/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.k;
import com.tencent.liteav.renderer.TXCFocusIndicatorView;
import com.tencent.liteav.renderer.TXCGLSurfaceView;
import com.tencent.rtmp.ui.TXDashBoard;

public class TXCloudVideoView
extends FrameLayout
implements View.OnTouchListener {
    private static final String TAG = "TXCloudVideoView";
    protected TXDashBoard mDashBoard;
    private int mCaptureWidth = 0;
    private int mCaptureHeight = 0;
    private float mLeft = 0.0f;
    private float mRight = 0.0f;
    private float mTop = 0.0f;
    private float mBottom = 0.0f;
    protected TextureView mVideoView;
    protected TXCGLSurfaceView mGLSurfaceView;
    protected TXCFocusIndicatorView mFocusIndicatorView;
    protected SurfaceView mSurfaceView;
    protected Object mGLContext;
    private int mFocusAreaSize = 0;
    private static final int FOCUS_AREA_SIZE_DP = 70;
    private String mUserId = "";
    private boolean mFocus = false;
    private boolean mZoom = false;
    private k mCapture;
    private int mCurrentScale = 1;
    private ScaleGestureDetector mScaleGestureDetector = null;
    private ScaleGestureDetector.OnScaleGestureListener mScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            int n2;
            int n3 = n2 = TXCloudVideoView.this.mCapture != null ? TXCloudVideoView.this.mCapture.e() : 0;
            if (n2 > 0) {
                int n4;
                float f2 = detector.getScaleFactor();
                if (f2 > 1.0f) {
                    f2 = 1.0f + 0.2f / (float)n2 * (float)(n2 - TXCloudVideoView.this.mCurrentScale);
                    if (f2 <= 1.1f) {
                        f2 = 1.1f;
                    }
                } else if (f2 < 1.0f && (f2 = 1.0f - 0.2f / (float)n2 * (float)TXCloudVideoView.this.mCurrentScale) >= 0.9f) {
                    f2 = 0.9f;
                }
                if ((n4 = Math.round((float)TXCloudVideoView.this.mCurrentScale * f2)) == TXCloudVideoView.this.mCurrentScale) {
                    if (f2 > 1.0f) {
                        ++n4;
                    } else if (f2 < 1.0f) {
                        --n4;
                    }
                }
                if (n4 >= n2) {
                    n4 = n2;
                }
                if (n4 <= 1) {
                    n4 = 1;
                }
                if (f2 > 1.0f) {
                    if (n4 < TXCloudVideoView.this.mCurrentScale) {
                        n4 = TXCloudVideoView.this.mCurrentScale;
                    }
                } else if (f2 < 1.0f && n4 > TXCloudVideoView.this.mCurrentScale) {
                    n4 = TXCloudVideoView.this.mCurrentScale;
                }
                TXCloudVideoView.this.mCurrentScale = n4;
                if (TXCloudVideoView.this.mCapture != null) {
                    TXCloudVideoView.this.mCapture.a(TXCloudVideoView.this.mCurrentScale);
                }
            }
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    };
    private a mTouchFocusRunnable = new a();

    public TXCloudVideoView(Context context) {
        this(context, null);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mDashBoard = new TXDashBoard(context);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this.mScaleGestureListener);
    }

    public TXCloudVideoView(SurfaceView view) {
        this(view.getContext(), null);
        this.mSurfaceView = view;
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void setOpenGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getOpenGLContext() {
        return this.mGLContext;
    }

    public void addVideoView(TXCGLSurfaceView view) {
        if (this.mGLSurfaceView != null) {
            this.removeView((View)this.mGLSurfaceView);
        }
        this.mGLSurfaceView = view;
        this.addView((View)this.mGLSurfaceView);
        this.resetLogView();
    }

    public void addVideoView(TextureView view) {
        if (this.mVideoView != null) {
            this.removeView((View)this.mVideoView);
        }
        this.mVideoView = view;
        this.addView((View)this.mVideoView);
        this.resetLogView();
    }

    public void removeVideoView() {
        if (this.mVideoView != null) {
            try {
                this.removeView((View)this.mVideoView);
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "remove mVideoView Exception: " + exception.getMessage());
            }
            this.mVideoView = null;
        }
        if (this.mGLSurfaceView != null) {
            try {
                this.removeView((View)this.mGLSurfaceView);
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "remove mGLSurfaceView Exception: " + exception.getMessage());
            }
            this.mGLSurfaceView = null;
        }
        this.mSurfaceView = null;
    }

    public void removeFocusIndicatorView() {
        if (this.mFocusIndicatorView != null) {
            this.removeView(this.mFocusIndicatorView);
            this.mFocusIndicatorView = null;
        }
    }

    public void onDestroy() {
    }

    public TextureView getVideoView() {
        return this.mVideoView;
    }

    public TXCGLSurfaceView getGLSurfaceView() {
        return this.mGLSurfaceView;
    }

    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    public void setRenderMode(int mode) {
    }

    public void setRenderRotation(int rotation) {
    }

    public TextureView getHWVideoView() {
        return this.mVideoView;
    }

    public void clearLastFrame(boolean clear) {
        if (clear) {
            this.setVisibility(8);
        }
    }

    public void onTouchFocus(int x2, int y2) {
        if (this.mGLSurfaceView == null) {
            return;
        }
        if (x2 < 0 || y2 < 0) {
            if (this.mFocusIndicatorView != null) {
                this.mFocusIndicatorView.setVisibility(8);
            }
            return;
        }
        if (this.mFocusIndicatorView == null) {
            this.mFocusIndicatorView = new TXCFocusIndicatorView(this.getContext());
            this.mFocusIndicatorView.setVisibility(0);
            this.addView(this.mFocusIndicatorView);
        } else {
            int n2 = this.indexOfChild(this.mFocusIndicatorView);
            if (n2 != this.getChildCount() - 1) {
                this.removeView(this.mFocusIndicatorView);
                this.addView(this.mFocusIndicatorView);
            }
        }
        Rect rect = this.getTouchRect(x2, y2, this.mGLSurfaceView.getWidth(), this.mGLSurfaceView.getHeight(), 1.0f);
        this.mFocusIndicatorView.show(rect.left, rect.top, rect.right - rect.left);
    }

    private Rect getTouchRect(int x2, int y2, int width, int height, float coefficient) {
        if (this.mFocusAreaSize == 0 && this.mGLSurfaceView != null) {
            this.mFocusAreaSize = (int)(70.0f * this.mGLSurfaceView.getResources().getDisplayMetrics().density + 0.5f);
        }
        int n2 = Float.valueOf((float)this.mFocusAreaSize * coefficient).intValue();
        int n3 = this.clamp(x2 - n2 / 2, 0, width - n2);
        int n4 = this.clamp(y2 - n2 / 2, 0, height - n2);
        return new Rect(n3, n4, n3 + n2, n4 + n2);
    }

    private int clamp(int x2, int min, int max) {
        if (x2 > max) {
            return max;
        }
        if (x2 < min) {
            return min;
        }
        return x2;
    }

    public void setMirror(boolean mirror) {
    }

    public void disableLog(boolean enable) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(enable);
        }
    }

    public void showLog(boolean enable) {
        if (this.mDashBoard != null) {
            this.mDashBoard.setShowLevel(enable ? 2 : 0);
        }
    }

    public void clearLog() {
        if (this.mDashBoard != null) {
            this.mDashBoard.a();
        }
    }

    public void setLogText(Bundle status, Bundle event, int eventId) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(status, event, eventId);
        }
    }

    protected void resetLogView() {
        if (this.mDashBoard != null) {
            this.removeView((View)this.mDashBoard);
            this.addView((View)this.mDashBoard);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updateDbMargin();
        if (this.mDashBoard != null) {
            this.mDashBoard.setStatusTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 30.0));
            this.mDashBoard.setEventTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 25.0));
        }
        if (0 != this.mCaptureWidth && 0 != this.mCaptureHeight) {
            this.updateVideoViewSize(this.mCaptureWidth, this.mCaptureHeight);
        }
    }

    public void updateVideoViewSize(int captureWidth, int captureHeight) {
        FrameLayout.LayoutParams layoutParams = null;
        TXCGLSurfaceView tXCGLSurfaceView = null;
        if (null != this.mGLSurfaceView) {
            tXCGLSurfaceView = this.mGLSurfaceView;
        } else if (null != this.mVideoView) {
            tXCGLSurfaceView = this.mVideoView;
        } else {
            return;
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (0 == captureHeight || 0 == n3) {
            return;
        }
        this.mCaptureWidth = captureWidth;
        this.mCaptureHeight = captureHeight;
        float f2 = (float)captureWidth * 1.0f / (float)captureHeight;
        float f3 = (float)n2 * 1.0f / (float)n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int n7 = n3;
        if (f2 > f3) {
            n7 = (int)((float)n6 / f2);
            n5 = (this.getHeight() - n7) / 2;
        } else {
            n6 = (int)((float)n7 * f2);
            n4 = (this.getWidth() - n6) / 2;
        }
        ViewGroup.LayoutParams layoutParams2 = tXCGLSurfaceView.getLayoutParams();
        if (layoutParams2 != null) {
            layoutParams = (FrameLayout.LayoutParams)layoutParams2;
            if (layoutParams.width == n6 && layoutParams.height == n7) {
                return;
            }
            layoutParams.width = n6;
            layoutParams.height = n7;
        } else {
            layoutParams = new FrameLayout.LayoutParams(n6, n7);
        }
        layoutParams.leftMargin = n4;
        layoutParams.topMargin = n5;
        tXCGLSurfaceView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setDashBoardStatusInfo(CharSequence info) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(info);
        }
    }

    public void appendEventInfo(String message) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(message);
        }
    }

    public void showVideoDebugLog(int showType) {
        if (this.mDashBoard != null) {
            this.mDashBoard.setShowLevel(showType);
        }
    }

    public void setLogMargin(float leftMarginInDp, float rightMarginInDp, float topMarginInDp, float bottomMarginInDp) {
        this.mLeft = leftMarginInDp;
        this.mRight = rightMarginInDp;
        this.mTop = topMarginInDp;
        this.mBottom = bottomMarginInDp;
        if (this.mDashBoard != null) {
            this.mDashBoard.a((int)this.mLeft, (int)this.mTop, (int)this.mRight, (int)this.mBottom);
        }
    }

    public void setLogMarginRatio(final float leftMarginInDp, final float rightMarginInDp, final float topMarginInDp, final float bottomMarginInDp) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                TXCloudVideoView.this.mLeft = (float)TXCloudVideoView.this.getWidth() * leftMarginInDp;
                TXCloudVideoView.this.mRight = (float)TXCloudVideoView.this.getWidth() * rightMarginInDp;
                TXCloudVideoView.this.mTop = (float)TXCloudVideoView.this.getHeight() * topMarginInDp;
                TXCloudVideoView.this.mBottom = (float)TXCloudVideoView.this.getHeight() * bottomMarginInDp;
                if (TXCloudVideoView.this.mDashBoard != null) {
                    TXCloudVideoView.this.mDashBoard.a((int)TXCloudVideoView.this.mLeft, (int)TXCloudVideoView.this.mTop, (int)TXCloudVideoView.this.mRight, (int)TXCloudVideoView.this.mBottom);
                }
            }
        }, 100L);
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public static int px2dip(Context context, float pxValue) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / f2 + 0.5f);
    }

    private void updateDbMargin() {
        if (this.mDashBoard != null) {
            this.mDashBoard.a((int)this.mLeft, (int)this.mTop, (int)this.mRight, (int)this.mBottom);
        }
    }

    public void start(boolean focus, boolean zoom, k capture) {
        this.mFocus = focus;
        this.mZoom = zoom;
        if (this.mFocus || this.mZoom) {
            this.setOnTouchListener(this);
            this.mCapture = capture;
        }
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.setVisibility(0);
        }
    }

    public void stop(boolean isNeedClearLastImg) {
        if (this.mFocus || this.mZoom) {
            this.setOnTouchListener(null);
        }
        this.mCapture = null;
        if (isNeedClearLastImg && this.mGLSurfaceView != null) {
            this.mGLSurfaceView.setVisibility(8);
        }
    }

    public boolean onTouch(View v2, MotionEvent event) {
        if (event.getPointerCount() == 1 && event.getAction() == 0) {
            this.mTouchFocusRunnable.a(v2);
            this.mTouchFocusRunnable.a(event);
            this.postDelayed(this.mTouchFocusRunnable, 100L);
        } else if (event.getPointerCount() > 1 && event.getAction() == 2) {
            this.removeCallbacks(this.mTouchFocusRunnable);
            this.onTouchFocus(-1, -1);
            if (this.mScaleGestureDetector != null && this.mZoom) {
                this.mScaleGestureDetector.onTouchEvent(event);
            }
        }
        if (this.mZoom && event.getAction() == 0) {
            this.performClick();
        }
        return this.mZoom;
    }

    private class a
    implements Runnable {
        private View b;
        private MotionEvent c;

        private a() {
        }

        public void a(View view) {
            this.b = view;
        }

        public void a(MotionEvent motionEvent) {
            this.c = motionEvent;
        }

        @Override
        public void run() {
            if (TXCloudVideoView.this.mCapture != null && TXCloudVideoView.this.mFocus) {
                TXCloudVideoView.this.mCapture.a(this.c.getX() / (float)this.b.getWidth(), this.c.getY() / (float)this.b.getHeight());
            }
            if (TXCloudVideoView.this.mFocus) {
                TXCloudVideoView.this.onTouchFocus((int)this.c.getX(), (int)this.c.getY());
            }
        }
    }
}

