/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl.Play;

import android.media.AudioTrack;
import android.os.Process;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCBuild;
import java.nio.ByteBuffer;

public class TXCAudioPlayout {
    private static final String TAG = "TXCAudioPlayout";
    private AudioTrack mAudioTrack;
    private byte[] mPlayBuffer;

    public boolean startPlayout(int samplerate, int channelCount, int frameSize, int streamType) {
        int[] nArray = new int[]{streamType, 0, 3, 1};
        int n2 = channelCount == 1 ? 4 : 12;
        int n3 = AudioTrack.getMinBufferSize((int)samplerate, (int)n2, (int)2);
        if (n3 <= 0) {
            TXCLog.e(TAG, "AudioTrack.getMinBufferSize returns invalid value: " + n3);
            return false;
        }
        for (int i2 = 0; i2 < nArray.length && this.mAudioTrack == null; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 1; i3 <= 2 && this.mAudioTrack == null; ++i3) {
                int n5 = n3 * i3;
                if (n5 < frameSize * 4 && i3 < 2) continue;
                this.mAudioTrack = TXCAudioPlayout.createStartedAudioTrack(samplerate, n2, n5, n4);
            }
        }
        Thread.currentThread().setName("tx_audio_playout");
        Process.setThreadPriority((int)-19);
        return this.mAudioTrack != null;
    }

    private static AudioTrack createStartedAudioTrack(int samplerate, int channelConfig, int bufferSize, int streamType) {
        AudioTrack audioTrack = null;
        try {
            audioTrack = new AudioTrack(streamType, samplerate, channelConfig, 2, bufferSize, 1);
            if (audioTrack.getState() != 1) {
                throw new RuntimeException("AudioTrack is not initialized.");
            }
            audioTrack.play();
            TXCLog.i(TAG, "create AudioTrack success. samplerate: %d, channelConfig: %d, bufferSize: %d, streamType: %s", samplerate, channelConfig, bufferSize, TXCAudioPlayout.streamTypeToText(streamType));
        }
        catch (Exception exception) {
            TXCLog.w(TAG, "create AudioTrack failed. samplerate: %d, channelConfig: %d, bufferSize: %d, streamType: %s", samplerate, channelConfig, bufferSize, TXCAudioPlayout.streamTypeToText(streamType));
            TXCAudioPlayout.tearDownAudioTrack(audioTrack);
            audioTrack = null;
        }
        return audioTrack;
    }

    private static void tearDownAudioTrack(AudioTrack audioTrack) {
        if (audioTrack == null) {
            return;
        }
        try {
            if (audioTrack.getPlayState() == 3) {
                audioTrack.stop();
                audioTrack.flush();
            }
            audioTrack.release();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "stop AudioTrack failed.", exception);
        }
    }

    private static String streamTypeToText(int streamType) {
        switch (streamType) {
            case 0: {
                return "STREAM_VOICE_CALL";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
        }
        return "UNSUPPORT " + streamType;
    }

    public int write(ByteBuffer buffer, int offset, int size) {
        int n2;
        if (this.mAudioTrack == null) {
            return -1;
        }
        buffer.position(offset);
        if (TXCBuild.VersionInt() >= 21) {
            n2 = this.mAudioTrack.write(buffer, size, 0);
        } else {
            if (this.mPlayBuffer == null || this.mPlayBuffer.length < size) {
                this.mPlayBuffer = new byte[size];
            }
            buffer.get(this.mPlayBuffer, 0, size);
            n2 = this.mAudioTrack.write(this.mPlayBuffer, 0, size);
        }
        if (n2 <= 0) {
            TXCLog.e(TAG, "write audio data to AudioTrack failed. " + n2);
            return -1;
        }
        return n2;
    }

    public void stopPlayout() {
        TXCAudioPlayout.tearDownAudioTrack(this.mAudioTrack);
        this.mAudioTrack = null;
    }
}

