/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.opengl.EGLContext;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.provider.Settings;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Pair;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.tencent.liteav.AudioServerConfig;
import com.tencent.liteav.TXCRenderAndDec;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.TXCAudioEncoderConfig;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.audio.TXCLiveBGMPlayer;
import com.tencent.liteav.audio.TXCSoundEffectPlayer;
import com.tencent.liteav.audio.impl.TXCAudioEngineJNI;
import com.tencent.liteav.basic.enums.a;
import com.tencent.liteav.basic.enums.b;
import com.tencent.liteav.basic.enums.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.Monitor;
import com.tencent.liteav.basic.module.TXCEventRecorderProxy;
import com.tencent.liteav.basic.module.TXCKeyPointReportProxy;
import com.tencent.liteav.basic.module.TXCStatus;
import com.tencent.liteav.basic.opengl.TXCOpenGlUtils;
import com.tencent.liteav.basic.opengl.e;
import com.tencent.liteav.basic.opengl.p;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.structs.TXSVideoFrame;
import com.tencent.liteav.basic.util.TXCBuild;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.basic.util.h;
import com.tencent.liteav.basic.util.i;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.d;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.device.TXDeviceManagerImpl;
import com.tencent.liteav.g;
import com.tencent.liteav.h;
import com.tencent.liteav.o;
import com.tencent.liteav.renderer.e;
import com.tencent.liteav.screencapture.a;
import com.tencent.liteav.trtc.impl.TRTCCustomTextureUtil;
import com.tencent.liteav.trtc.impl.TRTCEncodeTypeDecision;
import com.tencent.liteav.trtc.impl.TRTCRoomInfo;
import com.tencent.liteav.trtc.impl.TRTCTranscodingConfigInner;
import com.tencent.liteav.trtc.impl.TRTCVideoPreprocessListenerAdapter;
import com.tencent.liteav.trtc.impl.TRTCVideoServerConfig;
import com.tencent.liteav.videoencoder.TXCSWVideoEncoder;
import com.tencent.liteav.videoencoder.c;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.tencent.trtc.TRTCStatistics;
import com.tencent.trtc.TRTCSubCloud;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TRTCCloudImpl
extends TRTCCloud
implements TXCRenderAndDec.b,
com.tencent.liteav.audio.b,
com.tencent.liteav.audio.d,
com.tencent.liteav.audio.e,
com.tencent.liteav.audio.f,
com.tencent.liteav.audio.g,
com.tencent.liteav.audio.h,
com.tencent.liteav.basic.c.b,
d.a,
o,
a.a {
    private static final String TAG = "TRTCCloudImpl";
    private static final int STATE_INTERVAL = 2000;
    protected static final int ROOM_STATE_OUT = 0;
    protected static final int ROOM_STATE_ENTRING = 1;
    private static final int ROOM_STATE_IN = 2;
    private static final int MIN_VOLUME_EVALUATION_INTERVAL_MS = 100;
    private static final int CURRENT_ENCODE_TYPE_H265 = 1;
    private static final int CURRENT_ENCODE_TYPE_H264 = 0;
    private static final String KEY_CONFIG_FPS = "config_fps";
    private static final String KEY_CONFIG_GOP = "config_gop";
    private static final String KEY_CONFIG_ADJUST_RESOLUTION = "config_adjust_resolution";
    private static final int DEFAULT_GOP_FOR_SCREEN_CAPTURE = 3;
    private static final int DEFAULT_FPS_FOR_SCREEN_CAPTURE = 10;
    private static final int RECV_MODE_UNKNOWN = 0;
    private static final int RECV_MODE_AUTO_AUDIO_VIDEO = 1;
    private static final int RECV_MODE_AUTO_AUDIO_ONLY = 2;
    private static final int RECV_MODE_AUTO_VIDEO_ONLY = 3;
    private static final int RECV_MODE_MANUAL = 4;
    private static final int START_LOCAL_RECORDING_FAILED = -1;
    private static final int LOCAL_AUDIO_MUTE_MODE_DEFAULT = 0;
    private static final int LOCAL_AUDIO_MUTE_MODE_EOS = 1;
    private static final int LOCAL_AUDIO_MUTE_MODE_NO_PACKET = 2;
    private static final int DEFAULT_VOLUME_LEVEL = 100;
    private static final String SERVER_AUDIOMIX_FAKE_USERID = "trtc_server_audio_mix";
    private static final long SERVER_AUDIOMIX_FAKE_TINYID = 0x7EEEEEEE22222222L;
    final TXAudioEffectManager.TXVoiceReverbType[] reverbTypes = new TXAudioEffectManager.TXVoiceReverbType[]{TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_0, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_1, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_2, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_3, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_4, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_5, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_6, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_7, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_8, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_9, TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_10};
    final TXAudioEffectManager.TXVoiceChangerType[] voiceChangerTypes = new TXAudioEffectManager.TXVoiceChangerType[]{TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_0, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_1, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_2, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_3, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_4, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_5, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_6, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_7, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_8, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_9, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_10, TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_11};
    final ArrayList<String> reverbParamKeyNames = new ArrayList<String>(Arrays.asList("dampingFreq", "density", "bandwidthFreq", "decay", "preDelay", "roomSize", "gain", "mix", "earlyMix"));
    protected long mNativeRtcContext;
    protected Object mNativeLock = new Object();
    private boolean mIsDestroyed = false;
    private VideoSourceType mMainStreamVideoSourceType;
    private VideoSourceType mSubStreamVideoSourceType;
    protected int mRoomState;
    protected boolean mIsExitOldRoom;
    private boolean mIsAudioCapturing;
    private boolean mIsVideoCapturing;
    protected TRTCRoomInfo mRoomInfo;
    protected TRTCCloudListener mTRTCListener;
    protected TRTCCloudListener.TRTCAudioFrameListener mAudioFrameListener = null;
    protected g mConfig;
    protected d mCaptureAndEnc;
    private final Object mCustomCaptureLock = new Object();
    protected g mSubStreamConfig;
    protected d mSubStreamCaptureAndEnc;
    private TRTCCustomTextureUtil mCustomSubStreamVideoUtil = null;
    private int mPublishAudioTunnelId = -1;
    private int mPlayoutAudioTunnelId = -1;
    protected Context mContext;
    private com.tencent.liteav.basic.util.g mMainHandler;
    private Handler mListenerHandler;
    protected com.tencent.liteav.basic.util.g mSDKHandler;
    private AtomicBoolean mIsSDKThreadAlive;
    private TXDeviceManagerImpl mDeviceManager;
    private long mLastSendMsgTimeMs;
    private int mSendMsgCount;
    private int mSendMsgSize;
    protected long mLastStateTimeMs;
    protected int mPriorStreamType = 2;
    private boolean mEnableSmallStream = false;
    private int mVideoRenderMirror = 0;
    private boolean mCustomRemoteRender = false;
    private TRTCEncodeTypeDecision mH265Decision;
    protected HashMap<String, RenderListenerAdapter> mRenderListenerMap;
    protected int mAudioVolumeEvalInterval = 0;
    private final TRTCCloudDef.TRTCVideoEncParam mSmallEncParam = new TRTCCloudDef.TRTCVideoEncParam();
    private DisplayOrientationDetector mOrientationEventListener;
    private int mSensorMode;
    protected int mAppScene;
    private int mQosPreference;
    private int mQosMode = 1;
    protected boolean mEnableEosMode = false;
    private int mCodecType = 2;
    private boolean mEnableSoftAEC = true;
    private boolean mEnableSoftANS = false;
    private boolean mEnableSoftAGC = false;
    private int mSoftAECLevel = 100;
    private int mSoftANSLevel = 100;
    private int mSoftAGCLevel = 100;
    private int mAudioCaptureVolume = 100;
    private int mAudioPlayoutVolume = 100;
    private boolean mEnableServerAudioMix;
    private TRTCCustomTextureUtil mCustomVideoUtil = null;
    private boolean mEnableCustomAudioCapture = false;
    private boolean mEnableCustomAudioRendering = false;
    private boolean mEnableCustomVideoCapture = false;
    protected int mCurrentRole = 20;
    protected int mTargetRole = 20;
    private final TRTCVideoPreprocessListenerAdapter mVideoPreprocessListenerAdapter = new TRTCVideoPreprocessListenerAdapter();
    protected int mPerformanceMode = 0;
    protected int mRoomType = 0;
    private int mCurrentOrientation = -1;
    protected int mRecvMode;
    private static TRTCCloudImpl sInstance = null;
    private View mFloatingWindow = null;
    private boolean mOverrideFPSFromUser = false;
    private final Bundle mLatestParamsOfBigEncoder = new Bundle();
    private final Bundle mLatestParamsOfSmallEncoder = new Bundle();
    private final Bundle mLatestParamsOfSubEncoder = new Bundle();
    protected int mFramework = 1;
    protected int mComponent = 0;
    private Set<Integer> mStreamTypes;
    private TRTCVideoServerConfig mVideoServerConfig;
    private TRTCCloud.BGMNotify mBGMNotify;
    private long mLastLogSEIMsgTs;
    private long mRecvSEIMsgCountInPeriod;
    private long mLastLogCustomCmdMsgTs;
    private long mRecvCustomCmdMsgCountInPeriod;
    protected int mCheckDuplicateEnterRoom = 0;
    private boolean mEnableLowLatencyMode;
    private int mCustomCaptureGLSyncMode = 0;
    protected int mQoSStrategy = 0;
    private final SurfaceHolder.Callback mLocalPreviewSurfaceViewCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder holder) {
            if (this.isSameHolderCurrentlyInUse(holder) && holder.getSurface().isValid()) {
                TRTCCloudImpl.this.apiLog("local view surfaceCreated, surface: %s, holder: %s", holder.getSurface(), holder);
                TRTCCloudImpl.this.mCaptureAndEnc.a(holder.getSurface());
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (this.isSameHolderCurrentlyInUse(holder)) {
                TRTCCloudImpl.this.apiLog("local view surfaceChanged, size: %dx%d, surface: %s, holder: %s", width, height, holder.getSurface(), holder);
                TRTCCloudImpl.this.mCaptureAndEnc.a(width, height);
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            if (this.isSameHolderCurrentlyInUse(holder)) {
                TRTCCloudImpl.this.apiLog("local view surfaceDestroyed, surface: %s, holder: %s", holder.getSurface(), holder);
                TRTCCloudImpl.this.mCaptureAndEnc.a((Surface)null);
            }
        }

        private boolean isSameHolderCurrentlyInUse(SurfaceHolder holder) {
            if (TRTCCloudImpl.this.mRoomInfo == null || TRTCCloudImpl.this.mRoomInfo.localView == null) {
                return false;
            }
            SurfaceView surfaceView = TRTCCloudImpl.this.mRoomInfo.localView.getSurfaceView();
            return surfaceView != null && surfaceView.getHolder() == holder;
        }
    };
    private boolean mKeepAVCaptureWhenEnterRoomFailed = false;
    private com.tencent.liteav.basic.c.a mCallback = new com.tencent.liteav.basic.c.a(){

        @Override
        public void onEvent(String id, int code, String msg, String params) {
            this.onEventInternal(id, code, msg, params);
            String string = "onEvent => msg:" + msg + " params:" + params + " code:" + code + " id:" + id;
            Monitor.a(2, code, string, "", 0, 0);
            if (code == 2027) {
                TXCKeyPointReportProxy.b(30002, 0);
            }
        }

        void onEventInternal(String id, int code, String msg, String params) {
            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
            if (tRTCCloudListener != null) {
                switch (code) {
                    case 10046: 
                    case 10047: 
                    case 10050: 
                    case 10052: 
                    case 10054: {
                        code = 1204;
                        break;
                    }
                    case 10048: 
                    case 10049: 
                    case 10053: {
                        code = 1205;
                    }
                }
                Bundle bundle = new Bundle();
                bundle.putString("EVT_USERID", id);
                bundle.putInt("EVT_ID", code);
                bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                if (msg != null) {
                    bundle.putCharSequence("EVT_MSG", (CharSequence)(msg + (params != null ? params : "")));
                }
                TRTCCloudImpl.this.onNotifyEvent(code, bundle);
            }
        }

        @Override
        public void onWarning(String id, int code, String msg, String params) {
            this.onEventInternal(id, code, msg, params);
            String string = "onWarning => msg:" + msg + " params:" + params + " code:" + code + " id:" + id;
            Monitor.a(4, code, string, "", 0, 0);
        }

        @Override
        public void onError(String id, int code, String msg, String params) {
            Object object;
            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
            if (tRTCCloudListener != null) {
                object = new Bundle();
                object.putString("EVT_USERID", id);
                object.putInt("EVT_ID", code);
                object.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                if (msg != null) {
                    object.putCharSequence("EVT_MSG", (CharSequence)(msg + (params != null ? params : "")));
                }
                TRTCCloudImpl.this.onNotifyEvent(code, (Bundle)object);
            }
            object = "onError => msg:" + msg + " params:" + params + " code:" + code + " id:" + id;
            Monitor.a(3, code, (String)object, "", 0, 0);
            if (code == -1302 || code == -1317 || code == -1318 || code == -1319) {
                TXCKeyPointReportProxy.b(30002, code);
                if (code == -1317) {
                    TXCEventRecorderProxy.a("18446744073709551615", 2002, 4L, -1L, "", 0);
                }
            }
        }
    };
    private TXDeviceManagerImpl.TXDeviceManagerListener mDeviceManagerListener = new TXDeviceManagerImpl.TXDeviceManagerListener(){

        @Override
        public void onSwitchCamera(boolean isFrontCamera) {
            TRTCCloudImpl.this.mConfig.p = isFrontCamera;
            TRTCCloudImpl.this.updateOrientation();
        }

        @Override
        public void onSwitchAutoFocus(boolean enable) {
            TRTCCloudImpl.this.mConfig.N = !enable;
        }

        @Override
        public void onSwitchSystemVolumeType(TXDeviceManager.TXSystemVolumeType type) {
            switch (type) {
                case TXSystemVolumeTypeAuto: {
                    TRTCCloudImpl.this.mConfig.A = 0;
                    break;
                }
                case TXSystemVolumeTypeVOIP: {
                    TRTCCloudImpl.this.mConfig.A = 2;
                    break;
                }
                case TXSystemVolumeTypeMedia: {
                    TRTCCloudImpl.this.mConfig.A = 1;
                }
            }
        }

        @Override
        public void onCameraParamChange(g config) {
            TRTCCloudImpl.this.mConfig.c = config.c;
            TRTCCloudImpl.this.mConfig.d = config.d;
            if (TRTCCloudImpl.this.mPerformanceMode != 1) {
                TRTCCloudImpl.this.mConfig.X = config.X;
            }
            TRTCCloudImpl.this.mConfig.W = config.W;
            TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mConfig);
        }
    };
    protected ArrayList<WeakReference<TRTCCloudImpl>> mSubClouds = new ArrayList();
    protected HashMap<Integer, TRTCCloudImpl> mCurrentPublishClouds = new HashMap();
    private VolumeLevelNotifyTask mVolumeLevelNotifyTask = null;
    protected int mDebugType = 0;
    private StatusTask mStatusNotifyTask = null;
    private int mNetType = -1;
    private int mBackground = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTCCloud sharedInstance(Context context) {
        Class<TRTCCloudImpl> clazz = TRTCCloudImpl.class;
        synchronized (TRTCCloudImpl.class) {
            if (sInstance == null) {
                sInstance = new TRTCCloudImpl(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySharedInstance() {
        Class<TRTCCloudImpl> clazz = TRTCCloudImpl.class;
        synchronized (TRTCCloudImpl.class) {
            if (sInstance != null) {
                TXCLog.i(TAG, "trtc_api destroy instance self:" + sInstance.hashCode());
                sInstance.destroy();
                sInstance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected TRTCCloudImpl(Context context) {
        this.init(context, null);
        TXCCommonUtil.setAppContext(this.mContext);
        TXCLog.init();
        AudioServerConfig audioServerConfig = AudioServerConfig.loadFromSharedPreferences(context);
        TXCLog.i(TAG, "audio config from shared preference: %s", audioServerConfig);
        String string = TXCAudioEngine.buildTRAEConfig(context, audioServerConfig.enableOpenSL, audioServerConfig.isLowLatencySampleRateSupported, audioServerConfig.lowLatencySampleRateBlockTime);
        TXCAudioEngine.CreateInstanceWithoutInitDevice(this.mContext, string, audioServerConfig.isAudioDeviceDSPEnabled());
        TXCAudioEngine.getInstance().clean();
        TXCAudioEngine.getInstance().setAudioCaptureDataListener(this);
        TXCAudioEngine.getInstance().addEventCallback(new WeakReference<com.tencent.liteav.basic.c.a>(this.mCallback));
        TXCAudioEngine.getInstance().setServer3AConfig(audioServerConfig.aecLevel, audioServerConfig.ansLevel, audioServerConfig.agcLevel);
        TXCAudioEngine.getInstance().enableAutoRestartDevice(audioServerConfig.enableAutoRestartDevice);
        TXCAudioEngine.getInstance().setMaxSelectedPlayStreams(audioServerConfig.maxSelectedPlayStreams);
        TXCAudioEngine.getInstance().enableInbandFEC(audioServerConfig.enableInbandFEC != 0);
        TXCAudioEngine.getInstance().enableDeviceAbnormalDetection(audioServerConfig.enableDeviceAbnormalDetection != 0);
        TXCAudioEngineJNI.nativeSetAudioPlayoutTunnelEnabled(true);
        TXCAudioEngine.getInstance().setAudioQuality(audioServerConfig.audioSampleRate, audioServerConfig.audioChannel, audioServerConfig.audioBitrate, audioServerConfig.encodeMode, audioServerConfig.systemVolumeType, 5);
        this.mCaptureAndEnc = this.createCaptureAndEnc(2, this.mConfig);
        this.mCaptureAndEnc.f();
        this.mDeviceManager.setCaptureAndEnc(this.mCaptureAndEnc);
        this.mDeviceManager.setDeviceManagerListener(this.mDeviceManagerListener);
        TXCKeyPointReportProxy.a(this.mContext);
        this.apiLog("reset audio volume");
        this.setAudioCaptureVolume(100);
        this.setAudioPlayoutVolume(100);
        TXCSoundEffectPlayer.getInstance().setSoundEffectListener(this);
        this.mH265Decision = new TRTCEncodeTypeDecision(this);
    }

    protected TRTCCloudImpl(Context context, com.tencent.liteav.basic.util.g sdkHandler) {
        this.init(context, sdkHandler);
        this.mCurrentRole = 21;
        this.mTargetRole = 21;
        this.mH265Decision = new TRTCEncodeTypeDecision(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, com.tencent.liteav.basic.util.g sdkHandler) {
        Object object;
        this.mCurrentPublishClouds.put(2, this);
        this.mCurrentPublishClouds.put(3, this);
        this.mCurrentPublishClouds.put(7, this);
        this.mCurrentPublishClouds.put(1, this);
        this.mContext = context.getApplicationContext();
        this.mConfig = new g();
        this.mConfig.n = c.e;
        this.mConfig.aa = 90;
        this.mConfig.m = 1;
        this.mConfig.S = true;
        this.mConfig.k = 15;
        this.mConfig.N = false;
        this.mConfig.W = false;
        this.mConfig.X = false;
        this.mConfig.a = 368;
        this.mConfig.b = 640;
        this.mConfig.e = 750;
        this.mConfig.g = 0;
        this.mConfig.Z = false;
        this.mRoomInfo = new TRTCRoomInfo();
        this.mRoomInfo.bigEncSize.a = 368;
        this.mRoomInfo.bigEncSize.b = 640;
        this.mMainHandler = new com.tencent.liteav.basic.util.g(context.getMainLooper());
        this.mListenerHandler = new Handler(context.getMainLooper());
        this.mIsSDKThreadAlive = new AtomicBoolean(true);
        if (sdkHandler != null) {
            this.mSDKHandler = sdkHandler;
        } else {
            object = new HandlerThread("TRTCCloudApi");
            object.start();
            this.mSDKHandler = new com.tencent.liteav.basic.util.g(object.getLooper());
        }
        this.mDeviceManager = new TXDeviceManagerImpl(this.mSDKHandler);
        this.mStatusNotifyTask = new StatusTask(this);
        this.mLastSendMsgTimeMs = 0L;
        this.mSendMsgCount = 0;
        this.mSendMsgSize = 0;
        this.mSensorMode = 2;
        this.mAppScene = 0;
        this.mQosPreference = 2;
        this.mQosMode = 1;
        this.mOrientationEventListener = new DisplayOrientationDetector(this.mContext, this);
        this.mRenderListenerMap = new HashMap();
        this.mStreamTypes = new HashSet<Integer>();
        object = this.mNativeLock;
        synchronized (object) {
            int[] nArray = TXCCommonUtil.getSDKVersion();
            int n2 = nArray.length >= 1 ? nArray[0] : 0;
            int n3 = nArray.length >= 2 ? nArray[1] : 0;
            int n4 = nArray.length >= 3 ? nArray[2] : 0;
            this.mNativeRtcContext = this.nativeCreateContext(n2, n3, n4);
        }
        this.apiLog("trtc cloud create");
        this.mRoomState = 0;
        this.mMainStreamVideoSourceType = VideoSourceType.NONE;
        this.mSubStreamVideoSourceType = VideoSourceType.NONE;
        this.mIsAudioCapturing = false;
        this.mIsVideoCapturing = false;
        this.mCurrentRole = 20;
        this.mTargetRole = 20;
        this.mRecvMode = 1;
        this.mLatestParamsOfBigEncoder.putInt(KEY_CONFIG_GOP, this.mConfig.l);
        this.mLatestParamsOfSmallEncoder.putInt(KEY_CONFIG_GOP, this.mConfig.l);
        this.mSubStreamConfig = new g();
        this.mSubStreamConfig.W = false;
        this.mLatestParamsOfSubEncoder.putInt(KEY_CONFIG_GOP, this.mSubStreamConfig.l);
        this.mVideoServerConfig = TRTCVideoServerConfig.loadFromSharedPreferences(context);
    }

    public void destroy() {
        this.runOnSDKThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TRTCCloudImpl.this.mIsDestroyed) {
                    TRTCCloudImpl.this.apiLog("has been destroyed");
                    return;
                }
                TXCAudioEngineJNI.nativeSetAudioPlayoutTunnelEnabled(false);
                Object object = TRTCCloudImpl.this.mNativeLock;
                synchronized (object) {
                    if (TRTCCloudImpl.this.mNativeRtcContext != 0L) {
                        TRTCCloudImpl.this.apiLog("destroy context");
                        TRTCCloudImpl.this.nativeDestroyContext(TRTCCloudImpl.this.mNativeRtcContext);
                    }
                    TRTCCloudImpl.this.mNativeRtcContext = 0L;
                }
                TRTCCloudImpl.this.mTRTCListener = null;
                TRTCCloudImpl.this.mAudioFrameListener = null;
                TRTCCloudImpl.this.resetVolumeInternal();
                TXCSoundEffectPlayer.getInstance().setSoundEffectListener(null);
                TXCAudioEngine.getInstance().clean();
                object = TRTCCloudImpl.this.mCurrentPublishClouds;
                synchronized (object) {
                    TRTCCloudImpl.this.mCurrentPublishClouds.clear();
                }
                object = TRTCCloudImpl.this.mSubClouds.iterator();
                while (object.hasNext()) {
                    TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)((WeakReference)object.next()).get();
                    if (tRTCCloudImpl == null) continue;
                    tRTCCloudImpl.destroy();
                }
                TRTCCloudImpl.this.mSubClouds.clear();
                com.tencent.liteav.audio.a.a().a(TRTCCloudImpl.this.hashCode());
                TRTCCloudImpl.this.mIsSDKThreadAlive.set(false);
                try {
                    if (TRTCCloudImpl.this.mSDKHandler != null) {
                        TRTCCloudImpl.this.mSDKHandler.getLooper().quit();
                    }
                }
                catch (Exception exception) {
                    TXCLog.e(TRTCCloudImpl.TAG, "(" + TRTCCloudImpl.this.hashCode() + ") error occur when quit looper.", exception);
                }
                catch (Error error) {
                    TXCLog.e(TRTCCloudImpl.TAG, "(" + TRTCCloudImpl.this.hashCode() + ") error occur when quit looper.");
                }
                TXCAudioEngine.UninitInstance();
                TRTCCloudImpl.this.mIsDestroyed = true;
                TRTCCloudImpl.this.apiLog("destroy instance finish.");
            }
        });
    }

    private void resetVolumeInternal() {
        this.setAudioCaptureVolume(100);
        this.setAudioPlayoutVolume(100);
        TXAudioEffectManagerImpl.getInstance().setAllMusicVolume(100);
        TXAudioEffectManagerImpl.getCacheInstance().setAllMusicVolume(100);
        this.getAudioEffectManager().setAllMusicVolume(100);
        this.getAudioEffectManager().setVoiceEarMonitorVolume(100);
    }

    @Override
    public void setListener(final TRTCCloudListener listener) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setListener " + listener);
                TRTCCloudImpl.this.mTRTCListener = listener;
            }
        });
    }

    @Override
    public void setListenerHandler(Handler listenerHandler) {
        this.apiLog("setListenerHandler " + listenerHandler);
        this.mListenerHandler = listenerHandler == null ? new Handler(Looper.getMainLooper()) : listenerHandler;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                Iterator<WeakReference<TRTCCloudImpl>> iterator = TRTCCloudImpl.this.mSubClouds.iterator();
                while (iterator.hasNext()) {
                    TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)iterator.next().get();
                    if (tRTCCloudImpl != null) {
                        tRTCCloudImpl.setListenerHandler(TRTCCloudImpl.this.mListenerHandler);
                        continue;
                    }
                    iterator.remove();
                }
            }
        });
    }

    void extractBizInfo(JSONObject businessInfo, String key, StringBuilder value) {
        if (key.equals("strGroupId")) {
            value.append(businessInfo.optString("strGroupId").toString());
            businessInfo.remove("strGroupId");
            businessInfo.remove("Role");
        } else if (key.equals("Str_uc_params")) {
            try {
                JSONObject jSONObject = businessInfo.optJSONObject("Str_uc_params");
                if (jSONObject == null) {
                    TXCLog.i(TAG, "Str_uc_params parse error:" + businessInfo.toString());
                    return;
                }
                if (jSONObject.has("enable_server_audio_mix")) {
                    this.mEnableServerAudioMix = jSONObject.getInt("enable_server_audio_mix") == 1;
                    value.append(jSONObject.getInt("enable_server_audio_mix"));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.apiLog("extractBizInfo: key" + key + " value:" + value.toString());
    }

    boolean isServerAudioMixFakeUser(String userId, long tinyId) {
        return SERVER_AUDIOMIX_FAKE_USERID.equals(userId) && tinyId == 0x7EEEEEEE22222222L;
    }

    protected void identifyTRTCComponent() {
        if (this.mComponent > 0) {
            return;
        }
        int n2 = 1;
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            String string = "";
            for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
                string = stackTraceElementArray[i2].getClassName();
                if (string.contains("TRTCMeetingImpl") || string.contains("TUIRoomCore")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 5;
                    break;
                }
                if (string.contains("TRTCLiveRoomImpl")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 4;
                    break;
                }
                if (string.contains("TRTCVoiceRoomImpl")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 6;
                    break;
                }
                if (string.contains("TRTCChatSalonImpl")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 7;
                    break;
                }
                if (string.contains("TUIChatService") && string.contains("TRTCCalling")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 10;
                    break;
                }
                if (string.contains("TRTCCalling")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 3;
                    break;
                }
                if (string.contains("TRTCKaraokeRoomImpl")) {
                    TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                    n2 = 8;
                    break;
                }
                if (!string.contains("TRTCChorusRoomImpl")) continue;
                TXCLog.i(TAG, "identifyTRTCFrameworkType callName:" + string);
                n2 = 9;
                break;
            }
            this.mComponent = n2;
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "identifyTRTCFrameworkType catch exception:" + exception.getCause());
        }
    }

    protected void SetGlobalEnvBySDKAppID(int sdkAppId) {
        if (sdkAppId >= 1400000000) {
            TXCCommonUtil.setGlobalEnv("default", TXCCommonUtil.ENV_PRIORITY_SDKAPPID);
        } else {
            TXCCommonUtil.setGlobalEnv("GDPR", TXCCommonUtil.ENV_PRIORITY_SDKAPPID);
        }
    }

    @Override
    public void enterRoom(TRTCCloudDef.TRTCParams params, final int appScene) {
        String string;
        final long l2 = TXCTimeUtil.getTimeTick();
        if (params == null) {
            this.apiLog("enter room, param nil!");
            this.onEnterRoom(-3316, "enter room param null");
            return;
        }
        final TRTCCloudDef.TRTCParams tRTCParams = new TRTCCloudDef.TRTCParams(params);
        if (tRTCParams.sdkAppId == 0 || TextUtils.isEmpty((CharSequence)tRTCParams.userId) || TextUtils.isEmpty((CharSequence)tRTCParams.userSig)) {
            this.apiLog("enterRoom param invalid:" + tRTCParams);
            if (tRTCParams.sdkAppId == 0) {
                this.onEnterRoom(-3317, "enter room sdkAppId invalid.");
            }
            if (TextUtils.isEmpty((CharSequence)tRTCParams.userSig)) {
                this.onEnterRoom(-3320, "enter room userSig invalid.");
            }
            if (TextUtils.isEmpty((CharSequence)tRTCParams.userId)) {
                this.onEnterRoom(-3319, "enter room userId invalid.");
            }
            return;
        }
        this.SetGlobalEnvBySDKAppID(tRTCParams.sdkAppId);
        final long l3 = (long)tRTCParams.roomId & 0xFFFFFFFFL;
        String string2 = "";
        String string3 = tRTCParams.businessInfo;
        if (l3 == 0L || tRTCParams.roomId == -1 && !TextUtils.isEmpty((CharSequence)string3)) {
            if (l3 == 0L) {
                string2 = tRTCParams.strRoomId;
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                try {
                    string = new JSONObject(string3);
                    StringBuilder stringBuilder = new StringBuilder("");
                    this.extractBizInfo((JSONObject)string, "strGroupId", stringBuilder);
                    if (tRTCParams.roomId == -1) {
                        string2 = stringBuilder.toString();
                    }
                    string3 = "";
                    if (string.length() != 0) {
                        string3 = string.toString();
                    }
                }
                catch (Exception exception) {
                    this.apiLog("enter room, room id error, busInfo " + tRTCParams.businessInfo);
                    string2 = "";
                    string3 = "";
                }
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                this.onEnterRoom(-3318, "room id invalid.");
                return;
            }
        }
        string = string2;
        final int n2 = tRTCParams.role;
        final String string4 = string3;
        final long l4 = System.currentTimeMillis();
        final TRTCCloudImpl tRTCCloudImpl = this;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                int n22;
                Object object;
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    object = null;
                    try {
                        object = new JSONObject(string4);
                        StringBuilder stringBuilder = new StringBuilder("");
                        TRTCCloudImpl.this.extractBizInfo((JSONObject)object, "Str_uc_params", stringBuilder);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
                TRTCCloudImpl.this.mH265Decision.setEnableH265EncodeByServer(false);
                Monitor.a(tRTCParams.userId, tRTCParams.sdkAppId, TextUtils.isEmpty((CharSequence)string) ? l3 + "" : string);
                if (TRTCCloudImpl.this.mRoomState != 0) {
                    if (!TextUtils.isEmpty((CharSequence)string) && string.equalsIgnoreCase(TRTCCloudImpl.this.mRoomInfo.strRoomId) || TRTCCloudImpl.this.mRoomInfo.roomId == l3 && l3 != 0L && l3 != -1L) {
                        TRTCCloudImpl.this.apiLog(String.format("enter the same room[%d] again!!!", l3));
                        TRTCCloudImpl.this.mRoomInfo.enterTime = l4;
                        if (TRTCCloudImpl.this.mCheckDuplicateEnterRoom == 1) {
                            TRTCCloudImpl.this.onEnterRoom(-3340, "enter the same room.");
                        }
                        return;
                    }
                    if (TRTCCloudImpl.this.mRoomState == 1) {
                        TRTCCloudImpl.this.apiLog(String.format("enter another room[%d] when entering room[%d], return!!!", l3, TRTCCloudImpl.this.mRoomInfo.roomId));
                        return;
                    }
                    TRTCCloudImpl.this.apiLog(String.format("enter another room[%d] when in room[%d], exit the old room!!!", l3, TRTCCloudImpl.this.mRoomInfo.roomId));
                    TRTCCloudImpl.this.mIsExitOldRoom = true;
                    TRTCCloudImpl.this.exitRoom();
                }
                TXCKeyPointReportProxy.a(30001, l2);
                TRTCCloudImpl.this.apiLog("========================================================================================================");
                TRTCCloudImpl.this.apiLog("========================================================================================================");
                TRTCCloudImpl.this.apiLog(String.format("============= SDK Version:%s Device Name:%s System Version:%s CPU Name:%s =============", TXCCommonUtil.getSDKVersionStr(), TXCBuild.Model(), TXCBuild.Version(), i.f()));
                TRTCCloudImpl.this.apiLog("========================================================================================================");
                TRTCCloudImpl.this.apiLog("========================================================================================================");
                object = String.format("enterRoom roomId:%d(%s) userId:%s sdkAppId:%d scene:%d, bizinfo:%s", l3, string, tRTCParams.userId, tRTCParams.sdkAppId, appScene, string4);
                int n3 = appScene;
                String string9 = "VideoCall";
                int n4 = 2;
                switch (appScene) {
                    case 0: {
                        string9 = "VideoCall";
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        string9 = "Live";
                        n4 = 2;
                        break;
                    }
                    case 2: {
                        string9 = "AudioCall";
                        n3 = 0;
                        n4 = 1;
                        break;
                    }
                    case 3: {
                        string9 = "VoiceChatRoom";
                        n3 = 1;
                        n4 = 2;
                        break;
                    }
                    default: {
                        TXCLog.w(TRTCCloudImpl.TAG, "enter room scene:%u error! default to VideoCall! " + appScene + " self:" + TRTCCloudImpl.this.hashCode());
                        n3 = 0;
                    }
                }
                TXCAudioEngine.getInstance().setAudioQuality(n4, 1);
                TRTCCloudImpl.this.apiOnlineLog((String)object + String.format(" bussInfo:%s, appScene:%s, role:%s, streamid:%s", string4, string9, n2 == 20 ? "Anchor" : "Audience", tRTCParams.streamId));
                if (TRTCCloudImpl.this.mAudioFrameListener != null) {
                    TXCAudioEngine.setPlayoutDataListener(tRTCCloudImpl);
                }
                TXCEventRecorderProxy.a("18446744073709551615", 5001, l3, -1L, "", 0);
                TXCStatus.a("18446744073709551615", 10003, TXCBuild.Model());
                TRTCCloudImpl.this.mRoomState = 1;
                if (TRTCCloudImpl.this.mNativeRtcContext == 0L) {
                    int[] nArray = TXCCommonUtil.getSDKVersion();
                    n22 = nArray.length >= 1 ? nArray[0] : 0;
                    int n5 = nArray.length >= 2 ? nArray[1] : 0;
                    int n6 = nArray.length >= 3 ? nArray[2] : 0;
                    TRTCCloudImpl.this.mNativeRtcContext = TRTCCloudImpl.this.nativeCreateContext(n22, n5, n6);
                }
                TRTCCloudImpl.this.updateAppScene(n3);
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mConfig);
                boolean bl = TRTCCloudImpl.this.isRPSSupported();
                n22 = 1;
                if (appScene != 0 || TRTCCloudImpl.this.mCodecType != 2) {
                    bl = false;
                    n22 = 0;
                }
                TRTCCloudImpl.this.mCaptureAndEnc.h(bl);
                TRTCCloudImpl.this.setVideoQuality(TRTCCloudImpl.this.mQosMode, TRTCCloudImpl.this.mQosPreference);
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mEnableSmallStream, TRTCCloudImpl.this.mRoomInfo.smallEncSize.a, TRTCCloudImpl.this.mRoomInfo.smallEncSize.b, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoFps, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoBitrate, TRTCCloudImpl.this.mConfig.l);
                String string2 = TXCBuild.Version();
                String string3 = TXCBuild.Model();
                TRTCCloudImpl.this.nativeSetDataReportDeviceInfo(string3, string2, tRTCParams.sdkAppId);
                TXCKeyPointReportProxy.a a2 = new TXCKeyPointReportProxy.a();
                a2.d = appScene;
                a2.e = string3;
                a2.f = string2;
                a2.h = TRTCCloudImpl.this.mContext != null ? TRTCCloudImpl.this.mContext.getPackageName() : "";
                a2.b = tRTCParams.sdkAppId;
                a2.g = TXCCommonUtil.getSDKVersionStr();
                a2.c = TRTCCloudImpl.this.mFramework;
                a2.i = TRTCCloudImpl.this.mComponent;
                TXCKeyPointReportProxy.a(a2);
                TRTCCloudImpl.this.nativeSetPriorRemoteVideoStreamType(TRTCCloudImpl.this.mNativeRtcContext, TRTCCloudImpl.this.mPriorStreamType);
                byte[] byArray = TRTCCloudImpl.this.mRoomInfo.getToken(TRTCCloudImpl.this.mContext);
                TRTCCloudImpl.this.nativeInit(TRTCCloudImpl.this.mNativeRtcContext, tRTCParams.sdkAppId, tRTCParams.userId, tRTCParams.userSig, byArray);
                TRTCCloudImpl.this.makeStreamsEffectiveAfterNetworkInited();
                String string42 = tRTCParams.privateMapKey != null ? tRTCParams.privateMapKey : "";
                String string5 = string != null ? string : "";
                String string6 = string4 != null ? string4 : "";
                String string7 = tRTCParams.userDefineRecordId != null ? tRTCParams.userDefineRecordId : "";
                String string8 = tRTCParams.streamId != null ? tRTCParams.streamId : "";
                int n7 = 3;
                int n8 = h.a.a.a();
                if (TRTCCloudImpl.this.mAppScene == 1) {
                    n7 = TRTCEncodeTypeDecision.getEnterRoomCodecSupportValue();
                    TRTCCloudImpl.this.setStartVideoEncodeCodec();
                    n8 = TRTCCloudImpl.this.mH265Decision.getExpectVideoCodecType(TRTCCloudImpl.this.mAppScene);
                } else {
                    TRTCCloudImpl.this.mH265Decision.setEnableH265EncodeByPrivateAPI(false);
                }
                TRTCCloudImpl.this.nativeEnterRoom(TRTCCloudImpl.this.mNativeRtcContext, l3, string6, string42, string5, n2, 255, n22, appScene, TRTCCloudImpl.this.mPerformanceMode, TXCBuild.Model(), TXCBuild.Version(), i.f(), TRTCCloudImpl.this.mRecvMode, string7, string8, TRTCCloudImpl.this.mRoomType, n7, n8, TRTCCloudImpl.this.mEnableLowLatencyMode, TRTCCloudImpl.this.mQoSStrategy, TRTCCloudImpl.this.mFramework);
                TRTCCloudImpl.this.mCurrentRole = n2;
                TRTCCloudImpl.this.mTargetRole = n2;
                if (TRTCCloudImpl.this.mCurrentRole == 21 && (TRTCCloudImpl.this.mEnableCustomAudioCapture || TRTCCloudImpl.this.mIsAudioCapturing || TRTCCloudImpl.this.mMainStreamVideoSourceType != VideoSourceType.NONE)) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                            if (tRTCCloudListener == null) {
                                return;
                            }
                            tRTCCloudListener.onWarning(6001, "ignore upstream for audience", null);
                        }
                    });
                    TRTCCloudImpl.this.apiLog("ignore upstream for audience, when enter room!!");
                }
                TRTCCloudImpl.this.mCaptureAndEnc.f();
                TRTCCloudImpl.this.startCollectStatus();
                TRTCCloudImpl.this.mLastStateTimeMs = 0L;
                TRTCCloudImpl.this.mRoomInfo.init(l3, tRTCParams.userId);
                TRTCCloudImpl.this.mRoomInfo.strRoomId = string5;
                TRTCCloudImpl.this.mRoomInfo.sdkAppId = tRTCParams.sdkAppId;
                TRTCCloudImpl.this.mRoomInfo.userSig = tRTCParams.userSig;
                TRTCCloudImpl.this.mRoomInfo.privateMapKey = string42;
                TRTCCloudImpl.this.mRoomInfo.enterTime = l4;
                TXCEventRecorderProxy.a("18446744073709551615", 4007, TRTCCloudImpl.this.mConfig.a, TRTCCloudImpl.this.mConfig.b, "", 2);
                TXCEventRecorderProxy.a("18446744073709551615", 4008, TRTCCloudImpl.this.mConfig.k, -1L, "", 2);
                TXCEventRecorderProxy.a("18446744073709551615", 4009, TRTCCloudImpl.this.mConfig.e, -1L, "", 2);
            }
        });
        this.identifyTRTCComponent();
    }

    public void makeStreamsEffectiveAfterNetworkInited() {
        this.enableNetworkSmallStream(this.mEnableSmallStream);
        this.enableNetworkBlackStream(this.mCaptureAndEnc.j());
        for (Integer n2 : this.mStreamTypes) {
            this.addUpStreamType(n2);
        }
        this.flushBigVideoEncParamsIntoNetwork();
        this.flushSmallVideoEncParamsIntoNetwork();
        if (this.mSubStreamVideoSourceType != VideoSourceType.NONE) {
            this.flushSubVideoEncParamsIntoNetwork();
        }
        if (this.mRoomInfo.muteLocalVideo && this.mConfig.D == null) {
            this.muteUpstream(2, this.mRoomInfo.muteLocalVideo);
        }
        if (this.mRoomInfo.muteLocalSubVideo) {
            this.muteUpstream(7, this.mRoomInfo.muteLocalSubVideo);
        }
        if (this.mRoomInfo.muteLocalAudio) {
            this.muteUpstream(1, this.mRoomInfo.muteLocalAudio);
        }
    }

    public void flushBigVideoEncParamsIntoNetwork() {
        this.setVideoEncConfig(2, this.mRoomInfo.bigEncSize.a, this.mRoomInfo.bigEncSize.b, this.mConfig.k, this.mConfig.e, this.mConfig.s, this.mConfig.g, this.mConfig.j);
    }

    public void flushSmallVideoEncParamsIntoNetwork() {
        if (this.mEnableSmallStream) {
            this.setVideoEncConfig(3, this.mRoomInfo.smallEncSize.a, this.mRoomInfo.smallEncSize.b, this.mSmallEncParam.videoFps, this.mSmallEncParam.videoBitrate, this.mConfig.s, this.mSmallEncParam.minVideoBitrate, this.mConfig.j);
        } else {
            this.setVideoEncoderConfiguration(3, 0, 0, 0, 0, 1, this.mConfig.s, 0, false);
        }
    }

    public void flushSubVideoEncParamsIntoNetwork() {
        g g2 = this.mSubStreamConfig;
        this.setVideoEncConfig(7, g2.a, g2.b, g2.k, g2.e, g2.s, g2.g, g2.j);
    }

    @Override
    public void exitRoom() {
        this.runOnSDKThreadAndWaitDone(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mConfig.j = false;
                TRTCCloudImpl.this.exitRoomInternal(true, "call from api");
            }
        }, TimeUnit.SECONDS.toMillis(2L));
    }

    protected void clearRemoteMuteStates() {
        this.mRoomInfo.muteRemoteAudio = TRTCRoomInfo.TRTCRemoteMuteState.UNSET;
        this.mRoomInfo.muteRemoteVideo = TRTCRoomInfo.TRTCRemoteMuteState.UNSET;
        this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

            @Override
            public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                userInfo.mainRender.muteAudio = TRTCRoomInfo.TRTCRemoteMuteState.UNSET;
                userInfo.mainRender.muteVideo = TRTCRoomInfo.TRTCRemoteMuteState.UNSET;
            }
        });
    }

    protected void exitRoomInternal(boolean reqExit, String reason) {
        this.mH265Decision.setEnableH265EncodeByServer(false);
        this.mH265Decision.setEnableH265EncodeByPrivateAPI(false);
        String string = String.format(Locale.ENGLISH, "exitRoom %s, self: %d, reason: %s", this.mRoomInfo.getRoomId(), this.hashCode(), reason);
        this.apiOnlineLog(string);
        Monitor.a(1, string, "", 0);
        if (this.mRoomState == 0 && !this.mKeepAVCaptureWhenEnterRoomFailed) {
            this.clearRemoteMuteStates();
            Monitor.a();
            this.apiLog("exitRoom ignore when no in room.");
            return;
        }
        this.mRoomState = 0;
        this.mCaptureAndEnc.g();
        TXCSoundEffectPlayer.getInstance().stopAllEffect();
        this.stopCollectStatus();
        this.startVolumeLevelCal(false);
        this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

            @Override
            public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                TRTCCloudImpl.this.stopRemoteRender(userInfo);
                com.tencent.liteav.audio.a.a().a(String.valueOf(userInfo.tinyID), TRTCCloudImpl.this.hashCode());
                if (userInfo.mainRender.render != null) {
                    userInfo.mainRender.render.setVideoFrameListener(null, b.a);
                }
                if (userInfo.subRender.render != null) {
                    userInfo.subRender.render.setVideoFrameListener(null, b.a);
                }
            }
        });
        TXCAudioEngine.getInstance();
        TXCAudioEngine.setPlayoutDataListener(null);
        this.enableVideoStream(2, false);
        this.enableVideoStream(0, false);
        this.enableAudioStream(false);
        if (reqExit) {
            this.nativeExitRoom(this.mNativeRtcContext);
        }
        this.enableAudioEarMonitoring(false);
        this.stopBGM();
        TXAudioEffectManagerImpl.getInstance().stopAllMusics(false);
        TXAudioEffectManagerImpl.getAutoCacheHolder().stopAllMusics(false);
        TXAudioEffectManagerImpl.getCacheInstance().stopAllMusics(false);
        this.stopLocalAudioInternal();
        TXCKeyPointReportProxy.a(31004);
        this.stopLocalPreview();
        this.stopScreenCapture();
        TXCKeyPointReportProxy.b(31004, 0);
        this.mConfig.D = null;
        this.mConfig.F = 10;
        this.mRoomInfo.clear();
        this.mRenderListenerMap.clear();
        this.mEnableSmallStream = false;
        this.mEnableEosMode = false;
        this.mCodecType = 2;
        this.mRoomType = 0;
        this.mFramework = 1;
        this.mComponent = 0;
        this.mEnableServerAudioMix = false;
        this.mEnableSoftAEC = true;
        this.mEnableSoftANS = false;
        this.mEnableSoftAGC = false;
        this.mCaptureAndEnc.a(false);
        TXCAudioEngine.getInstance().muteLocalAudio(false);
        TXCAudioEngine.getInstance().clean();
        this.enableCustomAudioCapture(false);
        this.enableMixExternalAudioFrame(false, false);
        this.enableCustomVideoCapture(0, false);
        this.enableCustomVideoCapture(2, false);
        this.mCaptureAndEnc.a((o)null, 0);
        this.stopAudioRecording();
        this.stopLocalRecording();
        TXCSoundEffectPlayer.getInstance().clearCache();
        this.resetVolumeInternal();
        Monitor.a();
        TXCLog.i(TAG, "(%d) exitRoomInternal end", this.hashCode());
    }

    @Override
    public void ConnectOtherRoom(final String param) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("ConnectOtherRoom");
                TRTCCloudImpl.this.nativeConnectOtherRoom(TRTCCloudImpl.this.mNativeRtcContext, param);
            }
        });
    }

    @Override
    public void DisconnectOtherRoom() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.disconnectOtherRoom("");
            }
        });
    }

    private void disconnectOtherRoom(String param) {
        this.apiOnlineLog("DisconnectOtherRoom");
        this.nativeDisconnectOtherRoom(this.mNativeRtcContext, param);
    }

    @Override
    public void setDefaultStreamRecvMode(final boolean autoRecvAudio, final boolean autoRecvVideo) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mRecvMode = 0;
                TRTCCloudImpl.this.mRecvMode = autoRecvAudio && autoRecvVideo ? 1 : (autoRecvAudio ? 2 : (autoRecvVideo ? 3 : 4));
                String string = String.format("setDefaultStreamRecvMode audio:%b, video:%b", autoRecvAudio, autoRecvVideo) + " self:" + TRTCCloudImpl.this.hashCode();
                TRTCCloudImpl.this.apiOnlineLog(string);
            }
        });
    }

    @Override
    public void switchRole(final int role) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog(String.format("switchRole:%s", role == 20 ? "Anchor" : "Audience"));
                TRTCCloudImpl.this.mTargetRole = role;
                TRTCCloudImpl.this.nativeChangeRole(TRTCCloudImpl.this.mNativeRtcContext, role);
            }
        });
    }

    @Override
    public TRTCCloud createSubCloud() {
        final TRTCSubCloud tRTCSubCloud = new TRTCSubCloud(this.mContext, new WeakReference<TRTCCloudImpl>(this), this.mSDKHandler);
        tRTCSubCloud.setListenerHandler(this.mListenerHandler);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mSubClouds.add(new WeakReference<TRTCSubCloud>(tRTCSubCloud));
            }
        });
        return tRTCSubCloud;
    }

    @Override
    public void destroySubCloud(final TRTCCloud subCloud) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                Iterator<WeakReference<TRTCCloudImpl>> iterator = TRTCCloudImpl.this.mSubClouds.iterator();
                while (iterator.hasNext()) {
                    TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)iterator.next().get();
                    if (tRTCCloudImpl == null || tRTCCloudImpl != subCloud) continue;
                    tRTCCloudImpl.destroy();
                    iterator.remove();
                    break;
                }
            }
        });
    }

    private boolean isNumericRoom(int roomId) {
        return roomId != 0 && roomId != -1;
    }

    @Override
    public void switchRoom(TRTCCloudDef.TRTCSwitchRoomConfig inputConfig) {
        final TRTCCloudDef.TRTCSwitchRoomConfig tRTCSwitchRoomConfig = new TRTCCloudDef.TRTCSwitchRoomConfig();
        tRTCSwitchRoomConfig.roomId = inputConfig.roomId;
        tRTCSwitchRoomConfig.strRoomId = inputConfig.strRoomId;
        tRTCSwitchRoomConfig.userSig = inputConfig.userSig;
        tRTCSwitchRoomConfig.privateMapKey = inputConfig.privateMapKey;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                String string = String.format("switchRoom roomId:%d, strRoomId:%s", tRTCSwitchRoomConfig.roomId, tRTCSwitchRoomConfig.strRoomId) + " self:" + TRTCCloudImpl.this.hashCode();
                TRTCCloudImpl.this.apiOnlineLog(string);
                if (!TRTCCloudImpl.this.isNumericRoom(tRTCSwitchRoomConfig.roomId) && TextUtils.isEmpty((CharSequence)tRTCSwitchRoomConfig.strRoomId)) {
                    TRTCCloudImpl.this.apiLog("Switch room failed with invalid room id");
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            if (TRTCCloudImpl.this.mTRTCListener != null) {
                                TRTCCloudImpl.this.mTRTCListener.onSwitchRoom(-3301, "Invalid room id");
                            }
                        }
                    });
                    return;
                }
                if (TRTCCloudImpl.this.isNumericRoom(tRTCSwitchRoomConfig.roomId) && (long)tRTCSwitchRoomConfig.roomId == TRTCCloudImpl.this.mRoomInfo.roomId || !TRTCCloudImpl.this.isNumericRoom(tRTCSwitchRoomConfig.roomId) && tRTCSwitchRoomConfig.strRoomId == TRTCCloudImpl.this.mRoomInfo.strRoomId) {
                    TRTCCloudImpl.this.apiLog("Switch room to the same one");
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            if (TRTCCloudImpl.this.mTRTCListener != null) {
                                TRTCCloudImpl.this.mTRTCListener.onSwitchRoom(0, "Switch room to the same one");
                            }
                        }
                    });
                    return;
                }
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        TRTCCloudImpl.this.stopRemoteRender(userInfo);
                        com.tencent.liteav.audio.a.a().a(String.valueOf(userInfo.tinyID), TRTCCloudImpl.this.hashCode());
                        if (userInfo.mainRender.render != null) {
                            userInfo.mainRender.render.setVideoFrameListener(null, b.a);
                        }
                        if (userInfo.subRender.render != null) {
                            userInfo.subRender.render.setVideoFrameListener(null, b.a);
                        }
                    }
                });
                TRTCCloudImpl.this.mRoomInfo.clearUserList();
                int n2 = 0;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                if (TRTCCloudImpl.this.isNumericRoom(tRTCSwitchRoomConfig.roomId)) {
                    n2 = tRTCSwitchRoomConfig.roomId;
                    TRTCCloudImpl.this.mRoomInfo.roomId = tRTCSwitchRoomConfig.roomId;
                    TRTCCloudImpl.this.mRoomInfo.strRoomId = "";
                } else if (!TextUtils.isEmpty((CharSequence)tRTCSwitchRoomConfig.strRoomId)) {
                    TRTCCloudImpl.this.mRoomInfo.strRoomId = tRTCSwitchRoomConfig.strRoomId;
                    TRTCCloudImpl.this.mRoomInfo.roomId = -1L;
                    string2 = tRTCSwitchRoomConfig.strRoomId;
                }
                if (!TextUtils.isEmpty((CharSequence)tRTCSwitchRoomConfig.userSig)) {
                    TRTCCloudImpl.this.mRoomInfo.userSig = tRTCSwitchRoomConfig.userSig;
                    string3 = tRTCSwitchRoomConfig.userSig;
                }
                if (!TextUtils.isEmpty((CharSequence)tRTCSwitchRoomConfig.privateMapKey)) {
                    TRTCCloudImpl.this.mRoomInfo.privateMapKey = tRTCSwitchRoomConfig.privateMapKey;
                    string4 = tRTCSwitchRoomConfig.privateMapKey;
                }
                TRTCCloudImpl.this.nativeSwitchRoom(TRTCCloudImpl.this.mNativeRtcContext, n2, string2, string3, string4);
            }
        });
    }

    @Override
    public void startLocalPreview(final boolean frontCamera, final TXCloudVideoView view) {
        this.mDeviceManager.setFrontCamera(frontCamera);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TextureView textureView;
                boolean bl;
                boolean bl2 = bl = TRTCCloudImpl.this.mMainStreamVideoSourceType != VideoSourceType.NONE;
                if (bl) {
                    TRTCCloudImpl.this.apiLog("startLocalPreview just reset view when is started");
                }
                if (TRTCCloudImpl.this.mCurrentRole == 21) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                            if (tRTCCloudListener == null) {
                                return;
                            }
                            tRTCCloudListener.onWarning(6001, "ignore start local preview,for role audience", null);
                        }
                    });
                    TRTCCloudImpl.this.apiLog("ignore startLocalPreview for audience");
                }
                String string = "startLocalPreview front:" + frontCamera + ", view:" + (view != null ? Integer.valueOf(((Object)((Object)view)).hashCode()) : "") + " " + TRTCCloudImpl.this.hashCode();
                TRTCCloudImpl.this.apiOnlineLog(string);
                TXCEventRecorderProxy.a("18446744073709551615", 4006, 2L, -1L, "", 2);
                TRTCCloudImpl.this.setStartVideoEncodeCodec();
                TRTCCloudImpl.this.mRoomInfo.localView = view;
                TRTCCloudImpl.this.mConfig.p = frontCamera;
                if (TRTCCloudImpl.this.mPerformanceMode == 1) {
                    TRTCCloudImpl.this.mConfig.X = true;
                }
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mConfig);
                TXCKeyPointReportProxy.a(40046, 1, 2);
                TRTCCloudImpl.this.mIsVideoCapturing = true;
                TRTCCloudImpl.this.mOrientationEventListener.enable();
                TRTCCloudImpl.this.updateOrientation();
                TRTCCloudImpl.this.enableVideoStream(0, true);
                SurfaceView surfaceView = view != null ? view.getSurfaceView() : null;
                TextureView textureView2 = textureView = view != null ? view.getHWVideoView() : null;
                if (surfaceView != null || textureView != null) {
                    if (!bl && TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.NONE) {
                        TRTCCloudImpl.this.mMainStreamVideoSourceType = VideoSourceType.CAMERA;
                        TRTCCloudImpl.this.mCaptureAndEnc.a((TXCloudVideoView)null);
                    } else {
                        TRTCCloudImpl.this.apiLog("startLocalPreview with surface view when is started");
                    }
                } else if (!bl && TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.NONE) {
                    TRTCCloudImpl.this.mMainStreamVideoSourceType = VideoSourceType.CAMERA;
                    TRTCCloudImpl.this.mCaptureAndEnc.a(view);
                } else {
                    TRTCCloudImpl.this.apiLog("startLocalPreview with view view when is started");
                }
                TRTCCloudImpl.this.updateLocalViewInternal(view);
            }
        });
    }

    private void updateLocalViewInternal(final TXCloudVideoView newView) {
        final SurfaceView surfaceView = newView != null ? newView.getSurfaceView() : null;
        final TextureView textureView = newView != null ? newView.getHWVideoView() : null;
        final Surface[] surfaceArray = new Surface[1];
        final f f2 = new f();
        this.runOnMainThreadAndWaitDone(new Runnable(){

            @Override
            public void run() {
                Object object;
                if (surfaceView != null) {
                    object = surfaceView.getHolder();
                    object.removeCallback(TRTCCloudImpl.this.mLocalPreviewSurfaceViewCallback);
                    object.addCallback(TRTCCloudImpl.this.mLocalPreviewSurfaceViewCallback);
                    if (object.getSurface().isValid()) {
                        TRTCCloudImpl.this.apiLog("updateLocalViewInternal with valid surface %s, width: %d, height: %d", object.getSurface(), surfaceView.getWidth(), surfaceView.getHeight());
                        surfaceArray[0] = object.getSurface();
                        f2.a = surfaceView.getWidth();
                        f2.b = surfaceView.getHeight();
                    } else {
                        TRTCCloudImpl.this.apiLog("updateLocalViewInternal with surfaceView add callback");
                    }
                }
                if (textureView != null) {
                    object = new LocalPreviewTextureViewListener(textureView);
                    textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)object);
                    if (((LocalPreviewTextureViewListener)object).getSurface() != null) {
                        surfaceArray[0] = ((LocalPreviewTextureViewListener)object).getSurface();
                        f2.a = textureView.getWidth();
                        f2.b = textureView.getHeight();
                        TRTCCloudImpl.this.apiLog("updateLocalViewInternal with TextureView, SurfaceTexture: %s, width: %d, height: %d", textureView.getSurfaceTexture(), f2.a, f2.b);
                    } else {
                        TRTCCloudImpl.this.apiLog("updateLocalViewInternal with textureView add callback");
                    }
                }
                if (newView != null) {
                    newView.showVideoDebugLog(TRTCCloudImpl.this.mDebugType);
                    if (TRTCCloudImpl.this.mRoomInfo.debugMargin != null) {
                        newView.setLogMarginRatio(TRTCCloudImpl.this.mRoomInfo.debugMargin.leftMargin, TRTCCloudImpl.this.mRoomInfo.debugMargin.rightMargin, TRTCCloudImpl.this.mRoomInfo.debugMargin.topMargin, TRTCCloudImpl.this.mRoomInfo.debugMargin.bottomMargin);
                    }
                }
            }
        });
        if (surfaceArray[0] != null) {
            this.mCaptureAndEnc.a(surfaceArray[0]);
            this.mCaptureAndEnc.a(f2.a, f2.b);
        }
    }

    @Override
    public void updateLocalView(final TXCloudVideoView view) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.NONE) {
                    TRTCCloudImpl.this.apiLog("local capture is not started, you should start it first.");
                    return;
                }
                if (TRTCCloudImpl.this.mRoomInfo.localView == view) {
                    TRTCCloudImpl.this.apiLog("update local view with same view, ignore this call");
                    return;
                }
                if (view == null || view.getHWVideoView() == null || TRTCCloudImpl.this.mRoomInfo.localView == null || TRTCCloudImpl.this.mRoomInfo.localView.getHWVideoView() == null) {
                    TRTCCloudImpl.this.apiLog("updateLocalView only support TXCloudVideoView with TextureView.");
                    return;
                }
                TRTCCloudImpl.this.apiLog("update local view with %s", new Object[]{view});
                TRTCCloudImpl.this.mRoomInfo.localView = view;
                TRTCCloudImpl.this.updateLocalViewInternal(view);
            }
        });
    }

    @Override
    public void stopLocalPreview() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("stopLocalPreview");
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.CAMERA) {
                    TRTCCloudImpl.this.mMainStreamVideoSourceType = VideoSourceType.NONE;
                    TRTCCloudImpl.this.mCaptureAndEnc.d(true);
                }
                if (TRTCCloudImpl.this.mRoomInfo.localView != null) {
                    final SurfaceView surfaceView = TRTCCloudImpl.this.mRoomInfo.localView.getSurfaceView();
                    final TextureView textureView = TRTCCloudImpl.this.mRoomInfo.localView.getHWVideoView();
                    TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (surfaceView != null) {
                                surfaceView.getHolder().removeCallback(TRTCCloudImpl.this.mLocalPreviewSurfaceViewCallback);
                            } else if (textureView != null) {
                                textureView.setSurfaceTextureListener(null);
                            }
                        }
                    });
                }
                TRTCCloudImpl.this.mRoomInfo.localView = null;
                TRTCCloudImpl.this.mIsVideoCapturing = false;
                TRTCCloudImpl.this.mOrientationEventListener.disable();
                if (!TRTCCloudImpl.this.mEnableCustomVideoCapture) {
                    TRTCCloudImpl.this.enableVideoStream(0, false);
                }
                TXCKeyPointReportProxy.a(40046, 0, 2);
                TXCEventRecorderProxy.a("18446744073709551615", 4006, 3L, -1L, "", 2);
            }
        });
    }

    @Override
    public void startRemoteView(final String userId, final TXCloudVideoView view) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo == null) {
                    TRTCRoomInfo.UserInfo userInfo2 = TRTCCloudImpl.this.createUserInfo(userId);
                    userInfo2.mainRender.view = view;
                    userInfo2.mainRender.startRenderView = true;
                    userInfo2.mainRender.muteVideo = TRTCCloudImpl.this.mRoomInfo.muteRemoteVideo;
                    userInfo2.mainRender.muteAudio = TRTCCloudImpl.this.mRoomInfo.muteRemoteAudio;
                    userInfo2.subRender.muteVideo = TRTCCloudImpl.this.mRoomInfo.muteRemoteVideo;
                    TRTCCloudImpl.this.mRoomInfo.addUserInfo(userId, userInfo2);
                    String string = String.format("Remote-startRemoteView userID:%s (save view before user enter)", userId) + " self:" + TRTCCloudImpl.this.hashCode();
                    TRTCCloudImpl.this.apiOnlineLog(string);
                    return;
                }
                if (view != null && ((Object)((Object)view)).equals((Object)userInfo.mainRender.view)) {
                    TRTCCloudImpl.this.apiLog("startRemoteView user view is the same, ignore " + userId);
                    return;
                }
                boolean bl = userInfo.mainRender.view != null;
                userInfo.mainRender.view = view;
                userInfo.mainRender.startRenderView = true;
                if (userInfo.mainRender.tinyID == 0L) {
                    TRTCCloudImpl.this.apiLog("startRemoteView user tinyID is 0, ignore " + userId);
                    return;
                }
                TRTCCloudImpl.this.setRenderView(userId, userInfo.mainRender, view, userInfo.debugMargin);
                String string = String.format("Remote-startRemoteView userID:%s tinyID:%d streamType:%d view:%d", userId, userInfo.tinyID, userInfo.streamType, view != null ? ((Object)((Object)view)).hashCode() : 0) + " self:" + TRTCCloudImpl.this.hashCode();
                TRTCCloudImpl.this.apiOnlineLog(string);
                TRTCCloudImpl.this.notifyLogByUserId(String.valueOf(userInfo.tinyID), userInfo.streamType, 0, "Start watching " + userId);
                if (!bl || !userInfo.mainRender.render.isRendering()) {
                    TRTCCloudImpl.this.startRemoteRender(userInfo.mainRender.render, userInfo.streamType);
                }
                if (userInfo.mainRender.muteVideo == TRTCRoomInfo.TRTCRemoteMuteState.MUTE) {
                    TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, userInfo.streamType, true);
                } else {
                    userInfo.mainRender.lastVideoStatusChangeOperation = 2;
                    TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, userInfo.streamType, true);
                    TXCKeyPointReportProxy.a(String.valueOf(userInfo.tinyID), 40021, 0L, userInfo.streamType);
                }
                TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4015, 1L, -1L, "", 0);
            }
        });
    }

    @Override
    public void stopRemoteView(String userId) {
        this.stopRemoteView(userId, 0);
    }

    @Override
    public void startRemoteSubStreamView(final String userId, final TXCloudVideoView view) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo == null) {
                    TRTCCloudImpl.this.apiLog("startRemoteSubStreamView user is not exist save view" + userId);
                    TRTCRoomInfo.UserInfo userInfo2 = TRTCCloudImpl.this.createUserInfo(userId);
                    userInfo2.subRender.view = view;
                    userInfo2.subRender.startRenderView = true;
                    userInfo2.mainRender.muteVideo = TRTCCloudImpl.this.mRoomInfo.muteRemoteVideo;
                    userInfo2.mainRender.muteAudio = TRTCCloudImpl.this.mRoomInfo.muteRemoteAudio;
                    userInfo2.subRender.muteVideo = TRTCCloudImpl.this.mRoomInfo.muteRemoteVideo;
                    TRTCCloudImpl.this.mRoomInfo.addUserInfo(userId, userInfo2);
                    return;
                }
                if (view != null && ((Object)((Object)view)).equals((Object)userInfo.subRender.view)) {
                    TRTCCloudImpl.this.apiLog("startRemoteSubStreamView user view is the same, ignore " + userId);
                    return;
                }
                boolean bl = userInfo.subRender.view != null;
                userInfo.subRender.view = view;
                userInfo.subRender.startRenderView = true;
                if (userInfo.subRender.tinyID == 0L) {
                    TRTCCloudImpl.this.apiLog("startRemoteSubStreamView user tinyID is 0, ignore " + userId);
                    return;
                }
                TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4015, 1L, -1L, "", 7);
                TRTCCloudImpl.this.setRenderView(userId, userInfo.subRender, view, userInfo.debugMargin);
                TRTCCloudImpl.this.apiOnlineLog(String.format("startRemoteSubStreamView userID:%s tinyID:%d streamType:%d view:%d", userId, userInfo.tinyID, 7, view != null ? ((Object)((Object)view)).hashCode() : 0));
                TRTCCloudImpl.this.notifyLogByUserId(String.valueOf(userInfo.tinyID), 7, 0, "Start watching " + userId);
                if (!bl || !userInfo.subRender.render.isRendering()) {
                    TRTCCloudImpl.this.startRemoteRender(userInfo.subRender.render, 7);
                }
                if (userInfo.subRender.muteVideo == TRTCRoomInfo.TRTCRemoteMuteState.MUTE) {
                    TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 7, true);
                } else {
                    userInfo.subRender.lastVideoStatusChangeOperation = 2;
                    TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 7, true);
                    TXCKeyPointReportProxy.a(String.valueOf(userInfo.tinyID), 40021, 0L, 7);
                }
            }
        });
    }

    @Override
    public void stopRemoteSubStreamView(String userId) {
        this.stopRemoteView(userId, 2);
    }

    @Override
    public void setRemoteSubStreamViewFillMode(String userId, int mode) {
        this.setRemoteViewFillMode(userId, 2, mode);
    }

    @Override
    public void setRemoteSubStreamViewRotation(String userId, int rotation) {
        this.setRemoteViewRotation(userId, 2, rotation);
    }

    @Override
    public void stopAllRemoteView() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("stopAllRemoteView");
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        TRTCCloudImpl.this.stopRemoteMainRender(userInfo, true);
                        TRTCCloudImpl.this.stopRemoteSubRender(userInfo);
                        userInfo.mainRender.view = null;
                        userInfo.mainRender.startRenderView = false;
                        userInfo.subRender.view = null;
                        userInfo.subRender.startRenderView = false;
                    }
                });
            }
        });
    }

    @Override
    public void snapshotVideo(final String userId, final int streamType, final TRTCCloudListener.TRTCSnapshotListener listener) {
        this.apiLog(String.format("snapshotVideo user:%s streamType:%d", userId, streamType));
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (userId == null) {
                    TRTCCloudImpl.this.apiLog("snapshotLocalView");
                    TRTCCloudImpl.this.mCaptureAndEnc.a(new p(){

                        @Override
                        public void onTakePhotoComplete(final Bitmap bitmap) {
                            TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (listener != null) {
                                        listener.onSnapshotComplete(bitmap);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                    e e2 = null;
                    if (streamType == 2) {
                        if (userInfo != null && userInfo.mainRender != null && userInfo.mainRender.render != null) {
                            TRTCCloudImpl.this.apiLog("snapshotRemoteSubStreamView->userId: " + userId);
                            e2 = userInfo.subRender.render.getVideoRender();
                        }
                    } else if (userInfo != null && userInfo.mainRender != null && userInfo.mainRender.render != null) {
                        TRTCCloudImpl.this.apiLog("snapshotRemoteView->userId: " + userId);
                        e2 = userInfo.mainRender.render.getVideoRender();
                    }
                    if (e2 != null) {
                        e2.a(new p(){

                            @Override
                            public void onTakePhotoComplete(final Bitmap bitmap) {
                                TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (listener != null) {
                                            listener.onSnapshotComplete(bitmap);
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                            @Override
                            public void run() {
                                if (listener != null) {
                                    listener.onSnapshotComplete(null);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void startScreenCapture(final int streamType, final TRTCCloudDef.TRTCVideoEncParam param, final TRTCCloudDef.TRTCScreenShareParams screenShareParams) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                bl = streamType == 2 ? TRTCCloudImpl.this.startSubStreamScreenCapture(param) : TRTCCloudImpl.this.startMainStreamScreenCapture(param);
                if (!bl) {
                    return;
                }
                if (TRTCCloudImpl.this.mCurrentRole == 21) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                            if (tRTCCloudListener == null) {
                                return;
                            }
                            tRTCCloudListener.onWarning(6001, "ignore start local preview,for role audience", null);
                        }
                    });
                    TRTCCloudImpl.this.apiLog("ignore startLocalPreview for audience");
                }
                TRTCCloudImpl.this.apiOnlineLog("startScreenCapture streamType:%d", streamType);
                TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (screenShareParams != null) {
                            TRTCCloudImpl.this.showFloatingWindow(screenShareParams.floatingView);
                        }
                    }
                });
            }
        });
    }

    private boolean startSubStreamScreenCapture(TRTCCloudDef.TRTCVideoEncParam param) {
        if (this.mSubStreamVideoSourceType != VideoSourceType.NONE || this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
            this.notifyCaptureStarted("Has started capturing, ignore startSubStreamScreenCapture");
            return false;
        }
        this.mSubStreamVideoSourceType = VideoSourceType.SCREEN;
        this.makeSureSubStreamCaptureCreated();
        if (param != null) {
            this.mOverrideFPSFromUser = false;
            this.setSubStreamEncoderParam(param);
        } else {
            this.mOverrideFPSFromUser = true;
        }
        this.updateStreamEncoder(false);
        this.addUpStreamType(7);
        TXCKeyPointReportProxy.a(40046, 1, 7);
        TXCEventRecorderProxy.a("18446744073709551615", 4006, 2L, -1L, "", 7);
        this.mSubStreamCaptureAndEnc.a(this);
        return true;
    }

    private boolean startMainStreamScreenCapture(TRTCCloudDef.TRTCVideoEncParam param) {
        if (this.mMainStreamVideoSourceType != VideoSourceType.NONE || this.mSubStreamVideoSourceType == VideoSourceType.SCREEN) {
            this.notifyCaptureStarted("Has started capturing, ignore startMainStreamScreenCapture");
            return false;
        }
        this.mMainStreamVideoSourceType = VideoSourceType.SCREEN;
        this.mSensorMode = 0;
        this.mOrientationEventListener.disable();
        this.setStartVideoEncodeCodec();
        if (param != null) {
            this.mOverrideFPSFromUser = false;
            this.setVideoEncoderParamInternal(param);
        } else {
            this.mOverrideFPSFromUser = true;
        }
        this.mCaptureAndEnc.a(0);
        this.updateStreamEncoder(true);
        g.a a2 = this.getSizeByResolution(this.mSmallEncParam.videoResolution, this.mSmallEncParam.videoResolutionMode);
        this.updateSmallStreamEncoder(a2.a, a2.b, this.mSmallEncParam.videoFps, this.mSmallEncParam.videoBitrate, this.mSmallEncParam.minVideoBitrate);
        this.mRoomInfo.localView = null;
        this.enableVideoStream(0, true);
        TXCKeyPointReportProxy.a(40046, 1, 2);
        TXCEventRecorderProxy.a("18446744073709551615", 4006, 2L, -1L, "", 2);
        this.mCaptureAndEnc.a(this);
        return true;
    }

    @Override
    public void startScreenCapture(TRTCCloudDef.TRTCVideoEncParam param, TRTCCloudDef.TRTCScreenShareParams screenShareParams) {
        this.startScreenCapture(0, param, screenShareParams);
    }

    private void showFloatingWindow(View view) {
        if (view == null) {
            return;
        }
        if (TXCBuild.VersionInt() >= 23 && !Settings.canDrawOverlays((Context)view.getContext())) {
            TXCLog.e(TAG, "can't show floating window for no drawing overlay permission");
            return;
        }
        this.mFloatingWindow = view;
        WindowManager windowManager = (WindowManager)view.getContext().getSystemService("window");
        int n2 = 2005;
        if (TXCBuild.VersionInt() >= 26) {
            n2 = 2038;
        } else if (TXCBuild.VersionInt() > 24) {
            n2 = 2002;
        }
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(n2);
        layoutParams.flags = 8;
        layoutParams.flags |= 0x40000;
        layoutParams.width = -2;
        layoutParams.height = -2;
        layoutParams.format = -3;
        windowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    private void stopSubStreamScreenCapture() {
        if (this.mSubStreamVideoSourceType != VideoSourceType.SCREEN) {
            return;
        }
        this.apiOnlineLog("stopSubStreamScreenCapture");
        this.makeSureSubStreamCaptureCreated();
        this.mSubStreamVideoSourceType = VideoSourceType.NONE;
        this.mSubStreamCaptureAndEnc.m();
        this.mSubStreamConfig.k = this.mLatestParamsOfSubEncoder.getInt(KEY_CONFIG_FPS, this.mSubStreamConfig.k);
        this.mSubStreamConfig.l = this.mLatestParamsOfSubEncoder.getInt(KEY_CONFIG_GOP, this.mSubStreamConfig.l);
        this.mSubStreamConfig.s = this.mLatestParamsOfSubEncoder.getBoolean(KEY_CONFIG_ADJUST_RESOLUTION, this.mSubStreamConfig.s);
        this.mSubStreamCaptureAndEnc.a(this.mSubStreamConfig);
        this.removeUpStreamType(7);
        TXCKeyPointReportProxy.a(40046, 0, 7);
        TXCEventRecorderProxy.a("18446744073709551615", 4006, 3L, -1L, "", 7);
    }

    private void stopMainStreamScreenCapture() {
        if (this.mMainStreamVideoSourceType != VideoSourceType.SCREEN) {
            return;
        }
        this.apiOnlineLog("stopMainStreamScreenCapture");
        this.mMainStreamVideoSourceType = VideoSourceType.NONE;
        this.mCaptureAndEnc.m();
        this.mRoomInfo.localView = null;
        this.enableVideoStream(0, false);
        TXCKeyPointReportProxy.a(40046, 0, 2);
        TXCEventRecorderProxy.a("18446744073709551615", 4006, 3L, -1L, "", 2);
        this.mConfig.k = this.mLatestParamsOfBigEncoder.getInt(KEY_CONFIG_FPS, this.mConfig.k);
        this.mConfig.l = this.mLatestParamsOfBigEncoder.getInt(KEY_CONFIG_GOP, this.mConfig.l);
        this.mConfig.s = this.mLatestParamsOfBigEncoder.getBoolean(KEY_CONFIG_ADJUST_RESOLUTION, this.mConfig.s);
        this.mSmallEncParam.videoFps = this.mLatestParamsOfSmallEncoder.getInt(KEY_CONFIG_FPS, this.mSmallEncParam.videoFps);
        this.mSmallEncParam.enableAdjustRes = this.mLatestParamsOfSmallEncoder.getBoolean(KEY_CONFIG_ADJUST_RESOLUTION, this.mSmallEncParam.enableAdjustRes);
        TXCLog.i(TAG, String.format(Locale.ENGLISH, "restore big encoder's fps: %d, gop: %d, small encoder's fps: %d", this.mConfig.k, this.mConfig.l, this.mSmallEncParam.videoFps));
    }

    @Override
    public void stopScreenCapture() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType != VideoSourceType.SCREEN && TRTCCloudImpl.this.mSubStreamVideoSourceType != VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.apiOnlineLog("stopScreenCapture been ignored for Screen capture is not started");
                    return;
                }
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.stopMainStreamScreenCapture();
                } else {
                    TRTCCloudImpl.this.stopSubStreamScreenCapture();
                }
                TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        TRTCCloudImpl.this.hideFloatingWindow();
                    }
                });
            }
        });
    }

    private void hideFloatingWindow() {
        if (this.mFloatingWindow == null) {
            return;
        }
        WindowManager windowManager = (WindowManager)this.mFloatingWindow.getContext().getSystemService("window");
        windowManager.removeViewImmediate(this.mFloatingWindow);
        this.mFloatingWindow = null;
    }

    @Override
    public void pauseScreenCapture() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.apiOnlineLog("pause mainStream screenCapture");
                    TRTCCloudImpl.this.mCaptureAndEnc.h();
                } else if (TRTCCloudImpl.this.mSubStreamVideoSourceType == VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.apiOnlineLog("pause subStream screenCapture");
                    TRTCCloudImpl.this.mSubStreamCaptureAndEnc.h();
                }
            }
        });
    }

    @Override
    public void resumeScreenCapture() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.apiOnlineLog("resume mainStream screenCapture");
                    TRTCCloudImpl.this.mCaptureAndEnc.i();
                } else if (TRTCCloudImpl.this.mSubStreamVideoSourceType == VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.apiOnlineLog("resume subStream screenCapture");
                    TRTCCloudImpl.this.mSubStreamCaptureAndEnc.i();
                }
            }
        });
    }

    @Override
    public void muteLocalVideo(final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteLocalVideo mute:" + mute + ", pauseImg:" + TRTCCloudImpl.this.mConfig.D);
                TRTCCloudImpl tRTCCloudImpl = TRTCCloudImpl.this.mCurrentPublishClouds.get(2);
                if (tRTCCloudImpl != TRTCCloudImpl.this && !mute) {
                    TRTCCloudImpl.this.muteLocalVideo(0, mute, TRTCCloudImpl.this);
                    TRTCCloudImpl.this.muteLocalVideo(2, mute, TRTCCloudImpl.this);
                } else {
                    TRTCCloudImpl.this.muteLocalVideo(0, mute, TRTCCloudImpl.this);
                }
            }
        });
    }

    @Override
    public void muteLocalVideo(final int streamType, final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteLocalVideo mute:" + mute + "streamType:" + streamType + ", pauseImg:" + TRTCCloudImpl.this.mConfig.D);
                TRTCCloudImpl.this.muteLocalVideo(streamType, mute, TRTCCloudImpl.this);
            }
        });
    }

    @Override
    public void setVideoMuteImage(final Bitmap image, final int fps) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setVideoMuteImage " + image + ", " + fps);
                int n2 = fps;
                if (n2 > 20) {
                    n2 = 20;
                } else if (n2 < 5) {
                    n2 = 5;
                }
                TRTCCloudImpl.this.mConfig.D = image;
                TRTCCloudImpl.this.mConfig.F = n2;
                TRTCCloudImpl.this.mConfig.E = -1;
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mConfig);
                if (TRTCCloudImpl.this.mRoomInfo.muteLocalVideo) {
                    if (TRTCCloudImpl.this.mConfig.D != null) {
                        TRTCCloudImpl.this.mCaptureAndEnc.h();
                        TRTCCloudImpl.this.muteUpstream(2, false);
                    } else {
                        TRTCCloudImpl.this.mCaptureAndEnc.i();
                        TRTCCloudImpl.this.muteUpstream(2, true);
                    }
                }
            }
        });
    }

    @Override
    public void startRemoteView(String userId, int streamType, TXCloudVideoView view) {
        switch (streamType) {
            case 0: 
            case 1: {
                this.startRemoteView(userId, view);
                this.setRemoteVideoStreamType(userId, streamType);
                break;
            }
            case 2: {
                this.startRemoteSubStreamView(userId, view);
                break;
            }
            default: {
                TXCLog.e(TAG, "startRemoteView unsupported streamType:" + streamType);
            }
        }
    }

    @Override
    public void updateRemoteView(final String userId, final int streamType, final TXCloudVideoView view) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.updateRemoteViewInternal(userId, streamType, view);
            }
        });
    }

    private void updateRemoteViewInternal(String userId, int streamType, TXCloudVideoView view) {
        TRTCRoomInfo.RenderInfo renderInfo;
        TRTCRoomInfo.UserInfo userInfo = this.mRoomInfo.getUser(userId);
        if (userInfo == null) {
            this.apiLog(TAG, "Can't get userinfo for %s, you should startRemoteView first.", userId);
            return;
        }
        switch (streamType) {
            case 0: 
            case 1: {
                renderInfo = userInfo.mainRender;
                break;
            }
            case 2: {
                renderInfo = userInfo.subRender;
                break;
            }
            default: {
                TXCLog.e(TAG, "updateRemoteView unsupported streamType:" + streamType);
                return;
            }
        }
        if (view == null || view.getHWVideoView() == null || renderInfo.view == null || renderInfo.view.getHWVideoView() == null) {
            this.apiLog("updateRemoteView only support TXCloudVideoView with TextureView. view: %s, remoteView: %s", new Object[]{view, renderInfo.view});
            return;
        }
        if (view == renderInfo.view) {
            this.apiLog("update remote view is same as the one being used.");
            return;
        }
        renderInfo.view = view;
        if (renderInfo.tinyID == 0L) {
            this.apiLog("update remote view when tinyID is 0, ignore %s", userInfo.userID);
            return;
        }
        this.setRenderView(userInfo.userID, renderInfo, view, userInfo.debugMargin);
        this.apiOnlineLog("Remote-updateRemoteView userID:%s tinyID:%d streamType:%d view:%s", new Object[]{userInfo.userID, userInfo.tinyID, streamType, view});
        this.startRemoteRender(renderInfo.render, this.outerStreamTypeToInnerStreamType(streamType));
    }

    private int outerStreamTypeToInnerStreamType(int outerStreamType) {
        if (outerStreamType == 0) {
            return 2;
        }
        if (outerStreamType == 1) {
            return 3;
        }
        return 7;
    }

    private void removeRemoteView(final String userId, final int streamType) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                Object object;
                TRTCRoomInfo.RenderInfo renderInfo;
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo == null) {
                    return;
                }
                TRTCRoomInfo.RenderInfo renderInfo2 = renderInfo = streamType == 2 ? userInfo.subRender : userInfo.mainRender;
                if (renderInfo.render != null && (object = renderInfo.render.getVideoRender()) != null) {
                    ((e)object).b(false);
                }
                if ((object = renderInfo.view) != null) {
                    SurfaceView surfaceView = ((TXCloudVideoView)((Object)object)).getSurfaceView();
                    if (surfaceView != null) {
                        surfaceView.getHolder().removeCallback((SurfaceHolder.Callback)renderInfo);
                    }
                    ((TXCloudVideoView)((Object)object)).removeVideoView();
                }
            }
        });
    }

    private void stopRemoteRender(final String userId, final int streamType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.RenderInfo renderInfo;
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo == null) {
                    TRTCCloudImpl.this.apiLog("stopRemoteRender user[%s] is not exist ", userId);
                    return;
                }
                TRTCCloudImpl.this.apiOnlineLog(String.format("stopRemoteView userID:%s tinyID:%d streamType:%d", userId, userInfo.tinyID, streamType));
                TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4015, 0L, -1L, "", streamType);
                if (streamType == 2) {
                    renderInfo = userInfo.subRender;
                    TRTCCloudImpl.this.stopRemoteSubRender(userInfo);
                } else {
                    renderInfo = userInfo.mainRender;
                    TRTCCloudImpl.this.stopRemoteMainRender(userInfo, false);
                }
                final TXCloudVideoView tXCloudVideoView = renderInfo.view;
                TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SurfaceView surfaceView;
                        if (tXCloudVideoView != null && (surfaceView = tXCloudVideoView.getSurfaceView()) != null) {
                            surfaceView.getHolder().removeCallback((SurfaceHolder.Callback)renderInfo);
                        }
                    }
                });
                renderInfo.view = null;
                renderInfo.startRenderView = false;
            }
        });
    }

    @Override
    public void stopRemoteView(String userId, int streamType) {
        if (streamType != 0 && streamType != 1 && streamType != 2) {
            TXCLog.e(TAG, "stopRemoteView unsupported streamType:" + streamType);
            return;
        }
        this.removeRemoteView(userId, streamType);
        this.stopRemoteRender(userId, streamType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void muteLocalVideo(int streamType, boolean mute, TRTCCloudImpl cloud) {
        int n2 = streamType == 2 ? 7 : 2;
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(n2);
        if (!mute) {
            if (tRTCCloudImpl != cloud) {
                this.enableVideoStream(streamType, false);
                HashMap<Integer, TRTCCloudImpl> hashMap = this.mCurrentPublishClouds;
                synchronized (hashMap) {
                    if (streamType != 2) {
                        this.mCurrentPublishClouds.put(2, cloud);
                        this.mCurrentPublishClouds.put(3, cloud);
                    } else {
                        this.mCurrentPublishClouds.put(7, cloud);
                    }
                }
                this.setVideoQuality(this.mQosMode, this.mQosPreference);
                if (streamType != 2) {
                    this.enableNetworkBlackStream(this.mCaptureAndEnc.j());
                    this.enableNetworkSmallStream(this.mEnableSmallStream);
                    this.flushBigVideoEncParamsIntoNetwork();
                    this.flushSmallVideoEncParamsIntoNetwork();
                } else {
                    this.flushSubVideoEncParamsIntoNetwork();
                }
                this.enableVideoStream(streamType, true);
            }
            if (streamType != 2) {
                this.mCaptureAndEnc.i();
                this.mRoomInfo.muteLocalVideo = mute;
                this.enableNetworkBlackStream(this.mCaptureAndEnc.j());
                this.muteUpstream(2, mute);
                this.mCaptureAndEnc.l(2);
                if (this.mEnableSmallStream) {
                    this.mCaptureAndEnc.l(3);
                    TXCEventRecorderProxy.a("18446744073709551615", 4006, 0L, -1L, "", 3);
                }
            } else {
                this.mRoomInfo.muteLocalSubVideo = mute;
                this.muteUpstream(7, mute);
                this.mCaptureAndEnc.l(7);
            }
            TXCEventRecorderProxy.a("18446744073709551615", 4006, 0L, -1L, "", n2);
        } else if (tRTCCloudImpl == cloud) {
            if (streamType != 2) {
                this.mRoomInfo.muteLocalVideo = mute;
                this.enableNetworkBlackStream(this.mCaptureAndEnc.j());
                if (this.mConfig.D != null) {
                    this.mCaptureAndEnc.h();
                } else {
                    this.muteUpstream(2, mute);
                    if (this.mEnableSmallStream) {
                        TXCEventRecorderProxy.a("18446744073709551615", 4006, 1L, -1L, "", 3);
                    }
                }
            } else {
                this.mRoomInfo.muteLocalSubVideo = mute;
                this.muteUpstream(7, mute);
            }
            TXCEventRecorderProxy.a("18446744073709551615", 4006, 1L, -1L, "", n2);
        }
    }

    void updateRemoteVideoStatusByMute(TRTCRoomInfo.UserInfo userInfo, boolean mute, int streamType) {
        TRTCRoomInfo.TRTCRemoteMuteState tRTCRemoteMuteState;
        TRTCRoomInfo.TRTCRemoteMuteState tRTCRemoteMuteState2 = tRTCRemoteMuteState = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
        if (streamType == 7) {
            if (userInfo.subRender.muteVideo != tRTCRemoteMuteState && userInfo.subRender.render != null) {
                if (mute) {
                    userInfo.subRender.lastVideoStatusChangeOperation = 1;
                    this.onRemoteVideoStatusUpdatedInternal(userInfo, 7, 0, 4);
                } else {
                    userInfo.subRender.lastVideoStatusChangeOperation = 2;
                }
            }
        } else if (userInfo.mainRender.muteVideo != tRTCRemoteMuteState && userInfo.mainRender.render != null) {
            if (mute) {
                userInfo.mainRender.lastVideoStatusChangeOperation = 1;
                this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 0, 4);
            } else {
                userInfo.mainRender.lastVideoStatusChangeOperation = 2;
            }
        }
    }

    @Override
    public void muteRemoteVideoStream(final String userId, final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteRemoteVideoStream userId:" + userId + ", mute:" + mute);
                TRTCCloudImpl.this.muteRemoteVideoStreamInternal(userId, 0, mute, true);
            }
        });
    }

    @Override
    public void muteRemoteVideoStream(final String userId, final int streamType, final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteRemoteVideoStream userId:" + userId + ", streamType:" + streamType + ", mute:" + mute);
                TRTCCloudImpl.this.muteRemoteVideoStreamInternal(userId, streamType, mute, true);
            }
        });
    }

    public void muteRemoteVideoStreamInternal(String userId, int streamType, boolean mute, boolean apiCall) {
        int n2;
        if (userId.isEmpty()) {
            TXCLog.e(TAG, "muteRemoteVideoStream return. userId is null");
            return;
        }
        TRTCRoomInfo.UserInfo userInfo = this.mRoomInfo.getUser(userId);
        if (userInfo == null) {
            this.apiLog("muteRemoteVideoStream " + userId + " no exist.");
            TRTCRoomInfo.UserInfo userInfo2 = this.createUserInfo(userId);
            if (streamType != 2) {
                userInfo2.mainRender.muteVideo = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                userInfo2.subRender.muteVideo = this.mRoomInfo.muteRemoteVideo;
                userInfo2.mainRender.muteAudio = this.mRoomInfo.muteRemoteAudio;
            } else {
                userInfo2.subRender.muteVideo = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                userInfo2.mainRender.muteVideo = this.mRoomInfo.muteRemoteVideo;
                userInfo2.mainRender.muteAudio = this.mRoomInfo.muteRemoteAudio;
            }
            this.mRoomInfo.addUserInfo(userId, userInfo2);
            return;
        }
        int n3 = n2 = streamType == 2 ? 7 : userInfo.streamType;
        if (userInfo.tinyID != 0L) {
            this.updateRemoteVideoStatusByMute(userInfo, mute, n2);
        }
        if (apiCall) {
            if (n2 != 7) {
                userInfo.mainRender.muteVideo = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
            } else {
                TRTCRoomInfo.TRTCRemoteMuteState tRTCRemoteMuteState = userInfo.subRender.muteVideo = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
            }
        }
        if (userInfo.tinyID == 0L) {
            return;
        }
        if (mute) {
            if (n2 != 7) {
                this.nativeCancelDownStream(this.mNativeRtcContext, userInfo.tinyID, 2, true);
                this.nativeCancelDownStream(this.mNativeRtcContext, userInfo.tinyID, 3, true);
            } else {
                this.nativeCancelDownStream(this.mNativeRtcContext, userInfo.tinyID, 7, true);
            }
        } else {
            if (n2 != 7) {
                this.nativeRequestDownStream(this.mNativeRtcContext, userInfo.tinyID, userInfo.streamType, true);
            } else {
                this.nativeRequestDownStream(this.mNativeRtcContext, userInfo.tinyID, 7, true);
            }
            TXCKeyPointReportProxy.a(String.valueOf(userInfo.tinyID), 40021, 0L, n2);
        }
        if (streamType != 7) {
            if (userInfo.mainRender.render != null) {
                userInfo.mainRender.render.resetPeriodStatistics();
                userInfo.mainRender.render.enableReport(!mute);
            }
        } else if (userInfo.subRender.render != null) {
            userInfo.subRender.render.resetPeriodStatistics();
            userInfo.subRender.render.enableReport(!mute);
        }
        TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4014, mute ? 1L : 0L, -1L, "", n2);
    }

    @Override
    public void muteAllRemoteVideoStreams(final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteAllRemoteVideoStreams mute " + mute);
                TRTCCloudImpl.this.mRoomInfo.muteRemoteVideo = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        TRTCCloudImpl.this.updateRemoteVideoStatusByMute(userInfo, mute, 2);
                        TRTCCloudImpl.this.updateRemoteVideoStatusByMute(userInfo, mute, 7);
                        userInfo.mainRender.muteVideo = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                        TRTCCloudImpl.this.apiLog("muteRemoteVideoStream " + userInfo.userID + ", mute " + mute);
                        if (userInfo.mainRender.render != null) {
                            userInfo.mainRender.render.resetPeriodStatistics();
                            userInfo.mainRender.render.enableReport(!mute);
                        }
                        if (userInfo.subRender.render != null) {
                            userInfo.subRender.render.resetPeriodStatistics();
                            userInfo.subRender.render.enableReport(!mute);
                        }
                        if (mute) {
                            TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 2, true);
                            TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 3, true);
                            TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 7, true);
                        } else {
                            if (userInfo.mainRender.render != null && userInfo.mainRender.render.isRendering()) {
                                TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, userInfo.streamType, true);
                                TXCKeyPointReportProxy.a(String.valueOf(userInfo.tinyID), 40021, 0L, userInfo.streamType);
                            }
                            if (userInfo.subRender.render != null && userInfo.subRender.render.isRendering()) {
                                TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 7, true);
                                TXCKeyPointReportProxy.a(String.valueOf(userInfo.tinyID), 40021, 0L, 7);
                            }
                        }
                        TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4014, mute ? 1L : 0L, -1L, "", 2);
                        TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4014, mute ? 1L : 0L, -1L, "", 7);
                    }
                });
            }
        });
    }

    @Override
    public void setVideoEncoderParam(final TRTCCloudDef.TRTCVideoEncParam param) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.setVideoEncoderParamInternal(param);
            }
        });
    }

    private void updateStreamEncoder(boolean isMainStream) {
        boolean bl;
        g g2 = isMainStream ? this.mConfig : this.mSubStreamConfig;
        boolean bl2 = bl = g2.o == 1 || g2.o == 3;
        if (isMainStream) {
            this.updateMainStreamEncoder(bl, g2.a, g2.b, g2.k, g2.e, g2.s, g2.g, g2.j);
        } else {
            this.updateSubStreamEncoder(bl, g2.a, g2.b, g2.k, g2.e, g2.s, g2.g, g2.j);
        }
    }

    private void updateSubStreamEncoder(boolean portrait, int width, int height, int fps, int targetBitrate, boolean isAdjustRes, int minBitrate, boolean setByAPI) {
        this.makeSureSubStreamCaptureCreated();
        this.updateEncoder(this.mSubStreamConfig, this.mSubStreamVideoSourceType, 7, portrait, width, height, fps, targetBitrate, isAdjustRes, minBitrate, setByAPI);
        this.mSubStreamCaptureAndEnc.f(this.mSubStreamConfig.k);
        this.mSubStreamCaptureAndEnc.d(this.mSubStreamConfig.e);
        this.mSubStreamCaptureAndEnc.a(this.mSubStreamConfig);
    }

    @Override
    public void setSubStreamEncoderParam(final TRTCCloudDef.TRTCVideoEncParam param) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (param == null) {
                    TRTCCloudImpl.this.apiLog("setSubStreamEncoderParam param is null");
                    return;
                }
                TRTCCloudImpl.this.makeSureSubStreamCaptureCreated();
                TRTCCloudImpl.this.mLatestParamsOfSubEncoder.putInt(TRTCCloudImpl.KEY_CONFIG_FPS, param.videoFps);
                TRTCCloudImpl.this.mLatestParamsOfSubEncoder.putBoolean(TRTCCloudImpl.KEY_CONFIG_ADJUST_RESOLUTION, param.enableAdjustRes);
                g.a a2 = TRTCCloudImpl.this.getSizeByResolution(param.videoResolution, param.videoResolutionMode);
                TRTCCloudImpl.this.updateSubStreamEncoder(param.videoResolutionMode == 1, a2.a, a2.b, param.videoFps, param.videoBitrate, param.enableAdjustRes, param.minVideoBitrate, true);
            }
        });
    }

    private void setVideoEncoderParamInternal(TRTCCloudDef.TRTCVideoEncParam param) {
        if (param != null) {
            this.mLatestParamsOfBigEncoder.putInt(KEY_CONFIG_FPS, param.videoFps);
            this.mLatestParamsOfBigEncoder.putBoolean(KEY_CONFIG_ADJUST_RESOLUTION, param.enableAdjustRes);
            g.a a2 = this.getSizeByResolution(param.videoResolution, param.videoResolutionMode);
            this.mConfig.j = true;
            this.updateMainStreamEncoder(param.videoResolutionMode == 1, a2.a, a2.b, param.videoFps, param.videoBitrate, param.enableAdjustRes, param.minVideoBitrate, this.mConfig.j);
            this.apiOnlineLog(String.format("setVideoEncoderParam width:%d, height:%d, fps:%d, bitrate:%d, mode:%d, minBitrate:%d", this.mRoomInfo.bigEncSize.a, this.mRoomInfo.bigEncSize.b, param.videoFps, param.videoBitrate, param.videoResolutionMode, param.minVideoBitrate));
            this.updateOrientation();
            TXCEventRecorderProxy.a("18446744073709551615", 4007, this.mRoomInfo.bigEncSize.a, this.mRoomInfo.bigEncSize.b, "", 2);
            TXCEventRecorderProxy.a("18446744073709551615", 4008, param.videoFps, -1L, "", 2);
            TXCEventRecorderProxy.a("18446744073709551615", 4009, param.videoBitrate, -1L, "", 2);
        } else {
            this.apiLog("setVideoEncoderParam param is null");
        }
    }

    @Override
    public void setNetworkQosParam(final TRTCCloudDef.TRTCNetworkQosParam param) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (param != null) {
                    TRTCCloudImpl.this.apiLog("setNetworkQosParam");
                    TRTCCloudImpl.this.mQosPreference = param.preference;
                    TRTCCloudImpl.this.mQosMode = param.controlMode;
                    TRTCCloudImpl.this.setVideoQuality(TRTCCloudImpl.this.mQosMode, TRTCCloudImpl.this.mQosPreference);
                } else {
                    TRTCCloudImpl.this.apiLog("setNetworkQosParam param is null");
                }
            }
        });
    }

    @Override
    public void setLocalRenderParams(TRTCCloudDef.TRTCRenderParams renderParams) {
        this.setLocalViewFillMode(renderParams.fillMode);
        this.setLocalViewRotation(renderParams.rotation);
        this.setLocalViewMirror(renderParams.mirrorType);
    }

    @Override
    public void setRemoteRenderParams(String userId, int streamType, TRTCCloudDef.TRTCRenderParams renderParams) {
        switch (streamType) {
            case 0: 
            case 1: 
            case 2: {
                this.setRemoteViewFillMode(userId, streamType, renderParams.fillMode);
                this.setRemoteViewRotation(userId, streamType, renderParams.rotation);
                this.setRemoteViewMirror(userId, streamType, renderParams.mirrorType);
                break;
            }
            default: {
                TXCLog.e(TAG, "setRemoteRenderParams unsupported streamType:" + streamType);
            }
        }
    }

    private TRTCRoomInfo.RenderInfo getRenderInfo(String userId, int streamType) {
        TRTCRoomInfo.UserInfo userInfo = this.mRoomInfo.getUser(userId);
        if (userInfo == null) {
            userInfo = this.createUserInfo(userId);
            this.mRoomInfo.addUserInfo(userId, userInfo);
        }
        TRTCRoomInfo.RenderInfo renderInfo = streamType == 0 || streamType == 1 ? userInfo.mainRender : userInfo.subRender;
        return renderInfo;
    }

    private void setRemoteViewFillMode(final String userId, final int streamType, final int mode) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setRemoteViewFillMode->userId:%s, streamType:%d, renderMode:%d", userId, streamType, mode);
                TRTCRoomInfo.RenderInfo renderInfo = TRTCCloudImpl.this.getRenderInfo(userId, streamType);
                if (renderInfo != null) {
                    renderInfo.renderMode = mode;
                    TXCRenderAndDec tXCRenderAndDec = renderInfo.render;
                    if (tXCRenderAndDec != null) {
                        tXCRenderAndDec.setRenderMode(mode);
                    }
                }
            }
        });
    }

    private void setRemoteViewRotation(final String userId, final int streamType, final int rotation) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setRemoteViewRotation->userId:%s, streamType:%d, rotation:%d", userId, streamType, rotation);
                TRTCRoomInfo.RenderInfo renderInfo = TRTCCloudImpl.this.getRenderInfo(userId, streamType);
                if (renderInfo != null) {
                    renderInfo.rotation = TRTCCloudImpl.this.getCompatibleRotation(rotation);
                    TXCRenderAndDec tXCRenderAndDec = renderInfo.render;
                    if (tXCRenderAndDec != null) {
                        tXCRenderAndDec.setRenderRotation(renderInfo.rotation);
                    }
                }
            }
        });
    }

    private void setRemoteViewMirror(final String userId, final int streamType, final int mirrorType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setRemoteViewMirror->userId:%s, streamType:%d, mirrorType:%d", userId, streamType, mirrorType);
                TRTCRoomInfo.RenderInfo renderInfo = TRTCCloudImpl.this.getRenderInfo(userId, streamType);
                if (renderInfo != null) {
                    renderInfo.mirrorType = mirrorType;
                    TXCRenderAndDec tXCRenderAndDec = renderInfo.render;
                    if (tXCRenderAndDec != null) {
                        if (mirrorType == 1) {
                            tXCRenderAndDec.setRenderMirrorType(1);
                        } else {
                            tXCRenderAndDec.setRenderMirrorType(2);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void setLocalViewFillMode(final int mode) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setLocalViewFillMode " + mode);
                TRTCCloudImpl.this.mCaptureAndEnc.g(mode);
            }
        });
    }

    @Override
    public void setRemoteViewFillMode(String userId, int mode) {
        this.setRemoteViewFillMode(userId, 0, mode);
    }

    @Override
    public void setLocalViewRotation(final int rotation) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("vrotation setLocalViewRotation " + rotation);
                TRTCCloudImpl.this.mRoomInfo.localRenderRotation = TRTCCloudImpl.this.getCompatibleRotation(rotation);
                TRTCCloudImpl.this.mCaptureAndEnc.h(TRTCCloudImpl.this.mRoomInfo.localRenderRotation);
                TRTCCloudImpl.this.updateOrientation();
            }
        });
    }

    @Override
    public void setRemoteViewRotation(String userId, int rotation) {
        this.setRemoteViewRotation(userId, 0, rotation);
    }

    @Override
    public void setVideoEncoderRotation(final int rotation) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("vrotation setVideoEncoderRotation " + rotation + ", g sensor mode " + TRTCCloudImpl.this.mSensorMode);
                if (TRTCCloudImpl.this.mSensorMode == 0) {
                    TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.getCompatibleRotation(rotation));
                }
            }
        });
    }

    @Override
    public void setGSensorMode(final int mode) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
                    TRTCCloudImpl.this.apiLog("setGSensorMode has been ignored for screen capturing");
                    return;
                }
                TRTCCloudImpl.this.mSensorMode = mode;
                TRTCCloudImpl.this.apiLog("vrotation setGSensorMode " + mode);
            }
        });
    }

    @Override
    public int enableEncSmallVideoStream(final boolean enable, final TRTCCloudDef.TRTCVideoEncParam param) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mEnableSmallStream = enable;
                TRTCCloudImpl.this.enableNetworkSmallStream(TRTCCloudImpl.this.mEnableSmallStream);
                if (param != null) {
                    ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoBitrate = param.videoBitrate;
                    ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.minVideoBitrate = param.minVideoBitrate;
                    ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoFps = param.videoFps;
                    ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoResolution = param.videoResolution;
                    ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoResolutionMode = param.videoResolutionMode;
                    TRTCCloudImpl.this.mLatestParamsOfSmallEncoder.putInt(TRTCCloudImpl.KEY_CONFIG_FPS, param.videoFps);
                    TRTCCloudImpl.this.mLatestParamsOfSmallEncoder.putBoolean(TRTCCloudImpl.KEY_CONFIG_ADJUST_RESOLUTION, param.enableAdjustRes);
                }
                TRTCCloudImpl.this.apiLog("enableEncSmallVideoStream enable:" + enable + " videoBitrate:" + ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoBitrate + " minVideoBitrate:" + ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.minVideoBitrate + " videoFps:" + ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoFps + " videoResolution:" + ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoResolution + " videoResolutionMode:" + ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoResolutionMode + " enableAdjustRes:" + ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.enableAdjustRes);
                boolean bl = TRTCCloudImpl.this.mConfig.s;
                int n2 = TRTCCloudImpl.this.mConfig.l;
                if (TRTCCloudImpl.this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
                    n2 = 3;
                    bl = false;
                    if (TRTCCloudImpl.this.mOverrideFPSFromUser) {
                        ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoFps = 10;
                    }
                }
                TRTCCloudImpl.this.mRoomInfo.smallEncSize = TRTCCloudImpl.this.getSizeByResolution(((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoResolution, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoResolutionMode);
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mEnableSmallStream, TRTCCloudImpl.this.mRoomInfo.smallEncSize.a, TRTCCloudImpl.this.mRoomInfo.smallEncSize.b, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoFps, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoBitrate, n2);
                if (TRTCCloudImpl.this.mEnableSmallStream) {
                    TRTCCloudImpl.this.setVideoEncConfig(3, TRTCCloudImpl.this.mRoomInfo.smallEncSize.a, TRTCCloudImpl.this.mRoomInfo.smallEncSize.b, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoFps, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.videoBitrate, bl, ((TRTCCloudImpl)TRTCCloudImpl.this).mSmallEncParam.minVideoBitrate, false);
                    TRTCCloudImpl.this.addUpStreamType(3);
                } else {
                    TRTCCloudImpl.this.setVideoEncoderConfiguration(3, 0, 0, 0, 0, 1, TRTCCloudImpl.this.mConfig.s, 0, false);
                    TRTCCloudImpl.this.removeUpStreamType(3);
                }
            }
        });
        return 0;
    }

    @Override
    public int setPriorRemoteVideoStreamType(final int type) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mPriorStreamType = type == 0 ? 2 : (type == 1 ? 3 : 2);
                TRTCCloudImpl.this.apiLog("setPriorRemoteVideoStreamType " + TRTCCloudImpl.this.mPriorStreamType);
            }
        });
        return 0;
    }

    @Override
    public void setLocalViewMirror(final int mode) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mVideoRenderMirror = mode;
                TRTCCloudImpl.this.apiLog("setLocalViewMirror " + mode);
                TRTCCloudImpl.this.mCaptureAndEnc.b(mode);
                TRTCCloudImpl.this.updateOrientation();
            }
        });
    }

    @Override
    public void setVideoEncoderMirror(final boolean mirror) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setVideoEncoderMirror " + mirror);
                TRTCCloudImpl.this.mConfig.V = mirror;
                TRTCCloudImpl.this.mCaptureAndEnc.g(mirror);
                TRTCCloudImpl.this.updateOrientation();
            }
        });
    }

    @Override
    public void setAudioQuality(final int quality) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setAudioQuality " + quality);
                TXCAudioEngine.getInstance().setAudioQuality(quality, 2);
            }
        });
    }

    @Override
    public void startLocalAudio(int quality) {
        this.setAudioQuality(quality);
        this.startLocalAudio();
    }

    @Override
    public void startLocalAudio() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mEnableCustomAudioCapture) {
                    TRTCCloudImpl.this.apiLog("startLocalAudio when enable custom audio capturing, ignore!!!");
                    return;
                }
                if (TRTCCloudImpl.this.mIsAudioCapturing) {
                    TRTCCloudImpl.this.apiLog("startLocalAudio when capturing audio, ignore!!!");
                    return;
                }
                if (TRTCCloudImpl.this.mCurrentRole == 21) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                            if (tRTCCloudListener == null) {
                                return;
                            }
                            tRTCCloudListener.onWarning(6001, "ignore start local audio,for role audience", null);
                        }
                    });
                    TRTCCloudImpl.this.apiLog("ignore startLocalAudio,for role audience");
                }
                TRTCCloudImpl.this.apiOnlineLog("startLocalAudio");
                TXCEventRecorderProxy.a("18446744073709551615", 3001, 0L, -1L, "", 0);
                TXCKeyPointReportProxy.a(30002);
                TRTCCloudImpl.this.mIsAudioCapturing = true;
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mConfig);
                TRTCCloudImpl.this.setQoSParams();
                TXCAudioEngine.getInstance().enableCaptureEOSMode(TRTCCloudImpl.this.mEnableEosMode);
                TXCAudioEngineJNI.nativeUseSysAudioDevice(false);
                TXCAudioEngine.getInstance().startLocalAudio(11, false);
                TXCAudioEngine.getInstance().enableEncodedDataPackWithTRAEHeaderCallback(true);
                TXCAudioEngine.getInstance().muteLocalAudio(TRTCCloudImpl.this.mRoomInfo.muteLocalAudio);
                TXCEventRecorderProxy.a("18446744073709551615", 3003, 11L, -1L, "", 0);
                TRTCCloudImpl.this.enableAudioStream(true);
                TXCKeyPointReportProxy.a(40050, 1, 1);
            }
        });
    }

    @Override
    public void stopLocalAudio() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.stopLocalAudioInternal();
            }
        });
    }

    private void stopLocalAudioInternal() {
        if (!this.mIsAudioCapturing) {
            this.apiLog("stopLocalAudio when no capturing audio, ignore!!!");
            return;
        }
        this.apiOnlineLog("stopLocalAudio");
        TXCEventRecorderProxy.a("18446744073709551615", 3001, 2L, -1L, "", 0);
        this.mIsAudioCapturing = false;
        TXCAudioEngine.getInstance().stopLocalAudio();
        if (!this.mEnableCustomAudioCapture) {
            this.enableAudioStream(false);
        }
        TXCKeyPointReportProxy.a(40050, 0, 1);
        TXCLog.i(TAG, "(%d)stopLocalAudioInternal end", this.hashCode());
    }

    @Override
    public int setRemoteVideoStreamType(final String userId, final int type) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo == null) {
                    return;
                }
                int n2 = 2;
                if (type == 1) {
                    n2 = 3;
                }
                if (userInfo.streamType == n2) {
                    return;
                }
                userInfo.streamType = n2;
                TRTCCloudImpl.this.apiLog("setRemoteVideoStreamType " + userId + ", " + n2 + ", " + userInfo.tinyID);
                TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, n2, false);
            }
        });
        return 0;
    }

    @Override
    public void setAudioRoute(int route) {
        TXDeviceManager.TXAudioRoute tXAudioRoute = TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece;
        switch (route) {
            case 0: {
                tXAudioRoute = TXDeviceManager.TXAudioRoute.TXAudioRouteSpeakerphone;
                break;
            }
            case 1: {
                tXAudioRoute = TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece;
                break;
            }
        }
        this.mDeviceManager.setAudioRoute(tXAudioRoute);
    }

    @Override
    public void muteLocalAudio(final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteLocalAudio " + mute);
                TRTCCloudImpl.this.muteLocalAudio(mute, TRTCCloudImpl.this);
                if (mute) {
                    TXCEventRecorderProxy.a("18446744073709551615", 3001, 1L, -1L, "", 0);
                } else {
                    TXCEventRecorderProxy.a("18446744073709551615", 3001, 3L, -1L, "", 0);
                }
            }
        });
    }

    public void muteLocalAudio(final boolean mute, final TRTCCloudImpl cloud) {
        this.runOnSDKThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TRTCCloudImpl tRTCCloudImpl = TRTCCloudImpl.this.mCurrentPublishClouds.get(1);
                if (!mute) {
                    if (tRTCCloudImpl != cloud) {
                        TRTCCloudImpl.this.enableAudioStream(false);
                        HashMap<Integer, TRTCCloudImpl> hashMap = TRTCCloudImpl.this.mCurrentPublishClouds;
                        synchronized (hashMap) {
                            TRTCCloudImpl.this.mCurrentPublishClouds.put(1, cloud);
                        }
                        TRTCCloudImpl.this.setAudioEncodeConfiguration();
                    }
                    TRTCCloudImpl.this.mRoomInfo.muteLocalAudio = mute;
                    TXCAudioEngine.getInstance().muteLocalAudio(mute);
                    TRTCCloudImpl.this.muteUpstream(1, mute);
                    TRTCCloudImpl.this.enableAudioStream(true);
                } else if (tRTCCloudImpl == cloud) {
                    TRTCCloudImpl.this.mRoomInfo.muteLocalAudio = mute;
                    TXCAudioEngine.getInstance().muteLocalAudio(mute);
                    TRTCCloudImpl.this.muteUpstream(1, mute);
                }
            }
        });
    }

    @Override
    public void muteRemoteAudio(final String userId, final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mEnableServerAudioMix) {
                    TXCLog.e(TRTCCloudImpl.TAG, "[server audio mix] muteRemoteAudio is disabled while server audio mixing, please use muteAllRemoteAudio instead");
                    return;
                }
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo == null) {
                    TRTCCloudImpl.this.apiLog("muteRemoteAudio " + userId + " no exist.");
                    TRTCRoomInfo.UserInfo userInfo2 = TRTCCloudImpl.this.createUserInfo(userId);
                    userInfo2.mainRender.muteAudio = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                    TRTCCloudImpl.this.mRoomInfo.addUserInfo(userId, userInfo2);
                    return;
                }
                userInfo.mainRender.muteAudio = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                TRTCCloudImpl.this.apiOnlineLog("muteRemoteAudio userId:%s mute:%b", userId, mute);
                if (userInfo.tinyID == 0L) {
                    return;
                }
                TXCAudioEngine.getInstance().muteRemoteAudio(String.valueOf(userInfo.tinyID), mute);
                if (mute) {
                    TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 1, true);
                } else {
                    TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 1, true);
                }
            }
        });
    }

    @Override
    public void muteAllRemoteAudio(final boolean mute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("muteAllRemoteAudio " + mute);
                TRTCCloudImpl.this.mRoomInfo.muteRemoteAudio = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        userInfo.mainRender.muteAudio = mute ? TRTCRoomInfo.TRTCRemoteMuteState.MUTE : TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE;
                        TXCAudioEngine.getInstance().muteRemoteAudio(String.valueOf(userInfo.tinyID), mute);
                        if (mute) {
                            TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 1, true);
                        } else {
                            TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, userInfo.tinyID, 1, true);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void setRemoteAudioVolume(final String userId, final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                int n2 = volume;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (TRTCCloudImpl.this.mEnableServerAudioMix) {
                    TXCLog.e(TRTCCloudImpl.TAG, "[server audio mix] setRemoteAudioVolume is disabled while server audio mixing, please use setAudioPlayoutVolume instead");
                    return;
                }
                TRTCCloudImpl.this.apiLog("setRemoteAudioVolume: userId = " + userId + " volume = " + n2);
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCAudioEngine.getInstance().setRemotePlayoutVolume(String.valueOf(userInfo.tinyID), n2);
                }
            }
        });
    }

    @Override
    public void setAudioCaptureVolume(int volume) {
        int n2 = volume;
        if (n2 < 0) {
            n2 = 0;
        }
        this.mAudioCaptureVolume = n2;
        this.apiLog("setAudioCaptureVolume:  volume=" + this.mAudioCaptureVolume);
        TXAudioEffectManagerImpl.getInstance().setVoiceCaptureVolume(n2);
    }

    @Override
    public int getAudioCaptureVolume() {
        return this.mAudioCaptureVolume;
    }

    @Override
    public void setAudioPlayoutVolume(int volume) {
        int n2 = volume;
        if (n2 < 0) {
            n2 = 0;
        }
        this.mAudioPlayoutVolume = n2;
        this.apiLog("setAudioPlayoutVolume:  volume=" + this.mAudioPlayoutVolume);
        TXAudioEffectManagerImpl.getInstance().setAudioPlayoutVolume(n2);
    }

    @Override
    public int getAudioPlayoutVolume() {
        return this.mAudioPlayoutVolume;
    }

    @Override
    public void setSystemVolumeType(int type) {
        TXDeviceManager.TXSystemVolumeType tXSystemVolumeType = TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeAuto;
        switch (type) {
            case 0: {
                tXSystemVolumeType = TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeAuto;
                break;
            }
            case 1: {
                tXSystemVolumeType = TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeMedia;
                break;
            }
            case 2: {
                tXSystemVolumeType = TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeVOIP;
            }
        }
        this.mDeviceManager.setSystemVolumeType(tXSystemVolumeType);
    }

    @Override
    public void enableAudioEarMonitoring(final boolean enable) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("enableAudioEarMonitoring enable:%b", enable);
                TXAudioEffectManagerImpl.getInstance().enableVoiceEarMonitor(enable);
            }
        });
    }

    @Override
    public TXDeviceManager getDeviceManager() {
        return this.mDeviceManager;
    }

    @Override
    public void onScreenCaptureStarted() {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onScreenCaptureStarted();
                }
            }
        });
    }

    @Override
    public void onScreenCaptureResumed() {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onScreenCaptureResumed();
                }
            }
        });
    }

    @Override
    public void onScreenCapturePaused() {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onScreenCapturePaused();
                }
            }
        });
    }

    @Override
    public void onScreenCaptureStopped(final int reason) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onScreenCaptureStopped(reason);
                }
            }
        });
    }

    protected void startVolumeLevelCal(boolean enable) {
        TXCAudioEngine.getInstance();
        TXCAudioEngine.enableAudioVolumeEvaluation(enable, this.mAudioVolumeEvalInterval);
        if (enable) {
            if (this.mVolumeLevelNotifyTask == null) {
                this.mVolumeLevelNotifyTask = new VolumeLevelNotifyTask(this);
                this.mSDKHandler.postDelayed(this.mVolumeLevelNotifyTask, this.mAudioVolumeEvalInterval);
            }
        } else {
            this.mVolumeLevelNotifyTask = null;
            this.mAudioVolumeEvalInterval = 0;
        }
    }

    @Override
    public void enableAudioVolumeEvaluation(final int intervalMs) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                int n2 = 0;
                n2 = intervalMs > 0 ? (intervalMs < 100 ? 100 : intervalMs) : 0;
                if (n2 == TRTCCloudImpl.this.mAudioVolumeEvalInterval) {
                    return;
                }
                TRTCCloudImpl.this.apiLog("enableAudioVolumeEvaluation " + n2);
                TRTCCloudImpl.this.mAudioVolumeEvalInterval = n2;
                if (TRTCCloudImpl.this.mAudioVolumeEvalInterval > 0) {
                    TRTCCloudImpl.this.startVolumeLevelCal(true);
                } else {
                    TRTCCloudImpl.this.startVolumeLevelCal(false);
                }
            }
        });
    }

    @Override
    public int startAudioRecording(TRTCCloudDef.TRTCAudioRecordingParams TRTCAudioRecordingParams2) {
        if (TextUtils.isEmpty((CharSequence)TRTCAudioRecordingParams2.filePath)) {
            this.apiLog("startLocalAudioRecord error:" + TRTCAudioRecordingParams2.filePath);
            return -1;
        }
        this.apiLog("startLocalAudioRecord:" + TRTCAudioRecordingParams2.filePath);
        TXCAudioEngine.getInstance().setAudioDumpingListener(new TXCAudioEngineJNI.a(){

            @Override
            public void onLocalAudioWriteFailed() {
                TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                        if (tRTCCloudListener == null) {
                            return;
                        }
                        TRTCCloudImpl.this.apiLog("startLocalAudioRecord onWarning:7001");
                        tRTCCloudListener.onWarning(7001, "write file failed when recording audio.", null);
                    }
                });
            }
        });
        return TXCAudioEngine.getInstance().startLocalAudioDumping(48000, 16, TRTCAudioRecordingParams2.recordingContent, TRTCAudioRecordingParams2.filePath);
    }

    @Override
    public void stopAudioRecording() {
        TXCAudioEngine.getInstance().stopLocalAudioDumping();
    }

    @Override
    public void startLocalRecording(final TRTCCloudDef.TRTCLocalRecordingParams params) {
        if (params == null) {
            this.apiLog("startLocalRecording params is null!");
            this.onLocalRecordBegin(-1, "");
            return;
        }
        if (params.recordType != 0 && params.recordType != 1 && params.recordType != 2) {
            this.apiLog("startLocalRecording recordType invalid: " + params.recordType);
            this.onLocalRecordBegin(-1, params.filePath);
            return;
        }
        if ((params.interval < 1000 || params.interval > 10000) && params.interval != -1) {
            this.apiLog("startLocalRecording interval invalid: " + params.interval);
            this.onLocalRecordBegin(-1, params.filePath);
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("startLocalRecording params: " + params);
                TRTCCloudImpl.this.nativeStartLocalRecording(TRTCCloudImpl.this.mNativeRtcContext, params);
                TRTCCloudImpl.this.mCaptureAndEnc.l(2);
            }
        });
    }

    @Override
    public void stopLocalRecording() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopLocalRecording");
                TRTCCloudImpl.this.nativeStopLocalRecording(TRTCCloudImpl.this.mNativeRtcContext);
            }
        });
    }

    @Override
    public int checkAudioCapabilitySupport(int capabilityType) {
        AudioServerConfig audioServerConfig = AudioServerConfig.loadFromSharedPreferences(this.mContext);
        if (capabilityType == 1) {
            return audioServerConfig.supportAAudio ? 1 : 0;
        }
        if (capabilityType == 2) {
            return audioServerConfig.isLowLatencySampleRateSupported ? 1 : 0;
        }
        this.apiLog("checkAudioCapabilitySupport params not valid, capabilityType: " + capabilityType);
        return 0;
    }

    @Override
    public void setRemoteAudioParallelParams(TRTCCloudDef.TRTCAudioParallelParams params) {
        this.apiLog("setRemoteAudioParallelParams max_count : " + params.maxCount);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < params.includeUsers.size(); ++i2) {
            TRTCRoomInfo.UserInfo userInfo = this.mRoomInfo.getUser(params.includeUsers.get(i2));
            if (userInfo != null) {
                arrayList.add(String.valueOf(userInfo.tinyID));
                continue;
            }
            this.apiLog("setRemoteAudioParallelParams params no user : " + params.includeUsers.get(i2));
        }
        TXCAudioEngine.getInstance().setRemoteAudioParallel(arrayList, params.maxCount);
    }

    @Override
    public void switchCamera() {
        this.mDeviceManager.switchCamera(!this.mDeviceManager.isFrontCamera());
    }

    @Override
    public boolean isCameraZoomSupported() {
        return this.mCaptureAndEnc.n();
    }

    @Override
    public void setZoom(int distance) {
        this.mDeviceManager.setCameraZoomRatio(distance);
    }

    @Override
    public boolean isCameraTorchSupported() {
        return this.mCaptureAndEnc.o();
    }

    @Override
    public boolean enableTorch(boolean enable) {
        return this.mDeviceManager.enableCameraTorch(enable);
    }

    @Override
    public boolean isCameraFocusPositionInPreviewSupported() {
        return this.mCaptureAndEnc.p();
    }

    @Override
    public void setFocusPosition(int x2, int y2) {
        this.mDeviceManager.setCameraFocusPosition(x2, y2);
    }

    @Override
    public boolean isCameraAutoFocusFaceModeSupported() {
        return this.mCaptureAndEnc.q();
    }

    @Override
    public TXBeautyManager getBeautyManager() {
        if (this.mCaptureAndEnc == null) {
            this.mCaptureAndEnc = new d(this.mContext);
        }
        return this.mCaptureAndEnc.b();
    }

    @Override
    public void setBeautyStyle(final int style, final int beauty, final int white, final int ruddiness) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.getBeautyManager().setBeautyStyle(style);
                TRTCCloudImpl.this.getBeautyManager().setBeautyLevel(beauty);
                TRTCCloudImpl.this.getBeautyManager().setWhitenessLevel(white);
                TRTCCloudImpl.this.getBeautyManager().setRuddyLevel(ruddiness);
            }
        });
    }

    @Override
    public void setFilter(final Bitmap bmp) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setFilter");
                TRTCCloudImpl.this.getBeautyManager().setFilter(bmp);
            }
        });
    }

    @Override
    public void setFilterConcentration(final float concentration) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setFilterStrength: " + concentration);
                TRTCCloudImpl.this.getBeautyManager().setFilterStrength(concentration);
            }
        });
    }

    @Override
    public void selectMotionTmpl(final String motionPath) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("selectMotionTmpl " + motionPath);
                TRTCCloudImpl.this.getBeautyManager().setMotionTmpl(motionPath);
            }
        });
    }

    @Override
    public void setMotionMute(final boolean motionMute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setMotionMute " + motionMute);
                TRTCCloudImpl.this.getBeautyManager().setMotionMute(motionMute);
            }
        });
    }

    @Override
    @TargetApi(value=18)
    public boolean setGreenScreenFile(final String file) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setGreenScreenFile " + file);
                TRTCCloudImpl.this.getBeautyManager().setGreenScreenFile(file);
            }
        });
        return true;
    }

    @Override
    public void setEyeScaleLevel(final int eyeScaleLevel) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setEyeScaleLevel " + eyeScaleLevel);
                TRTCCloudImpl.this.getBeautyManager().setEyeScaleLevel(eyeScaleLevel);
            }
        });
    }

    @Override
    public void setFaceSlimLevel(final int faceScaleLevel) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setFaceSlimLevel " + faceScaleLevel);
                TRTCCloudImpl.this.getBeautyManager().setFaceSlimLevel(faceScaleLevel);
            }
        });
    }

    @Override
    public void setFaceVLevel(final int faceVLevel) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setFaceVLevel " + faceVLevel);
                TRTCCloudImpl.this.getBeautyManager().setFaceVLevel(faceVLevel);
            }
        });
    }

    @Override
    public void setFaceShortLevel(final int faceShortlevel) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setFaceShortLevel " + faceShortlevel);
                TRTCCloudImpl.this.getBeautyManager().setFaceShortLevel(faceShortlevel);
            }
        });
    }

    @Override
    public void setChinLevel(final int chinLevel) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setChinLevel " + chinLevel);
                TRTCCloudImpl.this.getBeautyManager().setChinLevel(chinLevel);
            }
        });
    }

    @Override
    public void setNoseSlimLevel(final int noseSlimLevel) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setNoseSlimLevel " + noseSlimLevel);
                TRTCCloudImpl.this.getBeautyManager().setNoseSlimLevel(noseSlimLevel);
            }
        });
    }

    @Override
    public void setWatermark(final Bitmap image, final int streamType, final float x2, final float y2, final float width) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("addWatermark stream:" + streamType);
                if (streamType != 2) {
                    TRTCCloudImpl.this.mConfig.H = image;
                    TRTCCloudImpl.this.mConfig.K = x2;
                    TRTCCloudImpl.this.mConfig.L = y2;
                    TRTCCloudImpl.this.mConfig.M = width;
                    TRTCCloudImpl.this.mCaptureAndEnc.a(image, x2, y2, width);
                }
            }
        });
    }

    @Override
    public void enableCustomVideoCapture(final int streamType, final boolean enable) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (streamType == 2) {
                    TRTCCloudImpl.this.enableSubStreamCustomCapture(enable);
                } else {
                    TRTCCloudImpl.this.enableMainStreamCustomCapture(enable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableMainStreamCustomCapture(boolean enable) {
        if (enable && this.mMainStreamVideoSourceType != VideoSourceType.NONE) {
            this.notifyCaptureStarted("Has started capturing, ignore enableCustomVideoCapture");
            this.apiLog("Has started capturing, ignore enableCustomVideoCapture");
            return;
        }
        if (!enable && this.mMainStreamVideoSourceType != VideoSourceType.CUSTOM) {
            this.apiLog("Has not started capturing, ignore disableCustomVideoCapture");
            return;
        }
        this.setStartVideoEncodeCodec();
        VideoSourceType videoSourceType = this.mMainStreamVideoSourceType = enable ? VideoSourceType.CUSTOM : VideoSourceType.NONE;
        if (enable) {
            this.mConfig.U |= 2;
            if (this.mCurrentRole == 21) {
                this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                        if (tRTCCloudListener == null) {
                            return;
                        }
                        tRTCCloudListener.onWarning(6001, "ignore send custom video,for role audience", null);
                    }
                });
                this.apiLog("ignore enableCustomVideoCapture,for role audience");
            }
        } else {
            this.mConfig.U &= 0xFFFFFFFD;
            Object object = this.mCustomCaptureLock;
            synchronized (object) {
                if (this.mCustomVideoUtil != null) {
                    this.mCustomVideoUtil.release();
                    this.mCustomVideoUtil = null;
                }
            }
        }
        this.mCaptureAndEnc.a(this.mConfig);
        this.mEnableCustomVideoCapture = enable;
        this.apiOnlineLog("enableMainStreamCustomCapture " + enable);
        if (enable) {
            this.enableVideoStream(0, true);
        } else if (!this.mIsVideoCapturing) {
            this.enableVideoStream(0, false);
        }
        TXCKeyPointReportProxy.a(40046, enable ? 1 : 0, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableSubStreamCustomCapture(boolean enable) {
        if (enable && this.mSubStreamVideoSourceType != VideoSourceType.NONE) {
            this.notifyCaptureStarted("Has started capturing, ignore enableCustomVideoCapture");
            this.apiLog("Has started capturing, ignore enableCustomVideoCapture");
            return;
        }
        if (!enable && this.mSubStreamVideoSourceType != VideoSourceType.CUSTOM) {
            this.apiLog("Has not started capturing, ignore disableCustomVideoCapture");
            return;
        }
        VideoSourceType videoSourceType = this.mSubStreamVideoSourceType = enable ? VideoSourceType.CUSTOM : VideoSourceType.NONE;
        if (enable) {
            if (this.mCurrentRole == 21) {
                this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                        if (tRTCCloudListener == null) {
                            return;
                        }
                        tRTCCloudListener.onWarning(6001, "ignore send custom video,for role audience", null);
                    }
                });
                this.apiLog("ignore enableCustomVideoCapture,for role audience");
            }
        } else {
            Object object = this.mCustomCaptureLock;
            synchronized (object) {
                if (this.mCustomSubStreamVideoUtil != null) {
                    this.mCustomSubStreamVideoUtil.release();
                    this.mCustomSubStreamVideoUtil = null;
                }
            }
        }
        this.apiOnlineLog("enableSubStreamCustomCapture enable:%b", enable);
        if (enable) {
            this.addUpStreamType(7);
        } else {
            this.removeUpStreamType(7);
        }
        TXCKeyPointReportProxy.a(40046, enable ? 1 : 0, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureSubStreamCaptureCreated() {
        Object object = this.mCustomCaptureLock;
        synchronized (object) {
            if (this.mSubStreamCaptureAndEnc == null) {
                this.mSubStreamCaptureAndEnc = this.createCaptureAndEnc(7, this.mSubStreamConfig);
                this.mSubStreamCaptureAndEnc.f();
            }
        }
    }

    private d createCaptureAndEnc(int streamType, g config) {
        d d2 = new d(this.mContext);
        d2.k(streamType);
        d2.a(config);
        d2.j(true);
        d2.h(this.isRPSSupported());
        d2.a(this);
        d2.a(this);
        d2.setID("18446744073709551615");
        d2.i(true);
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMainStreamCustomVideoData(TRTCCloudDef.TRTCVideoFrame frame) {
        if (this.mMainStreamVideoSourceType != VideoSourceType.CUSTOM || this.mRoomInfo.muteLocalVideo) {
            return;
        }
        Object object = this.mCustomCaptureLock;
        synchronized (object) {
            if (this.mCustomVideoUtil == null) {
                this.mCustomVideoUtil = new TRTCCustomTextureUtil(this.mCaptureAndEnc, this.mCustomCaptureGLSyncMode);
            }
            if (this.mCustomVideoUtil != null) {
                this.mCustomVideoUtil.sendCustomTexture(frame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSubStreamCustomVideoData(TRTCCloudDef.TRTCVideoFrame frame) {
        if (this.mSubStreamVideoSourceType != VideoSourceType.CUSTOM || this.mRoomInfo.muteLocalSubVideo) {
            return;
        }
        Object object = this.mCustomCaptureLock;
        synchronized (object) {
            if (this.mCustomSubStreamVideoUtil == null) {
                this.makeSureSubStreamCaptureCreated();
                this.mCustomSubStreamVideoUtil = new TRTCCustomTextureUtil(this.mSubStreamCaptureAndEnc, this.mCustomCaptureGLSyncMode);
            }
            if (this.mCustomSubStreamVideoUtil != null) {
                this.mCustomSubStreamVideoUtil.sendCustomTexture(frame);
            }
        }
    }

    @Override
    public void sendCustomVideoData(int streamType, TRTCCloudDef.TRTCVideoFrame frame) {
        if (frame == null) {
            this.apiLog("sendCustomVideoData parameter is null");
            return;
        }
        if (frame.pixelFormat != 1 && frame.pixelFormat != 4 && frame.pixelFormat != 2) {
            this.apiLog("sendCustomVideoData parameter error unsupported pixel format " + frame.pixelFormat);
            return;
        }
        if (frame.bufferType != 2 && frame.texture == null) {
            this.apiLog("sendCustomVideoData parameter error unsupported buffer type " + frame.bufferType);
            return;
        }
        if (streamType == 0) {
            this.sendMainStreamCustomVideoData(frame);
        } else {
            this.sendSubStreamCustomVideoData(frame);
        }
    }

    @Override
    public void enableCustomVideoCapture(boolean enable) {
        this.enableCustomVideoCapture(0, enable);
    }

    @Override
    public void sendCustomVideoData(TRTCCloudDef.TRTCVideoFrame frame) {
        this.sendCustomVideoData(0, frame);
    }

    private void setStartVideoEncodeCodec() {
        if (this.mCaptureAndEnc != null) {
            boolean bl = this.mH265Decision.isVideoEncoderStartCodecUsingH265();
            this.mCaptureAndEnc.k(bl);
        }
    }

    private void enableBlackStream(JSONObject params) throws JSONException {
        if (params == null || !params.has("enable")) {
            this.apiLog("callExperimentalAPI[lack parameter or illegal type]: enable");
            return;
        }
        boolean bl = params.getBoolean("enable");
        this.apiLog("enableBlackStream " + bl);
        this.enableNetworkBlackStream(bl);
        if (this.mCaptureAndEnc != null) {
            this.mCaptureAndEnc.c(bl);
        }
        if (bl) {
            this.addUpstream(2);
        }
    }

    protected void setSEIPayloadType(JSONObject params) throws JSONException {
        if (params == null || !params.has("payloadType")) {
            this.apiLog("callExperimentalAPI[lack parameter or illegal type]: payloadType");
            return;
        }
        int n2 = params.getInt("payloadType");
        if (n2 != 5 && n2 != 243 && n2 != 242) {
            this.apiLog("callExperimentalAPI[invalid param]: payloadType[" + n2 + "]");
            return;
        }
        if (this.nativeSetSEIPayloadType(this.mNativeRtcContext, n2)) {
            this.apiLog("callExperimentalAPI[succeeded]: setSEIPayloadType (" + n2 + ")");
        } else {
            this.apiLog("callExperimentalAPI[failed]: setSEIPayloadType (" + n2 + ")");
        }
    }

    private void updateMainStreamEncoder(boolean portrait, int width, int height, int fps, int targetBitrate, boolean isAdjustRes, int minBitrate, boolean setByAPI) {
        if (width > 0 && height > 0) {
            this.mRoomInfo.bigEncSize.a = width;
            this.mRoomInfo.bigEncSize.b = height;
        }
        this.updateEncoder(this.mConfig, this.mMainStreamVideoSourceType, 2, portrait, this.mRoomInfo.bigEncSize.a, this.mRoomInfo.bigEncSize.b, fps, targetBitrate, isAdjustRes, minBitrate, setByAPI);
        this.mCaptureAndEnc.f(this.mConfig.k);
        this.mCaptureAndEnc.d(this.mConfig.e);
        this.mCaptureAndEnc.a(this.mConfig);
    }

    private void updateEncoder(g config, VideoSourceType sourceType, int streamType, boolean portrait, int width, int height, int fps, int targetBitrate, boolean isAdjustRes, int minBitrate, boolean setByAPI) {
        if (sourceType == VideoSourceType.SCREEN) {
            config.o = 1;
            config.a = width;
            config.b = height;
        } else if (portrait) {
            config.o = 1;
            config.a = width;
            config.b = height;
        } else {
            config.o = 0;
            config.a = height;
            config.b = width;
        }
        config.n = c.a;
        if (fps > 0) {
            if (fps > 30) {
                this.apiLog("setVideoEncoderParam fps > 30, limit fps to 30");
                config.k = 30;
            } else {
                config.k = fps;
            }
        }
        if (targetBitrate > 0) {
            config.e = targetBitrate;
        }
        if (minBitrate >= 0) {
            config.g = minBitrate;
        }
        if (sourceType == VideoSourceType.SCREEN) {
            config.l = 3;
            config.s = false;
            if (this.mOverrideFPSFromUser) {
                config.k = 10;
            }
        } else {
            config.s = isAdjustRes;
        }
        this.setVideoEncConfig(streamType, width, height, config.k, config.e, config.s, config.g, setByAPI);
        if (this.mCodecType == 2 && config.a * config.b >= 518400) {
            config.m = 1;
        }
    }

    private void updateSmallStreamEncoder(int width, int height, int fps, int bitrate, int minBitrate) {
        if (width > 0 && height > 0) {
            this.mRoomInfo.smallEncSize.a = width;
            this.mRoomInfo.smallEncSize.b = height;
        }
        if (fps > 0) {
            if (fps > 20) {
                this.apiLog("setVideoSmallEncoderParam fps > 20, limit fps to 20");
                this.mSmallEncParam.videoFps = 20;
            } else {
                this.mSmallEncParam.videoFps = fps;
            }
        }
        if (bitrate > 0) {
            this.mSmallEncParam.videoBitrate = bitrate;
        }
        if (minBitrate >= 0) {
            this.mSmallEncParam.minVideoBitrate = minBitrate;
        }
        int n2 = this.mConfig.l;
        if (this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
            this.mSmallEncParam.enableAdjustRes = false;
            n2 = 3;
            if (this.mOverrideFPSFromUser) {
                this.mSmallEncParam.videoFps = 10;
            }
        }
        this.mCaptureAndEnc.a(this.mEnableSmallStream, this.mRoomInfo.smallEncSize.a, this.mRoomInfo.smallEncSize.b, this.mSmallEncParam.videoFps, this.mSmallEncParam.videoBitrate, n2);
        this.setVideoEncConfig(3, this.mRoomInfo.smallEncSize.a, this.mRoomInfo.smallEncSize.b, this.mSmallEncParam.videoFps, this.mSmallEncParam.videoBitrate, this.mConfig.s, this.mSmallEncParam.minVideoBitrate, false);
    }

    private void setVideoEncoderParamEx(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("callExperimentalAPI[lack parameter or illegal type]: codecType");
            return;
        }
        int n2 = params.optInt("codecType", -1);
        if (n2 != -1) {
            JSONObject jSONObject;
            this.mCodecType = n2;
            if (this.mCodecType == 0 && (jSONObject = params.optJSONObject("softwareCodecParams")) != null) {
                this.mConfig.S = jSONObject.optInt("enableRealTime") != 0;
                this.mConfig.q = jSONObject.optInt("profile");
            }
        }
        int n3 = params.optInt("videoWidth", 0);
        int n4 = params.optInt("videoHeight", 0);
        int n5 = params.optInt("videoFps", 0);
        int n6 = params.optInt("videoBitrate", 0);
        int n7 = params.optInt("minVideoBitrate", 0);
        int n8 = params.optInt("rcMethod", 0);
        if (n3 > 0 && n4 > 0) {
            if (n3 > 1920) {
                n3 = 1920;
                n4 = 1920 * n4 / n3;
            }
            if (n4 > 1920) {
                n4 = 1920;
                n3 = 1920 * n3 / n4;
            }
            if (n3 < 90) {
                n3 = 90;
                n4 = 90 * n4 / n3;
            }
            if (n4 < 90) {
                n4 = 90;
                n3 = 90 * n3 / n4;
            }
            n3 = (n3 + 15) / 16 * 16;
            n4 = (n4 + 15) / 16 * 16;
            int n9 = params.optInt("streamType", 0);
            if (n9 == 0) {
                this.mConfig.j = true;
                this.mLatestParamsOfBigEncoder.putInt(KEY_CONFIG_FPS, n5);
                this.updateMainStreamEncoder(n3 <= n4, n3, n4, n5, n6, this.mConfig.s, n7, this.mConfig.j);
                this.mCaptureAndEnc.o(n8);
            } else if (n9 == 1) {
                this.mLatestParamsOfSmallEncoder.putInt(KEY_CONFIG_FPS, n5);
                this.updateSmallStreamEncoder(n3, n4, n5, n6, n7);
            } else if (n9 == 2) {
                this.mLatestParamsOfSubEncoder.putInt(KEY_CONFIG_FPS, n5);
                this.updateSubStreamEncoder(n3 <= n4, n3, n4, n5, n6, this.mSubStreamConfig.s, n7, this.mSubStreamConfig.j);
            }
            this.apiLog("vsize setVideoEncoderParamEx->width:" + this.mRoomInfo.bigEncSize.a + ", height:" + this.mRoomInfo.bigEncSize.b + ", fps:" + n5 + ", bitrate:" + n6 + ", stream:" + n9);
            this.updateOrientation();
        }
    }

    private void setLocalAudioMuteMode(JSONObject params) throws JSONException {
        int n2;
        if (params == null || !params.has("mode")) {
            this.apiLog("setLocalAudioMuteMode[lack parameter or illegal type]: mode");
        }
        this.mEnableEosMode = 1 == (n2 = params.getInt("mode"));
        TXCAudioEngine.getInstance().enableCaptureEOSMode(this.mEnableEosMode);
        this.nativeSetLocalAudioMuteMode(this.getNetworkContext(), n2);
    }

    private void setAudioSampleRate(JSONObject params) throws JSONException {
        if (params == null || !params.has("sampleRate")) {
            this.apiLog("setAudioSampleRate[lack parameter or illegal type]: sampleRate");
            return;
        }
        int n2 = params.getInt("sampleRate");
        if (this.mEnableCustomAudioCapture || this.mIsAudioCapturing) {
            this.apiLog("setAudioSampleRate[illegal state]");
            return;
        }
        if (16000 != n2 && 48000 != n2) {
            this.apiLog("muteRemoteAudioInSpeaker[illegal sampleRate]: " + n2);
            return;
        }
        TXCAudioEngine.getInstance().setEncoderSampleRate(n2);
    }

    private void enableAudioAGC(JSONObject params) throws JSONException {
        if (params == null || !params.has("enable")) {
            this.apiLog("enableAudioAGC[lack parameter or illegal type]: enable");
            return;
        }
        int n2 = params.getInt("enable");
        this.mEnableSoftAGC = 0 != n2;
        this.mSoftAGCLevel = params.has("level") ? params.getInt("level") : 100;
        TXCAudioEngine.getInstance().enableSoftAGC(this.mEnableSoftAGC, this.mSoftAGCLevel);
    }

    private void enableAudioAEC(JSONObject params) throws JSONException {
        if (params == null || !params.has("enable")) {
            this.apiLog("enableAudioAEC[lack parameter or illegal type]: enable");
            return;
        }
        int n2 = params.getInt("enable");
        this.mEnableSoftAEC = 0 != n2;
        this.mSoftAECLevel = params.has("level") ? params.getInt("level") : 100;
        TXCAudioEngine.getInstance().enableSoftAEC(this.mEnableSoftAEC, this.mSoftAECLevel);
    }

    private void enableAudioANS(JSONObject params) throws JSONException {
        if (params == null || !params.has("enable")) {
            this.apiLog("enableAudioANS[lack parameter or illegal type]: enable");
            return;
        }
        int n2 = params.getInt("enable");
        this.mEnableSoftANS = 0 != n2;
        this.mSoftANSLevel = params.has("level") ? params.getInt("level") : 100;
        TXCAudioEngine.getInstance().enableSoftANS(this.mEnableSoftANS, this.mSoftANSLevel);
    }

    protected void setPerformanceMode(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setPerformanceMode[lack parameter]");
            return;
        }
        if (!params.has("mode")) {
            this.apiLog("setPerformanceMode[lack parameter]: mode");
            return;
        }
        int n2 = params.getInt("mode");
        if (n2 == 1) {
            this.mPerformanceMode = 1;
            this.mCaptureAndEnc.b().enableSharpnessEnhancement(false);
            TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(2);
            if (tRTCCloudImpl != null) {
                long l2 = tRTCCloudImpl.getNetworkContext();
                this.nativeSetAllowSwitchToHighPerformanceMode(l2, true);
            }
        } else if (n2 == 2) {
            TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(2);
            if (tRTCCloudImpl != null) {
                long l3 = tRTCCloudImpl.getNetworkContext();
                this.nativeSetAllowSwitchToHighPerformanceMode(l3, false);
            }
        } else {
            this.mPerformanceMode = 0;
            TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(2);
            if (tRTCCloudImpl != null) {
                long l4 = tRTCCloudImpl.getNetworkContext();
                this.nativeSetAllowSwitchToHighPerformanceMode(l4, true);
            }
        }
    }

    protected void muteRemoteAudioInSpeaker(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("muteRemoteAudioInSpeaker[lack parameter]");
            return;
        }
        if (!params.has("userID")) {
            this.apiLog("muteRemoteAudioInSpeaker[lack parameter]: userID");
            return;
        }
        String string = params.getString("userID");
        if (string == null) {
            this.apiLog("muteRemoteAudioInSpeaker[illegal type]: userID");
            return;
        }
        if (!params.has("mute")) {
            this.apiLog("muteRemoteAudioInSpeaker[lack parameter]: mute");
            return;
        }
        int n2 = params.getInt("mute");
        TRTCRoomInfo.UserInfo userInfo = this.mRoomInfo.getUser(string);
        if (userInfo == null) {
            this.apiLog("muteRemoteAudioInSpeaker " + string + " no exist, create one.");
            TRTCRoomInfo.UserInfo userInfo2 = this.createUserInfo(string);
            userInfo2.muteAudioInSpeaker = n2 == 1;
            this.mRoomInfo.addUserInfo(string, userInfo2);
            return;
        }
        if (userInfo != null) {
            TXCAudioEngine.getInstance().muteRemoteAudioInSpeaker(String.valueOf(userInfo.tinyID), n2 == 1);
        } else {
            this.apiLog("muteRemoteAudioInSpeaker[illegal type]: userID");
        }
    }

    private void setCustomRenderMode(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setCustomRenderMode param is null");
            return;
        }
        if (!params.has("mode")) {
            this.apiLog("setCustomRenderMode[lack parameter]: mode");
            return;
        }
        int n2 = params.optInt("mode", 0);
        this.mRoomInfo.enableCustomPreprocessor = n2 == 1;
        this.mCaptureAndEnc.a(this.mRoomInfo.enableCustomPreprocessor);
    }

    private void setMediaCodecConfig(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setMediaCodecConfig param is null");
            return;
        }
        JSONArray jSONArray = null;
        if (params.has("encProperties")) {
            jSONArray = params.getJSONArray("encProperties");
        }
        this.mConfig.ab = jSONArray;
        this.mCaptureAndEnc.a(this.mConfig);
        JSONArray jSONArray2 = null;
        if (params.has("decProperties")) {
            jSONArray2 = params.getJSONArray("decProperties");
        }
        this.mRoomInfo.decProperties = jSONArray2;
        int n2 = 0;
        if (params.has("restartDecoder")) {
            n2 = params.getInt("restartDecoder");
        }
        this.mRoomInfo.enableRestartDecoder = n2 != 0;
    }

    public void setRemoteSurface(final String userId, final int streamType, final Surface surface) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setRemoteSurface " + userId + ", " + surface);
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCRenderAndDec tXCRenderAndDec;
                    TXCRenderAndDec tXCRenderAndDec2 = tXCRenderAndDec = streamType == 2 ? userInfo.subRender.render : userInfo.mainRender.render;
                    if (tXCRenderAndDec != null) {
                        e e2 = tXCRenderAndDec.getVideoRender();
                        if (e2 != null) {
                            e2.a(surface);
                        } else {
                            TRTCCloudImpl.this.apiLog("videoRender no exist");
                        }
                    } else {
                        TRTCCloudImpl.this.apiLog("render no exist");
                    }
                } else {
                    TRTCCloudImpl.this.apiLog("user no exist");
                }
            }
        });
    }

    public void setRemoteSurfaceSize(final String userId, final int streamType, final int width, final int height) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setRemoteSurfaceSize: " + userId + ", " + width + "," + height);
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCRenderAndDec tXCRenderAndDec;
                    TXCRenderAndDec tXCRenderAndDec2 = tXCRenderAndDec = streamType == 2 ? userInfo.subRender.render : userInfo.mainRender.render;
                    if (tXCRenderAndDec != null) {
                        e e2 = tXCRenderAndDec.getVideoRender();
                        if (e2 != null) {
                            e2.d(width, height);
                        } else {
                            TRTCCloudImpl.this.apiLog("videoRender no exist");
                        }
                    } else {
                        TRTCCloudImpl.this.apiLog("render no exist");
                    }
                } else {
                    TRTCCloudImpl.this.apiLog("user no exist");
                }
            }
        });
    }

    public void setLocalSurface(final Surface surface) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setLocalSurface " + surface);
                TRTCCloudImpl.this.mCaptureAndEnc.a(surface);
            }
        });
    }

    public void setLocalSurfaceSize(final int width, final int height) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setLocalSurfaceSize: " + width + "," + height);
                TRTCCloudImpl.this.mCaptureAndEnc.a(width, height);
            }
        });
    }

    protected void setFramework(JSONObject params) throws JSONException {
        int n2;
        if (params == null) {
            this.apiLog("setFramework[lack parameter]");
            return;
        }
        if (!params.has("framework") && !params.has("component")) {
            this.apiLog("setFramework[lack parameter]: framework or component");
            return;
        }
        int n3 = params.optInt("framework", 0);
        if (n3 > 0) {
            this.mFramework = n3;
        }
        if ((n2 = params.optInt("component", 0)) > 0) {
            this.mComponent = n2;
        }
    }

    private void forceCallbackMixedPlayAudioFrame(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("forceCallbackMixedPlayAudioFrame param is null");
            return;
        }
        if (!params.has("enable")) {
            this.apiLog("forceCallbackMixedPlayAudioFrame[lack parameter]: enable");
            return;
        }
        int n2 = params.optInt("enable", 0);
        TXCAudioEngine.getInstance().forceCallbackMixedPlayAudioFrame(n2 != 0);
    }

    private void setKeepAVCaptureOption(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setKeepAVCaptureOption param is null");
            return;
        }
        this.mKeepAVCaptureWhenEnterRoomFailed = params.optInt("keepWhenEnterRoomFailed", 0) != 0;
        this.apiLog("setKeepAVCaptureOption " + this.mKeepAVCaptureWhenEnterRoomFailed);
    }

    private void setEnableH265Encoder(JSONObject params) {
        if (params == null) {
            this.apiLog("setEnableH265Encoder param is null");
            return;
        }
        if (params.has("enable")) {
            int n2 = params.optInt("enable", 0);
            this.mH265Decision.setEnableH265EncodeByPrivateAPI(n2 != 0);
            if (this.mCaptureAndEnc != null && this.mAppScene == 1) {
                boolean bl = this.mH265Decision.isVideoEncoderCodecUsingH265();
                TXCLog.i(TAG, "enableH265 = " + bl + " ,mRoomState= " + this.mRoomState);
                this.mCaptureAndEnc.k(bl);
            }
        }
    }

    private void setCustomCaptureGLSyncMode(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("callExperimentalAPI[setCustomCaptureGLMode failed, params is null");
            return;
        }
        this.mCustomCaptureGLSyncMode = params.optInt("mode", 0);
        this.apiLog("setCustomCaptureGLMode: mode:" + this.mCustomCaptureGLSyncMode);
    }

    private void setLocalAudioMuteAction(JSONObject params) {
        if (params == null) {
            this.apiLog("setLocalAudioMuteAction param is null");
            return;
        }
        int n2 = -1;
        int n3 = -1;
        if (params.has("volumeEvaluation")) {
            n2 = params.optInt("volumeEvaluation", -1);
        }
        if (params.has("muteCapturedAudioFrameAfterCallback")) {
            n3 = params.optInt("muteCapturedAudioFrameAfterCallback", -1);
        }
        TXCAudioEngine.getInstance().setLocalAudioMuteAction(n2, n3);
    }

    protected void checkDuplicateEnterRoom(JSONObject params) {
        if (params == null) {
            this.apiLog("checkDuplicateEnterRoom param is null");
            return;
        }
        if (params.has("check")) {
            this.mCheckDuplicateEnterRoom = params.optInt("check", 0);
        }
    }

    protected void setAudioCacheType(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setAudioCacheType param is null");
            return;
        }
        if (!params.has("type")) {
            this.apiLog("setAudioCacheType[lack parameter]: type");
            return;
        }
        int n2 = params.optInt("type", 0);
        this.nativeSetAudioCacheType(this.mNativeRtcContext, n2);
        this.apiLog("setAudioCacheType: type " + n2);
    }

    protected void muteDuringAECWarmUp(JSONObject params) {
        if (params == null || !params.has("enabled")) {
            this.apiLog("muteDuringAECWarmUp without params.");
            return;
        }
        boolean bl = params.optInt("enabled", 1) > 0;
        this.nativeSetAECMuteDataEnabled(this.mNativeRtcContext, bl);
        this.apiLog("muteDuringAECWarmUp enabled: " + bl);
    }

    protected void setReverbParam(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setReverbParam param is null");
            return;
        }
        TXCAudioEngine.getInstance().setReverbType(255);
        Iterator iterator = params.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            double d2 = params.getDouble(string);
            if (!this.reverbParamKeyNames.contains(string)) continue;
            int n2 = this.reverbParamKeyNames.indexOf(string);
            TXCAudioEngine.getInstance().setReverbParamType(n2, (float)d2);
        }
    }

    protected void setEqualizationParam(JSONObject params) throws JSONException {
        if (params == null || !params.has("equalization_type")) {
            this.apiLog("setEqualizationParam[lack parameter]: equalization_type");
            return;
        }
        int n2 = params.optInt("equalization_type", 0);
        if (n2 < 0 || n2 > 11) {
            this.apiLog("setEqualizationParam[illegal value]: equalization_type" + n2);
            return;
        }
        int[] nArray = new int[10];
        if (n2 == 11) {
            if (!params.has("gain") || params.getJSONArray("gain").length() != 10) {
                this.apiLog("setEqualizationParam[illegal parameter]: gain");
                return;
            }
            JSONArray jSONArray = params.getJSONArray("gain");
            for (int i2 = 0; i2 < 10; ++i2) {
                nArray[i2] = jSONArray.getInt(i2);
            }
        }
        TXCAudioEngine.getInstance().setCaptureEqualizationType(n2);
        if (n2 == 11) {
            for (int i3 = 0; i3 < 10; ++i3) {
                TXCAudioEngine.getInstance().setCaptureEqualizationParam(i3, nArray[i3]);
            }
        }
    }

    private void setScreenCaptureCropRect(JSONObject params) {
        int n2 = params.optInt("x", 0);
        int n3 = params.optInt("y", 0);
        int n4 = params.optInt("w", 0);
        int n5 = params.optInt("h", 0);
        this.apiLog("setScreenCaptureCropRect [%d,%d,%d,%d]", n2, n3, n4, n5);
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
            this.apiLog("clear screen capture crop rect");
            this.mCaptureAndEnc.a((com.tencent.liteav.basic.opengl.a)null);
            if (this.mSubStreamCaptureAndEnc != null) {
                this.mSubStreamCaptureAndEnc.a((com.tencent.liteav.basic.opengl.a)null);
            }
            return;
        }
        if (n2 < 0 || n3 < 0 || n4 <= 0 || n5 <= 0) {
            return;
        }
        this.mCaptureAndEnc.a(new com.tencent.liteav.basic.opengl.a(n2, n3, n4, n5));
        if (this.mSubStreamCaptureAndEnc != null) {
            this.mSubStreamCaptureAndEnc.a(new com.tencent.liteav.basic.opengl.a(n2, n3, n4, n5));
        }
    }

    protected void setQoSStrategy(JSONObject params) throws JSONException {
        int n2;
        if (params == null) {
            this.apiLog("setQoSStrategy param is null");
            return;
        }
        if (!params.has("strategy")) {
            this.apiLog("setQoSStrategy[lack parameter]: strategy");
            return;
        }
        this.mQoSStrategy = n2 = params.optInt("strategy", 0);
    }

    private void setHeartBeatTimeoutSec(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setHeartBeatTimeoutSec param is null");
            return;
        }
        if (!params.has("timeoutSec")) {
            this.apiLog("setHeartBeatTimeoutSec[lack parameter]: timeoutSec");
            return;
        }
        int n2 = params.optInt("timeoutSec", 0);
        this.nativeSetHeartBeatTimeoutSec(this.mNativeRtcContext, n2);
    }

    private void setAVSyncPlaySources(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setAVSyncPlaySources param is null");
            return;
        }
        if (!params.has("audioSourceUserID")) {
            this.apiLog("setAVSyncPlaySources[lack parameter]: audioSourceUserID");
            return;
        }
        if (!params.has("videoSourceUserID")) {
            this.apiLog("setAVSyncPlaySources[lack parameter]: videoSourceUserID");
            return;
        }
        String string = params.getString("audioSourceUserID");
        if (string == null) {
            this.apiLog("setAVSyncPlaySources[illegal type]: audioSourceUserID");
            return;
        }
        String string2 = params.getString("videoSourceUserID");
        if (string2 == null) {
            this.apiLog("setAVSyncPlaySources[illegal type]: videoSourceUserID");
            return;
        }
        this.nativeSetAVSyncPlaySources(this.mNativeRtcContext, string, string2);
    }

    private void enableRealtimeChorus(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("enableRealtimeChorus param is null");
            return;
        }
        if (!params.has("enable")) {
            this.apiLog("enableRealtimeChorus[lack parameter]: enable");
            return;
        }
        int n2 = params.optInt("enable", 0);
        this.mEnableLowLatencyMode = n2 == 1;
        this.nativeEnableLowLatencyMode(this.mNativeRtcContext, n2 == 1);
    }

    private void preloadMusic(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("preLoadMusic param is null");
            return;
        }
        if (!params.has("musicId")) {
            this.apiLog("preLoadMusic[lack parameter]: musicId");
            return;
        }
        if (!params.has("path")) {
            this.apiLog("preLoadMusic[lack parameter]: path");
            return;
        }
        int n2 = params.optInt("musicId", 0);
        String string = params.optString("path", "");
        long l2 = params.optLong("startTimeMS", 0L);
        TXAudioEffectManager.AudioMusicParam audioMusicParam = new TXAudioEffectManager.AudioMusicParam(n2, string);
        audioMusicParam.startTimeMS = l2;
        TXAudioEffectManagerImpl.getAutoCacheHolder().preloadMusic(audioMusicParam);
    }

    private void setNetEnv(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setNetEnv param is null");
            return;
        }
        if (!params.has("env")) {
            this.apiLog("setNetEnv[lack parameter]: env");
            return;
        }
        int n2 = params.optInt("env", 0);
        this.nativeSetNetEnv(this.mNativeRtcContext, n2);
    }

    private void addCustomMonitorEvent(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("addCustomMonitorEvent param is null");
            return;
        }
        if (!params.has("jsonParam") || !params.has("eventId")) {
            this.apiLog("addCustomMonitorEvent[lack parameter]: jsonParam or eventId");
            return;
        }
        int n2 = params.optInt("eventId", 0);
        if (n2 != 100000) {
            this.apiLog("addCustomMonitorEvent[illegal parameter]: eventId");
            return;
        }
        String string = params.optString("jsonParam", "");
        TXCEventRecorderProxy.a("18446744073709551615", 100000, -1L, -1L, string, 0);
    }

    private void setAudioQualityEx(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setAudioQualityEx param is null");
            return;
        }
        int n2 = params.optInt("sampleRate", 0);
        int n3 = params.optInt("channel", 0);
        int n4 = params.optInt("bitrate", -1);
        int n5 = params.optInt("encodeMode", 0);
        int n6 = params.optInt("systemVolumeType", -1);
        TXCAudioEngine.getInstance().setAudioQuality(n2, n3, n4, n5, n6, 4);
        if (this.mIsAudioCapturing || this.mEnableCustomAudioCapture) {
            this.setQoSParams();
        }
    }

    protected void setRoomType(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("setRoomType param is null");
            return;
        }
        if (!params.has("type")) {
            this.apiLog("setRoomType[lack parameter]: type");
            return;
        }
        this.mRoomType = params.optInt("type", 0);
    }

    @Override
    public void callExperimentalAPI(String jsonStr) {
        String string3;
        JSONObject jSONObject = null;
        String string2 = "";
        JSONObject jSONObject2 = null;
        try {
            jSONObject = new JSONObject(jsonStr);
            if (!jSONObject.has("api")) {
                this.apiLog("callExperimentalAPI[lack api or illegal type]: " + jsonStr);
                return;
            }
            string2 = jSONObject.getString("api");
            if (!jSONObject.has("params")) {
                this.apiLog("callExperimentalAPI[lack params or illegal type]: " + jsonStr);
                return;
            }
            jSONObject2 = jSONObject.getJSONObject("params");
        }
        catch (Exception exception) {
            this.apiLog("callExperimentalAPI[failed]: " + jsonStr + " " + exception);
        }
        List<String> list = Arrays.asList("updatePrivateMapKey", "disconnectOtherRoom");
        boolean bl = false;
        for (String string3 : list) {
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        this.apiOnlineLog("callExperimentalAPI " + (bl ? string2 : jsonStr) + ", roomid = " + (this.mRoomInfo.roomId != -1L ? Long.valueOf(this.mRoomInfo.roomId) : this.mRoomInfo.strRoomId));
        final String string4 = string2;
        string3 = jSONObject2;
        if (string4.equals("setEncodedDataProcessingListener")) {
            this.setEncodedDataProcessingListener((JSONObject)string3);
            return;
        }
        if (string4.equals("setAudioPacketExtraDataListener")) {
            this.setAudioPacketExtraDataListener((JSONObject)string3);
            return;
        }
        try {
            if (string4.equals("enableRealtimeChorus")) {
                this.enableRealtimeChorus((JSONObject)string3);
                return;
            }
        }
        catch (Exception exception) {
            this.apiLog("callExperimentalAPI[failed]: " + exception.toString());
        }
        this.runOnSDKThread(new Runnable((JSONObject)string3, jsonStr){
            final /* synthetic */ JSONObject val$params;
            final /* synthetic */ String val$jsonStr;
            {
                this.val$params = jSONObject;
                this.val$jsonStr = string2;
            }

            @Override
            public void run() {
                try {
                    if (string4.equals("enableBlackStream")) {
                        TRTCCloudImpl.this.enableBlackStream(this.val$params);
                    } else if (string4.equals("setSEIPayloadType")) {
                        TRTCCloudImpl.this.setSEIPayloadType(this.val$params);
                    } else if (string4.equals("setLocalAudioMuteMode")) {
                        TRTCCloudImpl.this.setLocalAudioMuteMode(this.val$params);
                    } else if (string4.equals("setVideoEncodeParamEx")) {
                        TRTCCloudImpl.this.setVideoEncoderParamEx(this.val$params);
                    } else if (string4.equals("setAudioSampleRate")) {
                        TRTCCloudImpl.this.setAudioSampleRate(this.val$params);
                    } else if (string4.equals("muteRemoteAudioInSpeaker")) {
                        TRTCCloudImpl.this.muteRemoteAudioInSpeaker(this.val$params);
                    } else if (string4.equals("enableAudioAGC")) {
                        TRTCCloudImpl.this.enableAudioAGC(this.val$params);
                    } else if (string4.equals("enableAudioAEC")) {
                        TRTCCloudImpl.this.enableAudioAEC(this.val$params);
                    } else if (string4.equals("enableAudioANS")) {
                        TRTCCloudImpl.this.enableAudioANS(this.val$params);
                    } else if (string4.equals("setPerformanceMode")) {
                        TRTCCloudImpl.this.setPerformanceMode(this.val$params);
                    } else if (string4.equals("setCustomRenderMode")) {
                        TRTCCloudImpl.this.setCustomRenderMode(this.val$params);
                    } else if (string4.equals("setMediaCodecConfig")) {
                        TRTCCloudImpl.this.setMediaCodecConfig(this.val$params);
                    } else if (string4.equals("sendJsonCMD")) {
                        TRTCCloudImpl.this.sendJsonCmd(this.val$params, this.val$jsonStr);
                    } else if (string4.equals("updatePrivateMapKey")) {
                        TRTCCloudImpl.this.updatePrivateMapKey(this.val$params);
                    } else if (string4.equals("setFramework")) {
                        TRTCCloudImpl.this.setFramework(this.val$params);
                    } else if (string4.equals("forceCallbackMixedPlayAudioFrame")) {
                        TRTCCloudImpl.this.forceCallbackMixedPlayAudioFrame(this.val$params);
                    } else if (string4.equals("setSystemAudioKitEnabled")) {
                        TXCAudioEngine.getInstance().setSystemAudioKitEnabled();
                    } else if (string4.equals("setKeepAVCaptureOption")) {
                        TRTCCloudImpl.this.setKeepAVCaptureOption(this.val$params);
                    } else if (string4.equals("setHeartBeatTimeoutSec")) {
                        TRTCCloudImpl.this.setHeartBeatTimeoutSec(this.val$params);
                    } else if (string4.equals("setNetEnv")) {
                        TRTCCloudImpl.this.setNetEnv(this.val$params);
                    } else if (string4.equals("setAudioQualityEx")) {
                        TRTCCloudImpl.this.setAudioQualityEx(this.val$params);
                    } else if (string4.equals("SetAudioCacheParams")) {
                        TXCAudioEngine.getInstance().SetAudioCacheParams(this.val$params.getInt("min_cache_time"), this.val$params.getInt("max_cache_time"));
                    } else if (string4.equals("setRoomType")) {
                        TRTCCloudImpl.this.setRoomType(this.val$params);
                    } else if (string4.equals("setAVSyncPlaySources")) {
                        TRTCCloudImpl.this.setAVSyncPlaySources(this.val$params);
                    } else if (string4.equals("enableHevcEncode")) {
                        TRTCCloudImpl.this.setEnableH265Encoder(this.val$params);
                    } else if (string4.equals("setCustomCaptureGLSyncMode")) {
                        TRTCCloudImpl.this.setCustomCaptureGLSyncMode(this.val$params);
                    } else if (string4.equals("checkDuplicateEnterRoom")) {
                        TRTCCloudImpl.this.checkDuplicateEnterRoom(this.val$params);
                    } else if (string4.equals("preloadMusic")) {
                        TRTCCloudImpl.this.preloadMusic(this.val$params);
                    } else if (string4.equals("setAudioCacheType")) {
                        TRTCCloudImpl.this.setAudioCacheType(this.val$params);
                    } else if (string4.equals("muteDuringAECWarmUp")) {
                        TRTCCloudImpl.this.muteDuringAECWarmUp(this.val$params);
                    } else if (string4.equals("setLocalAudioMuteAction")) {
                        TRTCCloudImpl.this.setLocalAudioMuteAction(this.val$params);
                    } else if (string4.equals("setReverbParam")) {
                        TRTCCloudImpl.this.setReverbParam(this.val$params);
                    } else if (string4.equals("setScreenCaptureCropRect")) {
                        TRTCCloudImpl.this.setScreenCaptureCropRect(this.val$params);
                    } else if (string4.equals("setQoSStrategy")) {
                        TRTCCloudImpl.this.setQoSStrategy(this.val$params);
                    } else if (string4.equals("disconnectOtherRoom")) {
                        TRTCCloudImpl.this.disconnectOtherRoom(this.val$params.toString());
                    } else if (string4.equals("setEqualizationParam")) {
                        TRTCCloudImpl.this.setEqualizationParam(this.val$params);
                    } else if (string4.equals("addCustomMonitorEvent")) {
                        TRTCCloudImpl.this.addCustomMonitorEvent(this.val$params);
                    } else {
                        TRTCCloudImpl.this.apiLog("callExperimentalAPI[illegal api]: " + string4);
                    }
                }
                catch (Exception exception) {
                    TRTCCloudImpl.this.apiLog("callExperimentalAPI[failed]: " + exception);
                }
            }
        });
    }

    protected void updatePrivateMapKey(JSONObject params) throws JSONException {
        if (params == null) {
            this.apiLog("callExperimentalAPI[update private map key fail, params is null");
            return;
        }
        String string = params.getString("privateMapKey");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.nativeUpdatePrivateMapKey(this.mNativeRtcContext, string);
        } else {
            this.apiLog("callExperimentalAPI[update private map key fail, key is empty");
        }
    }

    protected void sendJsonCmd(JSONObject params, String jsonStr) throws JSONException {
        if (params == null || !params.has("jsonParam") || !(params.get("jsonParam") instanceof JSONObject)) {
            this.apiLog("callExperimentalAPI[lack parameter or illegal type]: sendJsonCMD");
            return;
        }
        JSONObject jSONObject = params.getJSONObject("jsonParam");
        String string = jSONObject.toString();
        this.nativeSendJsonCmd(this.mNativeRtcContext, string, jsonStr);
    }

    @Override
    public int setLocalVideoRenderListener(final int pixelFormat, final int bufferType, final TRTCCloudListener.TRTCVideoRenderListener listener) {
        if (pixelFormat != 1 && pixelFormat != 4 && pixelFormat != 2 && pixelFormat != 5) {
            this.apiLog("setLocalVideoRenderListener unsupported pixelFormat : " + pixelFormat);
            return -1327;
        }
        if (bufferType != 1 && bufferType != 2 && bufferType != 3) {
            this.apiLog("setLocalVideoRenderListener unsupported bufferType : " + bufferType);
            return -1328;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog(String.format("setLocalVideoRenderListener pixelFormat:%d bufferType:%d", pixelFormat, bufferType));
                TRTCCloudImpl.this.mRoomInfo.localPixelFormat = pixelFormat;
                TRTCCloudImpl.this.mRoomInfo.localBufferType = bufferType;
                TRTCCloudImpl.this.mRoomInfo.localListener = listener;
                if (listener == null) {
                    TRTCCloudImpl.this.mCaptureAndEnc.a((o)null, pixelFormat);
                } else {
                    TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this, pixelFormat);
                }
            }
        });
        return 0;
    }

    @Override
    public int setLocalVideoProcessListener(final int pixelFormat, final int bufferType, final TRTCCloudListener.TRTCVideoFrameListener listener) {
        if (pixelFormat != 1 && pixelFormat != 4 && pixelFormat != 2) {
            this.apiLog("setLocalVideoRenderListener unsupported pixelFormat : " + pixelFormat);
            return -1327;
        }
        if (bufferType != 1 && bufferType != 2 && bufferType != 3) {
            this.apiLog("setLocalVideoRenderListener unsupported bufferType : " + bufferType);
            return -1328;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setLocalVideoPreprocessListener pixelFormat: %d, bufferType: %d, listener: %s", pixelFormat, bufferType, listener);
                TRTCCloudImpl.this.mVideoPreprocessListenerAdapter.setListener(pixelFormat, bufferType, listener);
                TRTCCloudImpl.this.mCaptureAndEnc.b(listener == null);
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mVideoPreprocessListenerAdapter);
            }
        });
        return 0;
    }

    @Override
    public int setRemoteVideoRenderListener(final String userId, final int pixelFormat, final int bufferType, final TRTCCloudListener.TRTCVideoRenderListener listener) {
        if (pixelFormat != 1 && pixelFormat != 4 && pixelFormat != 2 && pixelFormat != 5) {
            this.apiLog("setRemoteVideoRenderListener unsupported pixelFormat : " + pixelFormat);
            return -1327;
        }
        if (bufferType != 1 && bufferType != 2 && bufferType != 3) {
            this.apiLog("setRemoteVideoRenderListener unsupported bufferType : " + bufferType);
            return -1328;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog(String.format("setRemoteVideoRenderListener userid:%s pixelFormat:%d bufferType:%d", userId, pixelFormat, bufferType));
                if (listener == null) {
                    TRTCCloudImpl.this.mRenderListenerMap.remove(userId);
                } else {
                    RenderListenerAdapter renderListenerAdapter = new RenderListenerAdapter();
                    renderListenerAdapter.bufferType = bufferType;
                    renderListenerAdapter.pixelFormat = pixelFormat;
                    renderListenerAdapter.listener = listener;
                    TRTCCloudImpl.this.mRenderListenerMap.put(userId, renderListenerAdapter);
                    TRTCCloudImpl.this.mCustomRemoteRender = true;
                }
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userID, TRTCRoomInfo.UserInfo userInfo) {
                        if (userID.equalsIgnoreCase(userId)) {
                            b b2;
                            RenderListenerAdapter renderListenerAdapter = TRTCCloudImpl.this.mRenderListenerMap.get(userId);
                            if (renderListenerAdapter != null) {
                                renderListenerAdapter.strTinyID = String.valueOf(userInfo.tinyID);
                            }
                            TRTCCloudImpl tRTCCloudImpl = listener != null ? TRTCCloudImpl.this : null;
                            b b3 = b2 = renderListenerAdapter != null ? TRTCCloudImpl.this.getPixelFormat(renderListenerAdapter.pixelFormat) : b.a;
                            if (userInfo.mainRender.render != null) {
                                userInfo.mainRender.render.setVideoFrameListener(tRTCCloudImpl, b2);
                            }
                            if (userInfo.subRender.render != null) {
                                userInfo.subRender.render.setVideoFrameListener(tRTCCloudImpl, b2);
                            }
                        }
                    }
                });
            }
        });
        return 0;
    }

    @Override
    public void enableCustomAudioCapture(final boolean enable) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mEnableCustomAudioCapture == enable) {
                    return;
                }
                TRTCCloudImpl.this.mEnableCustomAudioCapture = enable;
                if (enable) {
                    TRTCCloudImpl.this.mConfig.U |= 1;
                    if (TRTCCloudImpl.this.mCurrentRole == 21) {
                        TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                            @Override
                            public void run() {
                                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                                if (tRTCCloudListener == null) {
                                    return;
                                }
                                tRTCCloudListener.onWarning(6001, "ignore send custom audio,for role audience", null);
                            }
                        });
                        TRTCCloudImpl.this.apiLog("ignore enableCustomAudioCapture,for role audience");
                    }
                } else {
                    TRTCCloudImpl.this.mConfig.U &= 0xFFFFFFFE;
                }
                TRTCCloudImpl.this.mCaptureAndEnc.a(TRTCCloudImpl.this.mConfig);
                TRTCCloudImpl.this.apiOnlineLog("enableCustomAudioCapture " + enable);
                if (!TRTCCloudImpl.this.mIsAudioCapturing) {
                    TRTCCloudImpl.this.enableAudioStream(enable);
                }
                if (enable) {
                    TRTCCloudImpl.this.setQoSParams();
                    TXCAudioEngineJNI.nativeUseSysAudioDevice(false);
                    TXCAudioEngine.getInstance().startLocalAudio(11, true);
                    TXCAudioEngine.getInstance().enableEncodedDataPackWithTRAEHeaderCallback(true);
                    TXCEventRecorderProxy.a("18446744073709551615", 3003, 11L, -1L, "", 0);
                } else {
                    TXCAudioEngine.getInstance().stopLocalAudio();
                }
                TXCKeyPointReportProxy.a(40050, enable ? 1 : 0, 1);
            }
        });
    }

    @Override
    public void sendCustomAudioData(TRTCCloudDef.TRTCAudioFrame frame) {
        if (frame == null) {
            this.apiLog("sendCustomAudioData parameter is null");
            return;
        }
        final com.tencent.liteav.basic.structs.a a2 = new com.tencent.liteav.basic.structs.a();
        a2.f = new byte[frame.data.length];
        System.arraycopy(frame.data, 0, a2.f, 0, frame.data.length);
        a2.a = frame.sampleRate;
        a2.b = frame.channel;
        a2.c = 16;
        a2.e = 0L == frame.timestamp ? TXCTimeUtil.generatePtsMS() : frame.timestamp;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (!TRTCCloudImpl.this.mEnableCustomAudioCapture) {
                    TRTCCloudImpl.this.apiLog("sendCustomAudioData when mEnableCustomAudioCapture is false");
                    return;
                }
                TXCAudioEngine.getInstance().sendCustomPCMData(a2);
            }
        });
    }

    @Override
    public void enableMixExternalAudioFrame(boolean enablePublish, boolean enablePlayout) {
        if (enablePublish) {
            if (this.mPublishAudioTunnelId < 0) {
                this.mPublishAudioTunnelId = TXCAudioEngineJNI.nativeOpenAudioTunnel(true);
            }
        } else if (this.mPublishAudioTunnelId >= 0) {
            TXCAudioEngineJNI.nativeCloseAudioTunnel(this.mPublishAudioTunnelId);
            this.mPublishAudioTunnelId = -1;
        }
        if (enablePlayout) {
            if (this.mPlayoutAudioTunnelId < 0) {
                this.mPlayoutAudioTunnelId = TXCAudioEngineJNI.nativeOpenAudioTunnel(false);
            }
        } else if (this.mPlayoutAudioTunnelId >= 0) {
            TXCAudioEngineJNI.nativeCloseAudioTunnel(this.mPlayoutAudioTunnelId);
            this.mPlayoutAudioTunnelId = -1;
        }
    }

    @Override
    public int mixExternalAudioFrame(TRTCCloudDef.TRTCAudioFrame frame) {
        if (frame == null || frame.data == null || frame.data.length == 0) {
            return -2;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        if (this.mPublishAudioTunnelId < 0 && this.mPlayoutAudioTunnelId < 0) {
            return -1;
        }
        if (this.mPublishAudioTunnelId >= 0) {
            n2 = TXCAudioEngineJNI.nativeWriteDataToTunnel(this.mPublishAudioTunnelId, frame.sampleRate, frame.channel, 16, frame.data);
        }
        if (this.mPlayoutAudioTunnelId >= 0) {
            n3 = TXCAudioEngineJNI.nativeWriteDataToTunnel(this.mPlayoutAudioTunnelId, frame.sampleRate, frame.channel, 16, frame.data);
        }
        if (n2 < n3) {
            return n2;
        }
        if (n3 != Integer.MAX_VALUE) {
            return n3;
        }
        return -4;
    }

    @Override
    public void enableCustomAudioRendering(final boolean enable) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mEnableCustomAudioRendering == enable) {
                    return;
                }
                TRTCCloudImpl.this.apiOnlineLog("enableCustomAudioRendering enable:" + enable);
                TRTCCloudImpl.this.mEnableCustomAudioRendering = enable;
                TXCAudioEngineJNI.nativeEnableCustomAudioRendering(enable);
            }
        });
    }

    @Override
    public void getCustomAudioRenderingFrame(TRTCCloudDef.TRTCAudioFrame audioFrame) {
        if (!this.mEnableCustomAudioRendering || audioFrame == null) {
            return;
        }
        TXCAudioEngineJNI.nativeGetCustomAudioRenderingFrame(audioFrame.data, audioFrame.sampleRate, audioFrame.channel);
    }

    @Override
    public void setMixExternalAudioVolume(int publishVolume, int playoutVolume) {
        if (this.mPublishAudioTunnelId >= 0 && publishVolume >= 0) {
            TXCAudioEngineJNI.nativeSetVolumeToTunnel(this.mPublishAudioTunnelId, publishVolume);
        }
        if (this.mPlayoutAudioTunnelId >= 0 && playoutVolume >= 0) {
            TXCAudioEngineJNI.nativeSetVolumeToTunnel(this.mPlayoutAudioTunnelId, playoutVolume);
        }
    }

    @Override
    public void playBGM(final String path, final TRTCCloud.BGMNotify notify) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("playBGM");
                TRTCCloudImpl.this.mBGMNotify = notify;
                if (TRTCCloudImpl.this.mBGMNotify != null) {
                    TXCLiveBGMPlayer.getInstance().setOnPlayListener(TRTCCloudImpl.this);
                } else {
                    TXCLiveBGMPlayer.getInstance().setOnPlayListener(null);
                }
                TXCLiveBGMPlayer.getInstance().startPlay(path);
            }
        });
    }

    @Override
    public void stopBGM() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopBGM");
                TXCLiveBGMPlayer.getInstance().stopPlay();
                TRTCCloudImpl.this.mBGMNotify = null;
            }
        });
    }

    @Override
    public void pauseBGM() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("pauseBGM");
                TXCLiveBGMPlayer.getInstance().pause();
            }
        });
    }

    @Override
    public void resumeBGM() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("resumeBGM");
                TXCLiveBGMPlayer.getInstance().resume();
            }
        });
    }

    @Override
    public int getBGMDuration(String path) {
        return TXCLiveBGMPlayer.getInstance().getBGMDuration(path);
    }

    @Override
    public int setBGMPosition(final int progress) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setBGMPosition " + progress);
                TXCLiveBGMPlayer.getInstance().setBGMPosition(progress);
            }
        });
        return 0;
    }

    @Override
    public void setMicVolumeOnMixing(final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setMicVolume " + volume);
                float f2 = (float)volume / 100.0f;
                TXCAudioEngine.getInstance().setSoftwareCaptureVolume(f2);
            }
        });
    }

    @Override
    public void setBGMVolume(final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setBGMVolume " + volume);
                float f2 = (float)volume / 100.0f;
                TXCLiveBGMPlayer.getInstance().setVolume(f2);
            }
        });
    }

    @Override
    public void setBGMPlayoutVolume(final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                float f2 = (float)volume / 100.0f;
                TRTCCloudImpl.this.apiLog("setBGMPlayoutVolume:" + volume + " fVolume:" + f2);
                TXCLiveBGMPlayer.getInstance().setPlayoutVolume(f2);
            }
        });
    }

    @Override
    public void setBGMPublishVolume(final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                float f2 = (float)volume / 100.0f;
                TRTCCloudImpl.this.apiLog("setBGMPublishVolume " + volume);
                TXCLiveBGMPlayer.getInstance().setPublishVolume(f2);
            }
        });
    }

    @Override
    public void setReverbType(final int reverbType) {
        if (reverbType < TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_0.getNativeValue() || reverbType > TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_12.getNativeValue()) {
            TXCLog.e(TAG, "reverbType not support :" + reverbType);
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setLocalViewFillMode");
                TXAudioEffectManagerImpl.getInstance().setVoiceReverbType(TRTCCloudImpl.this.reverbTypes[reverbType]);
            }
        });
    }

    @Override
    public boolean setVoiceChangerType(final int voiceChangerType) {
        if (voiceChangerType < 0 || voiceChangerType > 11) {
            TXCLog.e(TAG, "voiceChangerType not support :" + voiceChangerType);
            return false;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXAudioEffectManagerImpl.getInstance().setVoiceChangerType(TRTCCloudImpl.this.voiceChangerTypes[voiceChangerType]);
            }
        });
        return true;
    }

    @Override
    public TXAudioEffectManager getAudioEffectManager() {
        return TXAudioEffectManagerImpl.getAutoCacheHolder();
    }

    @Override
    public void onEffectPlayFinish(final int effectId) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onEffectPlayFinish -> effectId = " + effectId);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onAudioEffectFinished(effectId, 0);
                }
            }
        });
    }

    @Override
    public void onEffectPlayStart(final int effectId, final int errCode) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onEffectPlayStart -> effectId = " + effectId + " code = " + errCode);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null && errCode < 0) {
                    tRTCCloudListener.onAudioEffectFinished(effectId, errCode);
                }
            }
        });
    }

    @Override
    public void playAudioEffect(final TRTCCloudDef.TRTCAudioEffectParam effect) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("playAudioEffect -> effectId = " + effect.effectId + " path = " + effect.path + " publish = " + effect.publish + " loopCount = " + effect.loopCount);
                TXCSoundEffectPlayer.getInstance().playEffectWithId(effect.effectId, effect.path, effect.publish, effect.loopCount);
            }
        });
    }

    @Override
    public void setAudioEffectVolume(final int effectId, final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setAudioEffectVolume -> effectId = " + effectId + " volume = " + volume);
                float f2 = (float)volume / 100.0f;
                TXCSoundEffectPlayer.getInstance().setVolumeOfEffect(effectId, f2);
            }
        });
    }

    @Override
    public void stopAudioEffect(final int effectId) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopAudioEffect -> effectId = " + effectId);
                TXCSoundEffectPlayer.getInstance().stopEffectWithId(effectId);
            }
        });
    }

    @Override
    public void stopAllAudioEffects() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopAllAudioEffects");
                TXCSoundEffectPlayer.getInstance().stopAllEffect();
            }
        });
    }

    @Override
    public void setAllAudioEffectsVolume(final int volume) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setAllAudioEffectsVolume volume = " + volume);
                float f2 = (float)volume / 100.0f;
                TXCSoundEffectPlayer.getInstance().setEffectsVolume(f2);
            }
        });
    }

    @Override
    public void pauseAudioEffect(final int effectId) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("pauseAudioEffect -> effectId = " + effectId);
                TXCSoundEffectPlayer.getInstance().pauseEffectWithId(effectId);
            }
        });
    }

    @Override
    public void resumeAudioEffect(final int effectId) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("resumeAudioEffect -> effectId = " + effectId);
                TXCSoundEffectPlayer.getInstance().resumeEffectWithId(effectId);
            }
        });
    }

    @Override
    public void showDebugView(final int showType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("showDebugView " + showType);
                TRTCCloudImpl.this.mDebugType = showType;
                final TXCloudVideoView tXCloudVideoView = TRTCCloudImpl.this.mRoomInfo.localView;
                if (tXCloudVideoView != null) {
                    TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            tXCloudVideoView.showVideoDebugLog(showType);
                        }
                    });
                }
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        final TXCloudVideoView tXCloudVideoView = userInfo.mainRender.view;
                        final TXCloudVideoView tXCloudVideoView2 = userInfo.subRender.view;
                        if (tXCloudVideoView != null || tXCloudVideoView2 != null) {
                            TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (tXCloudVideoView != null) {
                                        tXCloudVideoView.showVideoDebugLog(showType);
                                    }
                                    if (tXCloudVideoView2 != null) {
                                        tXCloudVideoView2.showVideoDebugLog(showType);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    @Override
    public void setDebugViewMargin(final String userId, final TRTCCloud.TRTCViewMargin margin) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo;
                TRTCCloudImpl.this.apiLog("setDebugViewMargin");
                final TXCloudVideoView tXCloudVideoView = TRTCCloudImpl.this.mRoomInfo.localView;
                if (tXCloudVideoView != null && userId.equalsIgnoreCase(tXCloudVideoView.getUserId())) {
                    TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            tXCloudVideoView.setLogMarginRatio(margin.leftMargin, margin.rightMargin, margin.topMargin, margin.bottomMargin);
                        }
                    });
                }
                if ((userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId)) != null) {
                    userInfo.debugMargin = margin;
                    final TXCloudVideoView tXCloudVideoView2 = userInfo.mainRender.view;
                    final TXCloudVideoView tXCloudVideoView3 = userInfo.subRender.view;
                    if (tXCloudVideoView2 != null || tXCloudVideoView3 != null) {
                        TRTCCloudImpl.this.runOnMainThread(new Runnable(){

                            @Override
                            public void run() {
                                if (tXCloudVideoView2 != null) {
                                    tXCloudVideoView2.setLogMarginRatio(margin.leftMargin, margin.rightMargin, margin.topMargin, margin.bottomMargin);
                                }
                                if (tXCloudVideoView3 != null) {
                                    tXCloudVideoView3.setLogMarginRatio(margin.leftMargin, margin.rightMargin, margin.topMargin, margin.bottomMargin);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void startSpeedTest(final int sdkAppId, final String userId, final String userSig) {
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userSig) || sdkAppId == 0) {
            TXCLog.e(TAG, "startSpeedTest failed with invalid params. userId = " + userId + ", userSig = " + userSig + ", sdkAppId = " + sdkAppId + " self:" + this.hashCode());
            return;
        }
        this.SetGlobalEnvBySDKAppID(sdkAppId);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("startSpeedTest");
                TRTCCloudImpl.this.nativeStartSpeedTest(TRTCCloudImpl.this.mNativeRtcContext, sdkAppId, userId, userSig, -1, -1, 0);
            }
        });
    }

    @Override
    public int startSpeedTest(final TRTCCloudDef.TRTCSpeedTestParams params) {
        if (params == null || params.sdkAppId == 0) {
            TXCLog.e(TAG, "startSpeedTest failed. Invalid params " + params + ", sdkappid = " + (params == null ? 0 : params.sdkAppId) + ". self:" + this.hashCode());
            return -1;
        }
        this.SetGlobalEnvBySDKAppID(params.sdkAppId);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("startSpeedTest parmas:" + params);
                TRTCCloudImpl.this.nativeStartSpeedTest(TRTCCloudImpl.this.mNativeRtcContext, params.sdkAppId, params.userId, params.userSig, params.expectedUpBandwidth, params.expectedDownBandwidth, 1);
            }
        });
        return 0;
    }

    @Override
    public void stopSpeedTest() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopSpeedTest");
                TRTCCloudImpl.this.nativeStopSpeedTest(TRTCCloudImpl.this.mNativeRtcContext);
            }
        });
    }

    @Override
    public void startPublishCDNStream(final TRTCCloudDef.TRTCPublishCDNParam param) {
        if (param == null) {
            this.apiLog("startPublishCDNStream param is null");
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("startPublishCDNStream");
                TRTCCloudImpl.this.nativeStartPublishCDNStream(TRTCCloudImpl.this.mNativeRtcContext, param);
            }
        });
    }

    @Override
    public void stopPublishing() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopPublishing");
                TRTCCloudImpl.this.nativeStopPublishing(TRTCCloudImpl.this.mNativeRtcContext);
            }
        });
    }

    @Override
    public void stopPublishCDNStream() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("stopPublishCDNStream");
                TRTCCloudImpl.this.nativeStopPublishCDNStream(TRTCCloudImpl.this.mNativeRtcContext);
            }
        });
    }

    @Override
    public void startPublishing(final String streamId, final int streamType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("startPublishing streamId:" + streamId + ", streamType:" + streamType);
                int n2 = 2;
                if (streamType == 2) {
                    n2 = 7;
                }
                TRTCCloudImpl.this.nativeStartPublishing(TRTCCloudImpl.this.mNativeRtcContext, streamId, n2);
            }
        });
    }

    @Override
    public void setMixTranscodingConfig(TRTCCloudDef.TRTCTranscodingConfig config) {
        final TRTCTranscodingConfigInner tRTCTranscodingConfigInner = config != null ? new TRTCTranscodingConfigInner(config) : null;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("setMixTranscodingConfig " + tRTCTranscodingConfigInner);
                TRTCCloudImpl.this.nativeSetMixTranscodingConfig(TRTCCloudImpl.this.mNativeRtcContext, tRTCTranscodingConfigInner);
            }
        });
    }

    @Override
    public boolean sendCustomCmdMsg(final int cmdID, final byte[] data, final boolean reliable, final boolean ordered) {
        if (data == null) {
            return false;
        }
        if (this.mCurrentRole == 21) {
            this.apiLog("ignore send custom cmd msg for audience");
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (this.mLastSendMsgTimeMs == 0L) {
            this.mLastSendMsgTimeMs = l2;
        }
        boolean bl = false;
        if (l2 - this.mLastSendMsgTimeMs < 1000L) {
            if (this.mSendMsgCount < 40 && this.mSendMsgSize < 8192) {
                bl = true;
                ++this.mSendMsgCount;
                this.mSendMsgSize += data.length;
            } else {
                TXCLog.e(TAG, "send msg too more self:" + this.hashCode());
            }
        } else {
            bl = true;
            this.mLastSendMsgTimeMs = l2;
            this.mSendMsgCount = 1;
            this.mSendMsgSize = data.length;
        }
        if (bl) {
            this.runOnSDKThread(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudImpl.this.nativeSendCustomCmdMsg(TRTCCloudImpl.this.mNativeRtcContext, cmdID, data, reliable, ordered);
                }
            });
        }
        return bl;
    }

    @Override
    public boolean sendSEIMsg(final byte[] data, final int repeatCount) {
        if (data == null) {
            return false;
        }
        if (this.mCurrentRole == 21) {
            this.apiLog("ignore send sei msg for audience");
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (this.mLastSendMsgTimeMs == 0L) {
            this.mLastSendMsgTimeMs = l2;
        }
        boolean bl = false;
        if (l2 - this.mLastSendMsgTimeMs < 1000L) {
            if (this.mSendMsgCount < 40 && this.mSendMsgSize < 8192) {
                bl = true;
                ++this.mSendMsgCount;
                this.mSendMsgSize += data.length;
            } else {
                TXCLog.e(TAG, "send msg too more self:" + this.hashCode());
            }
        } else {
            bl = true;
            this.mLastSendMsgTimeMs = l2;
            this.mSendMsgCount = 1;
            this.mSendMsgSize = data.length;
        }
        if (bl) {
            this.runOnSDKThread(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudImpl.this.nativeSendSEIMsg(TRTCCloudImpl.this.mNativeRtcContext, data, repeatCount);
                }
            });
        }
        return bl;
    }

    @Override
    public void setAudioFrameListener(final TRTCCloudListener.TRTCAudioFrameListener listener) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("setAudioFrameListener " + listener);
                TRTCCloudImpl.this.mAudioFrameListener = listener;
                if (TRTCCloudImpl.this.mAudioFrameListener == null) {
                    TXCAudioEngine.setPlayoutDataListener(null);
                    TXCAudioEngine.getInstance().setAudioCaptureDataListener(null);
                    TXCAudioEngine.getInstance().setMixedAllDataListener(null);
                    TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                        @Override
                        public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                            TXCAudioEngine.getInstance().setSetAudioEngineRemoteStreamDataListener(String.valueOf(userInfo.tinyID), null);
                        }
                    });
                } else {
                    TXCAudioEngine.setPlayoutDataListener(TRTCCloudImpl.this);
                    TXCAudioEngine.getInstance().setAudioCaptureDataListener(TRTCCloudImpl.this);
                    TXCAudioEngine.getInstance().setMixedAllDataListener(TRTCCloudImpl.this);
                    TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                        @Override
                        public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                            TXCAudioEngine.getInstance().setSetAudioEngineRemoteStreamDataListener(String.valueOf(userInfo.tinyID), TRTCCloudImpl.this);
                        }
                    });
                }
            }
        });
    }

    @Override
    public long generateCustomPTS() {
        return TXCTimeUtil.generatePtsMS();
    }

    @Override
    public int setCapturedRawAudioFrameCallbackFormat(final TRTCCloudDef.TRTCAudioFrameCallbackFormat format) {
        this.apiLog(String.format("setCaptureAudioFrameCallbackFormat sample_rate: %d, channel: %d, samplesPerCall %d", format.sampleRate, format.channel, format.samplesPerCall));
        if (TXCAudioEngine.getInstance().IsDataCallbackFormatInvalid(format.sampleRate, format.channel, format.samplesPerCall)) {
            return -1;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXCAudioEngine.getInstance().setCaptureDataCallbackFormat(format.sampleRate, format.channel, format.samplesPerCall);
            }
        });
        return 0;
    }

    @Override
    public int setLocalProcessedAudioFrameCallbackFormat(final TRTCCloudDef.TRTCAudioFrameCallbackFormat format) {
        this.apiLog(String.format("setLocalProcessedAudioFrameCallbackFormat sample_rate: %d, channel: %d, samplesPerCall %d", format.sampleRate, format.channel, format.samplesPerCall));
        if (TXCAudioEngine.getInstance().IsDataCallbackFormatInvalid(format.sampleRate, format.channel, format.samplesPerCall)) {
            return -1;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXCAudioEngine.getInstance().setLocalProcessedDataCallbackFormat(format.sampleRate, format.channel, format.samplesPerCall);
            }
        });
        return 0;
    }

    @Override
    public int setMixedPlayAudioFrameCallbackFormat(final TRTCCloudDef.TRTCAudioFrameCallbackFormat format) {
        this.apiLog(String.format("setMixedPlayAudioFrameCallbackFormat sample_rate: %d, channel: %d, samplesPerCall %d", format.sampleRate, format.channel, format.samplesPerCall));
        if (TXCAudioEngine.getInstance().IsDataCallbackFormatInvalid(format.sampleRate, format.channel, format.samplesPerCall)) {
            return -1;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXCAudioEngine.getInstance().setPlayoutDataCallbackFormat(format.sampleRate, format.channel, format.samplesPerCall);
            }
        });
        return 0;
    }

    public void setAudioPacketExtraDataListener(JSONObject params) {
        if (params == null || !params.has("listener")) {
            this.apiLog("setAudioPacketExtraDataListener [lack parameter or illegal type]: listener");
            return;
        }
        long l2 = 0L;
        try {
            l2 = params.getLong("listener");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.apiLog("setAudioPacketExtraDataListener:" + Long.toHexString(l2));
        this.nativeSetAudioPacketExtraDataListener(this.mNativeRtcContext, l2);
    }

    public void setEncodedDataProcessingListener(JSONObject params) {
        if (params == null || !params.has("listener")) {
            this.apiLog("setEncodedDataProcessingListener [lack parameter or illegal type]: listener");
            return;
        }
        long l2 = 0L;
        try {
            l2 = params.getLong("listener");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.apiLog("setEncodedDataProcessingListener:" + Long.toHexString(l2));
        this.nativeSetEncodedDataProcessingListener(this.mNativeRtcContext, l2);
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            this.destroy();
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public void onNotifyEvent(final int event, final Bundle param) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (param == null) {
                    return;
                }
                String string = param.getString("EVT_USERID", "");
                if (TextUtils.isEmpty((CharSequence)string) || string.equalsIgnoreCase("18446744073709551615") || string.equalsIgnoreCase(TRTCCloudImpl.this.mRoomInfo.getTinyId())) {
                    TRTCCloudImpl.this.notifyEvent(TRTCCloudImpl.this.mRoomInfo.getUserId(), event, param);
                } else {
                    TRTCCloudImpl.this.notifyEventByUserId(string, event, param);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncVideo(TXSNALPacket nal) {
        if (nal == null) {
            return;
        }
        Object object = this.mNativeLock;
        synchronized (object) {
            this.pushVideoFrame(nal);
        }
    }

    @Override
    public void onEncVideoFormat(MediaFormat format) {
    }

    @Override
    public void onBackgroudPushStop() {
    }

    @Override
    public void onRequestKeyFrame(final String tinyId, final int streamType) {
        if (TextUtils.isEmpty((CharSequence)tinyId)) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.nativeRequestKeyFrame(TRTCCloudImpl.this.mNativeRtcContext, Long.valueOf(tinyId), streamType);
            }
        });
    }

    @Override
    public void onAudioPlayPcmData(final String id, final byte[] data, final long timestamp, final int sampleRate, final int channels, final byte[] extraData) {
        if (id == null) {
            TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
            if (tRTCAudioFrameListener != null) {
                TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
                tRTCAudioFrame.data = data;
                tRTCAudioFrame.timestamp = timestamp;
                tRTCAudioFrame.sampleRate = sampleRate;
                tRTCAudioFrame.channel = channels;
                tRTCAudioFrameListener.onMixedPlayAudioFrame(tRTCAudioFrame);
            }
        } else {
            this.runOnListenerThread(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = TRTCCloudImpl.this.mAudioFrameListener;
                    if (tRTCAudioFrameListener != null) {
                        TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
                        tRTCAudioFrame.data = data;
                        tRTCAudioFrame.timestamp = timestamp;
                        tRTCAudioFrame.sampleRate = sampleRate;
                        tRTCAudioFrame.channel = channels;
                        tRTCAudioFrame.extraData = extraData;
                        try {
                            long l2 = Long.valueOf(id);
                            tRTCAudioFrameListener.onRemoteUserAudioFrame(tRTCAudioFrame, TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(l2));
                        }
                        catch (Exception exception) {
                            TXCLog.e(TRTCCloudImpl.TAG, "onPlayAudioFrame failed." + exception.getMessage());
                        }
                    }
                }
            });
        }
    }

    public void onAudioJitterBufferError(String ID, int errNo, String errInfo) {
    }

    @Override
    public void onAudioJitterBufferNotify(final String ID, final int notifyNo, final String errInfo) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = new Bundle();
                bundle.putLong("EVT_ID", (long)notifyNo);
                bundle.putLong("EVT_TIME", System.currentTimeMillis());
                bundle.putString("EVT_MSG", errInfo);
                TRTCCloudImpl.this.notifyEventByUserId(ID, notifyNo, bundle);
            }
        });
    }

    @Override
    public void onRecordRawPcmData(byte[] data, long timestamp, int sampleRate, int channels, int bits, boolean withBgm) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener != null) {
            TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
            tRTCAudioFrame.data = data;
            tRTCAudioFrame.timestamp = timestamp;
            tRTCAudioFrame.sampleRate = sampleRate;
            tRTCAudioFrame.channel = channels;
            tRTCAudioFrameListener.onCapturedRawAudioFrame(tRTCAudioFrame);
        }
    }

    @Override
    public void onRecordPcmData(byte[] data, long timestamp, int sampleRate, int channels, int bits) {
        TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = this.mAudioFrameListener;
        if (tRTCAudioFrameListener != null) {
            TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
            tRTCAudioFrame.data = data;
            tRTCAudioFrame.timestamp = timestamp;
            tRTCAudioFrame.sampleRate = sampleRate;
            tRTCAudioFrame.channel = channels;
            tRTCAudioFrameListener.onLocalProcessedAudioFrame(tRTCAudioFrame);
            if (tRTCAudioFrame.extraData != null && tRTCAudioFrame.data.length != 0 && tRTCAudioFrame.extraData.length < 100) {
                TXCAudioEngine.getInstance().setAudioFrameExtraData(tRTCAudioFrame.extraData);
            }
        }
    }

    @Override
    public void onRecordEncData(byte[] data, long timestamp, int sampleRate, int channels, int bits) {
    }

    @Override
    public void onRecordError(int errNo, String errInfo) {
        int n2;
        Bundle bundle = new Bundle();
        bundle.putString("EVT_USERID", "18446744073709551615");
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        TXCLog.e(TAG, "onRecordError code = " + errNo + ":" + errInfo + " self:" + this.hashCode());
        if (errNo == -1) {
            n2 = -1302;
            bundle.putInt("EVT_ID", n2);
            this.onNotifyEvent(n2, bundle);
        }
        if (errNo == -6) {
            n2 = 2027;
            bundle.putInt("EVT_ID", n2);
            this.onNotifyEvent(n2, bundle);
        }
        if (errNo == -7) {
            n2 = 2029;
            bundle.putInt("EVT_ID", n2);
            this.onNotifyEvent(n2, bundle);
        }
    }

    @Override
    public void onMixedAllData(byte[] data, int sampleRate, int channels) {
        final TRTCCloudDef.TRTCAudioFrame tRTCAudioFrame = new TRTCCloudDef.TRTCAudioFrame();
        tRTCAudioFrame.data = data;
        tRTCAudioFrame.timestamp = 0L;
        tRTCAudioFrame.sampleRate = sampleRate;
        tRTCAudioFrame.channel = channels;
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener.TRTCAudioFrameListener tRTCAudioFrameListener = TRTCCloudImpl.this.mAudioFrameListener;
                if (tRTCAudioFrameListener != null) {
                    tRTCAudioFrameListener.onMixedAllAudioFrame(tRTCAudioFrame);
                }
            }
        });
    }

    @Override
    public void onRenderVideoFrame(String tinyId, int streamType, TXSVideoFrame videoFrame) {
        boolean bl;
        if (videoFrame == null) {
            return;
        }
        TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame = new TRTCCloudDef.TRTCVideoFrame();
        tRTCVideoFrame.width = videoFrame.width;
        tRTCVideoFrame.height = videoFrame.height;
        tRTCVideoFrame.rotation = videoFrame.rotation;
        tRTCVideoFrame.timestamp = videoFrame.pts;
        int n2 = this.translateStreamType(streamType);
        TRTCCloudListener.TRTCVideoRenderListener tRTCVideoRenderListener = null;
        String string = "";
        boolean bl2 = bl = TextUtils.isEmpty((CharSequence)tinyId) || tinyId.equalsIgnoreCase("18446744073709551615") || tinyId.equalsIgnoreCase(this.mRoomInfo.getTinyId());
        if (bl) {
            string = this.mRoomInfo.getUserId();
            tRTCVideoFrame.pixelFormat = this.mRoomInfo.localPixelFormat;
            tRTCVideoFrame.bufferType = this.mRoomInfo.localBufferType;
            tRTCVideoRenderListener = this.mRoomInfo.localListener;
        } else {
            for (Map.Entry<String, RenderListenerAdapter> entry : this.mRenderListenerMap.entrySet()) {
                RenderListenerAdapter renderListenerAdapter = entry.getValue();
                if (renderListenerAdapter == null || !tinyId.equalsIgnoreCase(entry.getValue().strTinyID)) continue;
                tRTCVideoFrame.pixelFormat = renderListenerAdapter.pixelFormat;
                tRTCVideoFrame.bufferType = renderListenerAdapter.bufferType;
                tRTCVideoRenderListener = renderListenerAdapter.listener;
                string = entry.getKey();
                break;
            }
        }
        if (tRTCVideoRenderListener != null) {
            if (tRTCVideoFrame.bufferType == 1) {
                if (videoFrame.eglContext != null) {
                    tRTCVideoFrame.buffer = ByteBuffer.allocateDirect(videoFrame.width * videoFrame.height * 4);
                    TXCOpenGlUtils.a(e.a.a, videoFrame.width, videoFrame.height, tRTCVideoFrame.buffer);
                } else {
                    if (videoFrame.buffer == null) {
                        videoFrame.loadYUVBufferFromGL();
                    }
                    tRTCVideoFrame.buffer = videoFrame.buffer;
                }
            } else if (tRTCVideoFrame.bufferType == 2) {
                if (videoFrame.eglContext != null) {
                    tRTCVideoFrame.data = new byte[videoFrame.width * videoFrame.height * 4];
                    TXCOpenGlUtils.a(e.a.a, videoFrame.width, videoFrame.height, tRTCVideoFrame.data);
                } else {
                    tRTCVideoFrame.data = videoFrame.data;
                    if (tRTCVideoFrame.data == null) {
                        tRTCVideoFrame.data = new byte[videoFrame.width * videoFrame.height * 3 / 2];
                        videoFrame.loadYUVArray(tRTCVideoFrame.data);
                    }
                }
            } else if (tRTCVideoFrame.bufferType == 3) {
                if (videoFrame.eglContext == null) {
                    return;
                }
                tRTCVideoFrame.texture = new TRTCCloudDef.TRTCTexture();
                tRTCVideoFrame.texture.textureId = videoFrame.textureId;
                if (videoFrame.eglContext instanceof javax.microedition.khronos.egl.EGLContext) {
                    tRTCVideoFrame.texture.eglContext10 = (javax.microedition.khronos.egl.EGLContext)videoFrame.eglContext;
                } else if (videoFrame.eglContext instanceof EGLContext) {
                    tRTCVideoFrame.texture.eglContext14 = (EGLContext)videoFrame.eglContext;
                }
            }
            tRTCVideoRenderListener.onRenderVideoFrame(string, n2, tRTCVideoFrame);
            if (this.mRoomInfo.enableCustomPreprocessor && bl) {
                if (tRTCVideoFrame.bufferType == 2) {
                    videoFrame.data = tRTCVideoFrame.data;
                } else if (tRTCVideoFrame.bufferType == 3) {
                    videoFrame.textureId = tRTCVideoFrame.texture.textureId;
                }
            }
        }
    }

    @Override
    public void onPlayStart() {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloud.BGMNotify bGMNotify = TRTCCloudImpl.this.mBGMNotify;
                if (bGMNotify != null) {
                    bGMNotify.onBGMStart(0);
                }
            }
        });
    }

    @Override
    public void onPlayEnd(final int err) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloud.BGMNotify bGMNotify = TRTCCloudImpl.this.mBGMNotify;
                if (bGMNotify != null) {
                    bGMNotify.onBGMComplete(err);
                }
            }
        });
    }

    @Override
    public void onPlayProgress(final long curPtsMS, final long durationMS) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloud.BGMNotify bGMNotify = TRTCCloudImpl.this.mBGMNotify;
                if (bGMNotify != null) {
                    bGMNotify.onBGMProgress(curPtsMS, durationMS);
                }
            }
        });
    }

    protected native long nativeCreateContext(int var1, int var2, int var3);

    protected native void nativeDestroyContext(long var1);

    protected native void nativeInit(long var1, int var3, String var4, String var5, byte[] var6);

    protected native int nativeEnterRoom(long var1, long var3, String var5, String var6, String var7, int var8, int var9, int var10, int var11, int var12, String var13, String var14, String var15, int var16, String var17, String var18, int var19, int var20, int var21, boolean var22, int var23, int var24);

    protected native int nativeExitRoom(long var1);

    private native void nativeUpdatePrivateMapKey(long var1, String var3);

    protected native int nativeSetPriorRemoteVideoStreamType(long var1, int var3);

    protected native void nativeFlushC2SVideoCodecConfig(long var1, int var3, int var4);

    protected native int nativeAddUpstream(long var1, int var3);

    private native int nativeRemoveUpstream(long var1, int var3);

    private native void nativeMuteUpstream(long var1, int var3, boolean var4, boolean var5);

    private native void nativeEnableBlackStream(long var1, boolean var3);

    private native void nativeEnableSmallStream(long var1, boolean var3);

    private native int nativeRequestDownStream(long var1, long var3, int var5, boolean var6);

    private native int nativeCancelDownStream(long var1, long var3, int var5, boolean var6);

    private native void nativePushVideo(long var1, int var3, int var4, int var5, byte[] var6, long var7, long var9, long var11, long var13, long var15);

    private native void nativeSetVideoQuality(long var1, int var3, int var4);

    private native void nativeRequestKeyFrame(long var1, long var3, int var5);

    private native void nativeSetVideoEncoderConfiguration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, int var10, boolean var11);

    private native void nativeSetAudioEncodeConfiguration(long var1, int var3, int var4, int var5, int var6);

    private native void nativeSetDataReportDeviceInfo(String var1, String var2, int var3);

    private native void nativeSendCustomCmdMsg(long var1, int var3, byte[] var4, boolean var5, boolean var6);

    private native void nativeSendSEIMsg(long var1, byte[] var3, int var4);

    private native boolean nativeSetSEIPayloadType(long var1, int var3);

    private native void nativeSendJsonCmd(long var1, String var3, String var4);

    private native void nativeSetAudioCacheType(long var1, int var3);

    private native int nativeStartSpeedTest(long var1, int var3, String var4, String var5, int var6, int var7, int var8);

    private native void nativeStopSpeedTest(long var1);

    private native int nativeGetNetworkQUality(long var1, int var3, int var4);

    private native int nativeConnectOtherRoom(long var1, String var3);

    private native int nativeDisconnectOtherRoom(long var1, String var3);

    protected native void nativeSetMixTranscodingConfig(long var1, TRTCTranscodingConfigInner var3);

    private native void nativeStartPublishCDNStream(long var1, TRTCCloudDef.TRTCPublishCDNParam var3);

    private native void nativeStopPublishCDNStream(long var1);

    private native void nativeStartPublishing(long var1, String var3, int var4);

    private native void nativeStopPublishing(long var1);

    private native void nativeChangeRole(long var1, int var3);

    private native void nativeReenterRoom(long var1, int var3, boolean var4);

    private native void nativeSetAllowSwitchToHighPerformanceMode(long var1, boolean var3);

    private native void nativeSetEncodedDataProcessingListener(long var1, long var3);

    private native void nativeSetAudioPacketExtraDataListener(long var1, long var3);

    public native void nativeSwitchRoom(long var1, long var3, String var5, String var6, String var7);

    private native void nativeSetHeartBeatTimeoutSec(long var1, int var3);

    private native void nativeSetAVSyncPlaySources(long var1, String var3, String var4);

    private native void nativeSetNetEnv(long var1, int var3);

    private native void nativeEnableLowLatencyMode(long var1, boolean var3);

    private native void nativeStartLocalRecording(long var1, TRTCCloudDef.TRTCLocalRecordingParams var3);

    private native void nativeStopLocalRecording(long var1);

    private native void nativeSetLocalAudioMuteMode(long var1, int var3);

    private native void nativeSetAECMuteDataEnabled(long var1, boolean var3);

    private void onRequestToken(int err, String errMsg, final long tinyID, final byte[] token) {
        this.apiLog("onRequestToken " + tinyID + "," + err + ", " + errMsg);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mRoomInfo.setTinyId(String.valueOf(tinyID));
                TRTCCloudImpl.this.mRoomInfo.setToken(TRTCCloudImpl.this.mContext, token);
            }
        });
    }

    private void onRequestAccIP(int err, String errMsg, boolean isAcc) {
        this.apiLog("onRequestAccIP err:" + err + " " + errMsg + " isAcc:" + isAcc);
        String string = errMsg;
        if (err == 0) {
            string = isAcc ? "connect ACC" : "connect PROXY";
            Bundle bundle = new Bundle();
            bundle.putLong("EVT_ID", (long)err);
            bundle.putLong("EVT_TIME", System.currentTimeMillis());
            bundle.putString("EVT_MSG", string);
            bundle.putInt("EVT_STREAM_TYPE", 2);
            this.notifyEvent(this.mRoomInfo.getUserId(), err, bundle);
        }
    }

    protected void onEnterRoom(final int err, final String errMsg) {
        this.apiOnlineLog("onEnterRoom err:" + err + ", msg:" + errMsg);
        if (err == 0) {
            TXCEventRecorderProxy.a("18446744073709551615", 5003, 1L, -1L, "", 0);
        } else {
            TXCEventRecorderProxy.a("18446744073709551615", 5003, 0L, -1L, "", 0);
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (err == 0) {
                    TRTCCloudImpl.this.mRoomState = 2;
                    TRTCCloudImpl.this.mRoomInfo.networkStatus = 3;
                    TRTCCloudImpl.this.notifyEvent(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, "Enter room success");
                    TXCKeyPointReportProxy.b(30001, err);
                } else {
                    if (err != -3340) {
                        if (TRTCCloudImpl.this.mKeepAVCaptureWhenEnterRoomFailed) {
                            TRTCCloudImpl.this.mRoomState = 0;
                        } else {
                            TRTCCloudImpl.this.exitRoomInternal(false, "enter room failed");
                        }
                        TXCKeyPointReportProxy.b(30001, err);
                    }
                    TRTCCloudImpl.this.notifyEvent(TRTCCloudImpl.this.mRoomInfo.getUserId(), err, "Enter room fail " + errMsg);
                }
            }
        });
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    if (err == 0) {
                        long l2 = TRTCCloudImpl.this.mRoomInfo.getRoomElapsed();
                        tRTCCloudListener.onEnterRoom(l2);
                    } else {
                        tRTCCloudListener.onEnterRoom(err);
                    }
                }
            }
        });
    }

    private void onExitRoom(final int err, String errMsg) {
        this.apiOnlineLog("onExitRoom err:" + err + ", msg:" + errMsg);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mIsExitOldRoom) {
                    TRTCCloudImpl.this.mIsExitOldRoom = false;
                    TRTCCloudImpl.this.apiLog("exit no current room, ignore onExitRoom.");
                    return;
                }
                if (TRTCCloudImpl.this.mRoomInfo.isMicStard()) {
                    TRTCCloudImpl.this.mRoomInfo.setRoomExit(true, err);
                    TRTCCloudImpl.this.apiLog("onExitRoom delay 2s when mic is not release.");
                    TRTCCloudImpl.this.runOnSDKThread(new Runnable(){

                        @Override
                        public void run() {
                            if (TRTCCloudImpl.this.mRoomInfo.isRoomExit()) {
                                TRTCCloudImpl.this.apiLog("force onExitRoom after 2s");
                                final int n2 = TRTCCloudImpl.this.mRoomInfo.getRoomExitCode();
                                TRTCCloudImpl.this.mRoomInfo.setRoomExit(false, 0);
                                TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                                        if (tRTCCloudListener != null) {
                                            tRTCCloudListener.onExitRoom(n2);
                                        }
                                    }
                                });
                            }
                        }
                    }, 2000);
                } else {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                            if (tRTCCloudListener != null) {
                                tRTCCloudListener.onExitRoom(err);
                            }
                        }
                    });
                }
            }
        });
    }

    private void onKickOut(final int err, final String errMsg) {
        this.apiLog("onKickOut " + err + ", " + errMsg);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.exitRoomInternal(false, "onKickOut " + errMsg);
                TRTCCloudImpl.this.onExitRoom(err, errMsg);
            }
        });
    }

    private void onConnectOtherRoom(final String userID, final int err, final String errMsg) {
        this.apiOnlineLog("onConnectOtherRoom userId:%s err:%d, msg:%s", userID, err, errMsg);
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    TRTCCloudImpl.this.mTRTCListener.onConnectOtherRoom(userID, err, errMsg);
                }
            }
        });
    }

    private void onDisConnectOtherRoom(final int err, final String errMsg) {
        this.apiOnlineLog("onDisConnectOtherRoom err:%d, msg:%s", err, errMsg);
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    TRTCCloudImpl.this.mTRTCListener.onDisConnectOtherRoom(err, errMsg);
                }
            }
        });
    }

    private void onSwitchRoom(final int err, final String errMsg) {
        this.apiOnlineLog(String.format("onSwitchRoom err:%d, msg:%s", err, errMsg));
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    TRTCCloudImpl.this.mTRTCListener.onSwitchRoom(err, errMsg);
                }
            }
        });
    }

    private void onCallExperimentalAPI(int err, String errMsg) {
        this.apiLog("onCallExperimentalAPI " + err + ", " + errMsg);
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    // empty if block
                }
            }
        });
    }

    private void onAddUpStream(final int errCode, final String errMsg, int streamType) {
        this.apiOnlineLog("onAddUpStream  streamType:%d, err:%d, msg:%s", streamType, errCode, errMsg);
        if (streamType == 7 && errCode != 0) {
            this.runOnSDKThread(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudImpl.this.stopSubStreamScreenCapture();
                    TRTCCloudImpl.this.enableCustomVideoCapture(2, false);
                }
            });
            this.runOnListenerThread(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                    if (tRTCCloudListener != null) {
                        tRTCCloudListener.onError(errCode, errMsg, null);
                    }
                }
            });
        }
    }

    private void onCancelRawAudioDownStream(int err, String errMsg, final long tinyID, final int stream) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                String string;
                if (TRTCCloudImpl.this.mEnableServerAudioMix && stream == 1 && (string = TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(tinyID)) != null) {
                    com.tencent.liteav.audio.a.a().a(String.valueOf(tinyID), TRTCCloudImpl.this.hashCode());
                    TXCLog.i(TRTCCloudImpl.TAG, "[server audio mix] onCancelRawAudioDownStream tinyId:" + tinyID + " userId:" + string + ", audio has been mixed by server, stop audio player");
                }
            }
        });
    }

    private void onRecvRawAudioDownStream(int err, String errMsg, final long tinyID, final int stream) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                String string;
                if (TRTCCloudImpl.this.mEnableServerAudioMix && stream == 1 && (string = TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(tinyID)) != null) {
                    com.tencent.liteav.audio.a.a().a(String.valueOf(tinyID), true, TRTCCloudImpl.this.hashCode());
                    TXCLog.i(TRTCCloudImpl.TAG, "[server audio mix] onRecvRawAudioDownStream start audio play, tinyId:" + tinyID + " userId:" + string);
                }
            }
        });
    }

    private void onRequestDownStream(final int err, final String errMsg, final long tinyID, final int stream) {
        if (err != 0) {
            this.runOnListenerThread(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                    if (tRTCCloudListener != null) {
                        tRTCCloudListener.onError(err, errMsg, null);
                    }
                }
            });
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        if (stream != 1 && tinyID == userInfo.tinyID) {
                            TRTCCloudImpl.this.apiLog("onRequestDownStream " + userInfo.tinyID + ", " + userInfo.userID + ", " + stream);
                            if (stream == 7) {
                                if (userInfo.subRender.render != null && userInfo.subRender.render.getStreamType() != stream) {
                                    userInfo.subRender.render.stopVideo();
                                    userInfo.subRender.render.setStreamType(stream);
                                    userInfo.subRender.render.startVideo();
                                }
                            } else if (userInfo.mainRender.render != null && userInfo.mainRender.render.getStreamType() != stream) {
                                userInfo.mainRender.render.stopVideo();
                                userInfo.mainRender.render.setStreamType(stream);
                                userInfo.mainRender.render.startVideo();
                                TXCKeyPointReportProxy.a(String.valueOf(userInfo.tinyID), 40038, 0L, stream);
                            }
                        }
                    }
                });
            }
        });
    }

    private TXCRenderAndDec createRender(long tinyID, int streamType) {
        TXCRenderAndDec tXCRenderAndDec = new TXCRenderAndDec(this.mContext);
        tXCRenderAndDec.setID(String.valueOf(tinyID));
        com.tencent.liteav.renderer.a a2 = new com.tencent.liteav.renderer.a();
        a2.b(true);
        tXCRenderAndDec.setVideoRender(a2);
        tXCRenderAndDec.setStreamType(streamType);
        tXCRenderAndDec.setNotifyListener(this);
        tXCRenderAndDec.setRenderAndDecDelegate(this);
        tXCRenderAndDec.setRenderMode(0);
        tXCRenderAndDec.enableDecoderChange(this.mPerformanceMode != 1);
        tXCRenderAndDec.enableRestartDecoder(this.mRoomInfo.enableRestartDecoder);
        tXCRenderAndDec.enableLimitDecCache(this.mVideoServerConfig.enableHWVUI);
        this.applyRenderConfig(tXCRenderAndDec);
        return tXCRenderAndDec;
    }

    protected void onAVMemberEnter(final long tinyID, final String userID, final int terminalType, final int videoState) {
        final WeakReference<TRTCCloudImpl> weakReference = new WeakReference<TRTCCloudImpl>(this);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                boolean bl2;
                boolean bl3;
                TXCRenderAndDec tXCRenderAndDec;
                if (TRTCCloudImpl.this.mRoomState == 0) {
                    TRTCCloudImpl.this.apiLog("ignore onAVMemberEnter when out room.");
                    return;
                }
                TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)weakReference.get();
                if (tRTCCloudImpl == null) {
                    return;
                }
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userID);
                if (userInfo != null) {
                    TRTCCloudImpl.this.apiLog(" user " + userID + "enter room when user is in room " + tinyID);
                }
                String string = String.valueOf(tinyID);
                if (userInfo == null) {
                    userInfo = TRTCCloudImpl.this.createUserInfo(userID);
                }
                TXCAudioEngine.getInstance().setRemoteAudioStreamEventListener(string, TRTCCloudImpl.this);
                if (TRTCCloudImpl.this.mAudioFrameListener != null) {
                    TXCAudioEngine.getInstance().setSetAudioEngineRemoteStreamDataListener(string, TRTCCloudImpl.this);
                }
                com.tencent.liteav.audio.a.a().a(string, true, TRTCCloudImpl.this.hashCode());
                TXCAudioEngine.getInstance().muteRemoteAudioInSpeaker(string, userInfo.muteAudioInSpeaker);
                if (userInfo.mainRender.muteAudio == TRTCRoomInfo.TRTCRemoteMuteState.MUTE) {
                    TRTCCloudImpl.this.nativeCancelDownStream(TRTCCloudImpl.this.mNativeRtcContext, tinyID, 1, true);
                    TXCAudioEngine.getInstance().muteRemoteAudio(string, true);
                } else if (userInfo.mainRender.muteAudio == TRTCRoomInfo.TRTCRemoteMuteState.UNMUTE) {
                    TRTCCloudImpl.this.nativeRequestDownStream(TRTCCloudImpl.this.mNativeRtcContext, tinyID, 1, true);
                    TXCAudioEngine.getInstance().muteRemoteAudio(string, false);
                }
                TXCRenderAndDec tXCRenderAndDec2 = TRTCCloudImpl.this.createRender(tinyID, TRTCCloudImpl.this.mPriorStreamType);
                RenderListenerAdapter renderListenerAdapter = TRTCCloudImpl.this.mRenderListenerMap.get(userID);
                if (renderListenerAdapter != null) {
                    renderListenerAdapter.strTinyID = string;
                    if (renderListenerAdapter.listener != null) {
                        tXCRenderAndDec2.setVideoFrameListener(TRTCCloudImpl.this, TRTCCloudImpl.this.getPixelFormat(renderListenerAdapter.pixelFormat));
                    }
                }
                userInfo.tinyID = tinyID;
                userInfo.userID = userID;
                userInfo.terminalType = terminalType;
                userInfo.streamState = videoState;
                userInfo.mainRender.render = tXCRenderAndDec2;
                userInfo.mainRender.tinyID = tinyID;
                userInfo.streamType = TRTCCloudImpl.this.mPriorStreamType;
                if (userInfo.mainRender.startRenderView.booleanValue()) {
                    TRTCCloudImpl.this.setRenderView(userID, userInfo.mainRender, userInfo.mainRender.view, userInfo.debugMargin);
                    TRTCCloudImpl.this.apiLog(String.format("startRemoteView when user enter userID:%s tinyID:%d streamType:%d", userID, userInfo.tinyID, userInfo.streamType));
                    TRTCCloudImpl.this.notifyLogByUserId(String.valueOf(userInfo.tinyID), userInfo.streamType, 0, "Start watching " + userID);
                    TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4015, 1L, -1L, "", userInfo.streamType);
                    TRTCCloudImpl.this.startRemoteRender(userInfo.mainRender.render, userInfo.streamType);
                    TRTCCloudImpl.this.muteRemoteVideoStreamInternal(userInfo.userID, 0, userInfo.mainRender.muteVideo == TRTCRoomInfo.TRTCRemoteMuteState.MUTE, false);
                }
                userInfo.mainRender.render.setRenderRotation(userInfo.mainRender.rotation);
                userInfo.mainRender.render.setRenderMode(userInfo.mainRender.renderMode);
                if (userInfo.mainRender.mirrorType == 1) {
                    userInfo.mainRender.render.setRenderMirrorType(1);
                } else {
                    userInfo.mainRender.render.setRenderMirrorType(2);
                }
                userInfo.subRender.render = tXCRenderAndDec = TRTCCloudImpl.this.createRender(tinyID, 7);
                userInfo.subRender.tinyID = tinyID;
                if (userInfo.subRender.startRenderView.booleanValue()) {
                    TRTCCloudImpl.this.setRenderView(userID, userInfo.subRender, userInfo.subRender.view, userInfo.debugMargin);
                    TRTCCloudImpl.this.apiOnlineLog(String.format("onUserScreenAvailable when user enter userID:%s tinyID:%d streamType:%d", userID, userInfo.tinyID, 7));
                    TRTCCloudImpl.this.notifyLogByUserId(String.valueOf(userInfo.tinyID), 7, 0, "Start watching " + userID);
                    TXCEventRecorderProxy.a(String.valueOf(userInfo.tinyID), 4015, 1L, -1L, "", 7);
                    TRTCCloudImpl.this.startRemoteRender(userInfo.subRender.render, 7);
                    TRTCCloudImpl.this.muteRemoteVideoStreamInternal(userInfo.userID, 2, userInfo.subRender.muteVideo == TRTCRoomInfo.TRTCRemoteMuteState.MUTE, false);
                }
                userInfo.subRender.render.setRenderRotation(userInfo.subRender.rotation);
                userInfo.subRender.render.setRenderMode(userInfo.subRender.renderMode);
                if (userInfo.subRender.mirrorType == 1) {
                    userInfo.subRender.render.setRenderMirrorType(1);
                } else {
                    userInfo.subRender.render.setRenderMirrorType(2);
                }
                TRTCCloudImpl.this.mRoomInfo.addUserInfo(userID, userInfo);
                TRTCCloudImpl.this.apiLog("onAVMemberEnter " + tinyID + ", " + userID + ", " + videoState);
                final TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        if (tRTCCloudListener != null && !TRTCCloudImpl.this.isServerAudioMixFakeUser(userID, tinyID)) {
                            tRTCCloudListener.onUserEnter(userID);
                        }
                    }
                });
                boolean bl4 = bl3 = TRTCRoomInfo.hasAudio(videoState) && !TRTCRoomInfo.isMuteAudio(videoState);
                if (bl3) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            if (tRTCCloudListener != null) {
                                tRTCCloudListener.onUserAudioAvailable(userID, bl3);
                            }
                            Monitor.a(2, String.format("onUserAudioAvailable userID:%s, bAvailable:%b", userID, bl3) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                        }
                    });
                    TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]audio Available[true]", userID));
                }
                final boolean bl5 = (TRTCRoomInfo.hasMainVideo(videoState) || TRTCRoomInfo.hasSmallVideo(videoState)) && !TRTCRoomInfo.isMuteMainVideo(videoState);
                boolean bl6 = bl2 = TRTCCloudImpl.this.mRecvMode != 3 && TRTCCloudImpl.this.mRecvMode != 1;
                if (bl5 && (TRTCCloudImpl.this.mRoomInfo.hasRecvFirstIFrame(tinyID, 2) || bl2)) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            if (tRTCCloudListener != null) {
                                tRTCCloudListener.onUserVideoAvailable(userID, bl5);
                            }
                            Monitor.a(2, String.format("onUserVideoAvailable userID:%s, bAvailable:%b", userID, bl5) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                        }
                    });
                    TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]video Available[true]", userID));
                }
                boolean bl7 = bl = TRTCRoomInfo.hasSubVideo(videoState) && !TRTCRoomInfo.isMuteSubVideo(videoState);
                if (bl) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            if (tRTCCloudListener != null) {
                                tRTCCloudListener.onUserSubStreamAvailable(userID, bl);
                            }
                            Monitor.a(2, String.format("onUserSubStreamAvailable userID:%s, bAvailable:%b", userID, bl) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                        }
                    });
                    TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]subvideo Available[true]", userID));
                }
                TRTCCloudImpl.this.notifyEvent(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]enter room", userID));
            }
        });
    }

    protected void onAVMemberExit(final long tinyID, final String userID, int terminalType, final int videoState) {
        final WeakReference<TRTCCloudImpl> weakReference = new WeakReference<TRTCCloudImpl>(this);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mRoomState == 0) {
                    TRTCCloudImpl.this.apiLog("ignore onAVMemberExit when out room.");
                    return;
                }
                TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)weakReference.get();
                if (tRTCCloudImpl == null) {
                    return;
                }
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userID);
                if (null != userInfo) {
                    TRTCCloudImpl.this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 0, 6);
                    TRTCCloudImpl.this.onRemoteVideoStatusUpdatedInternal(userInfo, 7, 0, 6);
                } else {
                    TRTCCloudImpl.this.apiLog("user " + userID + " exit room when user is not in room " + tinyID);
                }
                com.tencent.liteav.audio.a.a().a(String.valueOf(tinyID), TRTCCloudImpl.this.hashCode());
                TXCAudioEngine.getInstance().setSetAudioEngineRemoteStreamDataListener(String.valueOf(tinyID), null);
                TXCAudioEngine.getInstance().setRemoteAudioStreamEventListener(String.valueOf(tinyID), null);
                TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        TRTCCloudImpl.this.apiLog("onAVMemberExit " + tinyID + ", " + userID + ", " + videoState);
                        TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                        if (tRTCCloudListener != null) {
                            if (TRTCRoomInfo.hasAudio(videoState) && !TRTCRoomInfo.isMuteAudio(videoState)) {
                                tRTCCloudListener.onUserAudioAvailable(userID, false);
                                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]audio Available[%b]", userID, false));
                                Monitor.a(2, String.format("onUserAudioAvailable userID:%s, bAvailable:%b", userID, false) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                            }
                            if ((TRTCRoomInfo.hasMainVideo(videoState) || TRTCRoomInfo.hasSmallVideo(videoState)) && !TRTCRoomInfo.isMuteMainVideo(videoState)) {
                                tRTCCloudListener.onUserVideoAvailable(userID, false);
                                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]video Available[%b]", userID, false));
                                Monitor.a(2, String.format("onUserVideoAvailable userID:%s, bAvailable:%b", userID, false) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                            }
                            if (TRTCRoomInfo.hasSubVideo(videoState) && !TRTCRoomInfo.isMuteSubVideo(videoState)) {
                                tRTCCloudListener.onUserSubStreamAvailable(userID, false);
                                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]subVideo Available[%b]", userID, false));
                                Monitor.a(2, String.format("onUserSubStreamAvailable userID:%s, bAvailable:%b", userID, false) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                            }
                            if (!TRTCCloudImpl.this.isServerAudioMixFakeUser(userID, tinyID)) {
                                tRTCCloudListener.onUserExit(userID, 0);
                            }
                        }
                    }
                });
            }
        });
        this.notifyEvent(this.mRoomInfo.getUserId(), 0, String.format("[%s]leave room", userID));
    }

    private void onAVMemberChange(final long tinyID, final String userID, int terminalType, final int streamState, final int oldState) {
        final WeakReference<TRTCCloudImpl> weakReference = new WeakReference<TRTCCloudImpl>(this);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mRoomState == 0) {
                    TRTCCloudImpl.this.apiLog("ignore onAVMemberChange when out room");
                    return;
                }
                TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)weakReference.get();
                if (tRTCCloudImpl == null) {
                    return;
                }
                TRTCCloudImpl.this.apiLog("onAVMemberChange " + tinyID + ", " + userID + ", old state:" + oldState + ", new state:" + streamState);
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userID);
                if (userInfo != null) {
                    userInfo.streamState = streamState;
                    TRTCCloudImpl.this.checkUserState(userID, tinyID, streamState, oldState);
                }
            }
        });
    }

    private void onWholeMemberEnter(final long tinyID, final String userID) {
        final WeakReference<TRTCCloudImpl> weakReference = new WeakReference<TRTCCloudImpl>(this);
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)weakReference.get();
                if (tRTCCloudImpl == null) {
                    return;
                }
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null && !TRTCCloudImpl.this.isServerAudioMixFakeUser(userID, tinyID)) {
                    tRTCCloudListener.onRemoteUserEnterRoom(userID);
                }
            }
        });
    }

    private void onWholeMemberExit(final long tinyID, final String userID, final int exitReason) {
        final WeakReference<TRTCCloudImpl> weakReference = new WeakReference<TRTCCloudImpl>(this);
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)weakReference.get();
                if (tRTCCloudImpl == null) {
                    return;
                }
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null && !TRTCCloudImpl.this.isServerAudioMixFakeUser(userID, tinyID)) {
                    tRTCCloudListener.onRemoteUserLeaveRoom(userID, exitReason);
                }
            }
        });
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userID);
                if (null != userInfo) {
                    TRTCCloudImpl.this.stopRemoteRender(userInfo);
                    TRTCCloudImpl.this.mRoomInfo.removeRenderInfo(userID);
                }
            }
        });
    }

    private void onNotify(long tinyID, int streamType, int err, String errMsg) {
        this.apiLog(tinyID + " event " + err + ", " + errMsg);
        String string = String.valueOf(tinyID);
        Bundle bundle = new Bundle();
        bundle.putLong("EVT_ID", (long)err);
        bundle.putLong("EVT_TIME", System.currentTimeMillis());
        bundle.putString("EVT_MSG", errMsg);
        bundle.putInt("EVT_STREAM_TYPE", streamType);
        if (TextUtils.isEmpty((CharSequence)string) || tinyID == 0L || string.equalsIgnoreCase("18446744073709551615") || string.equalsIgnoreCase(this.mRoomInfo.getTinyId())) {
            this.notifyEvent(this.mRoomInfo.getUserId(), err, bundle);
        } else {
            this.notifyLogByUserId(String.valueOf(tinyID), streamType, err, errMsg);
        }
    }

    public void onAudioQosChanged(int encFrameLenMs, int encBitrate, int fecRate) {
        this.onAudioQosChanged(this, encFrameLenMs, encBitrate, fecRate);
    }

    public void onAudioQosChanged(TRTCCloudImpl cloud, final int encFrameLenMs, final int encBitrate, final int fecRate) {
        if (!this.isPublishingInCloud(cloud, 1)) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXCAudioEngine.getInstance().setAudioEncoderParam(encFrameLenMs, encBitrate);
                TXCAudioEngine.getInstance().setEncoderFECPercent(fecRate);
            }
        });
    }

    public void onVideoQosChanged(int streamType, int width, int height, int fps, int bitrate, int totalBitrate, int rpsNearestMode, int enableH265Enc) {
        this.onVideoQosChanged(this, streamType, width, height, fps, bitrate, totalBitrate, rpsNearestMode, enableH265Enc);
    }

    public void onVideoQosChanged(TRTCCloudImpl cloud, final int streamType, final int width, final int height, final int fps, final int bitrate, final int totalBitrate, final int rpsNearestMode, final int enableH265Enc) {
        if (!this.isPublishingInCloud(cloud, streamType)) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                boolean bl2 = bl = enableH265Enc == 1;
                if (streamType == 7) {
                    if (TRTCCloudImpl.this.mSubStreamCaptureAndEnc != null) {
                        TRTCCloudImpl.this.mSubStreamCaptureAndEnc.a(streamType, width, height, fps, bitrate, totalBitrate, rpsNearestMode, bl);
                    }
                } else if (streamType == 2) {
                    int n2;
                    TRTCCloudImpl.this.mCaptureAndEnc.a(streamType, width, height, fps, bitrate, totalBitrate, rpsNearestMode, bl);
                    int n3 = n2 = width > height ? 0 : 1;
                    if (TRTCCloudImpl.this.mConfig.o != n2 && width != height) {
                        TRTCCloudImpl.this.mConfig.o = n2;
                        TRTCCloudImpl.this.updateOrientation();
                    }
                }
                TRTCCloudImpl.this.mH265Decision.setEnableH265EncodeByServer(bl, TRTCEncodeTypeDecision.ModifyCodecReason.REASON_QOS);
            }
        });
    }

    public void notifyCurrentEncodeType(final boolean isH265) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener == null) {
                    return;
                }
                Bundle bundle = new Bundle();
                bundle.putInt("type", isH265 ? 1 : 0);
                String string = String.format("Current encoder type is %s encoder", isH265 ? "H265" : "H264");
                tRTCCloudListener.onWarning(1104, string, bundle);
            }
        });
    }

    public void onIdrFpsChanged(int fps) {
        this.onIdrFpsChanged(this, fps);
    }

    public void onIdrFpsChanged(TRTCCloudImpl cloud, final int fps) {
        if (!this.isPublishingInCloud(cloud, 2)) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mCaptureAndEnc.c(fps);
            }
        });
    }

    private void onVideoBlockThresholdChanged(final int videoBlockThreshold) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        if (userInfo.mainRender.render != null) {
                            userInfo.mainRender.render.setBlockInterval(videoBlockThreshold);
                        }
                        if (userInfo.subRender.render != null) {
                            userInfo.subRender.render.setBlockInterval(videoBlockThreshold);
                        }
                    }
                });
            }
        });
    }

    private void resetFeelingBlockReport() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        if (userInfo.mainRender.render != null) {
                            userInfo.mainRender.render.resetPeriodFeelingStatistics();
                        }
                        if (userInfo.subRender.render != null) {
                            userInfo.subRender.render.resetPeriodFeelingStatistics();
                        }
                    }
                });
            }
        });
    }

    private void onConnectionLost() {
        this.mRoomInfo.networkStatus = 1;
        this.notifyEvent(this.mRoomInfo.getUserId(), 0, "Network anomaly.");
        this.apiOnlineLog("onConnectionLost");
        this.resetFeelingBlockReport();
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onConnectionLost();
                }
            }
        });
    }

    private void onTryToReconnect() {
        this.mRoomInfo.networkStatus = 2;
        this.notifyEvent(this.mRoomInfo.getUserId(), 0, "Retry enter room.");
        this.apiOnlineLog("onTryToReconnect");
        this.resetFeelingBlockReport();
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onTryToReconnect();
                }
            }
        });
    }

    private void onConnectionRecovery() {
        this.mRoomInfo.networkStatus = 3;
        this.notifyEvent(this.mRoomInfo.getUserId(), 0, "Network recovered. Successfully re-enter room");
        this.apiOnlineLog("onConnectionRecovery");
        this.resetFeelingBlockReport();
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onConnectionRecovery();
                }
            }
        });
    }

    private void onSendCustomCmdMsgResult(int cmdID, int seq, int errCode, String errMsg) {
    }

    private void onRecvCustomCmdMsg(final String userId, long tinyId, final int cmdID, final int seq, final byte[] msg, final boolean ordered, final int missMsgCount, long recvTimeMs) {
        long l2 = System.currentTimeMillis();
        ++this.mRecvCustomCmdMsgCountInPeriod;
        if (l2 - this.mLastLogCustomCmdMsgTs > 10000L) {
            TXCLog.i(TAG, "onRecvMsg. tinyId=" + tinyId + ", streamId = " + cmdID + ", msg = " + msg + ", recvTime = " + recvTimeMs + ", recvCustomMsgCountInPeriod = " + this.mRecvCustomCmdMsgCountInPeriod + " self:" + this.hashCode());
            this.mLastLogCustomCmdMsgTs = l2;
            this.mRecvCustomCmdMsgCountInPeriod = 0L;
        }
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onRecvCustomCmdMsg(userId, cmdID, seq, msg);
                    if (ordered && missMsgCount > 0) {
                        tRTCCloudListener.onMissCustomCmdMsg(userId, cmdID, -1, missMsgCount);
                    }
                }
            }
        });
    }

    private void onRecvSEIMsg(final long tinyId, final byte[] message) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    try {
                        String string = TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(tinyId);
                        if (string != null) {
                            long l2 = System.currentTimeMillis();
                            TRTCCloudImpl.this.mRecvSEIMsgCountInPeriod++;
                            if (l2 - TRTCCloudImpl.this.mLastLogSEIMsgTs > 10000L) {
                                TXCLog.i(TRTCCloudImpl.TAG, "onRecvSEIMsg. userId=" + string + ", message = " + new String(message) + ", recvSEIMsgCountInPeriod = " + TRTCCloudImpl.this.mRecvSEIMsgCountInPeriod + " self:" + TRTCCloudImpl.this.hashCode());
                                TRTCCloudImpl.this.mLastLogSEIMsgTs = l2;
                                TRTCCloudImpl.this.mRecvSEIMsgCountInPeriod = 0L;
                            }
                            tRTCCloudListener.onRecvSEIMsg(string, message);
                        } else {
                            TXCLog.i(TRTCCloudImpl.TAG, "onRecvSEIMsg Error, user id is null for tinyId=" + tinyId + " self:" + TRTCCloudImpl.this.hashCode());
                        }
                    }
                    catch (Exception exception) {
                        TXCLog.e(TRTCCloudImpl.TAG, "onRecvSEIMsg failed.", exception);
                    }
                }
            }
        });
    }

    private void onSpeedTest(final boolean success, final String errMsg, final String ip, final int rtt, final float upLoss, final float downLoss, final int finishedCount, final int totalCount) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    TRTCCloudDef.TRTCSpeedTestResult tRTCSpeedTestResult = new TRTCCloudDef.TRTCSpeedTestResult();
                    tRTCSpeedTestResult.success = success;
                    tRTCSpeedTestResult.errMsg = errMsg;
                    tRTCSpeedTestResult.ip = ip;
                    tRTCSpeedTestResult.rtt = rtt;
                    tRTCSpeedTestResult.upLostRate = upLoss;
                    tRTCSpeedTestResult.downLostRate = downLoss;
                    tRTCSpeedTestResult.quality = upLoss >= downLoss ? TRTCCloudImpl.this.getNetworkQuality(rtt, (int)(upLoss * 100.0f)) : TRTCCloudImpl.this.getNetworkQuality(rtt, (int)(downLoss * 100.0f));
                    tRTCCloudListener.onSpeedTest(tRTCSpeedTestResult, finishedCount, totalCount);
                    TRTCCloudImpl.this.apiLog("SpeedTest progress %d/%d, result: %s", finishedCount, totalCount, tRTCSpeedTestResult.toString());
                }
            }
        });
    }

    private void onSpeedTest(final boolean success, final String errMsg, final String ip, final int quality, final float upLoss, final float downLoss, final int rtt, final int availableUpBandwidth, final int availableDownBandwidth) {
        this.apiLog("onSpeedTest success:%b errMsg:%s ip:%s quality:%d upLoss:%f downLoss:%f rtt:%d availableUpBandwidth:%d availableDownBandwidth:%d", success, errMsg, ip, quality, Float.valueOf(upLoss), Float.valueOf(downLoss), rtt, availableUpBandwidth, availableDownBandwidth);
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    TRTCCloudDef.TRTCSpeedTestResult tRTCSpeedTestResult = new TRTCCloudDef.TRTCSpeedTestResult();
                    tRTCSpeedTestResult.success = success;
                    tRTCSpeedTestResult.errMsg = errMsg;
                    tRTCSpeedTestResult.ip = ip;
                    tRTCSpeedTestResult.quality = quality;
                    tRTCSpeedTestResult.upLostRate = upLoss;
                    tRTCSpeedTestResult.downLostRate = downLoss;
                    tRTCSpeedTestResult.rtt = rtt;
                    tRTCSpeedTestResult.availableUpBandwidth = availableUpBandwidth;
                    tRTCSpeedTestResult.availableDownBandwidth = availableDownBandwidth;
                    tRTCCloudListener.onSpeedTestResult(tRTCSpeedTestResult);
                }
            }
        });
    }

    public void onVideoConfigChanged(int stream, boolean enableRPS) {
        this.onVideoConfigChanged(this, stream, enableRPS);
    }

    public void onVideoConfigChanged(TRTCCloudImpl cloud, final int stream, final boolean enableRPS) {
        if (!this.isPublishingInCloud(cloud, stream)) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (stream == 2) {
                    if (TRTCCloudImpl.this.isRPSSupported()) {
                        TRTCCloudImpl.this.mCaptureAndEnc.h(enableRPS);
                    } else {
                        TRTCCloudImpl.this.mCaptureAndEnc.h(false);
                    }
                }
            }
        });
    }

    private void updateRemoteVideoStatusByFirstFrame(TRTCRoomInfo.UserInfo userInfo, int stream, boolean firstCount) {
        if (stream == 7) {
            if (userInfo.subRender.render != null && TRTCRoomInfo.hasSubVideo(userInfo.streamState) && !TRTCRoomInfo.isMuteSubVideo(userInfo.streamState) && userInfo.subRender.muteVideo != TRTCRoomInfo.TRTCRemoteMuteState.MUTE) {
                if (firstCount || userInfo.subRender.lastVideoStatusChangeOperation == 0) {
                    this.onRemoteVideoStatusUpdatedInternal(userInfo, 7, 1, 3);
                    userInfo.subRender.lastVideoStatusChangeOperation = 2;
                } else if (userInfo.subRender.lastVideoStatusChangeOperation == 2) {
                    this.onRemoteVideoStatusUpdatedInternal(userInfo, 7, 1, 3);
                } else if (userInfo.subRender.lastVideoStatusChangeOperation == 4) {
                    this.onRemoteVideoStatusUpdatedInternal(userInfo, 7, 1, 5);
                }
            }
        } else if (userInfo.mainRender.render != null && (TRTCRoomInfo.hasMainVideo(userInfo.streamState) || TRTCRoomInfo.hasSmallVideo(userInfo.streamState)) && !TRTCRoomInfo.isMuteMainVideo(userInfo.streamState) && userInfo.mainRender.muteVideo != TRTCRoomInfo.TRTCRemoteMuteState.MUTE) {
            if (firstCount || userInfo.mainRender.lastVideoStatusChangeOperation == 0) {
                this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 1, 3);
                userInfo.mainRender.lastVideoStatusChangeOperation = 2;
            } else if (userInfo.mainRender.lastVideoStatusChangeOperation == 2) {
                this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 1, 3);
            } else if (userInfo.mainRender.lastVideoStatusChangeOperation == 4) {
                this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 1, 5);
            }
        }
    }

    private void onRecvFirstAudio(long tinyId) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void onRecvFirstVideo(final long tinyId, final int streamType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                TRTCRoomInfo.UserInfo userInfo = null;
                try {
                    String string = TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(tinyId);
                    if (string != null) {
                        userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(string);
                    }
                }
                catch (Exception exception) {
                    TXCLog.e(TRTCCloudImpl.TAG, "get user info failed.", exception);
                }
                if (userInfo == null) {
                    return;
                }
                int n2 = TRTCCloudImpl.this.mRoomInfo.recvFirstIFrame(tinyId, streamType);
                TRTCCloudImpl.this.apiLog("onRecvFirstVideo " + tinyId + ", " + n2 + ", streamType=" + streamType);
                if (streamType == 7) {
                    TRTCCloudImpl.this.updateRemoteVideoStatusByFirstFrame(userInfo, 7, n2 == 1);
                } else {
                    TRTCCloudImpl.this.updateRemoteVideoStatusByFirstFrame(userInfo, 2, n2 == 1);
                }
                boolean bl2 = bl = TRTCCloudImpl.this.mRecvMode != 3 && TRTCCloudImpl.this.mRecvMode != 1;
                if (n2 > 1 || bl || streamType != 2) {
                    return;
                }
                final String string = userInfo.userID;
                if ((TRTCRoomInfo.hasMainVideo(userInfo.streamState) || TRTCRoomInfo.hasSmallVideo(userInfo.streamState)) && !TRTCRoomInfo.isMuteMainVideo(userInfo.streamState)) {
                    TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                        @Override
                        public void run() {
                            TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                            if (tRTCCloudListener != null) {
                                tRTCCloudListener.onUserVideoAvailable(string, true);
                                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, String.format("[%s]video Available[%b]", string, true));
                                Monitor.a(2, String.format("onUserVideoAvailable by recv first video. userID:%s, bAvailable:%b", string, true) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                            }
                        }
                    });
                }
            }
        });
    }

    private void onStartPublishing(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("onStartPublishing err:" + code + ", msg:" + msg);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onStartPublishing(code, msg);
                }
            }
        });
    }

    private void onStopPublishing(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("onStopPublishing err:" + code + ", msg:" + msg);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onStopPublishing(code, msg);
                }
            }
        });
    }

    private void onStreamPublished(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("onStreamPublished err:" + code + ", msg:" + msg);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onStartPublishCDNStream(code, msg);
                }
            }
        });
    }

    private void onStreamUnpublished(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("onStreamUnpublished err:" + code + ", msg:" + msg);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onStopPublishCDNStream(code, msg);
                }
            }
        });
    }

    private void onTranscodingUpdated(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog("onTranscodingUpdated err:" + code + ", msg:" + msg);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onSetMixTranscodingConfig(code, msg);
                }
            }
        });
    }

    protected void onCancelTranscoding(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiOnlineLog(String.format("onCancelTranscoding err:%d, msg:%s", code, msg));
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onSetMixTranscodingConfig(code, msg);
                }
            }
        });
    }

    private void onChangeRole(final int code, final String msg) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                if (code == 0) {
                    TRTCCloudImpl.this.mCurrentRole = TRTCCloudImpl.this.mTargetRole;
                } else {
                    TRTCCloudImpl.this.mCurrentRole = 21;
                    TRTCCloudImpl.this.mTargetRole = 21;
                }
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onSwitchRole(code, msg);
                }
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        if (userInfo.mainRender.render != null) {
                            TRTCCloudImpl.this.applyRenderPlayStrategy(userInfo.mainRender.render, userInfo.mainRender.render.getConfig());
                        }
                    }
                });
                TRTCCloudImpl.this.notifyEvent(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, "onChangeRole:" + code);
                TRTCCloudImpl.this.apiOnlineLog("onChangeRole err:%d, msg:%s", code, msg);
            }
        });
    }

    protected void onSendFirstLocalVideoFrame(final int streamType) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onSendFirstLocalVideoFrame " + streamType);
                int n2 = TRTCCloudImpl.this.translateStreamType(streamType);
                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, "onSendFirstLocalVideoFrame:" + n2);
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onSendFirstLocalVideoFrame(n2);
                }
            }
        });
    }

    protected void onSendFirstLocalAudioFrame() {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onSendFirstLocalAudioFrame");
                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), 0, "onSendFirstLocalAudioFrame");
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onSendFirstLocalAudioFrame();
                }
            }
        });
    }

    private static TRTCVideoServerConfig createVideoServerConfigFromNative() {
        return new TRTCVideoServerConfig();
    }

    private void onRecvVideoServerConfig(final TRTCVideoServerConfig videoConfig) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onRecvVideoServerConfig " + videoConfig);
                TRTCCloudImpl.this.mVideoServerConfig = videoConfig;
                TRTCVideoServerConfig.saveToSharedPreferences(TRTCCloudImpl.this.mContext, videoConfig);
                TRTCCloudImpl.this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        TXCRenderAndDec tXCRenderAndDec = userInfo.mainRender.render;
                        if (tXCRenderAndDec != null) {
                            tXCRenderAndDec.enableLimitDecCache(((TRTCCloudImpl)TRTCCloudImpl.this).mVideoServerConfig.enableHWVUI);
                        }
                        if ((tXCRenderAndDec = userInfo.subRender.render) != null) {
                            tXCRenderAndDec.enableLimitDecCache(((TRTCCloudImpl)TRTCCloudImpl.this).mVideoServerConfig.enableHWVUI);
                        }
                    }
                });
            }
        });
    }

    private void onLocalRecordBegin(final int errCode, final String storagePath) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onLocalRecordBegin " + errCode + " " + storagePath);
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    TRTCCloudImpl.this.mTRTCListener.onLocalRecordBegin(errCode, storagePath);
                }
            }
        });
    }

    private void onLocalRecordComplete(final int errCode, final String storagePath) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.apiLog("onLocalRecordComplete " + errCode + " " + storagePath);
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    TRTCCloudImpl.this.mTRTCListener.onLocalRecordComplete(errCode, storagePath);
                }
            }
        });
    }

    private void onLocalRecording(final long duration, final String storagePath) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                if (TRTCCloudImpl.this.mTRTCListener != null) {
                    TRTCCloudImpl.this.mTRTCListener.onLocalRecording(duration, storagePath);
                }
            }
        });
    }

    private static AudioServerConfig createAudioServerConfigFromNative() {
        return new AudioServerConfig();
    }

    private void onRecvAudioServerConfig(AudioServerConfig audioConfig) {
        TXCLog.i(TAG, "on receive audio config: [%s]", audioConfig);
        AudioServerConfig.saveToSharedPreferences(this.mContext, audioConfig);
        TXCAudioEngine.getInstance().setServer3AConfig(audioConfig.aecLevel, audioConfig.ansLevel, audioConfig.agcLevel);
        TXCAudioEngine.getInstance().enableAutoRestartDevice(audioConfig.enableAutoRestartDevice);
        TXCAudioEngine.getInstance().setMaxSelectedPlayStreams(audioConfig.maxSelectedPlayStreams);
        TXCAudioEngine.getInstance().enableInbandFEC(audioConfig.enableInbandFEC != 0);
        TXCAudioEngine.getInstance().enableDeviceAbnormalDetection(audioConfig.enableDeviceAbnormalDetection != 0);
        TXCAudioEngine.getInstance().setAudioQuality(audioConfig.audioSampleRate, audioConfig.audioChannel, audioConfig.audioBitrate, audioConfig.encodeMode, audioConfig.systemVolumeType, 5);
    }

    private void onRecvEnterRoomVideoConfig(final boolean enableH265ByServer) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.mH265Decision.setEnableH265EncodeByServer(enableH265ByServer, TRTCEncodeTypeDecision.ModifyCodecReason.REASON_ENTERROOM_RESPOND);
                boolean bl = TRTCCloudImpl.this.mH265Decision.isVideoEncoderCodecUsingH265();
                if (TRTCCloudImpl.this.mCaptureAndEnc != null) {
                    TXCLog.i(TRTCCloudImpl.TAG, "codecability onRecvEnterRoomVideoConfig: enabledHevc =" + bl);
                    TRTCCloudImpl.this.mCaptureAndEnc.k(bl);
                }
            }
        });
    }

    private void store(String key, String value) {
        this.mRoomInfo.store(this.mContext, key, value);
    }

    private String query(String key) {
        return this.mRoomInfo.query(this.mContext, key);
    }

    private void setQoSParams() {
        TXCAudioEncoderConfig tXCAudioEncoderConfig = TXCAudioEngine.getInstance().getAudioEncoderConfig();
        TXCLog.i("", "setQoSParams:" + tXCAudioEncoderConfig.sampleRate + " " + tXCAudioEncoderConfig.channels + " " + tXCAudioEncoderConfig.minBitrate + " " + tXCAudioEncoderConfig.maxBitrate);
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(1);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeSetAudioEncodeConfiguration(l2, tXCAudioEncoderConfig.minBitrate, tXCAudioEncoderConfig.maxBitrate, tXCAudioEncoderConfig.sampleRate, tXCAudioEncoderConfig.channels);
        }
    }

    protected void runOnMainThread(Runnable task) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mMainHandler.post(task);
        } else {
            task.run();
        }
    }

    private void runOnMainThreadAndWaitDone(Runnable task) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mMainHandler.a(task);
        } else {
            task.run();
        }
    }

    protected void runOnListenerThread(Runnable task) {
        Handler handler = this.mListenerHandler;
        if (handler == null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mMainHandler.post(task);
            } else {
                task.run();
            }
        } else if (Looper.myLooper() != handler.getLooper()) {
            handler.post(task);
        } else {
            task.run();
        }
    }

    private void runOnListenerThread(Runnable task, int delayMill) {
        Handler handler = this.mListenerHandler;
        if (handler == null) {
            this.mMainHandler.postDelayed(task, delayMill);
        } else {
            handler.postDelayed(task, (long)delayMill);
        }
    }

    private void runOnSDKThread(Runnable task, int delayMill) {
        if (this.mSDKHandler != null) {
            this.mSDKHandler.postDelayed(task, delayMill);
        }
    }

    protected void runOnSDKThread(Runnable task) {
        if (this.mSDKHandler != null && this.mIsSDKThreadAlive.get()) {
            if (Looper.myLooper() != this.mSDKHandler.getLooper()) {
                try {
                    this.mSDKHandler.post(task);
                }
                catch (Exception exception) {
                    TXCLog.e(TAG, "(" + this.hashCode() + ")trtc_api run on sdk fail. alive:" + this.mIsSDKThreadAlive.get(), exception);
                }
            } else {
                task.run();
            }
        } else {
            TXCLog.e(TAG, "(" + this.hashCode() + ")trtc_api sdk thread is dead, ignore task.");
        }
    }

    private void runOnSDKThreadAndWaitDone(Runnable task, long timeoutMS) {
        if (this.mSDKHandler != null) {
            if (Looper.myLooper() != this.mSDKHandler.getLooper()) {
                this.mSDKHandler.a(task, timeoutMS);
            } else {
                task.run();
            }
        }
    }

    private int getCompatibleRotation(int rotation) {
        if (rotation < 0) {
            return 0;
        }
        if (rotation > 3) {
            return rotation / 90 * 90;
        }
        return rotation * 90;
    }

    private boolean isRPSSupported() {
        return TXCSWVideoEncoder.isRPSSupported();
    }

    public void updateAppScene(int appScene) {
        this.mAppScene = appScene;
        if (this.mAppScene != 0 && this.mAppScene != 1) {
            this.mAppScene = 0;
        }
        if (this.mConfig.a * this.mConfig.b >= 518400) {
            this.mAppScene = 1;
        }
        this.updateEncType();
        this.apiLog(String.format("update appScene[%d] for video enc[%d] source scene[%d]", this.mAppScene, this.mConfig.m, appScene));
    }

    private void updateEncType() {
        if (this.mCodecType == 0 || this.mCodecType == 1) {
            this.mConfig.m = this.mCodecType;
        } else if (this.mAppScene == 1) {
            this.mConfig.m = 1;
        }
    }

    private int GetPublishingCloudState(int streamType) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(streamType);
        if (tRTCCloudImpl != null) {
            return tRTCCloudImpl.mRoomState;
        }
        return 0;
    }

    private void setVideoEncConfig(int streamType, int width, int height, int fps, int bitrate, boolean isEnableAdjustRes, int minBitrate, boolean setByAPI) {
        if (this.GetPublishingCloudState(streamType) == 0) {
            this.apiLog("setVideoEncConfig ignore when no in room");
            return;
        }
        if (this.mCodecType != 2) {
            this.setVideoEncoderConfiguration(streamType, width, height, fps, bitrate, 1, isEnableAdjustRes, minBitrate, setByAPI);
        } else {
            this.setVideoEncoderConfiguration(streamType, width, height, fps, bitrate, this.isRPSSupported() ? this.mAppScene : 1, isEnableAdjustRes, minBitrate, setByAPI);
        }
    }

    protected void setRenderView(final String userId, final TRTCRoomInfo.RenderInfo renderInfo, final TXCloudVideoView view, final TRTCCloud.TRTCViewMargin debugMargin) {
        if (renderInfo == null || renderInfo.render == null || renderInfo.render.getVideoRender() == null) {
            return;
        }
        final e e2 = renderInfo.render.getVideoRender();
        if (view == null || view.getOpenGLContext() != null) {
            Object object = view == null ? null : view.getOpenGLContext();
            this.apiLog("setRenderView sharedContext: " + object);
            e2.c(object);
            return;
        }
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                e2.b(true);
                SurfaceView surfaceView = view.getSurfaceView();
                if (surfaceView != null) {
                    surfaceView.setVisibility(0);
                    SurfaceHolder surfaceHolder = surfaceView.getHolder();
                    surfaceHolder.removeCallback((SurfaceHolder.Callback)renderInfo);
                    surfaceHolder.addCallback((SurfaceHolder.Callback)renderInfo);
                    if (surfaceHolder.getSurface().isValid()) {
                        TRTCCloudImpl.this.apiLog(String.format(Locale.ENGLISH, "startRemoteView with valid surface %s, width: %d, height: %d", surfaceHolder.getSurface(), surfaceView.getWidth(), surfaceView.getHeight()));
                        e2.a(surfaceHolder.getSurface());
                        e2.d(surfaceView.getWidth(), surfaceView.getHeight());
                    } else {
                        TRTCCloudImpl.this.apiLog("startRemoteView with surfaceView add callback " + renderInfo);
                    }
                } else {
                    TextureView textureView = new TextureView(view.getContext());
                    view.addVideoView(textureView);
                    view.setVisibility(0);
                    view.setUserId(userId);
                    view.showVideoDebugLog(TRTCCloudImpl.this.mDebugType);
                    if (debugMargin != null) {
                        view.setLogMarginRatio(debugMargin.leftMargin, debugMargin.rightMargin, debugMargin.topMargin, debugMargin.bottomMargin);
                    }
                    e2.a(textureView);
                }
            }
        });
    }

    private void startRemoteRender(TXCRenderAndDec render, int streamType) {
        render.stopVideo();
        render.setStreamType(streamType);
        render.startVideo();
    }

    private void stopRemoteSubRender(TRTCRoomInfo.UserInfo userInfo) {
        if (userInfo == null) {
            return;
        }
        this.apiLog(String.format("stopRemoteRender userID:%s tinyID:%d streamType:%d", userInfo.userID, userInfo.tinyID, 7));
        this.nativeCancelDownStream(this.mNativeRtcContext, userInfo.tinyID, 7, false);
        userInfo.subRender.lastVideoStatusChangeOperation = 1;
        this.onRemoteVideoStatusUpdatedInternal(userInfo, 7, 0, 4);
        if (userInfo.subRender.render != null) {
            userInfo.subRender.render.stopVideo();
        }
    }

    private void stopRemoteMainRender(TRTCRoomInfo.UserInfo userInfo, Boolean muteStream) {
        if (userInfo == null) {
            return;
        }
        this.apiLog(String.format("stopRemoteRender userID:%s tinyID:%d streamType:%d", userInfo.userID, userInfo.tinyID, userInfo.streamType));
        this.nativeCancelDownStream(this.mNativeRtcContext, userInfo.tinyID, 2, muteStream);
        this.nativeCancelDownStream(this.mNativeRtcContext, userInfo.tinyID, 3, muteStream);
        userInfo.mainRender.lastVideoStatusChangeOperation = 1;
        this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 0, 4);
        if (userInfo.mainRender.render != null) {
            userInfo.mainRender.render.stopVideo();
        }
    }

    protected void stopRemoteRender(TRTCRoomInfo.UserInfo userInfo) {
        if (userInfo == null) {
            return;
        }
        this.apiLog(String.format("stopRemoteRender userID:%s tinyID:%d streamType:%d", userInfo.userID, userInfo.tinyID, userInfo.streamType));
        com.tencent.liteav.audio.a.a().a(String.valueOf(userInfo.tinyID), this.hashCode());
        final TXCloudVideoView tXCloudVideoView = userInfo.mainRender.view;
        final TXCloudVideoView tXCloudVideoView2 = userInfo.subRender.view;
        if (userInfo.mainRender.render != null) {
            userInfo.mainRender.render.setVideoFrameListener(null, b.a);
            userInfo.mainRender.render.stop();
            if ((tXCloudVideoView == null || tXCloudVideoView.getOpenGLContext() != null) && userInfo.mainRender.render.getVideoRender() != null) {
                userInfo.mainRender.render.getVideoRender().d();
            }
        }
        if (userInfo.subRender.render != null) {
            userInfo.subRender.render.setVideoFrameListener(null, b.a);
            userInfo.subRender.render.stop();
            if ((tXCloudVideoView2 == null || tXCloudVideoView2.getOpenGLContext() != null) && userInfo.subRender.render.getVideoRender() != null) {
                userInfo.subRender.render.getVideoRender().d();
            }
        }
        userInfo.mainRender.stop();
        userInfo.subRender.stop();
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (tXCloudVideoView != null) {
                    tXCloudVideoView.removeVideoView();
                }
                if (tXCloudVideoView2 != null) {
                    tXCloudVideoView2.removeVideoView();
                }
            }
        });
    }

    protected void enableVideoStream(int streamType, boolean enable) {
        if (enable) {
            if (streamType != 2) {
                this.addUpStreamType(2);
                if (this.mEnableSmallStream) {
                    this.addUpStreamType(3);
                }
            } else {
                this.addUpStreamType(7);
            }
        } else if (streamType != 2) {
            if (!this.mCaptureAndEnc.j()) {
                this.removeUpStreamType(2);
            }
            this.removeUpStreamType(3);
        } else {
            this.removeUpStreamType(7);
        }
    }

    protected void enableAudioStream(boolean enable) {
        if (enable) {
            this.addUpStreamType(1);
        } else {
            this.removeUpStreamType(1);
        }
    }

    private void applyRenderConfig(TXCRenderAndDec renderAndDec) {
        int n2;
        h h2 = new h();
        h2.h = false;
        if (this.mAppScene == 1) {
            h2.h = true;
        }
        if ((n2 = TXCStatus.c("18446744073709551615", 17020)) == 0) {
            n2 = 600;
        }
        h2.d = n2;
        h2.t = this.mRoomInfo.decProperties;
        this.applyRenderPlayStrategy(renderAndDec, h2);
    }

    private void applyRenderPlayStrategy(TXCRenderAndDec renderAndDec, h playerConfig) {
        playerConfig.g = true;
        if (this.mCurrentRole == 20) {
            playerConfig.a = a.a;
            playerConfig.c = a.b;
            playerConfig.b = a.c;
        } else if (this.mCurrentRole == 21) {
            playerConfig.a = a.f;
            playerConfig.c = a.g;
            playerConfig.b = a.h;
        }
        renderAndDec.setConfig(playerConfig);
    }

    private void notifyLogByUserId(String tinyID, int streamType, int errCode, String log) {
        if (tinyID == null || log == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("EVT_ID", (long)errCode);
        bundle.putLong("EVT_TIME", System.currentTimeMillis());
        bundle.putString("EVT_MSG", log);
        bundle.putInt("EVT_STREAM_TYPE", streamType);
        this.notifyEventByUserId(tinyID, errCode, bundle);
    }

    private void notifyEventByUserId(final String tinyID, final int event, final Bundle param) {
        if (tinyID == null || param == null) {
            return;
        }
        if (tinyID.equalsIgnoreCase(String.valueOf(0x7EEEEEEE22222222L))) {
            this.notifyEvent(SERVER_AUDIOMIX_FAKE_USERID, event, param);
            return;
        }
        this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

            @Override
            public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                if (tinyID.equalsIgnoreCase(String.valueOf(userInfo.tinyID))) {
                    TRTCCloudImpl.this.notifyEvent(userInfo.userID, event, param);
                }
            }
        });
    }

    private void appendDashboardLog(String userId, int streamType, String log) {
        this.appendDashboardLog(userId, streamType, log, "");
    }

    private void appendDashboardLog(String userId, int streamType, String log, String preLog) {
        Object object;
        this.apiLog(preLog + log);
        TXCloudVideoView tXCloudVideoView = null;
        if (TextUtils.isEmpty((CharSequence)userId) || this.mRoomInfo.userId != null && userId.equalsIgnoreCase(this.mRoomInfo.userId)) {
            tXCloudVideoView = this.mRoomInfo.localView;
        } else {
            object = this.mRoomInfo.getUser(userId);
            if (object != null) {
                tXCloudVideoView = streamType == 7 ? ((TRTCRoomInfo.UserInfo)object).subRender.view : ((TRTCRoomInfo.UserInfo)object).mainRender.view;
            }
        }
        object = tXCloudVideoView;
        this.runOnMainThread(new Runnable((TXCloudVideoView)((Object)object), log){
            final /* synthetic */ TXCloudVideoView val$finalView;
            final /* synthetic */ String val$log;
            {
                this.val$finalView = tXCloudVideoView;
                this.val$log = string;
            }

            @Override
            public void run() {
                if (this.val$finalView != null) {
                    this.val$finalView.appendEventInfo(this.val$log);
                }
            }
        });
    }

    private Pair<Integer, String> getEncoderTypeAndMsg(Bundle eventParam) {
        String string = "";
        int n2 = eventParam.getInt("EVT_PARAM1", 0);
        if (n2 == c.a.a.a() || n2 == c.a.b.a()) {
            n2 = 0;
            string = String.format(Locale.getDefault(), "Current encode type is %s encoder", "H264");
        } else if (n2 == c.a.c.a() || n2 == c.a.d.a()) {
            n2 = 1;
            string = String.format(Locale.getDefault(), "Current encode type is %s encoder", "H265");
        }
        return new Pair((Object)n2, (Object)string);
    }

    protected void notifyEvent(final String userId, final int eventCode, final Bundle eventParam) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                int n2;
                TRTCCloudImpl.this.appendDashboardLog(userId, eventParam.getInt("EVT_STREAM_TYPE", 2), eventParam.getString("EVT_MSG", ""), String.format("event %d, ", eventCode));
                if (eventCode == 2029) {
                    TRTCCloudImpl.this.apiLog("release mic~");
                    if (TRTCCloudImpl.this.mRoomInfo.isRoomExit()) {
                        TRTCCloudImpl.this.apiLog("onExitRoom when mic release.");
                        n2 = TRTCCloudImpl.this.mRoomInfo.getRoomExitCode();
                        TRTCCloudImpl.this.mRoomInfo.setRoomExit(false, 0);
                        TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                            @Override
                            public void run() {
                                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                                if (tRTCCloudListener != null) {
                                    tRTCCloudListener.onExitRoom(n2);
                                }
                            }
                        });
                    } else {
                        TRTCCloudImpl.this.mRoomInfo.micStart(false);
                    }
                } else if (eventCode == 2027) {
                    TRTCCloudImpl.this.apiLog(String.format("onMicDidReady~", new Object[0]));
                    TRTCCloudImpl.this.mRoomInfo.micStart(true);
                } else {
                    if (eventCode == -2304 || eventCode == -2312) {
                        TXCLog.i(TRTCCloudImpl.TAG, "codecability eventCode = ERR_H265_DECODE_FAIL");
                        int n3 = 3;
                        TRTCCloudImpl.this.mH265Decision.setEnableH265EncodeByPrivateAPI(false, TRTCEncodeTypeDecision.ModifyCodecReason.REASON_DECODE_ERROR);
                        TRTCCloudImpl.this.mCaptureAndEnc.k(false);
                        TRTCCloudImpl.this.notifyCurrentEncodeType(false);
                        TRTCCloudImpl.this.nativeFlushC2SVideoCodecConfig(TRTCCloudImpl.this.mNativeRtcContext, n3, h.a.a.a());
                        return;
                    }
                    if (eventCode == -2310 || eventCode == -2311) {
                        TXCLog.i(TRTCCloudImpl.TAG, "codecability eventCode: " + eventCode);
                        TRTCCloudImpl.this.mH265Decision.setEnableH265EncodeByPrivateAPI(false, TRTCEncodeTypeDecision.ModifyCodecReason.REASON_ENCODE_ERROR);
                        int n4 = 3 | TRTCEncodeTypeDecision.getH265DecoderValue();
                        TRTCCloudImpl.this.nativeFlushC2SVideoCodecConfig(TRTCCloudImpl.this.mNativeRtcContext, n4, h.a.a.a());
                        return;
                    }
                    if (eventCode == 1008) {
                        Pair pair = TRTCCloudImpl.this.getEncoderTypeAndMsg(eventParam);
                        int n5 = eventParam.getInt("EVT_STREAM_TYPE", 0);
                        TXCEventRecorderProxy.a("18446744073709551615", 4016, ((Integer)pair.first).intValue(), -1L, (String)pair.second, n5);
                    }
                }
                n2 = TRTCCloudImpl.this.translateStreamType(eventParam.getInt("EVT_STREAM_TYPE", 2));
                TRTCCloudImpl.this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                        if (tRTCCloudListener == null) {
                            return;
                        }
                        if (eventCode == 2003) {
                            if (userId != null && userId.equals(TRTCCloudImpl.this.mRoomInfo.getUserId())) {
                                TRTCCloudImpl.this.apiLog("onFirstVideoFrame local.");
                                tRTCCloudListener.onFirstVideoFrame(null, n2, eventParam.getInt("EVT_PARAM1"), eventParam.getInt("EVT_PARAM2"));
                            } else {
                                TRTCCloudImpl.this.apiLog("onFirstVideoFrame " + userId);
                                tRTCCloudListener.onFirstVideoFrame(userId, n2, eventParam.getInt("EVT_PARAM1"), eventParam.getInt("EVT_PARAM2"));
                            }
                        } else if (eventCode == 2026) {
                            TRTCCloudImpl.this.apiLog("onFirstAudioFrame " + userId);
                            tRTCCloudListener.onFirstAudioFrame(userId);
                            TRTCRoomInfo.UserInfo userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(userId);
                            if (userInfo != null) {
                                TXCKeyPointReportProxy.b(userInfo.tinyID + "", 32006);
                            }
                        } else if (eventCode == 1003) {
                            tRTCCloudListener.onCameraDidReady();
                            TRTCCloudImpl.this.apiOnlineLog("onCameraDidReady");
                        } else if (eventCode == 2027) {
                            tRTCCloudListener.onMicDidReady();
                            TRTCCloudImpl.this.apiOnlineLog("onMicDidReady");
                        } else if (eventCode != 1008) {
                            if (eventCode < 0) {
                                tRTCCloudListener.onError(eventCode, eventParam.getString("EVT_MSG", ""), eventParam);
                                Monitor.a(3, String.format("onError event:%d, msg:%s", eventCode, eventParam) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                                TXCKeyPointReportProxy.b(eventCode);
                            } else if (eventCode > 1100 && eventCode < 1110 || eventCode > 1200 && eventCode < 1206 || eventCode > 2100 && eventCode < 2110 || eventCode > 3001 && eventCode < 3011 || eventCode > 5100 && eventCode < 5104) {
                                tRTCCloudListener.onWarning(eventCode, eventParam.getString("EVT_MSG", ""), eventParam);
                                if (eventCode != 2105) {
                                    Monitor.a(4, String.format("onWarning event:%d, msg:%s", eventCode, eventParam) + " self:" + TRTCCloudImpl.this.hashCode(), "", 0);
                                }
                                switch (eventCode) {
                                    case 1103: 
                                    case 1109: 
                                    case 2101: 
                                    case 2102: 
                                    case 2106: 
                                    case 2109: {
                                        TXCKeyPointReportProxy.b(eventCode);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private void notifyEvent(String userId, int eventCode, String info) {
        Bundle bundle = new Bundle();
        bundle.putLong("EVT_ID", (long)eventCode);
        bundle.putLong("EVT_TIME", System.currentTimeMillis());
        bundle.putString("EVT_MSG", info);
        this.notifyEvent(userId, eventCode, bundle);
    }

    protected void apiLog(String msg) {
        TXCLog.i(TAG, "(" + this.hashCode() + ")trtc_api " + msg);
    }

    protected void apiLog(String format, Object ... args) {
        TXCLog.i(TAG, "(" + this.hashCode() + ")trtc_api " + String.format(format, args));
    }

    protected void apiOnlineLog(String msg) {
        String string = "(" + this.hashCode() + ")trtc_api";
        Monitor.a(1, msg + " self:" + this.hashCode(), "", 0, string);
    }

    protected void apiOnlineLog(String format, Object ... args) {
        String string = "(" + this.hashCode() + ")trtc_api";
        Monitor.a(1, String.format(format, args) + " self:" + this.hashCode(), "", 0, string);
    }

    private TRTCRoomInfo.UserInfo createUserInfo(String userID) {
        TRTCRoomInfo.UserInfo userInfo = new TRTCRoomInfo.UserInfo(0L, userID, 0, 0);
        userInfo.mainRender.muteVideo = this.mRoomInfo.muteRemoteVideo;
        userInfo.mainRender.muteAudio = this.mRoomInfo.muteRemoteAudio;
        userInfo.subRender.muteVideo = this.mRoomInfo.muteRemoteVideo;
        return userInfo;
    }

    private g.a getSizeByResolution(int trtcResolution, int resolutionMode) {
        int n2 = 0;
        int n3 = 0;
        switch (trtcResolution) {
            case 1: {
                n2 = 128;
                n3 = 128;
                break;
            }
            case 3: {
                n2 = 160;
                n3 = 160;
                break;
            }
            case 5: {
                n2 = 272;
                n3 = 272;
                break;
            }
            case 7: {
                n2 = 480;
                n3 = 480;
                break;
            }
            case 50: {
                n2 = 176;
                n3 = 128;
                break;
            }
            case 52: {
                n2 = 256;
                n3 = 192;
                break;
            }
            case 54: {
                n2 = 288;
                n3 = 224;
                break;
            }
            case 56: {
                n2 = 320;
                n3 = 240;
                break;
            }
            case 58: {
                n2 = 400;
                n3 = 304;
                break;
            }
            case 60: {
                n2 = 480;
                n3 = 368;
                break;
            }
            case 62: {
                n2 = 640;
                n3 = 480;
                break;
            }
            case 64: {
                n2 = 960;
                n3 = 720;
                break;
            }
            case 100: {
                n2 = 176;
                n3 = 96;
                break;
            }
            case 102: {
                n2 = 256;
                n3 = 144;
                break;
            }
            case 104: {
                n2 = 336;
                n3 = 192;
                break;
            }
            case 106: {
                n2 = 480;
                n3 = 272;
                break;
            }
            case 108: {
                n2 = 640;
                n3 = 368;
                break;
            }
            case 110: {
                n2 = 960;
                n3 = 544;
                break;
            }
            case 112: {
                n2 = 1280;
                n3 = 720;
                break;
            }
            case 114: {
                n2 = 1920;
                n3 = 1088;
                break;
            }
            default: {
                n2 = 640;
                n3 = 368;
            }
        }
        g.a a2 = new g.a();
        if (resolutionMode == 1) {
            a2.a = n3;
            a2.b = n2;
        } else {
            a2.a = n2;
            a2.b = n3;
        }
        return a2;
    }

    protected void checkUserState(final String userId, long tinyID, int newState, int oldState) {
        final TRTCCloudListener tRTCCloudListener = this.mTRTCListener;
        if (tRTCCloudListener != null && !TextUtils.isEmpty((CharSequence)userId)) {
            TRTCRoomInfo.UserInfo userInfo;
            boolean bl;
            boolean bl2;
            final boolean bl3 = TRTCRoomInfo.hasAudio(newState) && !TRTCRoomInfo.isMuteAudio(newState);
            boolean bl4 = bl2 = (TRTCRoomInfo.hasAudio(oldState) && !TRTCRoomInfo.isMuteAudio(oldState)) != bl3;
            if (bl2) {
                this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        tRTCCloudListener.onUserAudioAvailable(userId, bl3);
                    }
                });
                this.appendDashboardLog(this.mRoomInfo.getUserId(), 0, String.format("[%s]audio Available[%b]", userId, bl3));
                Monitor.a(2, String.format("onUserAudioAvailable userID:%s, bAvailable:%b", userId, bl3) + " self:" + this.hashCode(), "", 0);
            }
            final boolean bl5 = (TRTCRoomInfo.hasMainVideo(newState) || TRTCRoomInfo.hasSmallVideo(newState)) && !TRTCRoomInfo.isMuteMainVideo(newState);
            bl2 = ((TRTCRoomInfo.hasMainVideo(oldState) || TRTCRoomInfo.hasSmallVideo(oldState)) && !TRTCRoomInfo.isMuteMainVideo(oldState)) != bl5;
            boolean bl6 = bl = this.mRecvMode != 3 && this.mRecvMode != 1;
            if (bl2 && (userInfo = this.mRoomInfo.getUser(userId)) != null) {
                if (bl5) {
                    if (userInfo.mainRender.lastVideoStatusChangeOperation != 0) {
                        userInfo.mainRender.lastVideoStatusChangeOperation = 4;
                    }
                } else {
                    userInfo.mainRender.lastVideoStatusChangeOperation = 3;
                    this.onRemoteVideoStatusUpdatedInternal(userInfo, 2, 0, 6);
                }
                if (userInfo.mainRender.render != null) {
                    userInfo.mainRender.render.resetPeriodStatistics();
                    userInfo.mainRender.render.enableReport(bl5);
                }
            }
            if (bl2 && (this.mRoomInfo.hasRecvFirstIFrame(tinyID, 2) || bl)) {
                this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        tRTCCloudListener.onUserVideoAvailable(userId, bl5);
                    }
                });
                this.appendDashboardLog(this.mRoomInfo.getUserId(), 0, String.format("[%s]video Available[%b]", userId, bl5));
                Monitor.a(2, String.format("onUserVideoAvailable userID:%s, bAvailable:%b", userId, bl5) + " self:" + this.hashCode(), "", 0);
            }
            final boolean bl7 = TRTCRoomInfo.hasSubVideo(newState) && !TRTCRoomInfo.isMuteSubVideo(newState);
            boolean bl8 = bl2 = (TRTCRoomInfo.hasSubVideo(oldState) && !TRTCRoomInfo.isMuteSubVideo(oldState)) != bl7;
            if (bl2) {
                TRTCRoomInfo.UserInfo userInfo2 = this.mRoomInfo.getUser(userId);
                if (userInfo2 != null && userInfo2.subRender.render != null) {
                    if (bl7) {
                        if (userInfo2.subRender.lastVideoStatusChangeOperation != 0) {
                            userInfo2.subRender.lastVideoStatusChangeOperation = 4;
                        }
                    } else {
                        userInfo2.subRender.lastVideoStatusChangeOperation = 3;
                        this.onRemoteVideoStatusUpdatedInternal(userInfo2, 7, 0, 6);
                    }
                    userInfo2.subRender.render.resetPeriodStatistics();
                    userInfo2.subRender.render.enableReport(bl7);
                }
                this.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        tRTCCloudListener.onUserSubStreamAvailable(userId, bl7);
                    }
                });
                this.appendDashboardLog(this.mRoomInfo.getUserId(), 0, String.format("[%s]subVideo Available[%b]", userId, bl7));
                Monitor.a(2, String.format("onUserSubStreamAvailable userID:%s, bAvailable:%b", userId, bl7) + " self:" + this.hashCode(), "", 0);
            }
        }
    }

    private void collectCustomCaptureFps() {
        double d2;
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this.mCustomVideoUtil;
        if (tRTCCustomTextureUtil != null) {
            d2 = tRTCCustomTextureUtil.getCurrentFPS();
            TXCStatus.a("18446744073709551615", 1001, 2, d2);
        }
        if ((tRTCCustomTextureUtil = this.mCustomSubStreamVideoUtil) != null) {
            d2 = tRTCCustomTextureUtil.getCurrentFPS();
            TXCStatus.a("18446744073709551615", 1001, 7, d2);
        }
    }

    protected void checkRemoteDashBoard(final TXCloudVideoView renderView, TXCRenderAndDec render, TRTCRoomInfo.UserInfo userInfo) {
        if (renderView != null && render != null && render.isRendering()) {
            final CharSequence charSequence = this.getDownloadStreamInfo(render, userInfo);
            TXCLog.i(TAG, "[STATUS]" + charSequence.toString().replace("\n", "") + " self:" + this.hashCode());
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    renderView.setDashBoardStatusInfo(charSequence);
                }
            });
        }
    }

    protected void checkDashBoard() {
        TXCloudVideoView tXCloudVideoView;
        if (this.mDebugType != 0 && (tXCloudVideoView = this.mRoomInfo.localView) != null) {
            final CharSequence charSequence = this.getUploadStreamInfo();
            TXCLog.i(TAG, "[STATUS]" + charSequence.toString().replace("\n", "") + " self:" + this.hashCode());
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    tXCloudVideoView.setDashBoardStatusInfo(charSequence);
                }
            });
        }
        this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

            @Override
            public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                if (userInfo.mainRender.render != null && userInfo.mainRender.render.isRendering()) {
                    userInfo.mainRender.render.updateLoadInfo();
                }
                if (userInfo.subRender.render != null && userInfo.subRender.render.isRendering()) {
                    userInfo.subRender.render.updateLoadInfo();
                }
                if (TRTCCloudImpl.this.mDebugType != 0) {
                    TRTCCloudImpl.this.checkRemoteDashBoard(userInfo.mainRender.view, userInfo.mainRender.render, userInfo);
                    TRTCCloudImpl.this.checkRemoteDashBoard(userInfo.subRender.view, userInfo.subRender.render, userInfo);
                }
            }
        });
    }

    protected int getNetworkQuality(int rtt, int loss) {
        if (!i.d(this.mContext)) {
            return 6;
        }
        return this.nativeGetNetworkQUality(this.mNativeRtcContext, rtt, loss);
    }

    private int translateStreamType(int sdkStreamType) {
        switch (sdkStreamType) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    private int translateAudioAbnormalDetectState(int audioCaptureState) {
        if ((audioCaptureState & 1) != 0) {
            return 1;
        }
        if ((audioCaptureState & 2) != 0) {
            return 2;
        }
        if ((audioCaptureState & 4) != 0) {
            return 3;
        }
        return 0;
    }

    private b getPixelFormat(int apiPixelFormat) {
        switch (apiPixelFormat) {
            case 1: {
                return b.b;
            }
            case 2: {
                return b.c;
            }
            case 3: {
                return b.d;
            }
            case 4: {
                return b.e;
            }
            case 5: {
                return b.f;
            }
        }
        return b.a;
    }

    private TRTCStatistics.TRTCRemoteStatistics getRemoteStatistics(TXCRenderAndDec render, TRTCRoomInfo.UserInfo userInfo) {
        String string = String.valueOf(userInfo.tinyID);
        int n2 = render.getStreamType();
        int n3 = TXCStatus.c(string, 5003, n2);
        int n4 = TXCStatus.c(string, 17011, n2);
        int n5 = TXCStatus.c(string, 18047);
        TRTCStatistics.TRTCRemoteStatistics tRTCRemoteStatistics = new TRTCStatistics.TRTCRemoteStatistics();
        tRTCRemoteStatistics.userId = userInfo.userID;
        tRTCRemoteStatistics.videoPacketLoss = n4;
        tRTCRemoteStatistics.audioPacketLoss = n5;
        tRTCRemoteStatistics.finalLoss = n5 > n4 ? n5 : n4;
        tRTCRemoteStatistics.width = n3 >> 16;
        tRTCRemoteStatistics.height = n3 & 0xFFFF;
        tRTCRemoteStatistics.frameRate = (int)(TXCStatus.d(string, 6002, n2) + 0.5);
        tRTCRemoteStatistics.videoBitrate = TXCStatus.c(string, 17002, n2);
        tRTCRemoteStatistics.audioSampleRate = TXCStatus.c(string, 18003);
        tRTCRemoteStatistics.audioBitrate = TXCStatus.c(string, 18002);
        tRTCRemoteStatistics.jitterBufferDelay = TXCStatus.c(string, 2007);
        tRTCRemoteStatistics.point2PointDelay = TXCStatus.c(string, 18042);
        tRTCRemoteStatistics.streamType = this.translateStreamType(n2);
        tRTCRemoteStatistics.audioTotalBlockTime = TXCStatus.c(string, 18031);
        int n6 = TXCStatus.c(string, 18030);
        tRTCRemoteStatistics.audioBlockRate = n6 > 0 ? (int)((double)tRTCRemoteStatistics.audioTotalBlockTime * 100.0 / (double)n6 + 0.9) : 0;
        tRTCRemoteStatistics.videoTotalBlockTime = TXCStatus.c(string, 6006, n2);
        int n7 = TXCStatus.c(string, 6012, n2);
        tRTCRemoteStatistics.videoBlockRate = n7 > 0 ? (int)((double)tRTCRemoteStatistics.videoTotalBlockTime * 100.0 / (double)n7 + 0.9) : 0;
        return tRTCRemoteStatistics;
    }

    private TRTCStatistics.TRTCLocalStatistics getLocalStatistics(int streamType) {
        String string = "18446744073709551615";
        int n2 = TXCStatus.c(string, 4003, streamType);
        TRTCStatistics.TRTCLocalStatistics tRTCLocalStatistics = new TRTCStatistics.TRTCLocalStatistics();
        tRTCLocalStatistics.width = n2 >> 16;
        tRTCLocalStatistics.height = n2 & 0xFFFF;
        tRTCLocalStatistics.frameRate = (int)(TXCStatus.d(string, 4001, streamType) + 0.5);
        tRTCLocalStatistics.videoBitrate = TXCStatus.c(string, 13002, streamType);
        tRTCLocalStatistics.audioSampleRate = TXCStatus.c(string, 14003);
        tRTCLocalStatistics.audioBitrate = TXCStatus.c(string, 14002);
        tRTCLocalStatistics.streamType = this.translateStreamType(streamType);
        tRTCLocalStatistics.audioCaptureState = this.translateAudioAbnormalDetectState(TXCStatus.c(string, 14032));
        return tRTCLocalStatistics;
    }

    private void addRemoteStatistics(TXCRenderAndDec render, TRTCRoomInfo.UserInfo userInfo, TRTCStatistics statistics, ArrayList<TRTCCloudDef.TRTCQuality> remoteQualityArray) {
        TRTCStatistics.TRTCRemoteStatistics tRTCRemoteStatistics = this.getRemoteStatistics(render, userInfo);
        statistics.remoteArray.add(tRTCRemoteStatistics);
        statistics.downLoss = TXCStatus.c(String.valueOf(userInfo.tinyID), 16002);
        TRTCCloudDef.TRTCQuality tRTCQuality = new TRTCCloudDef.TRTCQuality();
        tRTCQuality.userId = userInfo.userID;
        tRTCQuality.quality = this.getNetworkQuality(statistics.rtt, tRTCRemoteStatistics.finalLoss);
        remoteQualityArray.add(tRTCQuality);
    }

    private void checkRTCState() {
        Object object;
        long l2 = System.currentTimeMillis();
        if (l2 < this.mLastStateTimeMs + 2000L) {
            return;
        }
        this.mLastStateTimeMs = l2;
        int[] nArray = i.a();
        final ArrayList arrayList = new ArrayList();
        final TRTCStatistics tRTCStatistics = new TRTCStatistics();
        tRTCStatistics.appCpu = nArray[0] / 10;
        tRTCStatistics.systemCpu = nArray[1] / 10;
        tRTCStatistics.rtt = TXCStatus.c("18446744073709551615", 12002);
        tRTCStatistics.gatewayRtt = TXCStatus.c("18446744073709551615", 12008);
        tRTCStatistics.sendBytes = TXCStatus.a("18446744073709551615", 12004);
        tRTCStatistics.receiveBytes = TXCStatus.a("18446744073709551615", 16004);
        tRTCStatistics.upLoss = TXCStatus.c("18446744073709551615", 12003);
        tRTCStatistics.localArray = new ArrayList();
        tRTCStatistics.remoteArray = new ArrayList();
        TRTCStatistics.TRTCLocalStatistics tRTCLocalStatistics = this.getLocalStatistics(2);
        tRTCStatistics.localArray.add(tRTCLocalStatistics);
        if (this.mEnableSmallStream) {
            object = this.getLocalStatistics(3);
            tRTCStatistics.localArray.add((TRTCStatistics.TRTCLocalStatistics)object);
        }
        this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

            @Override
            public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                if (userInfo.mainRender.render != null) {
                    TRTCCloudImpl.this.addRemoteStatistics(userInfo.mainRender.render, userInfo, tRTCStatistics, arrayList);
                }
                if (userInfo.subRender.render != null && userInfo.subRender.render.isRendering()) {
                    TRTCCloudImpl.this.addRemoteStatistics(userInfo.subRender.render, userInfo, tRTCStatistics, arrayList);
                }
            }
        });
        object = new TRTCCloudDef.TRTCQuality();
        ((TRTCCloudDef.TRTCQuality)object).userId = this.mRoomInfo.getUserId();
        ((TRTCCloudDef.TRTCQuality)object).quality = TXCStatus.c("18446744073709551615", 12005);
        this.runOnListenerThread(new Runnable((TRTCCloudDef.TRTCQuality)object, arrayList){
            final /* synthetic */ TRTCCloudDef.TRTCQuality val$localQuality;
            final /* synthetic */ ArrayList val$remoteQualityArray;
            {
                this.val$localQuality = tRTCQuality;
                this.val$remoteQualityArray = arrayList;
            }

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener != null) {
                    tRTCCloudListener.onStatistics(tRTCStatistics);
                    tRTCCloudListener.onNetworkQuality(this.val$localQuality, this.val$remoteQualityArray);
                }
            }
        });
    }

    protected void startCollectStatus() {
        if (this.mSDKHandler != null) {
            this.mSDKHandler.postDelayed(this.mStatusNotifyTask, 1000L);
        }
    }

    protected void stopCollectStatus() {
        if (this.mSDKHandler != null) {
            this.mSDKHandler.removeCallbacks(this.mStatusNotifyTask);
        }
    }

    protected CharSequence getUploadStreamInfo() {
        int[] nArray = i.a();
        String string = "18446744073709551615";
        int n2 = 2;
        int n3 = TXCStatus.c(string, 4003, n2);
        String string2 = TXCStatus.b(string, 10001);
        return String.format("LOCAL: [%s] RTT:%dms\n", this.mRoomInfo.getUserId(), TXCStatus.c(string, 12002)) + String.format(Locale.CHINA, "SEND:% 5dkbps LOSS:%d-%d-%d-%d|%d-%d-%d-%d|%d%%\n", TXCStatus.c(string, 12001), TXCStatus.c(string, 13011, n2), TXCStatus.c(string, 13012, n2), TXCStatus.c(string, 13013, n2), TXCStatus.c(string, 13010, n2), TXCStatus.c(string, 14011), TXCStatus.c(string, 14012), TXCStatus.c(string, 14013), TXCStatus.c(string, 14010), TXCStatus.c(string, 12003)) + String.format(Locale.CHINA, "BIT:%d|%d|%dkbps RES:%dx%d FPS:%d-%d\n", TXCStatus.c(string, 13002, n2), TXCStatus.c(string, 13002, 3), TXCStatus.c(string, 14002), n3 >> 16, n3 & 0xFFFF, (int)TXCStatus.d(string, 4001, n2), (int)TXCStatus.d(string, 13014, n2)) + String.format(Locale.CHINA, "FEC:%d%%|%d%%  ARQ:%d|%dkbps  RPS:%d\n", TXCStatus.c(string, 13004, n2), TXCStatus.c(string, 14006), TXCStatus.c(string, 13008, n2), TXCStatus.c(string, 14008), TXCStatus.c(string, 13007, n2)) + String.format(Locale.CHINA, "CPU:%d%%|%d%%    QOS:%s|%dkbps|%d-%d\n", nArray[0] / 10, nArray[1] / 10, this.getQosValue(TXCStatus.c(string, 15009, n2)), TXCStatus.c(string, 15002, n2), TXCStatus.c(string, 15010, n2), TXCStatus.c(string, 15005, n2)) + String.format(Locale.CHINA, "SVR:%s", string2);
    }

    private CharSequence getDownloadStreamInfo(TXCRenderAndDec render, TRTCRoomInfo.UserInfo userInfo) {
        String string = String.valueOf(userInfo.tinyID);
        int[] nArray = i.a();
        int n2 = render.getStreamType();
        long l2 = TXCStatus.a(string, 17014, n2);
        int n3 = TXCStatus.c(string, 5003, n2);
        String string2 = n2 == 3 ? "S" : (n2 == 7 ? "Sub" : (n2 == 1 ? "A" : "B"));
        String string3 = String.format("REMOTE: [%s]%s RTT:%dms\n", userInfo.userID, string2, TXCStatus.c("18446744073709551615", 12002)) + String.format(Locale.CHINA, "RECV:%dkbps LOSS:%d-%d-%d%%|%d-%d-%d%%|%d%%\n", TXCStatus.c(string, 17001, n2) + TXCStatus.c(string, 18001), TXCStatus.c(string, 17010, n2), TXCStatus.c(string, 17005, n2), TXCStatus.c(string, 17011, n2), TXCStatus.c(string, 18013), TXCStatus.c(string, 18007), TXCStatus.c(string, 18014), TXCStatus.c(string, 16002)) + String.format(Locale.CHINA, "BIT:%d|%dkbps RES:%dx%d FPS:%d-%d\n", TXCStatus.c(string, 17002, n2), TXCStatus.c(string, 18002), n3 >> 16, n3 & 0xFFFF, (int)TXCStatus.d(string, 6002, n2), (int)TXCStatus.d(string, 17003, n2)) + String.format(Locale.CHINA, "FEC:%d-%d-%d%%|%d-%d-%d%%    ARQ:%d-%d|%d-%d\n", TXCStatus.c(string, 17007, n2), TXCStatus.c(string, 17005, n2), TXCStatus.c(string, 17006, n2), TXCStatus.c(string, 18009), TXCStatus.c(string, 18007), TXCStatus.c(string, 18008), TXCStatus.c(string, 17009, n2), TXCStatus.c(string, 17008, n2), TXCStatus.c(string, 18012), TXCStatus.c(string, 18010)) + String.format(Locale.CHINA, "CPU:%d%%|%d%%  RPS:%d  LFR:%d  DERR:%d\n", nArray[0] / 10, nArray[1] / 10, TXCStatus.c(string, 17012, n2), TXCStatus.c(string, 17013, n2), l2) + String.format(Locale.CHINA, "Jitter: %d,%d|%d,%d|%d  p2pDelay: %d  ADROP: %d\n", TXCStatus.c(string, 2007), TXCStatus.c(string, 6104, n2), TXCStatus.c(string, 6105, n2), TXCStatus.c(string, 6106, n2), TXCStatus.c(string, 2021), TXCStatus.c(string, 18042), TXCStatus.c(string, 18015)) + String.format(Locale.CHINA, "QUALITY: %d   LEN: %d\n", TXCStatus.c(string, 18023), TXCStatus.c(string, 18016));
        SpannableString spannableString = new SpannableString((CharSequence)string3);
        int n4 = string3.lastIndexOf("DECERR:");
        if (-1 != n4 && l2 > 0L) {
            spannableString.setSpan((Object)new ForegroundColorSpan(-65536), n4 + 7, string3.length(), 33);
        }
        return spannableString;
    }

    private String getQosValue(int qos_status) {
        switch (qos_status) {
            case 0: {
                return "HOLD";
            }
            case 1: {
                return "UP";
            }
            case 2: {
                return "DOWN";
            }
        }
        return "ERR";
    }

    private int getDisplayRotation() {
        int n2 = i.g(this.mContext);
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 90;
                break;
            }
            case 2: {
                n3 = 180;
                break;
            }
            case 3: {
                n3 = 270;
            }
        }
        return n3;
    }

    private void updateOrientation() {
        if (this.mMainStreamVideoSourceType == VideoSourceType.CUSTOM || this.mMainStreamVideoSourceType == VideoSourceType.SCREEN) {
            return;
        }
        if (this.mCurrentOrientation == -1) {
            int n2 = i.g(this.mContext);
            this.mCurrentOrientation = n2 == 1 ? 0 : 1;
        }
        this.setOrientation(this.mCurrentOrientation);
    }

    private void checkRenderRotation(int orientation) {
        boolean bl;
        int n2 = this.getDisplayRotation();
        int n3 = (360 - n2 - (this.mConfig.o - 1) * 90) % 360;
        boolean bl2 = bl = orientation % 2 == n2 % 2 && this.mConfig.o == 1 || orientation % 2 != n2 % 2 && this.mConfig.o == 0;
        if (this.mVideoRenderMirror == 1) {
            if (!this.mConfig.p && bl) {
                n3 += 180;
            }
        } else if (this.mVideoRenderMirror == 2 && this.mConfig.p && bl) {
            n3 += 180;
        }
        TXCLog.d(TAG, String.format("vrotation rotation-change %d-%d-%d ======= renderRotation %d-%d", orientation, this.mConfig.o, n2, n3, this.mRoomInfo.localRenderRotation) + " self:" + this.hashCode());
        n3 = (this.mRoomInfo.localRenderRotation + n3) % 360;
        this.mCaptureAndEnc.h(n3);
    }

    private void checkVideoEncRotation(int orientation) {
        int n2 = 0;
        int n3 = 0;
        if (this.mConfig.o != 1) {
            n3 = this.mConfig.V && this.mConfig.p || !this.mConfig.V && !this.mConfig.p ? 90 : 270;
        }
        switch (orientation) {
            case 1: {
                n2 = (0 + n3) % 360;
                break;
            }
            case 0: {
                n2 = (90 + n3) % 360;
                if (!this.mConfig.p) {
                    n2 = (180 + n2) % 360;
                }
                if (!this.mConfig.V) break;
                n2 = (180 + n2) % 360;
                break;
            }
            case 3: {
                n2 = (180 + n3) % 360;
                break;
            }
            case 2: {
                n2 = (270 + n3) % 360;
                if (!this.mConfig.p) {
                    n2 = (180 + n2) % 360;
                }
                if (!this.mConfig.V) break;
                n2 = (180 + n2) % 360;
            }
        }
        TXCLog.d(TAG, String.format("vrotation rotation-change %d-%d ======= encRotation %d", orientation, this.mConfig.o, n2) + " self:" + this.hashCode());
        this.mCurrentOrientation = orientation;
        this.mCaptureAndEnc.a(n2);
    }

    private void setOrientation(final int orientation) {
        if (orientation == -1) {
            return;
        }
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudImpl.this.checkRenderRotation(orientation);
                if (TRTCCloudImpl.this.mSensorMode != 0) {
                    TRTCCloudImpl.this.checkVideoEncRotation(orientation);
                }
            }
        });
    }

    private void addUpStreamType(int streamType) {
        if (streamType == 7 && this.mSubStreamVideoSourceType == VideoSourceType.NONE) {
            TXCLog.i("addUpstream", "return, add sub upstream when not start");
            return;
        }
        if (!this.mStreamTypes.contains(streamType)) {
            this.mStreamTypes.add(streamType);
        }
        this.addUpstream(streamType);
    }

    private void removeUpStreamType(int streamType) {
        if (this.mStreamTypes.contains(streamType)) {
            this.mStreamTypes.remove(streamType);
        }
        this.removeUpstream(streamType);
    }

    private void setVideoEncoderConfiguration(int streamType, int width, int height, int fps, int bitrate, int codecMode, boolean isEnableAdjustRes, int minBitrate, boolean setByAPI) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(streamType);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeSetVideoEncoderConfiguration(l2, streamType, width, height, fps, bitrate, codecMode, isEnableAdjustRes, minBitrate, setByAPI);
        }
    }

    private void setVideoQuality(int controltype, int type) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(2);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeSetVideoQuality(l2, controltype, type);
        }
    }

    private void muteUpstream(int streamType, boolean mute) {
        TRTCCloudImpl tRTCCloudImpl;
        boolean bl = true;
        if (streamType == 7 && !mute && this.mSubStreamVideoSourceType == VideoSourceType.NONE) {
            TXCLog.i("muteUpstream", "return, unmute sub upstream when not start");
            bl = false;
        }
        if ((tRTCCloudImpl = this.mCurrentPublishClouds.get(streamType)) != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeMuteUpstream(l2, streamType, mute, bl);
        }
    }

    private void addUpstream(int streamType) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(streamType);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeAddUpstream(l2, streamType);
        }
    }

    private void removeUpstream(int streamType) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(streamType);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeRemoveUpstream(l2, streamType);
        }
    }

    private void setAudioEncodeConfiguration() {
        this.setQoSParams();
    }

    public void enableNetworkBlackStream(boolean enable) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(2);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeEnableBlackStream(l2, enable);
        }
    }

    public void enableNetworkSmallStream(boolean enable) {
        TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(2);
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            this.nativeEnableSmallStream(l2, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushVideoFrame(TXSNALPacket nal) {
        TRTCCloudImpl tRTCCloudImpl = null;
        HashMap<Integer, TRTCCloudImpl> hashMap = this.mCurrentPublishClouds;
        synchronized (hashMap) {
            tRTCCloudImpl = this.mCurrentPublishClouds.get(nal.streamType);
        }
        if (tRTCCloudImpl != null) {
            long l2 = tRTCCloudImpl.getNetworkContext();
            int n2 = nal.codecId == 1 ? 14 : 1;
            this.nativePushVideo(l2, nal.streamType, n2, nal.nalType, nal.nalData, nal.gopIndex, nal.gopFrameIndex, nal.refFremeIndex, nal.pts, nal.dts);
        }
    }

    public long getNetworkContext() {
        return this.mNativeRtcContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublishingInCloud(TRTCCloudImpl cloud, int streamType) {
        HashMap<Integer, TRTCCloudImpl> hashMap = this.mCurrentPublishClouds;
        synchronized (hashMap) {
            TRTCCloudImpl tRTCCloudImpl = this.mCurrentPublishClouds.get(streamType);
            if (tRTCCloudImpl == cloud) {
                return true;
            }
        }
        return false;
    }

    private void notifyCaptureStarted(final String message) {
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener == null) {
                    return;
                }
                tRTCCloudListener.onWarning(4000, message, null);
            }
        });
        this.apiLog(message);
    }

    public void OnRemoteVideoStatusUpdated(final String tinyId, final int streamType, final int status, final int reason) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo = null;
                try {
                    String string = TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(Long.valueOf(tinyId));
                    if (string != null) {
                        userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(string);
                    }
                }
                catch (Exception exception) {
                    TXCLog.e(TRTCCloudImpl.TAG, "get user info failed.", exception);
                }
                TRTCCloudImpl.this.onRemoteVideoStatusUpdatedInternal(userInfo, streamType, status, reason);
            }
        });
    }

    private void onRemoteVideoStatusUpdatedInternal(final TRTCRoomInfo.UserInfo userInfo, int streamType, final int status, final int reason) {
        if (userInfo == null) {
            return;
        }
        int n2 = 2;
        if (streamType == 7) {
            if (status == userInfo.subRender.lastVideoStreamStatus) {
                return;
            }
            if (userInfo.subRender.lastVideoStreamStatus == 0 && status == 2) {
                return;
            }
            if (reason == 2 && userInfo.subRender.lastVideoStreamStatus != 2) {
                return;
            }
            if (reason == 1 && userInfo.subRender.lastVideoStreamStatus != 1) {
                return;
            }
            if (userInfo.subRender.lastVideoStreamStatus == 2 && reason == 3) {
                return;
            }
            userInfo.subRender.lastVideoStreamStatus = status;
        } else {
            if (status == userInfo.mainRender.lastVideoStreamStatus) {
                return;
            }
            if (userInfo.mainRender.lastVideoStreamStatus == 0 && status == 2) {
                return;
            }
            if (reason == 2 && userInfo.mainRender.lastVideoStreamStatus != 2) {
                return;
            }
            if (reason == 1 && userInfo.mainRender.lastVideoStreamStatus != 1) {
                return;
            }
            if (userInfo.mainRender.lastVideoStreamStatus == 2 && reason == 3) {
                return;
            }
            userInfo.mainRender.lastVideoStreamStatus = status;
            n2 = 0;
        }
        final int n3 = n2;
        this.runOnListenerThread(new Runnable(){

            @Override
            public void run() {
                TRTCCloudListener tRTCCloudListener = TRTCCloudImpl.this.mTRTCListener;
                if (tRTCCloudListener == null) {
                    return;
                }
                tRTCCloudListener.onRemoteVideoStatusUpdated(userInfo.userID, n3, status, reason, null);
                String string = String.format("video status change userId:%s, streamType:%d, streamStatus:%d, reason:%d", userInfo.userID, n3, status, reason);
                TRTCCloudImpl.this.apiOnlineLog(string);
                TRTCCloudImpl.this.appendDashboardLog(TRTCCloudImpl.this.mRoomInfo.getUserId(), n3, string);
            }
        });
    }

    public void OnRemoteAudioStatusUpdated(final String tinyId, final int status, final int reason) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TRTCRoomInfo.UserInfo userInfo = null;
                try {
                    String string = TRTCCloudImpl.this.mRoomInfo.getUserIdByTinyId(Long.valueOf(tinyId));
                    if (string != null) {
                        userInfo = TRTCCloudImpl.this.mRoomInfo.getUser(string);
                    }
                }
                catch (Exception exception) {
                    TXCLog.e(TRTCCloudImpl.TAG, "get user info failed.", exception);
                }
                TRTCCloudImpl.this.onRemoteAudioStatusUpdatedInternal(userInfo, status, reason);
            }
        });
    }

    private void onRemoteAudioStatusUpdatedInternal(TRTCRoomInfo.UserInfo userInfo, int status, int reason) {
    }

    static {
        i.d();
    }

    static enum VideoSourceType {
        NONE,
        CAMERA,
        SCREEN,
        CUSTOM;

    }

    static class RenderListenerAdapter {
        public String strTinyID;
        public int pixelFormat;
        public int bufferType;
        public TRTCCloudListener.TRTCVideoRenderListener listener;

        RenderListenerAdapter() {
        }
    }

    private static class DisplayOrientationDetector
    extends OrientationEventListener {
        private WeakReference<TRTCCloudImpl> mTRTCEngine;
        public int mCurOrientation = -1;
        private int mCurrentDisplayRotation = 0;

        DisplayOrientationDetector(Context context, TRTCCloudImpl engine) {
            super(context);
            this.mTRTCEngine = new WeakReference<TRTCCloudImpl>(engine);
        }

        public void onOrientationChanged(int orientation) {
            if (orientation == -1) {
                TXCLog.i("DisplayOrientationDetector", "rotation-change invalid " + orientation);
                return;
            }
            int n2 = 0;
            n2 = orientation <= 45 ? 1 : (orientation <= 135 ? 2 : (orientation <= 225 ? 3 : (orientation <= 315 ? 0 : 1)));
            if (this.mCurOrientation != n2) {
                this.mCurOrientation = n2;
                TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)this.mTRTCEngine.get();
                if (tRTCCloudImpl != null) {
                    this.mCurrentDisplayRotation = tRTCCloudImpl.getDisplayRotation();
                    tRTCCloudImpl.setOrientation(this.mCurOrientation);
                }
                TXCLog.d("DisplayOrientationDetector", "rotation-change onOrientationChanged " + orientation + ", orientation " + this.mCurOrientation + " self:" + (tRTCCloudImpl != null ? Integer.valueOf(tRTCCloudImpl.hashCode()) : ""));
            }
        }

        public void checkOrientation() {
            int n2;
            TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)this.mTRTCEngine.get();
            if (tRTCCloudImpl != null && this.mCurrentDisplayRotation != (n2 = tRTCCloudImpl.getDisplayRotation())) {
                this.mCurrentDisplayRotation = n2;
                tRTCCloudImpl.setOrientation(this.mCurOrientation);
            }
        }
    }

    private static class StatusTask
    implements Runnable {
        private WeakReference<TRTCCloudImpl> mTRTCEngine;

        StatusTask(TRTCCloudImpl engine) {
            this.mTRTCEngine = new WeakReference<TRTCCloudImpl>(engine);
        }

        @Override
        public void run() {
            TRTCCloudImpl tRTCCloudImpl = (TRTCCloudImpl)this.mTRTCEngine.get();
            if (tRTCCloudImpl == null) {
                return;
            }
            int n2 = i.e(tRTCCloudImpl.mContext);
            int[] nArray = i.a();
            int n3 = i.b() * 1024;
            TXCStatus.a("18446744073709551615", 11006, (Object)n2);
            TXCStatus.a("18446744073709551615", 11001, (Object)(nArray[0] / 10));
            TXCStatus.a("18446744073709551615", 11002, (Object)(nArray[1] / 10));
            TXCStatus.a("18446744073709551615", 11003, (Object)n3);
            int n4 = -1;
            if (i.a(tRTCCloudImpl.mContext)) {
                TXCStatus.a("18446744073709551615", 11004, (Object)1);
                n4 = 1;
            } else {
                TXCStatus.a("18446744073709551615", 11004, (Object)0);
                n4 = 0;
            }
            if (tRTCCloudImpl.mNetType != n2) {
                if (tRTCCloudImpl.mNetType >= 0 && n2 > 0) {
                    tRTCCloudImpl.nativeReenterRoom(tRTCCloudImpl.mNativeRtcContext, 100, tRTCCloudImpl.mNetType != 0);
                }
                TXCEventRecorderProxy.a("18446744073709551615", 1003, n2 == 0 ? 0L : (long)n2, -1L, "", 0);
                Monitor.a(2, String.format("network switch from:%d to %d", tRTCCloudImpl.mNetType, n2) + " self:" + tRTCCloudImpl.hashCode(), "1:wifi/2:4G/3:3G/4:2G/5:Cable/6:5G", 0);
                tRTCCloudImpl.mNetType = n2;
                TXCKeyPointReportProxy.a(40039, n2, 0);
            }
            if (tRTCCloudImpl.mBackground != n4) {
                TXCEventRecorderProxy.a("18446744073709551615", 2001, n4, -1L, "", 0);
                tRTCCloudImpl.mBackground = n4;
                if (n4 == 0) {
                    tRTCCloudImpl.apiOnlineLog("onAppDidBecomeActive");
                } else {
                    tRTCCloudImpl.apiOnlineLog("onAppEnterBackground");
                }
                TXCKeyPointReportProxy.c(50001, n4);
            }
            TXCKeyPointReportProxy.a(nArray[0] / 10, nArray[1] / 10);
            TXCKeyPointReportProxy.a();
            tRTCCloudImpl.checkRTCState();
            tRTCCloudImpl.checkDashBoard();
            tRTCCloudImpl.collectCustomCaptureFps();
            tRTCCloudImpl.startCollectStatus();
            if (tRTCCloudImpl.mSensorMode != 0) {
                tRTCCloudImpl.mOrientationEventListener.checkOrientation();
            }
        }
    }

    private static class VolumeLevelNotifyTask
    implements Runnable {
        private WeakReference<TRTCCloudImpl> mWeakTRTCEngine;

        VolumeLevelNotifyTask(TRTCCloudImpl engine) {
            this.mWeakTRTCEngine = new WeakReference<TRTCCloudImpl>(engine);
        }

        @Override
        public void run() {
            TRTCCloudImpl tRTCCloudImpl = null;
            if (this.mWeakTRTCEngine != null) {
                tRTCCloudImpl = (TRTCCloudImpl)this.mWeakTRTCEngine.get();
            }
            if (tRTCCloudImpl != null) {
                final ArrayList<TRTCCloudDef.TRTCVolumeInfo> arrayList = new ArrayList<TRTCCloudDef.TRTCVolumeInfo>();
                int n2 = 0;
                if (tRTCCloudImpl.mCaptureAndEnc != null) {
                    n2 = TXCAudioEngine.getInstance().getSoftwareCaptureVolumeLevel();
                }
                if (n2 > 0) {
                    TRTCCloudDef.TRTCVolumeInfo tRTCVolumeInfo = new TRTCCloudDef.TRTCVolumeInfo();
                    tRTCVolumeInfo.userId = tRTCCloudImpl.mRoomInfo.userId;
                    tRTCVolumeInfo.volume = n2;
                    arrayList.add(tRTCVolumeInfo);
                }
                tRTCCloudImpl.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

                    @Override
                    public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                        int n2 = 0;
                        n2 = TXCAudioEngine.getInstance().getRemotePlayoutVolumeLevel(String.valueOf(userInfo.tinyID));
                        if (n2 > 0) {
                            TRTCCloudDef.TRTCVolumeInfo tRTCVolumeInfo = new TRTCCloudDef.TRTCVolumeInfo();
                            tRTCVolumeInfo.userId = userInfo.userID;
                            tRTCVolumeInfo.volume = n2;
                            arrayList.add(tRTCVolumeInfo);
                        }
                    }
                });
                final int n3 = TXCAudioEngine.getMixingPlayoutVolumeLevel();
                final TRTCCloudListener tRTCCloudListener = tRTCCloudImpl.mTRTCListener;
                tRTCCloudImpl.runOnListenerThread(new Runnable(){

                    @Override
                    public void run() {
                        if (tRTCCloudListener != null) {
                            tRTCCloudListener.onUserVoiceVolume(arrayList, n3);
                        }
                    }
                });
                if (tRTCCloudImpl.mAudioVolumeEvalInterval > 0) {
                    tRTCCloudImpl.mSDKHandler.postDelayed(tRTCCloudImpl.mVolumeLevelNotifyTask, tRTCCloudImpl.mAudioVolumeEvalInterval);
                }
            }
        }
    }

    private class LocalPreviewTextureViewListener
    implements TextureView.SurfaceTextureListener {
        private final TextureView mHost;
        private Surface mSurfaceFromView;

        public LocalPreviewTextureViewListener(TextureView host) {
            this.mHost = host;
            if (host != null && host.getSurfaceTexture() != null) {
                this.mSurfaceFromView = new Surface(host.getSurfaceTexture());
            }
            TXCLog.i(TRTCCloudImpl.TAG, "TextureViewListener created with host: %s", this.mHost);
        }

        public Surface getSurface() {
            return this.mSurfaceFromView;
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            this.mSurfaceFromView = new Surface(surface);
            if (this.isTextureViewCurrentlyInUse()) {
                TXCLog.i(TRTCCloudImpl.TAG, "local preview surfaceCreated, surface: %s, host: %s", surface, this.mHost);
                TRTCCloudImpl.this.mCaptureAndEnc.a(this.mSurfaceFromView);
                TRTCCloudImpl.this.mCaptureAndEnc.a(width, height);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (this.isTextureViewCurrentlyInUse()) {
                TXCLog.i(TRTCCloudImpl.TAG, "local preview surfaceChanged %s width: %d, height: %d", surface, width, height);
                TRTCCloudImpl.this.mCaptureAndEnc.a(width, height);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            if (this.isTextureViewCurrentlyInUse()) {
                TXCLog.i(TRTCCloudImpl.TAG, "local preview surfaceDestroyed %s, host: %s", surface, this.mHost);
                TRTCCloudImpl.this.mCaptureAndEnc.a((Surface)null);
            }
            if (this.mSurfaceFromView != null) {
                this.mSurfaceFromView.release();
                this.mSurfaceFromView = null;
            }
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }

        private boolean isTextureViewCurrentlyInUse() {
            if (TRTCCloudImpl.this.mRoomInfo == null || TRTCCloudImpl.this.mRoomInfo.localView == null) {
                return false;
            }
            return this.mHost == TRTCCloudImpl.this.mRoomInfo.localView.getHWVideoView();
        }
    }
}

