/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl.Record;

import android.content.Context;
import android.media.AudioRecord;
import com.tencent.liteav.audio.impl.Record.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class TXCAudioSysRecord
implements Runnable {
    private static final String TAG = "AudioCenter:" + TXCAudioSysRecord.class.getSimpleName();
    private static TXCAudioSysRecord instance = null;
    private Context mContext;
    private int mSampleRate = 48000;
    private int mChannels = 1;
    private int mBits = 16;
    private int mAECType = 0;
    private AudioRecord mMic;
    private byte[] mRecordBuffer = null;
    private WeakReference<c> mWeakRefListener;
    private Thread mRecordThread = null;
    private boolean mIsRunning = false;
    private boolean mIsCapFirstFrame = false;
    private boolean mSendMuteData = false;
    private AtomicBoolean mPause = new AtomicBoolean(false);
    private Object threadMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TXCAudioSysRecord getInstance() {
        if (instance != null) return instance;
        Class<TXCAudioSysRecord> clazz = TXCAudioSysRecord.class;
        synchronized (TXCAudioSysRecord.class) {
            if (instance != null) return instance;
            instance = new TXCAudioSysRecord();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TXCAudioSysRecord() {
        this.nativeClassInit();
    }

    public synchronized void setAudioRecordListener(c listener) {
        this.mWeakRefListener = listener == null ? null : new WeakReference<c>(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int sampleRate, int channels, int bits) {
        TXCLog.i(TAG, "start");
        Object object = this.threadMutex;
        synchronized (object) {
            this.stop();
            this.mSampleRate = sampleRate;
            this.mChannels = channels;
            this.mBits = bits;
            this.mIsRunning = true;
            this.mRecordThread = new Thread((Runnable)this, "AudioSysRecord Thread");
            this.mRecordThread.start();
        }
        TXCLog.i(TAG, "start ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TXCLog.i(TAG, "stop");
        Object object = this.threadMutex;
        synchronized (object) {
            this.mIsRunning = false;
            long l2 = System.currentTimeMillis();
            if (this.mRecordThread != null && this.mRecordThread.isAlive() && Thread.currentThread().getId() != this.mRecordThread.getId()) {
                try {
                    this.mRecordThread.join();
                }
                catch (Exception exception) {
                    TXCLog.e(TAG, "record stop Exception: " + exception.getMessage());
                }
            }
            TXCLog.i(TAG, "stop ok,stop record cost time(MS): " + (System.currentTimeMillis() - l2));
            this.mRecordThread = null;
        }
        TXCLog.i(TAG, "stop ok");
    }

    public void pause(boolean sendMuteData) {
        TXCLog.i(TAG, "system audio record pause");
        this.mPause.set(true);
        this.mSendMuteData = sendMuteData;
    }

    public void resume() {
        TXCLog.i(TAG, "system audio record resume");
        this.mPause.set(false);
    }

    public synchronized boolean isRecording() {
        return this.mIsRunning;
    }

    private void init() {
        int n2 = this.mSampleRate;
        int n3 = this.mChannels;
        int n4 = this.mBits;
        int n5 = this.mAECType;
        TXCLog.i(TAG, String.format("audio record sampleRate = %d, channels = %d, bits = %d, aectype = %d", n2, n3, n4, n5));
        int n6 = 12;
        if (n3 == 1) {
            n6 = 16;
        }
        int n7 = 2;
        if (n4 == 8) {
            n7 = 3;
        }
        int n8 = AudioRecord.getMinBufferSize((int)n2, (int)n6, (int)n7);
        try {
            TXCLog.i(TAG, "audio record type: system normal");
            this.mMic = new AudioRecord(1, n2, n6, n7, n8 * 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TXCLog.e(TAG, "create AudioRecord failed.", illegalArgumentException);
        }
        if (this.mMic == null || this.mMic.getState() != 1) {
            TXCLog.e(TAG, "audio record: initialize the mic failed.");
            this.uninit();
            this.onRecordError(-1, "microphone permission denied!");
            return;
        }
        int n9 = 1024 * n3 * n4 / 8;
        this.mRecordBuffer = n9 > n8 ? new byte[n8] : new byte[n9];
        TXCLog.i(TAG, String.format("audio record: mic open rate=%dHZ, channels=%d, bits=%d, buffer=%d/%d, state=%d", n2, n3, n4, n8, this.mRecordBuffer.length, this.mMic.getState()));
        if (this.mMic != null) {
            try {
                this.mMic.startRecording();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "mic startRecording failed.", exception);
                this.onRecordError(-1, "start recording failed!");
                return;
            }
        }
    }

    private void uninit() {
        if (this.mMic != null) {
            TXCLog.i(TAG, "stop mic");
            try {
                this.mMic.setRecordPositionUpdateListener(null);
                this.mMic.stop();
                this.mMic.release();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "stop AudioRecord failed.", exception);
            }
        }
        this.mMic = null;
        this.mRecordBuffer = null;
        this.mIsCapFirstFrame = false;
    }

    private void onRecordPcmData(byte[] data, int len, long timestampMS) {
        c c2 = null;
        if (null != this.mWeakRefListener) {
            c2 = (c)this.mWeakRefListener.get();
        }
        if (null != c2) {
            c2.onAudioRecordPCM(data, len, timestampMS);
        } else {
            TXCLog.e(TAG, "onRecordPcmData:no callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecordError(int errNo, String errInfo) {
        c c2 = null;
        TXCAudioSysRecord tXCAudioSysRecord = this;
        synchronized (tXCAudioSysRecord) {
            if (null != this.mWeakRefListener) {
                c2 = (c)this.mWeakRefListener.get();
            }
        }
        if (null != c2) {
            c2.onAudioRecordError(errNo, errInfo);
        } else {
            TXCLog.e(TAG, "onRecordError:no callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecordStart() {
        c c2 = null;
        TXCAudioSysRecord tXCAudioSysRecord = this;
        synchronized (tXCAudioSysRecord) {
            if (null != this.mWeakRefListener) {
                c2 = (c)this.mWeakRefListener.get();
            }
        }
        if (null != c2) {
            c2.onAudioRecordStart();
        } else {
            TXCLog.e(TAG, "onRecordStart:no callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecordStop() {
        c c2 = null;
        TXCAudioSysRecord tXCAudioSysRecord = this;
        synchronized (tXCAudioSysRecord) {
            if (null != this.mWeakRefListener) {
                c2 = (c)this.mWeakRefListener.get();
            }
        }
        if (null != c2) {
            c2.onAudioRecordStop();
        } else {
            TXCLog.e(TAG, "onRecordStop:no callback");
        }
    }

    @Override
    public void run() {
        if (!this.mIsRunning) {
            TXCLog.w(TAG, "audio record: abandom start audio sys record thread!");
            return;
        }
        this.onRecordStart();
        TXCLog.i(TAG, "start capture audio data ...,mIsRunning:" + this.mIsRunning + " Thread.interrupted:" + Thread.interrupted() + " mMic:" + this.mMic);
        this.init();
        int n2 = 0;
        int n3 = 0;
        while (this.mIsRunning && !Thread.interrupted() && this.mMic != null && n2 <= 5) {
            boolean bl;
            long l2 = System.currentTimeMillis();
            int n4 = this.mMic.read(this.mRecordBuffer, n3, this.mRecordBuffer.length - n3);
            if (n4 != this.mRecordBuffer.length - n3) {
                if (n4 <= 0) {
                    TXCLog.e(TAG, "read pcm error, len =" + n4);
                    ++n2;
                    continue;
                }
                n3 += n4;
                continue;
            }
            n2 = 0;
            n3 = 0;
            if (!this.mIsCapFirstFrame) {
                this.onRecordError(-6, "First frame captured#");
                this.mIsCapFirstFrame = true;
            }
            if (this.mSendMuteData) {
                Arrays.fill(this.mRecordBuffer, (byte)0);
            }
            if (!(bl = !this.mPause.get() || this.mSendMuteData)) continue;
            this.onRecordPcmData(this.mRecordBuffer, this.mRecordBuffer.length, TXCTimeUtil.getTimeTick());
            this.nativeSendSysRecordAudioData(this.mRecordBuffer, this.mRecordBuffer.length, this.mSampleRate, this.mChannels, this.mBits);
        }
        TXCLog.d(TAG, "stop capture audio data ...,mIsRunning:" + this.mIsRunning + " mMic:" + this.mMic + " nFailedCount:" + n2);
        this.uninit();
        if (n2 > 5) {
            this.onRecordError(-1, "read data failed!");
        } else {
            this.onRecordStop();
        }
    }

    private native void nativeClassInit();

    private native void nativeSendSysRecordAudioData(byte[] var1, int var2, int var3, int var4, int var5);
}

