/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl.Play;

import android.content.Context;
import android.media.AudioTrack;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.basic.log.TXCLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class TXCMultAudioTrackPlayer {
    private static final String TAG = "AudioCenter:" + TXCMultAudioTrackPlayer.class.getSimpleName();
    private AudioTrackThread mAudioThread = null;
    private boolean mMute = false;
    private volatile boolean mIsStarted = false;
    private volatile boolean mAudioTrackStarted = false;
    private Context mContext = null;
    private int mAudioMode = 0;
    private int mSampleRate = 48000;
    private int mChannel = 2;
    private int mBits = 16;

    public static TXCMultAudioTrackPlayer getInstance() {
        return TXCMultAudioTrackPlayerHolder.getInstance();
    }

    private TXCMultAudioTrackPlayer() {
        this.nativeClassInit();
    }

    public void start() {
        TXCLog.w(TAG, "mult-track-player start!");
        if (this.mIsStarted) {
            TXCLog.e(TAG, "mult-track-player can not start because of has started!");
            return;
        }
        if (this.mSampleRate == 0 || this.mChannel == 0) {
            TXCLog.e(TAG, "strat mult-track-player failed with invalid audio info , samplerate:" + this.mSampleRate + ", channels:" + this.mChannel);
            return;
        }
        this.mIsStarted = true;
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioTrackThread("AUDIO_TRACK"){

                @Override
                public void run() {
                    int n2;
                    int n3;
                    int n4 = 0;
                    AudioTrack audioTrack = null;
                    try {
                        n3 = 3;
                        if (TXCMultAudioTrackPlayer.this.mChannel == 1) {
                            n3 = 2;
                        }
                        n2 = 2;
                        if (TXCMultAudioTrackPlayer.this.mBits == 8) {
                            n2 = 3;
                        }
                        n4 = AudioTrack.getMinBufferSize((int)TXCMultAudioTrackPlayer.this.mSampleRate, (int)n3, (int)n2);
                        audioTrack = new AudioTrack(3, TXCMultAudioTrackPlayer.this.mSampleRate, n3, n2, n4, 1);
                        TXCLog.i(TAG, "create audio track, samplerate:" + TXCMultAudioTrackPlayer.this.mSampleRate + ", channels:" + TXCMultAudioTrackPlayer.this.mChannel + ", bits:" + TXCMultAudioTrackPlayer.this.mBits + " mMinBufferLength:" + n4);
                    }
                    catch (Exception exception) {
                        TXCLog.e(TAG, "create AudioTrack failed.", exception);
                        return;
                    }
                    try {
                        audioTrack.play();
                    }
                    catch (Exception exception) {
                        TXCLog.e(TAG, "start play failed.", exception);
                        return;
                    }
                    TXCMultAudioTrackPlayer.this.mAudioTrackStarted = true;
                    TXCMultAudioTrackPlayer.this.setAudioMode(TXCMultAudioTrackPlayer.this.mContext, TXCMultAudioTrackPlayer.this.mAudioMode);
                    n3 = 0;
                    n2 = 800;
                    int n5 = 100;
                    while (this.mIsLooping) {
                        byte[] byArray = TXCMultAudioTrackPlayer.this.nativeGetMixedTracksDataToAudioTrack();
                        if (byArray != null && byArray.length > 0) {
                            TXCAudioEngine.onCorePlayPcmData(byArray, 0L, TXCMultAudioTrackPlayer.this.mSampleRate, TXCMultAudioTrackPlayer.this.mChannel);
                            if (TXCMultAudioTrackPlayer.this.mMute) {
                                Arrays.fill(byArray, (byte)0);
                            }
                            if (n5 != 0 && n3 < n2) {
                                short[] sArray = new short[byArray.length / 2];
                                ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(sArray);
                                int n6 = 0;
                                while (n6 < sArray.length) {
                                    int n7 = n6++;
                                    sArray[n7] = (short)(sArray[n7] / n5);
                                }
                                ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(sArray);
                                n5 = n5 * (n2 - (n3 += byArray.length / (2 * TXCMultAudioTrackPlayer.this.mSampleRate / 1000))) / n2;
                            }
                            audioTrack.write(byArray, 0, byArray.length);
                            continue;
                        }
                        try {
                            1.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        audioTrack.pause();
                        audioTrack.flush();
                        audioTrack.stop();
                        audioTrack.release();
                    }
                    catch (Exception exception) {
                        TXCLog.e(TAG, "stop AudioTrack failed.", exception);
                    }
                    TXCLog.e(TAG, "mult-player thread stop finish!");
                }
            };
            this.mAudioThread.startLoop();
            this.mAudioThread.start();
        }
        TXCLog.w(TAG, "mult-track-player thread start finish!");
    }

    public void stop() {
        TXCLog.w(TAG, "mult-track-player stop!");
        if (!this.mIsStarted) {
            TXCLog.w(TAG, "mult-track-player can not stop because of not started yet!");
            return;
        }
        if (this.mAudioThread != null) {
            this.mAudioThread.stopLoop();
            this.mAudioThread = null;
        }
        this.mAudioMode = 0;
        this.mContext = null;
        this.mAudioTrackStarted = false;
        this.mIsStarted = false;
        TXCLog.w(TAG, "mult-track-player stop finish!");
    }

    public synchronized void setAudioMode(Context context, int audioMode) {
        this.mContext = context;
        this.mAudioMode = audioMode;
        if (this.mAudioTrackStarted) {
            TXCLog.w(TAG, "mult-track-player setAudioRoute~");
        } else {
            TXCLog.w(TAG, "mult-track-player do'not setAudioRoute~");
        }
    }

    public boolean isPlaying() {
        return this.mIsStarted;
    }

    public void setMute(boolean mute) {
        this.mMute = mute;
    }

    private native void nativeClassInit();

    private native byte[] nativeGetMixedTracksDataToAudioTrack();

    private static class TXCMultAudioTrackPlayerHolder {
        private static TXCMultAudioTrackPlayer instance = new TXCMultAudioTrackPlayer();

        private TXCMultAudioTrackPlayerHolder() {
        }

        public static TXCMultAudioTrackPlayer getInstance() {
            return instance;
        }
    }

    class AudioTrackThread
    extends Thread {
        volatile boolean mIsLooping;

        public AudioTrackThread(String name) {
            super(name);
            this.mIsLooping = false;
        }

        public void startLoop() {
            this.mIsLooping = true;
        }

        public void stopLoop() {
            this.mIsLooping = false;
        }
    }
}

