/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl.earmonitor;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.huawei.multimedia.liteav.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.liteav.audiokit.interfaces.HwAudioKit;
import com.huawei.multimedia.liteav.audiokit.interfaces.IAudioKitCallback;
import com.tencent.liteav.audio.impl.earmonitor.TXSystemAudioKit;
import com.tencent.liteav.audio.impl.earmonitor.a;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.i;
import com.tencent.liteav.basic.util.k;
import java.util.concurrent.TimeUnit;

public class HuaweiAudioKit
implements IAudioKitCallback,
TXSystemAudioKit,
k.a {
    private static final String TAG = "HuaweiAudioKit";
    private static final int BACKGROUND_CHECK_INTERVAL = (int)TimeUnit.SECONDS.toMillis(1L);
    private final Handler mUiHandler = new Handler(Looper.getMainLooper());
    private HwAudioKit mHwAudioKit;
    private boolean mIsAudioKitIniting = false;
    private a mAudioKitCallback;
    private k mBackgroundCheckTimer;
    private HwAudioKaraokeFeatureKit mKaraokeKit;
    private boolean mIsEarMonitoringEnabled = false;
    private boolean mIsBackgroundWhenLastCheck = false;

    @Override
    public void initialize(final Context context, final a callback) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (HuaweiAudioKit.this.mHwAudioKit != null) {
                    TXCLog.e(HuaweiAudioKit.TAG, "it's already initialized.");
                    return;
                }
                TXCLog.i(HuaweiAudioKit.TAG, "start initialize audio kit");
                HuaweiAudioKit.this.mIsAudioKitIniting = true;
                HuaweiAudioKit.this.mAudioKitCallback = callback;
                HuaweiAudioKit.this.mHwAudioKit = new HwAudioKit(context.getApplicationContext(), HuaweiAudioKit.this);
                HuaweiAudioKit.this.mHwAudioKit.initialize();
            }
        });
    }

    @Override
    public void uninitialize() {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                TXCLog.i(HuaweiAudioKit.TAG, "uninitialize");
                if (HuaweiAudioKit.this.mKaraokeKit != null) {
                    HuaweiAudioKit.this.mKaraokeKit.destroy();
                    HuaweiAudioKit.this.mKaraokeKit = null;
                }
                if (HuaweiAudioKit.this.mHwAudioKit != null) {
                    HuaweiAudioKit.this.mHwAudioKit.destroy();
                    HuaweiAudioKit.this.mHwAudioKit = null;
                }
                HuaweiAudioKit.this.mIsAudioKitIniting = false;
            }
        });
    }

    @Override
    public void startSystemEarMonitoring() {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                HuaweiAudioKit.this.startTimer();
                HuaweiAudioKit.this.startSystemEarMonitoringInternal();
            }
        });
    }

    private void startTimer() {
        if (this.mBackgroundCheckTimer != null) {
            return;
        }
        TXCLog.i(TAG, "start background checking timer");
        this.mBackgroundCheckTimer = new k(Looper.getMainLooper(), this);
        this.mBackgroundCheckTimer.a(0, BACKGROUND_CHECK_INTERVAL);
    }

    private void startSystemEarMonitoringInternal() {
        TXCLog.i(TAG, "startSystemEarMonitoring kit: %s", this.mKaraokeKit);
        if (this.mKaraokeKit == null) {
            return;
        }
        int n2 = this.mKaraokeKit.enableKaraokeFeature(true);
        if (n2 != 0 && n2 != 1805) {
            this.dealWithAudioKitResultInternal(1003);
        } else {
            this.mIsEarMonitoringEnabled = true;
        }
    }

    @Override
    public void stopSystemEarMonitoring() {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                HuaweiAudioKit.this.stopTimer();
                HuaweiAudioKit.this.stopSystemEarMonitoringInternal();
            }
        });
    }

    private void stopTimer() {
        if (this.mBackgroundCheckTimer != null) {
            TXCLog.i(TAG, "stop background checking timer");
            this.mBackgroundCheckTimer.a();
            this.mBackgroundCheckTimer = null;
        }
    }

    private void stopSystemEarMonitoringInternal() {
        TXCLog.i(TAG, "stopSystemEarMonitoring");
        if (this.mKaraokeKit != null) {
            this.mKaraokeKit.enableKaraokeFeature(false);
            this.mIsEarMonitoringEnabled = false;
        }
    }

    @Override
    public void setSystemEarMonitoringVolume(final int volume) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                HuaweiAudioKit.this.setSystemEarMonitoringVolumeInternal(volume);
            }
        });
    }

    private void setSystemEarMonitoringVolumeInternal(int volume) {
        int n2;
        TXCLog.i(TAG, "setSystemEarMonitoringVolumeInternal: %d, kit: %s", volume, this.mKaraokeKit);
        if (this.mKaraokeKit != null && ((n2 = this.mKaraokeKit.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, volume)) == 1806 || n2 == -2)) {
            this.dealWithAudioKitResultInternal(-2);
        }
    }

    @Override
    public void onResult(final int result) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                HuaweiAudioKit.this.dealWithAudioKitResultInternal(result);
            }
        });
    }

    private void dealWithAudioKitResultInternal(int result) {
        TXCLog.i(TAG, "on audio kit callback: %d", result);
        if (result == 0) {
            this.mIsAudioKitIniting = false;
            if (this.mAudioKitCallback != null) {
                this.mAudioKitCallback.onAudioKitInitFinished(this, true);
            }
            if (this.mHwAudioKit.isFeatureSupported(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE)) {
                this.mKaraokeKit = (HwAudioKaraokeFeatureKit)this.mHwAudioKit.createFeature(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
            } else if (this.mAudioKitCallback != null) {
                this.mAudioKitCallback.onEarMonitoringInitialized(this, false);
            }
        } else if (result == 1000) {
            if (this.mAudioKitCallback != null) {
                this.mAudioKitCallback.onEarMonitoringInitialized(this, true);
            }
        } else if (result != 1805 && this.mAudioKitCallback != null) {
            if (this.mIsAudioKitIniting) {
                this.mAudioKitCallback.onAudioKitInitFinished(this, false);
                this.mIsAudioKitIniting = false;
            } else {
                this.mAudioKitCallback.onAudioKitError(this);
            }
        }
    }

    @Override
    public void onTimeout() {
        boolean bl = i.a(TXCCommonUtil.getAppContext());
        if (this.mIsEarMonitoringEnabled && this.mIsBackgroundWhenLastCheck && !bl) {
            this.stopSystemEarMonitoringInternal();
            this.startSystemEarMonitoringInternal();
        } else if (bl && !this.mIsBackgroundWhenLastCheck) {
            TXCLog.i(TAG, "app has gone to background.");
        }
        this.mIsBackgroundWhenLastCheck = bl;
    }
}

