/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.network;

import android.content.Context;
import android.os.Bundle;
import com.tencent.liteav.basic.c.b;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.network.TXCStreamDownloader;
import com.tencent.liteav.network.e;
import com.tencent.liteav.network.f;
import com.tencent.liteav.network.g;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class TXIStreamDownloader {
    protected g mListener = null;
    protected b mNotifyListener = null;
    protected a mRestartListener = null;
    protected f mMessageNotifyListener = null;
    protected Context mApplicationContext = null;
    protected boolean mIsRunning = false;
    protected String mOriginUrl = "";
    public int connectRetryTimes = 0;
    public int connectRetryLimit = 3;
    public int connectRetryInterval = 3;
    protected boolean mEnableMessage = false;
    protected boolean mEnableMetaData = false;
    protected String mFlvSessionKey = "";
    protected String mUserID = "";
    protected int mPayloadType;
    protected Map<String, String> mHeaders;

    public TXIStreamDownloader(Context context) {
        this.mApplicationContext = context;
    }

    public void setPayloadType(int payloadType) {
        this.mPayloadType = payloadType;
    }

    public void setListener(g listener) {
        this.mListener = listener;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers;
    }

    public void setNotifyListener(b listener) {
        this.mNotifyListener = listener;
    }

    public void setRestartListener(a listener) {
        this.mRestartListener = listener;
    }

    public abstract void startDownload(Vector<e> var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public abstract void startDownload(Vector<e> var1, boolean var2, boolean var3, boolean var4, boolean var5, com.tencent.liteav.basic.b.a var6);

    public abstract void stopDownload();

    public void sendNotifyEvent(int event) {
        if (this.mNotifyListener != null) {
            this.mNotifyListener.onNotifyEvent(event, null);
        }
    }

    public void sendNotifyEvent(int event, String message) {
        if (this.mNotifyListener != null) {
            Bundle bundle = new Bundle();
            bundle.putString("EVT_MSG", message);
            this.mNotifyListener.onNotifyEvent(event, bundle);
        }
    }

    public void sendNotifyEvent(int event, String message, HashMap<String, String> param) {
        if (this.mNotifyListener != null) {
            Bundle bundle = new Bundle();
            if (param != null && param.size() > 0) {
                for (String string : param.keySet()) {
                    bundle.putString(string, param.get(string));
                }
            }
            bundle.putString("EVT_MSG", message);
            this.mNotifyListener.onNotifyEvent(event, bundle);
        }
    }

    public void sendNotifyEvent(int event, String message, Bundle param) {
        if (this.mNotifyListener != null) {
            Bundle bundle = new Bundle();
            if (param != null) {
                bundle.putAll(param);
            }
            bundle.putString("EVT_MSG", message);
            this.mNotifyListener.onNotifyEvent(event, bundle);
        }
    }

    public void onRecvVideoData(byte[] nal, int nalType, long dts, long pts, int codecId) {
        if (this.mListener != null) {
            TXSNALPacket tXSNALPacket = new TXSNALPacket();
            tXSNALPacket.nalData = nal;
            tXSNALPacket.nalType = nalType;
            tXSNALPacket.dts = dts;
            tXSNALPacket.pts = pts;
            tXSNALPacket.codecId = codecId;
            this.mListener.onPullNAL(tXSNALPacket);
        }
    }

    public void onRecvAudioData(byte[] aac, int ts, int audioType, int codecFormat) {
        if (this.mListener != null) {
            com.tencent.liteav.basic.structs.a a2 = new com.tencent.liteav.basic.structs.a();
            a2.f = aac;
            a2.e = ts;
            if (audioType == 10) {
                a2.d = codecFormat == 1 ? 2 : 3;
                if (a2.d == 2) {
                    a2.c = 16;
                }
            }
            if (audioType == 2) {
                a2.d = 5;
            }
            a2.h = audioType;
            a2.g = codecFormat;
            this.mListener.onPullAudio(a2);
        }
    }

    public void onRecvSEIData(byte[] sei) {
        if (sei != null && sei.length > 0 && this.mMessageNotifyListener != null) {
            this.mMessageNotifyListener.onSEIMessage(sei);
        }
    }

    public void onRecvMetaData(HashMap<String, String> metadata) {
        if (metadata != null && metadata.size() > 0 && this.mMessageNotifyListener != null) {
            this.mMessageNotifyListener.onMetaDataMessage(metadata);
        }
    }

    public TXCStreamDownloader.DownloadStats getDownloadStats() {
        return null;
    }

    public void setOriginUrl(String originUrl) {
        this.mOriginUrl = originUrl;
    }

    public String getCurrentStreamUrl() {
        return null;
    }

    public String getRealStreamUrl() {
        return null;
    }

    public boolean isQuicChannel() {
        return false;
    }

    public int getConnectCountQuic() {
        return 0;
    }

    public int getConnectCountTcp() {
        return 0;
    }

    public void setUserID(String userID) {
        this.mUserID = userID;
    }

    public void PushVideoFrame(byte[] data, int frameType, long dts, long pts, int codecId) {
    }

    public void PushAudioFrame(byte[] data, int packetType, long pts, int codecFormat) {
    }

    public long getCurrentTS() {
        return 0L;
    }

    public long getLastIFrameTS() {
        return 0L;
    }

    public void requestKeyFrame(String playUrl) {
    }

    public void setFlvSessionKey(String flvSessionKey) {
        this.mFlvSessionKey = flvSessionKey;
    }

    public String getFlvSessionKey() {
        return this.mFlvSessionKey;
    }

    public void setMessageNotifyListener(f listener) {
        this.mMessageNotifyListener = listener;
    }

    public static interface a {
        public void onRestartDownloader();

        public void onOldStreamStop();
    }
}

