/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.liteav.basic.e.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.TXCEventRecorderProxy;
import com.tencent.liteav.basic.module.TXCKeyPointReportProxy;
import com.tencent.liteav.basic.opengl.TXCOpenGlUtils;
import com.tencent.liteav.basic.opengl.j;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.structs.TXSVideoFrame;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.i;
import com.tencent.liteav.h;
import com.tencent.liteav.o;
import com.tencent.liteav.renderer.a;
import com.tencent.liteav.renderer.e;
import com.tencent.liteav.renderer.f;
import com.tencent.liteav.videodecoder.TXCVideoDecoder;
import com.tencent.liteav.videodecoder.g;
import java.lang.ref.WeakReference;

public class TXCRenderAndDec
extends com.tencent.liteav.basic.module.a
implements com.tencent.liteav.basic.c.b,
a.a,
f,
g {
    public static final String TAG = "TXCRenderAndDec";
    private Context mContext = null;
    private h mConfig = null;
    private boolean mEnableLimitHWDecCache = false;
    private TXCVideoDecoder mVideoDecoder = null;
    private boolean mEnableDecoderChange = false;
    private boolean mEnableRestartDecoder = false;
    private e mVideoRender = null;
    private WeakReference<com.tencent.liteav.basic.c.b> mNotifyListener;
    private WeakReference<b> mRenderAndDecDelegate;
    private j mRGBA2YUVFilter = null;
    private int mCustomRenderFrameBufferId = -1;
    private com.tencent.liteav.basic.enums.b mVideoFrameFormat = com.tencent.liteav.basic.enums.b.a;
    private o mVideoFrameListener;
    private boolean mRealTime = false;
    private boolean mIsRendering = false;
    private int mStreamType = 0;
    private long mFrameDecErrCnt = 0L;
    private long mLastReqKeyFrameTS = 0L;
    private boolean mFirstRender = false;
    private int mRenderMode = 0;
    private int mRenderRotation = 0;
    private long mLastRenderCalculateTS = 0L;
    private long mRenderFrameCount = 0L;
    private long mLastRenderFrameCount = 0L;
    private long mCurrentRenderPts = 0L;
    private a mDecListener = null;

    public TXCRenderAndDec(Context context) {
        this.mContext = context;
        c.a().a(this.mContext);
    }

    public void setVideoRender(e render) {
        TXCLog.i(TAG, "set video render " + render + " id " + this.getID() + ", " + this.mStreamType);
        this.mVideoRender = render;
        if (this.mVideoRender == null) {
            return;
        }
        this.mVideoRender.setID(this.getID());
        this.mVideoRender.a(this.mStreamType);
        this.mVideoRender.a(this);
        this.mVideoRender.c(this.mRenderMode);
        this.mVideoRender.e(this.mRenderRotation);
        if (this.mVideoFrameListener != null && this.mVideoRender instanceof com.tencent.liteav.renderer.a) {
            ((com.tencent.liteav.renderer.a)this.mVideoRender).b(this);
        }
        if (this.mConfig != null) {
            this.mVideoRender.b(this.mConfig.d);
        }
    }

    public void setNotifyListener(com.tencent.liteav.basic.c.b notifyListener) {
        this.mNotifyListener = new WeakReference<com.tencent.liteav.basic.c.b>(notifyListener);
    }

    public void setRenderAndDecDelegate(b delegate) {
        this.mRenderAndDecDelegate = new WeakReference<b>(delegate);
    }

    public void setVideoFrameListener(o listener, com.tencent.liteav.basic.enums.b videoFrameFormat) {
        this.mVideoFrameListener = listener;
        this.mVideoFrameFormat = videoFrameFormat;
        TXCLog.i(TAG, "setVideoFrameListener->enter listener: " + listener + ", format: " + (Object)((Object)videoFrameFormat));
        if (this.mVideoRender != null && this.mVideoRender instanceof com.tencent.liteav.renderer.a) {
            if (listener == null) {
                TXCLog.i(TAG, "setCustomRenderListener-> clean listener.");
                ((com.tencent.liteav.renderer.a)this.mVideoRender).b((a.a)null);
            } else {
                TXCLog.i(TAG, "setCustomRenderListener-> set listener.");
                ((com.tencent.liteav.renderer.a)this.mVideoRender).b(this);
            }
        }
    }

    public void setConfig(h config) {
        this.mConfig = config;
        if (this.mVideoRender != null) {
            this.mVideoRender.b(this.mConfig.d);
        }
    }

    public h getConfig() {
        return this.mConfig;
    }

    @Override
    public void setID(String id) {
        super.setID(id);
        if (this.mVideoRender != null) {
            this.mVideoRender.setID(this.getID());
        }
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.setUserId(id);
        }
    }

    public void setDecListener(a listener) {
        this.mDecListener = listener;
    }

    public void enableDecoderChange(boolean enable) {
        this.mEnableDecoderChange = enable;
    }

    public void enableRestartDecoder(boolean enable) {
        this.mEnableRestartDecoder = enable;
    }

    public void start(boolean realTime) {
        TXCLog.i(TAG, "start render dec " + this.getID() + ", " + this.mStreamType);
        this.mRealTime = realTime;
        this.mFrameDecErrCnt = 0L;
        this.mLastReqKeyFrameTS = 0L;
        if (this.mVideoRender != null) {
            this.mVideoRender.a(this);
            this.mVideoRender.e();
            this.mVideoRender.setID(this.getID());
        }
        this.mVideoDecoder = new TXCVideoDecoder();
        this.mVideoDecoder.setUserId(this.getID());
        this.mVideoDecoder.setStreamType(this.mStreamType);
        this.mVideoDecoder.setListener(this);
        this.mVideoDecoder.setNotifyListener(this);
        this.mVideoDecoder.enableChange(this.mEnableDecoderChange);
        this.mVideoDecoder.enableLimitDecCache(this.mEnableLimitHWDecCache);
        this.mVideoDecoder.enableRestart(this.mEnableRestartDecoder);
        this.startDecode();
        this.mIsRendering = true;
    }

    public void startVideo() {
        this.stopVideo();
        this.mRealTime = true;
        this.mFrameDecErrCnt = 0L;
        this.mLastReqKeyFrameTS = 0L;
        this.mCurrentRenderPts = 0L;
        if (this.mVideoRender != null) {
            this.mVideoRender.a(this);
            this.mVideoRender.e();
            this.mVideoRender.setID(this.getID());
        }
        TXCLog.i(TAG, "start video dec " + this.getID() + ", " + this.mStreamType);
        this.mVideoDecoder = new TXCVideoDecoder();
        this.mVideoDecoder.setUserId(this.getID());
        this.mVideoDecoder.setStreamType(this.mStreamType);
        this.mVideoDecoder.setListener(this);
        this.mVideoDecoder.setNotifyListener(this);
        this.mVideoDecoder.enableChange(this.mEnableDecoderChange);
        this.mVideoDecoder.enableRestart(this.mEnableRestartDecoder);
        this.mVideoDecoder.enableLimitDecCache(this.mEnableLimitHWDecCache);
        this.startDecode();
        this.mIsRendering = true;
    }

    public void stopVideo() {
        this.mIsRendering = false;
        if (this.mVideoDecoder != null) {
            TXCLog.i(TAG, "stop video dec " + this.getID() + ", " + this.mStreamType);
            this.mVideoDecoder.setListener(null);
            this.mVideoDecoder.setNotifyListener(null);
            this.mVideoDecoder.stop();
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.a(false);
            this.mVideoRender.a((f)null);
        }
    }

    public void stop() {
        TXCLog.i(TAG, "stop video render dec " + this.getID() + ", " + this.mStreamType);
        this.mIsRendering = false;
        this.mRealTime = false;
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.setListener(null);
            this.mVideoDecoder.setNotifyListener(null);
            this.mVideoDecoder.stop();
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.a(true);
            this.mVideoRender.a((f)null);
        }
    }

    public void enableReport(boolean enabled) {
        if (this.mVideoRender != null) {
            this.mVideoRender.c(enabled);
        }
    }

    public void resetPeriodStatistics() {
        if (this.mVideoRender != null) {
            this.mVideoRender.m();
        }
    }

    public void resetPeriodFeelingStatistics() {
        if (this.mVideoRender != null) {
            this.mVideoRender.n();
        }
    }

    public boolean isRendering() {
        return this.mIsRendering;
    }

    public void decVideo(TXSNALPacket nal) {
    }

    public void setRenderMode(int mode) {
        this.mRenderMode = mode;
        if (this.mVideoRender != null) {
            this.mVideoRender.c(mode);
        }
    }

    public void setRenderRotation(int rotation) {
        TXCLog.i(TAG, "vrotation setRenderRotation " + rotation);
        this.mRenderRotation = rotation;
        if (this.mVideoRender != null) {
            this.mVideoRender.e(rotation);
        }
    }

    public void setRenderMirrorType(int mirrorType) {
        TXCLog.i(TAG, "setRenderMirrorType " + mirrorType);
        if (this.mVideoRender != null) {
            this.mVideoRender.d(mirrorType);
        }
    }

    public void setBlockInterval(int blockIntervalMs) {
        if (this.mVideoRender != null) {
            this.mVideoRender.f(blockIntervalMs);
        }
    }

    public long getVideoCacheDuration() {
        int n2 = this.getIntValue(6104, 2);
        return n2;
    }

    public long getVideoCacheFrameCount() {
        int n2 = this.getIntValue(6105, 2);
        return n2;
    }

    public int getVideoDecCacheFrameCount() {
        int n2 = this.getIntValue(6106, 2);
        return n2;
    }

    public long getAVPlayInterval() {
        long l2 = this.getLongValue(6107, 2);
        return l2;
    }

    public long getAVNetRecvInterval() {
        long l2 = this.getLongValue(6108, 2);
        return l2;
    }

    public int getVideoGop() {
        return this.getIntValue(7120);
    }

    public long getCurrentRenderPts() {
        return this.mCurrentRenderPts;
    }

    public void updateLoadInfo() {
        if (this.mVideoDecoder != null) {
            this.setStatusValue(5002, this.mStreamType, this.mVideoDecoder.isHardwareDecode() ? 1L : 0L);
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.o();
        } else {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.mLastRenderCalculateTS;
            if (l3 >= 1000L) {
                double d2 = (double)(this.mRenderFrameCount - this.mLastRenderFrameCount) * 1000.0 / (double)l3;
                this.mLastRenderFrameCount = this.mRenderFrameCount;
                this.mLastRenderCalculateTS = l2;
                this.setStatusValue(6002, this.mStreamType, d2);
            }
        }
    }

    public e getVideoRender() {
        return this.mVideoRender;
    }

    public void setStreamType(int streamType) {
        this.mStreamType = streamType;
        if (this.mVideoRender != null) {
            this.mVideoRender.a(this.mStreamType);
        }
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.setStreamType(this.mStreamType);
        }
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public void enableLimitDecCache(boolean enableLimit) {
        this.mEnableLimitHWDecCache = enableLimit;
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null) {
            tXCVideoDecoder.enableLimitDecCache(enableLimit);
        }
    }

    private void startDecode(SurfaceTexture surfaceTexture) {
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null) {
            tXCVideoDecoder.stop();
            tXCVideoDecoder.enableHWDec(this.mConfig.h);
            tXCVideoDecoder.config(this.mConfig.t);
            TXCLog.i(TAG, "trtc_ start decode " + surfaceTexture + ", hw: " + this.mConfig.h + ", id " + this.getID() + "_" + this.mStreamType);
            if (surfaceTexture != null) {
                tXCVideoDecoder.setup(surfaceTexture, null, null, !this.mRealTime);
                tXCVideoDecoder.setUserId(this.getID());
                tXCVideoDecoder.start();
            } else if (!this.mConfig.h) {
                tXCVideoDecoder.setup((Surface)null, null, null, !this.mRealTime);
                tXCVideoDecoder.setUserId(this.getID());
                tXCVideoDecoder.start();
            }
        }
    }

    private void startDecode() {
        SurfaceTexture surfaceTexture = this.mVideoRender != null ? this.mVideoRender.a() : null;
        this.startDecode(surfaceTexture);
    }

    private void notifyEvent(int event, String description) {
        Bundle bundle = new Bundle();
        bundle.putString("EVT_USERID", this.getID());
        bundle.putInt("EVT_ID", event);
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        if (description != null) {
            bundle.putCharSequence("EVT_MSG", (CharSequence)description);
        }
        bundle.putInt("EVT_STREAM_TYPE", this.mStreamType);
        i.a(this.mNotifyListener, event, bundle);
    }

    public void restartDecoder() {
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null && tXCVideoDecoder.isH265()) {
            tXCVideoDecoder.restart(true);
        }
    }

    @Override
    public void onNotifyEvent(int event, Bundle param) {
        if (event == 2106) {
            this.mConfig.h = false;
            TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
            if (tXCVideoDecoder != null) {
                tXCVideoDecoder.restart(this.mConfig.h);
            }
        } else if (event == -2304) {
            if (com.tencent.liteav.basic.a.a()) {
                this.mConfig.h = false;
                TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
                if (tXCVideoDecoder != null) {
                    tXCVideoDecoder.restart(false);
                }
                return;
            }
        } else if (event == 2020) {
            TXCLog.e(TAG, "decoding too many frame(>40) without output! request key frame now.");
            this.requestKeyFrame();
            return;
        }
        param.putInt("EVT_STREAM_TYPE", this.mStreamType);
        i.a(this.mNotifyListener, event, param);
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture) {
        TXCLog.w(TAG, "play decode when surface texture create hw " + this.mConfig.h);
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null) {
            tXCVideoDecoder.setup(surfaceTexture, null, null, !this.mRealTime);
        }
        if (this.mConfig.h) {
            this.startDecode(surfaceTexture);
        }
        this.resetPeriodStatistics();
        this.enableReport(true);
    }

    @Override
    public void onSurfaceTextureDestroy(SurfaceTexture surfaceTexture) {
        try {
            TXCLog.w(TAG, "play:stop decode when surface texture release");
            if (this.mConfig.h && this.mVideoDecoder != null) {
                this.mVideoDecoder.stop();
            }
            if (this.mCustomRenderFrameBufferId != -1) {
                TXCOpenGlUtils.b(this.mCustomRenderFrameBufferId);
                this.mCustomRenderFrameBufferId = -1;
            }
            if (this.mRGBA2YUVFilter != null) {
                this.mRGBA2YUVFilter.d();
                this.mRGBA2YUVFilter = null;
            }
            if (this.mDecListener != null) {
                this.mDecListener.a(surfaceTexture);
            }
            this.resetPeriodStatistics();
            this.enableReport(false);
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "onSurfaceTextureDestroy failed.", exception);
        }
    }

    @Override
    public void onDecodeFrame(TXSVideoFrame videoFrame, int width, int height, long pts, long dts, int rotation) {
        o o2;
        this.mCurrentRenderPts = pts;
        if (rotation == 0 || rotation == 1 || rotation == 2 || rotation == 3) {
            rotation = 360 - rotation * 90;
        }
        if ((o2 = this.mVideoFrameListener) != null && videoFrame != null && (this.mVideoFrameFormat == com.tencent.liteav.basic.enums.b.b || this.mVideoFrameFormat == com.tencent.liteav.basic.enums.b.e)) {
            TXSVideoFrame tXSVideoFrame = videoFrame;
            if (this.mVideoRender != null) {
                tXSVideoFrame = videoFrame.clone();
            }
            tXSVideoFrame.rotation = (rotation + this.mRenderRotation) % 360;
            if (this.mVideoFrameFormat == com.tencent.liteav.basic.enums.b.e) {
                tXSVideoFrame.loadNV21BufferFromI420Buffer();
            }
            o2.onRenderVideoFrame(this.getID(), this.mStreamType, tXSVideoFrame);
        }
        if (!this.mFirstRender) {
            this.mFirstRender = true;
            TXCEventRecorderProxy.a(this.getID(), 5007, -1L, -1L, "", this.mStreamType);
            if (this.mVideoRender == null) {
                TXCKeyPointReportProxy.a(this.getID(), 40022, 0L, this.mStreamType);
            }
            if (this.mVideoDecoder != null) {
                TXCKeyPointReportProxy.a(this.getID(), 40029, this.mVideoDecoder.GetDecodeFirstFrameTS(), this.mStreamType);
            }
            if (this.mStreamType == 2) {
                TXCKeyPointReportProxy.a(this.getID(), 32004);
            }
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.a(videoFrame, width, height, rotation);
        } else if (this.mLastRenderCalculateTS == 0L) {
            this.mLastRenderCalculateTS = System.currentTimeMillis();
            this.mLastRenderFrameCount = 0L;
            this.mRenderFrameCount = 0L;
        } else {
            ++this.mRenderFrameCount;
        }
    }

    @Override
    public void onVideoSizeChange(int width, int height) {
        if (this.mVideoRender != null) {
            this.mVideoRender.c(width, height);
        }
        Bundle bundle = new Bundle();
        bundle.putCharSequence("EVT_MSG", (CharSequence)("Resolution changed to" + width + "x" + height));
        bundle.putInt("EVT_PARAM1", width);
        bundle.putInt("EVT_PARAM2", height);
        bundle.putString("EVT_USERID", this.getID());
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
        this.onNotifyEvent(2009, bundle);
        this.setStatusValue(5003, this.mStreamType, width << 16 | height);
        TXCEventRecorderProxy.a(this.getID(), 4003, width, height, "", this.mStreamType);
        TXCKeyPointReportProxy.a(this.getID(), 40002, width, this.mStreamType);
        TXCKeyPointReportProxy.a(this.getID(), 40003, height, this.mStreamType);
    }

    @Override
    public void onDecoderChange(String mimeType, boolean isH265) {
    }

    @Override
    public void onDecodeFailed(int code) {
        TXCLog.e(TAG, "video decode failed " + code);
        if (code == -2) {
            TXCVideoDecoder tXCVideoDecoder;
            TXCLog.w(TAG, "use h265 softdecoder but not set h265 softdecoder to sdk, isH265SoftDecodeExist= " + com.tencent.liteav.basic.a.a());
            if (!com.tencent.liteav.basic.a.a() && (tXCVideoDecoder = this.mVideoDecoder) != null && tXCVideoDecoder.isH265()) {
                this.mConfig.h = true;
                tXCVideoDecoder.restart(true);
            }
        } else if (-4 == code) {
            this.notifyEvent(-2312, "h265 softdecoder start fail.");
        } else {
            this.requestKeyFrame();
            this.setStatusValue(17014, this.mStreamType, ++this.mFrameDecErrCnt);
        }
    }

    @Override
    public void onTextureProcess(int textureId, int width, int height, int frameRotation) {
        o o2 = this.mVideoFrameListener;
        if (o2 == null) {
            return;
        }
        TXSVideoFrame tXSVideoFrame = new TXSVideoFrame();
        tXSVideoFrame.width = width;
        tXSVideoFrame.height = height;
        tXSVideoFrame.pts = TXCTimeUtil.getTimeTick();
        tXSVideoFrame.rotation = (frameRotation + this.mRenderRotation) % 360;
        if (this.mVideoFrameFormat == com.tencent.liteav.basic.enums.b.f) {
            tXSVideoFrame.textureId = textureId;
            tXSVideoFrame.eglContext = TXCOpenGlUtils.e();
            if (this.mCustomRenderFrameBufferId == -1) {
                this.mCustomRenderFrameBufferId = TXCOpenGlUtils.d();
            }
            TXCOpenGlUtils.a(textureId, this.mCustomRenderFrameBufferId);
            GLES20.glBindFramebuffer((int)36160, (int)this.mCustomRenderFrameBufferId);
            this.mVideoFrameListener.onRenderVideoFrame(this.getID(), this.mStreamType, tXSVideoFrame);
            TXCOpenGlUtils.d(this.mCustomRenderFrameBufferId);
        } else if (this.mVideoFrameFormat == com.tencent.liteav.basic.enums.b.c) {
            tXSVideoFrame.textureId = textureId;
            if (this.mVideoRender instanceof com.tencent.liteav.renderer.a) {
                tXSVideoFrame.eglContext = ((com.tencent.liteav.renderer.a)this.mVideoRender).b();
            }
            o2.onRenderVideoFrame(this.getID(), this.mStreamType, tXSVideoFrame);
        } else {
            TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
            if (tXCVideoDecoder != null && !tXCVideoDecoder.isHardwareDecode()) {
                return;
            }
            if (this.mRGBA2YUVFilter == null) {
                this.mRGBA2YUVFilter = this.mVideoFrameFormat == com.tencent.liteav.basic.enums.b.e ? new com.tencent.liteav.beauty.b.o(3) : new com.tencent.liteav.beauty.b.o(1);
                this.mRGBA2YUVFilter.a(true);
                if (this.mRGBA2YUVFilter.a()) {
                    this.mRGBA2YUVFilter.a(width, height);
                } else {
                    TXCLog.i(TAG, "throwVideoFrame->release mVideoFrameFilter");
                    this.mRGBA2YUVFilter = null;
                }
            }
            if (this.mRGBA2YUVFilter != null) {
                GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
                this.mRGBA2YUVFilter.a(width, height);
                this.mRGBA2YUVFilter.b(textureId);
                GLES20.glBindFramebuffer((int)36160, (int)this.mRGBA2YUVFilter.m());
                o2.onRenderVideoFrame(this.getID(), this.mStreamType, tXSVideoFrame);
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
        }
    }

    private void requestKeyFrame() {
        long l2 = TXCTimeUtil.getTimeTick();
        if (l2 > this.mLastReqKeyFrameTS + 3000L) {
            b b2;
            this.mLastReqKeyFrameTS = l2;
            TXCLog.e(TAG, "requestKeyFrame: " + this.getID());
            if (this.mRenderAndDecDelegate != null && (b2 = (b)this.mRenderAndDecDelegate.get()) != null) {
                b2.onRequestKeyFrame(this.getID(), this.mStreamType);
            }
        }
    }

    public static interface a {
        public void a(SurfaceTexture var1);
    }

    public static interface b {
        public void onRequestKeyFrame(String var1, int var2);
    }
}

