/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.util;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.liteav.basic.log.TXCLog;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;

public class TXHttpRequest {
    private static final String TAG = "TXHttpRequest";
    private static final int CON_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private long mNativeHttps = 0L;
    private d mSock5ProxyConfig = new d();

    public void setSocks5Proxy(String host, int port, String auth, String password) {
        this.mSock5ProxyConfig.a = host;
        this.mSock5ProxyConfig.b = port;
        this.mSock5ProxyConfig.c = auth;
        this.mSock5ProxyConfig.d = password;
    }

    public TXHttpRequest(long nativeHttp) {
        this.mNativeHttps = nativeHttp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static c downloadFileInternal(String url, String savePath, d config) {
        HttpURLConnection httpURLConnection = null;
        c c2 = new c();
        try {
            Proxy proxy = null;
            if (config != null && !TextUtils.isEmpty((CharSequence)config.a) && config.b > 0) {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(config.a, config.b));
                Authenticator.setDefault(new a(config.c, config.d));
            }
            httpURLConnection = proxy != null ? (HttpsURLConnection)new URL(url).openConnection(proxy) : (HttpsURLConnection)new URL(url).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            int n2 = httpURLConnection.getResponseCode();
            if (n2 != 200) {
                throw new IOException("download file failed with " + n2);
            }
            c2.d = TXHttpRequest.getHeaders((HttpsURLConnection)httpURLConnection);
            com.tencent.liteav.basic.util.d.a(httpURLConnection.getInputStream(), savePath);
            c2.a = 0;
        }
        catch (Exception exception) {
            c2.b = exception.getMessage();
            TXCLog.e(TAG, "download file failed. " + url, exception);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return c2;
    }

    public int sendHttpsRequest(Map<String, String> headers, String action, byte[] data, boolean keepAlive, long callbackFunc) {
        TXCLog.i(TAG, "sendHttpsRequest->enter action: " + action + ", data size: " + data.length);
        this.asyncPostRequest(headers, action.getBytes(), data, keepAlive, callbackFunc, this.mSock5ProxyConfig);
        return 0;
    }

    public int downloadFile(final String url, final String savePath, final long callbackFunc) {
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        Looper looper = Looper.myLooper();
        final Handler handler = looper == null ? null : new Handler(looper);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                c c2 = TXHttpRequest.downloadFileInternal(url, savePath, TXHttpRequest.this.mSock5ProxyConfig);
                TXHttpRequest.this.notifyResult(handler, c2, callbackFunc);
                executorService.shutdown();
            }
        });
        return 0;
    }

    private void notifyResult(Handler handler, final c result, final long callbackFunc) {
        if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    TXHttpRequest.this.nativeOnRecvMessage(TXHttpRequest.this.mNativeHttps, result.a, result.c, result.d, callbackFunc);
                }
            });
        } else {
            this.nativeOnRecvMessage(this.mNativeHttps, result.a, result.c, result.d, callbackFunc);
        }
    }

    public static c getHttpsPostRsp(Map<String, String> headers, String strAction, byte[] data, boolean keepAlive, d config) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        TXCLog.i(TAG, "getHttpsPostRsp->request: " + strAction);
        TXCLog.i(TAG, "getHttpsPostRsp->data: " + data.length);
        Proxy proxy = null;
        if (config != null && !TextUtils.isEmpty((CharSequence)config.a) && config.b > 0) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(config.a, config.b));
            Authenticator.setDefault(new a(config.c, config.d));
        }
        URL uRL = new URL(strAction.replace(" ", "%20"));
        HttpsURLConnection httpsURLConnection = null;
        httpsURLConnection = proxy != null ? (HttpsURLConnection)uRL.openConnection(proxy) : (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setConnectTimeout(5000);
        httpsURLConnection.setReadTimeout(5000);
        httpsURLConnection.setRequestMethod("POST");
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpsURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (keepAlive) {
            httpsURLConnection.setRequestProperty("Connection", "Keep-Alive");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.write(data);
        dataOutputStream.flush();
        dataOutputStream.close();
        int n2 = httpsURLConnection.getResponseCode();
        c c2 = new c();
        if (n2 >= 200 && n2 < 300) {
            int n3;
            InputStream inputStream = httpsURLConnection.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n3 = inputStream.read(data, 0, data.length)) != -1) {
                byteArrayOutputStream.write(data, 0, n3);
            }
            byteArrayOutputStream.flush();
            c2.d = new HashMap<String, String>();
            Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
                c2.d.put(entry.getKey(), entry.getValue().get(0));
            }
            inputStream.close();
            if (!keepAlive) {
                httpsURLConnection.disconnect();
            }
        } else {
            TXCLog.i(TAG, "getHttpsPostRsp->response code: " + n2);
            throw new Exception("response: " + n2);
        }
        c2.c = byteArrayOutputStream.toByteArray();
        c2.a = 0;
        TXCLog.i(TAG, "getHttpsPostRsp->rsp size: " + byteArrayOutputStream.size());
        return c2;
    }

    public void asyncPostRequest(Map<String, String> headers, byte[] action, byte[] data, boolean keepAlive, long callbackFunc, d config) {
        b b2 = new b(this, headers, keepAlive, callbackFunc, config);
        b2.execute((Object[])new byte[][]{action, data});
    }

    private static Map<String, String> getHeaders(HttpsURLConnection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return hashMap;
    }

    private native void nativeOnRecvMessage(long var1, int var3, byte[] var4, Map<String, String> var5, long var6);

    static class b
    extends AsyncTask<byte[], Void, c> {
        private WeakReference<TXHttpRequest> a;
        private Handler b = null;
        private Map<String, String> c;
        private boolean d = false;
        private long e = 0L;
        private d f;

        public b(TXHttpRequest tXHttpRequest, Map<String, String> map, boolean bl, long l2, d d2) {
            this.c = map;
            this.a = new WeakReference<TXHttpRequest>(tXHttpRequest);
            Looper looper = Looper.myLooper();
            this.b = looper != null ? new Handler(looper) : null;
            this.d = bl;
            this.e = l2;
            this.f = d2;
        }

        protected c a(byte[] ... byArray) {
            c c2 = new c();
            try {
                if (new String(byArray[0]).startsWith("https")) {
                    c2 = TXHttpRequest.getHttpsPostRsp(this.c, new String(byArray[0]), byArray[1], this.d, this.f);
                    c2.a = 0;
                } else {
                    c2.a = 1;
                    c2.b = "http request not support";
                }
            }
            catch (Exception exception) {
                c2.b = exception.toString();
                c2.a = 1;
                TXCLog.i(TXHttpRequest.TAG, "doInBackground Exception e=" + c2.a + "|" + c2.b);
            }
            TXCLog.i(TXHttpRequest.TAG, "TXPostRequest->result: " + c2.a + "|" + c2.b);
            return c2;
        }

        protected void a(final c c2) {
            super.onPostExecute((Object)c2);
            final TXHttpRequest tXHttpRequest = (TXHttpRequest)this.a.get();
            if (tXHttpRequest != null && tXHttpRequest.mNativeHttps != 0L) {
                if (this.b != null) {
                    this.b.post(new Runnable(){

                        @Override
                        public void run() {
                            TXCLog.i(TXHttpRequest.TAG, "TXPostRequest->recvMsg: " + c2.a + "|" + c2.b);
                            tXHttpRequest.nativeOnRecvMessage(tXHttpRequest.mNativeHttps, c2.a, c2.c, c2.d, b.this.e);
                        }
                    });
                } else {
                    TXCLog.i(TXHttpRequest.TAG, "TXPostRequest->recvMsg: " + c2.a + "|" + c2.b);
                    tXHttpRequest.nativeOnRecvMessage(tXHttpRequest.mNativeHttps, c2.a, c2.c, c2.d, this.e);
                }
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((c)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((byte[][])objectArray);
        }
    }

    static class c {
        public int a = 1;
        public String b = "";
        public byte[] c = "".getBytes();
        public Map<String, String> d;

        c() {
        }
    }

    private static class a
    extends Authenticator {
        private String a;
        private String b;

        public a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.a, this.b.toCharArray());
        }
    }

    private static class d {
        public String a = "";
        public int b = 0;
        public String c = "";
        public String d = "";

        private d() {
        }
    }
}

