/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoengine.decoder;

import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.basic.util.g;
import com.tencent.liteav.videobase.c.c;
import com.tencent.liteav.videobase.c.d;
import com.tencent.liteav.videobase.e.b;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.e;
import com.tencent.liteav.videoengine.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$1;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$10;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$11;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$12;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$13;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$14;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$2;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$3;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$4;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$5;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$6;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$7;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$8;
import com.tencent.liteav.videoengine.decoder.VideoDecodeController$$Lambda$9;
import com.tencent.liteav.videoengine.decoder.a;
import com.tencent.liteav.videoengine.decoder.h;
import com.tencent.liteav.videoengine.decoder.m;
import com.tencent.liteav.videoengine.decoder.n;
import com.tencent.liteav.videoengine.decoder.o;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;

public class VideoDecodeController
implements o {
    private static final String TAG = "VideoDecodeController";
    private static final int DECODED_FRAME_QUEUE_SIZE = 2;
    @NonNull
    private final com.tencent.liteav.videobase.f.c mReporter;
    @NonNull
    private final a mDecodeSupervisor;
    @NonNull
    private final m mStatistics;
    private g mWorkHandler;
    private VideoDecodeControllerListener mDecoderListener;
    private c mEGLCore;
    private boolean mIsStarted = false;
    private n mVideoDecoder;
    private JSONArray mMediaCodecDeviceRelatedParams;
    private boolean mIsFirstIFrameReceived = false;
    private final AtomicInteger mDecodingFrameCount = new AtomicInteger(0);
    private final e mDecodedFrameQueue = new e(2);
    private final a.d mResolutionDecoder = VideoDecodeController$$Lambda$1.lambdaFactory$();

    public VideoDecodeController(@NonNull com.tencent.liteav.videobase.f.c reporter) {
        this.mReporter = reporter;
        this.mDecodeSupervisor = new a(this.mResolutionDecoder, reporter, false, true);
        this.mStatistics = new m(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        TXCLog.i(TAG, "initialize");
        VideoDecodeController videoDecodeController = this;
        synchronized (videoDecodeController) {
            if (this.mWorkHandler != null) {
                TXCLog.w(TAG, "video decode controller is initialized");
                return;
            }
            HandlerThread handlerThread = new HandlerThread("video-decoder-controller");
            handlerThread.start();
            this.mWorkHandler = new g(handlerThread.getLooper());
        }
        this.runOnWorkThread(VideoDecodeController$$Lambda$2.lambdaFactory$(this));
    }

    public void start(VideoDecodeControllerListener listener) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$3.lambdaFactory$(this, listener));
    }

    public void decode(b frame) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$4.lambdaFactory$(this, frame));
    }

    private void decodeInternal(b frame) {
        frame.d();
        a.c c2 = this.mDecodeSupervisor.a(frame);
        switch (c2) {
            case b: {
                break;
            }
            case a: {
                this.doDecode(frame);
                break;
            }
            case d: {
                this.updateDecoderType(frame, n.a.a);
                this.doDecode(frame);
                break;
            }
            case e: {
                this.updateDecoderType(frame, n.a.b);
                this.doDecode(frame);
                break;
            }
            case c: {
                n.a a2 = this.getUsingDecoderType();
                if (a2 == null) break;
                this.updateDecoderType(frame, a2);
                this.doDecode(frame);
                break;
            }
            case f: {
                if (this.mDecoderListener == null) break;
                this.mDecoderListener.onRequestKeyFrame();
                break;
            }
            case g: {
                if (this.mDecoderListener == null) break;
                this.mDecoderListener.onDecodeFailed(null);
            }
        }
    }

    private void updateDecoderType(b frame, n.a chooseType) {
        this.stopDecoderInternal();
        g g2 = this.mWorkHandler;
        if (g2 == null) {
            return;
        }
        f f2 = this.mResolutionDecoder.decodeResolutionFromSps(frame.c(), frame.a);
        this.mVideoDecoder = chooseType == n.a.b ? new SoftwareVideoDecoder(this.mReporter) : new h(g2.getLooper(), f2, frame.c(), this.mMediaCodecDeviceRelatedParams, this.mReporter);
        this.mVideoDecoder.start(this.mEGLCore.d(), this);
        this.mDecodingFrameCount.set(0);
        TXCLog.i(TAG, "update decoder type to %s, video res: %s", new Object[]{chooseType, f2});
        this.mStatistics.a(this.mVideoDecoder.getDecoderType(), frame.c());
    }

    private void doDecode(b frame) {
        if (!this.mIsFirstIFrameReceived && frame.a()) {
            this.mIsFirstIFrameReceived = true;
            this.mReporter.a(com.tencent.liteav.videobase.f.e.Z, "VideoDecode: start decode first frame", null, new Object[0]);
            this.mReporter.a("Remote-VideoDecoder[%s]: Decode first frame [tinyID:%s]", this.hashCode(), this.mReporter.a());
        }
        this.mStatistics.a(frame.f);
        if (this.mVideoDecoder != null) {
            this.mDecodingFrameCount.incrementAndGet();
            this.mVideoDecoder.decode(frame);
        }
    }

    private n.a getUsingDecoderType() {
        return this.mVideoDecoder == null ? null : this.mVideoDecoder.getDecoderType();
    }

    public void stop() {
        this.runOnWorkThread(VideoDecodeController$$Lambda$5.lambdaFactory$(this));
    }

    private void stopDecoderInternal() {
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.stop();
            this.mVideoDecoder = null;
        }
        this.mDecodedFrameQueue.b();
    }

    public void setDecodeStrategy(DecodeStrategy decodeStrategy) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$6.lambdaFactory$(this, decodeStrategy));
    }

    public void restartDecoder() {
        this.runOnWorkThread(VideoDecodeController$$Lambda$7.lambdaFactory$(this));
    }

    public int getDecodingFrameCount() {
        return this.mDecodingFrameCount.get();
    }

    public void setMediaCodecDeviceRelatedParams(JSONArray params) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$8.lambdaFactory$(this, params));
    }

    public void setHWDecoderMaxCache(int maxCacheForHighRes, int maxCahceForLowRes) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$9.lambdaFactory$(this, maxCacheForHighRes, maxCahceForLowRes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninitialize() {
        TXCLog.i(TAG, "uninitialize");
        this.runOnWorkThread(VideoDecodeController$$Lambda$10.lambdaFactory$(this));
        VideoDecodeController videoDecodeController = this;
        synchronized (videoDecodeController) {
            if (this.mWorkHandler != null) {
                this.mWorkHandler.e();
                this.mWorkHandler = null;
            }
        }
    }

    private void runOnWorkThread(Runnable runnable) {
        g g2 = this.mWorkHandler;
        if (g2 != null && g2.getLooper().getThread().isAlive()) {
            g2.post(runnable);
        } else {
            TXCLog.w(TAG, "runnable [%s] is failed to post", runnable.getClass().getName());
        }
    }

    private boolean makeCurrentInternal() {
        try {
            this.mEGLCore.a();
            return true;
        }
        catch (d d2) {
            TXCLog.e(TAG, "make current failed.", d2);
            return false;
        }
    }

    @Override
    public void onDecodeFrame(PixelFrame pixelFrame, long dts) {
        pixelFrame.retain();
        long l2 = pixelFrame.getTimestamp();
        this.mDecodedFrameQueue.a(pixelFrame);
        Runnable runnable = VideoDecodeController$$Lambda$11.lambdaFactory$(this, l2, dts);
        g g2 = this.mWorkHandler;
        if (g2 != null && Looper.myLooper() == g2.getLooper()) {
            runnable.run();
        } else {
            this.runOnWorkThread(runnable);
        }
    }

    @Override
    public void onDecodeSEI(ByteBuffer seiBuffer) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$12.lambdaFactory$(this, seiBuffer));
    }

    @Override
    public void onDecodeFailed(com.tencent.liteav.videobase.f.e code) {
        this.runOnWorkThread(VideoDecodeController$$Lambda$13.lambdaFactory$(this));
    }

    @Override
    public void onRequestKeyFrame() {
        this.runOnWorkThread(VideoDecodeController$$Lambda$14.lambdaFactory$(this));
    }

    private static native int[] nativeDecodeResolution(boolean var0, byte[] var1);

    static /* synthetic */ void lambda$onRequestKeyFrame$13(VideoDecodeController this_) {
        if (this_.mDecoderListener != null) {
            this_.mDecoderListener.onRequestKeyFrame();
        }
    }

    static /* synthetic */ void lambda$onDecodeFailed$12(VideoDecodeController this_) {
        TXCLog.i(TAG, "on decode failed, type: %s", new Object[]{this_.getUsingDecoderType()});
        this_.mDecodeSupervisor.a();
    }

    static /* synthetic */ void lambda$onDecodeSEI$11(VideoDecodeController this_, ByteBuffer seiBuffer) {
        if (this_.mDecoderListener != null) {
            this_.mDecoderListener.onDecodeSEI(seiBuffer);
        }
    }

    static /* synthetic */ void lambda$onDecodeFrame$10(VideoDecodeController this_, long frameTimestamp, long dts) {
        this_.mDecodeSupervisor.a(frameTimestamp);
        this_.mDecodingFrameCount.decrementAndGet();
        this_.mStatistics.b();
        PixelFrame pixelFrame = this_.mDecodedFrameQueue.a();
        if (pixelFrame == null) {
            return;
        }
        if (this_.mEGLCore == null || !this_.makeCurrentInternal()) {
            pixelFrame.release();
            return;
        }
        if (this_.mDecoderListener != null) {
            this_.mDecoderListener.onDecodeFrame(pixelFrame, dts);
        }
        pixelFrame.release();
    }

    static /* synthetic */ void lambda$uninitialize$9(VideoDecodeController this_) {
        if (this_.mEGLCore == null) {
            return;
        }
        try {
            this_.mEGLCore.b();
            this_.mEGLCore.e();
        }
        catch (d d2) {
            TXCLog.e(TAG, "destroy egl core failed.", d2);
            this_.mReporter.a(com.tencent.liteav.videobase.f.e.Y, "VideoDecode: destroy EGLCore failed", "", new Object[0]);
        }
        this_.mEGLCore = null;
    }

    static /* synthetic */ void lambda$setHWDecoderMaxCache$8(VideoDecodeController this_, int maxCacheForHighRes, int maxCahceForLowRes) {
        this_.mDecodeSupervisor.a(maxCacheForHighRes, maxCahceForLowRes);
    }

    static /* synthetic */ void lambda$setMediaCodecDeviceRelatedParams$7(VideoDecodeController this_, JSONArray params) {
        this_.mMediaCodecDeviceRelatedParams = params;
        TXCLog.i(TAG, "set MediaCodec device related params to %s", params);
    }

    static /* synthetic */ void lambda$restartDecoder$6(VideoDecodeController this_) {
        this_.stopDecoderInternal();
        TXCLog.i(TAG, "restart decoder");
    }

    static /* synthetic */ void lambda$setDecodeStrategy$5(VideoDecodeController this_, DecodeStrategy decodeStrategy) {
        this_.mDecodeSupervisor.a(decodeStrategy);
    }

    static /* synthetic */ void lambda$stop$4(VideoDecodeController this_) {
        this_.mIsStarted = false;
        this_.mDecoderListener = null;
        this_.stopDecoderInternal();
        this_.mReporter.a("Remote-VideoDecoder[%s]: Stop [tinyID:%s]", this_, this_.mReporter.a());
    }

    static /* synthetic */ void lambda$decode$3(VideoDecodeController this_, b frame) {
        this_.decodeInternal(frame);
    }

    static /* synthetic */ void lambda$start$2(VideoDecodeController this_, VideoDecodeControllerListener listener) {
        if (this_.mIsStarted) {
            return;
        }
        this_.mIsStarted = true;
        this_.mDecoderListener = listener;
        this_.mDecodingFrameCount.set(0);
        this_.mDecodeSupervisor.b();
        this_.mStatistics.a();
    }

    static /* synthetic */ void lambda$initialize$1(VideoDecodeController this_) {
        this_.mEGLCore = new c();
        try {
            this_.mEGLCore.a(null, null, 128, 128);
        }
        catch (d d2) {
            TXCLog.e(TAG, "create egl core failed.", d2);
            this_.mReporter.a(com.tencent.liteav.videobase.f.e.X, "VideoDecode: create EGLCore failed", "", new Object[0]);
        }
    }

    static /* synthetic */ f lambda$new$0(boolean isH265, byte[] nalData) {
        int[] nArray = VideoDecodeController.nativeDecodeResolution(isH265, nalData);
        if (nArray == null || nArray.length != 2) {
            return new f(0, 0);
        }
        return new f(nArray[0], nArray[1]);
    }

    public static enum DecodeStrategy {
        AUTO_SWITCH,
        USE_HARDWARE_ONLY,
        USE_SOFTWARE_ONLY;

    }

    public static interface VideoDecodeControllerListener
    extends o {
    }
}

