/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.module;

import com.tencent.liteav.basic.log.TXCLog;

public class StatusBucket {
    private static final String TAG = StatusBucket.class.getName();
    private long mBucketObj = 0L;

    public StatusBucket() {
        this.mBucketObj = StatusBucket.nativeCreateStatusBucket();
    }

    public StatusBucket(long bucketOjb) {
        this.mBucketObj = bucketOjb;
    }

    public void setBooleanStatus(String id, int key, boolean value) {
        StatusBucket.nativeSetBooleanStatus(this.mBucketObj, id, key, value);
    }

    public void setIntStatus(String id, int key, int value) {
        StatusBucket.nativeSetIntStatus(this.mBucketObj, id, key, value);
    }

    public void setLongStatus(String id, int key, long value) {
        StatusBucket.nativeSetLongStatus(this.mBucketObj, id, key, value);
    }

    public boolean getBooleanStatus(String id, int key) {
        return StatusBucket.nativeGetBooleanStatus(this.mBucketObj, id, key);
    }

    public int getIntStatus(String id, int key) {
        return StatusBucket.nativeGetIntStatus(this.mBucketObj, id, key);
    }

    public long getLongStatus(String id, int key) {
        return StatusBucket.nativeGetLongStatus(this.mBucketObj, id, key);
    }

    public void merge(StatusBucket bucket) {
        StatusBucket.nativeMerge(this.mBucketObj, bucket.mBucketObj);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        long l2 = this.mBucketObj;
        this.mBucketObj = 0L;
        StatusBucket.nativeDestroyStatusBucket(l2);
    }

    public static void testStatusBucket() {
        StatusBucket statusBucket = new StatusBucket();
        StatusBucket statusBucket2 = new StatusBucket();
        statusBucket.setBooleanStatus("1", 1, true);
        statusBucket.setIntStatus("2", 2, 2);
        statusBucket.setLongStatus("3", 3, 3L);
        statusBucket2.setIntStatus("1", 4, 4);
        statusBucket2.setBooleanStatus("5", 5, true);
        statusBucket2.setLongStatus("6", 6, 6L);
        statusBucket.merge(statusBucket2);
        TXCLog.e(TAG, "test_status_bucket: id:1, key:1, value:" + statusBucket.getBooleanStatus("1", 1));
        TXCLog.e(TAG, "test_status_bucket: id:1, key:4, value:" + statusBucket.getIntStatus("1", 4));
        TXCLog.e(TAG, "test_status_bucket: id:2, key:2, value:" + statusBucket.getIntStatus("2", 2));
        TXCLog.e(TAG, "test_status_bucket: id:3, key:3, value:" + statusBucket.getLongStatus("3", 3));
        TXCLog.e(TAG, "test_status_bucket: id:5, key:5, value:" + statusBucket.getBooleanStatus("5", 5));
        TXCLog.e(TAG, "test_status_bucket: id:6, key:6, value:" + statusBucket.getLongStatus("6", 6));
    }

    private static native long nativeCreateStatusBucket();

    private static native void nativeDestroyStatusBucket(long var0);

    private static native void nativeSetBooleanStatus(long var0, String var2, int var3, boolean var4);

    private static native void nativeSetIntStatus(long var0, String var2, int var3, int var4);

    private static native void nativeSetLongStatus(long var0, String var2, int var3, long var4);

    private static native boolean nativeGetBooleanStatus(long var0, String var2, int var3);

    private static native int nativeGetIntStatus(long var0, String var2, int var3);

    private static native long nativeGetLongStatus(long var0, String var2, int var3);

    private static native void nativeMerge(long var0, long var2);
}

