/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.annotation.SuppressLint;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import com.tencent.liteav.basic.a.a;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.opengl.TXCOpenGlUtils;
import com.tencent.liteav.basic.opengl.e;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.beauty.b.k;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.m;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import java.nio.ByteBuffer;

public class TRTCVideoPreprocessListenerAdapter
implements m {
    private static final String TAG = "TRTCVideoPreprocessListenerAdapter";
    private final f mLastFrameSize = new f(0, 0);
    private final TRTCCloudDef.TRTCVideoFrame mYUVInputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final TRTCCloudDef.TRTCVideoFrame mYUVOutputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final TRTCCloudDef.TRTCVideoFrame mShadowInputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final TRTCCloudDef.TRTCVideoFrame mShadowOutputFrame = new TRTCCloudDef.TRTCVideoFrame();
    private final a mDelayQueue = new a();
    private int mPixelFormat;
    private int mBufferType;
    private TRTCCloudListener.TRTCVideoFrameListener mListener;
    private boolean mHasNotifiedGLContextCreated = false;
    private o mRGBAToYUVFilter;
    private k mYUVToRGBAFilter;
    private int mFrameBufferId = -1;

    public void setListener(final int pixelFormat, final int bufferType, final TRTCCloudListener.TRTCVideoFrameListener listener) {
        this.mDelayQueue.a(new Runnable(){

            @Override
            public void run() {
                TRTCVideoPreprocessListenerAdapter.this.setListenerInternal(pixelFormat, bufferType, listener);
            }
        });
    }

    private void setListenerInternal(int pixelFormat, int bufferType, TRTCCloudListener.TRTCVideoFrameListener listener) {
        this.notifyGLContextDestroy();
        this.mPixelFormat = pixelFormat;
        this.mBufferType = bufferType;
        this.mListener = listener;
        this.notifyGLContextCreated();
    }

    @Override
    public void onGLContextCreated() {
        this.mDelayQueue.a();
        this.notifyGLContextCreated();
    }

    @SuppressLint(value={"NewApi"})
    private static void initVideoFrame(TRTCCloudDef.TRTCVideoFrame videoFrame, int width, int height, int pixelFormat, int bufferType) {
        videoFrame.width = width;
        videoFrame.height = height;
        videoFrame.pixelFormat = pixelFormat;
        videoFrame.bufferType = bufferType;
        if (pixelFormat == 2 && videoFrame.texture == null) {
            videoFrame.texture = new TRTCCloudDef.TRTCTexture();
            Object object = TXCOpenGlUtils.e();
            if (object instanceof EGLContext) {
                videoFrame.texture.eglContext14 = (EGLContext)object;
            } else {
                videoFrame.texture.eglContext10 = (javax.microedition.khronos.egl.EGLContext)object;
            }
        } else if (pixelFormat == 1 || pixelFormat == 4) {
            if (bufferType == 2 && videoFrame.data == null) {
                videoFrame.data = new byte[width * height * 3 / 2];
            } else if (bufferType == 1 && videoFrame.buffer == null) {
                videoFrame.buffer = ByteBuffer.allocateDirect(width * height * 3 / 2);
            }
        }
    }

    private void shadowCopyVideoFrame(TRTCCloudDef.TRTCVideoFrame srcFrame, TRTCCloudDef.TRTCVideoFrame destFrame) {
        destFrame.width = srcFrame.width;
        destFrame.height = srcFrame.height;
        destFrame.pixelFormat = srcFrame.pixelFormat;
        destFrame.bufferType = srcFrame.bufferType;
        destFrame.texture = srcFrame.texture;
        destFrame.data = srcFrame.data;
        destFrame.buffer = srcFrame.buffer;
    }

    @Override
    public int onProcessVideoFrame(int inTextureId, int width, int height, int outTextureId) {
        this.mDelayQueue.a();
        if (this.mListener == null) {
            return inTextureId;
        }
        if (this.mLastFrameSize.a != width || this.mLastFrameSize.b != height) {
            this.releaseOpenGLResources();
            this.mYUVInputFrame.data = null;
            this.mYUVInputFrame.buffer = null;
            this.mYUVOutputFrame.data = null;
            this.mYUVOutputFrame.buffer = null;
            this.mLastFrameSize.a = width;
            this.mLastFrameSize.b = height;
        }
        TRTCVideoPreprocessListenerAdapter.initVideoFrame(this.mYUVInputFrame, width, height, this.mPixelFormat, this.mBufferType);
        TRTCVideoPreprocessListenerAdapter.initVideoFrame(this.mYUVOutputFrame, width, height, this.mPixelFormat, this.mBufferType);
        if (this.mPixelFormat == 2) {
            this.mYUVInputFrame.texture.textureId = inTextureId;
            this.mYUVOutputFrame.texture.textureId = outTextureId;
            this.mListener.onProcessVideoFrame(this.mYUVInputFrame, this.mYUVOutputFrame);
            return this.mYUVOutputFrame.texture.textureId;
        }
        if (this.mFrameBufferId == -1) {
            this.mFrameBufferId = TXCOpenGlUtils.d();
        }
        this.convertTextureToYUV(inTextureId, this.mYUVInputFrame);
        this.shadowCopyVideoFrame(this.mYUVInputFrame, this.mShadowInputFrame);
        this.shadowCopyVideoFrame(this.mYUVOutputFrame, this.mShadowOutputFrame);
        this.mListener.onProcessVideoFrame(this.mShadowInputFrame, this.mShadowOutputFrame);
        this.convertYUVToTexture(this.mShadowOutputFrame, outTextureId);
        return outTextureId;
    }

    private void convertYUVToTexture(TRTCCloudDef.TRTCVideoFrame videoFrame, int textureId) {
        if (videoFrame.data == null && videoFrame.buffer == null) {
            return;
        }
        int n2 = videoFrame.width;
        int n3 = videoFrame.height;
        k k2 = this.getYUVToRGBAFilter(videoFrame.pixelFormat, n2, n3);
        TXCOpenGlUtils.a(textureId, this.mFrameBufferId);
        GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
        if (videoFrame.bufferType == 2) {
            k2.a(videoFrame.data);
        } else if (videoFrame.bufferType == 1) {
            k2.a(videoFrame.buffer);
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
        k2.a(-1, this.mFrameBufferId, textureId);
        TXCOpenGlUtils.d(this.mFrameBufferId);
    }

    private void convertTextureToYUV(int textureId, TRTCCloudDef.TRTCVideoFrame videoFrame) {
        int n2 = videoFrame.width;
        int n3 = videoFrame.height;
        o o2 = this.getRGBAToYUVFilter(videoFrame.pixelFormat, n2, n3);
        GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
        o2.a(n2, n3);
        int n4 = o2.b(textureId);
        TXCOpenGlUtils.a(n4, this.mFrameBufferId);
        e.a a2 = e.a.a;
        if (videoFrame.pixelFormat == 1) {
            a2 = e.a.b;
        } else if (videoFrame.pixelFormat == 4) {
            a2 = e.a.c;
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
        if (videoFrame.bufferType == 1) {
            TXCOpenGlUtils.a(a2, n2, n3, videoFrame.buffer);
        } else {
            TXCOpenGlUtils.a(a2, n2, n3, videoFrame.data);
        }
        TXCOpenGlUtils.d(this.mFrameBufferId);
    }

    private o getRGBAToYUVFilter(int pixelFormat, int width, int height) {
        if (this.mRGBAToYUVFilter == null) {
            int n2 = pixelFormat == 1 ? 1 : 3;
            this.mRGBAToYUVFilter = new o(n2);
            this.mRGBAToYUVFilter.a(true);
            if (!this.mRGBAToYUVFilter.a()) {
                TXCLog.e(TAG, "init RGBA to YUV filter failed.");
            }
            this.mRGBAToYUVFilter.a(width, height);
        }
        return this.mRGBAToYUVFilter;
    }

    private k getYUVToRGBAFilter(int pixelFormat, int width, int height) {
        if (this.mYUVToRGBAFilter == null) {
            int n2 = pixelFormat == 1 ? 1 : 3;
            this.mYUVToRGBAFilter = new k(n2);
            if (!this.mYUVToRGBAFilter.a()) {
                TXCLog.e(TAG, "init YUV to RGBA failed.");
            }
            this.mYUVToRGBAFilter.a(width, height);
        }
        return this.mYUVToRGBAFilter;
    }

    public void onDetectFacePoints(float[] points) {
    }

    @Override
    public void onGLContextReadyToDestory() {
        this.mDelayQueue.a();
        this.notifyGLContextDestroy();
        this.releaseOpenGLResources();
    }

    private void notifyGLContextCreated() {
        if (this.mListener != null && !this.mHasNotifiedGLContextCreated) {
            this.mListener.onGLContextCreated();
            this.mHasNotifiedGLContextCreated = true;
        }
    }

    private void notifyGLContextDestroy() {
        if (this.mListener != null && this.mHasNotifiedGLContextCreated) {
            this.mListener.onGLContextDestory();
            this.mHasNotifiedGLContextCreated = false;
        }
    }

    private void releaseOpenGLResources() {
        if (this.mRGBAToYUVFilter != null) {
            this.mRGBAToYUVFilter.d();
            this.mRGBAToYUVFilter = null;
        }
        if (this.mYUVToRGBAFilter != null) {
            this.mYUVToRGBAFilter.d();
            this.mYUVToRGBAFilter = null;
        }
        TXCOpenGlUtils.b(this.mFrameBufferId);
        this.mFrameBufferId = -1;
    }
}

