/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.http;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@JNINamespace(value="liteav")
public class HttpClientAndroid {
    private static final String TAG = "HttpClientAndroid";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final int ERROR_CODE_INVALID_REQUEST = 0;
    private static final int READ_STREAM_SIZE = 1388;
    private final ConcurrentHashMap<Long, d> mRunningRequestMap = new ConcurrentHashMap();
    private final Handler mHttpHandler;
    private final b mHttpConfig;
    private String mLastRequestURL;
    private HttpURLConnection mConnection;
    private final Object mLocker = new Object();
    private long mNativeHttpClientAndroidJni;
    private volatile c mInternalState = c.a;

    @CalledByNative
    public HttpClientAndroid(int connectTimeoutMs, int readTimeoutMs, int writeTimeoutMs, boolean isKeepAlive, int socks5Port, String socks5Ip, String socks5User, String socks5Password, long nativeHttpClientAndroidJni) {
        this.mHttpConfig = new b(connectTimeoutMs, readTimeoutMs, writeTimeoutMs, isKeepAlive, socks5Port, socks5Ip, socks5User, socks5Password);
        this.mNativeHttpClientAndroidJni = nativeHttpClientAndroidJni;
        HandlerThread handlerThread = new HandlerThread("HttpClient_" + this.hashCode());
        handlerThread.start();
        this.mHttpHandler = new Handler(handlerThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public long send(long requestId, String url, String method, byte[] body, Map<String, String> headers, boolean isRepeat) {
        d d2;
        if (!this.checkNativeValid()) {
            LiteavLog.e(TAG, "Send request failed. Invalid native handle.");
            return 0L;
        }
        d d3 = d2 = new d(url, method, body, headers);
        if (!(!TextUtils.isEmpty((CharSequence)d2.b) && (d3.b.startsWith(HTTP_PREFIX) || d3.b.startsWith(HTTPS_PREFIX)))) {
            LiteavLog.e(TAG, "Send request failed. Invalid request url(" + d2.b + ").");
            return 0L;
        }
        if (!(!TextUtils.isEmpty((CharSequence)d2.c()))) {
            LiteavLog.e(TAG, "Send request failed. Request method(" + d2.c + ") is not supported.");
            return 0L;
        }
        Object object = this.mLocker;
        synchronized (object) {
            boolean bl = false;
            if (this.mInternalState == c.a) {
                this.mInternalState = isRepeat ? c.b : c.c;
                bl = true;
            } else if (this.mInternalState == c.c) {
                bl = true;
            }
            if (bl) {
                d2.a = requestId;
                this.mRunningRequestMap.put(requestId, d2);
                this.mHttpHandler.post(com.tencent.liteav.base.http.a.a(this, d2));
                return d2.a;
            }
            LiteavLog.e(TAG, "Send request failed. Invalid state:" + (Object)((Object)this.mInternalState));
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void cancel(long requestId) {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "Cancel request failed. Invalid native handle.");
                return;
            }
            if (this.mRunningRequestMap.size() == 0) {
                return;
            }
            d d2 = this.mRunningRequestMap.remove(requestId);
            LiteavLog.i(TAG, "Cancel request. request:".concat(String.valueOf(d2)));
            if (this.mRunningRequestMap.size() == 0) {
                this.mInternalState = c.a;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void cancelAll() {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "Cancel all request failed. Invalid native handle.");
                return;
            }
            if (this.mInternalState == c.a) {
                return;
            }
            this.mInternalState = c.a;
            LiteavLog.i(TAG, "Cancel all. size:" + this.mRunningRequestMap.size());
            this.mRunningRequestMap.clear();
            this.mHttpHandler.post(com.tencent.liteav.base.http.b.a(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void destroy() {
        Object object = this.mLocker;
        synchronized (object) {
            this.mRunningRequestMap.clear();
            this.mNativeHttpClientAndroidJni = -1L;
            LiteavLog.i(TAG, "Destroy http client.");
            this.mHttpHandler.post(com.tencent.liteav.base.http.c.a(this));
            return;
        }
    }

    private boolean checkRequestValid(long requestId) {
        return this.mRunningRequestMap.containsKey(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNativeValid() {
        Object object = this.mLocker;
        synchronized (object) {
            return this.mNativeHttpClientAndroidJni != -1L;
        }
    }

    private HttpURLConnection createConnection(d request) {
        try {
            Proxy proxy = null;
            if (TextUtils.isEmpty((CharSequence)this.mHttpConfig.f) && this.mHttpConfig.e > 0) {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.mHttpConfig.f, this.mHttpConfig.e));
                Authenticator.setDefault(new a(this.mHttpConfig.g, this.mHttpConfig.h));
            }
            URL uRL = new URL(request.b.replace(" ", "%20"));
            HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)uRL.openConnection(proxy) : (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setInstanceFollowRedirects(true);
            httpURLConnection.setConnectTimeout(this.mHttpConfig.a);
            httpURLConnection.setReadTimeout(this.mHttpConfig.b);
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            httpURLConnection.setRequestMethod(request.c());
            if (request.b()) {
                httpURLConnection.setDoOutput(true);
            }
            if (this.mHttpConfig.d) {
                httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            }
            if (request.e != null && !request.e.isEmpty()) {
                for (Map.Entry<String, String> entry : request.e.entrySet()) {
                    httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            return httpURLConnection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LiteavLog.e(TAG, "Create connection failed. ");
            return null;
        }
    }

    private void closeConnectionSafely(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanById(long requestId) {
        this.mRunningRequestMap.remove(requestId);
        if (this.mRunningRequestMap.size() == 0) {
            Object object = this.mLocker;
            synchronized (object) {
                this.mInternalState = c.a;
            }
        }
        if (!this.mHttpConfig.d) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this.mConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(d request) {
        Map<String, String> map;
        int n2;
        String string;
        int n3;
        boolean bl;
        if (!this.checkRequestValid(request.a)) {
            LiteavLog.w(TAG, "Do send failed. ignore request when cancelled. request:".concat(String.valueOf(request)));
            return;
        }
        Object object = this.mLocker;
        synchronized (object) {
            bl = this.mInternalState == c.c;
        }
        if (bl && this.mConnection != null && !request.b.equals(this.mLastRequestURL)) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this.mConnection = null;
        }
        this.mLastRequestURL = request.b;
        this.mConnection = this.createConnection(request);
        if (this.mConnection == null) {
            LiteavLog.e(TAG, "Do send failed. Fail to create http connection.");
            this.doOnCallback(f.b, request.a, null);
            this.doCleanById(request.a);
            return;
        }
        if (request.b() && request.a()) {
            object = null;
            try {
                object = this.mConnection.getOutputStream();
                ((OutputStream)object).write(request.d);
                ((OutputStream)object).flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LiteavLog.w(TAG, "Do send body failed.");
                try {
                    if (object != null) {
                        ((OutputStream)object).close();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        try {
            n3 = this.mConnection.getResponseCode();
            HttpClientAndroid httpClientAndroid = this;
            string = httpClientAndroid.parseHostAddress(httpClientAndroid.mConnection.getURL().getHost());
            n2 = this.mConnection.getURL().getPort();
            HttpClientAndroid httpClientAndroid2 = this;
            map = httpClientAndroid2.getResponseHeaders(httpClientAndroid2.mConnection.getHeaderFields());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LiteavLog.e(TAG, "Do send failed. Catch error.");
            this.doOnCallback(f.b, request.a, null);
            this.doCleanById(request.a);
            return;
        }
        if (!this.checkRequestValid(request.a)) {
            LiteavLog.w(TAG, "Do send failed. Invalid request, abort request.");
            return;
        }
        this.doReadData(request.a, n3, string, n2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadData(long requestId, int statusCode, String ip, int port, Map<String, String> headers) {
        boolean bl;
        InputStream inputStream;
        if (!this.checkRequestValid(requestId)) {
            LiteavLog.w(TAG, "Do read data failed. Invalid request id. id:".concat(String.valueOf(requestId)));
            return;
        }
        e e2 = new e();
        new e().d = ip;
        e2.f = port;
        e2.a = statusCode;
        e2.e = headers;
        try {
            inputStream = this.mConnection.getInputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LiteavLog.e(TAG, "Do read data failed. Fail to get InputStream.");
            this.doOnCallback(f.b, requestId, e2);
            this.doCleanById(requestId);
            return;
        }
        Object object = this.mLocker;
        synchronized (object) {
            bl = this.mInternalState == c.c;
        }
        if (bl) {
            int n2;
            boolean bl2;
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[1388];
            do {
                try {
                    n2 = inputStream.read(byArray);
                    if (n2 > 0) {
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    }
                    bl2 = n2 > 0 && this.checkRequestValid(requestId);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    LiteavLog.e(TAG, "Do read data failed. Catch error when reading.");
                    this.doOnCallback(f.b, requestId, e2);
                    this.doCleanById(requestId);
                    return;
                }
            } while (bl2);
            n2 = ((ByteArrayOutputStream)object).size();
            if (n2 > 0) {
                e2.b = ByteBuffer.allocateDirect(n2);
                e2.b.put(((ByteArrayOutputStream)object).toByteArray(), 0, n2);
                e2.c = n2;
            }
        } else {
            int n3;
            object = new byte[1388];
            try {
                n3 = inputStream.read((byte[])object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LiteavLog.e(TAG, "Do read data failed. Catch error when reading.");
                this.doOnCallback(f.b, requestId, e2);
                this.doCleanById(requestId);
                return;
            }
            if (n3 > 0) {
                e2.b = ByteBuffer.allocateDirect(n3);
                e2.b.put((byte[])object, 0, n3);
                e2.c = n3;
            }
        }
        if (e2.c == 0 && !bl) {
            LiteavLog.w(TAG, "Do read data failed. Rsp size is 0.");
            this.doOnCallback(f.c, requestId, e2);
            this.doCleanById(requestId);
            return;
        }
        if (bl) {
            this.doOnCallback(f.c, requestId, e2);
            this.doCleanById(requestId);
            return;
        }
        this.doOnCallback(f.a, requestId, e2);
        this.mHttpHandler.post(com.tencent.liteav.base.http.d.a(this, requestId, statusCode));
    }

    private String parseHostAddress(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "Parse host error. host:".concat(String.valueOf(host)));
            return "";
        }
    }

    private Map<String, String> getResponseHeaders(Map<String, List<String>> headerFields) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnCallback(f state, long requestId, e response) {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.checkNativeValid() && this.checkRequestValid(requestId)) {
                boolean bl = c.b == this.mInternalState;
                int n2 = response != null ? response.a : 0;
                ByteBuffer byteBuffer = response != null ? response.b : null;
                int n3 = response != null ? response.c : 0;
                String string = response != null ? response.d : null;
                int n4 = response != null ? response.f : 0;
                Map<String, String> map = response != null ? response.e : null;
                HttpClientAndroid.nativeOnCallback(this.mNativeHttpClientAndroidJni, bl, state.nativeValue, requestId, n2, n4, byteBuffer, string, map, n3);
            }
            return;
        }
    }

    private static native void nativeOnCallback(long var0, boolean var2, int var3, long var4, int var6, int var7, ByteBuffer var8, String var9, Map var10, int var11);

    @CalledByNative
    public static String[] getMapKeys(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return new String[0];
        }
        Set<String> set = map.keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    @CalledByNative
    public static String[] getMapValue(Map<String, String> map, String[] keys) {
        if (map == null || map.isEmpty() || keys == null || keys.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[keys.length];
        for (int i2 = 0; i2 < keys.length; ++i2) {
            stringArray[i2] = map.get(keys[i2]);
        }
        return stringArray;
    }

    @CalledByNative
    public static HashMap getJavaHashMap(String[] keys, String[] values) {
        if (keys == null || keys.length == 0 || values == null || values.length == 0) {
            return new HashMap();
        }
        if (keys.length != values.length) {
            LiteavLog.w(TAG, "Invalid parameter, keys and values do not match.");
            return new HashMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            hashMap.put(keys[i2], values[i2]);
        }
        return hashMap;
    }

    static /* synthetic */ void lambda$doReadData$3(HttpClientAndroid this_, long requestId, int statusCode) {
        this_.doReadData(requestId, statusCode, null, 0, null);
    }

    static /* synthetic */ void lambda$destroy$2(HttpClientAndroid this_) {
        if (this_.mConnection != null) {
            HttpClientAndroid httpClientAndroid = this_;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this_.mConnection = null;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            this_.mHttpHandler.getLooper().quitSafely();
        } else {
            this_.mHttpHandler.getLooper().quit();
        }
        LiteavLog.i(TAG, "Quit looper finish.");
    }

    static /* synthetic */ void lambda$cancelAll$1(HttpClientAndroid this_) {
        if (!this_.mHttpConfig.d) {
            HttpClientAndroid httpClientAndroid = this_;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this_.mConnection = null;
        }
        LiteavLog.i(TAG, "Cancel all finish.");
    }

    static /* synthetic */ void lambda$send$0(HttpClientAndroid this_, d request) {
        this_.doRequest(request);
    }

    static final class a
    extends Authenticator {
        String a;
        String b;

        a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        protected final PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.a, this.b.toCharArray());
        }
    }

    static enum c {
        a,
        b,
        c;

    }

    public static enum f {
        a(0),
        b(1),
        c(2);

        int nativeValue;

        private f(int n3) {
            this.nativeValue = n3;
        }
    }

    public static final class e {
        int a = 0;
        ByteBuffer b;
        int c = 0;
        String d = "";
        Map<String, String> e;
        int f = 0;
    }

    public static final class d {
        long a;
        String b;
        String c;
        byte[] d;
        Map<String, String> e;

        d(String string, String string2, byte[] byArray, Map<String, String> map) {
            this.b = string;
            this.c = string2;
            this.d = byArray;
            this.e = map;
        }

        final boolean a() {
            return this.d != null && this.d.length > 0;
        }

        final boolean b() {
            return HttpClientAndroid.METHOD_POST.equals(this.c());
        }

        final String c() {
            if (TextUtils.isEmpty((CharSequence)this.c)) {
                return "";
            }
            if (HttpClientAndroid.METHOD_POST.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_POST;
            }
            if (HttpClientAndroid.METHOD_GET.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_GET;
            }
            return "";
        }

        public final String toString() {
            return "Request{requestId=" + this.a + ", url='" + this.b + '\'' + ", method='" + this.c + '\'' + ", body.size=" + (this.a() ? this.d.length : 0) + ", headers=" + this.e + '}';
        }
    }

    public static final class b {
        int a;
        int b;
        int c;
        boolean d;
        int e;
        String f;
        String g;
        String h;

        b(int n2, int n3, int n4, boolean bl, int n5, String string, String string2, String string3) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = bl;
            this.e = n5;
            this.f = string;
            this.g = string2;
            this.h = string3;
        }
    }
}

