/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.view.Surface;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.live.a;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ITXLivePlayListener;
import com.tencent.rtmp.TXLivePlayConfig;
import com.tencent.rtmp.TXLivePlayer;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.TXRecordCommon;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="liteav")
public class TXLivePlayerJni
implements com.tencent.rtmp.a,
TXCloudVideoView.b {
    private static final String TAG = "TXLivePlayerJni";
    protected long mNativeTXLivePlayerJni = 0L;
    private ITXLivePlayListener mListener;
    private TXLivePlayer.ITXAudioVolumeEvaluationListener mAudioVolumeEvaluationListener;
    private TXLivePlayer.ITXAudioRawDataListener mAudioRawDataListener;
    private TXLivePlayer.ITXSnapshotListener mSnapshotListener;
    private TXRecordCommon.ITXVideoRecordListener mVideoRecordListener;
    private TXLivePlayer.ITXVideoRawDataListener mVideoRawDataListener;
    private TXLivePlayer.ITXLivePlayVideoRenderListener mVideoRenderListener;
    private Surface mSurface;
    private int mSurfaceWidth = -1;
    private int mSurfaceHeight = -1;
    private DisplayTarget mDisplayTarget;
    private TXLivePlayConfig mConfig;
    private Integer mRenderMode;
    private Integer mRenderRotate;
    private Boolean mEnableHardwareDecoder;
    private Integer mVolume;
    private Integer mAudioRoute;
    private Integer mVolumeIntervalMs;
    private Boolean mIsAudioMuted;
    private Boolean mShowDebugView;
    private Integer mAESMode;
    private String mAESURL;
    private String mAESKey;
    private String mAESIV;

    public TXLivePlayerJni(Context context) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
    }

    @CalledByNative
    public static String[] getMapKeys(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        int n2 = 0;
        for (String string : map.keySet()) {
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    @CalledByNative
    public static String[] getMapValues(Map<String, String> map, String[] keys) {
        String[] stringArray = new String[map.size()];
        int n2 = 0;
        String[] stringArray2 = keys;
        int n3 = keys.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = stringArray2[i2];
            stringArray[n2++] = map.get(string);
        }
        return stringArray;
    }

    @CalledByNative
    public static TXLivePlayerJni weakToStrongReference(WeakReference<TXLivePlayerJni> weakReference) {
        return (TXLivePlayerJni)weakReference.get();
    }

    private static native long nativeCreate(WeakReference<TXLivePlayerJni> var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeSetConfig(long var0, float var2, float var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, boolean var10, String var11, Map var12);

    private static native void nativeSetPlayerView(long var0, DisplayTarget var2);

    private static native void nativeStartPlay(long var0, String var2, int var3);

    private static native void nativeStopPlay(long var0, boolean var2);

    private static native boolean nativeIsPlaying(long var0);

    private static native void nativePause(long var0);

    private static native void nativeResume(long var0);

    private static native long nativeGetCurrentRenderPts(long var0);

    private static native void nativeSetRenderMode(long var0, int var2);

    private static native void nativeSetRenderRotation(long var0, int var2);

    private static native void nativeEnableHardwareDecode(long var0, boolean var2);

    private static native void nativeSetMute(long var0, boolean var2);

    private static native void nativeSetVolume(long var0, int var2);

    private static native void nativeSetAudioRoute(long var0, int var2);

    private static native int nativeSwitchStream(long var0, String var2);

    private static native void nativeEnableAudioVolumeEvaluation(long var0, int var2);

    private static native void nativeSnapshot(long var0);

    private static native void nativeEnableCustomRenderTexture(long var0, boolean var2);

    private static native void nativeEnableCustomRenderI420(long var0, boolean var2);

    private static native void nativeEnableCustomAudioProcess(long var0, boolean var2);

    private static native void nativeShowDebugView(long var0, boolean var2);

    private static native void nativeSetAESCodecParams(long var0, String var2, int var3, String var4, String var5);

    private static native void nativeStartRecord(long var0, int var2, String var3);

    private static native void nativeStopRecord(long var0);

    private boolean isNativeValid() {
        return this.mNativeTXLivePlayerJni != 0L;
    }

    @Override
    public void setPlayListener(ITXLivePlayListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setAudioVolumeEvaluationListener(TXLivePlayer.ITXAudioVolumeEvaluationListener listener) {
        this.mAudioVolumeEvaluationListener = listener;
    }

    @Override
    public void setVideoRecordListener(TXRecordCommon.ITXVideoRecordListener listener) {
        this.mVideoRecordListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startRecord(int recordType) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                String string = TXLivePlayerJni.genFilePath(ContextUtils.getApplicationContext(), ".mp4");
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return -1;
                }
                TXLivePlayerJni.nativeStartRecord(this.mNativeTXLivePlayerJni, recordType, string);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopRecord() {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeStopRecord(this.mNativeTXLivePlayerJni);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVideoRawDataListener(TXLivePlayer.ITXVideoRawDataListener listener) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mVideoRawDataListener = listener;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeEnableCustomRenderI420(this.mNativeTXLivePlayerJni, listener != null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setVideoRenderListener(TXLivePlayer.ITXLivePlayVideoRenderListener listener, Object glContext) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mVideoRenderListener = listener;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeEnableCustomRenderTexture(this.mNativeTXLivePlayerJni, listener != null);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioRawDataListener(TXLivePlayer.ITXAudioRawDataListener listener) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mAudioRawDataListener = listener;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeEnableCustomAudioProcess(this.mNativeTXLivePlayerJni, listener != null);
            }
            return;
        }
    }

    @Override
    public int prepareLiveSeek(String domain, int bizid) {
        return 0;
    }

    @Override
    public void seek(int time) {
    }

    @Override
    public int resumeLive() {
        return 0;
    }

    @Override
    public void setAutoPlay(boolean autoPlay) {
    }

    @Override
    public void setRate(float rate) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showDebugView(boolean isShow) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mShowDebugView = isShow;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeShowDebugView(this.mNativeTXLivePlayerJni, isShow);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlayerView(TXCloudVideoView view) {
        if (view != null) {
            a.a(view, new WeakReference<TXCloudVideoView.b>(this));
            this.showDebugView(a.a(view));
        }
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mDisplayTarget = view != null ? new DisplayTarget(view) : null;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetPlayerView(this.mNativeTXLivePlayerJni, this.mDisplayTarget);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSurface(Surface surface) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mSurface = surface;
            this.mDisplayTarget = surface != null ? new DisplayTarget(surface, this.mSurfaceWidth, this.mSurfaceHeight) : null;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetPlayerView(this.mNativeTXLivePlayerJni, this.mDisplayTarget);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSurfaceSize(int width, int height) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (width < 0 || height < 0) {
                return;
            }
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.mDisplayTarget = this.mSurface != null ? new DisplayTarget(this.mSurface, this.mSurfaceWidth, this.mSurfaceHeight) : null;
            if (this.isNativeValid() && this.mDisplayTarget != null) {
                TXLivePlayerJni.nativeSetPlayerView(this.mNativeTXLivePlayerJni, this.mDisplayTarget);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfig(TXLivePlayConfig config) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (config == null) {
                return;
            }
            this.mConfig = config;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetConfig(this.mNativeTXLivePlayerJni, this.mConfig.getCacheTime(), this.mConfig.getMaxAutoAdjustCacheTime(), this.mConfig.getMinAutoAdjustCacheTime(), this.mConfig.getVideoBlockThreshold(), this.mConfig.getConnectRetryCount(), this.mConfig.getConnectRetryInterval(), this.mConfig.isAutoAdjustCacheTime(), this.mConfig.isEnableMessage(), this.mConfig.isEnableMetaData(), this.mConfig.getFlvSessionKey(), this.mConfig.getHeaders());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startPlay(String playUrl, int playType) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (!this.isNativeValid()) {
                this.mNativeTXLivePlayerJni = TXLivePlayerJni.nativeCreate(new WeakReference<TXLivePlayerJni>(this));
                TXLivePlayerJni.nativeSetPlayerView(this.mNativeTXLivePlayerJni, this.mDisplayTarget);
                if (this.mConfig != null) {
                    TXLivePlayerJni.nativeSetConfig(this.mNativeTXLivePlayerJni, this.mConfig.getCacheTime(), this.mConfig.getMaxAutoAdjustCacheTime(), this.mConfig.getMinAutoAdjustCacheTime(), this.mConfig.getVideoBlockThreshold(), this.mConfig.getConnectRetryCount(), this.mConfig.getConnectRetryInterval(), this.mConfig.isAutoAdjustCacheTime(), this.mConfig.isEnableMessage(), this.mConfig.isEnableMetaData(), this.mConfig.getFlvSessionKey(), this.mConfig.getHeaders());
                }
                if (this.mVideoRenderListener != null) {
                    TXLivePlayerJni.nativeEnableCustomRenderTexture(this.mNativeTXLivePlayerJni, true);
                } else if (this.mVideoRawDataListener != null) {
                    TXLivePlayerJni.nativeEnableCustomRenderI420(this.mNativeTXLivePlayerJni, true);
                } else {
                    TXLivePlayerJni.nativeEnableCustomRenderTexture(this.mNativeTXLivePlayerJni, false);
                    TXLivePlayerJni.nativeEnableCustomRenderI420(this.mNativeTXLivePlayerJni, false);
                }
                TXLivePlayerJni.nativeEnableCustomAudioProcess(this.mNativeTXLivePlayerJni, this.mAudioRawDataListener != null);
                if (this.mRenderMode != null) {
                    TXLivePlayerJni.nativeSetRenderMode(this.mNativeTXLivePlayerJni, this.mRenderMode);
                }
                if (this.mRenderRotate != null) {
                    TXLivePlayerJni.nativeSetRenderRotation(this.mNativeTXLivePlayerJni, this.mRenderRotate);
                }
                if (this.mEnableHardwareDecoder != null) {
                    TXLivePlayerJni.nativeEnableHardwareDecode(this.mNativeTXLivePlayerJni, this.mEnableHardwareDecoder);
                }
                if (this.mVolume != null) {
                    TXLivePlayerJni.nativeSetVolume(this.mNativeTXLivePlayerJni, this.mVolume);
                }
                if (this.mAudioRoute != null) {
                    TXLivePlayerJni.nativeSetAudioRoute(this.mNativeTXLivePlayerJni, this.mAudioRoute);
                }
                if (this.mVolumeIntervalMs != null) {
                    TXLivePlayerJni.nativeEnableAudioVolumeEvaluation(this.mNativeTXLivePlayerJni, this.mVolumeIntervalMs);
                }
                if (this.mIsAudioMuted != null) {
                    TXLivePlayerJni.nativeSetMute(this.mNativeTXLivePlayerJni, this.mIsAudioMuted);
                }
                if (this.mShowDebugView != null) {
                    TXLivePlayerJni.nativeShowDebugView(this.mNativeTXLivePlayerJni, this.mShowDebugView);
                }
                if (this.mAESKey != null && this.mAESURL != null && this.mAESMode != null && this.mAESIV != null) {
                    TXLivePlayerJni.nativeSetAESCodecParams(this.mNativeTXLivePlayerJni, this.mAESURL, this.mAESMode, this.mAESKey, this.mAESIV);
                }
            }
            TXLivePlayerJni.nativeStartPlay(this.mNativeTXLivePlayerJni, playUrl, playType);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopPlay(boolean isNeedClearLastImg) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeStopPlay(this.mNativeTXLivePlayerJni, isNeedClearLastImg);
                TXLivePlayerJni.nativeDestroy(this.mNativeTXLivePlayerJni);
                this.mNativeTXLivePlayerJni = 0L;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPlaying() {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                return TXLivePlayerJni.nativeIsPlaying(this.mNativeTXLivePlayerJni);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativePause(this.mNativeTXLivePlayerJni);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeResume(this.mNativeTXLivePlayerJni);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentRenderPts() {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                return TXLivePlayerJni.nativeGetCurrentRenderPts(this.mNativeTXLivePlayerJni);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRenderMode(int mode) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mRenderMode = mode;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetRenderMode(this.mNativeTXLivePlayerJni, mode);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRenderRotation(int rotation) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mRenderRotate = rotation;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetRenderRotation(this.mNativeTXLivePlayerJni, rotation);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enableHardwareDecode(boolean enable) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mEnableHardwareDecoder = enable;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeEnableHardwareDecode(this.mNativeTXLivePlayerJni, enable);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMute(boolean mute) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mIsAudioMuted = mute;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetMute(this.mNativeTXLivePlayerJni, mute);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVolume(int volume) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mVolume = volume;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetVolume(this.mNativeTXLivePlayerJni, volume);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioRoute(int audioRoute) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mAudioRoute = audioRoute;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetAudioRoute(this.mNativeTXLivePlayerJni, audioRoute);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int switchStream(String playUrl) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.isNativeValid()) {
                return TXLivePlayerJni.nativeSwitchStream(this.mNativeTXLivePlayerJni, playUrl);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAudioVolumeEvaluation(int intervalMs) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mVolumeIntervalMs = intervalMs;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeEnableAudioVolumeEvaluation(this.mNativeTXLivePlayerJni, intervalMs);
            }
            return;
        }
    }

    @Override
    public void callExperimentalAPI(String jsonStr) {
        try {
            JSONObject jSONObject = new JSONObject(jsonStr);
            if (!jSONObject.has("api")) {
                LiteavLog.e(TAG, "call experimental api failed. json: ".concat(String.valueOf(jsonStr)));
                return;
            }
            String string = jSONObject.getString("api");
            JSONObject jSONObject2 = null;
            if (jSONObject.has("params")) {
                jSONObject2 = jSONObject.getJSONObject("params");
            }
            String string2 = string;
            int n2 = -1;
            switch (string2.hashCode()) {
                case 298124139: {
                    if (!string2.equals("setEncryptionParams")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                case 0: {
                    this.setEncryptionParams(jSONObject2);
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LiteavLog.e(TAG, "call experimental api failed. json:".concat(String.valueOf(jsonStr)));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEncryptionParams(JSONObject params) {
        if (!(params != null && params.has("url") && params.has("encMode") && params.has("encKey") && params.has("encIV"))) {
            LiteavLog.e(TAG, "set encryption params failed. invalid params:".concat(String.valueOf(params)));
            return;
        }
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            String string;
            String string2;
            String string3;
            int n2;
            try {
                n2 = params.getInt("encMode");
                string3 = params.getString("url");
                string2 = params.getString("encKey");
                string = params.getString("encIV");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                LiteavLog.e(TAG, "set encryption params failed. parse json failed.");
                return;
            }
            this.mAESMode = n2;
            this.mAESKey = string2;
            this.mAESURL = string3;
            this.mAESIV = string;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSetAESCodecParams(this.mNativeTXLivePlayerJni, this.mAESURL, this.mAESMode, this.mAESKey, this.mAESIV);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshot(TXLivePlayer.ITXSnapshotListener listener) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            this.mSnapshotListener = listener;
            if (this.isNativeValid()) {
                TXLivePlayerJni.nativeSnapshot(this.mNativeTXLivePlayerJni);
            }
            return;
        }
    }

    @Override
    public boolean addVideoRawData(byte[] yuvBuffer) {
        return false;
    }

    @CalledByNative
    public void onPlayEvent(int code, Bundle params) {
        ITXLivePlayListener iTXLivePlayListener = this.mListener;
        if (iTXLivePlayListener != null) {
            iTXLivePlayListener.onPlayEvent(code, params);
        }
    }

    @CalledByNative
    public void onNetStatus(Bundle params) {
        ITXLivePlayListener iTXLivePlayListener = this.mListener;
        if (iTXLivePlayListener != null) {
            iTXLivePlayListener.onNetStatus(params);
        }
    }

    @CalledByNative
    public void onRenderVideoFrame(PixelFrame pixelFrame) {
        Object object;
        TXLivePlayer.ITXLivePlayVideoRenderListener iTXLivePlayVideoRenderListener = this.mVideoRenderListener;
        if (iTXLivePlayVideoRenderListener != null) {
            object = new TXLivePlayer.TXLiteAVTexture();
            new TXLivePlayer.TXLiteAVTexture().textureId = pixelFrame.getTextureId();
            ((TXLivePlayer.TXLiteAVTexture)object).width = pixelFrame.getWidth();
            ((TXLivePlayer.TXLiteAVTexture)object).height = pixelFrame.getHeight();
            ((TXLivePlayer.TXLiteAVTexture)object).eglContext = pixelFrame.getGLContext();
            iTXLivePlayVideoRenderListener.onRenderVideoFrame((TXLivePlayer.TXLiteAVTexture)object);
        }
        if ((object = this.mVideoRawDataListener) != null) {
            object.onVideoRawDataAvailable(pixelFrame.getData(), pixelFrame.getWidth(), pixelFrame.getHeight(), (int)pixelFrame.getTimestamp());
        }
    }

    @CalledByNative
    public void onAudioInfoChanged(int sampleRate, int channels, int bitsperchannel) {
        TXLivePlayer.ITXAudioRawDataListener iTXAudioRawDataListener = this.mAudioRawDataListener;
        if (iTXAudioRawDataListener != null) {
            iTXAudioRawDataListener.onAudioInfoChanged(sampleRate, channels, bitsperchannel);
        }
    }

    @CalledByNative
    public void onPcmDataAvailable(byte[] pcmData, long timestamp) {
        TXLivePlayer.ITXAudioRawDataListener iTXAudioRawDataListener = this.mAudioRawDataListener;
        if (iTXAudioRawDataListener != null) {
            iTXAudioRawDataListener.onPcmDataAvailable(pcmData, timestamp);
        }
    }

    @CalledByNative
    public void onAudioVolumeEvaluationNotify(int volume) {
        TXLivePlayer.ITXAudioVolumeEvaluationListener iTXAudioVolumeEvaluationListener = this.mAudioVolumeEvaluationListener;
        if (iTXAudioVolumeEvaluationListener != null) {
            iTXAudioVolumeEvaluationListener.onAudioVolumeEvaluationNotify(volume);
        }
    }

    @CalledByNative
    public void onSnapshot(Bitmap image) {
        TXLivePlayer.ITXSnapshotListener iTXSnapshotListener = this.mSnapshotListener;
        if (iTXSnapshotListener != null) {
            iTXSnapshotListener.onSnapshot(image);
        }
    }

    @Override
    public void onShowLog(boolean enable) {
        this.showDebugView(enable);
    }

    @CalledByNative
    public void onRecordComplete(int errcode, String errmsg, String outputFilePath, String coverImagePath) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
            tXRecordResult.retCode = errcode == 0 ? 0 : -1;
            tXRecordResult.descMsg = errmsg;
            tXRecordResult.videoPath = outputFilePath;
            tXRecordResult.coverPath = coverImagePath;
            iTXVideoRecordListener.onRecordComplete(tXRecordResult);
        }
    }

    @CalledByNative
    public void onRecordProgress(long milliSeconds) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordProgress(milliSeconds);
        }
    }

    @CalledByNative
    public void onRecordEvent(int event, Bundle param) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordEvent(event, param);
        }
    }

    private static String genFilePath(Context context, String suffix) {
        if (context == null) {
            return null;
        }
        try {
            String string = String.valueOf(System.currentTimeMillis() / 1000L);
            String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date(Long.valueOf(string + "000")));
            String string3 = TXLivePlayerJni.getDiskFileDir(context);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return null;
            }
            String string4 = String.format("TXUGC_%s".concat(String.valueOf(suffix)), string2);
            return new File(string3, string4).getAbsolutePath();
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "create file path failed.", exception);
            return null;
        }
    }

    private static String getDiskFileDir(Context context) {
        if (context == null) {
            return null;
        }
        String string = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            if (file != null) {
                string = file.getPath();
            }
        } else {
            string = context.getFilesDir().getPath();
        }
        return string;
    }
}

