/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.h;
import com.tencent.liteav.videobase.utils.i;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videobase.videobase.f;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.ExternalDecodeFactoryManager;
import com.tencent.liteav.videoconsumer.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoconsumer.decoder.SpsInfo;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.aa;
import com.tencent.liteav.videoconsumer.decoder.ab;
import com.tencent.liteav.videoconsumer.decoder.ad;
import com.tencent.liteav.videoconsumer.decoder.ak;
import com.tencent.liteav.videoconsumer.decoder.am;
import com.tencent.liteav.videoconsumer.decoder.an;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.decoder.d;
import com.tencent.liteav.videoconsumer.decoder.p;
import com.tencent.liteav.videoconsumer.decoder.w;
import com.tencent.liteav.videoconsumer.decoder.z;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;

public final class VideoDecodeController
implements an {
    @NonNull
    final IVideoReporter a;
    @NonNull
    final d b;
    @NonNull
    final ak c;
    public com.tencent.liteav.base.util.b d;
    a e;
    Object f;
    com.tencent.liteav.videobase.b.e g;
    boolean h = false;
    private am o;
    JSONArray i;
    public VideoDecoderDef.ConsumerScene j = VideoDecoderDef.ConsumerScene.a;
    final AtomicInteger k = new AtomicInteger(0);
    final h l = new h(1);
    ServerVideoConsumerConfig m;
    final i n;
    private final d.d p = w.a();

    public VideoDecodeController(@NonNull IVideoReporter reporter) {
        this.a = reporter;
        b.a.a();
        boolean bl = ExternalDecodeFactoryManager.a();
        b.a.a();
        this.b = new d(this.p, reporter, bl, com.tencent.liteav.videoconsumer.decoder.b.b());
        this.c = new ak(reporter);
        this.n = new i("decoder" + this.hashCode());
    }

    final void c() {
        LiteavLog.i("VideoDecodeController", "initializeEGLCoreInternal()");
        this.g = new com.tencent.liteav.videobase.b.e();
        try {
            this.g.a(this.f, null, 128, 128);
            this.n.a((e)null);
            return;
        }
        catch (com.tencent.liteav.videobase.b.f f2) {
            LiteavLog.e("VideoDecodeController", "create egl core failed.", f2);
            this.a.notifyWarning(e.c.h, "VideoDecode: create EGLCore failed", new Object[0]);
            this.g = null;
            return;
        }
    }

    final void d() {
        LiteavLog.i("VideoDecodeController", "uninitializeEGLCoreInternal()");
        if (this.g == null) {
            return;
        }
        this.n.a();
        try {
            this.g.b();
            this.g.e();
        }
        catch (com.tencent.liteav.videobase.b.f f2) {
            LiteavLog.e("VideoDecodeController", "destroy egl core failed.", f2);
            this.a.notifyWarning(e.c.s, "VideoDecode: destroy EGLCore failed", new Object[0]);
        }
        this.g = null;
    }

    public final void a(Object object) {
        LiteavLog.i("VideoDecodeController", "setSharedEGLContext(object:" + object + ", mEGLCore: " + this.g + ")");
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ad.a(videoDecodeController, object));
    }

    final void a(EncodedVideoFrame encodedVideoFrame, am.a a2) {
        long l2 = SystemClock.elapsedRealtime();
        this.f();
        SpsInfo spsInfo = this.p.a(encodedVideoFrame.isH265(), encodedVideoFrame.data);
        this.o = a2 == am.a.a ? new SoftwareVideoDecoder(this.a) : new p(new com.tencent.liteav.base.util.p(spsInfo.width, spsInfo.height), encodedVideoFrame.isH265(), this.i, this.a);
        this.o.initialize();
        this.o.setServerConfig(this.m);
        this.o.setScene(this.j);
        this.o.start(this.g.d(), this);
        this.k.set(0);
        LiteavLog.d("VideoDecodeController", "open decoder cost time: " + (SystemClock.elapsedRealtime() - l2));
        LiteavLog.i("VideoDecodeController", "update decoder type to " + (Object)((Object)a2) + ", video " + spsInfo);
        boolean bl = encodedVideoFrame.isH265();
        am.a a3 = this.o.getDecoderType();
        ak ak2 = this.c;
        this.c.e = a3;
        if (bl && a3 == am.a.a) {
            a3 = am.a.c;
        }
        VideoDecoderDef.DecoderProperty decoderProperty = new VideoDecoderDef.DecoderProperty(a3, bl ? CodecType.b : CodecType.a);
        ak2.a.updateStatus(com.tencent.liteav.videobase.videobase.f.L, decoderProperty);
    }

    final void a(EncodedVideoFrame encodedVideoFrame) {
        EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
        ak ak2 = this.c;
        if (!ak2.i && encodedVideoFrame2.isIDRFrame()) {
            ak2.g = SystemClock.elapsedRealtime();
            ak2.i = true;
            ak2.a.notifyEvent(e.b.A, "Start decode first frame", new Object[0]);
            LiteavLog.d("VideoDecodeControllerStatistics", "received first I frame.");
        }
        if (!ak2.f) {
            ++ak2.h;
        }
        long l2 = encodedVideoFrame2.pts;
        ak.a a2 = ak2.b;
        if (a2.e.isEmpty()) {
            a2.d = SystemClock.elapsedRealtime();
        }
        a2.e.addLast(l2);
        if (this.o != null) {
            this.k.incrementAndGet();
            this.o.decode(encodedVideoFrame);
        }
    }

    final am.a e() {
        if (this.o == null) {
            return null;
        }
        return this.o.getDecoderType();
    }

    final void f() {
        if (this.o != null) {
            this.o.stop();
            this.o.uninitialize();
            this.o = null;
        }
        this.l.b();
    }

    public final boolean a(Runnable runnable) {
        boolean bl = true;
        com.tencent.liteav.base.util.b b2 = this.d;
        if (b2 != null && b2.getLooper().getThread().isAlive()) {
            if (Looper.myLooper() == b2.getLooper()) {
                runnable.run();
            } else {
                bl = b2.post(runnable);
            }
        } else {
            bl = false;
        }
        if (!bl) {
            LiteavLog.w("VideoDecodeController", "runnable:" + runnable + " is failed to post, handler:" + (Object)((Object)b2));
        }
        return bl;
    }

    final boolean g() {
        try {
            this.g.a();
            return true;
        }
        catch (com.tencent.liteav.videobase.b.f f2) {
            LiteavLog.e("VideoDecodeController", "make current failed.", f2);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void a(PixelFrame pixelFrame, long l2) {
        long l3 = pixelFrame.getTimestamp();
        this.l.a(pixelFrame);
        VideoDecodeController videoDecodeController = this;
        if (!videoDecodeController.a(z.a(videoDecodeController, l3, l2))) {
            PixelFrame pixelFrame2 = pixelFrame;
            h h2 = this.l;
            if (pixelFrame2 != null) {
                boolean bl = false;
                h h3 = h2;
                synchronized (h3) {
                    if (h2.a.size() > 0) {
                        bl = h2.a.removeFirstOccurrence(pixelFrame2);
                    }
                }
                if (bl) {
                    pixelFrame2.release();
                    return;
                }
                LiteavLog.w("RingFrameQueue", "remove removeFrame:" + pixelFrame2 + " fail!");
            }
        }
    }

    @Override
    public final void a() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(aa.a(videoDecodeController));
    }

    @Override
    public final void b() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ab.a(videoDecodeController));
    }

    public static enum DecodeStrategy {
        a(0),
        b(1),
        c(2),
        d(3);

        private final int mValue;
        private static final DecodeStrategy[] e;

        private DecodeStrategy(int mValue) {
            this.mValue = mValue;
        }

        public static DecodeStrategy a(int n2) {
            DecodeStrategy[] decodeStrategyArray = e;
            int n3 = e.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                DecodeStrategy decodeStrategy = decodeStrategyArray[i2];
                if (decodeStrategy.mValue != n2) continue;
                return decodeStrategy;
            }
            return a;
        }

        static {
            e = DecodeStrategy.values();
        }
    }

    public static interface a
    extends an {
    }
}

