/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.b.e;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.am;
import com.tencent.liteav.videoconsumer.decoder.an;
import com.tencent.liteav.videoconsumer.decoder.o;
import com.tencent.liteav.videoconsumer.decoder.q;
import com.tencent.liteav.videoconsumer.decoder.r;
import com.tencent.liteav.videoconsumer.decoder.s;
import com.tencent.liteav.videoconsumer.decoder.t;
import com.tencent.liteav.videoconsumer.decoder.u;
import com.tencent.liteav.videoconsumer.decoder.v;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class p
implements SurfaceTexture.OnFrameAvailableListener,
am {
    @NonNull
    private final com.tencent.liteav.base.util.p a = new com.tencent.liteav.base.util.p();
    @NonNull
    private final IVideoReporter b;
    private final boolean c;
    private final JSONArray d;
    private volatile b e;
    private MediaCodec f = null;
    private an g;
    private final MediaCodec.BufferInfo h = new MediaCodec.BufferInfo();
    private final Deque<EncodedVideoFrame> i = new LinkedList<EncodedVideoFrame>();
    private boolean j = true;
    private e k;
    private int l = -1;
    private l m;
    private SurfaceTexture n;
    private Surface o;
    private VideoDecoderDef.ConsumerScene p = VideoDecoderDef.ConsumerScene.a;
    private boolean q = false;
    private o r = new o();

    public p(@NonNull com.tencent.liteav.base.util.p p2, boolean bl, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this.c = bl;
        this.d = jSONArray;
        this.a.a = p2.a;
        this.a.b = p2.b;
        this.b = iVideoReporter;
        LiteavLog.i("HardwareVideoDecoder", "create decoder " + p2 + ", useHevc: " + bl + " , params: " + jSONArray);
    }

    @Override
    public final void initialize() {
        HandlerThread handlerThread = new HandlerThread("HardwareVideoDecoder_" + this.hashCode());
        handlerThread.start();
        this.e = new b(handlerThread.getLooper());
    }

    @Override
    public final void uninitialize() {
        if (this.e != null) {
            this.e.a();
        }
    }

    @Override
    public final void setScene(VideoDecoderDef.ConsumerScene scene) {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.q.a(p2, scene));
    }

    @Override
    public final void start(Object glContext, an listener) {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.r.a(p2, glContext, listener));
    }

    private boolean a(Object object) {
        this.k = new e();
        try {
            this.k.a(object, null, 128, 128);
            this.k.a();
        }
        catch (f f2) {
            LiteavLog.e("HardwareVideoDecoder", "create EGLCore failed.", f2);
            this.a(e.c.h, "VideoDecode: create EGLCore failed errorCode:" + f2.mErrorCode, new Object[0]);
            return false;
        }
        this.l = OpenGlUtils.generateTextureOES();
        this.m = new l();
        try {
            this.n = new SurfaceTexture(this.l);
            this.o = new Surface(this.n);
            this.n.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            LiteavLog.e("HardwareVideoDecoder", "create SurfaceTexture failed.", outOfResourcesException);
            this.a(e.c.k, "VideoDecode: insufficient resource, Start decoder failed:" + outOfResourcesException.getMessage(), new Object[0]);
            return false;
        }
        LiteavLog.i("HardwareVideoDecoder", "initialize gl components");
        return true;
    }

    private boolean a(String string, a a2, boolean bl) {
        MediaFormat mediaFormat;
        MediaFormat mediaFormat2 = MediaFormat.createVideoFormat((String)string, (int)this.a.a, (int)this.a.b);
        if (bl) {
            mediaFormat = mediaFormat2;
            if (this.p == VideoDecoderDef.ConsumerScene.c) {
                if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("qcom")) {
                    mediaFormat.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
                    mediaFormat.setInteger("vendor.qti-ext-dec-picture-order.enable", 1);
                } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 29 && LiteavSystemInfo.getHardware().toLowerCase().contains("kirin")) {
                    mediaFormat.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-req", 1);
                    mediaFormat.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-rdy", -1);
                } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("exynos")) {
                    mediaFormat.setInteger("vendor.rtc-ext-dec-low-latency.enable", 1);
                }
                if (LiteavSystemInfo.getSystemOSVersionInt() >= 30) {
                    mediaFormat.setInteger("low-latency", 1);
                }
            }
        }
        mediaFormat = this.d;
        MediaFormat mediaFormat3 = mediaFormat2;
        if (mediaFormat != null) {
            try {
                for (int i2 = 0; i2 < mediaFormat.length(); ++i2) {
                    JSONObject jSONObject = mediaFormat.getJSONObject(i2);
                    mediaFormat3.setInteger(jSONObject.optString("key"), jSONObject.optInt("value"));
                }
            }
            catch (JSONException jSONException) {
                LiteavLog.e("HardwareVideoDecoder", "set MediaCodec device related params failed.", jSONException);
            }
        }
        LiteavLog.i("HardwareVideoDecoder", String.valueOf(mediaFormat2));
        try {
            a2.a = MediaCodec.createDecoderByType((String)string);
            a2.a.configure(mediaFormat2, this.o, null, 0);
            a2.a.setVideoScalingMode(1);
            a2.a.start();
            LiteavLog.i("HardwareVideoDecoder", "Start MediaCodec success.");
            return true;
        }
        catch (Exception exception) {
            LiteavLog.e("HardwareVideoDecoder", "Start MediaCodec failed.", exception);
            com.tencent.liteav.videoconsumer.decoder.p.a(a2.a);
            a2.a = null;
            e.c c2 = e.c.m;
            String string2 = "VideoDecode: Start decoder failed";
            if (exception instanceof IllegalArgumentException) {
                c2 = e.c.i;
                string2 = "VideoDecode: illegal argument, Start decoder failed";
            } else if (exception instanceof IllegalStateException) {
                c2 = e.c.j;
                string2 = "VideoDecode: illegal state, Start decoder failed";
            }
            a2.b = c2;
            a2.c = string2;
            a2.d = exception;
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private static void a(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            mediaCodec.stop();
            try {
                mediaCodec.release();
                return;
            }
            catch (Exception exception) {
                LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception);
                return;
            }
            catch (Exception exception) {
                try {
                    LiteavLog.e("HardwareVideoDecoder", "Stop MediaCodec failed." + exception.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        mediaCodec.release();
                    }
                    catch (Exception exception2) {
                        LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception2);
                    }
                    throw throwable;
                }
                try {
                    mediaCodec.release();
                    return;
                }
                catch (Exception exception3) {
                    LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception3);
                    return;
                }
            }
        }
    }

    @Override
    public final void decode(EncodedVideoFrame frame) {
        p p2 = this;
        p2.a(s.a(p2, frame));
    }

    @Override
    public final void stop() {
        p p2 = this;
        p2.a(t.a(p2));
    }

    @Override
    public final am.a getDecoderType() {
        return am.a.b;
    }

    @Override
    public final void setServerConfig(ServerVideoConsumerConfig config) {
        p p2 = this;
        p2.a(u.a(p2, config));
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        p p2 = this;
        p2.a(v.a(p2, surfaceTexture));
    }

    private boolean a() {
        try {
            if (this.k != null) {
                this.k.a();
            }
            return true;
        }
        catch (f f2) {
            LiteavLog.e("HardwareVideoDecoder", "makeCurrent failed.", f2);
            return false;
        }
    }

    private void a(e.c c2, String string, Object ... objectArray) {
        this.b.notifyWarning(c2, string, objectArray);
        if (this.g != null) {
            this.g.a();
        }
    }

    private void a(Runnable runnable) {
        b b2 = this.e;
        if (b2 != null) {
            if (b2.getLooper() == Looper.myLooper()) {
                runnable.run();
                return;
            }
            b2.post(runnable);
        }
    }

    static /* synthetic */ void a(p p2, SurfaceTexture surfaceTexture) {
        if (p2.n == null || surfaceTexture != p2.n) {
            LiteavLog.i("HardwareVideoDecoder", "mSurfaceTexture= " + p2.n + " ,surfaceTexture= " + surfaceTexture);
            return;
        }
        p2.a();
        l.b b2 = null;
        try {
            b2 = (l.b)p2.m.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w("HardwareVideoDecoder", "textureholderpool obtain interrupted.");
        }
        b2.a(36197, p2.l, p2.a.a, p2.a.b);
        PixelFrame pixelFrame = b2.a(p2.k.d());
        if (pixelFrame.getMatrix() == null) {
            pixelFrame.setMatrix(new float[16]);
        }
        try {
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(pixelFrame.getMatrix());
        }
        catch (Exception exception) {
            LiteavLog.w("HardwareVideoDecoder", "updateTexImage exception: ".concat(String.valueOf(exception)));
        }
        p2.j = true;
        long l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
        pixelFrame.setTimestamp(l2);
        p2.g.a(pixelFrame, l2);
        b2.release();
        pixelFrame.release();
    }

    static /* synthetic */ void a(p p2, ServerVideoConsumerConfig serverVideoConsumerConfig) {
        if (serverVideoConsumerConfig == null) {
            return;
        }
        p2.q = serverVideoConsumerConfig.enableVui;
    }

    static /* synthetic */ void a(p p2, EncodedVideoFrame encodedVideoFrame) {
        EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
        p p3 = p2;
        if (p3.f == null) {
            LiteavLog.w("HardwareVideoDecoder", "MediaCodec is stopped.");
            return;
        }
        if (encodedVideoFrame2 != null) {
            p3.i.addLast(encodedVideoFrame2);
        }
        try {
            MediaFormat mediaFormat;
            int n2;
            p p4;
            while (p3.j) {
                boolean bl;
                block35: {
                    p4 = p3;
                    for (int i2 = 0; i2 < 3 && (n2 = p4.f.dequeueOutputBuffer(p4.h, TimeUnit.MILLISECONDS.toMicros(10L))) != -1; ++i2) {
                        if (n2 == -3) {
                            LiteavLog.i("HardwareVideoDecoder", "on output buffers changed");
                            continue;
                        }
                        if (n2 == -2) {
                            mediaFormat = p4.f.getOutputFormat();
                            LiteavLog.i("HardwareVideoDecoder", "decode output format changed: ".concat(String.valueOf(mediaFormat)));
                            int n3 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
                            int n4 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
                            int n5 = mediaFormat.getInteger("width");
                            int n6 = mediaFormat.getInteger("height");
                            LiteavLog.i("HardwareVideoDecoder", "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n3, n4, n5, n6);
                            continue;
                        }
                        if (n2 >= 0) {
                            p4.j = false;
                            p4.f.releaseOutputBuffer(n2, true);
                            if ((p4.h.flags & 4) != 0) {
                                LiteavLog.i("HardwareVideoDecoder", "meet end of stream.");
                            }
                            bl = true;
                            break block35;
                        }
                        LiteavLog.d("HardwareVideoDecoder", "dequeueOutputBuffer get invalid index: %d", n2);
                        break;
                    }
                    bl = false;
                }
                if (bl) continue;
            }
            while (!p3.i.isEmpty()) {
                boolean bl;
                EncodedVideoFrame encodedVideoFrame3 = p3.i.peekFirst();
                if (encodedVideoFrame3 == null || encodedVideoFrame3.data == null || encodedVideoFrame3.data.remaining() == 0) {
                    LiteavLog.w("HardwareVideoDecoder", "receive empty buffer.");
                    bl = true;
                } else {
                    MediaFormat mediaFormat2;
                    mediaFormat = mediaFormat2 = p4.f.getInputBuffers();
                    if (mediaFormat2 == null || ((MediaFormat)mediaFormat).length == 0) {
                        LiteavLog.e("HardwareVideoDecoder", "get invalid input buffers.");
                        bl = false;
                    } else {
                        n2 = p4.f.dequeueInputBuffer(10000L);
                        if (n2 < 0) {
                            bl = false;
                        } else {
                            EncodedVideoFrame encodedVideoFrame4 = encodedVideoFrame3;
                            p p5 = p4;
                            if (encodedVideoFrame4.isIDRFrame() && encodedVideoFrame4.codecType == CodecType.a && p5.q && p5.p == VideoDecoderDef.ConsumerScene.c) {
                                byte[] byArray;
                                Object[] objectArray;
                                byte[] byArray2;
                                int[] nArray;
                                byte[] byArray3 = new byte[encodedVideoFrame4.data.remaining()];
                                encodedVideoFrame4.data.get(byArray3);
                                encodedVideoFrame4.data.rewind();
                                int[] nArray2 = nArray = new int[]{-1};
                                Object object = byArray3;
                                int n7 = 0;
                                while (n7 + 4 < ((byte[])object).length && (n7 = EncodedVideoFrame.getNextNALHeaderPos(n7, ByteBuffer.wrap((byte[])object))) >= 0) {
                                    if ((object[n7] & 0x1F) != 7) continue;
                                    nArray2[0] = n7;
                                    break;
                                }
                                if (nArray2[0] < 0) {
                                    byArray2 = null;
                                } else {
                                    n7 = ((byte[])object).length - nArray2[0];
                                    int n8 = nArray2[0];
                                    while (n8 + 3 < ((byte[])object).length) {
                                        if (object[n8] == 0 && object[n8 + 1] == 0 && object[n8 + 2] == 1 || object[n8] == 0 && object[n8 + 1] == 0 && object[n8 + 2] == 0 && object[n8 + 3] == 1) {
                                            n7 = n8 - nArray2[0];
                                            break;
                                        }
                                        ++n8;
                                    }
                                    objectArray = new byte[n7];
                                    System.arraycopy(object, nArray2[0], objectArray, 0, objectArray.length);
                                    byArray2 = byArray = objectArray;
                                }
                                if (byArray2 != null && nArray[0] >= 0) {
                                    Object[] objectArray2 = null;
                                    try {
                                        byte[] byArray4;
                                        nArray2 = byArray;
                                        object = p5.r;
                                        n7 = 0;
                                        int[] nArray3 = nArray2;
                                        byte[] byArray5 = new byte[nArray2.length];
                                        int n9 = 0;
                                        int n10 = 0;
                                        while (n10 < nArray3.length) {
                                            if (n10 < nArray3.length - 3 && nArray3[n10] == 0 && nArray3[n10 + 1] == 0 && nArray3[n10 + 2] == 3 && nArray3[n10 + 3] <= 3) {
                                                byArray5[n9++] = nArray3[n10];
                                                byArray5[n9++] = nArray3[n10 + 1];
                                                n10 += 3;
                                                continue;
                                            }
                                            byArray5[n9++] = nArray3[n10];
                                            ++n10;
                                        }
                                        if (n9 != nArray3.length) {
                                            byte[] byArray6 = new byte[n9];
                                            System.arraycopy(byArray5, 0, byArray6, 0, n9);
                                            byArray4 = byArray6;
                                        } else {
                                            byArray4 = objectArray = null;
                                        }
                                        if (byArray4 != null) {
                                            n7 = 1;
                                        } else {
                                            objectArray = nArray2;
                                        }
                                        objectArray = ((o)object).a(new ByteArrayInputStream((byte[])objectArray));
                                        if (objectArray != null && n7 != 0) {
                                            objectArray = com.tencent.liteav.videoconsumer.decoder.o.a(objectArray);
                                        }
                                        objectArray2 = objectArray;
                                    }
                                    catch (Exception exception) {
                                        LiteavLog.e("HardwareVideoDecoder", "modify dec buffer error ", exception);
                                    }
                                    if (objectArray2 != null) {
                                        encodedVideoFrame4.data = ByteBuffer.allocateDirect(byArray3.length - byArray.length + objectArray2.length);
                                        if (nArray[0] > 0) {
                                            encodedVideoFrame4.data.put(byArray3, 0, nArray[0]);
                                        }
                                        encodedVideoFrame4.data.put((byte[])objectArray2);
                                        encodedVideoFrame4.data.put(byArray3, nArray[0] + byArray.length, byArray3.length - nArray[0] - byArray.length);
                                        encodedVideoFrame4.data.rewind();
                                    }
                                }
                            }
                            int n11 = encodedVideoFrame3.data.remaining();
                            mediaFormat2[n2].put(encodedVideoFrame3.data);
                            p4.f.queueInputBuffer(n2, 0, n11, TimeUnit.MILLISECONDS.toMicros(encodedVideoFrame3.pts), 0);
                            bl = true;
                        }
                    }
                }
                if (!bl) break;
                EncodedVideoFrame encodedVideoFrame5 = p3.i.removeFirst();
                if (encodedVideoFrame5 == null) continue;
                encodedVideoFrame5.release();
            }
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("HardwareVideoDecoder", "decode failed.", exception);
            p3.a(e.c.n, "VideoDecode: decode error, restart decoder message:" + exception.getMessage(), new Object[0]);
            return;
        }
    }

    static /* synthetic */ void a(p p2, Object object, an an2) {
        an an3 = an2;
        Object object2 = object;
        p p3 = p2;
        LiteavLog.i("HardwareVideoDecoder", "Start internal");
        if (p3.k != null) {
            LiteavLog.w("HardwareVideoDecoder", "Decoder already started.");
            return;
        }
        p3.g = an3;
        if (p3.a(object2)) {
            a a2;
            String string = p3.c ? "video/hevc" : "video/avc";
            if (p3.a(string, a2 = new a(0), true) || p3.a(string, a2, false)) {
                p3.f = a2.a;
                p3.b.notifyEvent(e.b.B, "Start decoder success", new Object[0]);
                return;
            }
            p3.a(a2.b, "decoder config fail, message:" + a2.c + " exception:" + a2.d.getMessage(), new Object[0]);
        }
    }

    static /* synthetic */ void a(p p2, VideoDecoderDef.ConsumerScene consumerScene) {
        p2.p = consumerScene;
    }

    static /* synthetic */ void a(p p2) {
        p p3 = p2;
        LiteavLog.i("HardwareVideoDecoder", "Stop internal");
        if (p3.f != null) {
            com.tencent.liteav.videoconsumer.decoder.p.a(p3.f);
            p3.f = null;
        }
        for (EncodedVideoFrame encodedVideoFrame : p3.i) {
            if (encodedVideoFrame == null) continue;
            encodedVideoFrame.release();
        }
        p3.i.clear();
        p p4 = p3;
        LiteavLog.i("HardwareVideoDecoder", "uninitialize gl components");
        if (p4.a()) {
            if (p4.m != null) {
                p4.m.b();
            }
            if (p4.o != null) {
                p4.o.release();
                p4.o = null;
            }
            if (p4.n != null) {
                p4.n.release();
                p4.n = null;
            }
            OpenGlUtils.deleteTexture(p4.l);
            p4.l = -1;
            try {
                if (p4.k != null) {
                    p4.k.b();
                    p4.k.e();
                }
            }
            catch (f f2) {
                LiteavLog.e("HardwareVideoDecoder", "destroy EGLCore failed.", f2);
            }
            p4.k = null;
        }
        p3.j = true;
    }

    static final class a {
        public MediaCodec a = null;
        public e.c b = null;
        public String c = null;
        public Exception d = null;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

