/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.DisplayMetrics;
import android.view.Display;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CpuUsageMeasurer;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.a;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.base.util.s;

@JNINamespace(value="liteav")
public class SystemUtil {
    private static final String TAG = "SystemUtil";
    private static boolean mFirstTimeRun;
    private static final a<CpuUsageMeasurer> sCpuUsageMeasurer;

    public static int[] getProcessCPURate() {
        if (mFirstTimeRun) {
            mFirstTimeRun = false;
            sCpuUsageMeasurer.a();
            CpuUsageMeasurer.a();
            return new int[]{0, 0};
        }
        sCpuUsageMeasurer.a();
        return CpuUsageMeasurer.a();
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    @NonNull
    public static Size getDisplaySize() {
        try {
            Display display = SystemUtil.getDefaultDisplay();
            if (display != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getRealMetrics(displayMetrics);
                return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "get display size failed.", exception);
        }
        return new Size(720, 1280);
    }

    @SuppressLint(value={"NewApi"})
    public static int getDisplayRotation() {
        try {
            Display display = SystemUtil.getDefaultDisplay();
            if (display != null) {
                return display.getRotation();
            }
            return 0;
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "get display rotation failed.", exception);
            return 0;
        }
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static int getDisplayRotationDegree() {
        switch (SystemUtil.getDisplayRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static Display getDefaultDisplay() {
        return i.a().b();
    }

    static {
        sCpuUsageMeasurer = new a(s.b());
    }
}

