/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.decoder;

import android.annotation.TargetApi;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.tencent.thumbplayer.core.common.TPCodecUtils;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.common.TPSystemInfo;
import com.tencent.thumbplayer.core.decoder.TPBaseMediaCodecDecoder;
import com.tencent.thumbplayer.core.decoder.TPFrameInfo;
import com.tencent.thumbplayer.g.b;
import java.nio.ByteBuffer;
import java.util.ArrayList;

@RequiresApi(api=16)
public class TPMediaCodecVideoDecoder
extends TPBaseMediaCodecDecoder {
    private static final String TAG = "TPMediaCodecVideoDecode";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final String DEVICE_NAME_VIVO_X5L = "vivo X5L";
    private static final int YUV420P_PLANAR_COUNT = 3;
    private static final int PIXEL_STRIDE_CONTINUOUS = 1;
    private boolean mEnableMediaCodecOutputData = false;
    private ArrayList<String> mMimeCandidates = new ArrayList();
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private int mCropLeft = 0;
    private int mCropRight = 0;
    private int mCropTop = 0;
    private int mCropBottom = 0;
    private int mRotation = 0;
    private int mDolbyVisionProfile = 0;
    private int mDolbyVisionLevel = 0;
    private byte[] mCsd0Data = null;
    private byte[] mCsd1Data = null;
    private byte[] mCsd2Data = null;
    private boolean mDisableDolbyVisionComponent = false;

    public TPMediaCodecVideoDecoder(int n2) {
        super(n2);
    }

    @Override
    public boolean initDecoder(String string, int n2, int n3, int n4, Surface surface, int n5, int n6, int n7) {
        TPNativeLog.printLog(2, TAG, "initDecoder, mimeType:" + string + " width:" + n2 + " height:" + n3 + " rotation:" + n4 + " dvProfile:" + n6 + " dvLevel:" + n7);
        this.mVideoWidth = n2;
        this.mVideoHeight = n3;
        this.mRotation = n4;
        this.mSurface = surface;
        this.mDrmType = n5;
        this.mDolbyVisionProfile = n6;
        this.mDolbyVisionLevel = n7;
        this.mMimeCandidates.clear();
        if ("video/dolby-vision".equals(string)) {
            int n8 = TPCodecUtils.convertDolbyVisionToOmxProfile(this.mDolbyVisionProfile);
            boolean bl = false;
            if (n8 >= 4 && n8 <= 256) {
                bl = true;
            }
            if (this.mDisableDolbyVisionComponent && bl) {
                this.mMimeCandidates.add("video/hevc");
            } else {
                this.mMimeCandidates.add(string);
                if (bl) {
                    this.mMimeCandidates.add("video/hevc");
                }
            }
        } else {
            this.mMimeCandidates.add(string);
        }
        return true;
    }

    @Override
    public boolean initDecoder(String string, int n2, int n3, int n4, int n5) {
        return false;
    }

    ArrayList<String> getMimeCandidates() {
        return this.mMimeCandidates;
    }

    @Override
    String getCodecName(@NonNull String string, boolean bl) {
        String string2;
        if (this.mDolbyVisionProfile <= 0 || this.mDisableDolbyVisionComponent || (string2 = TPCodecUtils.getDolbyVisionDecoderName(string, this.mDolbyVisionProfile, this.mDolbyVisionLevel, bl)) == null) {
            string2 = TPCodecUtils.getDecoderName(string, bl);
        }
        return string2;
    }

    @Override
    void configCodec(@NonNull b b2, @NonNull String string) {
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)this.mVideoWidth, (int)this.mVideoHeight);
        if (Build.VERSION.SDK_INT > 22) {
            mediaFormat.setInteger("rotation-degrees", this.mRotation);
        }
        if (TPSystemInfo.getDeviceName().equalsIgnoreCase(DEVICE_NAME_VIVO_X5L)) {
            mediaFormat.setInteger("max-input-size", this.mVideoWidth * this.mVideoHeight);
        }
        if (this.mCsd0Data != null) {
            mediaFormat.setByteBuffer("csd-0", ByteBuffer.wrap(this.mCsd0Data));
        }
        if (this.mCsd1Data != null) {
            mediaFormat.setByteBuffer("csd-1", ByteBuffer.wrap(this.mCsd1Data));
        }
        if (this.mCsd2Data != null) {
            mediaFormat.setByteBuffer("csd-2", ByteBuffer.wrap(this.mCsd2Data));
        }
        if ("video/dolby-vision".equals(string)) {
            mediaFormat.setInteger("profile", TPCodecUtils.convertDolbyVisionToOmxProfile(this.mDolbyVisionProfile));
            mediaFormat.setInteger("level", TPCodecUtils.convertDolbyVisionToOmxLevel(this.mDolbyVisionLevel));
        }
        if (this.mEnableMediaCodecOutputData && Build.VERSION.SDK_INT >= 21) {
            mediaFormat.setInteger("color-format", 2135033992);
            b2.a(mediaFormat, null, this.mMediaCrypto, 0);
        } else {
            b2.a(mediaFormat, this.mSurface, this.mMediaCrypto, 0);
        }
        b2.d(1);
    }

    @Override
    void processOutputConfigData(@NonNull b b2, int n2, @NonNull MediaCodec.BufferInfo bufferInfo, @NonNull TPFrameInfo tPFrameInfo) {
        tPFrameInfo.errCode = 0;
        this.processOutputBuffer(b2, n2, bufferInfo, tPFrameInfo);
    }

    @Override
    void processOutputFormatChanged(@NonNull MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
        this.mVideoWidth = mediaFormat.getInteger("width");
        this.mVideoHeight = mediaFormat.getInteger("height");
        if (bl) {
            this.mCropLeft = mediaFormat.getInteger(KEY_CROP_LEFT);
            this.mCropRight = mediaFormat.getInteger(KEY_CROP_RIGHT);
            this.mCropTop = mediaFormat.getInteger(KEY_CROP_TOP);
            this.mCropBottom = mediaFormat.getInteger(KEY_CROP_BOTTOM);
        }
        TPNativeLog.printLog(2, TAG, "processOutputFormatChanged: mVideoWidth: " + this.mVideoWidth + ", mVideoHeight: " + this.mVideoHeight + ", mCropLeft: " + this.mCropLeft + ", mCropRight: " + this.mCropRight + ", mCropTop: " + this.mCropTop + ", mCropBottom: " + this.mCropBottom);
    }

    @Override
    void processOutputBuffer(@NonNull b b2, int n2, @NonNull MediaCodec.BufferInfo bufferInfo, @NonNull TPFrameInfo tPFrameInfo) {
        tPFrameInfo.width = this.mVideoWidth;
        tPFrameInfo.height = this.mVideoHeight;
        tPFrameInfo.cropLeft = this.mCropLeft;
        tPFrameInfo.cropRight = this.mCropRight;
        tPFrameInfo.cropTop = this.mCropTop;
        tPFrameInfo.cropBottom = this.mCropBottom;
        tPFrameInfo.format = 167;
        if (this.mEnableMediaCodecOutputData) {
            this.processOutputData(b2, n2, bufferInfo, tPFrameInfo);
            return;
        }
    }

    @TargetApi(value=21)
    private void processOutputData(@NonNull b b2, int n2, @NonNull MediaCodec.BufferInfo bufferInfo, @NonNull TPFrameInfo tPFrameInfo) {
        if (bufferInfo.flags == 4 && bufferInfo.size <= 0) {
            TPNativeLog.printLog(2, TAG, "processOutputBuffer: bufferInfo.flags is BUFFER_FLAG_END_OF_STREAM, return EOS!");
            tPFrameInfo.format = -1;
            tPFrameInfo.errCode = 2;
            b2.a(n2, false);
            return;
        }
        Image image = b2.b(n2);
        if (image == null) {
            tPFrameInfo.format = -1;
            tPFrameInfo.errCode = 3;
            b2.a(n2, false);
            TPNativeLog.printLog(4, TAG, "processOutputBuffer: getOutputImage return null");
            return;
        }
        this.copyVideoDataFromImage(image, tPFrameInfo);
        b2.a(n2, false);
    }

    @RequiresApi(api=21)
    private void copyVideoDataFromImage(@NonNull Image image, @NonNull TPFrameInfo tPFrameInfo) {
        if (image.getFormat() != 35) {
            tPFrameInfo.format = -1;
            tPFrameInfo.errCode = 3;
            TPNativeLog.printLog(4, TAG, "copyVideoDataFromImage: image format not support!");
            return;
        }
        tPFrameInfo.format = 0;
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        Image.Plane[] planeArray = image.getPlanes();
        if (tPFrameInfo.lineSize == null || tPFrameInfo.lineSize.length < 3) {
            tPFrameInfo.lineSize = new int[3];
        }
        if (tPFrameInfo.videoData == null || tPFrameInfo.videoData.length < 3) {
            tPFrameInfo.videoData = new byte[3][];
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            int n4 = i2 == 0 ? 0 : 1;
            int n5 = n2 >> n4;
            int n6 = n3 >> n4;
            this.copyVideoDataFromPlane(planeArray[i2], n5, n6, i2, tPFrameInfo);
        }
    }

    @RequiresApi(api=21)
    private void copyVideoDataFromPlane(@NonNull Image.Plane plane, int n2, int n3, @IntRange(from=0L) int n4, @NonNull TPFrameInfo tPFrameInfo) {
        ByteBuffer byteBuffer = plane.getBuffer();
        tPFrameInfo.lineSize[n4] = n2;
        int n5 = n2 * n3;
        if (tPFrameInfo.videoData[n4] == null || tPFrameInfo.videoData[n4].length < n5) {
            tPFrameInfo.videoData[n4] = new byte[n5];
        }
        if (plane.getPixelStride() == 1) {
            byteBuffer.get(tPFrameInfo.videoData[n4], 0, n5);
            return;
        }
        for (int i2 = 0; i2 < n5; ++i2) {
            tPFrameInfo.videoData[n4][i2] = byteBuffer.get(i2 * plane.getPixelStride());
        }
    }

    @Override
    void processMediaCodecException(Exception exception) {
    }

    @Override
    String getLogTag() {
        return TAG;
    }

    @Override
    public int setOutputSurface(Surface surface) {
        if (this.mEnableMediaCodecOutputData) {
            return 3;
        }
        return super.setOutputSurface(surface);
    }

    @Override
    public boolean setParamBytes(int n2, byte[] byArray) {
        if (n2 == 200) {
            this.mCsd0Data = byArray;
        } else if (n2 == 201) {
            this.mCsd1Data = byArray;
        } else if (n2 == 202) {
            this.mCsd2Data = byArray;
        }
        return super.setParamBytes(n2, byArray);
    }

    @Override
    public boolean setParamObject(int n2, Object object) {
        return super.setParamObject(n2, object);
    }

    @Override
    public int setOperateRate(float f2) {
        return super.setOperateRate(f2);
    }

    @Override
    public boolean setParamBool(int n2, boolean bl) {
        if (5 == n2) {
            if (!this.mStarted && Build.VERSION.SDK_INT >= 21) {
                this.mEnableMediaCodecOutputData = bl;
            } else {
                TPNativeLog.printLog(3, this.getLogTag(), "BOOL_ENABLE_MEDIACODEC_OUTPUT_DATA failed. need set before start, mStart=" + this.mStarted + ", api level is " + Build.VERSION.SDK_INT + ", support api level = 21");
            }
        } else if (6 == n2) {
            if (!this.mStarted) {
                this.mDisableDolbyVisionComponent = bl;
            } else {
                TPNativeLog.printLog(3, this.getLogTag(), "BOOL_FORCE_DOLBY_VISION_USE_HEVC_CODEC failed. need set before start, mStart=" + this.mStarted);
            }
        }
        return super.setParamBool(n2, bl);
    }
}

