/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.tencent.thumbplayer.core.downloadproxy.aidl.TPDownloadProxyFactoryAidl;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDLProxyBindServiceCallback;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyHelper;
import com.tencent.thumbplayer.core.downloadproxy.client.TPDownloadProxyClient;
import com.tencent.thumbplayer.core.downloadproxy.jni.TPDownloadProxyNative;
import com.tencent.thumbplayer.core.downloadproxy.service.TPDownloadProxyService;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import java.util.HashMap;
import java.util.Map;

public class TPDownloadProxyFactory {
    private static final String FILE_NAME = "TPDownloadProxyFactory";
    private static Object mMapObject = new Object();
    private static HashMap<Integer, ITPDownloadProxy> mvTPDownloadProxyMap = new HashMap();
    private static HashMap<Integer, TPDownloadProxyClient> mvTPDownloadProxyClientMap = new HashMap();
    private static boolean mUseService = false;
    private static boolean mCanUseAIDL = false;
    private static boolean mIsReadyForDownload = false;
    private static TPDLProxyBindServiceCallback mCallback = null;
    private static TPDownloadProxyFactoryAidl downloadProxyFactoryAidl;
    private static ServiceConnection mConnection;

    public static void setUseService(boolean useService) {
        mUseService = useService;
    }

    public static boolean getUseService() {
        return mUseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITPDownloadProxy getTPDownloadProxy(int serviceType) {
        if (serviceType <= 0) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getTPDownloadProxy is invalid, serviceType:".concat(String.valueOf(serviceType)));
            return null;
        }
        if (mUseService) {
            if (mCanUseAIDL) {
                try {
                    return TPDownloadProxyFactory.getTPDownloadProxyService(serviceType);
                }
                catch (Throwable throwable) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getTPDownloadProxy failed, error:" + throwable.toString());
                    return null;
                }
            }
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getTPDownloadProxy failed, can't use aidl!");
            return null;
        }
        Object object = mMapObject;
        synchronized (object) {
            ITPDownloadProxy iTPDownloadProxy = mvTPDownloadProxyMap.get(serviceType);
            if (iTPDownloadProxy == null) {
                iTPDownloadProxy = new TPDownloadProxy(serviceType);
                mvTPDownloadProxyMap.put(serviceType, iTPDownloadProxy);
            }
            return iTPDownloadProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ITPDownloadProxy getTPDownloadProxyService(int serverType) {
        if (downloadProxyFactoryAidl != null) {
            TPDownloadProxyClient tPDownloadProxyClient;
            HashMap<Integer, TPDownloadProxyClient> hashMap = mvTPDownloadProxyClientMap;
            synchronized (hashMap) {
                tPDownloadProxyClient = mvTPDownloadProxyClientMap.get(serverType);
                if (tPDownloadProxyClient == null) {
                    try {
                        tPDownloadProxyClient = new TPDownloadProxyClient(downloadProxyFactoryAidl.getTPDownloadProxy(serverType));
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getTPDownloadProxyService failed, error:" + throwable.toString());
                    }
                }
                mvTPDownloadProxyClientMap.put(serverType, tPDownloadProxyClient);
            }
            return tPDownloadProxyClient;
        }
        TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getTPDownloadProxyService failed, aidl is null!");
        return null;
    }

    public static boolean ensurePlayManagerService(TPDLProxyBindServiceCallback callback) {
        Context context = TPDownloadProxyHelper.getContext();
        if (context == null) {
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "ensurePlayManagerService get context null!");
            return false;
        }
        mCallback = callback;
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "ensurePlayManagerService " + (context == null ? "context is null" : "ok"));
        try {
            Intent intent = new Intent(context, TPDownloadProxyService.class);
            context.startService(intent);
            if (!context.bindService(intent, mConnection, 1)) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "ensurePlayManagerService bind service failed!");
            }
            return true;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "ensurePlayManagerService failed, error:" + throwable.toString());
            return false;
        }
    }

    private static synchronized void setCanUseAIDL(boolean useAIDL) {
        mCanUseAIDL = useAIDL;
    }

    public static synchronized boolean getCanUseAIDL() {
        return mCanUseAIDL;
    }

    public static synchronized boolean isReadyForPlay() {
        if (!mUseService) {
            boolean bl = TPDownloadProxyNative.getInstance().isReadyForWork();
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "isReadyForPlay ret:".concat(String.valueOf(bl)));
            return bl;
        }
        if (!mCanUseAIDL) {
            return false;
        }
        boolean bl = false;
        if (downloadProxyFactoryAidl != null) {
            try {
                bl = downloadProxyFactoryAidl.isReadyForPlay();
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "isReadyForPlay failed, error:" + throwable.toString());
            }
        }
        return bl;
    }

    public static synchronized void setReadyForDownload(boolean readyForDownload) {
        mIsReadyForDownload = readyForDownload;
    }

    public static synchronized boolean isReadyForDownload() {
        if (!mUseService) {
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "isReadyForDownload ret:" + mIsReadyForDownload);
            return mIsReadyForDownload;
        }
        if (!mCanUseAIDL) {
            return false;
        }
        boolean bl = false;
        if (downloadProxyFactoryAidl != null) {
            try {
                bl = downloadProxyFactoryAidl.isReadyForDownload();
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "isReadyForDownload failed, error:" + throwable.toString());
            }
        }
        return bl;
    }

    public static synchronized boolean canUseService() {
        if (!mUseService) {
            return true;
        }
        if (!mCanUseAIDL) {
            return false;
        }
        if (downloadProxyFactoryAidl != null) {
            try {
                downloadProxyFactoryAidl.isReadyForPlay();
                return true;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "canUseService failed, error:" + throwable.toString());
            }
        }
        return false;
    }

    public static String getNativeVersion() {
        if (!mUseService) {
            return TPDownloadProxyNative.getInstance().getNativeVersion();
        }
        if (!mCanUseAIDL) {
            return TPDownloadProxyNative.getInstance().getNativeVersion();
        }
        if (downloadProxyFactoryAidl != null) {
            try {
                return downloadProxyFactoryAidl.getNativeVersion();
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getNativeVersion failed, error:" + throwable.toString());
            }
        }
        return TPDownloadProxyNative.getInstance().getNativeVersion();
    }

    static {
        mConnection = new ServiceConnection(){

            public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                downloadProxyFactoryAidl = TPDownloadProxyFactoryAidl.Stub.asInterface(iBinder);
                try {
                    for (Map.Entry entry : mvTPDownloadProxyClientMap.entrySet()) {
                        ((TPDownloadProxyClient)entry.getValue()).updateAidl(downloadProxyFactoryAidl.getTPDownloadProxy((Integer)entry.getKey()));
                    }
                }
                catch (Throwable throwable) {
                    TPDLProxyLog.i(TPDownloadProxyFactory.FILE_NAME, 0, "tpdlnative", "onServiceConnected failed, error:" + throwable.toString());
                }
                TPDLProxyLog.i(TPDownloadProxyFactory.FILE_NAME, 0, "tpdlnative", "on service connected!");
                if (downloadProxyFactoryAidl == null) {
                    TPDLProxyLog.i(TPDownloadProxyFactory.FILE_NAME, 0, "tpdlnative", "on service connected, aidl is null!");
                    return;
                }
                TPDLProxyLog.i(TPDownloadProxyFactory.FILE_NAME, 0, "tpdlnative", "on service connected, aidl not null!");
                TPDownloadProxyFactory.setCanUseAIDL(true);
                if (mCallback != null) {
                    mCallback.onBindSuccess();
                }
            }

            public final void onServiceDisconnected(ComponentName componentName) {
                TPDLProxyLog.i(TPDownloadProxyFactory.FILE_NAME, 0, "tpdlnative", "on service disconnected");
                downloadProxyFactoryAidl = null;
                TPDownloadProxyFactory.setCanUseAIDL(false);
                TPDownloadProxyFactory.ensurePlayManagerService(mCallback);
            }
        };
    }
}

