/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.drm;

import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.drm.ITPMediaDrm;
import com.tencent.thumbplayer.core.drm.TPMediaDrmFatalException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@RequiresApi(api=18)
public class TPDirectMediaDrm
implements ITPMediaDrm {
    private static final String TAG = "TPDirectMediaDrm";
    private MediaDrm mMediaDrm;
    private boolean mReleased = false;
    private ITPMediaDrm.OnEventListener mOnEventListener;
    private ITPMediaDrm.OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private ITPMediaDrm.OnExpirationUpdateListener mOnExpirationUpdateListener;

    public TPDirectMediaDrm(@NonNull UUID uUID) {
        try {
            this.mMediaDrm = new MediaDrm(uUID);
        }
        catch (UnsupportedSchemeException unsupportedSchemeException) {
            throw unsupportedSchemeException;
        }
        catch (Throwable throwable) {
            this.mReleased = true;
            TPNativeLog.printLog(4, TAG, "new MediaDrm failed, e:".concat(String.valueOf(throwable)));
        }
        TPNativeLog.printLog(2, TAG, "TPDirectMediaDrm constructor");
    }

    @Override
    @NonNull
    public synchronized byte[] openSession() {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.openSession();
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized void closeSession(@NonNull byte[] byArray) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.closeSession(byArray);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    @NonNull
    public synchronized MediaDrm.KeyRequest getKeyRequest(@NonNull byte[] byArray, @Nullable byte[] byArray2, @Nullable String string, int n2, @Nullable HashMap<String, String> hashMap) {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.getKeyRequest(byArray, byArray2, string, n2, hashMap);
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    @Nullable
    public synchronized byte[] provideKeyResponse(@NonNull byte[] byArray, @NonNull byte[] byArray2) {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.provideKeyResponse(byArray, byArray2);
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized MediaDrm.ProvisionRequest getProvisionRequest() {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.getProvisionRequest();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized void provideProvisionResponse(@NonNull byte[] byArray) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.provideProvisionResponse(byArray);
            return;
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void restoreKeys(@NonNull byte[] byArray, @NonNull byte[] byArray2) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.restoreKeys(byArray, byArray2);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void removeKeys(@NonNull byte[] byArray) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.removeKeys(byArray);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    @RequiresApi(api=23)
    public synchronized void setOnKeyStatusChangeListener(@Nullable ITPMediaDrm.OnKeyStatusChangeListener onKeyStatusChangeListener, @Nullable Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (this.mReleased) {
            return;
        }
        this.mOnKeyStatusChangeListener = onKeyStatusChangeListener;
        this.mMediaDrm.setOnKeyStatusChangeListener(new MediaDrm.OnKeyStatusChangeListener(){

            public void onKeyStatusChange(@NonNull MediaDrm mediaDrm, @NonNull byte[] byArray, @NonNull List<MediaDrm.KeyStatus> list, boolean bl) {
                ITPMediaDrm.OnKeyStatusChangeListener onKeyStatusChangeListener = TPDirectMediaDrm.this.mOnKeyStatusChangeListener;
                if (onKeyStatusChangeListener != null) {
                    onKeyStatusChangeListener.onKeyStatusChange(TPDirectMediaDrm.this, byArray, list, bl);
                }
            }
        }, handler);
    }

    @Override
    @RequiresApi(api=23)
    public synchronized void setOnExpirationUpdateListener(@Nullable ITPMediaDrm.OnExpirationUpdateListener onExpirationUpdateListener, @Nullable Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (this.mReleased) {
            return;
        }
        this.mOnExpirationUpdateListener = onExpirationUpdateListener;
        this.mMediaDrm.setOnExpirationUpdateListener(new MediaDrm.OnExpirationUpdateListener(){

            public void onExpirationUpdate(@NonNull MediaDrm mediaDrm, @NonNull byte[] byArray, long l2) {
                ITPMediaDrm.OnExpirationUpdateListener onExpirationUpdateListener = TPDirectMediaDrm.this.mOnExpirationUpdateListener;
                if (onExpirationUpdateListener != null) {
                    onExpirationUpdateListener.onExpirationUpdate(TPDirectMediaDrm.this, byArray, l2);
                }
            }
        }, handler);
    }

    @Override
    @NonNull
    public synchronized HashMap<String, String> queryKeyStatus(@NonNull byte[] byArray) {
        if (this.mReleased) {
            return new HashMap<String, String>();
        }
        try {
            return this.mMediaDrm.queryKeyStatus(byArray);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return new HashMap<String, String>();
        }
    }

    @Override
    @NonNull
    public synchronized String getPropertyString(@NonNull String string) {
        if (this.mReleased) {
            return "";
        }
        try {
            return this.mMediaDrm.getPropertyString(string);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return "";
        }
    }

    @Override
    public synchronized void setPropertyString(@NonNull String string, @NonNull String string2) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.setPropertyString(string, string2);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void close() {
        if (this.mReleased) {
            return;
        }
        this.mMediaDrm.setOnEventListener(null);
        this.mOnEventListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnExpirationUpdateListener(null, null);
        }
        this.mOnExpirationUpdateListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnKeyStatusChangeListener(null, null);
        }
        this.mOnKeyStatusChangeListener = null;
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                this.mMediaDrm.close();
            } else {
                this.mMediaDrm.release();
            }
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
        }
        this.mMediaDrm = null;
        this.mReleased = true;
    }
}

