/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.player;

import android.content.Context;
import android.os.Build;
import android.view.Surface;
import com.tencent.thumbplayer.core.common.TPAudioPassThroughPluginDetector;
import com.tencent.thumbplayer.core.common.TPFieldCalledByNative;
import com.tencent.thumbplayer.core.common.TPHeadsetPluginDetector;
import com.tencent.thumbplayer.core.common.TPMediaTrackDashFormat;
import com.tencent.thumbplayer.core.common.TPMediaTrackInfo;
import com.tencent.thumbplayer.core.common.TPNativeLibraryLoader;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.common.TPScreenRefreshRateDetector;
import com.tencent.thumbplayer.core.common.TPSystemInfo;
import com.tencent.thumbplayer.core.demuxer.ITPNativeDemuxerCallback;
import com.tencent.thumbplayer.core.player.ITPNativePlayerAudioFrameCallback;
import com.tencent.thumbplayer.core.player.ITPNativePlayerEventRecordCallback;
import com.tencent.thumbplayer.core.player.ITPNativePlayerMessageCallback;
import com.tencent.thumbplayer.core.player.ITPNativePlayerPostProcessFrameCallback;
import com.tencent.thumbplayer.core.player.ITPNativePlayerSubtitleFrameCallback;
import com.tencent.thumbplayer.core.player.ITPNativePlayerVideoFrameCallback;
import com.tencent.thumbplayer.core.player.TPDynamicStatisticParams;
import com.tencent.thumbplayer.core.player.TPGeneralPlayFlowParams;
import com.tencent.thumbplayer.core.player.TPNativePlayerHlsTag;
import com.tencent.thumbplayer.core.player.TPNativePlayerInitConfig;
import com.tencent.thumbplayer.core.player.TPNativePlayerProgramInfo;
import com.tencent.thumbplayer.core.player.TPNativePlayerUtils;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TPNativePlayer {
    @TPFieldCalledByNative
    private long mNativeContext;
    private int m_playerID = -1;
    private Context mContext = null;

    private native int _createPlayer();

    private native int _resetInitConfig();

    private native int _addInitConfigQueueInt(int var1, int var2);

    private native int _addInitConfigQueueString(int var1, String var2);

    private native int _setInitConfigInt(int var1, int var2);

    private native int _setInitConfigLong(int var1, long var2);

    private native int _setInitConfigFloat(int var1, float var2);

    private native int _setInitConfigBool(int var1, boolean var2);

    private native int _setInitConfigObject(int var1, Object var2);

    private native int _setInitConfigString(int var1, String var2);

    private native int _applyInitConfig();

    private native int _setDataSource(String var1);

    private native int _setDataSourceFd(int var1, long var2, long var4);

    private native int _setDataSourceWithHttpHeader(String var1, Object[] var2);

    private native int _prepare();

    private native int _prepareAsync();

    private native int _start();

    private native int _pause();

    private native int _resume();

    private native int _stop();

    private native int _reset();

    private native int _release();

    private native int _seekToAsync(int var1, int var2, long var3);

    private native int _switchDefinitionAsync(String var1, int var2, long var3);

    private native int _switchDefinitionAsyncWithHttpHeader(String var1, Object[] var2, int var3, long var4);

    private native int _setOptionLong(int var1, long var2, long var4);

    private native int _setOptionObject(int var1, Object var2);

    private native int _setAudioVolume(float var1);

    private native int _setAudioMute(boolean var1);

    private native int _setAudioNormalizeVolumeParams(String var1);

    private native int _setPlaybackRate(float var1);

    private native int _setVideoSurface(Surface var1);

    private native int _setVideoSurfaceWithType(Surface var1, int var2);

    private native int _setLoopback(boolean var1, long var2, long var4);

    private native int _setMessageCallback(Object var1);

    private native int _setAudioFrameCallback(Object var1);

    private native int _setVideoFrameCallback(Object var1);

    private native int _setSubtitleFrameCallback(Object var1);

    private native int _setPostProcessFrameCallback(Object var1);

    private native int _setDemuxerCallback(Object var1);

    private native int _setEventRecordCallback(Object var1);

    private native int _getPlayerID();

    private native long _getPropertyLong(int var1);

    private native String _getPropertyString(int var1);

    private native int _getVideoWidth();

    private native int _getVideoHeight();

    private native long _getDurationMs();

    private native long _getCurrentPositionMs();

    private native long _getBufferedDurationMs();

    private native long _getBufferedSize();

    private native int _addSubtitleTrackSource(String var1, String var2);

    private native int _addSubtitleTrackSourceWithHttpHeader(String var1, String var2, Object[] var3);

    private native int _addAudioTrackSource(String var1, String var2);

    private native int _addAudioTrackSourceWithHttpHeader(String var1, String var2, Object[] var3);

    private native int _getTrackCount();

    private native int _getTrackType(int var1);

    private native int _getContainerType(int var1);

    private native String _getTrackName(int var1);

    private native boolean _getTrackIsSelected(int var1);

    private native boolean _getTrackIsExclusive(int var1);

    private native boolean _getTrackIsInternal(int var1);

    private native int _selectTrackAsync(int var1, long var2);

    private native int _deselectTrackAsync(int var1, long var2);

    private native TPNativePlayerHlsTag _getTrackHlsTag(int var1);

    private native TPMediaTrackDashFormat _getTrackDashFormat(int var1);

    private native int _getProgramCount();

    private native int _selectProgramAsync(int var1, long var2);

    private native TPNativePlayerProgramInfo _getProgramInfo(int var1);

    private static native Object _getPlayerCoreParams(int var0);

    private native long _getDemuxerOffsetInFile();

    private native TPGeneralPlayFlowParams _getGeneralPlayFlowParams();

    private native TPDynamicStatisticParams _getDynamicStatisticParams(boolean var1);

    public TPNativePlayer(Context context) {
        this.mContext = context.getApplicationContext();
        TPNativeLibraryLoader.loadLibIfNeeded(context);
        try {
            this.m_playerID = this._createPlayer();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, "Failed to create native player:" + throwable.getMessage());
            throw new UnsupportedOperationException("Failed to create native player");
        }
        TPHeadsetPluginDetector.init(this.mContext);
        TPAudioPassThroughPluginDetector.init(this.mContext);
        if (Build.VERSION.SDK_INT >= 17) {
            TPScreenRefreshRateDetector.init(this.mContext);
        }
        TPSystemInfo.initAudioBestSettings(this.mContext);
    }

    public void setInitConfig(TPNativePlayerInitConfig tPNativePlayerInitConfig) {
        try {
            Object object;
            this._resetInitConfig();
            HashMap<Integer, Integer> hashMap = tPNativePlayerInitConfig.getIntMap();
            HashMap<Integer, Long> hashMap2 = tPNativePlayerInitConfig.getLongMap();
            HashMap<Integer, Float> hashMap3 = tPNativePlayerInitConfig.getFloatMap();
            HashMap<Integer, Boolean> hashMap4 = tPNativePlayerInitConfig.getBoolMap();
            HashMap<Integer, Vector<Integer>> hashMap5 = tPNativePlayerInitConfig.getQueueIntMap();
            HashMap<Integer, Object> hashMap6 = tPNativePlayerInitConfig.getObjectMap();
            HashMap<Integer, String> hashMap7 = tPNativePlayerInitConfig.getStringMap();
            for (Map.Entry<Integer, Integer> entry2 : hashMap.entrySet()) {
                this._setInitConfigInt(entry2.getKey(), entry2.getValue());
            }
            for (Map.Entry<Integer, Number> entry : hashMap2.entrySet()) {
                this._setInitConfigLong(entry.getKey(), (Long)entry.getValue());
            }
            for (Map.Entry<Integer, Number> entry : hashMap3.entrySet()) {
                this._setInitConfigFloat(entry.getKey(), ((Float)entry.getValue()).floatValue());
            }
            for (Map.Entry<Integer, Constable> entry : hashMap4.entrySet()) {
                this._setInitConfigBool(entry.getKey(), (Boolean)entry.getValue());
            }
            for (Map.Entry<Integer, Object> entry : hashMap6.entrySet()) {
                this._setInitConfigObject(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Integer, Object> entry : hashMap5.entrySet()) {
                Vector vector = (Vector)entry.getValue();
                if (vector == null) continue;
                object = vector.iterator();
                while (object.hasNext()) {
                    int n2 = (Integer)object.next();
                    this._addInitConfigQueueInt(entry.getKey(), n2);
                }
            }
            for (Map.Entry<Integer, Object> entry : hashMap7.entrySet()) {
                Object object2 = entry.getValue();
                this._setInitConfigString(entry.getKey(), object2 != null ? (String)object2 : null);
            }
            for (Map.Entry<Integer, Object> entry : tPNativePlayerInitConfig.getQueueStringMap().entrySet()) {
                object = (Vector)entry.getValue();
                if (object == null) continue;
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this._addInitConfigQueueString(entry.getKey(), string);
                }
            }
            this._applyInitConfig();
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return;
        }
    }

    public int setDataSource(String string) {
        try {
            return this._setDataSource(string);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setDataSource(String string, Map<String, String> map) {
        try {
            return this._setDataSourceWithHttpHeader(string, TPNativePlayerUtils.tpMapStringToStringArray(map));
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setDataSource(int n2, long l2, long l3) {
        try {
            return this._setDataSourceFd(n2, l2, l3);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int prepare() {
        try {
            return this._prepare();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int prepareAsync() {
        try {
            return this._prepareAsync();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int start() {
        try {
            return this._start();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int pause() {
        try {
            return this._pause();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int stop() {
        try {
            return this._stop();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public void reset() {
        try {
            this._reset();
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return;
        }
    }

    public void release() {
        try {
            this._release();
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return;
        }
    }

    public int seekToAsync(int n2, int n3, long l2) {
        try {
            return this._seekToAsync(n2, n3, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    @Deprecated
    public int switchDefinitionAsync(String string, long l2) {
        return this.switchDefinitionAsync(string, 0, l2);
    }

    public int switchDefinitionAsync(String string, int n2, long l2) {
        try {
            return this._switchDefinitionAsync(string, n2, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int switchDefinitionAsync(String string, Map<String, String> map, int n2, long l2) {
        try {
            return this._switchDefinitionAsyncWithHttpHeader(string, TPNativePlayerUtils.tpMapStringToStringArray(map), n2, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setOptionLong(int n2, long l2, long l3) {
        try {
            return this._setOptionLong(n2, l2, l3);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setOptionObject(int n2, Object object) {
        try {
            return this._setOptionObject(n2, object);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setAudioVolume(float f2) {
        try {
            return this._setAudioVolume(f2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setAudioMute(boolean bl) {
        try {
            return this._setAudioMute(bl);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setAudioNormalizeVolumeParams(String string) {
        try {
            return this._setAudioNormalizeVolumeParams(string);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setPlaybackRate(float f2) {
        try {
            return this._setPlaybackRate(f2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setVideoSurface(Surface surface) {
        try {
            return this._setVideoSurface(surface);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setVideoSurfaceWithType(Surface surface, int n2) {
        try {
            return this._setVideoSurfaceWithType(surface, n2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setLoopback(boolean bl, long l2, long l3) {
        try {
            return this._setLoopback(bl, l2, l3);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setMessageCallback(ITPNativePlayerMessageCallback iTPNativePlayerMessageCallback) {
        try {
            return this._setMessageCallback(iTPNativePlayerMessageCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setEventRecordCallback(ITPNativePlayerEventRecordCallback iTPNativePlayerEventRecordCallback) {
        try {
            return this._setEventRecordCallback(iTPNativePlayerEventRecordCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setAudioFrameCallback(ITPNativePlayerAudioFrameCallback iTPNativePlayerAudioFrameCallback) {
        try {
            return this._setAudioFrameCallback(iTPNativePlayerAudioFrameCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setVideoFrameCallback(ITPNativePlayerVideoFrameCallback iTPNativePlayerVideoFrameCallback) {
        try {
            return this._setVideoFrameCallback(iTPNativePlayerVideoFrameCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setSubtitleFrameCallback(ITPNativePlayerSubtitleFrameCallback iTPNativePlayerSubtitleFrameCallback) {
        try {
            return this._setSubtitleFrameCallback(iTPNativePlayerSubtitleFrameCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setDemuxerCallback(ITPNativeDemuxerCallback iTPNativeDemuxerCallback) {
        try {
            return this._setDemuxerCallback(iTPNativeDemuxerCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int setPostProcessFrameCallback(ITPNativePlayerPostProcessFrameCallback iTPNativePlayerPostProcessFrameCallback) {
        try {
            return this._setPostProcessFrameCallback(iTPNativePlayerPostProcessFrameCallback);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int getPlayerID() {
        try {
            return this._getPlayerID();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0;
        }
    }

    public long getPropertyLong(int n2) {
        try {
            return this._getPropertyLong(n2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0L;
        }
    }

    public String getPropertyString(int n2) {
        try {
            return this._getPropertyString(n2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return "";
        }
    }

    public int getVideoWidth() {
        try {
            return this._getVideoWidth();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0;
        }
    }

    public int getVideoHeight() {
        try {
            return this._getVideoHeight();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0;
        }
    }

    public long getDurationMs() {
        try {
            return this._getDurationMs();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0L;
        }
    }

    public long getCurrentPositionMs() {
        try {
            return this._getCurrentPositionMs();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0L;
        }
    }

    public long getBufferedDurationMs() {
        try {
            return this._getBufferedDurationMs();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0L;
        }
    }

    public long getBufferedSize() {
        try {
            return this._getBufferedSize();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 0L;
        }
    }

    public int addSubtitleTrackSource(String string, String string2) {
        try {
            return this._addSubtitleTrackSource(string, string2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int addSubtitleTrackSource(String string, String string2, Map<String, String> map) {
        try {
            return this._addSubtitleTrackSourceWithHttpHeader(string, string2, TPNativePlayerUtils.tpMapStringToStringArray(map));
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int addAudioTrackSource(String string, String string2) {
        try {
            return this._addAudioTrackSource(string, string2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int addAudioTrackSource(String string, String string2, Map<String, String> map) {
        try {
            return this._addAudioTrackSourceWithHttpHeader(string, string2, TPNativePlayerUtils.tpMapStringToStringArray(map));
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int selectTrackAsync(int n2, long l2) {
        try {
            return this._selectTrackAsync(n2, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int deselectTrackAsync(int n2, long l2) {
        try {
            return this._deselectTrackAsync(n2, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public TPMediaTrackInfo[] getTrackInfo() {
        try {
            TPMediaTrackInfo[] tPMediaTrackInfoArray = null;
            int n2 = this._getTrackCount();
            if (n2 > 0) {
                tPMediaTrackInfoArray = new TPMediaTrackInfo[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    tPMediaTrackInfoArray[i2] = new TPMediaTrackInfo();
                    tPMediaTrackInfoArray[i2].trackType = this._getTrackType(i2);
                    tPMediaTrackInfoArray[i2].contianerType = this._getContainerType(i2);
                    tPMediaTrackInfoArray[i2].trackName = this._getTrackName(i2);
                    tPMediaTrackInfoArray[i2].isSelected = this._getTrackIsSelected(i2);
                    tPMediaTrackInfoArray[i2].isExclusive = this._getTrackIsExclusive(i2);
                    tPMediaTrackInfoArray[i2].isInternal = this._getTrackIsInternal(i2);
                    if (tPMediaTrackInfoArray[i2].contianerType == 1) {
                        TPNativePlayerHlsTag tPNativePlayerHlsTag = this._getTrackHlsTag(i2);
                        tPMediaTrackInfoArray[i2].hlsTag.name = tPNativePlayerHlsTag.name;
                        tPMediaTrackInfoArray[i2].hlsTag.language = tPNativePlayerHlsTag.language;
                        tPMediaTrackInfoArray[i2].hlsTag.groupId = tPNativePlayerHlsTag.groupId;
                        tPMediaTrackInfoArray[i2].hlsTag.resolution = tPNativePlayerHlsTag.resolution;
                        tPMediaTrackInfoArray[i2].hlsTag.codecs = tPNativePlayerHlsTag.codecs;
                        tPMediaTrackInfoArray[i2].hlsTag.framerate = tPNativePlayerHlsTag.framerate;
                        tPMediaTrackInfoArray[i2].hlsTag.bandwidth = tPNativePlayerHlsTag.bandwidth;
                        continue;
                    }
                    if (tPMediaTrackInfoArray[i2].contianerType != 2) continue;
                    tPMediaTrackInfoArray[i2].dashFormat = this._getTrackDashFormat(i2);
                }
            }
            return tPMediaTrackInfoArray;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return null;
        }
    }

    public int getProgramCount() {
        try {
            return this._getProgramCount();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public int selectProgramAsync(int n2, long l2) {
        try {
            return this._selectProgramAsync(n2, l2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return 1000001;
        }
    }

    public TPNativePlayerProgramInfo[] getProgramInfo() {
        try {
            int n2 = this._getProgramCount();
            TPNativePlayerProgramInfo[] tPNativePlayerProgramInfoArray = new TPNativePlayerProgramInfo[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                tPNativePlayerProgramInfoArray[i2] = this._getProgramInfo(i2);
            }
            return tPNativePlayerProgramInfoArray;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return null;
        }
    }

    public Object getPlayerCoreParams(int n2) {
        return null;
    }

    public long getDemuxerOffsetInFile() {
        try {
            return this._getDemuxerOffsetInFile();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return -1L;
        }
    }

    public TPGeneralPlayFlowParams getGeneralPlayFlowParams() {
        try {
            return this._getGeneralPlayFlowParams();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return null;
        }
    }

    public TPDynamicStatisticParams getDynamicStatisticParams(boolean bl) {
        try {
            return this._getDynamicStatisticParams(bl);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return null;
        }
    }
}

