/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.musicdecoder;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.text.TextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::audio")
public class MediaCodecBridge {
    private static final String TAG = "MediaCodecBridge";
    private static final long TIMEOUT_MS = 2000L;
    private MediaCodec mMediaCodec;
    private MediaExtractor mMediaExtractor;
    private MediaFormat mFormat;
    private String mMime;
    private int mTrackIndex;
    private int mTrackCount;
    private int mRawDataSize;
    private long mLongestDurationUs;
    private boolean mDecodeEOS;

    public boolean initAndStart(String path) {
        if (this.mMediaCodec != null) {
            return false;
        }
        if (!this.initMediaExtractor(path)) {
            return false;
        }
        if (!this.initMediaCodec()) {
            return false;
        }
        try {
            this.mMediaCodec.start();
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Cannot start the audio codec", throwable);
            return false;
        }
        return true;
    }

    public boolean seekTo(long timeUs) {
        if (this.mMediaCodec == null || this.mMediaExtractor == null) {
            return false;
        }
        if (timeUs > this.mLongestDurationUs) {
            return false;
        }
        this.mMediaExtractor.seekTo(timeUs, 2);
        return true;
    }

    public ByteBuffer processFrame() {
        if (this.mMediaCodec == null) {
            return null;
        }
        int n2 = this.mMediaCodec.dequeueInputBuffer(2000L);
        if (n2 < 0) {
            return null;
        }
        ByteBuffer byteBuffer = this.mMediaCodec.getInputBuffers()[n2];
        int n3 = -1;
        if (byteBuffer != null) {
            n3 = this.mMediaExtractor.readSampleData(byteBuffer, 0);
        }
        if (n3 <= 0) {
            this.mMediaCodec.queueInputBuffer(n2, 0, 0, 0L, 4);
        } else {
            this.mRawDataSize += n3;
            this.mMediaCodec.queueInputBuffer(n2, 0, n3, this.mMediaExtractor.getSampleTime(), 0);
            this.mMediaExtractor.advance();
        }
        return this.drainData();
    }

    private ByteBuffer drainData() {
        for (int i2 = 0; i2 < 3; ++i2) {
            ByteBuffer byteBuffer = this.dequeueOutputBuffer();
            if (byteBuffer == null) continue;
            return byteBuffer;
        }
        return null;
    }

    private ByteBuffer dequeueOutputBuffer() {
        if (this.mDecodeEOS) {
            return null;
        }
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n2 = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(2000L));
            if (n2 == -1) {
                return null;
            }
            if (n2 == -3) {
                Log.i(TAG, "codec output buffers changed.", new Object[0]);
                return null;
            }
            if (n2 == -2) {
                this.mFormat = this.mMediaCodec.getOutputFormat();
                Log.i(TAG, "codec output format changed: " + this.mFormat, new Object[0]);
                return null;
            }
            if (n2 < 0) {
                Log.e(TAG, "unexpected result from dequeueOutputBuffer: ".concat(String.valueOf(n2)), new Object[0]);
                return null;
            }
            if ((bufferInfo.flags & 4) != 0) {
                Log.i(TAG, "Decode to EOS", new Object[0]);
                this.mDecodeEOS = true;
                return null;
            }
            ByteBuffer byteBuffer = LiteavSystemInfo.getSystemOSVersionInt() >= 21 ? this.mMediaCodec.getOutputBuffer(n2) : this.mMediaCodec.getOutputBuffers()[n2];
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(bufferInfo.size);
            byteBuffer2.put(byteBuffer);
            this.mMediaCodec.releaseOutputBuffer(n2, false);
            return byteBuffer2;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Failed to dequeue output buffer", throwable);
            return null;
        }
    }

    private boolean initMediaExtractor(String path) {
        boolean bl;
        block6: {
            if (TextUtils.isEmpty((CharSequence)path)) {
                return false;
            }
            this.mDecodeEOS = false;
            bl = false;
            try {
                int n2;
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(path);
                this.mTrackCount = this.mMediaExtractor.getTrackCount();
                for (n2 = 0; n2 < this.mTrackCount; ++n2) {
                    long l2;
                    MediaFormat mediaFormat = this.mMediaExtractor.getTrackFormat(n2);
                    String string = mediaFormat.getString("mime");
                    if (TextUtils.isEmpty((CharSequence)string) || !string.startsWith("audio/") || this.mLongestDurationUs >= (l2 = this.getDuration(mediaFormat))) continue;
                    this.mLongestDurationUs = l2;
                }
                if (this.mTrackIndex != 0) {
                    MediaCodecBridge mediaCodecBridge = this;
                    bl = mediaCodecBridge.selectTrack(mediaCodecBridge.mTrackIndex);
                    break block6;
                }
                for (n2 = 0; n2 < this.mTrackCount; ++n2) {
                    if (!this.selectTrack(n2)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                Log.e(TAG, "initMediaExtractor: ", throwable);
                this.mMediaExtractor = null;
                this.mFormat = null;
                this.mMime = null;
                bl = false;
            }
        }
        return bl;
    }

    private boolean selectTrack(int index) {
        MediaFormat mediaFormat = this.mMediaExtractor.getTrackFormat(index);
        String string = mediaFormat.getString("mime");
        if (!TextUtils.isEmpty((CharSequence)string) && string.startsWith("audio/")) {
            this.mMediaExtractor.selectTrack(index);
            this.mTrackIndex = index;
            this.mFormat = mediaFormat;
            this.mMime = string;
            return true;
        }
        return false;
    }

    private boolean initMediaCodec() {
        if (TextUtils.isEmpty((CharSequence)this.mMime) || this.mFormat == null) {
            return false;
        }
        try {
            this.mMediaCodec = MediaCodec.createDecoderByType((String)this.mMime);
            this.mMediaCodec.configure(this.mFormat, null, null, 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.mMediaCodec = null;
            return false;
        }
        return true;
    }

    private long getDuration(MediaFormat format) {
        if (format == null) {
            return -1L;
        }
        long l2 = -1L;
        try {
            l2 = format.getLong("durationUs");
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getDuration failed. ".concat(String.valueOf(throwable)), new Object[0]);
        }
        return l2;
    }

    public MediaFormat getOutputFormat() {
        return this.mFormat;
    }

    public long getLongestDuration() {
        return this.mLongestDurationUs;
    }

    public int getTrackCount() {
        return this.mTrackCount;
    }

    public boolean isDecodeEnd() {
        return this.mDecodeEOS;
    }

    public void setMusicTrack(int index) {
        if (this.mTrackIndex == index) {
            return;
        }
        this.mMediaExtractor.unselectTrack(this.mTrackIndex);
        if (!this.selectTrack(index)) {
            return;
        }
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        if (!this.initMediaCodec()) {
            return;
        }
        try {
            this.mMediaCodec.start();
            return;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Cannot start the audio codec", throwable);
            return;
        }
    }

    public int getTotalRawDataSize() {
        return this.mRawDataSize;
    }

    public void stop() {
        if (this.mMediaExtractor != null) {
            this.mMediaExtractor.release();
            this.mMediaExtractor = null;
        }
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        this.mDecodeEOS = false;
    }
}

