/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.txcplayer.ext.service;

import android.content.Context;
import android.view.MotionEvent;
import android.view.Surface;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.txcplayer.ITXVCubePlayer;
import com.tencent.liteav.txcplayer.common.c;
import com.tencent.liteav.txcplayer.ext.host.HostEngine;
import java.util.HashMap;

public class RenderProcessService {
    private static final String TAG = "HostEngine-RenderProcessService";
    private static RenderProcessService mInstance;
    private boolean mEnableRenderProcess = true;
    private int mCurrentModel = 0;

    private RenderProcessService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RenderProcessService getInstance() {
        if (mInstance != null) return mInstance;
        Class<RenderProcessService> clazz = RenderProcessService.class;
        synchronized (RenderProcessService.class) {
            if (mInstance != null) return mInstance;
            mInstance = new RenderProcessService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void checkInit(Context appContext) {
        HostEngine.getInstance().init(appContext);
    }

    public int getVodLicenseFeature() {
        if (HostEngine.getInstance().getAppContext() == null) {
            LiteavLog.w(TAG, "Host engine not init!!");
            return 0;
        }
        if (c.c()) {
            return 1;
        }
        return 0;
    }

    public boolean canRenderProcessWork() {
        if (!this.isEnableRenderProcess()) {
            LiteavLog.i(TAG, "[canRenderProcessWork],isEnableRenderProcess == false !!!");
            return false;
        }
        if (!HostEngine.getInstance().checkAndLoadPlugin(2)) {
            LiteavLog.i(TAG, "[canRenderProcessWork],isEnableRenderProcess == false !!!");
            return false;
        }
        if (this.mCurrentModel == 1 || this.mCurrentModel == 2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HostEngine.getInstance().sendSyncRequestToPlugin(2, 104, null, hashMap);
            boolean bl = false;
            Object v2 = hashMap.get("KEY_RET_PARAM1");
            if (v2 != null && v2 instanceof Boolean) {
                bl = (Boolean)v2;
            }
            if (!bl) {
                LiteavLog.i(TAG, "[canRenderProcessWork],IS_SUPPORT_RESOLUTION == false !!!");
                return false;
            }
        }
        LiteavLog.i(TAG, "[canRenderProcessWork], finally return true");
        return true;
    }

    public boolean connectPlayer(ITXVCubePlayer player, Surface surface) {
        if (player == null || surface == null) {
            LiteavLog.w(TAG, "connectPlayer invalid param player or surface is null !!!");
            return false;
        }
        if (!this.canRenderProcessWork()) {
            LiteavLog.w(TAG, "connectPlayer\uff0cpostProcessService does not need to work");
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", surface);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 100, hashMap, hashMap2);
        Boolean bl = Boolean.FALSE;
        Object v2 = hashMap2.get("KEY_RET_PARAM1");
        if (v2 != null && v2 instanceof Boolean) {
            bl = (Boolean)v2;
        }
        return bl;
    }

    public boolean setSurfaceBufferSize(ITXVCubePlayer player) {
        if (player == null) {
            LiteavLog.w(TAG, "setSurfaceBufferSize invalid param player is null !!!");
            return false;
        }
        if (!this.canRenderProcessWork()) {
            LiteavLog.w(TAG, "setSurfaceBufferSize\uff0cpostProcessService does not need to work");
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 101, hashMap, hashMap2);
        Boolean bl = Boolean.FALSE;
        Object v2 = hashMap2.get("KEY_RET_PARAM1");
        if (v2 != null && v2 instanceof Boolean) {
            bl = (Boolean)v2;
        }
        return bl;
    }

    public void stopRenderProcess(ITXVCubePlayer player) {
        if (!this.canRenderProcessWork()) {
            return;
        }
        if (player == null) {
            LiteavLog.w(TAG, "stopRenderProcess invalid param player is null !!!");
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 103, hashMap, null);
    }

    public void updateRenderProcessMode(ITXVCubePlayer player, int mode) {
        this.mCurrentModel = mode;
        if (!this.canRenderProcessWork()) {
            LiteavLog.w(TAG, "updatePostProcessMode\uff0cpostProcessService does not need to work");
            return;
        }
        if (player == null) {
            LiteavLog.w(TAG, "updatePostProcessMode invalid param player is null !!!");
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", mode);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 102, hashMap, null);
    }

    public boolean isEnableRenderProcess() {
        return this.mEnableRenderProcess;
    }

    public void setEnableRenderProcess(boolean enableRenderProcess) {
        LiteavLog.d(TAG, "setEnableRenderProcess: ".concat(String.valueOf(enableRenderProcess)));
        this.mEnableRenderProcess = enableRenderProcess;
    }

    public boolean onTouchEvent(ITXVCubePlayer player, MotionEvent motionEvent) {
        if (!this.canRenderProcessWork()) {
            return false;
        }
        if (this.mCurrentModel != 11 && this.mCurrentModel != 12) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", motionEvent);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 105, hashMap, hashMap2);
        boolean bl = false;
        Object v2 = hashMap2.get("KEY_RET_PARAM1");
        if (v2 != null && v2 instanceof Boolean) {
            bl = (Boolean)v2;
        }
        return bl;
    }
}

