/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.frame;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.tencent.liteav.base.a.b;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.i;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class PixelFrameFactory {
    private final String mTAG = "PixelFrameFactory_" + this.hashCode();
    private Object mSharedEGLContext = null;
    private EGLCore mRenderEGLCore;
    private EGLDisplay mCallerEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mCallerEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface mCallerEGLReadSurface = EGL14.EGL_NO_SURFACE;
    private EGLSurface mCallerEGLDrawSurface = EGL14.EGL_NO_SURFACE;
    private e mGLTexturePool;
    private i mPixelFrameRenderer;
    private final Size mLastFrameSize = new Size();
    private final b mThrottlers = new b();

    public synchronized PixelFrame create(int width, int height, int rotation, long timeStamp, int bufferType, int formatType, int textureId, Object eglContext, Object data, boolean isNeedCopyBuffer) {
        PixelFrame pixelFrame = new PixelFrame();
        pixelFrame.setWidth(width);
        pixelFrame.setHeight(height);
        pixelFrame.setRotation(l.a(rotation));
        pixelFrame.setTimestamp(timeStamp);
        pixelFrame.setGLContext(eglContext);
        pixelFrame.setTextureId(textureId);
        pixelFrame.setPixelBufferType(GLConstants.a.a(bufferType));
        pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.a(formatType));
        pixelFrame = pixelFrame.getPixelBufferType() == GLConstants.a.d || pixelFrame.getPixelBufferType() == GLConstants.a.a ? (isNeedCopyBuffer ? this.deepCopyDataToPixelFrame(pixelFrame, data) : this.shallowCopyDataToPixelFrame(pixelFrame, data)) : this.deepCopyTextureToPixelFrame(pixelFrame, eglContext);
        return pixelFrame;
    }

    public synchronized void release(PixelFrame pixelFrame) {
        if (pixelFrame != null) {
            pixelFrame.release();
        }
    }

    public synchronized void uninitOpenGLComponents() {
        if (this.mRenderEGLCore == null) {
            return;
        }
        LiteavLog.i(this.mTAG, "uninitOpenGLComponents");
        if (this.makeCurrent()) {
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.a();
                this.mGLTexturePool.b();
                this.mGLTexturePool = null;
            }
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a();
                this.mPixelFrameRenderer = null;
            }
        }
        EGLCore.destroy(this.mRenderEGLCore);
        this.mRenderEGLCore = null;
    }

    private PixelFrame shallowCopyDataToPixelFrame(PixelFrame pixelFrame, Object data) {
        if (data instanceof byte[]) {
            pixelFrame.setData((byte[])data);
        } else if (data instanceof ByteBuffer) {
            pixelFrame.setBuffer((ByteBuffer)data);
        }
        pixelFrame.retain();
        return pixelFrame;
    }

    private PixelFrame deepCopyDataToPixelFrame(PixelFrame pixelFrame, Object data) {
        if (data instanceof byte[]) {
            byte[] byArray = com.tencent.liteav.videobase.utils.e.a(((byte[])data).length);
            if (byArray == null) {
                return null;
            }
            System.arraycopy(data, 0, byArray, 0, byArray.length);
            pixelFrame.setData(byArray);
        } else if (data instanceof ByteBuffer) {
            ByteBuffer byteBuffer = com.tencent.liteav.videobase.utils.e.b(((ByteBuffer)data).capacity());
            if (byteBuffer == null) {
                return null;
            }
            ((ByteBuffer)data).rewind();
            byteBuffer.put((ByteBuffer)data);
            byteBuffer.rewind();
            pixelFrame.setBuffer(byteBuffer);
        }
        pixelFrame.retain();
        return pixelFrame;
    }

    private PixelFrame deepCopyTextureToPixelFrame(PixelFrame pixelFrame, Object sharedContext) {
        this.saveCallerEGLContext();
        GLES20.glFinish();
        if (!CommonUtil.equals(this.mSharedEGLContext, sharedContext)) {
            this.uninitOpenGLComponents();
            this.initRenderEGLContext(sharedContext);
        }
        if (!this.makeCurrent()) {
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "use origin texture when makeCurrent error", new Object[0]);
            pixelFrame.retain();
            return pixelFrame;
        }
        pixelFrame = this.copyTexture(pixelFrame);
        GLES20.glFinish();
        this.restoreCallerEGLContext();
        return pixelFrame;
    }

    private void saveCallerEGLContext() {
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        if (CommonUtil.equals(this.mCallerEGLContext, EGL14.EGL_NO_CONTEXT) || !CommonUtil.equals(eGLContext, this.mCallerEGLContext)) {
            this.mCallerEGLContext = eGLContext;
            this.mCallerEGLDisplay = EGL14.eglGetCurrentDisplay();
            this.mCallerEGLReadSurface = EGL14.eglGetCurrentSurface((int)12378);
            this.mCallerEGLDrawSurface = EGL14.eglGetCurrentSurface((int)12377);
        }
    }

    private void restoreCallerEGLContext() {
        if (!CommonUtil.equals(this.mCallerEGLContext, EGL14.EGL_NO_CONTEXT)) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mCallerEGLDisplay, (EGLSurface)this.mCallerEGLDrawSurface, (EGLSurface)this.mCallerEGLReadSurface, (EGLContext)this.mCallerEGLContext);
            return;
        }
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        EGL14.eglMakeCurrent((EGLDisplay)EGL14.eglGetCurrentDisplay(), (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT);
    }

    private PixelFrame copyTexture(PixelFrame pixelFrame) {
        if (this.mGLTexturePool == null) {
            this.mGLTexturePool = new e();
        }
        d d2 = this.mGLTexturePool.a(pixelFrame.getWidth(), pixelFrame.getHeight());
        if (this.mLastFrameSize.width != pixelFrame.getWidth() || this.mLastFrameSize.height != pixelFrame.getHeight()) {
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a();
                this.mPixelFrameRenderer = null;
            }
            this.mLastFrameSize.width = pixelFrame.getWidth();
            this.mLastFrameSize.height = pixelFrame.getHeight();
        }
        if (this.mPixelFrameRenderer == null) {
            this.mPixelFrameRenderer = new i(pixelFrame.getWidth(), pixelFrame.getHeight());
        }
        this.mPixelFrameRenderer.a(pixelFrame, GLConstants.GLScaleType.c, d2);
        pixelFrame = d2.a(pixelFrame.getGLContext());
        d2.release();
        return pixelFrame;
    }

    private void initRenderEGLContext(Object sharedContext) {
        if (this.mRenderEGLCore != null) {
            return;
        }
        LiteavLog.i(this.mTAG, "initRenderEGLContext");
        this.mSharedEGLContext = sharedContext;
        this.mRenderEGLCore = new EGLCore();
        try {
            this.mRenderEGLCore.initialize(sharedContext, null, 128, 128);
            return;
        }
        catch (com.tencent.liteav.videobase.egl.d d2) {
            this.mRenderEGLCore = null;
            LiteavLog.e(this.mThrottlers.a("initEGLCore"), this.mTAG, "create EGLCore failed.", d2);
            return;
        }
    }

    private boolean makeCurrent() {
        if (this.mRenderEGLCore == null) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentNull"), this.mTAG, "makeCurrent on mEGLCore is null", new Object[0]);
            return false;
        }
        try {
            this.mRenderEGLCore.makeCurrent();
        }
        catch (com.tencent.liteav.videobase.egl.d d2) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentError"), this.mTAG, "make current failed.", d2);
            return false;
        }
        return true;
    }
}

