/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class BitmapUtils {
    public static Bitmap createBitmap(Bitmap source, Matrix matrix, boolean sizeSameAsOriginBitmap) {
        if (source == null) {
            return null;
        }
        source.getConfig();
        if (sizeSameAsOriginBitmap) {
            Bitmap bitmap = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            new Canvas(bitmap).drawBitmap(source, matrix, paint);
            return bitmap;
        }
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap createBitmapFromBuffer(ByteBuffer buffer, int width, int height) {
        try {
            buffer.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            return bitmap;
        }
        catch (Throwable throwable) {
            LiteavLog.e("BitmapUtils", "build bitmap failed.", throwable);
            return null;
        }
    }

    public static void saveBitmapToFile(Bitmap bitmap, String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            try {
                LiteavLog.e("BitmapUtils", "save jpg file failed.", exception);
            }
            catch (Throwable throwable) {
                f.a(fileOutputStream);
                throw throwable;
            }
            f.a(fileOutputStream);
            return;
        }
        f.a(fileOutputStream);
        return;
    }
}

