/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.adapter.strategy.utils;

import android.text.TextUtils;
import android.util.SparseArray;
import com.tencent.thumbplayer.adapter.a.b.c;
import com.tencent.thumbplayer.adapter.strategy.utils.TPNativeKeyMap;
import com.tencent.thumbplayer.api.TPCommonEnum;
import com.tencent.thumbplayer.api.TPOptionalID;
import com.tencent.thumbplayer.tplayer.TPOptionalIDInternal;
import com.tencent.thumbplayer.utils.TPLogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TPNativeKeyMapUtil {
    private static final String TAG = "TPNativeKeyMapUtil";
    private static final String REVERSE_MAP_NAME_SUFFIX = ".reverseMap";
    private static final Map<String, Map<Number, Number>> sNameToMap = new ConcurrentHashMap<String, Map<Number, Number>>();
    private static final Map<Class<?>, AtomicBoolean> sHasThisAnnotationInitMap = new ConcurrentHashMap();
    private static final SparseArray<c.a> sToNativeOptionalIdMap = new SparseArray();
    private static final SparseArray<String> sOptionalIdKeyToNameMap = new SparseArray();
    private static final AtomicBoolean sHasOptionalIdMapInit = new AtomicBoolean(false);

    public static String getOptionalIdName(int n2) {
        if (!sHasOptionalIdMapInit.get()) {
            TPNativeKeyMapUtil.buildOptionalIdMap();
        }
        return (String)sOptionalIdKeyToNameMap.get(n2, (Object)"");
    }

    public static void init() {
        long l2 = System.currentTimeMillis();
        Class<?>[] classArray = TPNativeKeyMap.class.getDeclaredClasses();
        TPLogUtil.i(TAG, "init BiDirectionMap for tp&native value");
        Class<?>[] classArray2 = classArray;
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz = classArray2[i2];
            if (!clazz.isAnnotation() || !Modifier.isPublic(clazz.getModifiers()) || clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class) == null) continue;
            TPNativeKeyMapUtil.buildBiDirectionMapForAnnotation(clazz);
        }
        long l3 = System.currentTimeMillis();
        TPLogUtil.i(TAG, "init cost time=" + (l3 - l2));
    }

    public static <T extends Annotation> int toNativeIntValue(Class<T> clazz, int n2) {
        Map<Number, Number> map = TPNativeKeyMapUtil.getMapForAnnotation(clazz, true);
        if (!map.containsKey(n2)) {
            TPLogUtil.e(TAG, "toNativeValue, tpValue=" + n2 + "return default value, clazz" + clazz);
            return (int)clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class).nativeDefValue();
        }
        return map.get(n2).intValue();
    }

    public static <T extends Annotation> int toTPIntValue(Class<T> clazz, int n2) {
        Map<Number, Number> map = TPNativeKeyMapUtil.getMapForAnnotation(clazz, false);
        if (!map.containsKey(n2)) {
            TPLogUtil.i(TAG, "toTPValue, nativeValue=" + n2 + "return default value, clazz" + clazz);
            return (int)clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class).tpDefValue();
        }
        return map.get(n2).intValue();
    }

    public static <T extends Annotation> Set<Map.Entry<Number, Number>> getEntrySetOfToNativeMap(Class<T> clazz) {
        Map<Number, Number> map = TPNativeKeyMapUtil.getMapForAnnotation(clazz, true);
        return new HashSet<Map.Entry<Number, Number>>(map.entrySet());
    }

    public static <T extends Annotation> Set<Map.Entry<Number, Number>> getEntrySetOfToTPMap(Class<T> clazz) {
        Map<Number, Number> map = TPNativeKeyMapUtil.getMapForAnnotation(clazz, false);
        return new HashSet<Map.Entry<Number, Number>>(map.entrySet());
    }

    public static <T extends Annotation> long toNativeLongValue(Class<T> clazz, long l2) {
        Map<Number, Number> map = TPNativeKeyMapUtil.getMapForAnnotation(clazz, true);
        if (!map.containsKey(l2)) {
            TPLogUtil.e(TAG, "toNativeValue, tpValue=" + l2 + "return default value, clazz" + clazz);
            return clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class).nativeDefValue();
        }
        return map.get(l2).longValue();
    }

    public static <T extends Annotation> long toTPLongValue(Class<T> clazz, long l2) {
        Map<Number, Number> map = TPNativeKeyMapUtil.getMapForAnnotation(clazz, false);
        if (!map.containsKey(l2)) {
            TPLogUtil.i(TAG, "toTPValue, nativeValue=" + l2 + "return default value, clazz" + clazz);
            return clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class).tpDefValue();
        }
        return map.get(l2).longValue();
    }

    private static <T extends Annotation> Map<Number, Number> getMapForAnnotation(Class<T> clazz, boolean bl) {
        String string = TPNativeKeyMapUtil.getMapKey(clazz, bl);
        Map<Number, Number> map = sNameToMap.get(string);
        if (map == null || map.size() == 0) {
            TPNativeKeyMapUtil.buildBiDirectionMapForAnnotation(clazz);
            map = sNameToMap.get(string);
        }
        if (clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class) == null) {
            throw new IllegalArgumentException(clazz.getSimpleName() + "has not SearchConfig annotation");
        }
        if (map == null || map.size() == 0) {
            throw new IllegalStateException(clazz.getSimpleName() + " is null after buildBiDirectionMap");
        }
        return map;
    }

    private static <T extends Annotation> String getMapKey(Class<T> clazz, boolean bl) {
        String string = clazz.getCanonicalName();
        if (bl) {
            return string;
        }
        return string + REVERSE_MAP_NAME_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Annotation> void buildBiDirectionMapForAnnotation(Class<T> clazz) {
        AtomicBoolean atomicBoolean;
        TPLogUtil.i(TAG, "buildBiDirectionMapForAnnotation, clazz=".concat(String.valueOf(clazz)));
        Object object = sHasThisAnnotationInitMap;
        synchronized (object) {
            atomicBoolean = sHasThisAnnotationInitMap.get(clazz);
            if (atomicBoolean == null) {
                atomicBoolean = new AtomicBoolean(false);
                sHasThisAnnotationInitMap.put(clazz, atomicBoolean);
            }
        }
        object = atomicBoolean;
        synchronized (object) {
            if (atomicBoolean.get()) {
                TPLogUtil.i(TAG, "className=" + clazz.getSimpleName() + " already init");
                return;
            }
            TPNativeKeyMapUtil.searchClassToFillMap(clazz);
            atomicBoolean.set(true);
            return;
        }
    }

    private static <T extends Annotation> void searchClassToFillMap(Class<T> clazz) {
        String string = TPNativeKeyMapUtil.getMapKey(clazz, true);
        Map<Number, Number> map = sNameToMap.get(string);
        String string2 = TPNativeKeyMapUtil.getMapKey(clazz, false);
        Map<Number, Number> map2 = sNameToMap.get(string2);
        if (map == null || map2 == null) {
            map = new HashMap<Number, Number>();
            sNameToMap.put(string, map);
            map2 = new HashMap<Number, Number>();
            sNameToMap.put(string2, map2);
        }
        try {
            TPNativeKeyMap.SearchConfig searchConfig = clazz.getAnnotation(TPNativeKeyMap.SearchConfig.class);
            if (searchConfig == null) {
                throw new IllegalArgumentException(clazz.getCanonicalName() + "has not SearchConfig annotation");
            }
            Class<?> clazz2 = searchConfig.searchClass();
            for (Field field : clazz2.getDeclaredFields()) {
                Number number;
                Number number2;
                T t2;
                String string3 = "";
                if (searchConfig.valueClass() == Integer.TYPE) {
                    string3 = "int";
                } else if (searchConfig.valueClass() == Long.TYPE) {
                    string3 = "long";
                }
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    throw new IllegalArgumentException("\u4ee3\u7801\u8fd8\u6ca1\u5b9e\u73b0\u5bf9" + searchConfig.valueClass().getName() + "\u7684\u652f\u6301");
                }
                if (!field.getType().toString().equals(string3) || (t2 = field.getAnnotation(clazz)) == null) continue;
                field.setAccessible(true);
                Method method = clazz.getDeclaredMethod("value", new Class[0]);
                method.setAccessible(true);
                if (searchConfig.valueClass() == Integer.TYPE) {
                    number2 = (Integer)method.invoke(t2, new Object[0]);
                    number = field.getInt(clazz2);
                } else if (searchConfig.valueClass() == Long.TYPE) {
                    number2 = (Long)method.invoke(t2, new Object[0]);
                    number = field.getLong(clazz2);
                } else {
                    throw new IllegalArgumentException("\u4ee3\u7801\u8fd8\u6ca1\u5b9e\u73b0\u5bf9" + searchConfig.valueClass().getName() + "\u7684\u652f\u6301");
                }
                TPNativeKeyMapUtil.checkFillMapValidity(clazz, map, map2, clazz2, number2, number);
                map.put(number, number2);
                map2.put(number2, number);
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            TPLogUtil.e(TAG, illegalAccessException);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            TPLogUtil.e(TAG, noSuchMethodException);
            throw new IllegalStateException("com.tencent.thumbplayer.adapter.strategy.utils.TPNativeKeyMap\u4e0b\u6240\u6709\u5143\u7d20\u9700\u8981\u52a0\u5230\u6df7\u6dc6\u4e2d, \u5e76\u4e14\u6bcf\u4e2aMapXXX\u6ce8\u89e3\u9700\u8981\u6709value\u65b9\u6cd5");
        }
        catch (InvocationTargetException invocationTargetException) {
            TPLogUtil.e(TAG, invocationTargetException);
            return;
        }
    }

    private static <T extends Annotation> void checkFillMapValidity(Class<T> clazz, Map<Number, Number> map, Map<Number, Number> map2, Class<?> clazz2, Number number, Number number2) {
        if (map.containsKey(number2)) {
            throw new IllegalStateException(clazz2.getName() + " \u914d\u7f6e\u4e86\u91cd\u590d\u7684\u6210\u5458\u53d8\u91cf\uff0c\u6ce8\u89e3=" + clazz.getName() + " \u6210\u5458\u53d8\u91cf\u503c=" + number2 + " \u8bf7\u67e5\u627e\u4e00\u4e0b\u4f7f\u7528\u8fd9\u4e2a\u6ce8\u89e3@" + clazz.getName() + "\u7684\u54ea\u4e24\u4e2a\u6210\u5458\u53d8\u91cf\u503c\u76f8\u7b49");
        }
        if (map2.containsKey(number)) {
            throw new IllegalStateException(clazz2.getName() + " \u914d\u7f6e\u4e86\u91cd\u590d\u7684\u6ce8\u89e3\u503c\uff0c\u6ce8\u89e3=" + clazz.getName() + " \u6210\u5458\u53d8\u91cf\u503c=" + number2 + " \u8bf7\u67e5\u627e\u4e00\u4e0b@" + clazz.getName() + "(\u8fd9\u4e2a\u503c)\u5728\u54ea\u91cc\u91cd\u590d\u4e86");
        }
    }

    public static c.a convertToNativeOptionalId(@TPCommonEnum.TPOptionalId int n2) {
        if (sToNativeOptionalIdMap.size() == 0) {
            TPNativeKeyMapUtil.buildOptionalIdMap();
        }
        return (c.a)sToNativeOptionalIdMap.get(n2, (Object)new c.a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildOptionalIdMap() {
        AtomicBoolean atomicBoolean = sHasOptionalIdMapInit;
        synchronized (atomicBoolean) {
            if (sToNativeOptionalIdMap.size() != 0) {
                return;
            }
            if (sHasOptionalIdMapInit.get()) {
                throw new IllegalStateException("\u6784\u5efaMap\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u3010--keep class com.tencent.thumbplayer.api.** { *; }\u3011\u662f\u5426\u52a0\u5165\u53cd\u6df7\u6dc6");
            }
            TPNativeKeyMapUtil.buildNativeInitConfigMap();
            TPNativeKeyMapUtil.buildPublicToNativeOptionalIdMap();
            TPNativeKeyMapUtil.buildPrivateToNativeOptionalIdMap();
            sHasOptionalIdMapInit.set(true);
            return;
        }
    }

    private static void buildNativeInitConfigMap() {
        try {
            Class<?> clazz = Class.forName(TPOptionalID.class.getName());
            for (Field field : clazz.getDeclaredFields()) {
                TPNativeKeyMap.MapInitConfig mapInitConfig;
                if (!field.getType().toString().equals("int") || (mapInitConfig = field.getAnnotation(TPNativeKeyMap.MapInitConfig.class)) == null) continue;
                int n2 = field.getInt(clazz);
                sOptionalIdKeyToNameMap.put(n2, (Object)mapInitConfig.keyName());
                if (mapInitConfig.value() == -1) {
                    sToNativeOptionalIdMap.put(n2, (Object)new c.a());
                    continue;
                }
                field.setAccessible(true);
                sToNativeOptionalIdMap.put(n2, (Object)new c.a(mapInitConfig.type(), mapInitConfig.value()));
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            TPLogUtil.e(TAG, classNotFoundException);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            TPLogUtil.e(TAG, illegalAccessException);
            return;
        }
    }

    private static void buildPublicToNativeOptionalIdMap() {
        try {
            TPNativeKeyMapUtil.buildNativeOptionalIdToMapInternal(Class.forName(TPOptionalID.class.getName()));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            TPLogUtil.e(TAG, classNotFoundException);
            return;
        }
    }

    private static void buildPrivateToNativeOptionalIdMap() {
        try {
            TPNativeKeyMapUtil.buildNativeOptionalIdToMapInternal(Class.forName(TPOptionalIDInternal.class.getName()));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            TPLogUtil.e(TAG, classNotFoundException);
            return;
        }
    }

    private static void buildNativeOptionalIdToMapInternal(Class<?> clazz) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                TPNativeKeyMap.MapOptionalId mapOptionalId;
                if (!field.getType().toString().equals("int") || (mapOptionalId = field.getAnnotation(TPNativeKeyMap.MapOptionalId.class)) == null) continue;
                int n2 = field.getInt(clazz);
                sOptionalIdKeyToNameMap.put(n2, (Object)mapOptionalId.keyName());
                if (mapOptionalId.value() == -1) {
                    sToNativeOptionalIdMap.put(n2, (Object)new c.a());
                    continue;
                }
                field.setAccessible(true);
                sToNativeOptionalIdMap.put(n2, (Object)new c.a(mapOptionalId.type(), mapOptionalId.value()));
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            TPLogUtil.e(TAG, illegalAccessException);
            return;
        }
    }
}

