/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.common;

import android.app.ActivityManager;
import android.content.Context;
import android.media.AudioManager;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.regex.Pattern;

public class TPSystemInfo {
    public static final int CPU_HW_OTHER = -1;
    public static final int CPU_HW_QUALCOMM = 0;
    public static final int CPU_HW_MTK = 1;
    public static final int CPU_HW_HISI = 2;
    public static final int CPU_HW_SAMSUNG = 3;
    public static final int CHIP_UNKNOW = 0;
    public static final int CHIP_X86 = 1;
    public static final int CHIP_MIPS = 2;
    public static final int CHIP_ARM_V5 = 3;
    public static final int CHIP_ARM_V6 = 4;
    public static final int CHIP_ARM_V7_NO_NENO = 5;
    public static final int CHIP_ARM_V7_NENO = 6;
    public static final int CHIP_ARM_AARCH64 = 7;
    public static final int CHIP_ARM_LATER = 50;
    public static final String KEY_PROPERTY_MODEL = "ro.product.model";
    public static final String KEY_PROPERTY_MANUFACTURER = "ro.product.manufacturer";
    public static final String KEY_PROPERTY_VERSION_RELEASE = "ro.build.version.release";
    public static final String KEY_PROPERTY_DEVICE = "ro.product.device";
    public static final String KEY_PROPERTY_BOARD = "ro.product.board";
    private static String sDeviceName = "";
    private static String sDeviceManufacturer = "";
    private static String sOSVersion = "";
    private static String sProductDevice = "";
    private static String sProductBoard = "";
    private static String sProcessorName = "N/A";
    private static String sFeature = "";
    private static String sCpuHardware = "";
    private static int sCpuArchitecture = 0;
    public static int sScreenWidth;
    public static int sScreenHeight;
    private static long sAppInstallTime;
    private static int sCpuHWProducter;
    private static int sCpuHWProductIdx;
    private static int sAudioBestSampleRate;
    private static int sAudioBestFramesPerBust;
    private static final String[][] sCpuPerfList;
    private static long sMaxCpuFreq;
    private static long sCurrentCpuFreq;
    private static int sNumOfCores;
    private static int sCpuArch;
    private static int sOpenGLVersion;
    public static final int SDK_INT;

    private static void parseCpuInfoLine(String string) {
        if (string.contains("aarch64") || string.contains("AArch64")) {
            sCpuArchitecture = 64;
        }
        if (string.startsWith("Processor")) {
            int n2 = string.indexOf(58);
            if (n2 > 1) {
                sProcessorName = string.substring(n2 + 1, string.length());
                sProcessorName = sProcessorName.trim();
            }
            return;
        }
        if (string.startsWith("CPU architecture")) {
            if (sCpuArchitecture == 0) {
                int n3 = string.indexOf(58);
                if (n3 > 1) {
                    String string2 = string.substring(n3 + 1, string.length()).trim();
                    if (string2.length() > 0 && string2.length() < 2) {
                        sCpuArchitecture = (int)Long.parseLong(string2);
                        return;
                    }
                    if (string2.length() > 1) {
                        sCpuArchitecture = (int)Long.parseLong(string2.substring(0, 1));
                    }
                }
                return;
            }
        } else {
            int n4;
            if (string.startsWith("Features")) {
                int n5 = string.indexOf(58);
                if (n5 > 1) {
                    sFeature = string.substring(n5 + 1, string.length()).trim();
                }
                return;
            }
            if (string.startsWith("Hardware") && (n4 = string.indexOf(58)) > 1) {
                sCpuHardware = string.substring(n4 + 1, string.length()).trim().replace(" ", "");
                TPNativeLog.printLog(2, "hardware " + sCpuHardware);
                TPSystemInfo.getCpuHWProductIndex(sCpuHardware);
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void getCpuInfo() {
        String string;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        inputStreamReader = new InputStreamReader((InputStream)new FileInputStream("/proc/cpuinfo"), "UTF-8");
        bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
            TPSystemInfo.parseCpuInfoLine(string);
        }
        try {
            inputStreamReader.close();
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            TPNativeLog.printLog(4, iOException.getMessage());
            return;
        }
        catch (Throwable throwable) {
            try {
                sCpuHardware = "Unknown";
                sCpuArchitecture = 0;
            }
            catch (Throwable throwable2) {
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    TPNativeLog.printLog(4, iOException.getMessage());
                }
                throw throwable2;
            }
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                return;
            }
            catch (IOException iOException) {
                TPNativeLog.printLog(4, iOException.getMessage());
                return;
            }
        }
    }

    private static int getCpuHWProducer(String string) {
        if (string.isEmpty()) {
            return -1;
        }
        if (string.contains("Exynos") || string.contains("SMDK") || string.contains("S5L8900") || string.contains("S5PC100")) {
            return 3;
        }
        if (string.contains("Kirin") || string.contains("K3V")) {
            return 2;
        }
        if (string.contains("MSM") || string.contains("APQ") || string.contains("QSD") || string.contains("SDM") || string.contains("SM")) {
            return 0;
        }
        if (string.contains("MT6")) {
            return 1;
        }
        return -1;
    }

    public static int getCpuHWProducter(String string) {
        if (sCpuHWProducter < 0) {
            sCpuHWProducter = TPSystemInfo.getCpuHWProducer(string);
        }
        return sCpuHWProducter;
    }

    public static int getCpuHWProductIndex(String string) {
        int n2 = -1;
        if (sCpuHWProducter < 0) {
            sCpuHWProducter = TPSystemInfo.getCpuHWProducer(string);
        }
        if (sCpuHWProducter >= 0 && sCpuHWProductIdx < 0) {
            String[] stringArray = sCpuPerfList[sCpuHWProducter];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string.contains(stringArray[i2])) continue;
                int n3 = i2;
                if (-1 == n2) {
                    n2 = n3;
                    continue;
                }
                if (stringArray[i2].length() <= stringArray[n2].length()) continue;
                n2 = n3;
            }
            sCpuHWProductIdx = n2;
        }
        return sCpuHWProductIdx;
    }

    public static int getCpuHWProductIndex(int n2, String string) {
        if (n2 < 0 || n2 >= sCpuPerfList.length) {
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -1;
        }
        String[] stringArray = sCpuPerfList[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!TextUtils.equals((CharSequence)string, (CharSequence)stringArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    /*
     * Loose catch block
     */
    public static long getMaxCpuFreq() {
        long l2;
        block24: {
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            block23: {
                String string;
                block22: {
                    if (-1L != sMaxCpuFreq) {
                        return sMaxCpuFreq;
                    }
                    inputStreamReader = null;
                    bufferedReader = null;
                    l2 = 0L;
                    String string2 = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
                    inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8");
                    bufferedReader = new BufferedReader(inputStreamReader);
                    string = bufferedReader.readLine();
                    if (string != null) break block22;
                    inputStreamReader.close();
                    bufferedReader.close();
                    try {
                        inputStreamReader.close();
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        TPNativeLog.printLog(4, iOException.getMessage());
                    }
                    return 0L;
                }
                String string3 = string.trim();
                if (string3.length() <= 0) break block23;
                l2 = Long.parseLong(string3);
            }
            try {
                inputStreamReader.close();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                TPNativeLog.printLog(4, iOException.getMessage());
            }
            break block24;
            catch (IOException iOException) {
                l2 = 0L;
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block24;
                }
                catch (IOException iOException2) {
                    TPNativeLog.printLog(4, iOException2.getMessage());
                }
                break block24;
            }
            catch (Throwable throwable) {
                l2 = 0L;
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block24;
                }
                catch (IOException iOException) {
                    TPNativeLog.printLog(4, iOException.getMessage());
                }
                break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    TPNativeLog.printLog(4, iOException.getMessage());
                }
                throw throwable;
            }
        }
        sMaxCpuFreq = l2;
        TPNativeLog.printLog(2, "MaxCpuFreq " + sMaxCpuFreq);
        return l2;
    }

    /*
     * Exception decompiling
     */
    public static long getCurrentCpuFreq() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 32[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getNumCores() {
        if (-1 != sNumOfCores) {
            return sNumOfCores;
        }
        try {
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]", file.getName());
                }
            }
            File[] fileArray = new File("/sys/devices/system/cpu/").listFiles(new CpuFilter());
            if (fileArray == null) {
                sNumOfCores = 1;
                return 1;
            }
            sNumOfCores = fileArray.length;
            TPNativeLog.printLog(2, "core num " + sNumOfCores);
            return sNumOfCores;
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, exception.getMessage());
            sNumOfCores = 1;
            return 1;
        }
    }

    public static synchronized String getDeviceName() {
        if (TextUtils.isEmpty((CharSequence)sDeviceName)) {
            sDeviceName = Build.MODEL;
        }
        return sDeviceName;
    }

    public static synchronized void setDeviceName(String string) {
        sDeviceName = string;
    }

    public static String getDeviceManufacturer() {
        if (TextUtils.isEmpty((CharSequence)sDeviceManufacturer)) {
            sDeviceManufacturer = Build.MANUFACTURER;
        }
        return sDeviceManufacturer;
    }

    public static String getProductDevice() {
        if (TextUtils.isEmpty((CharSequence)sProductDevice)) {
            sProductDevice = Build.DEVICE;
        }
        return sProductDevice;
    }

    public static String getProductBoard() {
        if (TextUtils.isEmpty((CharSequence)sProductBoard)) {
            sProductBoard = Build.BOARD;
        }
        return sProductBoard;
    }

    public static String getCpuHarewareName() {
        if (TextUtils.isEmpty((CharSequence)sCpuHardware)) {
            TPSystemInfo.getCpuInfo();
        }
        return sCpuHardware;
    }

    public static int getCpuArchFromId(int n2) {
        int n3;
        switch (n2) {
            case 5: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 4;
                break;
            }
            case 7: {
                n3 = 6;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 64: {
                n3 = 7;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    public static boolean isARMV5Whitelist() {
        return TPSystemInfo.getDeviceName().equals("XT882") || TPSystemInfo.getDeviceName().equals("ME860") || TPSystemInfo.getDeviceName().equals("MB860") || TPSystemInfo.getDeviceName().equals("Lenovo P70") || TPSystemInfo.getDeviceName().equals("Lenovo A60") || TPSystemInfo.getDeviceName().equals("Lenovo A366t");
    }

    public static int getCpuArchitecture() {
        if (-1 != sCpuArch) {
            return sCpuArch;
        }
        TPNativeLog.printLog(2, "getCpuArchitecture Build.CPU_ABI: " + Build.CPU_ABI);
        if (Build.CPU_ABI.contains("arm64-v8a")) {
            sCpuArch = 7;
            return 7;
        }
        if (Build.CPU_ABI != null && (Build.CPU_ABI.contains("x86") || Build.CPU_ABI.contains("X86"))) {
            sCpuArch = 1;
        } else if (Build.CPU_ABI != null && (Build.CPU_ABI.contains("mips") || Build.CPU_ABI.contains("Mips"))) {
            sCpuArch = 2;
        } else {
            if (sCpuArchitecture == 0) {
                TPSystemInfo.getCpuInfo();
            }
            TPNativeLog.printLog(2, "getCpuArchitecture mCpuArchitecture:" + sCpuArchitecture);
            if (!TextUtils.isEmpty((CharSequence)sCpuHardware) && sCpuHardware.contains("MSM8994")) {
                sCpuArch = 7;
                return 7;
            }
            if (TPSystemInfo.isARMV5Whitelist()) {
                sCpuArch = 3;
                return 3;
            }
            if (!TextUtils.isEmpty((CharSequence)sProcessorName) && sProcessorName.contains("ARMv6")) {
                sCpuArch = 4;
                return 4;
            }
            if (!TextUtils.isEmpty((CharSequence)sProcessorName) && sProcessorName.contains("AArch64")) {
                sCpuArch = 7;
                return 7;
            }
            if (!(sCpuArchitecture != 7 || TextUtils.isEmpty((CharSequence)sFeature) || sFeature.contains("neon") || sFeature.contains("asimd"))) {
                sCpuArch = 4;
                return 4;
            }
            sCpuArch = TPSystemInfo.getCpuArchFromId(sCpuArchitecture);
        }
        return sCpuArch;
    }

    private static boolean hasMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static String getOsVersion() {
        if (TextUtils.isEmpty((CharSequence)sOSVersion)) {
            sOSVersion = Build.VERSION.RELEASE;
        }
        return sOSVersion;
    }

    public static int getScreenWidth(Context context) {
        if (context == null) {
            return 0;
        }
        if (sScreenWidth != 0) {
            return sScreenWidth;
        }
        try {
            sScreenWidth = context.getResources().getDisplayMetrics().widthPixels;
        }
        catch (Throwable throwable) {
            sScreenWidth = 0;
        }
        return sScreenWidth;
    }

    public static int getScreenHeight(Context context) {
        if (context == null) {
            return 0;
        }
        if (sScreenHeight != 0) {
            return sScreenHeight;
        }
        try {
            sScreenHeight = context.getResources().getDisplayMetrics().heightPixels;
        }
        catch (Throwable throwable) {
            sScreenHeight = 0;
        }
        return sScreenHeight;
    }

    private static void writeStringToFile(String string, String string2) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = new File(string);
            if (!file.exists() && file.createNewFile()) {
                return;
            }
            outputStreamWriter = new FileWriter(file, false);
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            return;
        }
        catch (Throwable throwable) {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static String readStringFromFile(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSystemStat() {
        RandomAccessFile randomAccessFile = null;
        String string = null;
        try {
            randomAccessFile = new RandomAccessFile("/proc/stat", "r");
            string = randomAccessFile.readLine();
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                return string;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Throwable throwable3) {
                    TPNativeLog.printLog(4, throwable3.getMessage());
                }
            }
        }
        try {
            randomAccessFile.close();
            return string;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            return string;
        }
    }

    public static int getSystemCpuUsage(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return -1;
        }
        float f2 = -1.0f;
        try {
            String[] stringArray = string.trim().split("\\s+");
            long l2 = TPSystemInfo.getSystemIdleTime(stringArray);
            long l3 = TPSystemInfo.getSystemUptime(stringArray);
            stringArray = string2.trim().split("\\s+");
            long l4 = TPSystemInfo.getSystemIdleTime(stringArray);
            long l5 = TPSystemInfo.getSystemUptime(stringArray);
            if (l2 >= 0L && l3 >= 0L && l4 >= 0L && l5 >= 0L && l5 + l4 > l3 + l2 && l5 >= l3) {
                f2 = (float)(l5 - l3) / (float)(l5 + l4 - (l3 + l2)) * 100.0f;
            }
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            f2 = -1.0f;
        }
        return (int)f2;
    }

    public static long getSystemUptime(String[] stringArray) {
        long l2 = 0L;
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            if (4 == i2) continue;
            try {
                l2 += Long.parseLong(stringArray[i2]);
                continue;
            }
            catch (Throwable throwable) {
                return -1L;
            }
        }
        return l2;
    }

    public static long getSystemIdleTime(String[] stringArray) {
        try {
            return Long.parseLong(stringArray[4]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1L;
        }
    }

    public static int getOpenGLSupportVersion(Context context) {
        if (sOpenGLVersion == 0) {
            try {
                ActivityManager activityManager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
                if (activityManager == null) {
                    return sOpenGLVersion;
                }
                sOpenGLVersion = activityManager.getDeviceConfigurationInfo().reqGlEsVersion;
            }
            catch (Throwable throwable) {
                TPNativeLog.printLog(4, throwable.getMessage());
            }
        }
        return sOpenGLVersion;
    }

    public static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean supportInDeviceDolbyAudioEffect() {
        boolean bl = false;
        try {
            AudioEffect.Descriptor[] descriptorArray = AudioEffect.queryEffects();
            int n2 = descriptorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!descriptorArray[i2].implementor.contains("Dolby Laboratories")) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, exception.getMessage());
        }
        return bl;
    }

    public static synchronized void initAudioBestSettings(Context context) {
        if (context == null || sAudioBestSampleRate > 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            String string = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            String string2 = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
            try {
                sAudioBestSampleRate = Integer.parseInt(string);
                sAudioBestFramesPerBust = Integer.parseInt(string2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                TPNativeLog.printLog(4, numberFormatException.getMessage());
            }
        }
    }

    public static int getBestAudioSampleRate() {
        return sAudioBestSampleRate;
    }

    public static int getBestAudioFramesPerBust() {
        return sAudioBestFramesPerBust;
    }

    public static void setProperty(String string, String string2) {
        if (TextUtils.equals((CharSequence)string, (CharSequence)KEY_PROPERTY_MODEL)) {
            sDeviceName = string2;
            return;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)KEY_PROPERTY_MANUFACTURER)) {
            sDeviceManufacturer = string2;
            return;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)KEY_PROPERTY_VERSION_RELEASE)) {
            sOSVersion = string2;
            return;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)KEY_PROPERTY_DEVICE)) {
            sProductDevice = string2;
            return;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)KEY_PROPERTY_BOARD)) {
            sProductBoard = string2;
        }
    }

    static {
        sCpuHWProducter = -1;
        sCpuHWProductIdx = -1;
        sAudioBestSampleRate = 0;
        sAudioBestFramesPerBust = 0;
        sCpuPerfList = new String[][]{{"MSM7227", "MSM7627", "MSM7227T", "MSM7627T", "MSM7227A", "MSM7627A", "QSD8250", "QSD8650", "MSM7230", "MSM7630", "APQ8055", "MSM8255", "MSM8655", "MSM8255T", "MSM8655T", "MSM8225", "MSM8625", "MSM8260", "MSM8660", "MSM8x25Q", "MSM8x26", "MSM8x10", "MSM8x12", "MSM8x30", "MSM8260A", "MSM8660A", "MSM8960", "MSM8208", "MSM8916", "MSM8960T", "MSM8909", "MSM8916v2", "MSM8936", "MSM8909v2", "MSM8917", "APQ8064", "APQ8064T", "MSM8920", "MSM8939", "MSM8937", "MSM8939v2", "MSM8940", "MSM8952", "MSM8974", "MSM8x74AA", "MSM8x74AB", "MSM8x74AC", "MSM8953", "APQ8084", "MSM8953Pro", "MSM8992", "MSM8956", "MSM8976", "MSM8976Pro", "MSM8994", "MSM8996", "MSM8996Pro", "MSM8998", "SDM845", "SM8150", "SM8250", "SM8250-AB", "SM8250-AC", "SM8350", "SM8350-AC", "SM8450"}, {"MT6516", "MT6513", "MT6573", "MT6515M", "MT6515", "MT6575", "MT6572", "MT6577", "MT6589", "MT6582", "MT6592", "MT6595", "MT6735", "MT6750", "MT6753", "MT6752", "MT6755", "MT6755", "MT6755T", "MT6795", "MT6757", "MT675x", "MT6797", "MT6797T", "MT6797X", "MT6771V", "MT6799", "MT6769Z", "MT6785T", "MT6853V", "MT6853V", "MT6873", "MT6874", "MT6875", "MT6877", "MT6885", "MT6889V", "MT6889Z", "MT6891Z", "MT6893", "MT6983"}, {"K3V2", "K3V2E", "K3V2+", "Kirin910", "Kirin920", "Kirin925", "Kirin928", "Kirin620", "Kirin650", "Kirin655", "Kirin930", "Kirin935", "Kirin950", "Kirin955", "Kirin960", "Kirin970", "Kirin810", "Kirin980", "Kirin820", "Kirin985", "Kirin990", "Kirin9000E", "Kirin9000"}, {"S5L8900", "S5PC100", "Exynos3110", "Exynos3475", "Exynos4210", "Exynos4212", "SMDK4x12", "Exynos4412", "Exynos5250", "Exynos5260", "Exynos5410", "Exynos5420", "Exynos5422", "Exynos5430", "Exynos5800", "Exynos5433", "Exynos7580", "Exynos7870", "Exynos7870", "Exynos7420", "Exynos8890", "Exynos890", "Exynos8895", "Exynos9810", "Exynos9820", "Exynos9825", "Exynos990", "Exynos1080", "Exynos2100", "Exynos2200"}};
        sMaxCpuFreq = -1L;
        sCurrentCpuFreq = -1L;
        sNumOfCores = -1;
        sCpuArch = -1;
        sOpenGLVersion = 0;
        SDK_INT = Build.VERSION.SDK_INT == 25 && !TextUtils.isEmpty((CharSequence)Build.VERSION.CODENAME) && Build.VERSION.CODENAME.charAt(0) == 'O' ? 26 : Build.VERSION.SDK_INT;
    }
}

