/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.decoder;

import android.os.Build;
import android.util.SparseArray;
import android.view.Surface;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.decoder.ITPMediaCodecDecoder;
import com.tencent.thumbplayer.core.decoder.TPBaseMediaCodecDecoder;
import com.tencent.thumbplayer.core.decoder.TPFrameInfo;
import com.tencent.thumbplayer.core.decoder.TPMediaCodecAudioDecoder;
import com.tencent.thumbplayer.core.decoder.TPMediaCodecVideoDecoder;
import java.util.concurrent.atomic.AtomicInteger;

public class TPMediaCodecManager {
    private static final String TAG = "TPMediaCodecManager";
    private static SparseArray<ITPMediaCodecDecoder> mCodecList = new SparseArray();
    private static AtomicInteger codecNum = new AtomicInteger(0);

    private static native void _onMediaCodecReady(int var0, String var1);

    private static native void _onMediaCodecException(int var0, String var1);

    private static native void _onMediaDrmInfo(int var0, Object var1);

    private static native void _onMediaCodecReportEvent(int var0, int var1);

    public static int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static int createMediaCodec(boolean bl) {
        if (codecNum.get() >= Integer.MAX_VALUE) {
            codecNum.set(0);
        }
        int n2 = codecNum.getAndIncrement();
        TPBaseMediaCodecDecoder tPBaseMediaCodecDecoder = bl ? new TPMediaCodecAudioDecoder(n2) : new TPMediaCodecVideoDecoder(n2);
        TPMediaCodecManager.addCodecToList(n2, tPBaseMediaCodecDecoder);
        return n2;
    }

    public static boolean initVideoMediaCodec(int n2, String string, int n3, int n4, int n5, Surface surface, int n6, int n7, int n8) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "initVideoMediaCodec failed!");
            return false;
        }
        if (!iTPMediaCodecDecoder.initDecoder(string, n3, n4, n5, surface, n6, n7, n8)) {
            return false;
        }
        return iTPMediaCodecDecoder.startDecoder();
    }

    public static boolean initAudioMediaCodec(int n2, String string, int n3, int n4, int n5, int n6) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "initAudioMediaCodec failed!");
            return false;
        }
        if (!iTPMediaCodecDecoder.initDecoder(string, n3, n4, n5, n6)) {
            return false;
        }
        return iTPMediaCodecDecoder.startDecoder();
    }

    public static int setMediaCodecSurface(int n2, Surface surface) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecSurface failed!");
            return 3;
        }
        return iTPMediaCodecDecoder.setOutputSurface(surface);
    }

    public static int sendOnePacket(int n2, byte[] byArray, boolean bl, long l2, boolean bl2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "sendOnePacket failed!");
            return 3;
        }
        return iTPMediaCodecDecoder.decode(byArray, bl, l2, bl2);
    }

    public static TPFrameInfo receiveOneFrame(int n2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "receiveOneFrame failed!");
            return null;
        }
        return iTPMediaCodecDecoder.dequeueOutputBuffer();
    }

    public static int releaseVideoFrame(int n2, int n3, boolean bl) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "releaseVideoFrame failed!");
            return 3;
        }
        return iTPMediaCodecDecoder.releaseOutputBuffer(n3, bl);
    }

    public static int releaseMediaCodec(int n2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "releaseMediaCodec failed!");
            return 3;
        }
        TPMediaCodecManager.removeCodecFromList(n2);
        return iTPMediaCodecDecoder.release();
    }

    public static int signalEndOfStream(int n2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "signalEndOfStream failed!");
            return 3;
        }
        return iTPMediaCodecDecoder.signalEndOfStream();
    }

    public static int flushMediaCodec(int n2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "flushMediaCodec failed!");
            return 3;
        }
        return iTPMediaCodecDecoder.flush();
    }

    public static boolean setMediaCodecParamInt(int n2, int n3, int n4) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamInt failed!");
            return false;
        }
        return iTPMediaCodecDecoder.setParamInt(n3, n4);
    }

    public static boolean setMediaCodecParamLong(int n2, int n3, long l2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamLong failed!");
            return false;
        }
        return iTPMediaCodecDecoder.setParamLong(n3, l2);
    }

    public static boolean setMediaCodecParamBool(int n2, int n3, boolean bl) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamBool failed!");
            return false;
        }
        return iTPMediaCodecDecoder.setParamBool(n3, bl);
    }

    public static boolean setMediaCodecParamString(int n2, int n3, String string) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamString failed!");
            return false;
        }
        return iTPMediaCodecDecoder.setParamString(n3, string);
    }

    public static boolean setMediaCodecParamBytes(int n2, int n3, byte[] byArray) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamBytes failed!");
            return false;
        }
        return iTPMediaCodecDecoder.setParamBytes(n3, byArray);
    }

    public static boolean setMediaCodecParamObject(int n2, int n3, Object object) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamObject failed!");
            return false;
        }
        return iTPMediaCodecDecoder.setParamObject(n3, object);
    }

    public static void setCryptoInfo(int n2, int n3, int[] nArray, int[] nArray2, byte[] byArray, byte[] byArray2, int n4) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecParamObject failed!");
            return;
        }
        iTPMediaCodecDecoder.setCryptoInfo(n3, nArray, nArray2, byArray, byArray2, n4);
    }

    public static int setMediaCodecOperateRate(int n2, float f2) {
        ITPMediaCodecDecoder iTPMediaCodecDecoder = TPMediaCodecManager.getCodecById(n2);
        if (iTPMediaCodecDecoder == null) {
            TPNativeLog.printLog(3, TAG, "setMediaCodecOperateRate failed!");
            return 3;
        }
        return iTPMediaCodecDecoder.setOperateRate(f2);
    }

    public static void onMediaCodecReady(int n2, String string) {
        TPMediaCodecManager._onMediaCodecReady(n2, string);
    }

    public static void onMediaCodecException(int n2, String string) {
        TPMediaCodecManager._onMediaCodecException(n2, string);
    }

    public static void onMediaDrmInfo(int n2, Object object) {
        TPMediaCodecManager._onMediaDrmInfo(n2, object);
    }

    public static void onMediaCodecReportEvent(int n2, int n3) {
        TPMediaCodecManager._onMediaCodecReportEvent(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCodecToList(int n2, ITPMediaCodecDecoder iTPMediaCodecDecoder) {
        Class<TPMediaCodecManager> clazz = TPMediaCodecManager.class;
        synchronized (TPMediaCodecManager.class) {
            mCodecList.put(n2, (Object)iTPMediaCodecDecoder);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCodecFromList(int n2) {
        Class<TPMediaCodecManager> clazz = TPMediaCodecManager.class;
        synchronized (TPMediaCodecManager.class) {
            mCodecList.remove(n2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITPMediaCodecDecoder getCodecById(int n2) {
        Class<TPMediaCodecManager> clazz = TPMediaCodecManager.class;
        synchronized (TPMediaCodecManager.class) {
            ITPMediaCodecDecoder iTPMediaCodecDecoder = (ITPMediaCodecDecoder)mCodecList.get(n2);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (iTPMediaCodecDecoder == null) {
                TPNativeLog.printLog(3, TAG, "No such codec by id:".concat(String.valueOf(n2)));
                return null;
            }
            return iTPMediaCodecDecoder;
        }
    }
}

