/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDLProxyLogListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPOfflineDownloadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPlayListener;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPPreLoadListener;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDLProxyInitParam;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDLProxyMsg;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadParam;
import com.tencent.thumbplayer.core.downloadproxy.apiinner.TPListenerManager;
import com.tencent.thumbplayer.core.downloadproxy.jni.TPDownloadProxyNative;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLFileSystem;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyUtils;
import java.io.File;

public class TPDownloadProxy
implements ITPDownloadProxy {
    private static final String FILE_NAME = "TPDownloadProxy";
    private int mServiceType;
    private String mCurrentStoragePath = "";
    private boolean mIsInit = false;
    private Context mContext = null;

    public TPDownloadProxy(int serviceType) {
        this.mServiceType = serviceType;
    }

    private void getCellularNetwork(Context context) {
        if (context == null) {
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, context is null, can not set interface 4g");
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12);
            builder.addTransportType(0);
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, connectivityManager is null, can not set interface 4g");
                return;
            }
            NetworkRequest networkRequest = builder.build();
            ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    super.onAvailable(network);
                    TPListenerManager.getInstance().setNetwork(network);
                    long l2 = network.getNetworkHandle();
                    TPDLProxyLog.i(TPDownloadProxy.FILE_NAME, 0, "tpdlnative", "cellular_network, net_id_t: ".concat(String.valueOf(l2)));
                    TPDownloadProxy.this.setUserData("cellular_interface_id", l2);
                }

                public void onLost(Network network) {
                    super.onLost(network);
                    TPDownloadProxy.this.setUserData("cellular_interface_id", 0);
                    TPDLProxyLog.i(TPDownloadProxy.FILE_NAME, 0, "tpdlnative", "cellular_network failed");
                }
            };
            connectivityManager.requestNetwork(networkRequest, networkCallback);
        }
    }

    @Override
    public synchronized int init(Context context, TPDLProxyInitParam param) {
        if (this.mIsInit) {
            TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "download already init");
            return 0;
        }
        TPDownloadProxyNative.getInstance().setAppContext(context);
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                int n2;
                String string;
                if (!TextUtils.isEmpty((CharSequence)param.getAppVer())) {
                    this.setUserData("app_version_name", param.getAppVer());
                }
                if (param.getPlatform() > 0) {
                    this.setUserData("platform", param.getPlatform());
                }
                if (!TextUtils.isEmpty((CharSequence)param.getGuid())) {
                    this.setUserData("guid", param.getGuid());
                }
                if (TextUtils.isEmpty((CharSequence)(string = param.getCacheDir())) && context != null) {
                    try {
                        File file = TPDLFileSystem.getProperCacheDirectory(context, "download");
                        if (file != null) {
                            string = file.getAbsolutePath();
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "init get cache dir failed, error:" + throwable.toString());
                    }
                }
                TPListenerManager.getInstance().initHandler();
                if (TextUtils.isEmpty((CharSequence)param.getDataDir()) && !TextUtils.isEmpty((CharSequence)this.mCurrentStoragePath)) {
                    n2 = TPDownloadProxyNative.getInstance().initService(this.mServiceType, string, this.mCurrentStoragePath, param.getConfigStr());
                } else {
                    if (!TextUtils.isEmpty((CharSequence)param.getDataDir())) {
                        this.mCurrentStoragePath = param.getDataDir();
                    }
                    n2 = TPDownloadProxyNative.getInstance().initService(this.mServiceType, string, param.getDataDir(), param.getConfigStr());
                }
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                intentFilter.addAction("android.intent.action.SCREEN_ON");
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String string = intent.getAction();
                        if ("android.intent.action.SCREEN_OFF".equals(string)) {
                            TPDownloadProxy.this.pushEvent(20);
                            return;
                        }
                        if ("android.intent.action.SCREEN_ON".equals(string)) {
                            TPDownloadProxy.this.pushEvent(19);
                        }
                    }
                };
                if (context != null) {
                    context.registerReceiver(broadcastReceiver, intentFilter);
                }
                if (n2 == 0) {
                    this.mIsInit = true;
                }
                this.mContext = context;
                return n2;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "init failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public int deinit() {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                this.mIsInit = false;
                return TPDownloadProxyNative.getInstance().deInitService(this.mServiceType);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "deinit failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public void setLogListener(ITPDLProxyLogListener logListener) {
        TPDLProxyLog.setLogListener(this.mServiceType, logListener);
    }

    @Override
    public int startPlay(String fileId, TPDownloadParam dlParam, ITPPlayListener playListener) {
        int n2 = -1;
        int n3 = dlParam.getDlType();
        if (playListener != null) {
            dlParam.getExtInfoMap().put("dl_param_adv_remain_time", playListener.getAdvRemainTime() / 1000L);
        }
        if (dlParam.isOffline()) {
            n3 += 300;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                if (dlParam.isAdaptive() && (n3 == 3 || n3 == 5)) {
                    n3 += 400;
                }
                n2 = TPDownloadProxyNative.getInstance().createDownloadTask(this.mServiceType, fileId, n3, dlParam.getClipCount());
                TPListenerManager.getInstance().setPlayListener(n2, playListener);
                String string = TextUtils.isEmpty((CharSequence)dlParam.getKeyid()) ? fileId : dlParam.getKeyid();
                TPDownloadProxyNative.getInstance().setClipInfo(n2, dlParam.getClipNo(), string, n3, dlParam.getCdnUrls(), dlParam.getSavaPath(), dlParam.getExtraJsonInfo());
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startPlay failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public int startClipPlay(String fileId, int clipCount, ITPPlayListener playListener) {
        int n2 = -1;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                n2 = TPDownloadProxyNative.getInstance().createDownloadTask(this.mServiceType, fileId, 2, clipCount);
                TPListenerManager.getInstance().setPlayListener(n2, playListener);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startClipPlay failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public boolean setClipInfo(int playId, int clipNo, String clipFileId, TPDownloadParam dlParam) {
        boolean bl = false;
        int n2 = dlParam.getDlType();
        if (dlParam.isOffline()) {
            n2 += 300;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                bl = TPDownloadProxyNative.getInstance().setClipInfo(playId, clipNo, clipFileId, n2, dlParam.getCdnUrls(), dlParam.getSavaPath(), dlParam.getExtraJsonInfo()) >= 0;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setClipInfo failed, error:" + throwable.toString());
            }
        }
        return bl;
    }

    @Override
    public String getPlayUrl(int playId, int urlType) {
        String string = "";
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                string = TPDLProxyUtils.byteArrayToString(TPDownloadProxyNative.getInstance().getClipPlayUrl(playId, 1, urlType));
                if (urlType != 2) {
                    TPDownloadProxyNative.getInstance().startDownload(playId);
                }
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getPlayUrl failed, error:" + throwable.toString());
            }
        }
        return string;
    }

    @Override
    public String getClipPlayUrl(int playId, int clipNo, int urlType) {
        String string = "";
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                string = TPDLProxyUtils.byteArrayToString(TPDownloadProxyNative.getInstance().getClipPlayUrl(playId, clipNo, urlType));
                if (urlType != 2) {
                    TPDownloadProxyNative.getInstance().startDownload(playId);
                }
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getClipPlayUrl failed, error:" + throwable.toString());
            }
        }
        return string;
    }

    @Override
    public String getPlayErrorCodeStr(int playId) {
        String string = "";
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                string = TPDLProxyUtils.byteArrayToString(TPDownloadProxyNative.getInstance().getErrorCodeStr(playId));
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getPlayErrorCodeStr failed, error:" + throwable.toString());
            }
        }
        return string;
    }

    @Override
    public void stopPlay(int playId) {
        if (playId <= 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().stopDownload(playId);
                TPListenerManager.getInstance().removePlayListener(playId);
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "stopPlay failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public int pauseDownload(int playId) {
        if (playId <= 0) {
            return -1;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().pauseDownload(playId);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "pauseDownload failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public int resumeDownload(int playId) {
        if (playId <= 0) {
            return -1;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().resumeDownload(playId);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "resumeDownload failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public int startPreload(String fileId, TPDownloadParam dlParam, ITPPreLoadListener preloadListener) {
        int n2 = -1;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                int n3 = dlParam.getDlType() + 200;
                n2 = TPDownloadProxyNative.getInstance().createDownloadTask(this.mServiceType, fileId, n3, dlParam.getClipCount());
                TPListenerManager.getInstance().setPreLoadListener(n2, preloadListener);
                String string = TextUtils.isEmpty((CharSequence)dlParam.getKeyid()) ? fileId : dlParam.getKeyid();
                TPDownloadProxyNative.getInstance().setClipInfo(n2, dlParam.getClipNo(), string, n3, dlParam.getCdnUrls(), dlParam.getSavaPath(), dlParam.getExtraJsonInfo());
                TPDownloadProxyNative.getInstance().startDownload(n2);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startPreload failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public int startClipPreload(String fileId, int clipCount, ITPPreLoadListener preloadListener) {
        int n2 = -1;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                n2 = TPDownloadProxyNative.getInstance().createDownloadTask(this.mServiceType, fileId, 202, clipCount);
                TPListenerManager.getInstance().setPreLoadListener(n2, preloadListener);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startClipPreload failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public void stopPreload(int preloadId) {
        if (preloadId <= 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().stopDownload(preloadId);
                TPListenerManager.getInstance().removePreLoadListener(preloadId);
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "stopPreload failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public int startOfflineDownload(String fileId, TPDownloadParam dlParam, ITPOfflineDownloadListener offlineDownloadListener) {
        int n2 = -1;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                int n3 = dlParam.getDlType() + 100;
                n2 = TPDownloadProxyNative.getInstance().createDownloadTask(this.mServiceType, fileId, n3, dlParam.getClipCount());
                TPListenerManager.getInstance().setOfflineDownloadListener(n2, offlineDownloadListener);
                String string = TextUtils.isEmpty((CharSequence)dlParam.getKeyid()) ? fileId : dlParam.getKeyid();
                TPDownloadProxyNative.getInstance().setClipInfo(n2, dlParam.getClipNo(), string, n3, dlParam.getCdnUrls(), dlParam.getSavaPath(), dlParam.getExtraJsonInfo());
                TPDownloadProxyNative.getInstance().startDownload(n2);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "stopOfflineDownload failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public int startClipOfflineDownload(String fileId, int clipCount, ITPOfflineDownloadListener offlineDownloadListener) {
        int n2 = -1;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                n2 = TPDownloadProxyNative.getInstance().createDownloadTask(this.mServiceType, fileId, 102, clipCount);
                TPListenerManager.getInstance().setOfflineDownloadListener(n2, offlineDownloadListener);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startClipOfflineDownload failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public void stopOfflineDownload(int taskId) {
        if (taskId <= 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().stopDownload(taskId);
                TPListenerManager.getInstance().removeOfflineDownloadListener(taskId);
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "stopOfflineDownload failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public void startTask(int taskId) {
        if (taskId <= 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().startDownload(taskId);
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startTask failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public void updateStoragePath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        try {
            this.mCurrentStoragePath = path;
            TPDownloadProxyNative.getInstance().updateStoragePath(this.mServiceType, path);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "updateStoragePath failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public void setMaxStorageSizeMB(long maxStorageSizeMB) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().setMaxStorageSizeMB(this.mServiceType, maxStorageSizeMB);
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setMaxStorageSizeMB failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public int removeStorageCache(String fileId) {
        return this.removeStorageCache(fileId, -1L);
    }

    @Override
    public int removeStorageCache(String fileId, long preferredResolution) {
        if (TextUtils.isEmpty((CharSequence)fileId)) {
            return -1;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().deleteCache(this.mCurrentStoragePath, fileId, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "deleteCache failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public int clearCache(String path, String fileId, int mode) {
        return this.clearCache(path, fileId, mode, -1L);
    }

    @Override
    public int clearCache(String path, String fileId, int mode, long preferredResolution) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().clearCache(path, fileId, mode, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "clearCache failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public boolean checkResourceExist(String diskPath, String resourceID, long preferredResolution) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().checkResourceExist(diskPath, resourceID, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "checkResourceExist failed, error:" + throwable.toString());
            }
        }
        return false;
    }

    @Override
    public float getResourceDownloadProgress(String diskPath, String resourceID, long preferredResolution) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().getResourceDownloadProgress(diskPath, resourceID, preferredResolution);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getResourceDownloadProgress failed, error:" + throwable.toString());
            }
        }
        return 0.0f;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                if (key.equalsIgnoreCase("app_version_name")) {
                    TPDownloadProxyNative.getInstance().setUserData("app_version_name", (String)value);
                    return;
                }
                if (key.equalsIgnoreCase("platform")) {
                    TPDownloadProxyNative.getInstance().setUserData("platform", value.toString());
                    return;
                }
                if (key.equalsIgnoreCase("guid")) {
                    TPDownloadProxyNative.getInstance().setUserData("guid", (String)value);
                    return;
                }
                if (key.equalsIgnoreCase("qq_is_vip")) {
                    TPDownloadProxyNative.getInstance().setUserData("qq_is_vip", (Boolean)value != false ? "1" : "0");
                    return;
                }
                if (key.equalsIgnoreCase("carrier_pesudo_code")) {
                    TPDownloadProxyNative.getInstance().setUserData("carrier_pesudo_code", (String)value);
                    return;
                }
                if (key.equalsIgnoreCase("carrier_pesudo_state")) {
                    TPDownloadProxyNative.getInstance().setUserData("carrier_pesudo_state", value.toString());
                    return;
                }
                if (key.equalsIgnoreCase("proxy_config")) {
                    TPDownloadProxyNative.getInstance().setUserData("proxy_config", value.toString());
                    return;
                }
                TPDownloadProxyNative.getInstance().setUserData(key, value.toString());
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setUserData failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public String getNativeInfo(int key) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDLProxyUtils.byteArrayToString(TPDownloadProxyNative.getInstance().getNativeInfo(key));
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getNativeInfo failed, error:" + throwable.toString());
            }
        }
        return null;
    }

    @Override
    public int checkResourceStatus(String diskPath, String resourceID, int fileFormat) {
        int n2 = -1;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                n2 = TPDownloadProxyNative.getInstance().checkResourceStatus(diskPath, resourceID, fileFormat);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "checkResourceStatus failed, error:" + throwable.toString());
            }
        }
        return n2;
    }

    @Override
    public long getResourceSize(String diskPath, String resourceID) {
        long l2 = -1L;
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                l2 = TPDownloadProxyNative.getInstance().getResourceSize(diskPath, resourceID);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getResourceSize failed, error:" + throwable.toString());
            }
        }
        return l2;
    }

    @Override
    public void pushEvent(int event) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().pushEvent(event);
                if (9 == event) {
                    TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "cellular_network, update net interface info");
                    TPDownloadProxy tPDownloadProxy = this;
                    tPDownloadProxy.getCellularNetwork(tPDownloadProxy.mContext);
                }
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "cellular_network pushEvent failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public void setPlayState(int playId, int state) {
        if (playId <= 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().setPlayerState(playId, state);
                if (state == 1) {
                    long l2 = TPListenerManager.getInstance().getPlaylistener(playId).getCurrentPlayOffset();
                    int n2 = (int)(TPListenerManager.getInstance().getPlaylistener(playId).getCurrentPosition() / 1000L);
                    int n3 = (int)(TPListenerManager.getInstance().getPlaylistener(playId).getPlayerBufferLength() / 1000L);
                    int n4 = (int)(TPListenerManager.getInstance().getPlaylistener(playId).getAdvRemainTime() / 1000L);
                    TPDownloadProxyNative.getInstance().updateTaskInfo(playId, "taskinfo_play_offset", String.valueOf(l2));
                    TPDownloadProxyNative.getInstance().updatePlayerPlayMsg(playId, n2, n3, n4);
                }
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setPlayState failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public void updateTaskInfo(int playId, String key, Object value) {
        if (playId <= 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().updateTaskInfo(playId, key, value.toString());
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "updateTaskInfo failed, error:" + throwable.toString());
            }
        }
    }

    @Override
    public byte[] getOfflineLicenseKeySetId(String saveDir, String playUrl, String licenseUrl) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().getOfflineLicenseKeySetId(saveDir, playUrl, licenseUrl);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getOfflineLicenseKeySetId failed, error:" + throwable.toString());
            }
        }
        return null;
    }

    @Override
    public int deleteOfflineLicenseKeySetId(String saveDir, String playUrl, String licenseUrl) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().deleteOfflineLicenseKeySetId(saveDir, playUrl, licenseUrl);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "deleteOfflineLicenseKeySetId failed, error:" + throwable.toString());
            }
        }
        return -1;
    }

    @Override
    public TPDLProxyMsg.TPPDTInfo[] getPDTInfos(int playId) {
        if (playId <= 0) {
            return null;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDownloadProxyNative.getInstance().getPDTInfos(playId);
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getPDTInfos failed, error:" + throwable.toString());
            }
        }
        return null;
    }

    @Override
    public void switchToResolution(int playId, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().switchToResolution(playId, width, height);
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "switchToResolution failed, error:" + throwable.toString());
            }
        }
    }
}

