/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.drm;

import android.media.DeniedByServerException;
import android.media.MediaDrm;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class TPDownloadMediaDrm {
    private static final String FILE_NAME = "TPDownloadMediaDrm";
    private MediaDrm mMediaDrm;
    private OnEventListener mOnEventListener;
    private OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private OnExpirationUpdateListener mOnExpirationUpdateListener;
    private static final int MAX_LICENSE_DURATION_TO_RENEW_SECONDS = 60;
    public static final String PROPERTY_LICENSE_DURATION_REMAINING = "LicenseDurationRemaining";
    public static final String PROPERTY_PLAYBACK_DURATION_REMAINING = "PlaybackDurationRemaining";

    private TPDownloadMediaDrm(UUID uuid) throws UnsupportedSchemeException {
        this.mMediaDrm = new MediaDrm(uuid);
    }

    public static synchronized TPDownloadMediaDrm createDownloadMediaDrm(String uuidStr) {
        TPDownloadMediaDrm tPDownloadMediaDrm = null;
        if (TextUtils.isEmpty((CharSequence)uuidStr)) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        try {
            UUID uUID = UUID.fromString(uuidStr);
            tPDownloadMediaDrm = new TPDownloadMediaDrm(uUID);
        }
        catch (Exception exception) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "createDownloadMediaDrm exception : " + exception.getMessage());
        }
        return tPDownloadMediaDrm;
    }

    public static synchronized boolean isCryptoSchemeSupported(String uuidStr) {
        return MediaDrm.isCryptoSchemeSupported((UUID)UUID.fromString(uuidStr));
    }

    public static synchronized int getSdkIntVersion() {
        return Build.VERSION.SDK_INT;
    }

    public DownloadDrmSession openSession() {
        byte[] byArray = null;
        int n2 = 0;
        try {
            byArray = this.mMediaDrm.openSession();
        }
        catch (NotProvisionedException notProvisionedException) {
            n2 = -1;
        }
        catch (Exception exception) {
            n2 = -2;
        }
        return new DownloadDrmSession(n2, byArray);
    }

    public void closeSession(byte[] sessionId) {
        this.mMediaDrm.closeSession(sessionId);
    }

    public KeyRequest getKeyRequest(byte[] scope, byte[] init, String mimeType, int keyType) {
        MediaDrm.KeyRequest keyRequest;
        int n2 = 0;
        try {
            keyRequest = this.mMediaDrm.getKeyRequest(scope, init, mimeType, keyType, null);
        }
        catch (NotProvisionedException notProvisionedException) {
            return new KeyRequest(-1, null, -1);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            n2 = keyRequest.getRequestType();
        }
        return new KeyRequest(n2, keyRequest.getData(), 0);
    }

    public byte[] provideKeyResponse(byte[] scope, byte[] response) {
        try {
            return this.mMediaDrm.provideKeyResponse(scope, response);
        }
        catch (NotProvisionedException notProvisionedException) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "provideKeyResponse NotProvisionedException : " + notProvisionedException.getMessage());
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = -1;
            return byArray2;
        }
        catch (DeniedByServerException deniedByServerException) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "provideKeyResponse DeniedByServerException : " + deniedByServerException.getMessage());
            byte[] byArray = new byte[1];
            byte[] byArray3 = byArray;
            byArray[0] = -2;
            return byArray3;
        }
    }

    public ProvisionRequest getProvisionRequest() {
        MediaDrm.ProvisionRequest provisionRequest;
        try {
            provisionRequest = this.mMediaDrm.getProvisionRequest();
        }
        catch (Exception exception) {
            return new ProvisionRequest("", new byte[0]);
        }
        return new ProvisionRequest(provisionRequest.getDefaultUrl(), provisionRequest.getData());
    }

    public int provideProvisionResponse(byte[] response) {
        try {
            this.mMediaDrm.provideProvisionResponse(response);
        }
        catch (DeniedByServerException deniedByServerException) {
            return -1;
        }
        return 0;
    }

    public int restoreKeys(byte[] sessionId, byte[] keySetId) {
        int n2 = 0;
        try {
            this.mMediaDrm.restoreKeys(sessionId, keySetId);
            long l2 = this.getLicenseDurationRemainingSec(sessionId);
            if (l2 <= 60L) {
                TPDLProxyLog.w(FILE_NAME, 0, "tpdlnative", "Offline license has expired or will expire soon, Remaining seconds: ".concat(String.valueOf(l2)));
                this.mMediaDrm.removeKeys(sessionId);
                n2 = -1;
            }
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    private long getLicenseDurationRemainingSec(byte[] sessionId) {
        try {
            HashMap hashMap = this.mMediaDrm.queryKeyStatus(sessionId);
            if (hashMap != null && hashMap.size() > 0) {
                String string = (String)hashMap.get(PROPERTY_LICENSE_DURATION_REMAINING);
                long l2 = 0L;
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    l2 = Long.parseLong(string);
                }
                String string2 = (String)hashMap.get(PROPERTY_PLAYBACK_DURATION_REMAINING);
                long l3 = 0L;
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    l3 = Long.parseLong(string2);
                }
                return Math.min(l2, l3);
            }
        }
        catch (Throwable throwable) {
            TPDLProxyLog.w(FILE_NAME, 0, "tpdlnative", "queryKeyStatus failed, error:" + throwable.toString());
        }
        return 0L;
    }

    public int removeKeys(byte[] sessionId) {
        try {
            this.mMediaDrm.removeKeys(sessionId);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    public String getPropertyString(String propertyName) {
        return this.mMediaDrm.getPropertyString(propertyName);
    }

    public void setPropertyString(String propertyName, String value) {
        this.mMediaDrm.setPropertyString(propertyName, value);
    }

    public byte[] getPropertyByteArray(String propertyName) {
        return this.mMediaDrm.getPropertyByteArray(propertyName);
    }

    public void setPropertyByteArray(String propertyName, byte[] value) {
        this.mMediaDrm.setPropertyByteArray(propertyName, value);
    }

    public void close() {
        if (this.mMediaDrm == null) {
            return;
        }
        this.mMediaDrm.setOnEventListener(null);
        this.mOnEventListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnExpirationUpdateListener(null, null);
        }
        this.mOnExpirationUpdateListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnKeyStatusChangeListener(null, null);
        }
        this.mOnKeyStatusChangeListener = null;
        this.mMediaDrm.release();
        this.mMediaDrm = null;
    }

    public void setOnEventListener(OnEventListener listener) {
        this.mMediaDrm.setOnEventListener(new MediaDrm.OnEventListener(){

            public void onEvent(MediaDrm md, byte[] sessionId, int event, int extra, byte[] data) {
                if (null != TPDownloadMediaDrm.this.mOnEventListener) {
                    TPDownloadMediaDrm.this.mOnEventListener.onEvent(TPDownloadMediaDrm.this, sessionId, event, extra, data);
                }
            }
        });
    }

    public synchronized void setOnKeyStatusChangeListener(OnKeyStatusChangeListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.mOnKeyStatusChangeListener = listener;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnKeyStatusChangeListener(new MediaDrm.OnKeyStatusChangeListener(){

                public void onKeyStatusChange(MediaDrm md, byte[] sessionId, List<MediaDrm.KeyStatus> keyInformation, boolean hasNewUsableKey) {
                    if (null != TPDownloadMediaDrm.this.mOnKeyStatusChangeListener) {
                        TPDownloadMediaDrm.this.mOnKeyStatusChangeListener.onKeyStatusChange(TPDownloadMediaDrm.this, sessionId, keyInformation, hasNewUsableKey);
                    }
                }
            }, handler);
        }
    }

    public void setOnExpirationUpdateListener(OnExpirationUpdateListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.mOnExpirationUpdateListener = listener;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnExpirationUpdateListener(new MediaDrm.OnExpirationUpdateListener(){

                public void onExpirationUpdate(MediaDrm md, byte[] sessionId, long expirationTime) {
                    if (null != TPDownloadMediaDrm.this.mOnExpirationUpdateListener) {
                        TPDownloadMediaDrm.this.mOnExpirationUpdateListener.onExpirationUpdate(TPDownloadMediaDrm.this, sessionId, expirationTime);
                    }
                }
            }, handler);
        }
    }

    public static final class ProvisionRequest {
        String mDefaultUrl;
        byte[] mData;

        ProvisionRequest(String url, byte[] data) {
            this.mDefaultUrl = url;
            this.mData = data;
        }
    }

    public static final class KeyRequest {
        byte[] mData;
        int mRequestType;
        int mStatus;

        KeyRequest(int requestType, byte[] data, int status) {
            this.mRequestType = requestType;
            this.mData = data;
            this.mStatus = status;
        }
    }

    public static final class DownloadDrmSession {
        byte[] mSessionId;
        int mStatus;

        DownloadDrmSession(int status, byte[] sessionId) {
            this.mStatus = status;
            this.mSessionId = sessionId;
        }
    }

    static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(TPDownloadMediaDrm var1, byte[] var2, long var3);
    }

    static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(TPDownloadMediaDrm var1, byte[] var2, List<MediaDrm.KeyStatus> var3, boolean var4);
    }

    static interface OnEventListener {
        public void onEvent(TPDownloadMediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }
}

