/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.utils;

import com.tencent.thumbplayer.core.downloadproxy.jni.TPDownloadProxyNative;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPRequestItem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.json.JSONObject;

public class TPCGIRequester {
    private static final int MAX_RETRY_TIMES = 3;
    private static final int RETRY_INTERVAL = 3000;
    private static final int TIMEOUT = 3000;
    private static final String FILE_NAME = "TPCGIRequester";
    private static final int MSG_REPORT_URL = 2010;
    private static final int MSG_CONFIG_URL = 2011;
    private static final int MSG_WUJI_CONFIG_URL = 2013;
    private static volatile ExecutorService mCustomExecutor = null;
    private TimerTask mTimerTask;
    private LinkedBlockingQueue<TPRequestItem> mRetryQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<TPRequestItem> mRequestQueue = new LinkedBlockingQueue();
    private static TPCGIRequester mRequester = null;

    private TPCGIRequester() {
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                while (TPCGIRequester.this.mRetryQueue.peek() != null && System.currentTimeMillis() - ((TPRequestItem)TPCGIRequester.this.mRetryQueue.peek()).getRequestFailedTime() > 3000L) {
                    TPCGIRequester.this.addNotifyReqQueue((TPRequestItem)TPCGIRequester.this.mRetryQueue.poll());
                }
            }
        };
        new Timer(true).scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPCGIRequester getInstance() {
        if (mRequester != null) return mRequester;
        Class<TPCGIRequester> clazz = TPCGIRequester.class;
        synchronized (TPCGIRequester.class) {
            if (mRequester != null) return mRequester;
            mRequester = new TPCGIRequester();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mRequester;
        }
    }

    public void addRequestItem(String url, int requestType) {
        if (url.isEmpty()) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "request url null");
            return;
        }
        TPRequestItem tPRequestItem = new TPRequestItem(url, requestType);
        this.addNotifyReqQueue(tPRequestItem);
    }

    private void addNotifyReqQueue(TPRequestItem ri) {
        try {
            this.mRequestQueue.put(ri);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "RequestQueue add failed:" + throwable.toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExecutorService obtainThreadExcutor() {
        if (mCustomExecutor != null) return mCustomExecutor;
        Class<TPCGIRequester> clazz = TPCGIRequester.class;
        synchronized (TPCGIRequester.class) {
            if (mCustomExecutor != null) return mCustomExecutor;
            mCustomExecutor = Executors.newSingleThreadExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mCustomExecutor;
        }
    }

    private void process() {
        TPCGIRequester.obtainThreadExcutor().execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            TPRequestItem tPRequestItem;
                            if (TPCGIRequester.this.handleRequestItem(tPRequestItem = (TPRequestItem)TPCGIRequester.this.mRequestQueue.take())) {
                                continue;
                            }
                            tPRequestItem.updateFailedTime();
                            TPCGIRequester.this.addRetryRequestItem(tPRequestItem);
                        }
                    }
                    catch (Throwable throwable) {
                        TPDLProxyLog.e(TPCGIRequester.FILE_NAME, 0, "tpdlnative", "request queue take failed: " + throwable.toString());
                        continue;
                    }
                    break;
                }
            }
        });
    }

    private boolean handleRequestItem(TPRequestItem ri) {
        String string = ri.getUrl();
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(3000);
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 == 200 || n2 == 206) {
                bl = true;
                if (ri.getRequestType() == 2011 || ri.getRequestType() == 2013) {
                    String string2;
                    StringBuffer stringBuffer = new StringBuffer();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2);
                        stringBuffer.append("\n");
                    }
                    bufferedReader.close();
                    String string3 = stringBuffer.toString().replace("QZOutputJson=", "");
                    JSONObject jSONObject = new JSONObject(string3);
                    TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "start update config. responce data: ".concat(String.valueOf(string3)));
                    if (ri.getRequestType() == 2013) {
                        if (0 == jSONObject.getInt("code")) {
                            String string4 = jSONObject.getString("data");
                            TPDownloadProxyNative.getInstance().setUserData("proxy_config", string4);
                        }
                    } else if (0 == jSONObject.getInt("ret")) {
                        String string5 = jSONObject.getJSONObject("config").toString();
                        TPDownloadProxyNative.getInstance().setUserData("proxy_config", string5);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "Send Request Routine error:" + throwable.toString());
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return bl;
    }

    private void addRetryRequestItem(TPRequestItem ri) {
        try {
            if (ri.getRequestTimes() <= 3) {
                this.mRetryQueue.put(ri);
            }
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "retry queue add failed" + throwable.toString());
            return;
        }
    }
}

