/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.utils;

import android.content.Context;
import android.os.Environment;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TPDLIOUtil {
    private static final String FILE_NAME = "TPDLIOUtil";
    private static Pattern PROTOCOL_PATTERN = Pattern.compile("^(\\w+):/{2,3}");
    private static Pattern PATH_PATTERN = Pattern.compile("^(\\w+):/{2,3}(.*)");
    private static final String PROTOCOL_FILE = "file";
    private static final String PROTOCOL_ASSET = "asset";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";

    public static boolean isRemoteFile(String uri) {
        String string = TPDLIOUtil.getProtocol(uri);
        return string.equals(PROTOCOL_HTTPS) || string.equals(PROTOCOL_HTTP);
    }

    public static String getProtocol(String uri) {
        if (uri == null || uri.length() <= 0) {
            return PROTOCOL_FILE;
        }
        Matcher matcher = PROTOCOL_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return PROTOCOL_FILE;
    }

    public static InputStream open(Context context, String uri) {
        String string = TPDLIOUtil.getProtocol(uri);
        if (string.equals(PROTOCOL_ASSET)) {
            String string2 = TPDLIOUtil.getPath(uri);
            try {
                return context.getAssets().open(string2);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (string.equals(PROTOCOL_FILE)) {
            String string3 = TPDLIOUtil.getPath(uri);
            try {
                return new FileInputStream(string3);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (string.equals(PROTOCOL_HTTP) || string.equals(PROTOCOL_HTTPS)) {
            try {
                return new URL(uri).openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static String getPath(String uri) {
        if (uri == null) {
            return null;
        }
        Matcher matcher = PATH_PATTERN.matcher(uri);
        if (matcher.find() && matcher.group(1).equals(PROTOCOL_ASSET)) {
            return matcher.group(2);
        }
        return uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean write(File file, byte[] data, int offset, int length) {
        Object object;
        if (file == null) return false;
        if (data == null) return false;
        if (data.length <= 0) {
            return false;
        }
        if (!file.exists()) {
            object = file.getParentFile();
            if (object != null && !((File)object).mkdirs()) {
                return false;
            }
            try {
                if (!file.createNewFile()) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        object = null;
        try {
            object = new FileOutputStream(file);
            ((OutputStream)object).write(data, offset, length);
        }
        catch (Exception exception) {
            if (object == null) return false;
            try {
                ((OutputStream)object).close();
                return false;
            }
            catch (IOException iOException) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "write error:" + iOException.toString());
            }
            return false;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "write error:" + iOException.toString());
            }
            throw throwable;
        }
        try {
            ((OutputStream)object).close();
            return true;
        }
        catch (IOException iOException) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "write error:" + iOException.toString());
        }
        return true;
    }

    public static int copy(InputStream from, OutputStream to) {
        if (from == null || to == null) {
            return 0;
        }
        byte[] byArray = new byte[1024];
        int n2 = 0;
        try {
            int n3;
            while ((n3 = from.read(byArray)) > 0) {
                to.write(byArray, 0, n3);
                n2 += n3;
            }
        }
        catch (IOException iOException) {}
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(File from, File to) {
        int n2;
        Object object;
        if (from == null) return 0;
        if (to == null) {
            return 0;
        }
        if (!from.exists()) {
            return 0;
        }
        if (!to.exists()) {
            object = to.getParentFile();
            if (object == null) {
                return 0;
            }
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                return 0;
            }
        }
        object = null;
        FileOutputStream fileOutputStream = null;
        try {
            object = new FileInputStream(from);
            fileOutputStream = new FileOutputStream(to);
            n2 = TPDLIOUtil.copy((InputStream)object, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                if (object != null) {
                    ((FileInputStream)object).close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream == null) return 0;
                fileOutputStream.close();
                return 0;
            }
            catch (IOException iOException) {}
            return 0;
        }
        catch (Throwable throwable) {
            try {
                if (object != null) {
                    ((FileInputStream)object).close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
            return n2;
        }
        catch (IOException iOException) {}
        return n2;
    }

    public static OutputStream openOutputStream(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        return TPDLIOUtil.openOutputStream(new File(path));
    }

    public static OutputStream openOutputStream(File file) {
        if (file == null || !TPDLIOUtil.createFile(file)) {
            return null;
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static InputStream openInputStream(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        return TPDLIOUtil.openInputStream(new File(path));
    }

    public static InputStream openInputStream(File file) {
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static boolean createParentDirectories(File file) {
        if (file == null) {
            return false;
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            return file2.mkdirs();
        }
        return true;
    }

    public static boolean createParentDirectories(String file) {
        return TPDLIOUtil.createParentDirectories(new File(file));
    }

    public static boolean createFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            if (!TPDLIOUtil.createParentDirectories(file)) {
                return false;
            }
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public static boolean createFile(String file) {
        if (file == null || file.length() <= 0) {
            return false;
        }
        return TPDLIOUtil.createFile(new File(file));
    }

    public static File compare(File left, File right) {
        if (left == null) {
            return right;
        }
        if (right == null || !right.exists()) {
            return left;
        }
        if (!left.exists()) {
            return right;
        }
        if (left.lastModified() > right.lastModified()) {
            return left;
        }
        return right;
    }

    public static void recursiveDelete(File file) {
        try {
            if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    if (fileArray == null) {
                        return;
                    }
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        TPDLIOUtil.recursiveDelete(fileArray2[i2]);
                    }
                }
                boolean bl = file.delete();
                TPDLProxyLog.d(FILE_NAME, 0, "tpdlnative", "recursiveDelete: delete=".concat(String.valueOf(bl)));
            }
            return;
        }
        catch (Exception exception) {
            TPDLProxyLog.d(FILE_NAME, 0, "tpdlnative", "recursiveDelete failed, error:" + exception.toString());
            return;
        }
    }

    public static boolean isExternalStorageMounted() {
        return Environment.getExternalStorageState().equals("mounted");
    }
}

