/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.trtc.TRTCCloudDef;

@JNINamespace(value="liteav::trtc")
public class AudioCustomTrackJni {
    private int mPlayoutVolume = 100;
    private long mNativeAudioCustomTrackJni = AudioCustomTrackJni.nativeCreateAudioCustomTrackJni(this);

    public synchronized void enablePlayout(boolean enable) {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            AudioCustomTrackJni.nativeEnablePlayout(this.mNativeAudioCustomTrackJni, enable);
            if (enable) {
                AudioCustomTrackJni.nativeSetPlayoutVolume(this.mNativeAudioCustomTrackJni, this.mPlayoutVolume);
            }
        }
    }

    public synchronized int writeData(TRTCCloudDef.TRTCAudioFrame frame) {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            return AudioCustomTrackJni.nativeWriteData(this.mNativeAudioCustomTrackJni, new AudioFrame(frame));
        }
        return -1;
    }

    public synchronized void setPlayoutVolume(int playoutVolume) {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            this.mPlayoutVolume = playoutVolume;
            AudioCustomTrackJni.nativeSetPlayoutVolume(this.mNativeAudioCustomTrackJni, playoutVolume);
        }
    }

    public synchronized void pause() {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            AudioCustomTrackJni.nativePause(this.mNativeAudioCustomTrackJni);
        }
    }

    public synchronized void resume() {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            AudioCustomTrackJni.nativeResume(this.mNativeAudioCustomTrackJni);
        }
    }

    public synchronized void seek() {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            AudioCustomTrackJni.nativeSeek(this.mNativeAudioCustomTrackJni);
        }
    }

    public synchronized void clean() {
        if (this.mNativeAudioCustomTrackJni != 0L) {
            AudioCustomTrackJni.nativeClean(this.mNativeAudioCustomTrackJni);
        }
    }

    private static native long nativeCreateAudioCustomTrackJni(AudioCustomTrackJni var0);

    private static native void nativeEnablePlayout(long var0, boolean var2);

    private static native int nativeWriteData(long var0, AudioFrame var2);

    private static native void nativeSetPlayoutVolume(long var0, int var2);

    private static native void nativePause(long var0);

    private static native void nativeResume(long var0);

    private static native void nativeSeek(long var0);

    private static native void nativeClean(long var0);

    static class AudioFrame {
        private TRTCCloudDef.TRTCAudioFrame a;

        public AudioFrame(TRTCCloudDef.TRTCAudioFrame frame) {
            this.a = frame;
        }

        @CalledByNative(value="AudioFrame")
        public byte[] getData() {
            return this.a.data;
        }

        @CalledByNative(value="AudioFrame")
        public int getSampleRate() {
            return this.a.sampleRate;
        }

        @CalledByNative(value="AudioFrame")
        public int getChannel() {
            return this.a.channel;
        }

        @CalledByNative(value="AudioFrame")
        public long getTimestamp() {
            return this.a.timestamp;
        }
    }
}

