/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.videobase;

import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.n;
import com.tencent.liteav.videobase.videobase.b;
import com.tencent.liteav.videobase.videobase.c;
import com.tencent.liteav.videobase.videobase.d;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;

@JNINamespace(value="liteav::video")
public class DisplayTarget {
    private final com.tencent.liteav.base.util.b mUIHandler = new com.tencent.liteav.base.util.b(Looper.getMainLooper());
    private a mTargetType;
    private WeakReference<TXCloudVideoView> mTxCloudVideoView;
    private WeakReference<TextureView> mTextureView;
    private WeakReference<SurfaceView> mSurfaceView;
    private Surface mSurface;
    private int mWidth;
    private int mHeight;

    public DisplayTarget(@NonNull TXCloudVideoView txCloudVideoView) {
        this.mTxCloudVideoView = new WeakReference<TXCloudVideoView>(txCloudVideoView);
        this.mTargetType = a.d;
    }

    public DisplayTarget(TextureView textureView) {
        this.mTargetType = a.a;
        this.mTextureView = new WeakReference<TextureView>(textureView);
    }

    public DisplayTarget(SurfaceView surfaceView) {
        this.mTargetType = a.b;
        this.mSurfaceView = new WeakReference<SurfaceView>(surfaceView);
    }

    public DisplayTarget(Surface surface, int width, int height) {
        this.mSurface = surface;
        this.mWidth = width;
        this.mHeight = height;
        this.mTargetType = a.c;
    }

    public DisplayTarget(DisplayTarget displayTarget) {
        this.mSurface = displayTarget.mSurface;
        this.mWidth = displayTarget.mWidth;
        this.mHeight = displayTarget.mHeight;
        this.mTargetType = displayTarget.mTargetType;
        this.mTextureView = displayTarget.mTextureView;
        this.mSurfaceView = displayTarget.mSurfaceView;
        this.mTxCloudVideoView = displayTarget.mTxCloudVideoView;
    }

    public a getType() {
        return this.mTargetType;
    }

    public SurfaceView getSurfaceView() {
        if (this.mSurfaceView != null) {
            return (SurfaceView)this.mSurfaceView.get();
        }
        return null;
    }

    public TXCloudVideoView getTXCloudVideoView() {
        if (this.mTxCloudVideoView != null) {
            return (TXCloudVideoView)((Object)this.mTxCloudVideoView.get());
        }
        return null;
    }

    public TextureView getTextureView() {
        if (this.mTextureView != null) {
            return (TextureView)this.mTextureView.get();
        }
        return null;
    }

    public void setSurfaceView(SurfaceView surfaceView) {
        this.mSurfaceView = new WeakReference<SurfaceView>(surfaceView);
        this.mTargetType = a.b;
    }

    public void setTextureView(TextureView textureView) {
        this.mTextureView = new WeakReference<TextureView>(textureView);
        this.mTargetType = a.a;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void hideAll() {
        DisplayTarget displayTarget = this;
        displayTarget.setVisibility((View)displayTarget.getTextureView(), 8);
        DisplayTarget displayTarget2 = this;
        displayTarget2.setVisibility((View)displayTarget2.getSurfaceView(), 8);
        DisplayTarget displayTarget3 = this;
        displayTarget3.setVisibility((View)displayTarget3.getTXCloudVideoView(), 8);
        this.removeVideoView();
    }

    public void showAll() {
        this.addVideoView();
        DisplayTarget displayTarget = this;
        displayTarget.setVisibility((View)displayTarget.getTextureView(), 0);
        DisplayTarget displayTarget2 = this;
        displayTarget2.setVisibility((View)displayTarget2.getSurfaceView(), 0);
        DisplayTarget displayTarget3 = this;
        displayTarget3.setVisibility((View)displayTarget3.getTXCloudVideoView(), 0);
    }

    public n getSize() {
        int n2 = 0;
        int n3 = 0;
        if (this.mTargetType == a.c) {
            n2 = this.mWidth;
            n3 = this.mHeight;
        } else {
            View view = null;
            if (this.mTargetType == a.b && this.mSurfaceView != null) {
                view = (View)this.mSurfaceView.get();
            } else if (this.mTargetType == a.a && this.mTextureView != null) {
                view = (View)this.mTextureView.get();
            } else if (this.mTargetType == a.d && this.mTxCloudVideoView != null) {
                view = (View)this.mTxCloudVideoView.get();
            }
            if (view != null) {
                n2 = view.getWidth();
                n3 = view.getHeight();
            }
        }
        return new n(n2, n3);
    }

    public String toString() {
        return "DisplayTarget{mTargetType=" + (Object)((Object)this.mTargetType) + ", mTXCloudVideoView=" + (Object)((Object)this.getTXCloudVideoView()) + ", mTextureView=" + this.getTextureView() + ", mSurfaceView=" + this.getSurfaceView() + ", mSurface=" + this.mSurface + ", mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DisplayTarget displayTarget = (DisplayTarget)o2;
        return this.mWidth == displayTarget.mWidth && this.mHeight == displayTarget.mHeight && this.mTargetType == displayTarget.mTargetType && CommonUtil.equals((Object)this.getTXCloudVideoView(), (Object)displayTarget.getTXCloudVideoView()) && CommonUtil.equals(this.getTextureView(), displayTarget.getTextureView()) && CommonUtil.equals(this.getSurfaceView(), displayTarget.getSurfaceView()) && CommonUtil.equals(this.mSurface, displayTarget.mSurface);
    }

    @CalledByNative
    public static DisplayTarget createDisplayTarget(TXCloudVideoView view) {
        return new DisplayTarget(view);
    }

    private void runOnUIThread(Runnable task) {
        if (Looper.myLooper() == this.mUIHandler.getLooper()) {
            task.run();
            return;
        }
        this.mUIHandler.post(task);
    }

    private void setVisibility(View view, int visible) {
        if (view == null) {
            return;
        }
        this.runOnUIThread(b.a(view, visible));
    }

    private void addVideoView() {
        DisplayTarget displayTarget = this;
        displayTarget.runOnUIThread(c.a(displayTarget));
    }

    private void removeVideoView() {
        DisplayTarget displayTarget = this;
        displayTarget.runOnUIThread(d.a(displayTarget));
    }

    static /* synthetic */ void lambda$removeVideoView$2(DisplayTarget this_) {
        if (this_.getType() != a.d) {
            return;
        }
        TXCloudVideoView tXCloudVideoView = this_.getTXCloudVideoView();
        if (tXCloudVideoView == null) {
            return;
        }
        tXCloudVideoView.removeVideoView();
    }

    static /* synthetic */ void lambda$addVideoView$1(DisplayTarget this_) {
        if (this_.getType() != a.d) {
            return;
        }
        TXCloudVideoView tXCloudVideoView = this_.getTXCloudVideoView();
        if (tXCloudVideoView == null) {
            return;
        }
        if (tXCloudVideoView.getVideoView() != null) {
            return;
        }
        tXCloudVideoView.addVideoView(new TextureView(tXCloudVideoView.getContext()));
    }

    static /* synthetic */ void lambda$setVisibility$0(View view, int visible) {
        view.setVisibility(visible);
    }

    public static enum a {
        a,
        b,
        c,
        d;

    }
}

