/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.opengl.GLES20;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.b.g;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;

@JNINamespace(value="liteav::video")
public class VirtualCameraPixelFrameCreator {
    private final String mTAG = "VirtualCameraPixelFrameCreator" + this.hashCode();
    private final b mThrottlers = new b();
    private com.tencent.liteav.videobase.b.e mEGLCore;
    private e mGLTexturePool;

    @CalledByNative
    public VirtualCameraPixelFrameCreator(Object glContext) {
        this.initGLComponents(glContext);
    }

    private void initGLComponents(Object sharedContext) {
        LiteavLog.i(this.mTAG, "initGLComponents");
        this.mEGLCore = new com.tencent.liteav.videobase.b.e();
        try {
            this.mEGLCore.a(sharedContext, null, 128, 128);
            this.mEGLCore.a();
        }
        catch (g g2) {
            LiteavLog.e(this.mTAG, "initializeEGL failed.", g2);
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new e();
        }
    }

    private void uninitGLComponents() {
        LiteavLog.i(this.mTAG, "uninitGLComponents");
        if (this.mEGLCore == null) {
            return;
        }
        this.makeCurrent();
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        com.tencent.liteav.videobase.b.e.a(this.mEGLCore);
        this.mEGLCore = null;
    }

    @CalledByNative
    public PixelFrame createPixelFrame(Bitmap bitmap, int width, int height) {
        LiteavLog.i(this.mThrottlers.a("createPixelFrame"), this.mTAG, "createPixelFrame", new Object[0]);
        if (!this.makeCurrent()) {
            return null;
        }
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(bitmap).drawARGB(255, 0, 0, 0);
        }
        d d2 = this.mGLTexturePool.a(bitmap.getWidth(), bitmap.getHeight());
        OpenGlUtils.loadTexture(bitmap, d2.a(), false);
        PixelFrame pixelFrame = d2.a(this.mEGLCore.c());
        pixelFrame.setTimestamp(TimeUtil.a());
        d2.release();
        GLES20.glFinish();
        return pixelFrame;
    }

    @CalledByNative
    public void releasePixelFrame(PixelFrame pixelFrame) {
        LiteavLog.i(this.mThrottlers.a("releasePixelFrame"), this.mTAG, "releasePixelFrame", new Object[0]);
        if (pixelFrame == null) {
            return;
        }
        this.makeCurrent();
        pixelFrame.release();
    }

    @CalledByNative
    private void release() {
        this.uninitGLComponents();
    }

    private boolean makeCurrent() {
        if (this.mEGLCore == null) {
            return false;
        }
        try {
            this.mEGLCore.a();
            return true;
        }
        catch (g g2) {
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "EGLCore make current failed.", g2);
            return false;
        }
    }
}

