/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.text.TextUtils;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JNINamespace(value="liteav::manager")
public class TXAudioEffectManagerImpl
implements TXAudioEffectManager {
    private static final String TAG = "TXAudioEffectManagerImpl";
    private static final int EFFECT_PLAYER_ID_TYPE = 2;
    private long mNativeAudioEffectMgr = 0L;
    private List<Integer> mEffectIdList = new ArrayList<Integer>();
    private final MusicPlayObserver mMusicPlayObserver = new MusicPlayObserver();
    private final MusicPreloadObserver mMusicPreloadObserver = new MusicPreloadObserver();

    public TXAudioEffectManagerImpl(long nativeAudioEffectMgr) {
        this.mNativeAudioEffectMgr = nativeAudioEffectMgr;
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicObserver(this.mNativeAudioEffectMgr, this.mMusicPlayObserver);
            TXAudioEffectManagerImpl.nativeSetPreloadObserver(this.mNativeAudioEffectMgr, this.mMusicPreloadObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllAudioEffects() {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl tXAudioEffectManagerImpl = this;
            synchronized (tXAudioEffectManagerImpl) {
                for (Integer n2 : this.mEffectIdList) {
                    this.mMusicPlayObserver.removeObserver(TXAudioEffectManagerImpl.convertToEffectId(n2));
                    TXAudioEffectManagerImpl.nativeStopPlayMusic(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(n2));
                }
                this.mEffectIdList.clear();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllAudioEffectsVolume(int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl tXAudioEffectManagerImpl = this;
            synchronized (tXAudioEffectManagerImpl) {
                for (Integer n2 : this.mEffectIdList) {
                    this.setAudioEffectVolume(n2, volume);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playAudioEffect(TXAudioEffectManager.AudioMusicParam musicParam) {
        if (musicParam == null || TextUtils.isEmpty((CharSequence)musicParam.path)) {
            LiteavLog.e(TAG, "startPlayMusic invalid params");
            return;
        }
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeStartPlayMusic(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(musicParam.id), new AudioBgmParams(musicParam));
            TXAudioEffectManagerImpl tXAudioEffectManagerImpl = this;
            synchronized (tXAudioEffectManagerImpl) {
                this.mEffectIdList.add(musicParam.id);
                return;
            }
        }
    }

    public void setEffectObserver(int id, TXAudioEffectManager.TXMusicPlayObserver observer) {
        if (this.mNativeAudioEffectMgr != 0L) {
            if (observer != null) {
                this.mMusicPlayObserver.addObserver(TXAudioEffectManagerImpl.convertToEffectId(id), observer);
                return;
            }
            this.mMusicPlayObserver.removeObserver(TXAudioEffectManagerImpl.convertToEffectId(id));
        }
    }

    public void setAudioEffectVolume(int id, int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicPlayoutVolume(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(id), volume);
            TXAudioEffectManagerImpl.nativeSetMusicPublishVolume(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(id), volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAudioEffect(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            this.mMusicPlayObserver.removeObserver(TXAudioEffectManagerImpl.convertToEffectId(id));
            TXAudioEffectManagerImpl.nativeStopPlayMusic(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(id));
            TXAudioEffectManagerImpl tXAudioEffectManagerImpl = this;
            synchronized (tXAudioEffectManagerImpl) {
                int n2 = this.mEffectIdList.indexOf(id);
                if (n2 >= 0) {
                    this.mEffectIdList.remove(n2);
                }
                return;
            }
        }
    }

    public void pauseAudioEffect(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativePausePlayMusic(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(id));
        }
    }

    public void resumeAudioEffect(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeResumePlayMusic(this.mNativeAudioEffectMgr, TXAudioEffectManagerImpl.convertToEffectId(id));
        }
    }

    @Override
    public void enableVoiceEarMonitor(boolean enable) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeEnableVoiceEarMonitor(this.mNativeAudioEffectMgr, enable);
        }
    }

    @Override
    public void setVoiceEarMonitorVolume(int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetVoiceEarMonitorVolume(this.mNativeAudioEffectMgr, volume);
        }
    }

    @Override
    public void setVoiceReverbType(TXAudioEffectManager.TXVoiceReverbType type) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetVoiceReverbType(this.mNativeAudioEffectMgr, type.getNativeValue());
        }
    }

    @Override
    public void setVoiceChangerType(TXAudioEffectManager.TXVoiceChangerType type) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetVoiceChangerType(this.mNativeAudioEffectMgr, type.getNativeValue());
        }
    }

    @Override
    public void setVoiceCaptureVolume(int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetVoiceCaptureVolume(this.mNativeAudioEffectMgr, volume);
        }
    }

    @Override
    public void setVoicePitch(double pitch) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetVoicePitch(this.mNativeAudioEffectMgr, pitch);
        }
    }

    @Override
    public void setMusicObserver(int id, TXAudioEffectManager.TXMusicPlayObserver observer) {
        if (this.mNativeAudioEffectMgr != 0L) {
            if (observer != null) {
                this.mMusicPlayObserver.addObserver(id, observer);
                return;
            }
            this.mMusicPlayObserver.removeObserver(id);
        }
    }

    @Override
    public boolean startPlayMusic(TXAudioEffectManager.AudioMusicParam musicParam) {
        if (musicParam == null) {
            LiteavLog.e(TAG, "startPlayMusic invalid params");
            return false;
        }
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeStartPlayMusic(this.mNativeAudioEffectMgr, musicParam.id, new AudioBgmParams(musicParam));
        }
        return true;
    }

    @Override
    public void stopPlayMusic(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeStopPlayMusic(this.mNativeAudioEffectMgr, id);
        }
    }

    @Override
    public void pausePlayMusic(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativePausePlayMusic(this.mNativeAudioEffectMgr, id);
        }
    }

    @Override
    public void resumePlayMusic(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeResumePlayMusic(this.mNativeAudioEffectMgr, id);
        }
    }

    @Override
    public void setAllMusicVolume(int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetAllMusicVolume(this.mNativeAudioEffectMgr, volume);
        }
    }

    @Override
    public void setMusicPublishVolume(int id, int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicPublishVolume(this.mNativeAudioEffectMgr, id, volume);
        }
    }

    @Override
    public void setMusicPlayoutVolume(int id, int volume) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicPlayoutVolume(this.mNativeAudioEffectMgr, id, volume);
        }
    }

    @Override
    public void setMusicPitch(int id, float pitch) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicPitch(this.mNativeAudioEffectMgr, id, pitch);
        }
    }

    @Override
    public void setMusicSpeedRate(int id, float speedRate) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicSpeedRate(this.mNativeAudioEffectMgr, id, speedRate);
        }
    }

    @Override
    public int getMusicTrackCount(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            return TXAudioEffectManagerImpl.nativeGetMusicTrackCount(this.mNativeAudioEffectMgr, id);
        }
        return 0;
    }

    @Override
    public void setMusicTrack(int id, int trackIndex) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicTrack(this.mNativeAudioEffectMgr, id, trackIndex);
        }
    }

    @Override
    public long getMusicCurrentPosInMS(int id) {
        if (this.mNativeAudioEffectMgr != 0L) {
            return TXAudioEffectManagerImpl.nativeGetMusicCurrentPosInMS(this.mNativeAudioEffectMgr, id);
        }
        return 0L;
    }

    @Override
    public long getMusicDurationInMS(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            LiteavLog.e(TAG, "getMusicDurationInMS invalid params");
            return 0L;
        }
        if (this.mNativeAudioEffectMgr != 0L) {
            return TXAudioEffectManagerImpl.nativeGetMusicDurationInMS(this.mNativeAudioEffectMgr, path);
        }
        return 0L;
    }

    @Override
    public void seekMusicToPosInMS(int id, int pts) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSeekMusicToPosInMS(this.mNativeAudioEffectMgr, id, pts);
        }
    }

    @Override
    public void setMusicScratchSpeedRate(int id, float scratchSpeedRate) {
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeSetMusicScratchSpeedRate(this.mNativeAudioEffectMgr, id, scratchSpeedRate);
        }
    }

    @Override
    public void setPreloadObserver(TXAudioEffectManager.TXMusicPreloadObserver observer) {
        if (this.mNativeAudioEffectMgr != 0L) {
            this.mMusicPreloadObserver.setObserver(observer);
        }
    }

    @Override
    public boolean preloadMusic(TXAudioEffectManager.AudioMusicParam preloadParam) {
        if (preloadParam == null) {
            LiteavLog.e(TAG, "preloadMusic invalid params");
            return false;
        }
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativePreloadMusic(this.mNativeAudioEffectMgr, preloadParam.id, new AudioBgmParams(preloadParam));
        }
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeAudioEffectMgr != 0L) {
            TXAudioEffectManagerImpl.nativeDestroy(this.mNativeAudioEffectMgr);
            this.mNativeAudioEffectMgr = 0L;
        }
    }

    private static native void nativeDestroy(long var0);

    private static native void nativeEnableVoiceEarMonitor(long var0, boolean var2);

    private static native void nativeSetVoiceEarMonitorVolume(long var0, int var2);

    private static native void nativeSetVoiceReverbType(long var0, int var2);

    private static native void nativeSetVoiceChangerType(long var0, int var2);

    private static native void nativeSetVoiceCaptureVolume(long var0, int var2);

    private static native void nativeSetMusicObserver(long var0, MusicPlayObserver var2);

    private static native void nativeSetPreloadObserver(long var0, MusicPreloadObserver var2);

    private static native void nativeStartPlayMusic(long var0, long var2, AudioBgmParams var4);

    private static native void nativeStopPlayMusic(long var0, long var2);

    private static native void nativePausePlayMusic(long var0, long var2);

    private static native void nativeResumePlayMusic(long var0, long var2);

    private static native void nativeSetAllMusicVolume(long var0, int var2);

    private static native void nativeSetMusicPublishVolume(long var0, long var2, int var4);

    private static native void nativeSetMusicPlayoutVolume(long var0, long var2, int var4);

    private static native void nativeSetMusicPitch(long var0, long var2, float var4);

    private static native void nativeSetMusicSpeedRate(long var0, long var2, float var4);

    private static native int nativeGetMusicTrackCount(long var0, long var2);

    private static native void nativeSetMusicTrack(long var0, long var2, int var4);

    private static native long nativeGetMusicCurrentPosInMS(long var0, long var2);

    private static native long nativeGetMusicDurationInMS(long var0, String var2);

    private static native void nativeSeekMusicToPosInMS(long var0, long var2, long var4);

    private static native void nativeSetVoicePitch(long var0, double var2);

    private static native void nativeSetMusicScratchSpeedRate(long var0, long var2, float var4);

    private static native void nativePreloadMusic(long var0, long var2, AudioBgmParams var4);

    public static TXAudioEffectManager.TXVoiceReverbType voiceReverbTypeFromInt(int value) {
        if (value == 0) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_0;
        }
        if (value == 1) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_1;
        }
        if (value == 2) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_2;
        }
        if (value == 3) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_3;
        }
        if (value == 4) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_4;
        }
        if (value == 5) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_5;
        }
        if (value == 6) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_6;
        }
        if (value == 7) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_7;
        }
        if (value == 8) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_8;
        }
        if (value == 9) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_9;
        }
        if (value == 10) {
            return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_10;
        }
        return TXAudioEffectManager.TXVoiceReverbType.TXLiveVoiceReverbType_0;
    }

    public static TXAudioEffectManager.TXVoiceChangerType voiceChangerTypeFromInt(int value) {
        if (value == 0) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_0;
        }
        if (value == 1) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_1;
        }
        if (value == 2) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_2;
        }
        if (value == 3) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_3;
        }
        if (value == 4) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_4;
        }
        if (value == 5) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_5;
        }
        if (value == 6) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_6;
        }
        if (value == 7) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_7;
        }
        if (value == 8) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_8;
        }
        if (value == 9) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_9;
        }
        if (value == 10) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_10;
        }
        if (value == 11) {
            return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_11;
        }
        return TXAudioEffectManager.TXVoiceChangerType.TXLiveVoiceChangerType_0;
    }

    private static long convertToEffectId(int id) {
        return 0x200000000L | (long)id;
    }

    static class MusicPreloadObserver {
        private TXAudioEffectManager.TXMusicPreloadObserver mObserver;

        MusicPreloadObserver() {
        }

        public void setObserver(TXAudioEffectManager.TXMusicPreloadObserver observer) {
            this.mObserver = observer;
        }

        public void onLoadProgress(long id, int progress) {
            TXAudioEffectManager.TXMusicPreloadObserver tXMusicPreloadObserver = this.mObserver;
            if (tXMusicPreloadObserver != null) {
                tXMusicPreloadObserver.onLoadProgress((int)id, progress);
            }
        }

        public void onLoadError(long id, int errorCode) {
            TXAudioEffectManager.TXMusicPreloadObserver tXMusicPreloadObserver = this.mObserver;
            if (tXMusicPreloadObserver != null) {
                tXMusicPreloadObserver.onLoadError((int)id, errorCode);
            }
        }
    }

    static class MusicPlayObserver {
        private final HashMap<Long, TXAudioEffectManager.TXMusicPlayObserver> mObserverMap = new HashMap();

        MusicPlayObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObserver(long id, TXAudioEffectManager.TXMusicPlayObserver observer) {
            if (observer == null) {
                return;
            }
            MusicPlayObserver musicPlayObserver = this;
            synchronized (musicPlayObserver) {
                this.mObserverMap.put(id, observer);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObserver(long id) {
            MusicPlayObserver musicPlayObserver = this;
            synchronized (musicPlayObserver) {
                this.mObserverMap.remove(id);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStart(long id, int errCode) {
            TXAudioEffectManager.TXMusicPlayObserver observer;
            MusicPlayObserver musicPlayObserver = this;
            synchronized (musicPlayObserver) {
                observer = this.mObserverMap.get(id);
            }
            if (observer != null) {
                observer.onStart((int)id, errCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPlayProgress(long id, long curPtsMS, long durationMS) {
            TXAudioEffectManager.TXMusicPlayObserver observer;
            MusicPlayObserver musicPlayObserver = this;
            synchronized (musicPlayObserver) {
                observer = this.mObserverMap.get(id);
            }
            if (observer != null) {
                observer.onPlayProgress((int)id, curPtsMS, durationMS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(long id, int errCode) {
            TXAudioEffectManager.TXMusicPlayObserver observer;
            MusicPlayObserver musicPlayObserver = this;
            synchronized (musicPlayObserver) {
                observer = this.mObserverMap.get(id);
            }
            if (observer != null) {
                observer.onComplete((int)id, errCode);
            }
        }
    }

    static class AudioBgmParams {
        private TXAudioEffectManager.AudioMusicParam mParams;

        public AudioBgmParams(TXAudioEffectManager.AudioMusicParam param) {
            this.mParams = param;
        }

        public String getPath() {
            return this.mParams.path;
        }

        public int getLoopCount() {
            return this.mParams.loopCount;
        }

        public boolean isPublish() {
            return this.mParams.publish;
        }

        public long getStartTimeMS() {
            return this.mParams.startTimeMS;
        }

        public long getEndTimeMS() {
            return this.mParams.endTimeMS;
        }
    }
}

