/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2.route;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import com.tencent.liteav.audio2.route.a;
import com.tencent.liteav.audio2.route.b;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.util.Iterator;

@JNINamespace(value="liteav::audio")
public class AudioDeviceProperty
implements a.a {
    private static final String TAG = "AudioDeviceProperty";
    private a mAudioEventBroadcastReceiver;
    private b mBluetoothHeadsetListener;
    private long mNativeAudioDeviceProperty;
    private final AudioManager mAudioManager;
    private final Context mContext;
    private AudioDeviceCallback mAudioDeviceCallback;
    private boolean mAudioDeviceCallbackAvailable = false;

    public AudioDeviceProperty(long nativeAudioDeviceProperty) {
        this.mNativeAudioDeviceProperty = nativeAudioDeviceProperty;
        this.mContext = ContextUtils.getApplicationContext();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public void start() {
        this.registerAudioDeviceCallback();
        a a2 = this.mAudioEventBroadcastReceiver = new a(this.mContext, this);
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.HEADSET_PLUG");
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            intentFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
            a2.a.registerReceiver((BroadcastReceiver)a2, intentFilter);
        }
        catch (Throwable throwable) {
            Log.e("AudioEventBroadcastReceiver", "register broadcast exception", new Object[0]);
        }
        this.mBluetoothHeadsetListener = new b(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object;
        if (this.mAudioEventBroadcastReceiver != null) {
            object = this.mAudioEventBroadcastReceiver;
            if (((a)((Object)object)).a != null) {
                try {
                    ((a)((Object)object)).a.unregisterReceiver((BroadcastReceiver)object);
                }
                catch (Exception exception) {}
            }
        }
        this.mAudioEventBroadcastReceiver = null;
        if (this.mBluetoothHeadsetListener != null) {
            object = this.mBluetoothHeadsetListener;
            Object object2 = ((b)object).c;
            synchronized (object2) {
                if (((b)object).a != null && ((b)object).b != null) {
                    ((b)object).b();
                    ((b)object).b = null;
                }
            }
        }
        this.mBluetoothHeadsetListener = null;
        this.unregisterAudioDeviceCallback();
    }

    public void setVoip(boolean isVoip) {
        try {
            int n2 = isVoip ? 3 : 0;
            this.mAudioManager.setMode(n2);
            Log.i(TAG, "setMode ".concat(String.valueOf(n2)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "Set mode exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    public int getMode() {
        try {
            return this.mAudioManager.getMode();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "Get mode exception " + throwable.getMessage(), new Object[0]);
            return 0;
        }
    }

    public boolean isSpeakerphoneOn() {
        try {
            return this.mAudioManager.isSpeakerphoneOn();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isSpeakerphoneOn exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    public void setSpeakerphoneOn(boolean on) {
        try {
            this.mAudioManager.setSpeakerphoneOn(on);
            Log.i(TAG, "setSpeakerphoneOn ".concat(String.valueOf(on)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "setSpeakerphoneOn exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    public boolean isWiredHeadsetOn() {
        try {
            return this.mAudioManager.isWiredHeadsetOn();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isWiredHeadsetOn exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    public void setWiredHeadsetOn(boolean on) {
        try {
            this.mAudioManager.setWiredHeadsetOn(on);
            Log.i(TAG, "setWiredHeadsetOn ".concat(String.valueOf(on)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "setWiredHeadsetOn exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    public void setBluetoothScoOn(boolean on) {
        try {
            this.mAudioManager.setBluetoothScoOn(on);
            Log.i(TAG, "setBluetoothScoOn ".concat(String.valueOf(on)), new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "setBluetoothScoOn exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    public boolean isBluetoothScoOn() {
        try {
            return this.mAudioManager.isBluetoothScoOn();
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isBluetoothScoOn exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    public boolean isBluetoothScoConnected() {
        try {
            new IntentFilter();
            Intent intent = ContextUtils.getApplicationContext().registerReceiver(null, new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"));
            if (intent == null) {
                return false;
            }
            return intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0) == 1;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "isBluetoothScoConnected exception " + throwable.getMessage(), new Object[0]);
            return false;
        }
    }

    public boolean checkBluetoothPermission() {
        return b.a(this.mContext);
    }

    public void startBluetoothSco() {
        try {
            this.mAudioManager.startBluetoothSco();
            Log.i(TAG, "startBluetoothSco", new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "startBluetoothSco exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    public void stopBluetoothSco() {
        try {
            this.mAudioManager.stopBluetoothSco();
            Log.i(TAG, "stopBluetoothSco", new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.i(TAG, "stopBluetoothSco exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    public boolean isBluetoothHeadsetConnected() {
        if (this.mBluetoothHeadsetListener == null) {
            Log.e(TAG, "mBluetoothHeadsetListener is null", new Object[0]);
            return false;
        }
        return this.mBluetoothHeadsetListener.a();
    }

    public boolean isUsbHeadsetAvailable() {
        try {
            UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
            if (usbManager == null) {
                return false;
            }
            Iterator iterator = usbManager.getDeviceList().values().iterator();
            while (iterator.hasNext()) {
                if (!AudioDeviceProperty.isUsbHeadsetDevice((UsbDevice)iterator.next())) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            Log.i(TAG, "getDeviceList exception " + throwable.getMessage(), new Object[0]);
        }
        return false;
    }

    public UsbAudioDeviceInfo GetUsbAudioDeviceInfo(String name) {
        UsbAudioDeviceInfo usbAudioDeviceInfo = new UsbAudioDeviceInfo();
        try {
            UsbManager usbManager = (UsbManager)this.mContext.getSystemService("usb");
            if (usbManager == null || LiteavSystemInfo.getSystemOSVersionInt() < 21) {
                return usbAudioDeviceInfo;
            }
            for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
                if (!name.contains(usbDevice.getProductName()) && !AudioDeviceProperty.isUsbHeadsetDevice(usbDevice)) continue;
                usbAudioDeviceInfo.a = usbDevice.getProductName();
                usbAudioDeviceInfo.b = String.valueOf(usbDevice.getVendorId()) + usbDevice.getProductId();
                return usbAudioDeviceInfo;
            }
        }
        catch (Throwable throwable) {
            Log.i(TAG, "getDeviceList exception " + throwable.getMessage(), new Object[0]);
        }
        return usbAudioDeviceInfo;
    }

    @Override
    public void onWiredHeadsetConnectionChanged(boolean connected) {
        if (this.mAudioDeviceCallbackAvailable) {
            return;
        }
        AudioDeviceProperty.nativeNotifyWiredHeadsetConnectionChangedFromJava(this.mNativeAudioDeviceProperty, connected);
    }

    @Override
    public void onBluetoothConnectionChanged(boolean connected) {
        AudioDeviceProperty.nativeNotifyBluetoothConnectionChangedFromJava(this.mNativeAudioDeviceProperty, connected);
    }

    public static boolean isUsbHeadsetDevice(UsbDevice usbDevice) {
        if (usbDevice == null) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < usbDevice.getInterfaceCount(); ++i2) {
                if (usbDevice.getInterface(i2).getInterfaceClass() != 1) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Get interface exception " + throwable.getMessage(), new Object[0]);
        }
        return false;
    }

    private void registerAudioDeviceCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            return;
        }
        if (this.mAudioDeviceCallback == null) {
            this.buildAudioDeviceCallback();
        }
        if (this.mAudioDeviceCallback == null) {
            return;
        }
        try {
            this.mAudioManager.registerAudioDeviceCallback(this.mAudioDeviceCallback, null);
            Log.i(TAG, "register audio device callback", new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "registerAudioDeviceCallback exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    private void unregisterAudioDeviceCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            return;
        }
        if (this.mAudioDeviceCallback == null) {
            return;
        }
        try {
            this.mAudioManager.unregisterAudioDeviceCallback(this.mAudioDeviceCallback);
            Log.i(TAG, "unregister audio device callback", new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "unregisterAudioDeviceCallback exception " + throwable.getMessage(), new Object[0]);
            return;
        }
    }

    private void buildAudioDeviceCallback() {
        if (this.mAudioDeviceCallback != null) {
            return;
        }
        this.mAudioDeviceCallback = new AudioDeviceCallback(){

            public final void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                if (addedDevices.length == 0) {
                    return;
                }
                AudioDeviceProperty.this.mAudioDeviceCallbackAvailable = true;
                AudioDeviceInfo[] audioDeviceInfoArray = addedDevices;
                int n2 = addedDevices.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray[i2];
                    Log.i(AudioDeviceProperty.TAG, "added device type is " + audioDeviceInfo.getType() + " sink: " + audioDeviceInfo.isSink() + " product name: " + audioDeviceInfo.getProductName(), new Object[0]);
                    if (audioDeviceInfo.getType() == 8 && LiteavSystemInfo.getSystemOSVersionInt() > 30) {
                        AudioDeviceProperty.nativeNotifyBluetoothConnectionChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, true);
                        continue;
                    }
                    if (audioDeviceInfo.getType() == 11 || audioDeviceInfo.getType() == 12 || audioDeviceInfo.getType() == 22) {
                        AudioDeviceProperty.nativeNotifyUsbConnectionChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, audioDeviceInfo.getProductName().toString(), AudioDeviceProperty.this.isUsbHeadsetAvailable());
                        continue;
                    }
                    if (audioDeviceInfo.getType() != 3 && audioDeviceInfo.getType() != 4) continue;
                    AudioDeviceProperty.nativeNotifyWiredHeadsetConnectionChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, true);
                }
            }

            public final void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                if (removedDevices.length == 0) {
                    return;
                }
                AudioDeviceInfo[] audioDeviceInfoArray = removedDevices;
                int n2 = removedDevices.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray[i2];
                    Log.i(AudioDeviceProperty.TAG, "removed device type is " + audioDeviceInfo.getType() + " sink: " + audioDeviceInfo.isSink() + " product name: " + audioDeviceInfo.getProductName(), new Object[0]);
                    if (audioDeviceInfo.getType() == 8 && LiteavSystemInfo.getSystemOSVersionInt() > 30) {
                        AudioDeviceProperty.nativeNotifyBluetoothConnectionChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, false);
                        continue;
                    }
                    if (audioDeviceInfo.getType() == 11 || audioDeviceInfo.getType() == 12 || audioDeviceInfo.getType() == 22) {
                        AudioDeviceProperty.nativeNotifyUsbConnectionChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, audioDeviceInfo.getProductName().toString(), AudioDeviceProperty.this.isUsbHeadsetAvailable());
                        continue;
                    }
                    if (audioDeviceInfo.getType() != 3 && audioDeviceInfo.getType() != 4) continue;
                    AudioDeviceProperty.nativeNotifyWiredHeadsetConnectionChangedFromJava(AudioDeviceProperty.this.mNativeAudioDeviceProperty, false);
                }
            }
        };
    }

    @Override
    public void onBluetoothScoConnected(boolean connected) {
        AudioDeviceProperty.nativeNotifyBluetoothScoConnectedFromJava(this.mNativeAudioDeviceProperty, connected);
    }

    public int getSystemVolume() {
        int n2 = -1;
        try {
            n2 = this.mAudioManager.getStreamVolume(this.mAudioManager.getMode() == 0 ? 3 : 0);
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getStreamVolume exception " + throwable.getMessage(), new Object[0]);
        }
        return n2;
    }

    @Override
    public void onSystemVolumeChanged() {
        AudioDeviceProperty.nativeNotifySystemVolumeChangedFromJava(this.mNativeAudioDeviceProperty);
    }

    @Override
    public void onUsbConnectionChanged(String name, boolean connected) {
        if (this.mAudioDeviceCallbackAvailable) {
            return;
        }
        AudioDeviceProperty.nativeNotifyUsbConnectionChangedFromJava(this.mNativeAudioDeviceProperty, name, connected);
    }

    private static native void nativeNotifyWiredHeadsetConnectionChangedFromJava(long var0, boolean var2);

    private static native void nativeNotifyBluetoothConnectionChangedFromJava(long var0, boolean var2);

    private static native void nativeNotifyBluetoothScoConnectedFromJava(long var0, boolean var2);

    private static native void nativeNotifyUsbConnectionChangedFromJava(long var0, String var2, boolean var3);

    private static native void nativeNotifySystemVolumeChangedFromJava(long var0);

    public static class UsbAudioDeviceInfo {
        public String a = "";
        public String b = "";

        public String getName() {
            return this.a;
        }

        public String getVidPid() {
            return this.b;
        }
    }
}

