/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.device;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.device.TXDeviceManager;

@JNINamespace(value="liteav::manager")
public class TXDeviceManagerImpl
implements TXDeviceManager {
    private long mNativeDeviceMgr = 0L;

    public TXDeviceManagerImpl(long nativeDevicetMgr) {
        this.mNativeDeviceMgr = nativeDevicetMgr;
    }

    public boolean isCameraTorchSupported() {
        if (this.mNativeDeviceMgr == 0L) {
            return false;
        }
        return TXDeviceManagerImpl.nativeIsCameraTorchSupported(this.mNativeDeviceMgr);
    }

    public boolean isCameraFocusPositionInPreviewSupported() {
        if (this.mNativeDeviceMgr == 0L) {
            return false;
        }
        return TXDeviceManagerImpl.nativeIsCameraFocusPositionInPreviewSupported(this.mNativeDeviceMgr);
    }

    public boolean isCameraAutoFocusFaceModeSupported() {
        if (this.mNativeDeviceMgr == 0L) {
            return false;
        }
        return TXDeviceManagerImpl.nativeIsCameraAutoFocusFaceModeSupported(this.mNativeDeviceMgr);
    }

    @Override
    public boolean isFrontCamera() {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeIsFrontCamera(this.mNativeDeviceMgr);
        }
        return false;
    }

    @Override
    public int switchCamera(boolean frontCamera) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeSwitchCamera(this.mNativeDeviceMgr, frontCamera);
        }
        return 0;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeGetCameraZoomMaxRatio(this.mNativeDeviceMgr);
        }
        return 0.0f;
    }

    @Override
    public int setCameraZoomRatio(float zoomRatio) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeSetCameraZoomRatio(this.mNativeDeviceMgr, zoomRatio);
        }
        return 0;
    }

    @Override
    public int enableCameraAutoFocus(boolean enabled) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeEnableCameraAutoFocus(this.mNativeDeviceMgr, enabled);
        }
        return 0;
    }

    @Override
    public boolean isAutoFocusEnabled() {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeIsAutoFocusEnabled(this.mNativeDeviceMgr);
        }
        return false;
    }

    @Override
    public boolean enableCameraTorch(boolean enable) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeEnableCameraTorch(this.mNativeDeviceMgr, enable);
        }
        return false;
    }

    @Override
    public int setCameraFocusPosition(int x, int y) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeSetCameraFocusPosition(this.mNativeDeviceMgr, x, y);
        }
        return 0;
    }

    @Override
    public int setAudioRoute(TXDeviceManager.TXAudioRoute route) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeSetAudioRoute(this.mNativeDeviceMgr, TXDeviceManagerImpl.audioRouteAsInt(route));
        }
        return 0;
    }

    @Override
    public int setSystemVolumeType(TXDeviceManager.TXSystemVolumeType type) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeSetSystemVolumeType(this.mNativeDeviceMgr, TXDeviceManagerImpl.systemVolumeTypeAsInt(type));
        }
        return 0;
    }

    @Override
    public void setCameraCapturerParam(TXDeviceManager.TXCameraCaptureParam params) {
        if (this.mNativeDeviceMgr != 0L) {
            TXDeviceManagerImpl.nativeSetCameraCapturerParam(this.mNativeDeviceMgr, new CameraCaptureParam(params));
        }
    }

    @Override
    public int setExposureCompensation(float value) {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeSetExposureCompensation(this.mNativeDeviceMgr, value);
        }
        return 0;
    }

    public boolean isCameraZoomSupported() {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeIsCameraZoomSupported(this.mNativeDeviceMgr);
        }
        return false;
    }

    public boolean isLowLatencyEarMonitorSupported() {
        if (this.mNativeDeviceMgr != 0L) {
            return TXDeviceManagerImpl.nativeIsLowLatencyEarMonitorSupported(this.mNativeDeviceMgr);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeDeviceMgr != 0L) {
            TXDeviceManagerImpl.nativeDestroy(this.mNativeDeviceMgr);
            this.mNativeDeviceMgr = 0L;
        }
    }

    private static native void nativeDestroy(long var0);

    private static native boolean nativeIsCameraTorchSupported(long var0);

    private static native boolean nativeIsCameraFocusPositionInPreviewSupported(long var0);

    private static native boolean nativeIsCameraAutoFocusFaceModeSupported(long var0);

    private static native boolean nativeIsFrontCamera(long var0);

    private static native int nativeSwitchCamera(long var0, boolean var2);

    private static native float nativeGetCameraZoomMaxRatio(long var0);

    private static native int nativeSetCameraZoomRatio(long var0, float var2);

    private static native int nativeEnableCameraAutoFocus(long var0, boolean var2);

    private static native boolean nativeIsAutoFocusEnabled(long var0);

    private static native boolean nativeEnableCameraTorch(long var0, boolean var2);

    private static native int nativeSetCameraFocusPosition(long var0, int var2, int var3);

    private static native int nativeSetAudioRoute(long var0, int var2);

    private static native int nativeSetSystemVolumeType(long var0, int var2);

    private static native void nativeSetCameraCapturerParam(long var0, CameraCaptureParam var2);

    private static native int nativeSetExposureCompensation(long var0, float var2);

    private static native boolean nativeIsCameraZoomSupported(long var0);

    private static native boolean nativeIsLowLatencyEarMonitorSupported(long var0);

    public static int systemVolumeTypeAsInt(TXDeviceManager.TXSystemVolumeType type) {
        int n2 = 0;
        if (type == TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeAuto) {
            n2 = 0;
        } else if (type == TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeMedia) {
            n2 = 1;
        } else if (type == TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeVOIP) {
            n2 = 2;
        }
        return n2;
    }

    public static TXDeviceManager.TXSystemVolumeType systemVolumeTypefromInt(int value) {
        if (value == 0) {
            return TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeAuto;
        }
        if (value == 1) {
            return TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeMedia;
        }
        if (value == 2) {
            return TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeVOIP;
        }
        return TXDeviceManager.TXSystemVolumeType.TXSystemVolumeTypeAuto;
    }

    public static int audioRouteAsInt(TXDeviceManager.TXAudioRoute audioRoute) {
        int n2 = 0;
        if (audioRoute == TXDeviceManager.TXAudioRoute.TXAudioRouteSpeakerphone) {
            n2 = 0;
        } else if (audioRoute == TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece) {
            n2 = 1;
        }
        return n2;
    }

    public static TXDeviceManager.TXAudioRoute audioRouteFromInt(int value) {
        if (value == 0) {
            return TXDeviceManager.TXAudioRoute.TXAudioRouteSpeakerphone;
        }
        if (value == 1) {
            return TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece;
        }
        return TXDeviceManager.TXAudioRoute.TXAudioRouteSpeakerphone;
    }

    public static int cameraCaptureModeAsInt(TXDeviceManager.TXCameraCaptureMode mode) {
        int n2 = 0;
        if (mode == TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyAuto) {
            n2 = 0;
        } else if (mode == TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyPerformance) {
            n2 = 1;
        } else if (mode == TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyHighQuality) {
            n2 = 2;
        } else if (mode == TXDeviceManager.TXCameraCaptureMode.TXCameraCaptureManual) {
            n2 = 3;
        }
        return n2;
    }

    public static TXDeviceManager.TXCameraCaptureMode cameraCaptureModeFromInt(int value) {
        if (value == 0) {
            return TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyAuto;
        }
        if (value == 1) {
            return TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyPerformance;
        }
        if (value == 2) {
            return TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyHighQuality;
        }
        if (value == 3) {
            return TXDeviceManager.TXCameraCaptureMode.TXCameraCaptureManual;
        }
        return TXDeviceManager.TXCameraCaptureMode.TXCameraResolutionStrategyAuto;
    }

    static class CameraCaptureParam {
        private TXDeviceManager.TXCameraCaptureParam mParams;

        public CameraCaptureParam(TXDeviceManager.TXCameraCaptureParam param) {
            this.mParams = param;
        }

        public int getMode() {
            return TXDeviceManagerImpl.cameraCaptureModeAsInt(this.mParams.mode);
        }

        public int getWidth() {
            return this.mParams.width;
        }

        public int getHeight() {
            return this.mParams.height;
        }
    }
}

