/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.videobase;

import android.app.Activity;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.base.util.k;

@JNINamespace(value="liteav::video")
public class SystemDisplayInfo {
    private static final String TAG = "SystemDisplayInfo";

    public static Display getDisplay() {
        Display display = SystemDisplayInfo.getDisplayByDisplayManager();
        if (display != null) {
            return display;
        }
        return SystemDisplayInfo.getDefaultDisplayByWindowManager();
    }

    public static Size getDisplaySize() {
        try {
            Display display = SystemDisplayInfo.getDisplay();
            if (display != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getRealMetrics(displayMetrics);
                return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "error getting display size.", exception);
        }
        return new Size(720, 1280);
    }

    public static int getDisplayRotationDegree() {
        return SystemDisplayInfo.getDisplayRotation().mValue;
    }

    public static k getDisplayRotation() {
        k k2 = SystemDisplayInfo.getDisplayRotationCorrection();
        if (k2 != null) {
            return k2;
        }
        try {
            Display display = SystemDisplayInfo.getDisplay();
            if (display != null) {
                return SystemDisplayInfo.surfaceRotationEnumToRotation(display.getRotation());
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "error getting display rotation.", exception);
        }
        return k.a;
    }

    private static Display getDisplayByDisplayManager() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 32) {
            return null;
        }
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            LiteavLog.e(TAG, "context is null.");
            return null;
        }
        try {
            return ((DisplayManager)context.getSystemService("display")).getDisplay(0);
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "error getting display from display service.", throwable);
            return null;
        }
    }

    private static Display getDefaultDisplayByWindowManager() {
        Activity activity = i.a().c();
        Object object = activity != null ? activity : ContextUtils.getApplicationContext();
        if (object == null) {
            LiteavLog.e(TAG, "context is null.");
            return null;
        }
        try {
            return ((WindowManager)object.getSystemService("window")).getDefaultDisplay();
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "error getting display from window service.", throwable);
            return null;
        }
    }

    private static k surfaceRotationEnumToRotation(int surfaceRotationEnum) {
        switch (surfaceRotationEnum) {
            case 1: {
                return k.b;
            }
            case 2: {
                return k.c;
            }
            case 3: {
                return k.d;
            }
        }
        return k.a;
    }

    private static k getDisplayRotationCorrection() {
        int n2 = SystemDisplayInfo.nativeGetDisplayRotationCorrection();
        if (k.b(n2)) {
            return k.a(n2);
        }
        return null;
    }

    private static synchronized native int nativeGetDisplayRotationCorrection();
}

