/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.video;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.IBinder;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videoproducer.capture.VirtualDisplayManager;

public class ScreenCaptureService
extends Service {
    private static final String TAG = "ScreenCaptureService";
    private static final int NOTIFICATION_ID = 13957237;
    private static final String CHANNEL_ID = "notification_id";

    public IBinder onBind(Intent intent) {
        LiteavLog.i(TAG, "Service on bind");
        return new Binder();
    }

    public boolean onUnbind(Intent intent) {
        LiteavLog.i(TAG, "Service on unbind");
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        this.stopForeground(true);
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int n2 = intent.getIntExtra("code", -1);
        Intent intent2 = (Intent)intent.getParcelableExtra("data");
        LiteavLog.i(TAG, "On Start server command, code:" + n2 + ", data:" + intent2);
        if (intent2 == null) {
            this.stopSelf();
            return 2;
        }
        try {
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 29) {
                this.startForeground(13957237, this.createNotification(), 32);
            } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
                this.startForeground(13957237, this.createNotification());
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "start foreground failed.", throwable);
        }
        MediaProjection mediaProjection = null;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
            MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
            try {
                mediaProjection = mediaProjectionManager.getMediaProjection(n2, intent2);
            }
            catch (Throwable throwable) {
                LiteavLog.e(TAG, "onStartCommand mediaProjectionManager getMediaProjection fail.", throwable);
            }
            VirtualDisplayManager.a((Context)this).a(mediaProjection);
        }
        return 2;
    }

    private Notification createNotification() {
        NotificationManager notificationManager;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
            notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)"notification_name", 2);
            notificationManager.createNotificationChannel(notificationChannel);
        }
        notificationManager = new Notification.Builder((Context)this).setDefaults(1);
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
            notificationManager.setChannelId(CHANNEL_ID);
        }
        return notificationManager.build();
    }
}

