/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.utils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.utils.Rotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

@JNINamespace(value="liteav::video")
public class OpenGlUtils {
    private static final String TAG = "OpenGlUtils";

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static Object getCurrentContext() {
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 17) {
            return EGL14.eglGetCurrentContext();
        }
        return ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    public static long getGLContextNativeHandle(Object glContext) {
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 17 && glContext instanceof android.opengl.EGLContext) {
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
                return ((android.opengl.EGLContext)glContext).getNativeHandle();
            }
            return ((android.opengl.EGLContext)glContext).getHandle();
        }
        return 0L;
    }

    public static void bindTexture(int target, int texture) {
        GLES20.glBindTexture((int)target, (int)texture);
    }

    public static void bindFramebuffer(int target, int framebuffer) {
        GLES20.glBindFramebuffer((int)target, (int)framebuffer);
    }

    public static void attachTextureToFrameBuffer(int textureId, int frameBufferId) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureId, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public static void detachTextureFromFrameBuffer(int frameBufferId) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)0, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public static void glViewport(int x2, int y2, int width, int height) {
        GLES20.glViewport((int)x2, (int)y2, (int)width, (int)height);
    }

    public static int generateTextureOES() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)36197, (int)nArray[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return nArray[0];
    }

    public static int createTexture(int width, int height, int internalFormat, int format) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        LiteavLog.d(TAG, "glGenTextures textureId: " + nArray[0]);
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)5121, null);
        return nArray[0];
    }

    public static int loadTexture(Bitmap img, int usedTexId, boolean recycle) {
        int[] nArray = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            LiteavLog.d(TAG, "glGenTextures textureId: " + nArray[0]);
            OpenGlUtils.bindTexture(3553, nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)img, (int)0);
        } else {
            OpenGlUtils.bindTexture(3553, usedTexId);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)img);
            nArray[0] = usedTexId;
        }
        if (recycle) {
            img.recycle();
        }
        return nArray[0];
    }

    public static int loadTexture(int format, Buffer data, int width, int height, int usedTexId) {
        int[] nArray = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            LiteavLog.d(TAG, "glGenTextures textureId: " + nArray[0]);
            OpenGlUtils.bindTexture(3553, nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, (Buffer)data);
        } else {
            OpenGlUtils.bindTexture(3553, usedTexId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)format, (int)5121, (Buffer)data);
            nArray[0] = usedTexId;
        }
        return nArray[0];
    }

    public static int generateFrameBufferId() {
        int[] nArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        return nArray[0];
    }

    public static void deleteTexture(int textureId) {
        if (textureId != -1) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        }
    }

    public static void deleteFrameBuffer(int frameBufferId) {
        if (frameBufferId != -1) {
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{frameBufferId}, (int)0);
        }
    }

    public static void deleteShaderId(int shaderId) {
        if (shaderId != -1) {
            GLES20.glDeleteShader((int)shaderId);
        }
    }

    public static FloatBuffer createNormalCubeVerticesBuffer() {
        return (FloatBuffer)ByteBuffer.allocateDirect(GLConstants.c.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(GLConstants.c).position(0);
    }

    public static FloatBuffer createTextureCoordsBuffer(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] fArray = new float[GLConstants.d.length];
        OpenGlUtils.initTextureCoordsBuffer(fArray, rotation, flipHorizontal, flipVertical);
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(GLConstants.d.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray).position(0);
        return floatBuffer;
    }

    public static void initTextureCoordsBuffer(float[] textureCoords, Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] fArray = GLConstants.d;
        if (rotation != null) {
            switch (rotation) {
                case b: {
                    fArray = GLConstants.f;
                    break;
                }
                case c: {
                    fArray = GLConstants.g;
                    break;
                }
                case d: {
                    fArray = GLConstants.e;
                    break;
                }
                default: {
                    fArray = GLConstants.d;
                }
            }
        }
        System.arraycopy(fArray, 0, textureCoords, 0, fArray.length);
        if (flipHorizontal) {
            textureCoords[0] = OpenGlUtils.flip(textureCoords[0]);
            textureCoords[2] = OpenGlUtils.flip(textureCoords[2]);
            textureCoords[4] = OpenGlUtils.flip(textureCoords[4]);
            textureCoords[6] = OpenGlUtils.flip(textureCoords[6]);
        }
        if (flipVertical) {
            textureCoords[1] = OpenGlUtils.flip(textureCoords[1]);
            textureCoords[3] = OpenGlUtils.flip(textureCoords[3]);
            textureCoords[5] = OpenGlUtils.flip(textureCoords[5]);
            textureCoords[7] = OpenGlUtils.flip(textureCoords[7]);
        }
    }

    private static float flip(float i2) {
        if (i2 == 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static Point reverseMappingPoint(GLConstants.GLScaleType scaleType, Rotation rotation, Point scaledPoint, Size scaledSize, Size fromSize) {
        float f2;
        float f3 = (float)fromSize.width * 1.0f / (float)scaledSize.width;
        float f4 = (float)fromSize.height * 1.0f / (float)scaledSize.height;
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(-scaledSize.width) / 2.0f, (float)(-scaledSize.height) / 2.0f);
        if (scaleType == GLConstants.GLScaleType.a) {
            float f5 = f2 = Math.min(f3, f4);
            matrix.postScale(f5, f5);
        } else if (scaleType == GLConstants.GLScaleType.c) {
            matrix.postScale(f3, f4);
        } else if (scaleType == GLConstants.GLScaleType.b) {
            float f6 = f2 = Math.max(f3, f4);
            matrix.postScale(f6, f6);
        }
        matrix.postRotate((float)(360 - rotation.mValue));
        if (rotation == Rotation.b || rotation == Rotation.d) {
            matrix.postTranslate((float)fromSize.height / 2.0f, (float)fromSize.width / 2.0f);
        } else {
            matrix.postTranslate((float)fromSize.width / 2.0f, (float)fromSize.height / 2.0f);
        }
        float[] fArray = new float[2];
        matrix.mapPoints(fArray, new float[]{scaledPoint.x, scaledPoint.y});
        return new Point((int)fArray[0], (int)fArray[1]);
    }

    public static void checkGlError(String op) {
    }

    public static void loadYuv420DataToTextures(ByteBuffer yuvData, int uvFormat, int width, int height, int[] usedTexIds) {
        if (yuvData.isDirect()) {
            OpenGlUtils.nativeLoadYuv420ByteBufferToTextures(yuvData, uvFormat, width, height, usedTexIds);
            return;
        }
        OpenGlUtils.nativeLoadYuv420ByteArrayToTextures(yuvData.array(), uvFormat, width, height, usedTexIds);
    }

    public static void convertYuvFormat(GLConstants.PixelFormatType srcFormatType, Object srcData, GLConstants.PixelFormatType destFormatType, Object destData, int width, int height) {
        int n2 = srcFormatType.getValue();
        int n3 = destFormatType.getValue();
        boolean bl2 = srcData instanceof ByteBuffer && destData instanceof ByteBuffer ? OpenGlUtils.nativeConvertYuvFormatBufferToBuffer(n2, (ByteBuffer)srcData, n3, (ByteBuffer)destData, width, height) : (srcData instanceof ByteBuffer && destData instanceof byte[] ? OpenGlUtils.nativeConvertYuvFormatBufferToArray(n2, (ByteBuffer)srcData, n3, (byte[])destData, width, height) : (srcData instanceof byte[] && destData instanceof ByteBuffer ? OpenGlUtils.nativeConvertYuvFormatArrayToBuffer(n2, (byte[])srcData, n3, (ByteBuffer)destData, width, height) : OpenGlUtils.nativeConvertYuvFormatArrayToArray(n2, (byte[])srcData, n3, (byte[])destData, width, height)));
        if (!bl2) {
            throw new IllegalArgumentException("Do not support " + (Object)((Object)srcFormatType) + " to " + (Object)((Object)destFormatType));
        }
    }

    public static void readPixels(int x2, int y2, int width, int height, Object buffer) {
        if (buffer instanceof Buffer) {
            ((Buffer)buffer).position(0);
            GLES20.glReadPixels((int)x2, (int)y2, (int)width, (int)height, (int)6408, (int)5121, (Buffer)((Buffer)buffer));
            return;
        }
        if (!(buffer instanceof byte[])) {
            LiteavLog.e(TAG, "read pixels failed due to unsupport object. ".concat(String.valueOf(buffer)));
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])buffer);
        GLES20.glReadPixels((int)x2, (int)y2, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
    }

    public static native void nativeCopyDataFromByteBufferToByteBuffer(ByteBuffer var0, ByteBuffer var1, int var2);

    public static native void nativeCopyDataFromByteBufferToByteArray(ByteBuffer var0, byte[] var1, int var2);

    public static native void nativeCopyDataFromByteArrayToByteBuffer(byte[] var0, ByteBuffer var1, int var2);

    private static native void nativeLoadYuv420ByteArrayToTextures(byte[] var0, int var1, int var2, int var3, int[] var4);

    private static native void nativeLoadYuv420ByteBufferToTextures(ByteBuffer var0, int var1, int var2, int var3, int[] var4);

    private static native boolean nativeConvertYuvFormatBufferToBuffer(int var0, ByteBuffer var1, int var2, ByteBuffer var3, int var4, int var5);

    private static native boolean nativeConvertYuvFormatBufferToArray(int var0, ByteBuffer var1, int var2, byte[] var3, int var4, int var5);

    private static native boolean nativeConvertYuvFormatArrayToBuffer(int var0, byte[] var1, int var2, ByteBuffer var3, int var4, int var5);

    private static native boolean nativeConvertYuvFormatArrayToArray(int var0, byte[] var1, int var2, byte[] var3, int var4, int var5);
}

