/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import java.lang.reflect.Field;
import org.json.JSONArray;
import org.json.JSONException;

@JNINamespace(value="liteav::video")
public final class VideoEncodeParams
implements Cloneable {
    public int width = 0;
    public int height = 0;
    public int fps = 20;
    public int gop = 3;
    public int bitrate = 0;
    public boolean annexb = true;
    public VideoEncoderDef.EncoderProfile encoderProfile = null;
    public VideoEncoderDef.BitrateMode bitrateMode = VideoEncoderDef.BitrateMode.a;
    public long baseFrameIndex = 0L;
    public long baseGopIndex = 0L;
    public boolean fullIFrame = false;
    public boolean enableBFrame = false;
    public VideoEncoderDef.ReferenceStrategy referenceStrategy = VideoEncoderDef.ReferenceStrategy.a;
    public CodecType codecType = CodecType.b;
    public boolean isTranscodingMode = false;
    public VideoEncoderDef.EncoderComplexity encoderComplexity = null;
    public JSONArray mediaCodecDeviceRelatedParams = null;

    @CalledByNative
    public VideoEncodeParams() {
    }

    public VideoEncodeParams(VideoEncodeParams copyFrom) {
        if (copyFrom == null) {
            return;
        }
        this.width = copyFrom.width;
        this.height = copyFrom.height;
        this.fps = copyFrom.fps;
        this.gop = copyFrom.gop;
        this.bitrate = copyFrom.bitrate;
        this.annexb = copyFrom.annexb;
        this.encoderProfile = copyFrom.encoderProfile;
        this.bitrateMode = copyFrom.bitrateMode;
        this.baseFrameIndex = copyFrom.baseFrameIndex;
        this.baseGopIndex = copyFrom.baseGopIndex;
        this.fullIFrame = copyFrom.fullIFrame;
        this.enableBFrame = copyFrom.enableBFrame;
        this.codecType = copyFrom.codecType;
        this.referenceStrategy = copyFrom.referenceStrategy;
        this.isTranscodingMode = copyFrom.isTranscodingMode;
        this.encoderComplexity = copyFrom.encoderComplexity;
        if (copyFrom.mediaCodecDeviceRelatedParams != null) {
            try {
                this.mediaCodecDeviceRelatedParams = new JSONArray(copyFrom.mediaCodecDeviceRelatedParams.toString());
                return;
            }
            catch (JSONException jSONException) {}
        }
    }

    @CalledByNative
    public final int getWidth() {
        return this.width;
    }

    @CalledByNative
    public final int getHeight() {
        return this.height;
    }

    @CalledByNative
    public final int getFps() {
        return this.fps;
    }

    @CalledByNative
    public final int getGop() {
        return this.gop;
    }

    @CalledByNative
    public final int getBitrate() {
        return this.bitrate;
    }

    @CalledByNative
    public final int getEncoderProfile() {
        return this.encoderProfile.mValue;
    }

    @CalledByNative
    public final int getBitrateMode() {
        return this.bitrateMode.mValue;
    }

    @CalledByNative
    public final long getBaseFrameIndex() {
        return this.baseFrameIndex;
    }

    @CalledByNative
    public final long getBaseGopIndex() {
        return this.baseGopIndex;
    }

    @CalledByNative
    public final int getCodecType() {
        return this.codecType.mValue;
    }

    public final VideoEncoderDef.ReferenceStrategy getReferenceStrategy() {
        return this.referenceStrategy;
    }

    public final JSONArray getMediaCodecDeviceRelatedParams() {
        return this.mediaCodecDeviceRelatedParams;
    }

    @CalledByNative
    public final boolean isEnablesBframe() {
        return this.enableBFrame;
    }

    @CalledByNative
    public final boolean isEnablesRps() {
        return this.referenceStrategy == VideoEncoderDef.ReferenceStrategy.b;
    }

    @CalledByNative
    public final boolean isEnablesSvc() {
        return this.referenceStrategy == VideoEncoderDef.ReferenceStrategy.c;
    }

    @CalledByNative
    public final boolean isFullIFrame() {
        return this.fullIFrame;
    }

    @CalledByNative
    public final boolean isAnnexb() {
        return this.annexb;
    }

    @CalledByNative
    public final boolean isTranscodingMode() {
        return this.isTranscodingMode;
    }

    @CalledByNative
    public final void setBFrameEnabled(boolean enableBFrame) {
        this.enableBFrame = enableBFrame;
    }

    @CalledByNative
    public final void setReferenceStrategy(VideoEncoderDef.ReferenceStrategy strategy) {
        this.referenceStrategy = strategy;
    }

    @CalledByNative
    public final void setTranscodingModeEnabled(boolean enableTranscodingMode) {
        this.isTranscodingMode = enableTranscodingMode;
    }

    @CalledByNative
    public final void setEncoderComplexity(VideoEncoderDef.EncoderComplexity encoderComplexity) {
        this.encoderComplexity = encoderComplexity;
    }

    @CalledByNative
    public final int getEncoderComplexity() {
        if (this.encoderComplexity == null) {
            return VideoEncoderDef.EncoderComplexity.e.mValue;
        }
        return this.encoderComplexity.mValue;
    }

    @CalledByNative
    public final void setFullIFrame(boolean fullIFrame) {
        this.fullIFrame = fullIFrame;
    }

    @CalledByNative
    public final void setAnnexb(boolean annexb) {
        this.annexb = annexb;
    }

    @CalledByNative
    public final void setWidth(int width) {
        this.width = width;
    }

    @CalledByNative
    public final void setHeight(int height) {
        this.height = height;
    }

    @CalledByNative
    public final void setFps(int fps) {
        this.fps = fps;
    }

    @CalledByNative
    public final void setGop(int gop) {
        this.gop = gop;
    }

    @CalledByNative
    public final void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    @CalledByNative
    public final void setEncoderProfile(VideoEncoderDef.EncoderProfile encoderProfile) {
        this.encoderProfile = encoderProfile;
    }

    @CalledByNative
    public final void setBitrateMode(VideoEncoderDef.BitrateMode bitrateMode) {
        this.bitrateMode = bitrateMode;
    }

    @CalledByNative
    public final void setBaseFrameIndex(long baseFrameIndex) {
        this.baseFrameIndex = baseFrameIndex;
    }

    @CalledByNative
    public final void setBaseGopIndex(long baseGopIndex) {
        this.baseGopIndex = baseGopIndex;
    }

    @CalledByNative
    public final void setCodecType(CodecType codecType) {
        this.codecType = codecType;
    }

    @CalledByNative
    public final void setMediaCodecDeviceRelatedParams(JSONArray mediaCodecDeviceRelatedParams) {
        this.mediaCodecDeviceRelatedParams = mediaCodecDeviceRelatedParams;
    }

    @CalledByNative
    public static VideoEncoderDef.BitrateMode createEncoderBitrateMode(int type) {
        return VideoEncoderDef.BitrateMode.a(type);
    }

    @CalledByNative
    public static CodecType createEncoderVideoCodec(int type) {
        return CodecType.a(type);
    }

    @CalledByNative
    public static VideoEncoderDef.EncoderProfile createEncoderProfileType(int type) {
        return VideoEncoderDef.EncoderProfile.a(type);
    }

    @CalledByNative
    public static VideoEncoderDef.ReferenceStrategy createReferenceStrategy(int strategy) {
        return VideoEncoderDef.ReferenceStrategy.a(strategy);
    }

    @CalledByNative
    public static VideoEncoderDef.EncoderComplexity createEncoderComplexity(int complexity) {
        return VideoEncoderDef.EncoderComplexity.a(complexity);
    }

    private int checkFieldDiffCounts(Object left, Object right) {
        Field[] fieldArray = VideoEncodeParams.class.getDeclaredFields();
        int n2 = 0;
        Field[] fieldArray2 = fieldArray;
        int n3 = fieldArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Field field = fieldArray2[i2];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                if (CommonUtil.equals(field.get(left), field.get(right))) continue;
                ++n2;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return n2;
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj instanceof VideoEncodeParams) {
            VideoEncodeParams videoEncodeParams = this;
            return videoEncodeParams.checkFieldDiffCounts(videoEncodeParams, obj) == 0;
        }
        return false;
    }

    @NonNull
    public final String toString() {
        return "width=" + this.width + ", height=" + this.height + ", fps=" + this.fps + ", gop=" + this.gop + ", bitrate=" + this.bitrate + ", annexb=" + this.annexb + ", encoderProfile=" + (Object)((Object)this.encoderProfile) + ", bitrateMode=" + (Object)((Object)this.bitrateMode) + ", baseFrameIndex=" + this.baseFrameIndex + ", baseGopIndex=" + this.baseGopIndex + ", fullIFrame=" + this.fullIFrame + ", enableBFrame=" + this.enableBFrame + ", referenceStrategy=" + (Object)((Object)this.referenceStrategy) + ", codecType=" + (Object)((Object)this.codecType) + ", isTransCodingMode=" + this.isTranscodingMode + ", mediaCodecDeviceRelatedParams=" + this.mediaCodecDeviceRelatedParams + ", encoderComplexity=" + (Object)((Object)this.encoderComplexity);
    }
}

