/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.thumbplayer.adapter.a.b.a;
import com.tencent.thumbplayer.adapter.strategy.utils.TPNativeKeyMapUtil;
import com.tencent.thumbplayer.api.ITPModuleLoader;
import com.tencent.thumbplayer.api.TPInitParams;
import com.tencent.thumbplayer.common.a.c;
import com.tencent.thumbplayer.config.TPPlayerConfig;
import com.tencent.thumbplayer.core.common.ITPNativeLibraryExternalLoader;
import com.tencent.thumbplayer.core.common.ITPNativeLogCallback;
import com.tencent.thumbplayer.core.common.TPNativeLibraryLoader;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.common.TPSystemInfo;
import com.tencent.thumbplayer.core.common.TPThumbplayerCapabilityHelper;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDLProxyNativeLibLoader;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPProxyAdapter;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyHelper;
import com.tencent.thumbplayer.utils.TPLogUtil;
import com.tencent.thumbplayer.utils.b;
import com.tencent.thumbplayer.utils.d;
import com.tencent.thumbplayer.utils.f;
import com.tencent.thumbplayer.utils.i;
import com.tencent.thumbplayer.utils.o;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class TPPlayerMgr {
    private static final String TAG = "TPThumbPlayer[TPPlayerMgr.java]";
    public static final int EVENT_ID_APP_ENTER_BACKGROUND = 100001;
    public static final int EVENT_ID_APP_ENTER_FOREGROUND = 100002;
    public static final String TP_PLAYERCORE_MODULE_NAME = "TPCore";
    public static final String TP_DOWNLOAD_PROXY_MODULE_NAME = "DownloadProxy";
    public static final String PLYAER_HOST_KEY = "player_host_config";
    public static final String PROXY_HOST_KEY = "httpproxy_config";
    public static final String BEACON_POLICY_HOST_KEY = "beacon_policy_host";
    public static final String BEACON_LOG_HOST_KEY = "beacon_log_host";
    public static final int INVALID_SUGGEST_BITRATE = -1;
    public static final int INVALID_CELLULAR_FLOW = -1;
    private static Context mAppContext;
    private static boolean mIsInit;
    private static final HashMap<String, Boolean> mBoolPropertyNameToValueCache;
    private static final HashMap<String, Integer> mIntegerPropertyNameToValueCache;
    private static final HashMap<String, String> mStringPropertyNameToValueCache;
    private static final HashMap<String, Long> mLongPropertyNameToValueCache;
    public static final String PROPERTY_MEDIA_DRM_REUSE = "PROPERTY_MediaDrmReuse";
    public static final String PROPERTY_ENABLE_NEW_REPORT = "PROPERTY_EnableNewReport";
    public static final String PROPERTY_ENABLE_DATA_REPORT = "PROPERTY_EnableDataReport";
    public static final String PROPERTY_ENABLE_PLAYER_REPORT = "PROPERTY_EnablePlayerReport";
    public static final String PROPERTY_PROXY_MAX_USE_MEMORY_MB = "PROPERTY_ProxyMaxUseMemoryMB";
    public static final String PROPERTY_VIDEO_MEDIACODEC_CO_EXIST_MAX_CNT = "PROPERTY_VideoMediaCodecCoexistMaxCnt";
    public static final String PROPERTY_AB_USER_ID = "PROPERTY_AbUserId";
    public static final String PROPERTY_WIDEVINE_PROVISIONING_SERVER_URL = "PROPERTY_WidevineProvisioningServerUrl";
    private static final HashMap<String, ITPPropertyHandler<Boolean>> mBooleanPropertyNameToPropertyHandlerTables;
    private static final HashMap<String, ITPPropertyHandler<String>> mStringPropertyNameToPropertyHandlerTables;
    private static final HashMap<String, ITPPropertyHandler<Integer>> mIntegerPropertyNameToPropertyHandlerTables;
    private static final HashMap<String, ITPPropertyHandler<Long>> mLongPropertyNameToPropertyHandlerTables;

    public static synchronized void initSdk(Context context, String string, int n2) {
        TPPlayerMgr.dumpStackTrace();
        if (mIsInit) {
            TPLogUtil.i(TAG, "Init SDK, has init sdk");
            return;
        }
        mIsInit = true;
        d d2 = new d();
        d2.a();
        TPPlayerMgr.preInitSync(context, string, n2);
        Future<Boolean> future = TPPlayerMgr.initAsyncWithWait();
        TPPlayerMgr.initSync();
        TPPlayerMgr.initAsyncWithoutWait();
        d2.b();
        try {
            if (future.get().booleanValue()) {
                TPLogUtil.i(TAG, "Init SDK, TPPlayer  wait initSync finish, times: " + d2.c());
            }
        }
        catch (ExecutionException executionException) {
            TPLogUtil.e(TAG, "Init SDK, TPPlayer wait initSync ExecutionException, times: " + d2.c());
        }
        catch (InterruptedException interruptedException) {
            TPLogUtil.e(TAG, "Init SDK, TPPlayer wait initSync InterruptedException, times: " + d2.c());
        }
        TPLogUtil.i(TAG, "Init SDK, TPPlayer all times: " + d2.d());
    }

    public static void initSdk(Context context, TPInitParams tPInitParams) {
        TPSystemInfo.setDeviceName(tPInitParams.getDeviceName());
        TPPlayerMgr.initSdk(context, tPInitParams.getGuid(), tPInitParams.getPlatform());
    }

    private static void preInitSync(Context context, String string, int n2) {
        d d2 = new d();
        d2.a();
        mAppContext = context.getApplicationContext();
        TPPlayerConfig.setGuid(string);
        TPPlayerConfig.setPlatform(n2);
        TPNativeLog.setLogCallback(new ITPNativeLogCallback(){

            @Override
            public final void onPrintLog(int n2, String string, String string2) {
                switch (n2) {
                    case 0: {
                        TPLogUtil.v(string, string2);
                        return;
                    }
                    case 1: {
                        TPLogUtil.d(string, string2);
                        return;
                    }
                    case 2: {
                        TPLogUtil.i(string, string2);
                        return;
                    }
                    case 3: {
                        TPLogUtil.w(string, string2);
                        return;
                    }
                    case 4: {
                        TPLogUtil.e(string, string2);
                    }
                }
            }
        });
        TPLogUtil.i(TAG, "Init SDK, preInitSync all times: " + d2.d());
    }

    private static void initSync() {
        d d2 = new d();
        d2.a();
        try {
            TPNativeLibraryLoader.loadLibIfNeeded(mAppContext);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            TPLogUtil.e(TAG, unsupportedOperationException);
        }
        TPLogUtil.i(TAG, "Init SDK, initSync so load times: " + d2.d());
    }

    private static Future<Boolean> initAsyncWithWait() {
        return o.a().c().submit(new Callable<Boolean>(){

            @Override
            public final Boolean call() {
                TPPlayerMgr.initInAsyncThread();
                return Boolean.TRUE;
            }
        });
    }

    private static void initInAsyncThread() {
        d d2 = new d();
        d2.a();
        com.tencent.thumbplayer.common.a.b.a(mAppContext.getApplicationContext());
        TPLogUtil.i(TAG, "Init SDK, initAsyncWithWait  TPBeaconReportWrapper init, times: " + d2.e());
        a.a(mAppContext);
        TPLogUtil.i(TAG, "Init SDK, initAsyncWithWait  TPDrmCapability init, times: " + d2.e());
        TPThumbplayerCapabilityHelper.init(mAppContext, true);
        TPLogUtil.i(TAG, "Init SDK, initAsyncWithWait all times: " + d2.d());
    }

    private static void initAsyncWithoutWait() {
        o.a().d().execute(new Runnable(){

            @Override
            public final void run() {
                d d2 = new d();
                d2.a();
                TPNativeKeyMapUtil.init();
                TPLogUtil.i(TPPlayerMgr.TAG, "Init SDK, initAsyncWithoutWait  nativeKeyMap init, times: " + d2.c());
                i.a().a(mAppContext);
                new c().a();
                TPPlayerMgr.setExternalProperties();
                TPLogUtil.i(TPPlayerMgr.TAG, "Init SDK, initAsyncWithoutWait all times: " + d2.d());
            }
        });
    }

    private static synchronized void setExternalProperties() {
        ITPPropertyHandler<Object> iTPPropertyHandler;
        for (Map.Entry<String, Boolean> entry : mBoolPropertyNameToValueCache.entrySet()) {
            iTPPropertyHandler = mBooleanPropertyNameToPropertyHandlerTables.get(entry.getKey());
            if (iTPPropertyHandler == null) continue;
            iTPPropertyHandler.setPropertyValue(entry.getValue());
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : mIntegerPropertyNameToValueCache.entrySet()) {
            iTPPropertyHandler = mIntegerPropertyNameToPropertyHandlerTables.get(entry.getKey());
            if (iTPPropertyHandler == null) continue;
            iTPPropertyHandler.setPropertyValue(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : mStringPropertyNameToValueCache.entrySet()) {
            iTPPropertyHandler = mStringPropertyNameToPropertyHandlerTables.get(entry.getKey());
            if (iTPPropertyHandler == null) continue;
            iTPPropertyHandler.setPropertyValue((Boolean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : mLongPropertyNameToValueCache.entrySet()) {
            iTPPropertyHandler = mLongPropertyNameToPropertyHandlerTables.get(entry.getKey());
            if (iTPPropertyHandler == null) continue;
            iTPPropertyHandler.setPropertyValue(entry.getValue());
        }
    }

    private static void dumpStackTrace() {
        TPLogUtil.i(TAG, "Current stack trace: ");
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            TPLogUtil.i(TAG, stackTraceElement.toString());
        }
    }

    public static void setHost(String string) {
        TPPlayerConfig.parseHostConfig(string);
    }

    public static void setDebugEnable(boolean bl2) {
        TPPlayerConfig.setDebugEnable(bl2);
    }

    public static void setOnLogListener(OnLogListener onLogListener) {
        TPLogUtil.setOnLogListener(onLogListener);
    }

    public static void setProxyEnable(boolean bl2) {
        TPPlayerConfig.setP2PEnable(bl2);
    }

    public static void setProxyMaxStorageSizeMB(long l2) {
        TPLogUtil.i(TAG, "setProxyMaxStorageSize: " + l2 + " MB.");
        TPPlayerConfig.setProxyMaxStorageSizeMB(l2);
        com.tencent.thumbplayer.c.i.a().a(l2);
    }

    public static boolean isProxyEnable() {
        return TPPlayerConfig.isUseP2P() && TPDownloadProxyHelper.isReadyForPlay();
    }

    public static void setUserInfo(String string, boolean bl2) {
        TPPlayerConfig.setUserUin(string);
        TPPlayerConfig.setUserIsVip(bl2);
    }

    public static void setUpcInfo(String string, int n2) {
        TPPlayerConfig.setUserUpc(string);
        TPPlayerConfig.setUserUpcState(n2);
        f.a(100003, n2, 0, string);
    }

    public static void setOutNetIP(String string) {
        TPPlayerConfig.setOutNetIp(string);
    }

    public static void setProxyServiceType(int n2) {
        TPPlayerConfig.setProxyServiceType(n2);
    }

    public static boolean isThumbPlayerEnable() {
        return TPNativeLibraryLoader.isLibLoadedAndTryToLoad();
    }

    public static int getSuggestedBitrate() {
        com.tencent.thumbplayer.c.b b2 = com.tencent.thumbplayer.c.i.a().a(TPPlayerConfig.getProxyServiceType());
        if (b2 == null) {
            return -1;
        }
        ITPDownloadProxy iTPDownloadProxy = b2.a();
        if (iTPDownloadProxy == null) {
            return -1;
        }
        return b.a(iTPDownloadProxy.getNativeInfo(0), -1);
    }

    public static int getCellularDataCost() {
        com.tencent.thumbplayer.c.b b2 = com.tencent.thumbplayer.c.i.a().a(TPPlayerConfig.getProxyServiceType());
        if (b2 == null) {
            return -1;
        }
        ITPDownloadProxy iTPDownloadProxy = b2.a();
        if (iTPDownloadProxy == null) {
            return -1;
        }
        return b.a(iTPDownloadProxy.getNativeInfo(2), -1);
    }

    public static String getOfflineRecordVinfo(String string, String string2) {
        return TPDownloadProxyHelper.checkVideoStatus(string, string2);
    }

    public static int getOfflineRecordDurationMs(String string, String string2) {
        return TPDownloadProxyHelper.getRecordDuration(string, string2);
    }

    public static void postEvent(int n2, int n3, int n4, Object object) {
        f.a(n2, n3, n4, object);
    }

    public static void setLibLoader(final ITPModuleLoader iTPModuleLoader) {
        if (mIsInit) {
            throw new IllegalStateException("player has init");
        }
        TPNativeLibraryLoader.setLibLoader(new ITPNativeLibraryExternalLoader(){

            @Override
            public final boolean loadLib(String string, String string2) {
                if (iTPModuleLoader != null) {
                    try {
                        iTPModuleLoader.loadLibrary(string, string2);
                        return true;
                    }
                    catch (Throwable throwable) {
                        TPLogUtil.e(TPPlayerMgr.TAG, throwable);
                    }
                }
                return false;
            }
        });
        TPDownloadProxyHelper.setNativeLibLoader(new ITPDLProxyNativeLibLoader(){

            @Override
            public final boolean loadLib(String string, String string2) {
                if (iTPModuleLoader != null) {
                    try {
                        iTPModuleLoader.loadLibrary(string, string2);
                        return true;
                    }
                    catch (Throwable throwable) {
                        TPLogUtil.e(TPPlayerMgr.TAG, throwable);
                    }
                }
                return false;
            }
        });
    }

    public static void setTPProxyAdapter(ITPProxyAdapter iTPProxyAdapter) {
        TPDownloadProxyHelper.setTPProxyAdapter(iTPProxyAdapter);
    }

    public static String getLibVersion(String string) {
        if (!mIsInit) {
            throw new IllegalStateException("player not initialized");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.equals(TP_DOWNLOAD_PROXY_MODULE_NAME)) {
                return TPDownloadProxyHelper.getNativeLibVersion();
            }
            if (string.equals(TP_PLAYERCORE_MODULE_NAME)) {
                return TPNativeLibraryLoader.getLibVersion();
            }
        }
        throw new IllegalArgumentException("libName:".concat(String.valueOf(string)));
    }

    public static Context getAppContext() {
        return mAppContext;
    }

    public static String getThumbPlayerVersion() {
        return "2.32.0.204";
    }

    public static synchronized void setPropertyBool(@NonNull String string, boolean bl2) {
        if (!mIsInit) {
            mBoolPropertyNameToValueCache.put(string, bl2);
            return;
        }
        ITPPropertyHandler<Boolean> iTPPropertyHandler = mBooleanPropertyNameToPropertyHandlerTables.get(string);
        if (iTPPropertyHandler == null) {
            TPLogUtil.w(TAG, "not found handler of property, propertyName:".concat(String.valueOf(string)));
            return;
        }
        iTPPropertyHandler.setPropertyValue(bl2);
        mBoolPropertyNameToValueCache.put(string, bl2);
    }

    public static synchronized boolean getPropertyBoolean(@NonNull String string, boolean bl2) {
        Boolean bl3 = mBoolPropertyNameToValueCache.get(string);
        if (bl3 == null) {
            return bl2;
        }
        return bl3;
    }

    @Deprecated
    public static synchronized boolean getPropertyBoolean(@NonNull String string) {
        return TPPlayerMgr.getPropertyBoolean(string, false);
    }

    public static synchronized void setPropertyInteger(@NonNull String string, int n2) {
        if (!mIsInit) {
            mIntegerPropertyNameToValueCache.put(string, n2);
            return;
        }
        ITPPropertyHandler<Integer> iTPPropertyHandler = mIntegerPropertyNameToPropertyHandlerTables.get(string);
        if (iTPPropertyHandler == null) {
            TPLogUtil.w(TAG, "not found handler of property, propertyName:".concat(String.valueOf(string)));
            return;
        }
        iTPPropertyHandler.setPropertyValue(n2);
        mIntegerPropertyNameToValueCache.put(string, n2);
    }

    public static synchronized int getPropertyInteger(@NonNull String string, int n2) {
        Integer n3 = mIntegerPropertyNameToValueCache.get(string);
        if (n3 == null) {
            return n2;
        }
        return n3;
    }

    @Deprecated
    public static synchronized int getPropertyInteger(@NonNull String string) {
        return TPPlayerMgr.getPropertyInteger(string, 0);
    }

    public static synchronized void setPropertyLong(@NonNull String string, long l2) {
        if (!mIsInit) {
            mLongPropertyNameToValueCache.put(string, l2);
            return;
        }
        ITPPropertyHandler<Long> iTPPropertyHandler = mLongPropertyNameToPropertyHandlerTables.get(string);
        if (iTPPropertyHandler == null) {
            TPLogUtil.w(TAG, "not found handler of property, propertyName:".concat(String.valueOf(string)));
            return;
        }
        iTPPropertyHandler.setPropertyValue(l2);
        mLongPropertyNameToValueCache.put(string, l2);
    }

    public static synchronized long getPropertyLong(@NonNull String string, long l2) {
        Long l3 = mLongPropertyNameToValueCache.get(string);
        if (l3 == null) {
            return l2;
        }
        return l3;
    }

    @Deprecated
    public static long getPropertyLong(@NonNull String string) {
        return TPPlayerMgr.getPropertyLong(string, 0L);
    }

    public static synchronized void setPropertyString(@NonNull String string, @NonNull String string2) {
        if (!mIsInit) {
            mStringPropertyNameToValueCache.put(string, string2);
            return;
        }
        ITPPropertyHandler<String> iTPPropertyHandler = mStringPropertyNameToPropertyHandlerTables.get(string);
        if (iTPPropertyHandler == null) {
            TPLogUtil.w(TAG, "not found handler of property, propertyName:".concat(String.valueOf(string)));
            return;
        }
        iTPPropertyHandler.setPropertyValue(string2);
        mStringPropertyNameToValueCache.put(string, string2);
    }

    @Nullable
    public static synchronized String getPropertyString(@NonNull String string, @Nullable String string2) {
        String string3 = mStringPropertyNameToValueCache.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    @Deprecated
    public static String getPropertyString(@NonNull String string) {
        return TPPlayerMgr.getPropertyString(string, "");
    }

    static {
        mBoolPropertyNameToValueCache = new HashMap();
        mIntegerPropertyNameToValueCache = new HashMap();
        mStringPropertyNameToValueCache = new HashMap();
        mLongPropertyNameToValueCache = new HashMap();
        mBooleanPropertyNameToPropertyHandlerTables = new HashMap<String, 6>();
        mBooleanPropertyNameToPropertyHandlerTables.put(PROPERTY_MEDIA_DRM_REUSE, new ITPPropertyHandler<Boolean>(){

            @Override
            public final void setPropertyValue(@NonNull Boolean bl2) {
                TPPlayerConfig.setMediaDrmReuseEnable(bl2);
            }

            @Override
            @NonNull
            public final Boolean getPropertyValue() {
                return TPPlayerConfig.getMediaDrmReuseEnable();
            }
        });
        mBooleanPropertyNameToPropertyHandlerTables.put(PROPERTY_ENABLE_DATA_REPORT, new ITPPropertyHandler<Boolean>(){

            @Override
            public final void setPropertyValue(@NonNull Boolean bl2) {
                TPLogUtil.i(TPPlayerMgr.TAG, "set data report enable : ".concat(String.valueOf(bl2)));
                TPPlayerConfig.setDataReportEnable(bl2);
                com.tencent.thumbplayer.c.i.a().a(bl2);
            }

            @Override
            @NonNull
            public final Boolean getPropertyValue() {
                return TPPlayerConfig.isDataReportEnable();
            }
        });
        mBooleanPropertyNameToPropertyHandlerTables.put(PROPERTY_ENABLE_PLAYER_REPORT, new ITPPropertyHandler<Boolean>(){

            @Override
            public final void setPropertyValue(@NonNull Boolean bl2) {
                TPLogUtil.i(TPPlayerMgr.TAG, "set player report enable : ".concat(String.valueOf(bl2)));
                TPPlayerConfig.setPlayerReportEnable(bl2);
            }

            @Override
            @NonNull
            public final Boolean getPropertyValue() {
                return TPPlayerConfig.isPlayerReportEnable();
            }
        });
        mBooleanPropertyNameToPropertyHandlerTables.put(PROPERTY_ENABLE_NEW_REPORT, new ITPPropertyHandler<Boolean>(){

            @Override
            public final void setPropertyValue(@NonNull Boolean bl2) {
                TPLogUtil.i(TPPlayerMgr.TAG, "set new report enable : ".concat(String.valueOf(bl2)));
                TPPlayerConfig.setNewReportEnable(bl2);
            }

            @Override
            @NonNull
            public final Boolean getPropertyValue() {
                return TPPlayerConfig.getNewReportEnable();
            }
        });
        mStringPropertyNameToPropertyHandlerTables = new HashMap<String, 10>();
        mStringPropertyNameToPropertyHandlerTables.put(PROPERTY_AB_USER_ID, new ITPPropertyHandler<String>(){

            @Override
            public final void setPropertyValue(@NonNull String string) {
                TPPlayerConfig.setAbUserId(string);
            }

            @Override
            @NonNull
            public final String getPropertyValue() {
                return TPPlayerConfig.getAbUserId();
            }
        });
        mStringPropertyNameToPropertyHandlerTables.put(PROPERTY_WIDEVINE_PROVISIONING_SERVER_URL, new ITPPropertyHandler<String>(){

            @Override
            public final void setPropertyValue(@NonNull String string) {
                TPPlayerConfig.setWidevineProvisioningServerUrl(string);
            }

            @Override
            @NonNull
            public final String getPropertyValue() {
                return TPPlayerConfig.getWidevineProvisioningServerUrl();
            }
        });
        mIntegerPropertyNameToPropertyHandlerTables = new HashMap<String, 12>();
        mIntegerPropertyNameToPropertyHandlerTables.put(PROPERTY_VIDEO_MEDIACODEC_CO_EXIST_MAX_CNT, new ITPPropertyHandler<Integer>(){

            @Override
            public final void setPropertyValue(@NonNull Integer n2) {
                TPPlayerConfig.setVideoMediaCodecCoexistMaxCnt(n2);
            }

            @Override
            @NonNull
            public final Integer getPropertyValue() {
                return TPPlayerConfig.getVideoMediaCodecCoexistMaxCnt();
            }
        });
        mLongPropertyNameToPropertyHandlerTables = new HashMap<String, 13>();
        mLongPropertyNameToPropertyHandlerTables.put(PROPERTY_PROXY_MAX_USE_MEMORY_MB, new ITPPropertyHandler<Long>(){

            @Override
            public final void setPropertyValue(@NonNull Long l2) {
                TPPlayerConfig.setProxyMaxUseMemoryMB(l2);
                com.tencent.thumbplayer.c.i.a().b(l2);
            }

            @Override
            @NonNull
            public final Long getPropertyValue() {
                return TPPlayerConfig.getProxyMaxUseMemoryMB();
            }
        });
    }

    static interface ITPPropertyHandler<T> {
        public void setPropertyValue(@NonNull T var1);

        @NonNull
        public T getPropertyValue();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LongProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntegerProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BooleanProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventId {
    }

    public static interface OnLogListener {
        public int v(String var1, String var2);

        public int d(String var1, String var2);

        public int i(String var1, String var2);

        public int w(String var1, String var2);

        public int e(String var1, String var2);
    }
}

