/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.common;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import java.util.HashMap;

public class TPUnitendCodecUtils {
    private static HashMap<String, String> mSecureDecoderNameMaps = null;
    private static int DolbyVisionProfileDvavPer = 0;
    private static int DolbyVisionProfileDvavPen = 1;
    private static int DolbyVisionProfileDvheDer = 2;
    private static int DolbyVisionProfileDvheDen = 3;
    private static int DolbyVisionProfileDvheDtr = 4;
    private static int DolbyVisionProfileDvheStn = 5;
    private static int DolbyVisionProfileDvheDth = 6;
    private static int DolbyVisionProfileDvheDtb = 7;
    private static int DolbyVisionProfileDvheSt = 8;
    private static int DolbyVisionProfileDvavSe = 9;

    public static synchronized String getSecureDecoderName(String string) {
        if (!(TextUtils.equals((CharSequence)"video/avc", (CharSequence)string) || TextUtils.equals((CharSequence)"video/hevc", (CharSequence)string) || TextUtils.equals((CharSequence)"video/dolby-vision", (CharSequence)string))) {
            return null;
        }
        if (mSecureDecoderNameMaps == null) {
            mSecureDecoderNameMaps = new HashMap();
        }
        if (mSecureDecoderNameMaps.containsKey(string)) {
            return mSecureDecoderNameMaps.get(string);
        }
        MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(1).getCodecInfos();
        if (mediaCodecInfoArray == null) {
            return null;
        }
        String string2 = null;
        MediaCodecInfo[] mediaCodecInfoArray2 = mediaCodecInfoArray;
        int n2 = mediaCodecInfoArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo.CodecCapabilities codecCapabilities;
            MediaCodecInfo mediaCodecInfo = mediaCodecInfoArray2[i2];
            if (mediaCodecInfo.isEncoder()) continue;
            try {
                codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
            }
            catch (Exception exception) {
                codecCapabilities = null;
            }
            if (codecCapabilities == null || !codecCapabilities.isFeatureSupported("secure-playback")) continue;
            string2 = mediaCodecInfo.getName();
            break;
        }
        mSecureDecoderNameMaps.put(string, string2);
        return string2;
    }

    public static synchronized String getDolbyVisionDecoderName(String string, int n2, int n3, boolean bl2) {
        if (!TextUtils.equals((CharSequence)"video/dolby-vision", (CharSequence)string)) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(1).getCodecInfos();
        if (mediaCodecInfoArray == null) {
            return null;
        }
        String string2 = null;
        MediaCodecInfo[] mediaCodecInfoArray2 = mediaCodecInfoArray;
        int n4 = mediaCodecInfoArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            MediaCodecInfo.CodecCapabilities codecCapabilities;
            MediaCodecInfo mediaCodecInfo = mediaCodecInfoArray2[i2];
            TPNativeLog.printLog(2, "TPUnitendCodecUtils", "getDolbyVisionDecoderName name:" + mediaCodecInfo.getName());
            if (mediaCodecInfo.isEncoder()) continue;
            try {
                codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
            }
            catch (Exception exception) {
                codecCapabilities = null;
            }
            if (codecCapabilities == null) continue;
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = codecCapabilities.profileLevels;
            for (int i3 = 0; i3 < codecProfileLevelArray.length; ++i3) {
                int n5 = TPUnitendCodecUtils.convertOmxProfileToDolbyVision(codecProfileLevelArray[i3].profile);
                if (n5 != n2) continue;
                TPNativeLog.printLog(2, "TPUnitendCodecUtils", "getDolbyVisionDecoderName i:" + i3 + " profile:" + n5 + " dvProfile:" + n2 + " bSecure:" + bl2 + " name:" + mediaCodecInfo.getName());
                if (bl2) {
                    if (!codecCapabilities.isFeatureSupported("secure-playback")) continue;
                    string2 = mediaCodecInfo.getName();
                    break;
                }
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            TPNativeLog.printLog(2, "TPUnitendCodecUtils", "getDolbyVisionDecoderName name:".concat(String.valueOf(string2)));
            break;
        }
        return string2;
    }

    public static int convertOmxProfileToDolbyVision(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = DolbyVisionProfileDvavPer;
                break;
            }
            case 2: {
                n3 = DolbyVisionProfileDvavPen;
                break;
            }
            case 4: {
                n3 = DolbyVisionProfileDvheDer;
                break;
            }
            case 8: {
                n3 = DolbyVisionProfileDvheDen;
                break;
            }
            case 16: {
                n3 = DolbyVisionProfileDvheDtr;
                break;
            }
            case 32: {
                n3 = DolbyVisionProfileDvheStn;
                break;
            }
            case 64: {
                n3 = DolbyVisionProfileDvheDth;
                break;
            }
            case 128: {
                n3 = DolbyVisionProfileDvheDtb;
                break;
            }
            case 256: {
                n3 = DolbyVisionProfileDvheSt;
                break;
            }
            case 512: {
                n3 = DolbyVisionProfileDvavSe;
            }
        }
        TPNativeLog.printLog(2, "TPUnitendCodecUtils", "convertOmxProfileToDolbyVision omxProfile:" + n2 + " dolbyVisionProfile:" + n3);
        return n3;
    }
}

