/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.utils;

import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TPDLProxyUtils {
    private static final String FILE_NAME = "TPDLProxyUtils";

    public static String byteArrayToString(byte[] byteArray) {
        String string = "";
        if (byteArray == null) {
            return string;
        }
        try {
            string = new String(byteArray, "UTF-8");
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "byteArrayToString failed, error:" + throwable.toString());
        }
        return string;
    }

    public static int objectToInt(Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return (Integer)obj;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "object to int failed, error:" + throwable.toString());
            return defaultValue;
        }
    }

    public static long objectToLong(Object obj, long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return (Long)obj;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "object to long failed, error:" + throwable.toString());
            return defaultValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serialize(Object obj) {
        String string;
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            string = byteArrayOutputStream.toString("ISO-8859-1");
        }
        catch (Throwable throwable) {
            try {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize obj, error:" + throwable.toString());
                return "";
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string  objectOutputStream close, error:" + throwable3.toString());
                }
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable4) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string byteArrayOutputStream close, error:" + throwable4.toString());
                }
            }
        }
        try {
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string  objectOutputStream close, error:" + throwable.toString());
        }
        try {
            byteArrayOutputStream.close();
            return string;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string byteArrayOutputStream close, error:" + throwable.toString());
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object serializeToObject(String str) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj , error:" + throwable.toString());
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj objectInputStream close, error:" + throwable3.toString());
                }
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (Throwable throwable4) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj byteArrayInputStream close, error:" + throwable4.toString());
                }
            }
        }
        try {
            objectInputStream.close();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj objectInputStream close, error:" + throwable.toString());
        }
        try {
            byteArrayInputStream.close();
            return object;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj byteArrayInputStream close, error:" + throwable.toString());
        }
        return object;
    }

    public static String losePackageCheck(int nTotalPackage) {
        String string = "";
        String string2 = "";
        try {
            String string3;
            String string4 = "ping -c " + nTotalPackage + " www.qq.com";
            Process process = Runtime.getRuntime().exec(string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string5 = "received, ";
            String string6 = " packet loss";
            while ((string3 = bufferedReader.readLine()) != null) {
                int n2;
                int n3;
                if (string3.contains(string6)) {
                    n3 = string3.indexOf(string5);
                    n2 = string3.indexOf("%");
                    string = string3.substring(string5.length() + n3, n2 + 1);
                }
                if (!string3.contains("avg")) continue;
                n3 = string3.indexOf("/", 20);
                n2 = string3.indexOf(".", n3);
                string2 = string3.substring(n3 + 1, n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string + ";" + string2;
    }
}

