/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.f;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.BitmapUtils;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.TXCCloudVideoViewMethodInvoker;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.RenderViewHelperInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderInterface;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoconsumer.renderer.aa;
import com.tencent.liteav.videoconsumer.renderer.ab;
import com.tencent.liteav.videoconsumer.renderer.ac;
import com.tencent.liteav.videoconsumer.renderer.ad;
import com.tencent.liteav.videoconsumer.renderer.ae;
import com.tencent.liteav.videoconsumer.renderer.af;
import com.tencent.liteav.videoconsumer.renderer.ag;
import com.tencent.liteav.videoconsumer.renderer.ah;
import com.tencent.liteav.videoconsumer.renderer.i;
import com.tencent.liteav.videoconsumer.renderer.r;
import com.tencent.liteav.videoconsumer.renderer.s;
import com.tencent.liteav.videoconsumer.renderer.t;
import com.tencent.liteav.videoconsumer.renderer.u;
import com.tencent.liteav.videoconsumer.renderer.v;
import com.tencent.liteav.videoconsumer.renderer.w;
import com.tencent.liteav.videoconsumer.renderer.x;
import com.tencent.liteav.videoconsumer.renderer.y;
import com.tencent.liteav.videoconsumer.renderer.z;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.rtmp.ui.a;
import com.tencent.rtmp.ui.b;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class q
extends VideoRenderInterface
implements RenderViewHelperInterface.RenderViewListener,
a,
b {
    private final String a = "VideoRenderer_" + this.hashCode();
    @NonNull
    private final Handler b = new Handler(Looper.getMainLooper());
    private final CustomHandler c;
    @NonNull
    private final IVideoReporter d;
    private final l e;
    @NonNull
    private final l f = new l(5);
    private final com.tencent.liteav.base.b.b g = new com.tencent.liteav.base.b.b();
    @NonNull
    private final Size h = new Size();
    private Surface i = null;
    private boolean j = false;
    private Object k;
    private EGLCore l = null;
    private final c m = new c();
    private j n;
    private final k o = new k();
    private e p;
    private GLConstants.GLScaleType q = GLConstants.GLScaleType.a;
    private Rotation r = Rotation.a;
    private boolean s = false;
    private boolean t = false;
    @Nullable
    private DisplayTarget u;
    private RenderViewHelperInterface v;
    private final Size w = new Size();
    private volatile boolean x = false;
    private boolean y = false;
    private TakeSnapshotListener z;
    private VideoRenderListener A;
    private boolean B = false;
    private Bitmap C;
    private boolean D = false;
    private final com.tencent.liteav.base.b.a E = new com.tencent.liteav.base.b.a(5000L);

    public q(@NonNull Looper looper, @NonNull IVideoReporter iVideoReporter) {
        this.c = new CustomHandler(looper);
        this.e = null;
        this.d = iVideoReporter;
    }

    public q(@NonNull l l2, @NonNull IVideoReporter iVideoReporter) {
        this.c = null;
        this.e = l2;
        this.d = iVideoReporter;
    }

    @Override
    public final void start(VideoRenderListener listener) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.renderer.r.a(q2, listener));
    }

    @Override
    public final void stop(boolean clearLastImage) {
        q q2 = this;
        q2.a(aa.a(q2, clearLastImage));
    }

    @Override
    public final void setDisplayView(DisplayTarget displayTarget, boolean clearLastImage) {
        q q2 = this;
        q2.a(ab.a(q2, displayTarget, clearLastImage));
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        q q2 = this;
        q2.a(ac.a(q2, listener));
    }

    @Override
    public final void onTap(int x2, int y2, int width, int height) {
        q q2 = this;
        q2.a(ad.a(q2, x2, y2, width, height));
    }

    @Override
    public final void onZoom(float scale) {
    }

    @Override
    public final void enableTapToFocusGesture(boolean enable) {
        q q2 = this;
        q2.a(ae.a(q2, enable));
    }

    @Override
    public final void enableZoomGesture(boolean enable) {
        q q2 = this;
        q2.a(af.a(q2, enable));
    }

    @Override
    public final void setScaleType(GLConstants.GLScaleType scaleType) {
        q q2 = this;
        q2.a(ag.a(q2, scaleType));
    }

    @Override
    public final void setRenderRotation(Rotation rotation) {
        q q2 = this;
        q2.a(ah.a(q2, rotation));
    }

    @Override
    public final void setHorizontalMirror(boolean mirror) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.renderer.s.a(q2, mirror));
    }

    @Override
    public final void setVerticalMirror(boolean mirror) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.renderer.t.a(q2, mirror));
    }

    @Override
    public final void renderFrame(PixelFrame pixelFrame) {
        if (!this.x) {
            return;
        }
        if (pixelFrame == null) {
            LiteavLog.w(this.a, "renderFrame pixelFrame is null!");
            return;
        }
        if (!this.y) {
            this.y = true;
            LiteavLog.d(this.a, "VideoRender receive first frame!");
        }
        pixelFrame.getGLContext();
        this.o.a(pixelFrame);
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.renderer.u.a(q2));
    }

    private void a(Runnable runnable) {
        if (this.e != null) {
            this.e.a(runnable);
            return;
        }
        if (Looper.myLooper() == this.c.getLooper()) {
            runnable.run();
            return;
        }
        this.c.post(runnable);
    }

    private void a() {
        if (this.l == null) {
            return;
        }
        LiteavLog.i(this.g.a("uninitGL"), this.a, "uninitializeEGL %d %s", this.i != null ? this.i.hashCode() : 0, this.h);
        try {
            this.l.makeCurrent();
        }
        catch (f f2) {
            LiteavLog.e(this.g.a("makeCurrentError"), this.a, "uninitializeEGL EGLCore makeCurrent failed.".concat(String.valueOf(f2)), new Object[0]);
        }
        this.e();
        this.m.d();
        if (this.p != null) {
            this.p.a();
            this.p.b();
            this.p = null;
        }
        EGLCore.destroy(this.l);
        this.l = null;
    }

    private void a(DisplayTarget displayTarget, boolean bl2) {
        LiteavLog.i(this.a, "setDisplayViewInternal=" + displayTarget + ",clearLastImage=" + bl2);
        boolean bl3 = CommonUtil.equals(this.u, displayTarget);
        if (bl3 && displayTarget != null && this.v != null) {
            LiteavLog.w(this.a, "view is equal and RenderViewHelper is created.");
            return;
        }
        if (!bl3) {
            this.B = true;
            if (this.u != null && bl2) {
                this.u.hideAll();
            }
        }
        this.a(bl2);
        this.u = displayTarget;
        if (displayTarget == null) {
            return;
        }
        displayTarget.showAll();
        this.v = RenderViewHelperInterface.create(displayTarget, this);
    }

    private TXCloudVideoView b() {
        if (this.u == null) {
            return null;
        }
        return this.u.getTXCloudVideoView();
    }

    private void c() {
        if (this.l == null) {
            return;
        }
        Size size = this.l.getSurfaceSize();
        if (this.h.equals(size)) {
            return;
        }
        LiteavLog.i(this.a, "surface size changed,old size=" + this.h + ",new size=" + size);
        this.h.set(size);
        this.e();
        if (this.i != null) {
            this.d.updateStatus(com.tencent.liteav.videobase.videobase.i.j, this.h.width << 16 | this.h.height);
        }
        if (this.A != null) {
            this.A.onRenderTargetSizeChanged(this.h.width, this.h.height);
        }
    }

    private void a(PixelFrame pixelFrame, VideoRenderListener.a a2) {
        if (this.A != null) {
            this.A.onRenderFrame(pixelFrame, a2);
        }
    }

    private boolean a(@NonNull PixelFrame pixelFrame) {
        Object object = pixelFrame.getGLContext();
        if (this.l == null || object != null && !CommonUtil.equals(this.k, object)) {
            this.a();
            Object object2 = pixelFrame.getGLContext();
            q q2 = this;
            if (q2.i == null) {
                LiteavLog.e(q2.g.a("initGLNoSurface"), q2.a, "Initialize EGL failed because surface is null", new Object[0]);
            } else {
                try {
                    LiteavLog.i(q2.g.a("initGL"), q2.a, "initializeEGL surface=" + q2.i + ",size=" + q2.h, new Object[0]);
                    q2.l = new EGLCore();
                    q2.l.initialize(object2, q2.i, q2.h.width, q2.h.height);
                    q2.k = object2;
                    q2.l.makeCurrent();
                    if (q2.p == null) {
                        q2.p = new e();
                    }
                    q2.m.a();
                }
                catch (f f2) {
                    LiteavLog.e(q2.g.a("initGLError"), q2.a, "initializeEGL failed.", f2);
                    q2.l = null;
                    q2.d.notifyWarning(h.c.e, "VideoRender: create EGLCore fail:".concat(String.valueOf(f2)));
                }
            }
        }
        if (this.l == null) {
            return false;
        }
        try {
            this.l.makeCurrent();
            return true;
        }
        catch (f f3) {
            LiteavLog.e(this.g.a("makeCurrentForFrameError"), this.a, "EGLCore makeCurrent failed.".concat(String.valueOf(f3)), new Object[0]);
            return false;
        }
    }

    private boolean d() {
        try {
            this.l.swapBuffers();
            return true;
        }
        catch (f f2) {
            LiteavLog.e(this.g.a("swapBuffers"), this.a, "EGLCore swapBuffers failed.".concat(String.valueOf(f2)), new Object[0]);
            this.d.notifyWarning(h.c.g, "VideoRender: swapBuffer error:".concat(String.valueOf(f2)));
            return false;
        }
    }

    private void a(PixelFrame pixelFrame, boolean bl2, boolean bl3, Rotation rotation, GLConstants.GLScaleType gLScaleType, boolean bl4) {
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        pixelFrame2.setRotation(Rotation.a((pixelFrame.getRotation().mValue + rotation.mValue) % 360));
        if (bl2) {
            PixelFrame pixelFrame3 = pixelFrame2;
            pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
        }
        if (bl3) {
            PixelFrame pixelFrame4 = pixelFrame2;
            pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
        }
        if (rotation == Rotation.b || rotation == Rotation.d) {
            int n2 = pixelFrame2.getWidth();
            PixelFrame pixelFrame5 = pixelFrame2;
            pixelFrame5.setWidth(pixelFrame5.getHeight());
            pixelFrame2.setHeight(n2);
        }
        PixelFrame pixelFrame6 = pixelFrame2;
        pixelFrame6.setMirrorVertical(!pixelFrame6.isMirrorVertical());
        if (pixelFrame2.getRotation() != Rotation.a && pixelFrame2.getRotation() != Rotation.c) {
            PixelFrame pixelFrame7 = pixelFrame2;
            pixelFrame7.setRotation(Rotation.a((pixelFrame7.getRotation().mValue + Rotation.c.mValue) % 360));
        }
        OpenGlUtils.glViewport(0, 0, this.h.width, this.h.height);
        if (bl4 && this.v != null) {
            this.v.updateVideoFrameInfo(this.q, pixelFrame2.getWidth(), pixelFrame2.getHeight());
        }
        if (this.n == null && this.h.isValid()) {
            LiteavLog.i(this.a, "create PixelFrameRenderer,surfaceSize=" + this.h);
            this.n = new j(this.h.width, this.h.height);
        }
        if (this.n != null) {
            if (this.v instanceof i) {
                this.n.a(pixelFrame2, GLConstants.GLScaleType.c, null);
                return;
            }
            this.n.a(pixelFrame2, gLScaleType, null);
        }
    }

    private void a(Surface surface, boolean bl2) {
        if (com.tencent.liteav.base.util.i.a(this.i, surface)) {
            LiteavLog.d(this.a, "updateSurface same surface!");
            return;
        }
        this.a();
        if (this.j && this.i != null) {
            this.i.release();
        }
        this.i = surface;
        if (this.i == null) {
            this.h.set(0, 0);
        }
        this.j = bl2;
    }

    private void a(boolean bl2) {
        if (this.v != null) {
            this.v.release(bl2);
            this.v = null;
        }
    }

    @Override
    public final void onSurfaceChanged(Surface surface, boolean isNeedRelease) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.renderer.w.a(q2, surface, isNeedRelease));
    }

    @Override
    public final void onRequestRedraw(@NonNull Bitmap bitmap) {
        this.a(bitmap);
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.renderer.x.a(q2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap a(Bitmap bitmap) {
        q q2 = this;
        synchronized (q2) {
            Bitmap bitmap2 = this.C;
            this.C = bitmap;
            return bitmap2;
        }
    }

    @Override
    public final void onSurfaceDestroy() {
        q q2 = this;
        Runnable runnable = com.tencent.liteav.videoconsumer.renderer.y.a(q2);
        q q3 = q2;
        if (q2.e != null) {
            q3.e.a(runnable, 2000L);
            return;
        }
        if (Looper.myLooper() == q3.c.getLooper()) {
            runnable.run();
            return;
        }
        q3.c.runAndWaitDone(runnable, 2000L);
    }

    private void e() {
        if (this.n != null) {
            this.n.a();
            this.n = null;
        }
    }

    static /* synthetic */ void a(q q2) {
        LiteavLog.i(q2.a, "onSurfaceDestroy " + q2.i);
        q2.a((Surface)null, q2.j);
    }

    static /* synthetic */ void b(q q2) {
        Bitmap bitmap = q2.a((Bitmap)null);
        if (bitmap == null) {
            return;
        }
        PixelFrame pixelFrame = PixelFrame.createFromBitmap(bitmap);
        if (!q2.a(pixelFrame)) {
            pixelFrame.release();
            return;
        }
        q2.c();
        q2.a(pixelFrame, false, false, Rotation.a, q2.q, false);
        q2.d();
    }

    static /* synthetic */ void a(q q2, Surface surface, boolean bl2) {
        LiteavLog.i(q2.a, "onSurfaceChanged surface: %s, oldSurface: %s, isNeedRelease: %b", surface, q2.i, bl2);
        q2.a(surface, bl2);
    }

    static /* synthetic */ void a(q q2, RenderViewHelperInterface renderViewHelperInterface, ByteBuffer byteBuffer, int n2, int n3, TakeSnapshotListener takeSnapshotListener) {
        TextureView textureView = null;
        if (renderViewHelperInterface instanceof i) {
            textureView = ((i)renderViewHelperInterface).a;
        }
        Matrix matrix = textureView == null ? null : textureView.getTransform(new Matrix());
        q2.f.a(com.tencent.liteav.videoconsumer.renderer.z.a(q2, byteBuffer, n2, n3, matrix, takeSnapshotListener));
    }

    static /* synthetic */ void a(q q2, ByteBuffer byteBuffer, int n2, int n3, Matrix matrix, TakeSnapshotListener takeSnapshotListener) {
        TakeSnapshotListener takeSnapshotListener2 = takeSnapshotListener;
        Matrix matrix2 = matrix;
        int n4 = n3;
        int n5 = n2;
        ByteBuffer byteBuffer2 = byteBuffer;
        q q3 = q2;
        try {
            byteBuffer2.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer2);
            Matrix matrix3 = matrix2 == null ? new Matrix() : matrix2;
            matrix3.postScale(1.0f, -1.0f, (float)n5 / 2.0f, (float)n4 / 2.0f);
            bitmap = BitmapUtils.createBitmap(bitmap, matrix3, true);
            takeSnapshotListener2.onComplete(bitmap);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(q3.a, "build snapshot bitmap failed.", throwable);
            takeSnapshotListener2.onComplete(null);
            return;
        }
    }

    static /* synthetic */ void c(q q2) {
        PixelFrame pixelFrame = q2.o.a();
        if (pixelFrame == null) {
            LiteavLog.d(q2.a, "renderFrameInternal pixelFrame is null!");
            return;
        }
        PixelFrame pixelFrame2 = pixelFrame;
        q q3 = q2;
        q3.w.set(pixelFrame2.getWidth(), pixelFrame2.getHeight());
        FrameMetaData frameMetaData = pixelFrame2.getMetaData();
        if (frameMetaData != null) {
            q3.r = frameMetaData.getRenderRotation();
            q3.s = frameMetaData.isRenderMirrorHorizontal();
            q3.t = frameMetaData.isRenderMirrorVertical();
            q3.w.set(frameMetaData.getCaptureRealSize());
        }
        if (q3.E.a() && q3.v != null) {
            q3.v.checkViewAvailability();
        }
        if (q3.v == null) {
            q3.a(pixelFrame2, VideoRenderListener.a.c);
        } else if (!q3.a(pixelFrame2)) {
            q3.a(pixelFrame2, VideoRenderListener.a.a);
            LiteavLog.e(q3.g.a("makeCurrent"), q3.a, "make current failed.", new Object[0]);
        } else {
            q q4;
            block14: {
                q3.c();
                q3.a(pixelFrame2, q3.s, q3.t, q3.r, q3.q, true);
                if (q3.z != null) {
                    OpenGlUtils.bindFramebuffer(36160, 0);
                    q q5 = q3;
                    int n2 = q3.h.height;
                    int n3 = q5.h.width;
                    q4 = q5;
                    TakeSnapshotListener takeSnapshotListener = q5.z;
                    if (takeSnapshotListener != null) {
                        ByteBuffer byteBuffer;
                        q4.z = null;
                        try {
                            byteBuffer = ByteBuffer.allocateDirect(n3 * n2 * 4).order(ByteOrder.nativeOrder());
                            byteBuffer.position(0);
                        }
                        catch (Throwable throwable) {
                            LiteavLog.e(q4.a, "can't alloc buffer, size: " + n3 * n2 * 4);
                            takeSnapshotListener.onComplete(null);
                            break block14;
                        }
                        GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
                        RenderViewHelperInterface renderViewHelperInterface = q4.v;
                        q4.b.post(com.tencent.liteav.videoconsumer.renderer.v.a(q4, renderViewHelperInterface, byteBuffer, n3, n2, takeSnapshotListener));
                    }
                }
            }
            if (q3.d() && OpenGlUtils.getGLErrorCount() <= 0) {
                q3.a(pixelFrame2, VideoRenderListener.a.b);
                PixelFrame pixelFrame3 = pixelFrame2;
                q4 = q3;
                if (q4.B) {
                    q4.d.notifyEvent(h.b.i, pixelFrame3, null);
                    q4.B = false;
                }
            } else {
                q3.a(pixelFrame2, VideoRenderListener.a.a);
                LiteavLog.e(q3.g.a("renderFailed"), q3.a, "render frame failed.", new Object[0]);
            }
        }
        pixelFrame.release();
    }

    static /* synthetic */ void a(q q2, boolean bl2) {
        if (q2.t != bl2) {
            LiteavLog.i(q2.a, "setVerticalMirror ".concat(String.valueOf(bl2)));
        }
        q2.t = bl2;
    }

    static /* synthetic */ void b(q q2, boolean bl2) {
        if (q2.s != bl2) {
            LiteavLog.i(q2.a, "setHorizontalMirror ".concat(String.valueOf(bl2)));
        }
        q2.s = bl2;
    }

    static /* synthetic */ void a(q q2, Rotation rotation) {
        if (q2.r != rotation) {
            LiteavLog.i(q2.a, "setRenderRotation ".concat(String.valueOf((Object)rotation)));
            q2.r = rotation;
        }
    }

    static /* synthetic */ void a(q q2, GLConstants.GLScaleType gLScaleType) {
        if (q2.q != gLScaleType) {
            LiteavLog.i(q2.a, "setScaleType ".concat(String.valueOf((Object)gLScaleType)));
            q2.q = gLScaleType;
        }
    }

    static /* synthetic */ void c(q q2, boolean bl2) {
        LiteavLog.i(q2.a, "enableZoomGesture enable:".concat(String.valueOf(bl2)));
        TXCloudVideoView tXCloudVideoView = q2.b();
        if (tXCloudVideoView != null) {
            boolean bl3 = bl2;
            TXCCloudVideoViewMethodInvoker.setZoomEnabled(tXCloudVideoView, bl3, bl3 ? q2 : null);
        }
    }

    static /* synthetic */ void d(q q2, boolean bl2) {
        LiteavLog.i(q2.a, "enableTapToFocusGesture enable:".concat(String.valueOf(bl2)));
        TXCloudVideoView tXCloudVideoView = q2.b();
        if (tXCloudVideoView != null) {
            boolean bl3 = bl2;
            TXCCloudVideoViewMethodInvoker.setTouchToFocusEnabled(tXCloudVideoView, bl3, bl3 ? q2 : null);
        }
        q2.D = bl2;
    }

    static /* synthetic */ void a(q q2, int n2, int n3, int n4, int n5) {
        if (!q2.D) {
            return;
        }
        TXCloudVideoView tXCloudVideoView = q2.b();
        if (tXCloudVideoView != null) {
            TXCCloudVideoViewMethodInvoker.showFocusView(tXCloudVideoView, n2, n3, n4, n5);
        }
    }

    static /* synthetic */ void a(q q2, TakeSnapshotListener takeSnapshotListener) {
        LiteavLog.i(q2.a, "takeSnapshot ");
        q2.z = takeSnapshotListener;
    }

    static /* synthetic */ void a(q q2, DisplayTarget displayTarget, boolean bl2) {
        q2.a(displayTarget, bl2);
    }

    static /* synthetic */ void e(q q2, boolean bl2) {
        LiteavLog.i(q2.a, "Stop,clearLastImage=".concat(String.valueOf(bl2)));
        if (!q2.x) {
            LiteavLog.w(q2.a, "renderer is not started!");
            return;
        }
        q2.x = false;
        q2.z = null;
        q2.a(bl2);
        if (q2.u != null && bl2) {
            q2.u.hideAll();
        }
        q2.o.b();
        q2.a();
        if (q2.j && q2.i != null) {
            q2.i.release();
            q2.j = false;
        }
        q2.i = null;
        q2.h.set(0, 0);
        q2.w.set(0, 0);
        q2.y = false;
    }

    static /* synthetic */ void a(q q2, VideoRenderListener videoRenderListener) {
        LiteavLog.i(q2.a, "Start");
        if (q2.x) {
            LiteavLog.w(q2.a, "renderer is started!");
            return;
        }
        q2.x = true;
        q2.A = videoRenderListener;
        if (q2.u != null) {
            q q3 = q2;
            q3.a(q3.u, true);
        }
        q2.E.a = SystemClock.elapsedRealtime();
    }
}

