/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.graphics.SurfaceTexture;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CameraControllerInterface;
import com.tencent.liteav.videoproducer.capture.CameraEventCallback;
import com.tencent.liteav.videoproducer.capture.CaptureCloudConfig;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.a;
import com.tencent.liteav.videoproducer.capture.ai;
import com.tencent.liteav.videoproducer.capture.at;
import com.tencent.liteav.videoproducer.capture.ax;
import com.tencent.liteav.videoproducer.capture.b;
import com.tencent.liteav.videoproducer.capture.c;
import com.tencent.liteav.videoproducer.capture.d;
import com.tencent.liteav.videoproducer.capture.e;
import com.tencent.liteav.videoproducer.capture.f;
import com.tencent.liteav.videoproducer.capture.g;
import com.tencent.liteav.videoproducer.capture.h;
import com.tencent.liteav.videoproducer.capture.i;
import com.tencent.liteav.videoproducer.capture.j;
import com.tencent.liteav.videoproducer.capture.k;
import com.tencent.liteav.videoproducer.capture.l;
import com.tencent.liteav.videoproducer.capture.m;
import com.tencent.liteav.videoproducer.capture.n;
import com.tencent.liteav.videoproducer.capture.o;
import com.tencent.liteav.videoproducer.capture.p;
import com.tencent.liteav.videoproducer.capture.q;
import com.tencent.liteav.videoproducer.capture.r;
import com.tencent.liteav.videoproducer.capture.s;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import java.util.concurrent.atomic.AtomicBoolean;

@JNINamespace(value="liteav::video")
public class CameraCaptureSingleton
implements SurfaceTexture.OnFrameAvailableListener,
CameraEventCallback {
    private static final String TAG = "CameraCaptureSingleton";
    private static final int DELAY_FOR_RESTART_CAMERA = 2000;
    private static final int DELAY_FOR_SWITCH_TO_CAMERA1 = 1000;
    private static final boolean USE_DEFAULT_FRONT_CAMERA = true;
    private static final int HOLD_POOL_MAX_SIZE = 1;
    private final com.tencent.liteav.base.b.b mThrottlers = new com.tencent.liteav.base.b.b();
    private com.tencent.liteav.videobase.frame.l mTextureHolderPool;
    private final float[] mMatrix = new float[16];
    private static volatile CameraCaptureSingleton sInstance;
    private boolean mNeedNotifyStartFinish = true;
    private final com.tencent.liteav.base.util.l mSequenceTaskRunner;
    private final at mListenerManager = new at();
    private final ai mCameraSupervisor = new ai();
    protected EGLCore mEGLCore;
    protected int mPausedCount = 0;
    protected CameraCaptureParams mCurrentCaptureParams = null;
    private final AtomicBoolean mExpectFrontCamera = new AtomicBoolean();
    protected com.tencent.liteav.videobase.frame.e mGLTexturePool;
    private SurfaceTexture mSurfaceTexture;
    private int mOESTextureId = -1;
    private CameraControllerInterface mCameraController;
    private PixelFrame mPixelFrame;
    private boolean mEnableTapToFocus = false;
    private boolean mEnableZoom = false;
    private float mZoomPercent = 0.0f;
    private float mExposureCompensation = 0.0f;
    private volatile Rotation mCameraRotation = Rotation.a;
    private boolean mIsFirstFrameCaptured = false;
    private boolean mIsZoomSupported = false;
    private boolean mIsTorchSupported = false;
    private boolean mIsFocusPositionInPreviewSupported = false;
    private boolean mIsCameraAutoFocusFaceModeSupported = false;
    private int mMaxZoomLevel = 0;
    private boolean mIsCameraInRestarting = false;
    private boolean mIsCameraInSwitching = false;
    private Object mSharedContext;
    private ServerVideoProducerConfig mServerConfig = null;
    private CaptureCloudConfig mCloudConfig = null;
    private final Runnable mRestartCameraRunnable = new Runnable(){

        @Override
        public final void run() {
            LiteavLog.i(CameraCaptureSingleton.TAG, "restart camera runnable.");
            CameraCaptureSingleton.this.mIsCameraInRestarting = true;
            boolean bl2 = false;
            if (LiteavSystemInfo.getAppBackgroundState() == 1) {
                LiteavLog.i(CameraCaptureSingleton.TAG, "not in Foreground");
            } else if (CameraCaptureSingleton.this.mCameraController == null && CameraCaptureSingleton.this.mCurrentCaptureParams != null) {
                bl2 = CameraCaptureSingleton.this.openCamera(CameraCaptureSingleton.this.mCurrentCaptureParams);
            }
            if (!bl2) {
                CameraCaptureSingleton.this.mSequenceTaskRunner.b(CameraCaptureSingleton.this.mRestartCameraRunnable, 2000L);
            }
        }
    };
    private final Runnable mSwitchToCamera1Runnable = new Runnable(){

        @Override
        public final void run() {
            LiteavLog.i(CameraCaptureSingleton.TAG, "switch to camera1 runnable.");
            CameraCaptureSingleton.this.mIsCameraInSwitching = true;
            boolean bl2 = false;
            if (LiteavSystemInfo.getAppBackgroundState() == 1) {
                LiteavLog.i(CameraCaptureSingleton.TAG, "not in Foreground");
            } else {
                bl2 = CameraCaptureSingleton.this.openCamera(CameraCaptureSingleton.this.mCurrentCaptureParams);
            }
            if (!bl2) {
                CameraCaptureSingleton.this.mSequenceTaskRunner.b(CameraCaptureSingleton.this.mSwitchToCamera1Runnable, 1000L);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CalledByNative
    public static CameraCaptureSingleton getInstance() {
        if (sInstance != null) return sInstance;
        Class<CameraCaptureSingleton> clazz = CameraCaptureSingleton.class;
        synchronized (CameraCaptureSingleton.class) {
            if (sInstance != null) return sInstance;
            sInstance = new CameraCaptureSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private CameraCaptureSingleton() {
        this.mSequenceTaskRunner = new com.tencent.liteav.base.util.l();
        this.mExpectFrontCamera.set(true);
    }

    public void removeListener(CaptureSourceInterface.CaptureSourceListener listener) {
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(a.a(cameraCaptureSingleton, listener));
    }

    public void setServerConfig(ServerVideoProducerConfig serverConfig) {
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(l.a(cameraCaptureSingleton, serverConfig));
    }

    public void setCaptureCloudConfig(CaptureCloudConfig cloudConfig) {
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(m.a(cameraCaptureSingleton, cloudConfig));
    }

    @CalledByNative
    public void switchCamera(boolean front) {
        LiteavLog.i(TAG, "switchCamera ".concat(String.valueOf(front)));
        this.mExpectFrontCamera.set(front);
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(n.a(cameraCaptureSingleton));
    }

    @CalledByNative
    public boolean isFrontCamera() {
        CameraCaptureParams cameraCaptureParams = this.mCurrentCaptureParams;
        if (cameraCaptureParams != null && cameraCaptureParams.a != null) {
            return cameraCaptureParams.a;
        }
        return false;
    }

    @CalledByNative
    public boolean isZoomSupported() {
        return this.mIsZoomSupported;
    }

    @CalledByNative
    public boolean isTorchSupported() {
        return this.mIsTorchSupported;
    }

    @CalledByNative
    public boolean isAutoFocusEnabled() {
        return !this.mEnableTapToFocus;
    }

    @CalledByNative
    public boolean isCameraFocusPositionInPreviewSupported() {
        return this.mIsFocusPositionInPreviewSupported;
    }

    @CalledByNative
    public boolean isCameraAutoFocusFaceModeSupported() {
        return this.mIsCameraAutoFocusFaceModeSupported;
    }

    @CalledByNative
    public void turnOnTorch(boolean on) {
        LiteavLog.i(TAG, "turnOnTorch ".concat(String.valueOf(on)));
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(o.a(cameraCaptureSingleton, on));
    }

    @CalledByNative
    public void enableTapToFocus(boolean enable) {
        LiteavLog.i(TAG, "enableTapToFocus ".concat(String.valueOf(enable)));
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(p.a(cameraCaptureSingleton, enable));
    }

    @CalledByNative
    public void startAutoFocusAtPosition(int x2, int y2) {
        LiteavLog.i(TAG, "startAutoFocusAtPosition " + x2 + ", " + y2);
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(q.a(cameraCaptureSingleton, x2, y2));
    }

    @CalledByNative
    public void enableCameraZoom(boolean enable) {
        LiteavLog.i(TAG, "enableCameraZoom ".concat(String.valueOf(enable)));
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(r.a(cameraCaptureSingleton, enable));
    }

    @CalledByNative
    public int getMaxZoomLevel() {
        return this.mMaxZoomLevel;
    }

    @CalledByNative
    public void setZoomLevel(float level) {
        LiteavLog.i(TAG, "setZoomLevel ".concat(String.valueOf(level)));
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(s.a(cameraCaptureSingleton, level));
    }

    public void setPercentOfMaxZoomLevel(float percent) {
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(b.a(cameraCaptureSingleton, percent));
    }

    private void setZoomInternal(float percent) {
        LiteavLog.i(TAG, "setZoomInternal ".concat(String.valueOf(percent)));
        if ((double)Math.abs(this.mZoomPercent - percent) < 0.001) {
            return;
        }
        if (this.mCameraController != null) {
            this.mZoomPercent = percent;
            this.mCameraController.setZoom(percent);
        }
    }

    @CalledByNative
    public void enableMockCamera(boolean enable) {
        this.mCameraSupervisor.b = enable ? CameraControllerInterface.a.a : null;
    }

    @CalledByNative
    public void setExposureCompensation(float value) {
        LiteavLog.i(TAG, "setExposureCompensation ".concat(String.valueOf(value)));
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(c.a(cameraCaptureSingleton, value));
    }

    @CalledByNative
    public void setCameraAPIType(int cameraAPIType) {
        LiteavLog.i(TAG, "setCameraAPIType ".concat(String.valueOf(cameraAPIType)));
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(d.a(cameraCaptureSingleton, cameraAPIType));
    }

    public Rotation getCameraRotation() {
        return this.mCameraRotation;
    }

    @Override
    public void onCameraError(CameraControllerInterface cameraController) {
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(e.a(cameraCaptureSingleton, cameraController));
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(f.a(cameraCaptureSingleton, surfaceTexture));
    }

    private void onCaptureFrameAvailable() {
        if (this.mGLTexturePool == null || this.mTextureHolderPool == null) {
            LiteavLog.w(TAG, "onCaptureFrameAvailable mGLTexturePool:" + this.mGLTexturePool + " mTextureHolderPool:" + this.mTextureHolderPool);
            return;
        }
        l.b b2 = null;
        try {
            b2 = (l.b)this.mTextureHolderPool.a();
        }
        catch (InterruptedException interruptedException) {}
        if (this.mPixelFrame.getMatrix() == null) {
            this.mPixelFrame.setMatrix(this.mMatrix);
        }
        try {
            this.mSurfaceTexture.updateTexImage();
            this.mSurfaceTexture.getTransformMatrix(this.mMatrix);
        }
        catch (Exception exception) {
            LiteavLog.w(this.mThrottlers.a("updateTexImage"), TAG, "updateTexImage exception: ".concat(String.valueOf(exception)), new Object[0]);
        }
        if (this.mCameraSupervisor.a() == CameraControllerInterface.a.a) {
            CameraCaptureSingleton cameraCaptureSingleton = this;
            cameraCaptureSingleton.getMockCameraMatrix(cameraCaptureSingleton.mMatrix);
        }
        b2.a(36197, this.mOESTextureId, this.mPixelFrame.getWidth(), this.mPixelFrame.getHeight());
        PixelFrame pixelFrame = b2.a(this.mPixelFrame.getGLContext());
        pixelFrame.setMirrorHorizontal(this.isFrontCamera());
        pixelFrame.setMatrix(this.mMatrix);
        pixelFrame.setTimestamp(TimeUtil.c());
        FrameMetaData frameMetaData = new FrameMetaData();
        frameMetaData.setCaptureMetaData(this.isFrontCamera(), false, 0, this.isFrontCamera(), pixelFrame.getWidth(), pixelFrame.getHeight());
        pixelFrame.setMetaData(frameMetaData);
        if (pixelFrame.getGLContext() == null) {
            pixelFrame.setGLContext(this.mEGLCore.getEglContext());
        }
        this.mListenerManager.onFrameAvailable(null, pixelFrame);
        b2.release();
        pixelFrame.release();
    }

    private void getMockCameraMatrix(float[] matrix) {
        try {
            this.mCameraController.getClass().getDeclaredMethod("getTransformMatrix", float[].class).invoke((Object)this.mCameraController, new Object[]{matrix});
            return;
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "getMockCameraMatrix with exception: ".concat(String.valueOf(exception)));
            return;
        }
    }

    public void start(Object glContext, CaptureSourceInterface.CaptureParams params, CaptureSourceInterface.CaptureSourceListener listener) {
        LiteavLog.i(TAG, "Start ".concat(String.valueOf(glContext)));
        CameraCaptureParams cameraCaptureParams = new CameraCaptureParams((CameraCaptureParams)params);
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(g.a(cameraCaptureSingleton, listener, cameraCaptureParams));
    }

    private void initGLComponents(Object glContext) {
        if (this.mEGLCore != null) {
            return;
        }
        this.mEGLCore = new EGLCore();
        if (this.mTextureHolderPool == null) {
            this.mTextureHolderPool = new com.tencent.liteav.videobase.frame.l();
        }
        try {
            this.mEGLCore.initialize(glContext, null, 128, 128);
            this.mEGLCore.makeCurrent();
            this.mSharedContext = glContext;
        }
        catch (com.tencent.liteav.videobase.egl.f f2) {
            LiteavLog.e(this.mThrottlers.a("initGL"), TAG, "initializeEGL failed.", f2);
            this.mListenerManager.onCaptureError();
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new com.tencent.liteav.videobase.frame.e();
        }
    }

    public void stopAndWaitDone(int waitingTimeMS) {
        this.mSequenceTaskRunner.a(h.a(this), waitingTimeMS);
    }

    private void stopInternal() {
        LiteavLog.i(TAG, "stop listener count: " + this.mListenerManager.a());
        if (this.mListenerManager.a() == 0) {
            this.closeCamera();
            this.mZoomPercent = 0.0f;
            this.mNeedNotifyStartFinish = true;
            this.mCurrentCaptureParams = null;
            this.uninitGLComponents();
        }
    }

    protected void uninitGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        if (this.mTextureHolderPool != null) {
            this.mTextureHolderPool.b();
            this.mTextureHolderPool = null;
        }
        try {
            this.mEGLCore.makeCurrent();
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.b();
                this.mGLTexturePool = null;
            }
        }
        catch (com.tencent.liteav.videobase.egl.f f2) {
            LiteavLog.e(this.mThrottlers.a("uninitGL"), TAG, "EGLCore destroy failed.", f2);
        }
        this.mSharedContext = null;
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
        this.mSequenceTaskRunner.c(this.mRestartCameraRunnable);
        this.mSequenceTaskRunner.c(this.mSwitchToCamera1Runnable);
    }

    private boolean openCamera(@NonNull CameraCaptureParams params) {
        if (this.mCameraController != null) {
            LiteavLog.e(TAG, "camera is opened, you should Stop it first.");
            return true;
        }
        boolean bl2 = this.openCameraInternal(params);
        if (bl2) {
            this.handleCameraStartSuccess();
        } else {
            this.handleCameraStartFailed();
        }
        return bl2;
    }

    private boolean openCameraInternal(@NonNull CameraCaptureParams params) {
        if (!this.makeCurrent()) {
            LiteavLog.e(TAG, "openCameraInternal: set opengl context fail.");
            return false;
        }
        this.mOESTextureId = OpenGlUtils.generateTextureOES();
        this.mSurfaceTexture = new SurfaceTexture(this.mOESTextureId);
        this.mCameraController = this.createCameraController(this.mCameraSupervisor.a());
        if (params.a == null) {
            params.a = this.mExpectFrontCamera.get();
            LiteavLog.w(TAG, "openCameraInternal frontCamera not set, use expect front camera:" + params.a);
        }
        this.mCurrentCaptureParams = params;
        this.mCameraController.enableTapToFocus(this.mEnableTapToFocus);
        this.mCameraController.setExposureCompensation(this.mExposureCompensation);
        this.mCameraController.setZoom(this.mZoomPercent);
        this.mListenerManager.onCameraTouchEnable(this.mEnableTapToFocus);
        this.mListenerManager.onCameraZoomEnable(this.mEnableZoom);
        return this.mCameraController.startCapture(this.mCurrentCaptureParams, this.mSurfaceTexture, this);
    }

    private CameraControllerInterface createCameraController(CameraControllerInterface.a type) {
        CameraControllerInterface cameraControllerInterface;
        switch (type) {
            case a: {
                Object var3_2 = null;
                try {
                    var3_2 = Class.forName("com.tencent.liteav.videoengine.demo.mock.camera.MockCameraController").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                cameraControllerInterface = var3_2;
                break;
            }
            case c: {
                cameraControllerInterface = new com.tencent.liteav.videoproducer.capture.b.a(this.mSequenceTaskRunner);
                break;
            }
            default: {
                cameraControllerInterface = new com.tencent.liteav.videoproducer.capture.a.a();
            }
        }
        if (cameraControllerInterface != null) {
            cameraControllerInterface.setServerConfig(this.mServerConfig);
            cameraControllerInterface.setCloudConfig(this.mCloudConfig);
        }
        LiteavLog.i(TAG, "createCameraController, CameraAPIType:" + (Object)((Object)type) + ", return camera controller: " + cameraControllerInterface);
        return cameraControllerInterface;
    }

    private static PixelFrame initOutputPixelFrame(Size previewSize, Rotation rotation, Object glContext, int oesTextureId) {
        PixelFrame pixelFrame = new PixelFrame();
        if (rotation == Rotation.b || rotation == Rotation.d) {
            pixelFrame.setWidth(previewSize.height);
            pixelFrame.setHeight(previewSize.width);
        } else {
            pixelFrame.setWidth(previewSize.width);
            pixelFrame.setHeight(previewSize.height);
        }
        pixelFrame.setPixelBufferType(GLConstants.PixelBufferType.c);
        pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
        pixelFrame.setRotation(Rotation.a);
        pixelFrame.setGLContext(glContext);
        pixelFrame.setTextureId(oesTextureId);
        return pixelFrame;
    }

    private void closeCamera() {
        LiteavLog.i(TAG, "closeCamera");
        try {
            if (this.mCameraController != null) {
                this.mCameraController.stopCapture();
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "closeCamera fail, Exception:".concat(String.valueOf(exception)));
        }
        finally {
            this.mCameraRotation = Rotation.a;
            this.mCameraController = null;
            this.mMaxZoomLevel = 0;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        OpenGlUtils.deleteTexture(this.mOESTextureId);
        this.mOESTextureId = -1;
        this.mPixelFrame = null;
        this.mIsFirstFrameCaptured = false;
    }

    protected void updateCamera(@NonNull CameraCaptureParams params) {
        this.closeCamera();
        this.mNeedNotifyStartFinish = true;
        this.openCamera(params);
    }

    public void pause() {
        LiteavLog.i(TAG, "pause");
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(i.a(cameraCaptureSingleton));
    }

    protected void pauseInternal() {
        ++this.mPausedCount;
        int n2 = this.mListenerManager.a();
        LiteavLog.i(TAG, "pauseInternal paused cnt= " + this.mPausedCount + " , listener cnt=" + n2);
        if (this.mPausedCount > n2) {
            this.mPausedCount = n2;
        }
        if (n2 != this.mPausedCount) {
            LiteavLog.i(TAG, "pauseInternal listeners is not zero.");
            return;
        }
        this.closeCamera();
    }

    private boolean isNeedRestartCamera(CameraCaptureParams params) {
        boolean bl2 = false;
        boolean bl3 = true;
        if (params.a != this.mCurrentCaptureParams.a) {
            this.mCurrentCaptureParams.a = params.a;
            bl2 = true;
            this.mCurrentCaptureParams.c = params.c;
            this.mCurrentCaptureParams.d = params.d;
        } else {
            bl3 = this.mCameraController == null ? false : this.mCameraController.isCurrentPreviewSizeAspectRatioMatch(params.c, params.d, this.mListenerManager.a() <= 1);
            if (!bl3) {
                this.mCurrentCaptureParams.c = params.c;
                this.mCurrentCaptureParams.d = params.d;
            }
        }
        if (this.mListenerManager.a() <= 1 && this.mCurrentCaptureParams.b != params.b || this.mListenerManager.a() > 1 && this.mCurrentCaptureParams.b < params.b) {
            this.mCurrentCaptureParams.b = params.b;
            bl2 = true;
        }
        return bl2 || !bl3;
    }

    public void resume() {
        LiteavLog.i(TAG, "resume");
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(j.a(cameraCaptureSingleton));
    }

    public void updateParams(CaptureSourceInterface.CaptureParams params) {
        CameraCaptureParams cameraCaptureParams = new CameraCaptureParams((CameraCaptureParams)params);
        LiteavLog.i(TAG, "updateParams");
        CameraCaptureSingleton cameraCaptureSingleton = this;
        cameraCaptureSingleton.runInGLThread(k.a(cameraCaptureSingleton, cameraCaptureParams));
    }

    public CameraControllerInterface.a getCameraAPIType() {
        return this.mCameraSupervisor.a();
    }

    private void updateParamsInternal(CameraCaptureParams params) {
        if (params.a == null) {
            params.a = this.mCurrentCaptureParams.a;
            LiteavLog.i(TAG, "params not set frontCamera, use mCurrentCaptureParams frontCamera:" + this.mCurrentCaptureParams.a);
        }
        if (this.isNeedRestartCamera(params)) {
            LiteavLog.i(TAG, "reopen camera params: ".concat(String.valueOf(params)));
            this.updateCamera(params);
        }
    }

    protected void resumeInternal(CameraCaptureParams params) {
        LiteavLog.i(TAG, "resumeInternal pausedCount %d, listeners size = %d", this.mPausedCount, this.mListenerManager.a());
        if (this.mListenerManager.a() == this.mPausedCount) {
            this.openCamera(params);
        }
        --this.mPausedCount;
        if (this.mPausedCount < 0) {
            this.mPausedCount = 0;
        }
    }

    protected boolean makeCurrent() {
        if (this.mEGLCore == null) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentNull"), TAG, "makeCurrent on mEGLCore is null", new Object[0]);
            return false;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (com.tencent.liteav.videobase.egl.f f2) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentError"), TAG, "make current failed.", f2);
            this.mListenerManager.onCaptureError();
            return false;
        }
        return true;
    }

    private void checkFirstFrameCaptured() {
        if (!this.mIsFirstFrameCaptured) {
            this.mIsFirstFrameCaptured = true;
            LiteavLog.d(TAG, "camera capture first frame.");
        }
    }

    protected void runInGLThread(Runnable runnable) {
        this.mSequenceTaskRunner.a(runnable);
    }

    private void handleCameraStartSuccess() {
        if (this.mCameraController == null || this.mSurfaceTexture == null) {
            LiteavLog.e(TAG, "camera start success, but mCameraController or mSurfaceTexture is null.");
            return;
        }
        LiteavLog.i(TAG, "camera start success. params: %s", this.mCurrentCaptureParams);
        this.mCameraRotation = this.mCameraController.getCameraRotation();
        this.mIsZoomSupported = this.mCameraController.isZoomSupported();
        this.mIsTorchSupported = this.mCameraController.isTorchSupported();
        this.mIsCameraAutoFocusFaceModeSupported = this.mCameraController.isCameraAutoFocusFaceModeSupported();
        this.mIsFocusPositionInPreviewSupported = this.mCameraController.isCameraFocusPositionInPreviewSupported();
        this.mMaxZoomLevel = this.mCameraController.getMaxZoom();
        Size size = this.mCameraController.getPreviewSize();
        this.mPixelFrame = CameraCaptureSingleton.initOutputPixelFrame(size, this.mCameraRotation, this.mSharedContext == null ? this.mEGLCore.getEglContext() : this.mSharedContext, this.mOESTextureId);
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        if (this.mNeedNotifyStartFinish) {
            this.mNeedNotifyStartFinish = false;
            this.mListenerManager.onStartFinish(true);
        }
        this.mIsCameraInRestarting = false;
        this.mIsCameraInSwitching = false;
    }

    private void handleCameraStartFailed() {
        LiteavLog.e(TAG, "camera start failed. params: %s", this.mCurrentCaptureParams);
        if (this.mCameraController != null) {
            this.mCameraController.stopCapture();
        }
        this.mCameraController = null;
        if (this.mIsCameraInRestarting) {
            this.mSequenceTaskRunner.b(this.mRestartCameraRunnable, 2000L);
            return;
        }
        if (this.mIsCameraInSwitching) {
            this.mSequenceTaskRunner.b(this.mSwitchToCamera1Runnable, 1000L);
            return;
        }
        CameraControllerInterface.a a2 = this.mCameraSupervisor.a();
        ai ai2 = this.mCameraSupervisor;
        if (ai2.a == CameraControllerInterface.a.c) {
            ai2.c = true;
        }
        if (a2 != this.mCameraSupervisor.a()) {
            LiteavLog.w(TAG, "camera switch from " + (Object)((Object)a2) + " to " + (Object)((Object)this.mCameraSupervisor.a()));
            this.mSequenceTaskRunner.b(this.mSwitchToCamera1Runnable, 1000L);
            return;
        }
        if (this.mNeedNotifyStartFinish) {
            this.mNeedNotifyStartFinish = false;
            this.mListenerManager.onStartFinish(false);
        }
    }

    static /* synthetic */ void lambda$updateParams$17(CameraCaptureSingleton this_, CameraCaptureParams captureParams) {
        if (this_.mEGLCore != null && this_.mCurrentCaptureParams != null) {
            LiteavLog.i(TAG, "capture source has already started!");
            this_.updateParamsInternal(captureParams);
        }
    }

    static /* synthetic */ void lambda$resume$16(CameraCaptureSingleton this_) {
        CameraCaptureSingleton cameraCaptureSingleton = this_;
        cameraCaptureSingleton.resumeInternal(cameraCaptureSingleton.mCurrentCaptureParams);
    }

    static /* synthetic */ void lambda$stopAndWaitDone$15(CameraCaptureSingleton this_) {
        LiteavLog.i(TAG, "stop camera begin");
        this_.stopInternal();
        LiteavLog.i(TAG, "stop camera end");
    }

    static /* synthetic */ void lambda$start$14(CameraCaptureSingleton this_, CaptureSourceInterface.CaptureSourceListener listener, CameraCaptureParams captureParams) {
        this_.mListenerManager.a(listener);
        if (this_.mEGLCore != null && this_.mCurrentCaptureParams != null) {
            LiteavLog.i(TAG, "capture source has already started!");
            this_.updateParamsInternal(captureParams);
            return;
        }
        this_.initGLComponents(ax.a().b());
        this_.openCamera(captureParams);
    }

    static /* synthetic */ void lambda$onFrameAvailable$13(CameraCaptureSingleton this_, SurfaceTexture surfaceTexture) {
        if (this_.mSurfaceTexture == null || surfaceTexture != this_.mSurfaceTexture) {
            return;
        }
        if (!this_.makeCurrent()) {
            LiteavLog.e(this_.mThrottlers.a("onFrameAvailable"), TAG, "make current failed.", new Object[0]);
            return;
        }
        this_.checkFirstFrameCaptured();
        this_.onCaptureFrameAvailable();
    }

    static /* synthetic */ void lambda$onCameraError$12(CameraCaptureSingleton this_, CameraControllerInterface cameraController) {
        if (this_.mCameraController == null || this_.mCameraController != cameraController) {
            return;
        }
        LiteavLog.w(TAG, "VideoCapture: camera error");
        this_.closeCamera();
        this_.mSequenceTaskRunner.b(this_.mRestartCameraRunnable, 2000L);
    }

    static /* synthetic */ void lambda$setCameraAPIType$11(CameraCaptureSingleton this_, int cameraAPIType) {
        CameraControllerInterface.a a2 = this_.mCameraSupervisor.a();
        this_.mCameraSupervisor.b = cameraAPIType == 1 ? CameraControllerInterface.a.b : (cameraAPIType == 2 ? CameraControllerInterface.a.c : null);
        if (this_.mCameraController == null || this_.mCurrentCaptureParams == null) {
            LiteavLog.i(TAG, "setCameraAPIType,mCameraController is null.");
            return;
        }
        if (a2 == this_.mCameraSupervisor.a()) {
            LiteavLog.i(TAG, "setCameraAPIType,decided api type is not changed.");
            return;
        }
        this_.closeCamera();
        this_.mNeedNotifyStartFinish = true;
        CameraCaptureSingleton cameraCaptureSingleton = this_;
        cameraCaptureSingleton.openCamera(cameraCaptureSingleton.mCurrentCaptureParams);
    }

    static /* synthetic */ void lambda$setExposureCompensation$10(CameraCaptureSingleton this_, float value) {
        this_.mExposureCompensation = value;
        if (this_.mCameraController != null) {
            this_.mCameraController.setExposureCompensation(value);
        }
    }

    static /* synthetic */ void lambda$setPercentOfMaxZoomLevel$9(CameraCaptureSingleton this_, float percent) {
        this_.setZoomInternal(percent);
    }

    static /* synthetic */ void lambda$setZoomLevel$8(CameraCaptureSingleton this_, float level) {
        int n2 = this_.mMaxZoomLevel;
        if (n2 <= 0) {
            LiteavLog.w(TAG, "setZoomLevel maxZoomLevel=".concat(String.valueOf(n2)));
            return;
        }
        this_.setZoomInternal(level / (float)n2);
    }

    static /* synthetic */ void lambda$enableCameraZoom$7(CameraCaptureSingleton this_, boolean enable) {
        this_.mEnableZoom = enable;
        this_.mListenerManager.onCameraZoomEnable(enable);
    }

    static /* synthetic */ void lambda$startAutoFocusAtPosition$6(CameraCaptureSingleton this_, int x2, int y2) {
        if (!this_.mEnableTapToFocus) {
            return;
        }
        if (this_.mCameraController != null) {
            this_.mCameraController.startAutoFocusAtPosition(x2, y2);
        }
    }

    static /* synthetic */ void lambda$enableTapToFocus$5(CameraCaptureSingleton this_, boolean enable) {
        this_.mEnableTapToFocus = enable;
        if (this_.mCameraController != null) {
            this_.mCameraController.enableTapToFocus(enable);
        }
        this_.mListenerManager.onCameraTouchEnable(enable);
    }

    static /* synthetic */ void lambda$turnOnTorch$4(CameraCaptureSingleton this_, boolean on) {
        if (this_.mCameraController != null) {
            this_.mCameraController.turnOnTorch(on);
        }
    }

    static /* synthetic */ void lambda$switchCamera$3(CameraCaptureSingleton this_) {
        boolean bl2 = this_.mExpectFrontCamera.get();
        if (this_.mCurrentCaptureParams != null && this_.mCurrentCaptureParams.a != bl2) {
            this_.closeCamera();
            this_.mZoomPercent = 0.0f;
            this_.mNeedNotifyStartFinish = true;
            this_.mCurrentCaptureParams.a = bl2;
            CameraCaptureSingleton cameraCaptureSingleton = this_;
            cameraCaptureSingleton.openCamera(cameraCaptureSingleton.mCurrentCaptureParams);
        }
    }

    static /* synthetic */ void lambda$setCaptureCloudConfig$2(CameraCaptureSingleton this_, CaptureCloudConfig cloudConfig) {
        this_.mCloudConfig = cloudConfig;
        this_.mCameraSupervisor.a(cloudConfig.getCamera2SupportMinApiLevel());
        LiteavLog.i(TAG, "setCaptureCloudConfig minApiLevel:" + cloudConfig.getCamera2SupportMinApiLevel());
    }

    static /* synthetic */ void lambda$setServerConfig$1(CameraCaptureSingleton this_, ServerVideoProducerConfig serverConfig) {
        this_.mServerConfig = serverConfig;
        this_.mCameraSupervisor.a(serverConfig.getCamera2SupportMinApiLevel());
        LiteavLog.i(TAG, "setServerConfig minApiLevel:" + serverConfig.getCamera2SupportMinApiLevel());
    }

    static /* synthetic */ void lambda$removeListener$0(CameraCaptureSingleton this_, CaptureSourceInterface.CaptureSourceListener listener) {
        this_.mListenerManager.b(listener);
    }
}

