/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.projection.MediaProjection;
import android.opengl.Matrix;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.SystemUtil;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.base.util.w;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.e;
import com.tencent.liteav.videobase.utils.g;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.VirtualDisplayManager;
import com.tencent.liteav.videoproducer.capture.au;
import com.tencent.liteav.videoproducer.capture.az;
import com.tencent.liteav.videoproducer.capture.ba;
import com.tencent.liteav.videoproducer.capture.bb;
import com.tencent.liteav.videoproducer.capture.bc;
import com.tencent.liteav.videoproducer.capture.bd;
import com.tencent.liteav.videoproducer.capture.be;
import com.tencent.liteav.videoproducer.capture.bf;
import java.util.Locale;

public final class ScreenCapturer
extends au
implements SurfaceTexture.OnFrameAvailableListener,
w.a,
VirtualDisplayManager.VirtualDisplayListener {
    private final String g = "ScreenCapturer_" + this.hashCode();
    @NonNull
    private final Context h;
    @NonNull
    private final IVideoReporter i;
    @Nullable
    private ScreenCaptureParams j;
    @Nullable
    private Size k;
    private boolean l;
    private int m;
    private int n;
    private int o = -1;
    private SurfaceTexture p;
    private Surface q;
    protected l f;
    private g r;
    private w s;
    private MediaProjection t;
    private boolean u = true;
    private boolean v = false;
    private boolean w = false;
    private boolean x = false;

    public ScreenCapturer(@NonNull Context context, @NonNull Looper looper, @NonNull IVideoReporter reporter) {
        super(looper, reporter);
        this.h = context.getApplicationContext();
        this.i = reporter;
    }

    @Override
    public final void stop() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.b(az.a(screenCapturer));
    }

    @Override
    protected final void a(CaptureSourceInterface.CaptureParams captureParams) {
        LiteavLog.i(this.g, "Start capture %s", captureParams);
        if (this.c == null) {
            LiteavLog.e(this.g, "Start capture, mEGLCore is null");
            this.a(false);
            return;
        }
        this.j = new ScreenCaptureParams((ScreenCaptureParams)captureParams);
        this.t = this.j.f;
        if (!this.c()) {
            this.i.notifyError(h.a.f, "Start screen capture failed, params:" + this.j);
            this.a(false);
            return;
        }
        this.e();
    }

    private void e() {
        if (this.f == null) {
            this.f = new l();
        }
        if (this.k == null) {
            this.i();
        }
        if (this.j.a) {
            this.u = ScreenCapturer.j();
            this.g();
            ScreenCapturer screenCapturer = this;
            screenCapturer.b(screenCapturer.u);
        } else {
            this.f();
        }
        this.o = OpenGlUtils.generateTextureOES();
        this.p = new SurfaceTexture(this.o);
        this.p.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.p.setDefaultBufferSize(this.m, this.n);
        this.q = new Surface(this.p);
        VirtualDisplayManager.a(this.h).a(this.q, this.m, this.n, this.t, this);
        LiteavLog.i(this.g, "Start virtual display, size: %dx%d", this.m, this.n);
    }

    private void f() {
        boolean bl2;
        boolean bl3 = this.j.c < this.j.d;
        boolean bl4 = bl2 = this.k.width < this.k.height;
        if (this.j.c == this.j.d || bl3 == bl2) {
            this.m = this.k.width;
            this.n = this.k.height;
        } else {
            this.m = this.k.height;
            this.n = this.k.width;
        }
        LiteavLog.i(this.g, "UpdateSurfaceSizeByCaptureParams, capture params size: " + new Size(this.j.c, this.j.d) + ", surface final size:" + new Size(this.m, this.n));
    }

    private void g() {
        if (this.u != this.l) {
            this.m = this.k.height;
            this.n = this.k.width;
        } else {
            this.m = this.k.width;
            this.n = this.k.height;
        }
        LiteavLog.i(this.g, "UpdateSurfaceSizeByDisplayOrientation, original display size:" + this.k + " portrait:" + this.l + " , surface final size :" + new Size(this.m, this.n) + " portrait:" + this.u);
    }

    @Override
    protected final void b() {
        LiteavLog.i(this.g, "Stop capture");
        this.h();
        this.i.notifyEvent(h.b.n, null, "Stop screen capture success");
        this.x = false;
    }

    private void h() {
        this.t = null;
        VirtualDisplayManager.a(this.h).a(this.q);
        if (this.q != null) {
            this.q.release();
            this.q = null;
        }
        if (!this.c()) {
            LiteavLog.w(this.g, "MakeCurrent error!");
            this.d();
            return;
        }
        if (this.f != null) {
            this.f.b();
            this.f = null;
        }
        if (this.p != null) {
            this.p.setOnFrameAvailableListener(null);
            this.p.release();
            this.p = null;
        }
        OpenGlUtils.deleteTexture(this.o);
        this.o = -1;
        if (this.s != null) {
            this.s.a();
            this.s = null;
        }
    }

    @Override
    public final void updateParams(CaptureSourceInterface.CaptureParams params) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(ba.a(screenCapturer, params));
    }

    @Override
    public final void pause() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bb.a(screenCapturer));
    }

    @Override
    public final void resume() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bc.a(screenCapturer));
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bd.a(screenCapturer));
    }

    @Override
    public final void onTimeout() {
        Object object;
        if (this.p == null || this.w) {
            return;
        }
        Object object2 = this.r;
        long l2 = SystemClock.elapsedRealtime();
        if (!(((g)object2).a == 0 ? true : ((g)object2).b == -1L || l2 - ((g)object2).b >= (((g)object2).c + 1L) * 1000L / (long)((g)object2).a)) {
            return;
        }
        if (this.j != null && this.j.a) {
            object2 = this;
            boolean bl2 = ((ScreenCapturer)object2).u;
            ((ScreenCapturer)object2).u = ScreenCapturer.j();
            if (bl2 != ((ScreenCapturer)object2).u) {
                ScreenCapturer screenCapturer = this;
                bl2 = screenCapturer.u;
                object2 = screenCapturer;
                LiteavLog.i(screenCapturer.g, "Display orientation changed, isPortrait: %b", bl2);
                if (((ScreenCapturer)object2).j != null && ((ScreenCapturer)object2).j.a) {
                    super.h();
                    super.e();
                }
                return;
            }
        }
        if (!this.c()) {
            this.d();
            return;
        }
        object2 = this.r;
        if (((g)object2).b == -1L) {
            ((g)object2).b = SystemClock.elapsedRealtime();
        }
        ++((g)object2).c;
        object2 = this;
        if (((ScreenCapturer)object2).f == null || ((ScreenCapturer)object2).j == null || ((ScreenCapturer)object2).c == null) {
            LiteavLog.w(((ScreenCapturer)object2).g, "onScreenFrameAvailable mTextureHolderPool = " + ((ScreenCapturer)object2).f + ", mCaptureParams = " + ((ScreenCapturer)object2).j + ", mEGLCore = " + ((ScreenCapturer)object2).c);
            return;
        }
        l.b b2 = null;
        try {
            b2 = (l.b)((ScreenCapturer)object2).f.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w(((ScreenCapturer)object2).g, "Texture holder pool obtain interrupted.");
        }
        if (b2 == null) {
            LiteavLog.e(((ScreenCapturer)object2).g, "Texture holder pool obtain null holder.");
            return;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (((ScreenCapturer)object2).j.e != null && !((ScreenCapturer)object2).j.e.isEmpty()) {
            object = ((ScreenCapturer)object2).j.e;
            f2 = (float)((Rect)object).left * 1.0f / (float)((ScreenCapturer)object2).m;
            f3 = (float)((Rect)object).top * 1.0f / (float)((ScreenCapturer)object2).n;
            int n2 = Math.min(((ScreenCapturer)object2).m - ((Rect)object).left, object.width());
            int n3 = Math.min(((ScreenCapturer)object2).n - ((Rect)object).top, object.height());
            f4 = (float)n2 * 1.0f / (float)((ScreenCapturer)object2).m;
            f5 = (float)n3 * 1.0f / (float)((ScreenCapturer)object2).n;
        }
        b2.a(36197, ((ScreenCapturer)object2).o, ((ScreenCapturer)object2).m, ((ScreenCapturer)object2).n);
        object = b2.a(((ScreenCapturer)object2).c.getEglContext());
        if (((PixelFrame)object).getMatrix() == null) {
            ((PixelFrame)object).setMatrix(new float[16]);
        }
        ((ScreenCapturer)object2).p.updateTexImage();
        ((ScreenCapturer)object2).p.getTransformMatrix(((PixelFrame)object).getMatrix());
        ((PixelFrame)object).setTimestamp(TimeUtil.c());
        if (!com.tencent.liteav.videobase.utils.e.a(f2, 0.0f) || !com.tencent.liteav.videobase.utils.e.a(f3, 0.0f)) {
            Matrix.translateM((float[])((PixelFrame)object).getMatrix(), (int)0, (float)f2, (float)f3, (float)0.0f);
        }
        if (!com.tencent.liteav.videobase.utils.e.a(f4, 1.0f) || !com.tencent.liteav.videobase.utils.e.a(f5, 1.0f)) {
            Matrix.scaleM((float[])((PixelFrame)object).getMatrix(), (int)0, (float)f4, (float)f5, (float)1.0f);
        }
        if (((ScreenCapturer)object2).d != null) {
            if (!((ScreenCapturer)object2).x) {
                ((ScreenCapturer)object2).x = true;
                ((ScreenCapturer)object2).d.onCaptureFirstFrame();
            }
            ((ScreenCapturer)object2).d.onFrameAvailable((CaptureSourceInterface)object2, (PixelFrame)object);
        }
        b2.release();
        ((PixelFrame)object).release();
    }

    @Override
    public final void onStartFinish(boolean success, boolean isPermissionDenied) {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(be.a(screenCapturer, success, isPermissionDenied));
    }

    @Override
    public final void onCaptureError() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.a(bf.a(screenCapturer));
    }

    private void i() {
        this.l = ScreenCapturer.j();
        this.k = SystemUtil.getDisplaySize();
        if (!this.k.isValid()) {
            this.k = this.l ? new Size(720, 1280) : new Size(1280, 720);
        }
        LiteavLog.i(this.g, "get display size: " + this.k + ", display portrait: " + this.l);
    }

    private static boolean j() {
        int n2 = SystemUtil.getDisplayRotation();
        return n2 == 0 || n2 == 2;
    }

    private void b(boolean bl2) {
        if (!this.j.a) {
            return;
        }
        if (this.d != null) {
            this.d.onScreenDisplayOrientationChanged(bl2);
        }
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer) {
        LiteavLog.e(screenCapturer.g, "capture error");
        if (screenCapturer.d != null) {
            screenCapturer.d.onCaptureError();
        }
        screenCapturer.i.notifyEvent(h.b.o, null, "screen capture has been interrupted");
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, boolean bl2, boolean bl3) {
        LiteavLog.i(screenCapturer.g, "on Start finish, success: %b, isPermissionDenied: %b", bl2, bl3);
        screenCapturer.a(bl2);
        if (bl2) {
            if (!screenCapturer.v) {
                screenCapturer.v = true;
                screenCapturer.i.notifyEvent(h.b.m, null, "Start screen capture success params:" + screenCapturer.j);
                return;
            }
        } else {
            if (bl3) {
                screenCapturer.i.notifyError(h.a.g, "permission denied, Start screen capture failed, params:" + screenCapturer.j);
                return;
            }
            screenCapturer.i.notifyError(h.a.f, "Start screen capture failed, params:" + screenCapturer.j);
        }
    }

    static /* synthetic */ void b(ScreenCapturer screenCapturer) {
        if (screenCapturer.p == null) {
            return;
        }
        screenCapturer.r = new g(screenCapturer.j.b);
        screenCapturer.s = new w(screenCapturer.a.getLooper(), screenCapturer);
        screenCapturer.s.a(0, 5);
        screenCapturer.p.setOnFrameAvailableListener(null);
    }

    static /* synthetic */ void c(ScreenCapturer screenCapturer) {
        LiteavLog.i(screenCapturer.g, "Resume capture");
        if (screenCapturer.w) {
            screenCapturer.i.notifyEvent(h.b.p, null, "screen capture has been resumed");
        }
        screenCapturer.w = false;
        if (screenCapturer.r != null) {
            screenCapturer.r.a();
        }
    }

    static /* synthetic */ void d(ScreenCapturer screenCapturer) {
        LiteavLog.i(screenCapturer.g, "Pause capture");
        if (!screenCapturer.w) {
            screenCapturer.i.notifyEvent(h.b.o, null, "screen capture has been interrupted");
        }
        screenCapturer.w = true;
    }

    static /* synthetic */ void a(ScreenCapturer screenCapturer, CaptureSourceInterface.CaptureParams captureParams) {
        if (screenCapturer.j != null && screenCapturer.j.equals(captureParams)) {
            LiteavLog.i(screenCapturer.g, "UpdateParams %s is the same ", captureParams);
            return;
        }
        LiteavLog.i(screenCapturer.g, "UpdateParams change from %s to %s", screenCapturer.j, captureParams);
        screenCapturer.j = new ScreenCaptureParams((ScreenCaptureParams)captureParams);
        if (screenCapturer.p == null) {
            LiteavLog.e(screenCapturer.g, "Capturer not started");
            return;
        }
        screenCapturer.t = screenCapturer.j.f;
        screenCapturer.h();
        screenCapturer.e();
    }

    public static class ScreenCaptureParams
    extends CaptureSourceInterface.CaptureParams {
        public boolean a;
        public MediaProjection f;

        public ScreenCaptureParams() {
        }

        public ScreenCaptureParams(ScreenCaptureParams params) {
            super(params);
            this.a = params.a;
            this.f = params.f;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ScreenCaptureParams)) {
                return false;
            }
            ScreenCaptureParams screenCaptureParams = (ScreenCaptureParams)obj;
            return super.equals(obj) && this.a == screenCaptureParams.a && this.f == screenCaptureParams.f;
        }

        @Override
        @NonNull
        public String toString() {
            return String.format(Locale.ENGLISH, "%s, autoRotate: %b, mediaProjcetion: %s", super.toString(), this.a, this.f);
        }
    }
}

