/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Looper;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.ugc.AudioEncodeParams;
import com.tencent.ugc.AudioFrame;
import com.tencent.ugc.CombineFilterInfo;
import com.tencent.ugc.MP4Writer;
import com.tencent.ugc.TXAudioFrame;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCAVSyncer;
import com.tencent.ugc.UGCAudioProcessor;
import com.tencent.ugc.UGCInitializer;
import com.tencent.ugc.UGCLicenseChecker;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.UGCThumbnailGenerator;
import com.tencent.ugc.UGCVideoProcessor;
import com.tencent.ugc.aa;
import com.tencent.ugc.ab;
import com.tencent.ugc.ac;
import com.tencent.ugc.ad;
import com.tencent.ugc.ae;
import com.tencent.ugc.af;
import com.tencent.ugc.ag;
import com.tencent.ugc.ah;
import com.tencent.ugc.ai;
import com.tencent.ugc.aj;
import com.tencent.ugc.ak;
import com.tencent.ugc.al;
import com.tencent.ugc.am;
import com.tencent.ugc.an;
import com.tencent.ugc.ao;
import com.tencent.ugc.ap;
import com.tencent.ugc.aq;
import com.tencent.ugc.ar;
import com.tencent.ugc.as;
import com.tencent.ugc.at;
import com.tencent.ugc.au;
import com.tencent.ugc.av;
import com.tencent.ugc.aw;
import com.tencent.ugc.ax;
import com.tencent.ugc.ay;
import com.tencent.ugc.az;
import com.tencent.ugc.b;
import com.tencent.ugc.ba;
import com.tencent.ugc.bb;
import com.tencent.ugc.bc;
import com.tencent.ugc.bd;
import com.tencent.ugc.be;
import com.tencent.ugc.bf;
import com.tencent.ugc.bg;
import com.tencent.ugc.bh;
import com.tencent.ugc.bi;
import com.tencent.ugc.bj;
import com.tencent.ugc.bk;
import com.tencent.ugc.bl;
import com.tencent.ugc.bm;
import com.tencent.ugc.bn;
import com.tencent.ugc.bo;
import com.tencent.ugc.bp;
import com.tencent.ugc.bq;
import com.tencent.ugc.br;
import com.tencent.ugc.bs;
import com.tencent.ugc.bt;
import com.tencent.ugc.bu;
import com.tencent.ugc.c;
import com.tencent.ugc.common.MediaExtractorBuilder;
import com.tencent.ugc.common.UGCConstants;
import com.tencent.ugc.common.UGCTranscodeAudioEncodeParamsDecider;
import com.tencent.ugc.common.UGCTranscodeVideoEncodeParamsDecider;
import com.tencent.ugc.d;
import com.tencent.ugc.datereport.UGCDataReport;
import com.tencent.ugc.e;
import com.tencent.ugc.f;
import com.tencent.ugc.g;
import com.tencent.ugc.h;
import com.tencent.ugc.i;
import com.tencent.ugc.j;
import com.tencent.ugc.k;
import com.tencent.ugc.l;
import com.tencent.ugc.m;
import com.tencent.ugc.n;
import com.tencent.ugc.o;
import com.tencent.ugc.p;
import com.tencent.ugc.q;
import com.tencent.ugc.r;
import com.tencent.ugc.retriver.FFmpegMediaRetriever;
import com.tencent.ugc.s;
import com.tencent.ugc.t;
import com.tencent.ugc.u;
import com.tencent.ugc.v;
import com.tencent.ugc.w;
import com.tencent.ugc.x;
import com.tencent.ugc.y;
import com.tencent.ugc.z;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TXVideoEditer {
    private static final String TAG = "TXVideoEditer";
    private final AtomicReference<Long> mPendingPreviewAtTime = new AtomicReference();
    private final Context mContext;
    @NonNull
    private final UGCVideoProcessor mVideoProcessor;
    @NonNull
    private final UGCAudioProcessor mAudioProcessor;
    @NonNull
    private final UGCMediaListSource mMediaListSource;
    @NonNull
    private final UGCAVSyncer mAVSyncer = new UGCAVSyncer();
    private UGCAVSyncer.SyncMode mPreviewSyncMode = UGCAVSyncer.SyncMode.VIDEO_MASTER;
    private MP4Writer mMp4Writer;
    private boolean mIsGenerating = false;
    private boolean mIsPlaying = false;
    private boolean mIsProcessToFullKeyFrame = false;
    private boolean mHasBGM = false;
    private boolean mNeedWaitProcessFullI = false;
    private boolean mNeedWaitThumbnailProcess = false;
    private AtomicReference<Long> mTargetSeekPts = new AtomicReference();
    private final long MIN_SEEK_DIR = 100L;
    private AtomicBoolean mIsRelease = new AtomicBoolean(false);
    private ArrayList<UGCThumbnailGenerator> mUGCThumbnailGeneratorList = new ArrayList();
    private final MP4Writer.MP4WriterListener mMp4WriterListener = new MP4Writer.MP4WriterListener(){

        @Override
        public final void onComplete(long durationMs) {
            LiteavLog.i(TXVideoEditer.TAG, "onComplete ".concat(String.valueOf(durationMs)));
            TXVideoEditer.this.handleWriteMP4Completed(0, durationMs);
        }

        @Override
        public final void onError(String info) {
            LiteavLog.i(TXVideoEditer.TAG, "onError ".concat(String.valueOf(info)));
            TXVideoEditer.this.handleWriteMP4Completed(-1, 0L);
        }
    };
    private final CustomHandler mMainHandler = new CustomHandler(Looper.getMainLooper());
    protected final com.tencent.liteav.base.util.l mSequenceTaskRunner;
    @NonNull
    private final UGCThumbnailGenerator mThumbnailGenerator;
    private UGCThumbnailGenerator.UGCThumbnailGenerateParams mProcessThumbnailInfo;
    private TXThumbnailListener mProcessThumbnailListener;
    private CombineFilterInfo mCombineFilterInfo;
    private FrameLayout mFrameLayout;
    private String mSourcePath;
    private String mProcessOutputPath;
    private boolean mIsVideoEnd = false;
    private boolean mIsAudioEnd = false;
    private TXVideoProcessListener mVideoProcessListener;
    private TXVideoPreviewListener mVideoPreviewListener;
    private TXVideoGenerateListener mVideoGenerateListener;
    private List<MediaFormat> mVideoFormatList;
    private List<MediaFormat> mAudioFormatList;
    private MediaFormat mBGMFormat;
    private int mVideoEncodeBitrate = -1;
    private int mAudioEncodeBitrate = -1;
    private Size mEncodeResolution;
    private int mEncodeProfile = -1;
    private long mSourceRangeStartTimeMs = 0L;
    private long mSourceRangeEndTimeMs = Integer.MAX_VALUE;
    private long mCutStartTimeMs = 0L;
    private long mCutEndTimeMs = Integer.MAX_VALUE;
    private boolean mIsReverse = false;
    private boolean mIsFullIFrame = false;
    private Rotation mRotation = Rotation.a;
    private boolean mIsVideoEncoderStarted = false;
    private boolean mIsAudioEncoderStarted = false;
    private final UGCVideoProcessor.VideoEncodedFrameListener mVideoEncodedFrameListener = new UGCVideoProcessor.VideoEncodedFrameListener(){

        @Override
        public final void onVideoEncodeStarted() {
            TXVideoEditer.this.mIsVideoEncoderStarted = true;
        }

        @Override
        public final void onVideoFrameEncoded(EncodedVideoFrame frame) {
            TXVideoEditer.this.onVideoEncodedFrame(frame);
        }

        @Override
        public final void onVideoEncodingCompleted() {
            TXVideoEditer.this.onVideoEncodedFrameComplete();
        }
    };
    private final UGCAudioProcessor.AudioEncodedFrameListener mAudioEncodedFrameListener = new UGCAudioProcessor.AudioEncodedFrameListener(){

        @Override
        public final void onAudioEncodingStarted() {
            TXVideoEditer.this.mIsAudioEncoderStarted = true;
        }

        @Override
        public final void onAudioFrameEncoded(AudioFrame frame) {
            TXVideoEditer.this.onAudioEncodedFrame(frame);
        }

        @Override
        public final void onAudioEncodingCompleted() {
            TXVideoEditer.this.onAudioEncodedFrameComplete();
        }
    };
    private final UGCVideoProcessor.VideoProcessListener mVideoProcessProgressListener = new UGCVideoProcessor.VideoProcessListener(){

        @Override
        public final void onProgress(long progress) {
            TXVideoEditer.this.mSequenceTaskRunner.a(bu.a(this, progress));
        }

        @Override
        public final void onComplete(TXVideoEditConstants.TXGenerateResult result) {
            if (result != null) {
                LiteavLog.i(TXVideoEditer.TAG, "on video progress complete: retCode= " + result.retCode + ", descMsg= " + result.descMsg);
            }
            TXVideoEditer.this.mSequenceTaskRunner.a(TXVideoEditer.this.mRunnableVideoProcessOnComplete);
        }

        static /* synthetic */ void a(4 var0, long l2) {
            long l3 = l2 * 1000L;
            if (var0.TXVideoEditer.this.mIsReverse) {
                l3 = var0.TXVideoEditer.this.mMediaListSource.getDuration() * 1000L - l3;
            }
            l3 = com.tencent.liteav.base.util.h.a(l3, 0L, var0.TXVideoEditer.this.mMediaListSource.getDuration() * 1000L);
            var0.TXVideoEditer.this.notifyPreviewProgress((int)l3);
        }
    };
    private final Runnable mRunnableVideoProcessOnComplete = b.a(this);
    private final TXThumbnailListener mThumbnailListenerForProcessFullI = m.a(this);
    private final TXThumbnailListener mInnerThumbnailListener = x.a(this);
    private static final HashSet<String> sVideoExtHashSet = new HashSet<String>(Arrays.asList("3gpp", "3gp", "3g2", "m4v", "mpeg", "mpg", "mpe", "mp4", "vob", "qt", "mov", "wmv", "avi"));

    public TXVideoEditer(Context context) {
        this(context, new com.tencent.liteav.base.util.l());
    }

    protected TXVideoEditer(Context context, @NonNull com.tencent.liteav.base.util.l sequenceTaskRunner) {
        UGCInitializer.initialize();
        this.mContext = context.getApplicationContext();
        this.mMediaListSource = new UGCMediaListSource();
        this.mVideoProcessor = new UGCVideoProcessor(this.mContext, this.mMediaListSource, this.mAVSyncer, new com.tencent.liteav.videobase.videobase.f(), true);
        this.mAudioProcessor = new UGCAudioProcessor(this.mAVSyncer, this.mMediaListSource);
        this.mThumbnailGenerator = new UGCThumbnailGenerator();
        this.mThumbnailGenerator.initialize();
        this.mVideoProcessor.initialize();
        this.mAudioProcessor.initialize();
        this.mMediaListSource.initialize();
        this.mSequenceTaskRunner = sequenceTaskRunner;
        UGCDataReport.reportDAU(1004);
    }

    public int setVideoPath(String videoSource) {
        LiteavLog.i(TAG, "setVideoPath ".concat(String.valueOf(videoSource)));
        if (TextUtils.isEmpty((CharSequence)videoSource)) {
            return -1;
        }
        int n2 = TXVideoEditer.isMediaSourceValid(videoSource);
        if (n2 != 0) {
            LiteavLog.i(TAG, "setVideoPath " + videoSource + " is illegal." + n2);
            return n2;
        }
        this.mSequenceTaskRunner.a(ai.a(this, videoSource));
        return 0;
    }

    public void setCustomVideoProcessListener(TXVideoCustomProcessListener listener) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setCustomVideoProcessListener is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(at.a(this, listener));
    }

    public void setProfile(int profile) {
        this.mSequenceTaskRunner.a(be.a(this, profile));
    }

    public void setSpecialRatio(float specialRatio) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setSpecialRatio is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(bp.a(this, specialRatio));
    }

    public void setFilter(Bitmap bmp) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setFilter is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1023);
        this.mSequenceTaskRunner.a(bs.a(this, bmp));
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setFilter is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(bt.a(this, leftIntensity, rightIntensity, leftRatio, leftBitmap, rightBitmap));
    }

    public void setBeautyFilter(int beautyLevel, int whiteningLevel) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBeautyFilter is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(c.a(this, beautyLevel, whiteningLevel));
    }

    public int setPictureList(List<Bitmap> bitmapList, int fps) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setPictureList is not supported in UGC_Smart license");
            return -1;
        }
        UGCDataReport.reportDAU(1030);
        this.mSequenceTaskRunner.a(d.a(this, fps, bitmapList));
        return 0;
    }

    public long setPictureTransition(int type) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setPictureTransition is not supported in UGC_Smart license");
            return 0L;
        }
        this.mSequenceTaskRunner.b(e.a(this, type));
        return this.mMediaListSource.getDuration();
    }

    public int setBGM(String path) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGM is not supported in UGC_Smart license");
            return 0;
        }
        LiteavLog.i(TAG, "setBGM: path= ".concat(String.valueOf(path)));
        int n2 = 0;
        boolean bl2 = false;
        if (!TextUtils.isEmpty((CharSequence)path)) {
            n2 = this.isBGMValid(path);
        } else {
            bl2 = true;
            LiteavLog.e(TAG, " setBGM: bgm path is empty.");
        }
        if (n2 != 0) {
            LiteavLog.i(TAG, " setBGM: check return: ".concat(String.valueOf(n2)));
            return n2;
        }
        boolean bl3 = bl2;
        this.mSequenceTaskRunner.a(f.a(this, path, bl3));
        UGCDataReport.reportDAU(1024);
        return 0;
    }

    public void setBGMLoop(boolean looping) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMLoop is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(g.a(this, looping));
    }

    public void setBGMAtVideoTime(long videoStartTime) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMAtVideoTime is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(h.a(this, videoStartTime));
    }

    public void setBGMStartTime(long startTime, long endTime) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMStartTime is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(i.a(this, startTime, endTime));
    }

    public void setBGMVolume(float volume) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMVolume is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(j.a(this, volume));
    }

    public void setBGMFadeInOutDuration(long fadeInDuration, long fadeOutDuration) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMFadeInOutDuration is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(k.a(this, fadeInDuration, fadeOutDuration));
    }

    public void setWaterMark(Bitmap watermark, TXVideoEditConstants.TXRect rect) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setWaterMark is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1028);
        this.mSequenceTaskRunner.a(l.a(this, rect, watermark));
    }

    public void setTailWaterMark(Bitmap tailWatermark, TXVideoEditConstants.TXRect rect, int duration) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setTailWaterMark is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1029);
        this.mSequenceTaskRunner.a(n.a(this, duration, tailWatermark, rect));
    }

    public void setSubtitleList(List<TXVideoEditConstants.TXSubtitle> subtitleList) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setSubtitleList is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1027);
        this.mSequenceTaskRunner.a(o.a(this, subtitleList));
    }

    public void setAnimatedPasterList(List<TXVideoEditConstants.TXAnimatedPaster> animatedPasterList) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setAnimatedPasterList is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1026);
        this.mSequenceTaskRunner.a(p.a(this, animatedPasterList));
    }

    public void setPasterList(List<TXVideoEditConstants.TXPaster> pasterList) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setPasterList is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1025);
        this.mSequenceTaskRunner.a(q.a(this, pasterList));
    }

    public void setRenderRotation(int rotation) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setRenderRotation is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(r.a(this, rotation));
    }

    public void setSpeedList(List<TXVideoEditConstants.TXSpeed> speedList) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setSpeedList is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1019);
        this.mSequenceTaskRunner.a(s.a(this, speedList));
    }

    public void setRepeatPlay(List<TXVideoEditConstants.TXRepeat> repeatList) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setRepeatPlay is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1020);
        this.mSequenceTaskRunner.a(t.a(this, repeatList));
    }

    public void setReverse(boolean isReverse) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setReverse is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1021);
        this.mSequenceTaskRunner.a(u.a(this, isReverse));
    }

    public boolean setTransitionEffect(int type, long videoTotalDurationMs, long startTimeMs) {
        return this.setTransitionEffect(type, startTimeMs, videoTotalDurationMs, 1000L);
    }

    public boolean setTransitionEffect(int type, long videoTotalDurationMs, long startTimeMs, long transitionDurationMs) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setTransitionEffect is not supported in UGC_Smart license");
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.mSequenceTaskRunner.b(v.a(this, type, startTimeMs, transitionDurationMs, atomicBoolean));
        return atomicBoolean.get();
    }

    public void deleteLastTransitionEffect() {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "deleteLastTransitionEffect is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(w.a(this));
    }

    public void startEffect(int type, long startTime) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "startEffect is not supported in UGC_Smart license");
            return;
        }
        UGCDataReport.reportDAU(1022, type, "");
        this.mSequenceTaskRunner.a(y.a(this, type, startTime));
    }

    public void stopEffect(int type, long endTime) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "stopEffect is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(z.a(this, type, endTime));
    }

    public void deleteLastEffect() {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "deleteLastEffect is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(aa.a(this));
    }

    public void deleteAllEffect() {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "deleteAllEffect is not supported in UGC_Smart license");
            return;
        }
        this.mSequenceTaskRunner.a(ab.a(this));
    }

    public void setVideoProcessListener(TXVideoProcessListener listener) {
        this.mSequenceTaskRunner.a(ac.a(this, listener));
    }

    public void getThumbnail(List<Long> thumbnailList, int width, int height, boolean fast, TXThumbnailListener listener) {
        this.mSequenceTaskRunner.a(ad.a(this, thumbnailList, width, height, fast, listener));
    }

    public void getThumbnail(int count, int width, int height, boolean fast, TXThumbnailListener listener) {
        this.mSequenceTaskRunner.a(ae.a(this, width, height, fast, count, listener));
    }

    public void setThumbnail(TXVideoEditConstants.TXThumbnail thumbnail) {
        this.mSequenceTaskRunner.a(af.a(this, thumbnail));
    }

    public void setThumbnailListener(TXThumbnailListener listener) {
        this.mSequenceTaskRunner.a(ag.a(this, listener));
    }

    private void startMP4Writer(String outputPath) {
        LiteavLog.i(TAG, "startMP4Writer ".concat(String.valueOf(outputPath)));
        this.mMp4Writer = new MP4Writer();
        this.mMp4Writer.setListener(this.mMp4WriterListener);
        if (!com.tencent.liteav.videobase.utils.c.a(this.mAudioFormatList) || this.mHasBGM) {
            this.mMp4Writer.setHasAudio(true);
        }
        this.mMp4Writer.setHasVideo(true);
        this.mMp4Writer.setPath(outputPath);
        this.mMp4Writer.start();
    }

    public void processVideo() {
        this.mSequenceTaskRunner.a(ah.a(this));
    }

    private void processVideoInternal() {
        TXThumbnailListener tXThumbnailListener;
        if (!UGCLicenseChecker.isSimpleFunctionSupport()) {
            TXVideoProcessListener tXVideoProcessListener = this.mVideoProcessListener;
            this.mMainHandler.post(aj.a(tXVideoProcessListener));
            return;
        }
        UGCDataReport.reportDAU(1034);
        LiteavLog.i(TAG, "processVideoInternal");
        this.mProcessOutputPath = this.generateVideoPath();
        TXVideoEditer tXVideoEditer = this;
        boolean bl2 = tXVideoEditer.isFullIFrame(tXVideoEditer.mSourcePath);
        UGCTranscodeVideoEncodeParamsDecider uGCTranscodeVideoEncodeParamsDecider = new UGCTranscodeVideoEncodeParamsDecider();
        uGCTranscodeVideoEncodeParamsDecider.setSourceType(UGCConstants.SourceType.VIDEO);
        uGCTranscodeVideoEncodeParamsDecider.setFullIFrame(true);
        uGCTranscodeVideoEncodeParamsDecider.setEncodeRotation(this.mRotation);
        uGCTranscodeVideoEncodeParamsDecider.setOutputResolution(4);
        uGCTranscodeVideoEncodeParamsDecider.setInputVideoMediaFormat(this.mVideoFormatList);
        VideoEncodeParams videoEncodeParams = uGCTranscodeVideoEncodeParamsDecider.getDecidedEncodeParams();
        UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = new UGCTranscodeAudioEncodeParamsDecider();
        uGCTranscodeAudioEncodeParamsDecider.setInputAudioMediaFormat(this.mAudioFormatList);
        AudioEncodeParams audioEncodeParams = uGCTranscodeAudioEncodeParamsDecider.getDecidedEncodeParams();
        TXVideoEditer tXVideoEditer2 = this;
        boolean bl3 = tXVideoEditer2.isGopEqualOne(tXVideoEditer2.mSourcePath);
        LiteavLog.i(TAG, "processVideoInternal: hasIFramePerMinute= " + bl3 + ", inputFullIFrame= " + bl2 + ",mProcessOutputPath= " + this.mProcessOutputPath);
        this.mIsProcessToFullKeyFrame = true;
        this.mNeedWaitProcessFullI = true;
        this.mIsGenerating = true;
        if (!bl2) {
            TXVideoEditer tXVideoEditer3 = this;
            tXVideoEditer3.startRecord(tXVideoEditer3.mProcessOutputPath, videoEncodeParams, audioEncodeParams);
            tXThumbnailListener = this.mThumbnailListenerForProcessFullI;
        } else {
            tXThumbnailListener = this.mInnerThumbnailListener;
        }
        this.handleProcessThumbnail(videoEncodeParams.width, videoEncodeParams.height, tXThumbnailListener);
    }

    private void handleProcessThumbnail(int width, int height, TXThumbnailListener listener) {
        if (this.mProcessThumbnailInfo == null) {
            return;
        }
        if (this.mProcessThumbnailInfo.width == 0 || this.mProcessThumbnailInfo.height == 0) {
            this.mProcessThumbnailInfo.width = width;
            this.mProcessThumbnailInfo.height = height;
        }
        this.mThumbnailGenerator.setVideoSourceRange(this.mCutStartTimeMs, this.mCutEndTimeMs);
        this.mProcessThumbnailInfo.thumbnailPtsList = UGCThumbnailGenerator.calculateThumbnailList(this.mProcessThumbnailInfo.thumbnailCount, 0L, this.mCutEndTimeMs - this.mCutStartTimeMs, this.mMediaListSource.getDuration());
        this.mNeedWaitThumbnailProcess = true;
        this.mThumbnailGenerator.start(this.mProcessThumbnailInfo, listener);
    }

    public void release() {
        this.mSequenceTaskRunner.a(ak.a(this));
    }

    private void clearThumbnailGenerator() {
        if (this.mUGCThumbnailGeneratorList.size() <= 0) {
            return;
        }
        for (UGCThumbnailGenerator uGCThumbnailGenerator : this.mUGCThumbnailGeneratorList) {
            uGCThumbnailGenerator.stop();
            uGCThumbnailGenerator.uninitialize();
        }
        this.mUGCThumbnailGeneratorList.clear();
    }

    public void setTXVideoPreviewListener(TXVideoPreviewListener listener) {
        this.mSequenceTaskRunner.a(al.a(this, listener));
    }

    public void initWithPreview(TXVideoEditConstants.TXPreviewParam param) {
        if (param == null) {
            LiteavLog.i(TAG, "initWithPreview param is null.");
            return;
        }
        LiteavLog.i(TAG, "initWithPreview: view= " + param.videoView + " renderMode= " + param.renderMode);
        this.mMainHandler.runOrPost(am.a(this, param));
    }

    public void startPlayFromTime(long startTime, long endTime) {
        this.mSequenceTaskRunner.a(an.a(this, startTime, endTime));
    }

    public void pausePlay() {
        this.mSequenceTaskRunner.a(ao.a(this));
    }

    public void resumePlay() {
        this.mSequenceTaskRunner.a(ap.a(this));
    }

    public void stopPlay() {
        this.mSequenceTaskRunner.a(aq.a(this));
    }

    private void doStopPlayInner() {
        LiteavLog.i(TAG, "doStopPlayInner");
        this.mVideoProcessor.setProgressListener(null);
        this.mAudioProcessor.setProgressListener(null);
        this.mAVSyncer.stop();
        this.mVideoProcessor.stop();
        this.mAudioProcessor.stop();
        this.mIsPlaying = false;
    }

    private boolean filtInvalidatedFrame(long framePts) {
        return this.mTargetSeekPts.get() != null && Math.abs(framePts - this.mTargetSeekPts.get()) > 100L;
    }

    public void previewAtTime(long timeMs) {
        this.mPendingPreviewAtTime.set(timeMs);
        this.mTargetSeekPts.set(timeMs);
        this.mSequenceTaskRunner.a(ar.a(this));
    }

    public void setVideoGenerateListener(TXVideoGenerateListener listener) {
        this.mSequenceTaskRunner.a(as.a(this, listener));
    }

    public void setCutFromTime(long startTime, long endTime) {
        this.mSequenceTaskRunner.a(au.a(this, startTime, endTime));
        UGCDataReport.reportDAU(1018);
    }

    public void setVideoBitrate(int videoBitrate) {
        this.mSequenceTaskRunner.a(av.a(this, videoBitrate));
    }

    @Deprecated
    public void setAudioBitrate(int audioBitrate) {
        this.mSequenceTaskRunner.a(aw.a(this, audioBitrate));
    }

    public void generateVideo(int videoCompressed, String videoOutputPath) {
        this.mSequenceTaskRunner.a(ax.a(this, videoCompressed, videoOutputPath));
    }

    public void cancel() {
        this.mSequenceTaskRunner.a(ay.a(this));
    }

    private void stopMp4Writer() {
        LiteavLog.i(TAG, "stopMp4Writer");
        if (this.mMp4Writer != null) {
            this.mMp4Writer.stop();
            this.mMp4Writer = null;
        }
    }

    protected void setIsSplitScreen(boolean isSplitScreen) {
        this.mMediaListSource.setIsMediaSourceOverlapped(isSplitScreen);
        if (isSplitScreen) {
            return;
        }
        this.mVideoProcessor.setSplitScreenList(null, -1, -1);
        this.setOutputSize(null);
    }

    protected void setSplitScreenList(List<TXVideoEditConstants.TXAbsoluteRect> rects, int canvasWidth, int canvasHeight) {
        this.mVideoProcessor.setSplitScreenList(rects, canvasWidth, canvasHeight);
        this.setOutputSize(new Size(canvasWidth, canvasHeight));
    }

    protected void setVideoVolumes(float[] volumes) {
        this.mAudioProcessor.setVideoVolumes(volumes);
    }

    protected long getDuration() {
        return this.mMediaListSource.getDuration();
    }

    protected void setIsFullIFrame(boolean isFullIFrame) {
        this.mIsFullIFrame = isFullIFrame;
    }

    protected void setOutputSize(Size resolution) {
        this.mEncodeResolution = resolution;
    }

    protected boolean isHasAudio() {
        return this.mMediaListSource.hasAudioData();
    }

    public void refreshOneFrame() {
        LiteavLog.i(TAG, "refreshOneFrame");
        this.mSequenceTaskRunner.a(az.a(this));
    }

    public void setVideoVolume(float volume) {
        this.mSequenceTaskRunner.a(ba.a(this, volume));
    }

    public int getThumbnailCount() {
        LiteavLog.i(TAG, "getThumbnailCount");
        if (this.mProcessThumbnailInfo.thumbnailPtsList != null) {
            return this.mProcessThumbnailInfo.thumbnailPtsList.size();
        }
        return 0;
    }

    public String getVideoSourcePath() {
        LiteavLog.i(TAG, "getVideoSourcePath: sourcePath= " + this.mSourcePath);
        return this.mSourcePath;
    }

    public String getVideoProcessPath() {
        LiteavLog.i(TAG, "getVideoProcessPath: process output path= " + this.mProcessOutputPath);
        return this.mProcessOutputPath;
    }

    protected int setMediaSourcePaths(List<String> videoSourceList) {
        if (this.mEncodeResolution == null) {
            this.mVideoProcessor.setOutputSize(-1, -1, GLConstants.GLScaleType.b);
        } else {
            this.mVideoProcessor.setOutputSize(this.mEncodeResolution.width, this.mEncodeResolution.height, GLConstants.GLScaleType.b);
        }
        if (videoSourceList.size() == 1) {
            this.mThumbnailGenerator.setVideoSourceList(videoSourceList);
        }
        this.mMediaListSource.setVideoSources(videoSourceList);
        this.mSourcePath = videoSourceList.get(0);
        this.mVideoFormatList = new LinkedList<MediaFormat>();
        this.mAudioFormatList = new LinkedList<MediaFormat>();
        this.getAllMediaFormatFromSource(videoSourceList);
        if (!com.tencent.liteav.videobase.utils.c.a(this.mVideoFormatList)) {
            this.mAVSyncer.setVideoExist(true);
        }
        if (!com.tencent.liteav.videobase.utils.c.a(this.mAudioFormatList)) {
            this.mAVSyncer.setAudioExist(true);
        }
        this.mPreviewSyncMode = !com.tencent.liteav.videobase.utils.c.a(this.mAudioFormatList) ? (videoSourceList.size() > 1 ? UGCAVSyncer.SyncMode.CLOCK_MASTER : UGCAVSyncer.SyncMode.AUDIO_MASTER) : UGCAVSyncer.SyncMode.VIDEO_MASTER;
        return 0;
    }

    private void getAllMediaFormatFromSource(List<String> videoSourceList) {
        for (String string : videoSourceList) {
            MediaExtractor mediaExtractor = new MediaExtractorBuilder().setPath(string).build();
            if (mediaExtractor != null) {
                int n2 = mediaExtractor.getTrackCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    MediaFormat mediaFormat = mediaExtractor.getTrackFormat(i2);
                    String string2 = mediaFormat.getString("mime");
                    if (string2 == null) continue;
                    if (string2.startsWith("video/")) {
                        this.mVideoFormatList.add(mediaFormat);
                    }
                    if (!string2.startsWith("audio/")) continue;
                    this.mAudioFormatList.add(mediaFormat);
                }
                continue;
            }
            LiteavLog.e(TAG, "build extractor fail.");
        }
    }

    private void doGetThumbnail(List<Long> thumbnailList, int width, int height, boolean fast, TXThumbnailListener listener) {
        LiteavLog.i(TAG, "getThumbnail: width= " + width + " height= " + height + ",fast= " + fast + ",list.size= " + thumbnailList.size());
        UGCThumbnailGenerator.UGCThumbnailGenerateParams uGCThumbnailGenerateParams = new UGCThumbnailGenerator.UGCThumbnailGenerateParams();
        new UGCThumbnailGenerator.UGCThumbnailGenerateParams().thumbnailPtsList = thumbnailList;
        uGCThumbnailGenerateParams.width = width;
        uGCThumbnailGenerateParams.height = height;
        uGCThumbnailGenerateParams.fast = fast;
        UGCThumbnailGenerator uGCThumbnailGenerator = new UGCThumbnailGenerator();
        uGCThumbnailGenerator.initialize();
        uGCThumbnailGenerator.setVideoSourceList(Collections.singletonList(this.mSourcePath));
        uGCThumbnailGenerator.start(uGCThumbnailGenerateParams, bb.a(this, listener, thumbnailList, uGCThumbnailGenerator));
        this.mSequenceTaskRunner.a(bc.a(this, uGCThumbnailGenerator));
    }

    private void handleEncodedCompletedInner() {
        if (this.mIsAudioEnd && this.mIsVideoEnd) {
            LiteavLog.i(TAG, "handleEncodedCompleted");
            this.mAVSyncer.stop();
            this.stopMp4Writer();
        }
    }

    private void handleWriteMP4Completed(int resultCode, long durationMs) {
        this.mSequenceTaskRunner.a(bd.a(this, resultCode, durationMs));
    }

    private void onPlayProgressEnd() {
        LiteavLog.i(TAG, "onProgressEnd mIsPreviewAudioEnd=" + this.mIsAudioEnd + " mIsPreviewVideoEnd=" + this.mIsVideoEnd);
        if (this.mIsAudioEnd && this.mIsVideoEnd) {
            this.mAVSyncer.stop();
            this.notifyPreviewFinished();
        }
    }

    private void startRecord(String outputPath, VideoEncodeParams videoEncodeParams, AudioEncodeParams audioEncodeParams) {
        this.doStopPlayInner();
        this.stopMp4Writer();
        this.startMP4Writer(outputPath);
        this.mIsVideoEncoderStarted = false;
        this.mIsAudioEncoderStarted = false;
        this.mVideoProcessor.setVideoEncodedFrameListener(this.mVideoEncodedFrameListener);
        this.mAudioProcessor.setAudioEncodedFrameListener(this.mAudioEncodedFrameListener);
        this.mAVSyncer.setSyncMode(UGCAVSyncer.SyncMode.INTERLEAVE_OUTPUT_WITHOUT_SKIP);
        this.mAVSyncer.start();
        TXVideoEditer tXVideoEditer = this;
        tXVideoEditer.mIsAudioEnd = false;
        tXVideoEditer.mIsVideoEnd = false;
        this.mMediaListSource.setVideoSourceRange(this.mCutStartTimeMs, this.mCutEndTimeMs);
        this.mVideoProcessor.setOutputSize(videoEncodeParams.width, videoEncodeParams.height, GLConstants.GLScaleType.b);
        this.mVideoProcessor.setEncodeParams(videoEncodeParams);
        this.mVideoProcessor.start(true);
        this.mAudioProcessor.setEncodeParams(audioEncodeParams);
        this.mAudioProcessor.start(true);
    }

    private void onVideoEncodedFrame(EncodedVideoFrame frame) {
        if (frame == null) {
            LiteavLog.w(TAG, "onVideoEncodedFrame frame is null.");
            return;
        }
        this.mSequenceTaskRunner.a(bf.a(this, frame));
    }

    private void onVideoEncodedFrameComplete() {
        this.mSequenceTaskRunner.a(bg.a(this));
    }

    private void onAudioEncodedFrame(AudioFrame frame) {
        if (frame == null) {
            LiteavLog.w(TAG, "onAudioEncodedFrame frame is null.");
            return;
        }
        this.mSequenceTaskRunner.a(bh.a(this, frame));
    }

    private void onAudioEncodedFrameComplete() {
        this.mSequenceTaskRunner.a(bi.a(this));
    }

    private String generateVideoPath() {
        File file = this.mContext.getExternalFilesDir(null);
        if (file == null) {
            LiteavLog.e(TAG, "generateVideoPath getExternalFilesDir return null.");
            return null;
        }
        String string = file + File.separator + "liteav";
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = String.valueOf(System.currentTimeMillis() / 1000L);
        String string3 = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US).format(new Date(Long.parseLong(string2 + "000")));
        return file2 + "/" + String.format("TXVideo_%s_process.mp4", string3);
    }

    private static boolean checkIsVideoType(String videoSourcePath) {
        String string = CommonUtil.getFileExtension(videoSourcePath);
        return !TextUtils.isEmpty((CharSequence)string) && sVideoExtHashSet.contains(string.toLowerCase());
    }

    protected static int isMediaSourceValid(String videoSourcePath) {
        if (TextUtils.isEmpty((CharSequence)videoSourcePath)) {
            LiteavLog.e(TAG, "checkLegality: path is null.");
            return -100001;
        }
        if (!MediaExtractorBuilder.isContentUri(videoSourcePath)) {
            if (!new File(videoSourcePath).exists()) {
                LiteavLog.e(TAG, "checkLegality:source no found!");
                return -100001;
            }
            if (!TXVideoEditer.checkIsVideoType(videoSourcePath)) {
                LiteavLog.e(TAG, "checkLegality:source type error!");
                return -100002;
            }
        }
        return 0;
    }

    private int isBGMValid(String path) {
        FFmpegMediaRetriever fFmpegMediaRetriever = new FFmpegMediaRetriever(false);
        if (fFmpegMediaRetriever.setDataSource(path) != 0 || fFmpegMediaRetriever.getAudioDurationMs() <= 0L) {
            return -1001;
        }
        return 0;
    }

    private boolean isFullIFrame(String videoSourcePath) {
        MediaExtractor mediaExtractor = new MediaExtractorBuilder().setPath(videoSourcePath).setMimeType("video/").build();
        if (mediaExtractor == null) {
            LiteavLog.w("ContentValues", "judgeFullIFrame: extractor is null.");
            return false;
        }
        mediaExtractor.seekTo(0L, 0);
        int n2 = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            if ((mediaExtractor.getSampleFlags() & 1) == 1) {
                ++n2;
            }
            mediaExtractor.advance();
        }
        return n2 > 5;
    }

    private boolean isGopEqualOne(String videoPath) {
        MediaExtractor mediaExtractor = new MediaExtractorBuilder().setPath(videoPath).setMimeType("video/").build();
        if (mediaExtractor == null) {
            LiteavLog.w(TAG, "extractor is null.");
            return false;
        }
        mediaExtractor.seekTo(1L, 1);
        long l2 = mediaExtractor.getSampleTime();
        mediaExtractor.release();
        return l2 > 100000L && l2 < 1100000L;
    }

    private float calculateProgress(long pts) {
        long l2 = this.mMediaListSource.getDuration();
        if (l2 == 0L) {
            l2 = 1L;
        }
        return (float)pts * 1.0f / (float)l2;
    }

    private void notifyPreviewProgress(int curProcessUs) {
        TXVideoPreviewListener tXVideoPreviewListener = this.mVideoPreviewListener;
        if (tXVideoPreviewListener != null) {
            this.mMainHandler.post(bj.a(this, curProcessUs, tXVideoPreviewListener));
        }
    }

    private void notifyPreviewFinished() {
        TXVideoPreviewListener tXVideoPreviewListener = this.mVideoPreviewListener;
        if (tXVideoPreviewListener != null) {
            TXVideoPreviewListener tXVideoPreviewListener2 = tXVideoPreviewListener;
            tXVideoPreviewListener2.getClass();
            this.mMainHandler.post(bk.a(tXVideoPreviewListener2));
        }
    }

    private void notifyProcessComplete(int resultCode, boolean isThumbnailProcessFinish) {
        TXVideoProcessListener tXVideoProcessListener;
        LiteavLog.i(TAG, "notifyProcessComplete: [resultCode, isThumbnailProcessFinish]" + resultCode + " " + isThumbnailProcessFinish);
        if (resultCode == 0) {
            if (isThumbnailProcessFinish) {
                this.mNeedWaitThumbnailProcess = false;
            } else {
                this.mNeedWaitProcessFullI = false;
            }
            if (this.mNeedWaitProcessFullI || this.mNeedWaitThumbnailProcess) {
                return;
            }
        }
        if ((tXVideoProcessListener = this.mVideoProcessListener) != null) {
            this.mMainHandler.post(bl.a(resultCode, tXVideoProcessListener));
        }
    }

    private void notifyGenerateProgress(float progress) {
        TXVideoGenerateListener tXVideoGenerateListener = this.mVideoGenerateListener;
        if (tXVideoGenerateListener != null) {
            this.mMainHandler.post(bm.a(tXVideoGenerateListener, progress));
        }
    }

    private void notifyGenerateComplete(int resultCode, long durationMs) {
        TXVideoGenerateListener tXVideoGenerateListener = this.mVideoGenerateListener;
        if (!TextUtils.isEmpty((CharSequence)this.mProcessOutputPath) && new File(this.mProcessOutputPath).exists()) {
            int n2 = (int)new File(this.mProcessOutputPath).length();
            UGCDataReport.reportDAU(1032, n2, "");
            UGCDataReport.reportDAU(1033, (int)durationMs, "");
        }
        if (tXVideoGenerateListener != null) {
            this.mMainHandler.post(bn.a(resultCode, tXVideoGenerateListener));
        }
    }

    static /* synthetic */ void lambda$notifyGenerateComplete$68(int resultCode, TXVideoGenerateListener listener) {
        TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
        new TXVideoEditConstants.TXGenerateResult().retCode = resultCode;
        tXGenerateResult.descMsg = "";
        listener.onGenerateComplete(tXGenerateResult);
    }

    static /* synthetic */ void lambda$notifyGenerateProgress$67(TXVideoGenerateListener listener, float progress) {
        listener.onGenerateProgress(progress);
    }

    static /* synthetic */ void lambda$notifyProcessComplete$66(int resultCode, TXVideoProcessListener videoProcessListener) {
        TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
        new TXVideoEditConstants.TXGenerateResult().retCode = resultCode;
        tXGenerateResult.descMsg = "";
        videoProcessListener.onProcessComplete(tXGenerateResult);
    }

    static /* synthetic */ void lambda$notifyPreviewProgress$65(TXVideoEditer this_, int curProcessUs, TXVideoPreviewListener listener) {
        if (!this_.filtInvalidatedFrame(curProcessUs / 1000)) {
            listener.onPreviewProgress(curProcessUs);
            this_.mTargetSeekPts.set(null);
        }
    }

    static /* synthetic */ void lambda$onAudioEncodedFrameComplete$64(TXVideoEditer this_) {
        LiteavLog.i(TAG, "onAudioEncodedFrameComplete end flag = " + this_.mIsAudioEnd);
        if (!this_.mIsAudioEnd) {
            this_.mIsAudioEnd = true;
            this_.mAVSyncer.setAudioEos();
            this_.handleEncodedCompletedInner();
        }
    }

    static /* synthetic */ void lambda$onAudioEncodedFrame$63(TXVideoEditer this_, AudioFrame frame) {
        if (this_.mMp4Writer != null && this_.mIsAudioEncoderStarted) {
            this_.mMp4Writer.writeAudioFrame(frame);
        }
    }

    static /* synthetic */ void lambda$onVideoEncodedFrameComplete$62(TXVideoEditer this_) {
        LiteavLog.i(TAG, "onVideoEncodedFrameComplete end flag = " + this_.mIsVideoEnd);
        if (!this_.mIsVideoEnd) {
            this_.mAVSyncer.setVideoEos();
            this_.mIsVideoEnd = true;
            this_.handleEncodedCompletedInner();
        }
    }

    static /* synthetic */ void lambda$onVideoEncodedFrame$61(TXVideoEditer this_, EncodedVideoFrame frame) {
        if (!this_.mIsGenerating || !this_.mIsVideoEncoderStarted) {
            frame.release();
            return;
        }
        if (this_.mMp4Writer != null) {
            this_.mMp4Writer.writeVideoFrame(frame);
        }
        if (this_.mIsProcessToFullKeyFrame) {
            TXVideoProcessListener tXVideoProcessListener = this_.mVideoProcessListener;
            if (tXVideoProcessListener != null) {
                this_.mMainHandler.post(bo.a(this_, tXVideoProcessListener, frame));
            }
            return;
        }
        TXVideoEditer tXVideoEditer = this_;
        tXVideoEditer.notifyGenerateProgress(tXVideoEditer.calculateProgress(frame.pts));
    }

    static /* synthetic */ void lambda$null$60(TXVideoEditer this_, TXVideoProcessListener videoProcessListener, EncodedVideoFrame frame) {
        videoProcessListener.onProcessProgress(this_.calculateProgress(frame.pts));
    }

    static /* synthetic */ void lambda$handleWriteMP4Completed$59(TXVideoEditer this_, int resultCode, long durationMs) {
        LiteavLog.i(TAG, "handleWriteMP4Completed: mIsProcessToFullKeyFrame=" + this_.mIsProcessToFullKeyFrame + ",resultCode=" + resultCode + ",mIsGenerating= " + this_.mIsGenerating);
        if (!this_.mIsGenerating) {
            return;
        }
        this_.mAVSyncer.stop();
        this_.mVideoProcessor.stop();
        this_.mAudioProcessor.stop();
        this_.stopMp4Writer();
        this_.mIsGenerating = false;
        if (this_.mIsProcessToFullKeyFrame) {
            if (com.tencent.liteav.base.util.f.a(this_.mProcessOutputPath) && resultCode == 0) {
                if (this_.mRotation != Rotation.a) {
                    this_.mRotation = Rotation.a;
                    this_.mVideoProcessor.setRenderRotation(this_.mRotation);
                }
                TXVideoEditer tXVideoEditer = this_;
                tXVideoEditer.setMediaSourcePaths(Collections.singletonList(tXVideoEditer.mProcessOutputPath));
            }
            this_.notifyProcessComplete(resultCode, false);
            return;
        }
        this_.notifyGenerateComplete(resultCode, durationMs);
    }

    static /* synthetic */ void lambda$doGetThumbnail$58(TXVideoEditer this_, UGCThumbnailGenerator thumbnailGenerator) {
        this_.mUGCThumbnailGeneratorList.add(thumbnailGenerator);
    }

    static /* synthetic */ void lambda$doGetThumbnail$57(TXVideoEditer this_, TXThumbnailListener listener, List thumbnailList, UGCThumbnailGenerator thumbnailGenerator, int index, long timeMs, Bitmap bitmap) {
        if (listener != null) {
            listener.onThumbnail(index, timeMs, bitmap);
        }
        if (this_.mIsRelease.get()) {
            return;
        }
        if (index == thumbnailList.size()) {
            LiteavLog.i(TAG, "getThumbnail finished!");
            thumbnailGenerator.stop();
            thumbnailGenerator.uninitialize();
            this_.mSequenceTaskRunner.a(bq.a(this_, thumbnailGenerator));
        }
    }

    static /* synthetic */ void lambda$null$56(TXVideoEditer this_, UGCThumbnailGenerator thumbnailGenerator) {
        if (this_.mUGCThumbnailGeneratorList.contains(thumbnailGenerator)) {
            this_.mUGCThumbnailGeneratorList.remove(thumbnailGenerator);
        }
    }

    static /* synthetic */ void lambda$setVideoVolume$55(TXVideoEditer this_, float volume) {
        LiteavLog.i(TAG, "setVideoVolume: volume= ".concat(String.valueOf(volume)));
        this_.mAudioProcessor.setVideoVolume(volume);
    }

    static /* synthetic */ void lambda$refreshOneFrame$54(TXVideoEditer this_) {
        this_.mVideoProcessor.refreshOneFrame();
    }

    static /* synthetic */ void lambda$cancel$53(TXVideoEditer this_) {
        LiteavLog.i(TAG, "cancel");
        this_.mIsGenerating = false;
        this_.mIsVideoEncoderStarted = false;
        this_.mIsAudioEncoderStarted = false;
        this_.mIsProcessToFullKeyFrame = false;
        this_.mThumbnailGenerator.stop();
        this_.mVideoProcessor.setVideoEncodedFrameListener(null);
        this_.mAudioProcessor.setAudioEncodedFrameListener(null);
        this_.mMediaListSource.setVideoSourceRange(0L, Integer.MAX_VALUE);
        this_.mMediaListSource.setTailWaterMarkDurationSecond(0);
        if (!this_.mIsPlaying) {
            this_.mAudioProcessor.stop();
            this_.mVideoProcessor.stop();
        }
        if (this_.mMp4Writer != null) {
            this_.mMp4Writer.setListener(null);
        }
        this_.stopMp4Writer();
    }

    static /* synthetic */ void lambda$generateVideo$52(TXVideoEditer this_, int videoCompressed, String videoOutputPath) {
        LiteavLog.i(TAG, "generateVideo: videoCompressed= " + videoCompressed + ", videoOutputPath= " + videoOutputPath);
        if (!UGCLicenseChecker.isSimpleFunctionSupport()) {
            TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
            new TXVideoEditConstants.TXGenerateResult().retCode = -5;
            tXGenerateResult.descMsg = "licence verify failed";
            if (this_.mVideoGenerateListener != null) {
                this_.mVideoGenerateListener.onGenerateComplete(tXGenerateResult);
            }
            return;
        }
        UGCTranscodeVideoEncodeParamsDecider uGCTranscodeVideoEncodeParamsDecider = new UGCTranscodeVideoEncodeParamsDecider();
        uGCTranscodeVideoEncodeParamsDecider.setSourceType(UGCConstants.SourceType.VIDEO);
        uGCTranscodeVideoEncodeParamsDecider.setFullIFrame(this_.mIsFullIFrame);
        uGCTranscodeVideoEncodeParamsDecider.setOutputResolution(videoCompressed);
        uGCTranscodeVideoEncodeParamsDecider.setEncodeProfile(this_.mEncodeProfile);
        uGCTranscodeVideoEncodeParamsDecider.setInputVideoMediaFormat(this_.mVideoFormatList);
        UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = new UGCTranscodeAudioEncodeParamsDecider();
        uGCTranscodeAudioEncodeParamsDecider.setInputAudioMediaFormat(this_.mAudioFormatList);
        uGCTranscodeAudioEncodeParamsDecider.setBGMMediaFormat(this_.mBGMFormat);
        if (TextUtils.isEmpty((CharSequence)this_.mSourcePath)) {
            uGCTranscodeVideoEncodeParamsDecider.setSourceType(UGCConstants.SourceType.PICTURE);
        }
        if (this_.mVideoEncodeBitrate != -1) {
            uGCTranscodeVideoEncodeParamsDecider.setEncodeBitrate(this_.mVideoEncodeBitrate);
        }
        if (this_.mAudioEncodeBitrate != -1) {
            uGCTranscodeAudioEncodeParamsDecider.setEncodeBitrate(this_.mAudioEncodeBitrate);
        }
        if (this_.mEncodeResolution != null) {
            uGCTranscodeVideoEncodeParamsDecider.setEncodeOutputSize(this_.mEncodeResolution);
        }
        VideoEncodeParams videoEncodeParams = uGCTranscodeVideoEncodeParamsDecider.getDecidedEncodeParams();
        AudioEncodeParams audioEncodeParams = uGCTranscodeAudioEncodeParamsDecider.getDecidedEncodeParams();
        this_.mIsProcessToFullKeyFrame = false;
        this_.mIsGenerating = true;
        this_.startRecord(videoOutputPath, videoEncodeParams, audioEncodeParams);
    }

    static /* synthetic */ void lambda$setAudioBitrate$51(TXVideoEditer this_, int audioBitrate) {
        LiteavLog.i(TAG, "setAudioBitrate: bitrate= ".concat(String.valueOf(audioBitrate)));
        this_.mAudioEncodeBitrate = audioBitrate;
    }

    static /* synthetic */ void lambda$setVideoBitrate$50(TXVideoEditer this_, int videoBitrate) {
        LiteavLog.i(TAG, "setVideoBitrate: bitrate= ".concat(String.valueOf(videoBitrate)));
        this_.mVideoEncodeBitrate = videoBitrate;
    }

    static /* synthetic */ void lambda$setCutFromTime$49(TXVideoEditer this_, long startTime, long endTime) {
        LiteavLog.i(TAG, "setCutFromTime: startTime= " + startTime + ",endTime= " + endTime);
        this_.mCutStartTimeMs = startTime;
        this_.mCutEndTimeMs = endTime;
    }

    static /* synthetic */ void lambda$setVideoGenerateListener$48(TXVideoEditer this_, TXVideoGenerateListener listener) {
        LiteavLog.i(TAG, "setVideoGenerateListener: listener= ".concat(String.valueOf(listener)));
        this_.mVideoGenerateListener = listener;
    }

    static /* synthetic */ void lambda$previewAtTime$47(TXVideoEditer this_) {
        Long l2 = this_.mPendingPreviewAtTime.getAndSet(null);
        if (l2 == null) {
            return;
        }
        LiteavLog.i(TAG, "previewAtTime time = ".concat(String.valueOf(l2)));
        this_.mMediaListSource.seekTo(l2);
        this_.mVideoProcessor.seekTo(l2);
        this_.mSequenceTaskRunner.c(this_.mRunnableVideoProcessOnComplete);
        this_.mAVSyncer.resetClock();
    }

    static /* synthetic */ void lambda$stopPlay$46(TXVideoEditer this_) {
        LiteavLog.i(TAG, "stopPlay");
        this_.doStopPlayInner();
    }

    static /* synthetic */ void lambda$resumePlay$45(TXVideoEditer this_) {
        LiteavLog.i(TAG, "resumePlay " + this_.mIsGenerating);
        if (this_.mIsGenerating) {
            return;
        }
        this_.mAVSyncer.start();
        this_.mVideoProcessor.start(false);
        this_.mAudioProcessor.start(false);
    }

    static /* synthetic */ void lambda$pausePlay$44(TXVideoEditer this_) {
        LiteavLog.i(TAG, "pausePlay " + this_.mIsGenerating);
        if (this_.mIsGenerating) {
            return;
        }
        this_.mAVSyncer.stop();
        this_.mVideoProcessor.stop();
        this_.mAudioProcessor.stop();
    }

    static /* synthetic */ void lambda$startPlayFromTime$43(TXVideoEditer this_, long startTime, long endTime) {
        LiteavLog.i(TAG, "startPlayFromTime: startTime= " + startTime + ", endTime= " + endTime);
        this_.doStopPlayInner();
        if (this_.mEncodeResolution == null) {
            this_.mVideoProcessor.setOutputSize(-1, -1, GLConstants.GLScaleType.b);
        } else {
            this_.mVideoProcessor.setOutputSize(this_.mEncodeResolution.width, this_.mEncodeResolution.height, GLConstants.GLScaleType.b);
        }
        TXVideoEditer tXVideoEditer = this_;
        tXVideoEditer.mIsAudioEnd = false;
        tXVideoEditer.mIsVideoEnd = false;
        this_.mAVSyncer.setSyncMode(this_.mPreviewSyncMode);
        this_.mAVSyncer.start();
        if (this_.mSourceRangeStartTimeMs != 0L || endTime != this_.mSourceRangeEndTimeMs && endTime >= 0L || this_.mIsReverse) {
            this_.mSourceRangeStartTimeMs = 0L;
            this_.mSourceRangeEndTimeMs = endTime;
            if (this_.mIsReverse) {
                this_.mSourceRangeStartTimeMs = startTime;
            }
        }
        if (!this_.mIsReverse) {
            this_.mMediaListSource.seekTo(startTime);
            this_.mMediaListSource.setPlayEndTime(endTime);
        } else {
            this_.mMediaListSource.seekTo(endTime);
            this_.mMediaListSource.setPlayEndTime(Long.MAX_VALUE);
        }
        this_.mVideoProcessor.setProgressListener(this_.mVideoProcessProgressListener);
        this_.mVideoProcessor.start(false);
        this_.mAudioProcessor.start(false);
        this_.mIsProcessToFullKeyFrame = false;
        this_.mIsGenerating = false;
        this_.mIsPlaying = true;
        this_.mTargetSeekPts.set(null);
    }

    static /* synthetic */ void lambda$initWithPreview$42(TXVideoEditer this_, TXVideoEditConstants.TXPreviewParam param) {
        if (this_.mFrameLayout != null) {
            this_.mFrameLayout.removeAllViews();
        }
        TextureView textureView = new TextureView(this_.mContext);
        this_.mFrameLayout = param.videoView;
        if (this_.mFrameLayout != null) {
            this_.mFrameLayout.addView((View)textureView);
        }
        DisplayTarget displayTarget = new DisplayTarget(textureView);
        GLConstants.GLScaleType gLScaleType = GLConstants.GLScaleType.a;
        if (param.renderMode == 2) {
            gLScaleType = GLConstants.GLScaleType.b;
        }
        this_.mVideoProcessor.setDisplayView(displayTarget, gLScaleType);
    }

    static /* synthetic */ void lambda$setTXVideoPreviewListener$41(TXVideoEditer this_, TXVideoPreviewListener listener) {
        LiteavLog.i(TAG, "setTXVideoPreviewListener: listener= ".concat(String.valueOf(listener)));
        this_.mVideoPreviewListener = listener;
    }

    static /* synthetic */ void lambda$release$40(TXVideoEditer this_) {
        LiteavLog.i(TAG, "release");
        this_.mIsRelease.set(true);
        this_.clearThumbnailGenerator();
        this_.mVideoProcessor.unInitialize();
        this_.mAudioProcessor.unInitialize();
        this_.mAudioProcessor.destroy();
        this_.mMediaListSource.uninitialize();
        this_.mThumbnailGenerator.uninitialize();
        this_.stopMp4Writer();
        UGCInitializer.uninitialize();
    }

    static /* synthetic */ void lambda$processVideoInternal$39(TXVideoProcessListener videoProcessListener) {
        TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
        new TXVideoEditConstants.TXGenerateResult().retCode = -5;
        tXGenerateResult.descMsg = "licence verify failed";
        if (videoProcessListener != null) {
            videoProcessListener.onProcessComplete(tXGenerateResult);
        }
    }

    static /* synthetic */ void lambda$setThumbnailListener$38(TXVideoEditer this_, TXThumbnailListener listener) {
        LiteavLog.i(TAG, "setThumbnailListener: listener= ".concat(String.valueOf(listener)));
        this_.mProcessThumbnailListener = listener;
    }

    static /* synthetic */ void lambda$setThumbnail$37(TXVideoEditer this_, TXVideoEditConstants.TXThumbnail thumbnail) {
        LiteavLog.i(TAG, "setThumbnail: thumbnail.count= " + thumbnail.count + " ,thumbnail.width= " + thumbnail.width + " ,thumbnail.height= " + thumbnail.height);
        this_.mProcessThumbnailInfo = new UGCThumbnailGenerator.UGCThumbnailGenerateParams();
        this_.mProcessThumbnailInfo.thumbnailCount = thumbnail.count;
        this_.mProcessThumbnailInfo.width = thumbnail.width;
        this_.mProcessThumbnailInfo.height = thumbnail.height;
        this_.mProcessThumbnailInfo.fast = false;
    }

    static /* synthetic */ void lambda$getThumbnail$36(TXVideoEditer this_, int width, int height, boolean fast, int count, TXThumbnailListener listener) {
        LiteavLog.i(TAG, "getThumbnail: width= " + width + " height= " + height + ",fast= " + fast + ",count= " + count);
        FFmpegMediaRetriever fFmpegMediaRetriever = new FFmpegMediaRetriever();
        fFmpegMediaRetriever.setDataSource(this_.mSourcePath);
        List<Long> list = UGCThumbnailGenerator.calculateThumbnailList(count, 0L, fFmpegMediaRetriever.getVideoDurationMs(), fFmpegMediaRetriever.getVideoDurationMs());
        if (list != null) {
            this_.doGetThumbnail(list, width, height, fast, listener);
        }
    }

    static /* synthetic */ void lambda$getThumbnail$35(TXVideoEditer this_, List thumbnailList, int width, int height, boolean fast, TXThumbnailListener listener) {
        this_.doGetThumbnail(thumbnailList, width, height, fast, listener);
    }

    static /* synthetic */ void lambda$setVideoProcessListener$34(TXVideoEditer this_, TXVideoProcessListener listener) {
        LiteavLog.i(TAG, "setVideoProcessListener: listener= ".concat(String.valueOf(listener)));
        this_.mVideoProcessListener = listener;
    }

    static /* synthetic */ void lambda$deleteAllEffect$33(TXVideoEditer this_) {
        LiteavLog.i(TAG, "deleteAllEffect");
        this_.mVideoProcessor.getEffectProcessor().deleteAllEffect();
    }

    static /* synthetic */ void lambda$deleteLastEffect$32(TXVideoEditer this_) {
        LiteavLog.i(TAG, "deleteLastEffect");
        this_.mVideoProcessor.getEffectProcessor().deleteLastEffect();
    }

    static /* synthetic */ void lambda$stopEffect$31(TXVideoEditer this_, int type, long endTime) {
        LiteavLog.i(TAG, "stopEffect");
        this_.mVideoProcessor.getEffectProcessor().stopEffect(type, endTime);
    }

    static /* synthetic */ void lambda$startEffect$30(TXVideoEditer this_, int type, long startTime) {
        LiteavLog.i(TAG, "startEffect: type=" + type + ",startTime= " + startTime);
        this_.mVideoProcessor.getEffectProcessor().startEffect(type, startTime);
    }

    static /* synthetic */ void lambda$deleteLastTransitionEffect$29(TXVideoEditer this_) {
        LiteavLog.i(TAG, "deleteLastTransitionEffect");
        this_.mVideoProcessor.getTransitionProcessor().deleteLastTransitionEffect();
    }

    static /* synthetic */ void lambda$setTransitionEffect$28(TXVideoEditer this_, int type, long startTimeMs, long transitionDurationMs, AtomicBoolean isSuccess) {
        LiteavLog.i(TAG, "setTransitionEffect: type=" + type + " ,startTimeMs= " + startTimeMs + " ,transitionDurationMs= " + transitionDurationMs);
        boolean bl2 = this_.mVideoProcessor.getTransitionProcessor().setTransitionEffect(type, this_.mMediaListSource.getDuration(), startTimeMs, transitionDurationMs);
        isSuccess.set(bl2);
    }

    static /* synthetic */ void lambda$setReverse$27(TXVideoEditer this_, boolean isReverse) {
        LiteavLog.i(TAG, "setReverse: isReverse= ".concat(String.valueOf(isReverse)));
        this_.mIsReverse = isReverse;
        this_.mMediaListSource.setReverse(isReverse);
        this_.mVideoProcessor.setReverse(isReverse);
        this_.mVideoProcessor.getEffectProcessor().setReverse(isReverse, this_.mMediaListSource.getDuration());
        this_.mVideoProcessor.getTransitionProcessor().setReverse(isReverse, this_.mMediaListSource.getDuration());
        this_.mVideoProcessor.getWatermarkProcessor().setReverse(isReverse, this_.mMediaListSource.getDuration());
        this_.doStopPlayInner();
    }

    static /* synthetic */ void lambda$setRepeatPlay$26(TXVideoEditer this_, List repeatList) {
        LiteavLog.i(TAG, "setRepeatPlay");
        this_.mMediaListSource.setRepeatPlay(repeatList);
    }

    static /* synthetic */ void lambda$setSpeedList$25(TXVideoEditer this_, List speedList) {
        if (speedList != null) {
            for (TXVideoEditConstants.TXSpeed tXSpeed : speedList) {
                LiteavLog.i(TAG, "setSpeedList " + tXSpeed.startTime + " " + tXSpeed.endTime + " speed: " + tXSpeed.speedLevel);
            }
        }
        this_.mVideoProcessor.setSpeedList(speedList);
        this_.mAudioProcessor.setSpeedList(speedList);
        this_.mMediaListSource.setSpeedList(speedList);
    }

    static /* synthetic */ void lambda$setRenderRotation$24(TXVideoEditer this_, int rotation) {
        LiteavLog.i(TAG, "setRenderRotation: rotation= ".concat(String.valueOf(rotation)));
        this_.mRotation = Rotation.a(rotation);
        this_.mVideoProcessor.setRenderRotation(this_.mRotation);
    }

    static /* synthetic */ void lambda$setPasterList$23(TXVideoEditer this_, List pasterList) {
        LiteavLog.i(TAG, "setPasterList");
        this_.mVideoProcessor.getWatermarkProcessor().setPasterList(pasterList);
    }

    static /* synthetic */ void lambda$setAnimatedPasterList$22(TXVideoEditer this_, List animatedPasterList) {
        LiteavLog.i(TAG, "setAnimatedPasterList");
        this_.mVideoProcessor.getWatermarkProcessor().setAnimatedPasterList(animatedPasterList);
    }

    static /* synthetic */ void lambda$setSubtitleList$21(TXVideoEditer this_, List subtitleList) {
        LiteavLog.i(TAG, "setSubtitleList");
        this_.mVideoProcessor.getWatermarkProcessor().setSubtitleList(subtitleList);
    }

    static /* synthetic */ void lambda$setTailWaterMark$20(TXVideoEditer this_, int duration, Bitmap tailWatermark, TXVideoEditConstants.TXRect rect) {
        LiteavLog.i(TAG, "setTailWaterMark: duration= ".concat(String.valueOf(duration)));
        this_.mVideoProcessor.getWatermarkProcessor().setTailWaterMark(tailWatermark, rect, this_.mMediaListSource.getDuration(), duration);
        this_.mMediaListSource.setTailWaterMarkDurationSecond(duration);
    }

    static /* synthetic */ void lambda$setWaterMark$19(TXVideoEditer this_, TXVideoEditConstants.TXRect rect, Bitmap watermark) {
        LiteavLog.i(TAG, "setWaterMark: " + rect.toString());
        this_.mVideoProcessor.getWatermarkProcessor().setWaterMark(watermark, rect);
    }

    static /* synthetic */ void lambda$setBGMFadeInOutDuration$18(TXVideoEditer this_, long fadeInDuration, long fadeOutDuration) {
        LiteavLog.i(TAG, "setBGMFadeInOutDuration: fadeInDuration= " + fadeInDuration + ",fadeOutDuration= " + fadeOutDuration);
        this_.mAudioProcessor.setFadeInOutDuration(fadeInDuration, fadeOutDuration);
    }

    static /* synthetic */ void lambda$setBGMVolume$17(TXVideoEditer this_, float volume) {
        LiteavLog.i(TAG, "setBGMVolume: ".concat(String.valueOf(volume)));
        this_.mAudioProcessor.setBGMVolume(volume);
    }

    static /* synthetic */ void lambda$setBGMStartTime$16(TXVideoEditer this_, long startTime, long endTime) {
        LiteavLog.i(TAG, "setBGMStartTime: startTime= " + startTime + ", endTime= " + endTime);
        this_.mAudioProcessor.setBGMStartTime(startTime, endTime);
    }

    static /* synthetic */ void lambda$setBGMAtVideoTime$15(TXVideoEditer this_, long videoStartTime) {
        LiteavLog.i(TAG, "setBGMAtVideoTime: videoStartTime= ".concat(String.valueOf(videoStartTime)));
        this_.mAudioProcessor.setBGMAtVideoTime(videoStartTime);
    }

    static /* synthetic */ void lambda$setBGMLoop$14(TXVideoEditer this_, boolean looping) {
        LiteavLog.i(TAG, "setBGMLoop: looping= ".concat(String.valueOf(looping)));
        this_.mAudioProcessor.setBGMLoop(looping);
    }

    static /* synthetic */ void lambda$setBGM$13(TXVideoEditer this_, String path, boolean finalIsClearBGM) {
        this_.mAudioProcessor.setBGM(path);
        this_.doStopPlayInner();
        if (finalIsClearBGM) {
            this_.mBGMFormat = null;
            this_.mHasBGM = false;
            if (com.tencent.liteav.videobase.utils.c.a(this_.mAudioFormatList)) {
                this_.mAVSyncer.setAudioExist(false);
                this_.mPreviewSyncMode = UGCAVSyncer.SyncMode.VIDEO_MASTER;
                this_.mAVSyncer.setSyncMode(UGCAVSyncer.SyncMode.VIDEO_MASTER);
            }
            return;
        }
        this_.mHasBGM = true;
        MediaExtractor mediaExtractor = new MediaExtractorBuilder().setPath(path).setMimeType("audio/").build();
        if (mediaExtractor == null) {
            LiteavLog.w(TAG, "setBGM: build extractor fail.");
            return;
        }
        int n2 = mediaExtractor.getSampleTrackIndex();
        this_.mBGMFormat = mediaExtractor.getTrackFormat(n2);
        this_.mAVSyncer.setAudioExist(true);
        this_.mPreviewSyncMode = UGCAVSyncer.SyncMode.AUDIO_MASTER;
        this_.mAVSyncer.setSyncMode(UGCAVSyncer.SyncMode.AUDIO_MASTER);
    }

    static /* synthetic */ void lambda$setPictureTransition$12(TXVideoEditer this_, int type) {
        LiteavLog.i(TAG, "setPictureTransition: ".concat(String.valueOf(type)));
        this_.mMediaListSource.setPictureTransition(type);
        this_.mVideoProcessor.setPictureTransition(type);
    }

    static /* synthetic */ void lambda$setPictureList$11(TXVideoEditer this_, int fps, List bitmapList) {
        LiteavLog.i(TAG, "setPictureList: fps= " + fps + ",bitmapList.size= " + bitmapList.size());
        this_.mMediaListSource.setPictureList(bitmapList, fps);
        this_.setOutputSize(new Size(720, 1280));
    }

    static /* synthetic */ void lambda$setBeautyFilter$10(TXVideoEditer this_, int beautyLevel, int whiteningLevel) {
        LiteavLog.i(TAG, "setBeautyFilter: beautyLevel= " + beautyLevel + ",whiteningLevel= " + whiteningLevel);
        this_.mVideoProcessor.setBeautyFilter(beautyLevel, whiteningLevel);
    }

    static /* synthetic */ void lambda$setFilter$9(TXVideoEditer this_, float leftIntensity, float rightIntensity, float leftRatio, Bitmap leftBitmap, Bitmap rightBitmap) {
        LiteavLog.i(TAG, "setFilter: leftIntensity= " + leftIntensity + ",rightIntensity= " + rightIntensity + ",leftRatio= " + leftRatio);
        this_.mVideoProcessor.setFilter(leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio);
    }

    static /* synthetic */ void lambda$setFilter$8(TXVideoEditer this_, Bitmap bmp) {
        LiteavLog.i(TAG, "setFilter: ".concat(String.valueOf(bmp)));
        float f2 = 0.5f;
        float f3 = 0.0f;
        if (this_.mCombineFilterInfo != null) {
            f2 = this_.mCombineFilterInfo.getLeftSpecialRatio();
            f3 = this_.mCombineFilterInfo.getRightSpecialRatio();
        }
        this_.setFilter(bmp, f2, null, f3, 1.0f);
    }

    static /* synthetic */ void lambda$setSpecialRatio$7(TXVideoEditer this_, float specialRatio) {
        LiteavLog.i(TAG, "setSpecialRatio: ".concat(String.valueOf(specialRatio)));
        if (this_.mCombineFilterInfo == null) {
            this_.mCombineFilterInfo = new CombineFilterInfo();
        }
        this_.mCombineFilterInfo.setLeftSpecialRatio(specialRatio);
        this_.mCombineFilterInfo.setRightSpecialRatio(0.0f);
        this_.mVideoProcessor.setSpecialRatio(specialRatio);
    }

    static /* synthetic */ void lambda$setProfile$6(TXVideoEditer this_, int profile) {
        LiteavLog.i(TAG, "setProfile: ".concat(String.valueOf(profile)));
        this_.mEncodeProfile = profile;
    }

    static /* synthetic */ void lambda$setCustomVideoProcessListener$5(TXVideoEditer this_, TXVideoCustomProcessListener listener) {
        LiteavLog.i(TAG, "setCustomVideoProcessListener: ".concat(String.valueOf(listener)));
        this_.mVideoProcessor.setCustomVideoProcessListener(listener);
    }

    static /* synthetic */ void lambda$setVideoPath$4(TXVideoEditer this_, String videoSource) {
        this_.setMediaSourcePaths(Collections.singletonList(videoSource));
    }

    static /* synthetic */ void lambda$new$3(TXVideoEditer this_, int index, long timeMs, Bitmap bitmap) {
        if (this_.mProcessThumbnailListener != null) {
            this_.mProcessThumbnailListener.onThumbnail(index, timeMs, bitmap);
        }
        int n2 = this_.getThumbnailCount();
        TXVideoProcessListener tXVideoProcessListener = this_.mVideoProcessListener;
        if (tXVideoProcessListener != null) {
            this_.mMainHandler.post(br.a(this_, n2, timeMs, index, tXVideoProcessListener));
        }
        if (n2 == index) {
            LiteavLog.i(TAG, "mInnerThumbnailListener: notifyProcessComplete");
            this_.mProcessOutputPath = this_.mSourcePath;
            this_.notifyProcessComplete(0, true);
        }
    }

    static /* synthetic */ void lambda$null$2(TXVideoEditer this_, int thumbnailCount, long timeMs, int index, TXVideoProcessListener videoProcessListener) {
        float f2 = thumbnailCount == 0 ? this_.calculateProgress(timeMs) : (float)index * 1.0f / (float)thumbnailCount;
        videoProcessListener.onProcessProgress(f2);
    }

    static /* synthetic */ void lambda$new$1(TXVideoEditer this_, int index, long timeMs, Bitmap bitmap) {
        if (this_.mProcessThumbnailListener != null) {
            this_.mProcessThumbnailListener.onThumbnail(index, timeMs, bitmap);
        }
        if (this_.getThumbnailCount() == index) {
            LiteavLog.i(TAG, "mInnerThumbnailListener: notifyProcessComplete");
            this_.notifyProcessComplete(0, true);
        }
    }

    static /* synthetic */ void lambda$new$0(TXVideoEditer this_) {
        if (!this_.mIsVideoEnd) {
            this_.mIsVideoEnd = true;
            this_.mIsAudioEnd = true;
            this_.mAVSyncer.setVideoEos();
            this_.mAVSyncer.setAudioEos();
            this_.onPlayProgressEnd();
        }
    }

    static /* synthetic */ void access$lambda$0(TXVideoEditer tXVideoEditer) {
        tXVideoEditer.processVideoInternal();
    }

    public static interface TXThumbnailListener {
        public void onThumbnail(int var1, long var2, Bitmap var4);
    }

    public static interface TXPCMCallbackListener {
        public TXAudioFrame onPCMCallback(TXAudioFrame var1);
    }

    public static interface TXVideoCustomProcessListener {
        public int onTextureCustomProcess(int var1, int var2, int var3, long var4);

        public void onTextureDestroyed();
    }

    public static interface TXVideoProcessListener {
        public void onProcessProgress(float var1);

        public void onProcessComplete(TXVideoEditConstants.TXGenerateResult var1);
    }

    public static interface TXVideoPreviewListenerEx
    extends TXVideoPreviewListener {
        public void onPreviewError(TXVideoEditConstants.TXPreviewError var1);
    }

    public static interface TXVideoPreviewListener {
        public void onPreviewProgress(int var1);

        public void onPreviewFinished();
    }

    public static interface TXVideoGenerateListener {
        public void onGenerateProgress(float var1);

        public void onGenerateComplete(TXVideoEditConstants.TXGenerateResult var1);
    }
}

