/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.f;
import com.tencent.liteav.videoconsumer.decoder.VideoDecodeController;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.ag;
import com.tencent.liteav.videoconsumer.decoder.ay;
import com.tencent.liteav.videoconsumer.decoder.bc;
import com.tencent.liteav.videoproducer.capture.ax;
import com.tencent.ugc.Clip;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.UGCPixelFrameProvider;
import com.tencent.ugc.VideoDemuxer;
import com.tencent.ugc.VideoDemuxerFFmpeg;
import com.tencent.ugc.VideoDemuxerSystem;
import com.tencent.ugc.fc;
import com.tencent.ugc.fd;
import com.tencent.ugc.fe;
import com.tencent.ugc.ff;
import com.tencent.ugc.fg;
import com.tencent.ugc.fh;
import com.tencent.ugc.fi;
import com.tencent.ugc.fj;
import com.tencent.ugc.fk;
import com.tencent.ugc.fl;
import com.tencent.ugc.fm;
import com.tencent.ugc.fn;
import com.tencent.ugc.fo;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UGCSingleFilePixelFrameProvider
implements UGCFrameQueue.UGCFrameQueueListener,
UGCPixelFrameProvider {
    private static final String TAG = "UGCVideoFileProvider";
    private static final int MAX_FRAME_SIZE = 3;
    private static final int REVERSE_STEP_TIME = 500;
    private final CustomHandler mWorkHandler;
    private final Clip mClip;
    private final UGCFrameQueue<List<PixelFrame>> mPixFrameQueue;
    private final Deque<PixelFrame> mPixFrameCacheForReverse;
    private final b mThrottlers = new b();
    private VideoDecodeController mVideoDecodeController;
    private VideoDemuxer mDemuxer;
    private boolean mIsAbandoningDecodingFrame = false;
    private long mSeekingTimeMs = -1L;
    private boolean mIsInPreciseSeeking = true;
    private boolean mHasReadEOF = false;
    private boolean mIsDecodeCompleted = false;
    private boolean mIsFrameSendingDecoder = false;
    private boolean mIsReverse = false;
    private long mReversePlayCurrentPts;
    private int mFrameCacheCapacityForReverse = 0;
    private EGLCore mEGLCore;
    private j mPixelFrameRenderer;
    private e mGLTexturePool;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private Rotation mVideoRotation = Rotation.a;
    private long mPlayEndPts = Long.MAX_VALUE;
    private final bc mVideoDecoderListener = new bc(){

        @Override
        public final void a(PixelFrame pixelFrame, long l2) {
            if (pixelFrame == null) {
                return;
            }
            pixelFrame.retain();
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(fk.a(this, pixelFrame));
        }

        @Override
        public final void o() {
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(fl.a(this));
        }

        @Override
        public final void p() {
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(fm.a(this));
        }

        @Override
        public final void n() {
            LiteavLog.i(UGCSingleFilePixelFrameProvider.TAG, "onAbandonDecodingFramesCompleted");
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(fn.a(this));
        }

        @Override
        public final void m() {
            LiteavLog.i(UGCSingleFilePixelFrameProvider.TAG, "on decode fail");
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(fo.a(this));
        }
    };

    public UGCSingleFilePixelFrameProvider(@NonNull Clip clip, @NonNull CustomHandler handler) {
        this.mClip = new Clip(clip);
        this.mPixFrameQueue = new UGCFrameQueue();
        this.mPixFrameCacheForReverse = new LinkedList<PixelFrame>();
        this.mWorkHandler = handler;
    }

    @Override
    public void initialize() {
        LiteavLog.i(TAG, "initialize");
    }

    @Override
    public void uninitialize() {
        LiteavLog.i(TAG, "unInitialize");
        this.mWorkHandler.runOrPost(fc.a(this));
    }

    @Override
    public void start() {
        this.mWorkHandler.runOrPost(fd.a(this));
    }

    @Override
    public void stop() {
        this.mWorkHandler.runOrPost(fe.a(this));
    }

    @Override
    public void seekTo(long lineTime, boolean isPreciseSeek) {
        LiteavLog.i(TAG, "seekTo lineTime = " + lineTime + " isPreciseSeek = " + isPreciseSeek);
        this.mWorkHandler.runAndWaitDone(ff.a(this, lineTime, isPreciseSeek), 1000L);
    }

    @Override
    public UGCFrameQueue<List<PixelFrame>> getFrameQueue() {
        return this.mPixFrameQueue;
    }

    @Override
    public void setReverse(boolean isReverse) {
        LiteavLog.i(TAG, "isReverse = ".concat(String.valueOf(isReverse)));
        this.mWorkHandler.runOrPost(fg.a(this, isReverse));
    }

    @Override
    public void onFrameDequeued() {
        this.mWorkHandler.runOrPost(fh.a(this));
    }

    private void uninitializeInternal() {
        this.unInitializeGLComponents();
        if (this.mVideoDecodeController != null) {
            this.mVideoDecodeController.h();
            this.mVideoDecodeController.j();
            this.mVideoDecodeController = null;
        }
        this.clearPixelFrameQueue();
        PixelFrame.releasePixelFrames(this.mPixFrameCacheForReverse);
    }

    private boolean createDemuxerAndOpenFile() {
        this.mDemuxer = this.mClip.videoMimeType == null || "video/hevc".equals(this.mClip.videoMimeType) || "video/avc".equals(this.mClip.videoMimeType) ? new VideoDemuxerFFmpeg() : new VideoDemuxerSystem();
        if (!this.mDemuxer.open(this.mClip.path)) {
            this.mDemuxer.close();
            this.mDemuxer = null;
            return false;
        }
        return true;
    }

    private void startInternal() {
        if (!this.createDemuxerAndOpenFile()) {
            LiteavLog.e(TAG, this.mClip.path + " open fail or there is not video stream");
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        LiteavLog.i(TAG, this.mClip.path + " open success");
        this.mPixFrameQueue.setUGCFrameQueueListener(this);
        this.mPixFrameQueue.clear();
        if (this.mIsReverse) {
            this.mReversePlayCurrentPts = this.mClip.endInFileTime;
            this.mDemuxer.seek(this.mReversePlayCurrentPts - 500L);
        } else if (this.mClip.startInFileTime != 0L) {
            this.mDemuxer.seek(this.mClip.startInFileTime);
        }
        this.initializeDecodeController();
        this.initializeGLComponents();
        this.mVideoDecodeController.a(this.mVideoDecoderListener);
        this.decodeInternal();
    }

    private void stopInternal() {
        this.mPixFrameQueue.setUGCFrameQueueListener(null);
        if (this.mDemuxer != null) {
            this.mDemuxer.close();
            this.mDemuxer = null;
        }
        if (this.mVideoDecodeController != null) {
            this.mVideoDecodeController.h();
        }
        this.clearPixelFrameQueue();
        PixelFrame.releasePixelFrames(this.mPixFrameCacheForReverse);
        this.mPixFrameQueue.queue(END_OF_STREAM);
        this.mIsAbandoningDecodingFrame = false;
        this.mIsInPreciseSeeking = true;
        this.mIsReverse = false;
        this.mIsFrameSendingDecoder = false;
        this.mSeekingTimeMs = -1L;
        this.mReversePlayCurrentPts = this.mClip.startInFileTime;
    }

    private void setReverseInternal(boolean isReverse) {
        if (this.mIsReverse == isReverse) {
            return;
        }
        this.mIsReverse = isReverse;
        if (this.mIsReverse) {
            this.mReversePlayCurrentPts = this.mClip.endInFileTime;
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
            uGCSingleFilePixelFrameProvider.seekToInFileTime(uGCSingleFilePixelFrameProvider.mClip.endInFileTime - 500L, false);
        } else {
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
            uGCSingleFilePixelFrameProvider.seekToInFileTime(uGCSingleFilePixelFrameProvider.mClip.startInFileTime, true);
        }
        this.clearPixelFrameQueue();
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
        this.mPlayEndPts = playEndPts;
    }

    private void decodeInternal() {
        if (this.mVideoDecodeController == null || !this.isNeedDecode()) {
            this.mIsFrameSendingDecoder = false;
            return;
        }
        EncodedVideoFrame encodedVideoFrame = this.mDemuxer.getNextEncodeVideoFrame();
        if (encodedVideoFrame == null) {
            return;
        }
        if (encodedVideoFrame == VideoDemuxerFFmpeg.END_OF_STREAM) {
            LiteavLog.i(TAG, "demuxer read completed");
            this.mHasReadEOF = true;
            VideoDecodeController videoDecodeController = this.mVideoDecodeController;
            videoDecodeController.a(ay.a(videoDecodeController));
            this.mWorkHandler.removeCallbacks(fi.a(this));
            this.mWorkHandler.runOrPost(fj.a(this), 1000);
            return;
        }
        this.mIsFrameSendingDecoder = true;
        this.mIsDecodeCompleted = false;
        this.mVideoRotation = Rotation.a(encodedVideoFrame.rotation);
        this.mVideoDecodeController.a(encodedVideoFrame);
    }

    private boolean isNeedDecode() {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = this.mVideoDecodeController != null && this.mDemuxer != null && !this.mIsAbandoningDecodingFrame && !this.mHasReadEOF;
        if (this.mIsReverse) {
            bl2 = this.mPixFrameQueue.size() >= 3 && this.mPixFrameQueue.size() + this.mPixFrameCacheForReverse.size() >= this.mFrameCacheCapacityForReverse + 3;
        } else {
            boolean bl5 = bl2 = this.mPixFrameQueue.size() >= 3;
        }
        return bl3 && !bl2;
    }

    private void seekToInFileTime(long fileTime, boolean isPreciseSeek) {
        if (this.mDemuxer == null) {
            return;
        }
        long l2 = h.a(fileTime, this.mClip.startInFileTime, this.mClip.endInFileTime);
        if (this.mSeekingTimeMs == l2 && this.mIsInPreciseSeeking == isPreciseSeek) {
            return;
        }
        LiteavLog.i(TAG, "seekToInFileTime file time = ".concat(String.valueOf(l2)));
        this.mSeekingTimeMs = l2;
        this.mIsInPreciseSeeking = isPreciseSeek;
        this.mDemuxer.seek(this.mSeekingTimeMs);
        this.mIsAbandoningDecodingFrame = true;
        this.mHasReadEOF = false;
        VideoDecodeController videoDecodeController = this.mVideoDecodeController;
        LiteavLog.i(videoDecodeController.a, "decoder abandonDecodingFrames");
        VideoDecodeController videoDecodeController2 = videoDecodeController;
        videoDecodeController2.a(ag.a(videoDecodeController2));
        PixelFrame.releasePixelFrames(this.mPixFrameCacheForReverse);
    }

    private void onDecodeFrameInternal(PixelFrame pixelFrame) {
        if (this.mVideoDecodeController == null) {
            pixelFrame.release();
            return;
        }
        long l2 = pixelFrame.getTimestamp();
        if (this.mIsAbandoningDecodingFrame || !this.mIsReverse && this.mIsInPreciseSeeking && l2 < this.mSeekingTimeMs && this.mSeekingTimeMs != -1L) {
            pixelFrame.release();
            return;
        }
        this.mSeekingTimeMs = -1L;
        pixelFrame = this.processFrame(pixelFrame);
        if (this.mIsReverse) {
            this.addFrameToQueueForReverse(pixelFrame);
            return;
        }
        this.addFrameToQueue(pixelFrame);
    }

    private PixelFrame processFrame(PixelFrame pixelFrame) {
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (com.tencent.liteav.videobase.egl.f f2) {
            pixelFrame.release();
            return null;
        }
        pixelFrame.setRotation(this.mVideoRotation);
        if (pixelFrame.getRotation() != Rotation.a && pixelFrame.getRotation() != Rotation.c) {
            pixelFrame.swapWidthHeight();
        }
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        if ((n2 != this.mVideoWidth || n3 != this.mVideoHeight) && this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.a();
            this.mPixelFrameRenderer = null;
        }
        if (this.mPixelFrameRenderer == null) {
            this.mPixelFrameRenderer = new j(n2, n3);
            this.mVideoWidth = n2;
            this.mVideoHeight = n3;
        }
        OpenGlUtils.glViewport(0, 0, n2, n3);
        d d2 = this.mGLTexturePool.a(n2, n3);
        this.mPixelFrameRenderer.a(pixelFrame, GLConstants.GLScaleType.a, d2);
        PixelFrame pixelFrame2 = d2.a(this.mEGLCore.getEglContext());
        pixelFrame2.setTimestamp(pixelFrame.getTimestamp());
        pixelFrame2.setGLContext(ax.a().b());
        GLES20.glFinish();
        d2.release();
        pixelFrame.release();
        return pixelFrame2;
    }

    private void initializeDecodeController() {
        if (this.mVideoDecodeController != null) {
            LiteavLog.w(TAG, "UGCVideoFileProvider is initialized");
            return;
        }
        LiteavLog.i(TAG, "initializeDecodeController");
        this.mVideoDecodeController = new VideoDecodeController(new f(), true);
        this.mVideoDecodeController.b();
        this.mVideoDecodeController.a(ax.a().b());
        this.mVideoDecodeController.a(VideoDecodeController.DecodeStrategy.c);
        this.mVideoDecodeController.a(VideoDecoderDef.ConsumerScene.a);
    }

    private void initializeGLComponents() {
        if (this.mEGLCore != null) {
            return;
        }
        LiteavLog.i(this.mThrottlers.a("initGL"), TAG, "initializeGLComponents", new Object[0]);
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(ax.a().b(), null, 128, 128);
            this.mEGLCore.makeCurrent();
        }
        catch (com.tencent.liteav.videobase.egl.f f2) {
            LiteavLog.e(this.mThrottlers.a("initGLError"), TAG, "initializeGLComponents failed.", f2);
            this.mEGLCore = null;
            return;
        }
        this.mGLTexturePool = new e();
    }

    private void unInitializeGLComponents() {
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.a();
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.a();
            this.mPixelFrameRenderer = null;
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private void addFrameToQueue(PixelFrame pixelFrame) {
        if (pixelFrame == null) {
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        if (pixelFrame.getTimestamp() < this.mClip.startInFileTime) {
            pixelFrame.release();
            return;
        }
        if (pixelFrame.getTimestamp() > this.mClip.endInFileTime || pixelFrame.getTimestamp() > this.mPlayEndPts) {
            LiteavLog.i(TAG, "addFrameToQueue Timestamp = " + pixelFrame.getTimestamp() + " endInnerFileTime = " + this.mClip.endInFileTime);
            this.mPixFrameQueue.queue(END_OF_STREAM);
            pixelFrame.release();
            return;
        }
        pixelFrame.setTimestamp(this.fileTimeToTimeline(pixelFrame.getTimestamp()));
        LinkedList<PixelFrame> linkedList = new LinkedList<PixelFrame>();
        linkedList.add(pixelFrame);
        this.mPixFrameQueue.queue(linkedList);
    }

    private void addFrameToQueueForReverse(PixelFrame pixelFrame) {
        if (pixelFrame != null && pixelFrame.getTimestamp() <= this.mReversePlayCurrentPts) {
            this.mPixFrameCacheForReverse.addLast(pixelFrame);
            return;
        }
        if (pixelFrame != null) {
            pixelFrame.release();
        }
        if (this.mPixFrameCacheForReverse.isEmpty()) {
            LiteavLog.i(TAG, "mGopVideoFrameList isEmpty so put END_OF_STREAM");
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        this.mFrameCacheCapacityForReverse = this.mPixFrameCacheForReverse.size();
        while (!this.mPixFrameCacheForReverse.isEmpty()) {
            PixelFrame pixelFrame2 = this.mPixFrameCacheForReverse.pollLast();
            this.mReversePlayCurrentPts = pixelFrame2.getTimestamp();
            if (this.mReversePlayCurrentPts > this.mClip.endInFileTime || this.mReversePlayCurrentPts < this.mClip.startInFileTime) {
                pixelFrame2.release();
                continue;
            }
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
            pixelFrame2.setTimestamp(uGCSingleFilePixelFrameProvider.fileTimeToTimelineForReverse(uGCSingleFilePixelFrameProvider.mReversePlayCurrentPts));
            LinkedList<PixelFrame> linkedList = new LinkedList<PixelFrame>();
            linkedList.add(pixelFrame2);
            this.mPixFrameQueue.queue(linkedList);
        }
        if (this.mReversePlayCurrentPts <= this.mClip.startInFileTime) {
            LiteavLog.i(TAG, "mLastGopFinishPts is smaller start time so put END_OF_STREAM");
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        --this.mReversePlayCurrentPts;
        UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
        uGCSingleFilePixelFrameProvider.seekToInFileTime(uGCSingleFilePixelFrameProvider.mReversePlayCurrentPts - 500L, false);
    }

    private long timelineToFileTime(long timeline) {
        if (this.mClip.speedList == null) {
            return timeline + this.mClip.startInFileTime;
        }
        long l2 = 0L;
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mClip.speedList) {
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            long l3 = (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
            l2 = (long)((float)timeline / f2) + tXSpeed.startTime;
            if (timeline < l3) break;
            timeline -= l3;
        }
        return l2;
    }

    private long fileTimeToTimeline(long fileTime) {
        long l2 = this.mClip.startInClipsTimeline;
        if (this.mClip.speedList == null) {
            return l2 + (fileTime - this.mClip.startInFileTime);
        }
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mClip.speedList) {
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            if (fileTime < tXSpeed.endTime) {
                l2 += (long)((float)(fileTime - tXSpeed.startTime) * f2);
                break;
            }
            l2 += (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
        }
        return l2;
    }

    private float getTimeMultipleInSpeed(int speedLevel) {
        return UGCMediaListSource.getSpeed(speedLevel);
    }

    private long fileTimeToTimelineForReverse(long fileTime) {
        if (this.mClip.speedList == null) {
            return this.mClip.endInFileTime - fileTime;
        }
        long l2 = this.mClip.startInClipsTimeline;
        for (int i2 = this.mClip.speedList.size() - 1; i2 >= 0; --i2) {
            TXVideoEditConstants.TXSpeed tXSpeed = this.mClip.speedList.get(i2);
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            if (fileTime > tXSpeed.startTime) {
                l2 += (long)((float)(tXSpeed.endTime - fileTime) * f2);
                break;
            }
            l2 += (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
        }
        return l2;
    }

    private void onDecodeCompletedInternal() {
        LiteavLog.i(TAG, "onDecodeCompletedInteral");
        if (this.mVideoDecodeController == null || this.mIsAbandoningDecodingFrame || this.mIsDecodeCompleted || !this.mHasReadEOF) {
            return;
        }
        if (this.mIsReverse) {
            this.addFrameToQueueForReverse(null);
        } else {
            this.addFrameToQueue(null);
        }
        this.mIsDecodeCompleted = true;
    }

    private void clearPixelFrameQueue() {
        Iterator<List<PixelFrame>> iterator = this.mPixFrameQueue.dequeueAll().iterator();
        while (iterator.hasNext()) {
            PixelFrame.releasePixelFrames(iterator.next());
        }
    }

    static /* synthetic */ void lambda$onFrameDequeued$2(UGCSingleFilePixelFrameProvider this_) {
        if (!this_.mIsFrameSendingDecoder) {
            this_.decodeInternal();
        }
    }

    static /* synthetic */ void lambda$setReverse$1(UGCSingleFilePixelFrameProvider this_, boolean isReverse) {
        this_.setReverseInternal(isReverse);
    }

    static /* synthetic */ void lambda$seekTo$0(UGCSingleFilePixelFrameProvider this_, long lineTime, boolean isPreciseSeek) {
        long l2;
        if (this_.mVideoDecodeController == null || this_.mDemuxer == null) {
            return;
        }
        this_.clearPixelFrameQueue();
        this_.mReversePlayCurrentPts = l2 = this_.timelineToFileTime(lineTime);
        this_.seekToInFileTime(l2, isPreciseSeek);
    }

    static /* synthetic */ VideoDecodeController access$100(UGCSingleFilePixelFrameProvider x0) {
        return x0.mVideoDecodeController;
    }

    static /* synthetic */ UGCFrameQueue access$200(UGCSingleFilePixelFrameProvider x0) {
        return x0.mPixFrameQueue;
    }

    static /* synthetic */ boolean access$302(UGCSingleFilePixelFrameProvider x0, boolean x1) {
        x0.mIsAbandoningDecodingFrame = x1;
        return x0.mIsAbandoningDecodingFrame;
    }

    static /* synthetic */ void access$400(UGCSingleFilePixelFrameProvider x0) {
        x0.decodeInternal();
    }

    static /* synthetic */ void access$500(UGCSingleFilePixelFrameProvider x0) {
        x0.onDecodeCompletedInternal();
    }

    static /* synthetic */ void access$600(UGCSingleFilePixelFrameProvider x0, PixelFrame x1) {
        x0.onDecodeFrameInternal(x1);
    }

    static /* synthetic */ void access$lambda$0(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.uninitializeInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.startInternal();
    }

    static /* synthetic */ void access$lambda$2(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.stopInternal();
    }

    static /* synthetic */ void access$lambda$3(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.onDecodeCompletedInternal();
    }

    static /* synthetic */ void access$lambda$4(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.onDecodeCompletedInternal();
    }
}

